/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-06-13 09:37:49 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_db7_forms` (
  `form_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_post_id` bigint(20) NOT NULL,
  `form_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `form_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL,
  `date_modified` datetime DEFAULT NULL,
  `currency` varchar(5) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_customer` (
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_1` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `address_2` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `city` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `state` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `postcode` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `country` varchar(5) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `fk_order_customer_order_idx` (`order_id`),
  CONSTRAINT `fk_order_customer_order` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int(10) unsigned NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `product_id` int(20) DEFAULT NULL,
  `tax_class` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_total` int(11) DEFAULT NULL,
  `subtotal` int(11) DEFAULT NULL,
  `total` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_order_item_order1_idx` (`order_id`),
  CONSTRAINT `fk_order_item_order1` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_order_transaction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date_created` datetime DEFAULT NULL,
  `date_modified` datetime DEFAULT NULL,
  `amount` int(11) DEFAULT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_nice_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_transaction_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `processor_status` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_transaction_order1_idx` (`order_id`),
  CONSTRAINT `fk_transaction_order1` FOREIGN KEY (`order_id`) REFERENCES `wp_dlm_order` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dlm_session` (
  `key` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(190) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expiry` datetime NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_download_log` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `user_ip` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `download_id` bigint(20) NOT NULL,
  `version_id` bigint(20) NOT NULL,
  `version` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `download_date` datetime DEFAULT NULL,
  `download_status` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `download_status_message` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_data` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ID`),
  KEY `attribute_name` (`download_id`)
) ENGINE=MyISAM AUTO_INCREMENT=17772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_edd_customermeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `customer_id` (`customer_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_edd_customers` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `email` varchar(50) NOT NULL,
  `name` mediumtext NOT NULL,
  `purchase_value` mediumtext NOT NULL,
  `purchase_count` bigint(20) NOT NULL,
  `payment_ids` longtext NOT NULL,
  `notes` longtext NOT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `user` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_em_bookings` (
  `booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned DEFAULT NULL,
  `person_id` bigint(20) unsigned NOT NULL,
  `booking_spaces` int(5) NOT NULL,
  `booking_comment` mediumtext COLLATE utf8mb4_unicode_ci,
  `booking_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `booking_status` tinyint(1) NOT NULL DEFAULT '1',
  `booking_price` decimal(14,4) unsigned NOT NULL DEFAULT '0.0000',
  `booking_tax_rate` decimal(7,4) DEFAULT NULL,
  `booking_taxes` decimal(14,4) DEFAULT NULL,
  `booking_meta` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`booking_id`),
  KEY `event_id` (`event_id`),
  KEY `person_id` (`person_id`),
  KEY `booking_status` (`booking_status`)
) ENGINE=MyISAM AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_bookings_relationships` (
  `booking_relationship_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned DEFAULT NULL,
  `booking_id` bigint(20) unsigned DEFAULT NULL,
  `booking_main_id` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`booking_relationship_id`),
  KEY `event_id` (`event_id`),
  KEY `booking_id` (`booking_id`),
  KEY `booking_main_id` (`booking_main_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_coupons` (
  `coupon_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_owner` bigint(20) unsigned NOT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `coupon_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `coupon_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `coupon_max` int(10) DEFAULT NULL,
  `coupon_start` datetime DEFAULT NULL,
  `coupon_end` datetime DEFAULT NULL,
  `coupon_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_tax` varchar(4) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_discount` decimal(14,2) NOT NULL,
  `coupon_eventwide` tinyint(1) NOT NULL DEFAULT '0',
  `coupon_sitewide` tinyint(1) NOT NULL DEFAULT '0',
  `coupon_private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`coupon_id`),
  KEY `coupon_owner` (`coupon_owner`),
  KEY `coupon_code` (`coupon_code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_email_queue` (
  `queue_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned DEFAULT NULL,
  `booking_id` bigint(20) unsigned DEFAULT NULL,
  `email` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attachment` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`queue_id`),
  KEY `event_id` (`event_id`),
  KEY `booking_id` (`booking_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `event_slug` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_owner` bigint(20) unsigned DEFAULT NULL,
  `event_status` int(1) DEFAULT NULL,
  `event_name` mediumtext COLLATE utf8mb4_unicode_ci,
  `event_start_time` time DEFAULT NULL,
  `event_end_time` time DEFAULT NULL,
  `event_all_day` int(1) DEFAULT NULL,
  `event_start_date` date DEFAULT NULL,
  `event_end_date` date DEFAULT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci,
  `event_rsvp` tinyint(1) NOT NULL DEFAULT '0',
  `event_rsvp_date` date DEFAULT NULL,
  `event_rsvp_time` time DEFAULT NULL,
  `event_rsvp_spaces` int(5) DEFAULT NULL,
  `event_spaces` int(5) DEFAULT '0',
  `event_private` tinyint(1) NOT NULL DEFAULT '0',
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `recurrence_id` bigint(20) unsigned DEFAULT NULL,
  `event_category_id` bigint(20) unsigned DEFAULT NULL,
  `event_attributes` mediumtext COLLATE utf8mb4_unicode_ci,
  `event_date_created` datetime DEFAULT NULL,
  `event_date_modified` datetime DEFAULT NULL,
  `recurrence` tinyint(1) DEFAULT '0',
  `recurrence_interval` int(4) DEFAULT NULL,
  `recurrence_freq` text COLLATE utf8mb4_unicode_ci,
  `recurrence_byday` text COLLATE utf8mb4_unicode_ci,
  `recurrence_byweekno` int(4) DEFAULT NULL,
  `recurrence_days` int(4) DEFAULT NULL,
  `recurrence_rsvp_days` int(3) DEFAULT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `group_id` bigint(20) unsigned DEFAULT NULL,
  `event_start` datetime DEFAULT NULL,
  `event_end` datetime DEFAULT NULL,
  `event_timezone` tinytext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`event_id`),
  KEY `event_status` (`event_status`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `group_id` (`group_id`),
  KEY `location_id` (`location_id`),
  KEY `event_start` (`event_start`),
  KEY `event_end` (`event_end`),
  KEY `event_start_date` (`event_start_date`),
  KEY `event_end_date` (`event_end_date`)
) ENGINE=MyISAM AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `blog_id` bigint(20) unsigned DEFAULT NULL,
  `location_slug` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_name` mediumtext COLLATE utf8mb4_unicode_ci,
  `location_owner` bigint(20) unsigned NOT NULL DEFAULT '0',
  `location_address` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_town` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_state` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_postcode` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_region` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_country` char(2) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_latitude` float(10,6) DEFAULT NULL,
  `location_longitude` float(10,6) DEFAULT NULL,
  `post_content` longtext COLLATE utf8mb4_unicode_ci,
  `location_status` int(1) DEFAULT NULL,
  `location_private` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`),
  KEY `location_country` (`location_country`),
  KEY `post_id` (`post_id`),
  KEY `blog_id` (`blog_id`),
  KEY `location_state` (`location_state`(191)),
  KEY `location_region` (`location_region`(191))
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `object_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  `meta_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `object_id` (`object_id`),
  KEY `meta_key` (`meta_key`(250))
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_modal_metas` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `modal_id` mediumint(9) unsigned NOT NULL,
  `display` longtext COLLATE utf8mb4_unicode_520_ci,
  `close` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_em_modals` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `theme_id` mediumint(9) unsigned NOT NULL DEFAULT '1',
  `name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_sitewide` tinyint(1) NOT NULL DEFAULT '0',
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `is_trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_em_theme_metas` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `theme_id` mediumint(9) unsigned NOT NULL,
  `overlay` longtext COLLATE utf8mb4_unicode_520_ci,
  `container` longtext COLLATE utf8mb4_unicode_520_ci,
  `close` longtext COLLATE utf8mb4_unicode_520_ci,
  `title` longtext COLLATE utf8mb4_unicode_520_ci,
  `content` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_em_themes` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_system` tinyint(1) NOT NULL DEFAULT '0',
  `is_trash` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_em_tickets` (
  `ticket_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `ticket_name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `ticket_description` mediumtext COLLATE utf8mb4_unicode_ci,
  `ticket_price` decimal(14,4) DEFAULT NULL,
  `ticket_start` datetime DEFAULT NULL,
  `ticket_end` datetime DEFAULT NULL,
  `ticket_min` int(10) DEFAULT NULL,
  `ticket_max` int(10) DEFAULT NULL,
  `ticket_spaces` int(11) DEFAULT NULL,
  `ticket_members` int(1) DEFAULT NULL,
  `ticket_members_roles` longtext COLLATE utf8mb4_unicode_ci,
  `ticket_guests` int(1) DEFAULT NULL,
  `ticket_required` int(1) DEFAULT NULL,
  `ticket_meta` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`ticket_id`),
  KEY `event_id` (`event_id`)
) ENGINE=MyISAM AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_tickets_bookings` (
  `ticket_booking_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint(20) unsigned NOT NULL,
  `ticket_id` bigint(20) unsigned NOT NULL,
  `ticket_booking_spaces` int(6) NOT NULL,
  `ticket_booking_price` decimal(14,4) NOT NULL,
  PRIMARY KEY (`ticket_booking_id`),
  KEY `booking_id` (`booking_id`),
  KEY `ticket_id` (`ticket_id`)
) ENGINE=MyISAM AUTO_INCREMENT=190 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_em_transactions` (
  `transaction_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `booking_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `transaction_gateway_id` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_payment_type` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_timestamp` datetime NOT NULL,
  `transaction_total_amount` decimal(14,2) DEFAULT NULL,
  `transaction_currency` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_status` varchar(35) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_duedate` date DEFAULT NULL,
  `transaction_gateway` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `transaction_note` mediumtext COLLATE utf8mb4_unicode_ci,
  `transaction_expires` datetime DEFAULT NULL,
  PRIMARY KEY (`transaction_id`),
  KEY `transaction_gateway` (`transaction_gateway`),
  KEY `booking_id` (`booking_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_es_deliverreport` (
  `es_deliver_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_deliver_sentguid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_emailid` int(10) unsigned NOT NULL,
  `es_deliver_emailmail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_sentdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_deliver_viewdate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_deliver_sentstatus` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Sent',
  `es_deliver_senttype` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Immediately',
  PRIMARY KEY (`es_deliver_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_emaillist` (
  `es_email_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_email_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_mail` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Unconfirmed',
  `es_email_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_email_viewcount` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_email_group` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Public',
  `es_email_guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`es_email_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_notification` (
  `es_note_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_note_cat` text COLLATE utf8mb4_unicode_520_ci,
  `es_note_group` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_note_templ` int(10) unsigned NOT NULL,
  `es_note_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Enable',
  PRIMARY KEY (`es_note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_es_sentdetails` (
  `es_sent_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `es_sent_guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_qstring` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_source` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `es_sent_starttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_endtime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `es_sent_count` int(10) unsigned NOT NULL,
  `es_sent_preview` text COLLATE utf8mb4_unicode_520_ci,
  `es_sent_status` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Sent',
  `es_sent_type` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Immediately',
  `es_sent_subject` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`es_sent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_event_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pub_user` bigint(20) NOT NULL,
  `pub_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `start_date` date NOT NULL DEFAULT '0000-00-00',
  `end_date` date DEFAULT NULL,
  `time` text,
  `title` text NOT NULL,
  `location` text,
  `details` text,
  `categories` text,
  `history` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_g_circles` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `center_lat` varchar(255) NOT NULL,
  `center_lng` varchar(255) NOT NULL,
  `radius` varchar(255) NOT NULL,
  `line_width` varchar(5) NOT NULL,
  `line_opacity` varchar(5) NOT NULL,
  `line_color` varchar(7) NOT NULL,
  `fill_color` varchar(7) NOT NULL,
  `fill_opacity` varchar(7) NOT NULL,
  `hover_line_opacity` varchar(5) NOT NULL,
  `hover_line_color` varchar(7) NOT NULL,
  `hover_fill_color` varchar(7) NOT NULL,
  `hover_fill_opacity` varchar(7) NOT NULL,
  `show_marker` int(7) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_g_maps` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `type` varchar(50) NOT NULL,
  `zoom` int(5) NOT NULL,
  `min_zoom` varchar(55) NOT NULL DEFAULT '0',
  `max_zoom` varchar(55) NOT NULL DEFAULT '22',
  `border_radius` int(5) NOT NULL,
  `center_lat` varchar(255) NOT NULL DEFAULT '0',
  `pan_controller` varchar(5) NOT NULL DEFAULT 'true',
  `zoom_controller` varchar(5) NOT NULL DEFAULT 'true',
  `type_controller` varchar(5) NOT NULL DEFAULT 'true',
  `scale_controller` varchar(5) NOT NULL DEFAULT 'true',
  `street_view_controller` varchar(5) NOT NULL DEFAULT 'true',
  `overview_map_controller` varchar(5) NOT NULL DEFAULT 'true',
  `center_lng` varchar(255) NOT NULL DEFAULT '0',
  `width` varchar(5) NOT NULL DEFAULT '100',
  `height` varchar(5) NOT NULL DEFAULT '450',
  `align` varchar(11) NOT NULL DEFAULT 'left',
  `info_type` varchar(9) NOT NULL DEFAULT 'click',
  `traffic_layer` varchar(55) NOT NULL DEFAULT 'false',
  `bike_layer` varchar(55) NOT NULL DEFAULT 'false',
  `transit_layer` varchar(55) NOT NULL DEFAULT 'false',
  `styling_hue` text NOT NULL,
  `styling_lightness` varchar(55) NOT NULL DEFAULT '0',
  `styling_gamma` varchar(55) NOT NULL DEFAULT '1',
  `styling_saturation` varchar(55) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_g_markers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map` int(11) NOT NULL,
  `title` varchar(50) NOT NULL,
  `lat` varchar(255) NOT NULL DEFAULT '0',
  `lng` varchar(255) NOT NULL DEFAULT '0',
  `animation` varchar(255) NOT NULL DEFAULT 'NONE',
  `description` text NOT NULL,
  `img` varchar(255) NOT NULL,
  `size` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_g_polygones` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `data` text NOT NULL,
  `line_opacity` varchar(5) NOT NULL,
  `line_color` varchar(9) NOT NULL,
  `fill_opacity` varchar(5) NOT NULL,
  `fill_color` varchar(9) NOT NULL,
  `url` text NOT NULL,
  `hover_line_opacity` varchar(5) NOT NULL,
  `hover_line_color` varchar(9) NOT NULL,
  `hover_fill_opacity` varchar(5) NOT NULL,
  `hover_fill_color` varchar(9) NOT NULL,
  `line_width` varchar(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_g_polylines` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map` int(11) NOT NULL,
  `name` varchar(50) NOT NULL,
  `data` text NOT NULL,
  `line_opacity` varchar(5) NOT NULL,
  `line_color` varchar(7) NOT NULL,
  `line_width` varchar(5) NOT NULL,
  `hover_line_color` varchar(9) NOT NULL,
  `hover_line_opacity` varchar(9) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_hugeit_maps_circles` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map_id` int(11) DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `center_lat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `center_lng` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `radius` int(50) NOT NULL DEFAULT '50000',
  `line_width` int(3) NOT NULL DEFAULT '5',
  `line_opacity` float NOT NULL DEFAULT '0.8',
  `line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'FF2B39',
  `fill_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '4FFF72',
  `fill_opacity` float NOT NULL DEFAULT '0.4',
  `hover_line_opacity` float NOT NULL DEFAULT '0.6',
  `hover_line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'FF5C5C',
  `hover_fill_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '96FFA1',
  `hover_fill_opacity` float NOT NULL DEFAULT '0.3',
  `show_marker` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hugeit_maps_directions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map_id` int(11) DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `start_lat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_lng` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_lat` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_lng` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'FF0F0F',
  `line_width` int(2) NOT NULL DEFAULT '5',
  `line_opacity` float NOT NULL DEFAULT '0.9',
  `show_steps` int(1) NOT NULL DEFAULT '0',
  `travel_mode` enum('DRIVING','WALKING','BICYCLING','TRANSIT') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'DRIVING',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hugeit_maps_maps` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` text COLLATE utf8mb4_unicode_ci,
  `type` enum('ROADMAP','SATELLITE','HYBRID','TERRAIN') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ROADMAP',
  `zoom` int(2) NOT NULL DEFAULT '2',
  `border_radius` int(2) NOT NULL DEFAULT '0',
  `center_lat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `center_lng` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `pan_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `zoom_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `type_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `scale_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `street_view_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `overview_map_controller` int(1) unsigned NOT NULL DEFAULT '1',
  `width` int(3) NOT NULL DEFAULT '100',
  `height` int(3) NOT NULL DEFAULT '450',
  `align` enum('left','right','center') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'left',
  `wheel_scroll` int(1) unsigned NOT NULL DEFAULT '1',
  `draggable` int(1) unsigned NOT NULL DEFAULT '1',
  `language` text COLLATE utf8mb4_unicode_ci,
  `min_zoom` int(2) NOT NULL DEFAULT '0',
  `max_zoom` int(2) NOT NULL DEFAULT '22',
  `info_type` enum('click','hover') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'click',
  `open_infowindows_onload` int(1) unsigned NOT NULL DEFAULT '0',
  `traffic_layer` int(1) unsigned NOT NULL DEFAULT '0',
  `bike_layer` int(1) unsigned NOT NULL DEFAULT '0',
  `transit_layer` int(1) unsigned NOT NULL DEFAULT '0',
  `styling_hue` varchar(7) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `styling_lightness` int(3) NOT NULL DEFAULT '0',
  `styling_gamma` int(2) unsigned NOT NULL DEFAULT '1',
  `styling_saturation` int(3) NOT NULL DEFAULT '0',
  `animation` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hugeit_maps_markers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map_id` int(11) unsigned DEFAULT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `lat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `lng` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `animation` enum('BOUNCE','DROP','NONE') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'NONE',
  `description` text COLLATE utf8mb4_unicode_ci,
  `img` text COLLATE utf8mb4_unicode_ci,
  `size` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hugeit_maps_polygons` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map_id` int(11) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `data` longtext COLLATE utf8mb4_unicode_ci,
  `line_opacity` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.9',
  `line_color` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'FF0F0F',
  `fill_opacity` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.5',
  `fill_color` varchar(6) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5DFF0D',
  `url` text COLLATE utf8mb4_unicode_ci,
  `hover_line_opacity` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.5',
  `hover_line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'FF80B7',
  `hover_fill_opacity` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.5',
  `hover_fill_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '75FF7E',
  `line_width` int(2) NOT NULL DEFAULT '5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hugeit_maps_polylines` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `map_id` int(11) unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci,
  `data` text COLLATE utf8mb4_unicode_ci,
  `line_opacity` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.9',
  `line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '18A326',
  `line_width` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '5',
  `hover_line_color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '11A000',
  `hover_line_opacity` float NOT NULL DEFAULT '0.5',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_hustle_modules` (
  `module_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `blog_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `module_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `module_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `active` tinyint(4) DEFAULT '1',
  `test_mode` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`module_id`),
  KEY `blog_id` (`blog_id`),
  KEY `active` (`active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_hustle_modules_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `module_id` (`module_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_kpt_panes` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `table_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `top_head_background` text CHARACTER SET utf8,
  `top_head_color` text CHARACTER SET utf8,
  `top_head_font_size` int(11) DEFAULT NULL,
  `top_head_letter_spacing` int(11) DEFAULT NULL,
  `top_head_line_height` text CHARACTER SET utf8,
  `top_head_font` text CHARACTER SET utf8,
  `top_head_height` int(11) DEFAULT NULL,
  `top_head_padding` int(11) DEFAULT NULL,
  `top_head_html` text CHARACTER SET utf8,
  `top_head_icon` text CHARACTER SET utf8,
  `top_head_image` text CHARACTER SET utf8,
  `price_background` text CHARACTER SET utf8,
  `price_color` text CHARACTER SET utf8,
  `price_font_size` int(11) DEFAULT NULL,
  `price_letter_spacing` int(11) DEFAULT NULL,
  `price_line_height` text CHARACTER SET utf8,
  `price_font` text CHARACTER SET utf8,
  `price_sub_color` text CHARACTER SET utf8,
  `price_sub_font_size` int(11) DEFAULT NULL,
  `price_sub_letter_spacing` int(11) DEFAULT NULL,
  `price_sub_line_height` text CHARACTER SET utf8,
  `price_sub_font` text CHARACTER SET utf8,
  `price_padding` int(11) DEFAULT NULL,
  `price_height` int(11) DEFAULT NULL,
  `price_html` text CHARACTER SET utf8,
  `price_sub_html` text CHARACTER SET utf8,
  `description_background` text CHARACTER SET utf8,
  `description_color` text CHARACTER SET utf8,
  `description_font_size` int(11) DEFAULT NULL,
  `description_letter_spacing` int(11) DEFAULT NULL,
  `description_line_height` text CHARACTER SET utf8,
  `description_font` text CHARACTER SET utf8,
  `description_padding` int(11) DEFAULT NULL,
  `description_height` int(11) DEFAULT NULL,
  `description_html` text CHARACTER SET utf8,
  `footer_background` text CHARACTER SET utf8,
  `footer_color` text CHARACTER SET utf8,
  `footer_color_hover` text CHARACTER SET utf8,
  `footer_font_size` int(11) DEFAULT NULL,
  `footer_letter_spacing` int(11) DEFAULT NULL,
  `footer_line_height` text CHARACTER SET utf8,
  `footer_btn_background` text CHARACTER SET utf8,
  `footer_btn_background_hover` text CHARACTER SET utf8,
  `footer_btn_border_color` text CHARACTER SET utf8,
  `footer_btn_border_color_hover` text CHARACTER SET utf8,
  `footer_btn_border_width` int(11) DEFAULT NULL,
  `footer_btn_border_radius` int(11) DEFAULT NULL,
  `footer_btn_padding` int(11) DEFAULT NULL,
  `footer_font` text CHARACTER SET utf8,
  `footer_height` int(11) DEFAULT NULL,
  `footer_link` text CHARACTER SET utf8,
  `footer_link_new_tab` int(11) DEFAULT '0',
  `footer_html` text CHARACTER SET utf8,
  `featured_background` text CHARACTER SET utf8,
  `featured_color` text CHARACTER SET utf8,
  `featured` text CHARACTER SET utf8,
  `featured_text` text CHARACTER SET utf8,
  `featured_font_size` int(11) DEFAULT NULL,
  `featured_letter_spacing` int(11) DEFAULT NULL,
  `featured_font` text CHARACTER SET utf8,
  `featured_line_height` text CHARACTER SET utf8,
  `featured_border_color` text CHARACTER SET utf8,
  `featured_border_width` int(11) DEFAULT NULL,
  `featured_border_radius` int(11) DEFAULT NULL,
  `featured_size` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=160 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_kpt_tablerows` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `table_parent` mediumint(9) DEFAULT NULL,
  `pane_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `inner_html` text CHARACTER SET utf8,
  `icon` text CHARACTER SET utf8,
  `image` text CHARACTER SET utf8,
  `height` int(11) DEFAULT NULL,
  `padding` int(11) DEFAULT NULL,
  `color` text CHARACTER SET utf8,
  `background` text CHARACTER SET utf8,
  `letter_spacing` int(11) DEFAULT NULL,
  `font_size` int(11) DEFAULT NULL,
  `line_height` text CHARACTER SET utf8,
  `font` text CHARACTER SET utf8,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=165 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_kpt_tables` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8,
  `template` text CHARACTER SET utf8,
  `animation` text CHARACTER SET utf8,
  `hover_effect` text CHARACTER SET utf8,
  `text_align` text CHARACTER SET utf8,
  `enable_top_head_row` int(11) DEFAULT NULL,
  `enable_price_row` int(11) DEFAULT NULL,
  `enable_description_row` int(11) DEFAULT NULL,
  `enable_footer_row` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ksp_layers` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `slider_parent` mediumint(9) DEFAULT NULL,
  `slide_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `type` text CHARACTER SET utf8,
  `inner_html` text CHARACTER SET utf8,
  `image_src` text CHARACTER SET utf8,
  `image_alt` text CHARACTER SET utf8,
  `align_horizontal` text CHARACTER SET utf8,
  `align_veritcal` text CHARACTER SET utf8,
  `data_y` int(11) DEFAULT NULL,
  `data_x` int(11) DEFAULT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `font_color` text CHARACTER SET utf8,
  `font_hover_color` text CHARACTER SET utf8,
  `background_color` text CHARACTER SET utf8,
  `background_hover_color` text CHARACTER SET utf8,
  `border_color` text CHARACTER SET utf8,
  `border_hover_color` text CHARACTER SET utf8,
  `border_width` int(11) DEFAULT NULL,
  `border_radius` int(11) DEFAULT NULL,
  `letter_spacing` int(11) DEFAULT NULL,
  `padding` int(11) DEFAULT NULL,
  `font_size` int(11) DEFAULT NULL,
  `line_height` text CHARACTER SET utf8,
  `font` text CHARACTER SET utf8,
  `data_delay` int(11) DEFAULT NULL,
  `data_time` text CHARACTER SET utf8,
  `data_in` text CHARACTER SET utf8,
  `data_out` text CHARACTER SET utf8,
  `data_ease` int(11) DEFAULT NULL,
  `link` text CHARACTER SET utf8,
  `link_new_tab` int(11) DEFAULT '0',
  `z_index` int(11) DEFAULT NULL,
  `text_shadow` text CHARACTER SET utf8,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=364 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ksp_sliders` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` text CHARACTER SET utf8,
  `responsive` int(11) DEFAULT NULL,
  `maxHeight` int(11) DEFAULT NULL,
  `maxWidth` int(11) DEFAULT NULL,
  `fullHeight` int(11) DEFAULT NULL,
  `full_offset` text CHARACTER SET utf8,
  `fullWidth` int(11) DEFAULT NULL,
  `autoPlay` int(11) DEFAULT NULL,
  `pauseTime` int(11) DEFAULT NULL,
  `enableParallax` int(11) DEFAULT NULL,
  `singleSlide` int(11) DEFAULT NULL,
  `minHeight` int(11) DEFAULT NULL,
  `pauseonHover` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_ksp_slides` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `slider_parent` mediumint(9) DEFAULT NULL,
  `position` int(11) DEFAULT NULL,
  `background_type_image` text CHARACTER SET utf8,
  `background_type_color` text CHARACTER SET utf8,
  `background_propriety_position` text CHARACTER SET utf8,
  `background_repeat` text CHARACTER SET utf8,
  `background_propriety_size` text CHARACTER SET utf8,
  `background_type_video` text CHARACTER SET utf8,
  `background_type_video_youtube` text CHARACTER SET utf8,
  `background_type_video_mute` int(11) DEFAULT NULL,
  `background_type_video_loop` int(11) DEFAULT NULL,
  `background_type_video_playpause` int(11) DEFAULT NULL,
  `background_type_video_ratio` text CHARACTER SET utf8,
  `background_type_video_start` int(11) DEFAULT NULL,
  `background_type_video_mp4` text CHARACTER SET utf8,
  `background_type_video_webm` text CHARACTER SET utf8,
  `background_link` text CHARACTER SET utf8,
  `background_link_new_tab` int(11) DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=222 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_lgp_crons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id_from` bigint(20) NOT NULL DEFAULT '0',
  `type_from` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_id_to` bigint(20) NOT NULL DEFAULT '0',
  `type_to` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `links` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_work` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_lgp_linking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL DEFAULT '0',
  `linking_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cat_id` (`cat_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_lgp_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL DEFAULT '0',
  `log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `show` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_lgp_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL DEFAULT '0',
  `update_time` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT '0',
  `count` int(10) NOT NULL DEFAULT '0',
  `lockout` int(10) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=334535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=93679 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_title` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_excerpt` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `to_ping` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `pinged` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `post_name` (`post_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=61736 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_pum_subscribers` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `email_hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `popup_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `fname` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `lname` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `values` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consent_args` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `email` (`email`),
  KEY `user_id` (`user_id`),
  KEY `popup_id` (`popup_id`),
  KEY `email_hash` (`email_hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE `wp_spidercalendar_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `gid` varchar(255) NOT NULL,
  `def_zone` varchar(255) NOT NULL,
  `time_format` tinyint(1) NOT NULL,
  `allow_publish` varchar(255) NOT NULL,
  `def_year` varchar(512) NOT NULL,
  `def_month` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_spidercalendar_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `calendar` int(11) NOT NULL,
  `date` date NOT NULL,
  `date_end` date NOT NULL,
  `title` text NOT NULL,
  `category` int(11) DEFAULT NULL,
  `time` varchar(20) NOT NULL,
  `text_for_date` longtext NOT NULL,
  `userID` varchar(255) NOT NULL,
  `repeat_method` varchar(255) NOT NULL,
  `repeat` varchar(255) NOT NULL,
  `week` varchar(255) NOT NULL,
  `month` varchar(255) NOT NULL,
  `month_type` varchar(255) NOT NULL,
  `monthly_list` varchar(255) NOT NULL,
  `month_week` varchar(255) NOT NULL,
  `year_month` varchar(255) NOT NULL,
  `published` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_spidercalendar_event_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `color` varchar(255) NOT NULL,
  `description` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_spidercalendar_theme` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `width` varchar(255) NOT NULL,
  `cell_height` varchar(255) NOT NULL,
  `bg_top` varchar(255) NOT NULL,
  `bg_bottom` varchar(255) NOT NULL,
  `border_color` varchar(255) NOT NULL,
  `text_color_year` varchar(255) NOT NULL,
  `text_color_month` varchar(255) NOT NULL,
  `text_color_week_days` varchar(255) NOT NULL,
  `text_color_other_months` varchar(255) NOT NULL,
  `text_color_this_month_unevented` varchar(255) NOT NULL,
  `text_color_this_month_evented` varchar(255) NOT NULL,
  `event_title_color` varchar(255) NOT NULL,
  `current_day_border_color` varchar(255) NOT NULL,
  `bg_color_this_month_evented` varchar(255) NOT NULL,
  `next_prev_event_arrowcolor` varchar(255) NOT NULL,
  `show_event_bgcolor` varchar(255) NOT NULL,
  `cell_border_color` varchar(255) NOT NULL,
  `arrow_color_year` varchar(255) NOT NULL,
  `week_days_cell_height` varchar(255) NOT NULL,
  `arrow_color_month` varchar(255) NOT NULL,
  `text_color_sun_days` varchar(255) NOT NULL,
  `title_color` varchar(255) NOT NULL,
  `next_prev_event_bgcolor` varchar(255) NOT NULL,
  `title_font_size` varchar(255) NOT NULL,
  `title_font` varchar(255) NOT NULL,
  `title_style` varchar(255) NOT NULL,
  `date_color` varchar(255) NOT NULL,
  `date_size` varchar(255) NOT NULL,
  `date_font` varchar(255) NOT NULL,
  `date_style` varchar(255) NOT NULL,
  `popup_width` varchar(255) NOT NULL,
  `popup_height` varchar(255) NOT NULL,
  `number_of_shown_evetns` varchar(255) NOT NULL,
  `sundays_font_size` varchar(255) NOT NULL,
  `other_days_font_size` varchar(255) NOT NULL,
  `weekdays_font_size` varchar(255) NOT NULL,
  `border_width` varchar(255) NOT NULL,
  `top_height` varchar(255) NOT NULL,
  `bg_color_other_months` varchar(255) NOT NULL,
  `sundays_bg_color` varchar(255) NOT NULL,
  `weekdays_bg_color` varchar(255) NOT NULL,
  `week_start_day` varchar(255) NOT NULL,
  `weekday_sunday_bg_color` varchar(255) NOT NULL,
  `border_radius` varchar(255) NOT NULL,
  `year_font_size` varchar(255) NOT NULL,
  `month_font_size` varchar(255) NOT NULL,
  `arrow_size` varchar(255) NOT NULL,
  `next_month_text_color` varchar(255) NOT NULL,
  `prev_month_text_color` varchar(255) NOT NULL,
  `next_month_arrow_color` varchar(255) NOT NULL,
  `prev_month_arrow_color` varchar(255) NOT NULL,
  `next_month_font_size` varchar(255) NOT NULL,
  `prev_month_font_size` varchar(255) NOT NULL,
  `month_type` varchar(255) NOT NULL,
  `date_format` varchar(255) NOT NULL,
  `show_time` int(11) NOT NULL,
  `show_cat` int(11) NOT NULL,
  `show_repeat` int(11) NOT NULL,
  `date_bg_color` varchar(255) NOT NULL,
  `event_bg_color1` varchar(255) NOT NULL,
  `event_bg_color2` varchar(255) NOT NULL,
  `event_num_bg_color1` varchar(255) NOT NULL,
  `event_num_bg_color2` varchar(255) NOT NULL,
  `event_num_color` varchar(255) NOT NULL,
  `date_font_size` varchar(255) NOT NULL,
  `event_num_font_size` varchar(255) NOT NULL,
  `event_table_height` varchar(255) NOT NULL,
  `date_height` varchar(255) NOT NULL,
  `ev_title_bg_color` varchar(255) NOT NULL,
  `week_font_size` varchar(255) NOT NULL,
  `day_month_font_size` varchar(255) NOT NULL,
  `week_font_color` varchar(255) NOT NULL,
  `day_month_font_color` varchar(255) NOT NULL,
  `views_tabs_bg_color` varchar(255) NOT NULL,
  `views_tabs_text_color` varchar(255) NOT NULL,
  `views_tabs_font_size` varchar(255) NOT NULL,
  `day_start` int(11) NOT NULL,
  `header_format` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_spidercalendar_widget_theme` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `ev_title_color` varchar(255) DEFAULT NULL,
  `width` varchar(255) NOT NULL,
  `week_start_day` varchar(255) NOT NULL,
  `show_cat` int(11) NOT NULL,
  `font_year` varchar(255) NOT NULL,
  `font_month` varchar(255) NOT NULL,
  `font_day` varchar(255) NOT NULL,
  `font_weekday` varchar(255) NOT NULL,
  `header_bgcolor` varchar(255) NOT NULL,
  `footer_bgcolor` varchar(255) NOT NULL,
  `text_color_month` varchar(255) NOT NULL,
  `text_color_week_days` varchar(255) NOT NULL,
  `text_color_other_months` varchar(255) NOT NULL,
  `text_color_this_month_unevented` varchar(255) NOT NULL,
  `text_color_this_month_evented` varchar(255) NOT NULL,
  `bg_color_this_month_evented` varchar(255) NOT NULL,
  `bg_color_selected` varchar(255) NOT NULL,
  `arrow_color` varchar(255) NOT NULL,
  `text_color_selected` varchar(255) NOT NULL,
  `border_day` varchar(255) NOT NULL,
  `text_color_sun_days` varchar(255) NOT NULL,
  `weekdays_bg_color` varchar(255) NOT NULL,
  `su_bg_color` varchar(255) NOT NULL,
  `cell_border_color` varchar(255) NOT NULL,
  `year_font_size` varchar(255) NOT NULL,
  `year_font_color` varchar(255) NOT NULL,
  `year_tabs_bg_color` varchar(255) NOT NULL,
  `date_format` varchar(255) NOT NULL,
  `title_color` varchar(255) NOT NULL,
  `title_font_size` varchar(255) NOT NULL,
  `title_font` varchar(255) NOT NULL,
  `title_style` varchar(255) NOT NULL,
  `date_color` varchar(255) NOT NULL,
  `date_size` varchar(255) NOT NULL,
  `date_font` varchar(255) NOT NULL,
  `date_style` varchar(255) NOT NULL,
  `next_prev_event_bgcolor` varchar(255) NOT NULL,
  `next_prev_event_arrowcolor` varchar(255) NOT NULL,
  `show_event_bgcolor` varchar(255) NOT NULL,
  `popup_width` varchar(255) NOT NULL,
  `popup_height` varchar(255) NOT NULL,
  `show_repeat` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_strong_views` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=1275 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=1275 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4805 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=173 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(10,2) DEFAULT NULL,
  `max_price` decimal(10,2) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wcpdf_invoice_number` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `order_id` int(16) DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `calculated_number` int(16) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=893 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=71145 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9269 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=444 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=1085 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=11926 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=1023 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=95 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entries` (
  `entry_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `post_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `viewed` tinyint(1) DEFAULT '0',
  `starred` tinyint(1) DEFAULT '0',
  `fields` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  `date_modified` datetime NOT NULL,
  `ip_address` varchar(128) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_uuid` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`entry_id`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entry_fields` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `field_id` int(11) NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `form_id` (`form_id`),
  KEY `field_id` (`field_id`)
) ENGINE=MyISAM AUTO_INCREMENT=480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpforms_entry_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) NOT NULL,
  `form_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `status` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpmm_subscribers` (
  `id_subscriber` bigint(20) NOT NULL AUTO_INCREMENT,
  `email` varchar(50) NOT NULL,
  `insert_date` datetime NOT NULL,
  PRIMARY KEY (`id_subscriber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_also_bought` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `selected_product` bigint(20) unsigned NOT NULL DEFAULT '0',
  `associated_product` bigint(20) unsigned NOT NULL DEFAULT '0',
  `quantity` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_cart_contents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `prodid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `purchaseid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `price` decimal(11,2) NOT NULL DEFAULT '0.00',
  `pnp` decimal(11,2) NOT NULL DEFAULT '0.00',
  `tax_charged` decimal(11,2) NOT NULL DEFAULT '0.00',
  `gst` decimal(11,2) NOT NULL DEFAULT '0.00',
  `quantity` int(10) unsigned NOT NULL DEFAULT '0',
  `donation` varchar(1) NOT NULL DEFAULT '0',
  `no_shipping` varchar(1) NOT NULL DEFAULT '0',
  `custom_message` text NOT NULL,
  `files` text NOT NULL,
  `meta` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_cart_item_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wpsc_cart_item_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  `meta_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(20)),
  KEY `meta_key_and_value` (`meta_key`(191),`meta_value`(32)),
  KEY `meta_timestamp_index` (`meta_timestamp`),
  KEY `wpsc_cart_item_id` (`wpsc_cart_item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_checkout_forms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `type` varchar(64) NOT NULL DEFAULT '',
  `mandatory` varchar(1) NOT NULL DEFAULT '0',
  `display_log` char(1) NOT NULL DEFAULT '0',
  `default` varchar(128) NOT NULL DEFAULT '0',
  `active` varchar(1) NOT NULL DEFAULT '1',
  `checkout_order` int(10) unsigned NOT NULL DEFAULT '0',
  `unique_name` varchar(255) NOT NULL DEFAULT '',
  `options` longtext,
  `checkout_set` varchar(64) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `checkout_order` (`checkout_order`),
  KEY `unique_name` (`unique_name`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_claimed_stock` (
  `product_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `variation_stock_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `stock_claimed` float NOT NULL,
  `last_activity` datetime NOT NULL,
  `cart_id` varchar(255) NOT NULL DEFAULT '0',
  `cart_submitted` varchar(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `unique_key` (`product_id`,`variation_stock_id`,`cart_id`),
  KEY `last_activity` (`last_activity`),
  KEY `cart_submitted` (`cart_submitted`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_coupon_codes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_code` varchar(255) DEFAULT '',
  `value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `is-percentage` char(1) NOT NULL DEFAULT '0',
  `use-once` char(1) NOT NULL DEFAULT '0',
  `is-used` char(1) NOT NULL DEFAULT '0',
  `active` char(1) NOT NULL DEFAULT '1',
  `every_product` varchar(255) NOT NULL DEFAULT '',
  `start` datetime NOT NULL,
  `expiry` datetime NOT NULL,
  `condition` text,
  PRIMARY KEY (`id`),
  KEY `coupon_code` (`coupon_code`),
  KEY `active` (`active`),
  KEY `start` (`start`),
  KEY `expiry` (`expiry`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_currency_list` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(255) NOT NULL DEFAULT '',
  `isocode` char(2) DEFAULT '',
  `currency` varchar(255) NOT NULL DEFAULT '',
  `symbol` varchar(10) NOT NULL DEFAULT '',
  `symbol_html` varchar(10) NOT NULL DEFAULT '',
  `code` char(3) NOT NULL DEFAULT '',
  `has_regions` char(1) NOT NULL DEFAULT '0',
  `tax` varchar(8) NOT NULL DEFAULT '',
  `continent` varchar(20) NOT NULL DEFAULT '',
  `visible` varchar(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=254 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_download_status` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) unsigned DEFAULT NULL,
  `fileid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `purchid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `cartid` bigint(20) unsigned DEFAULT NULL,
  `uniqueid` varchar(64) DEFAULT '',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `ip_number` varchar(255) NOT NULL DEFAULT '',
  `active` varchar(1) NOT NULL DEFAULT '0',
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `uniqueid` (`uniqueid`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `object_type` varchar(24) NOT NULL DEFAULT 'cart_Item',
  `object_id` bigint(20) NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `object_type__meta_key` (`object_type`,`meta_key`),
  KEY `object_type__object_id__meta_key` (`object_type`,`object_id`,`meta_key`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_product_rating` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ipnum` varchar(30) NOT NULL DEFAULT '',
  `productid` bigint(20) unsigned NOT NULL DEFAULT '0',
  `rated` tinyint(1) NOT NULL DEFAULT '0',
  `time` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_purchase_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `totalprice` decimal(11,2) NOT NULL DEFAULT '0.00',
  `statusno` smallint(6) NOT NULL DEFAULT '0',
  `sessionid` varchar(255) NOT NULL DEFAULT '',
  `transactid` varchar(255) NOT NULL DEFAULT '',
  `authcode` varchar(255) NOT NULL DEFAULT '',
  `processed` bigint(20) unsigned NOT NULL DEFAULT '1',
  `user_ID` bigint(20) unsigned DEFAULT '0',
  `date` varchar(255) NOT NULL DEFAULT '',
  `gateway` varchar(64) NOT NULL DEFAULT '',
  `billing_country` char(6) NOT NULL DEFAULT '',
  `shipping_country` char(6) NOT NULL DEFAULT '',
  `base_shipping` decimal(11,2) NOT NULL DEFAULT '0.00',
  `email_sent` char(1) NOT NULL DEFAULT '0',
  `stock_adjusted` char(1) NOT NULL DEFAULT '0',
  `discount_value` decimal(11,2) NOT NULL DEFAULT '0.00',
  `discount_data` text,
  `track_id` varchar(50) DEFAULT '',
  `billing_region` char(6) NOT NULL DEFAULT '',
  `shipping_region` char(6) NOT NULL DEFAULT '',
  `find_us` varchar(255) NOT NULL DEFAULT '',
  `engravetext` varchar(255) DEFAULT '',
  `shipping_method` varchar(64) DEFAULT NULL,
  `shipping_option` varchar(128) DEFAULT NULL,
  `affiliate_id` varchar(32) DEFAULT NULL,
  `plugin_version` varchar(32) DEFAULT NULL,
  `notes` text,
  `wpec_taxes_total` decimal(11,2) DEFAULT NULL,
  `wpec_taxes_rate` decimal(11,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sessionid` (`sessionid`),
  KEY `gateway` (`gateway`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_purchase_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wpsc_purchase_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  `meta_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(20)),
  KEY `meta_key_and_value` (`meta_key`(191),`meta_value`(32)),
  KEY `meta_timestamp_index` (`meta_timestamp`),
  KEY `wpsc_purchase_id` (`wpsc_purchase_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_region_tax` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `country_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) NOT NULL DEFAULT '',
  `code` char(2) NOT NULL DEFAULT '',
  `tax` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `country_id` (`country_id`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_submited_form_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `form_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `value` longtext,
  PRIMARY KEY (`id`),
  KEY `log_id` (`log_id`,`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_visitor_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wpsc_visitor_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  `meta_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(20)),
  KEY `meta_key_and_value` (`meta_key`(191),`meta_value`(32)),
  KEY `meta_timestamp_index` (`meta_timestamp`),
  KEY `wpsc_visitor_id` (`wpsc_visitor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wpsc_visitors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `last_active` timestamp NULL DEFAULT NULL,
  `expires` timestamp NULL DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `last_active` (`last_active`),
  KEY `expires` (`expires`),
  KEY `created` (`created`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=MyISAM AUTO_INCREMENT=242611 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


 /* SQL Chunk Header Index 1 */ 

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES(197, 61729, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-08 07:05:54', '2019-06-08 05:05:54', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (198, 61730, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-11 14:38:50', '2019-06-11 12:38:50', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (186, 61688, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-07 16:39:36', '2019-05-07 14:39:36', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (187, 61688, 'K. Kanouni', 'office@homotec.ch', '', '', '2019-05-07 16:41:00', '2019-05-07 14:41:00', 'Status der Bestellung von In Wartestellung auf Fertiggestellt geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (188, 61697, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-14 18:14:05', '2019-05-14 16:14:05', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (189, 61704, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-28 15:59:27', '2019-05-28 13:59:27', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (190, 61707, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-28 16:11:09', '2019-05-28 14:11:09', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (118, 61568, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-02 16:01:22', '2019-05-02 14:01:22', 'Lagerbestände reduziert: 1 Mitglied-Ticket / Seminar mit Dr. Rajan Sankaran (1-MT-DRS) 140&rarr;139', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (119, 61568, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-05-02 16:01:22', '2019-05-02 14:01:22', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (191, 61723, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-06 13:16:13', '2019-06-06 11:16:13', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (192, 61724, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-06 15:22:19', '2019-06-06 13:22:19', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (193, 61725, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-06 15:53:04', '2019-06-06 13:53:04', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (194, 61726, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-06 17:35:50', '2019-06-06 15:35:50', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (195, 61727, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-06 21:29:18', '2019-06-06 19:29:18', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0),
 (196, 61728, 'WooCommerce', 'woocommerce@seminare.samuel-hahnemann-schule.ch', '', '', '2019-06-07 16:49:40', '2019-06-07 14:49:40', 'Überweisung erwartet Status der Bestellung von Zahlung ausstehend auf In Wartestellung geändert.', 0, '1', 'WooCommerce', 'order_note', 0, 0);

/* INSERT TABLE DATA: wp_db7_forms */
INSERT INTO `wp_db7_forms` VALUES(1, 59074, 'a:6:{s:12:\"cfdb7_status\";s:6:\"unread\";s:9:\"your-name\";s:8:\"Kanounov\";s:10:\"your-email\";s:17:\"office@homotec.ch\";s:14:\"tel-0794800010\";s:12:\"079 480 1022\";s:12:\"your-subject\";s:16:\"Sankaran Seminar\";s:12:\"your-message\";s:12:\"Bitte danke!\";}', '2019-04-03 16:29:33'),
 (2, 59074, 'a:6:{s:12:\"cfdb7_status\";s:6:\"unread\";s:9:\"your-name\";s:2:\"Ka\";s:10:\"your-email\";s:17:\"office@homotec.ch\";s:14:\"tel-0794800010\";s:11:\"07945202112\";s:12:\"your-subject\";s:16:\"Eine Reklamation\";s:12:\"your-message\";s:6:\"Danke.\";}', '2019-04-10 11:32:34');

/* INSERT TABLE DATA: wp_download_log */
INSERT INTO `wp_download_log` VALUES(1, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-08-29 18:28:42', 'completed', '', NULL),
 (2, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-09-26 14:10:23', 'completed', '', NULL),
 (3, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-09-27 11:46:37', 'completed', '', NULL),
 (4, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-09-27 11:49:35', 'completed', '', NULL),
 (5, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-09-27 18:02:32', 'completed', '', NULL),
 (6, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-09-28 18:24:25', 'completed', '', NULL),
 (7, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-10-25 17:57:46', 'completed', '', NULL),
 (8, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-11-01 16:06:04', 'completed', '', NULL),
 (9, 0, '178.197.225.42', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0', 1095, 1098, '2015', '2016-11-03 15:01:15', 'completed', '', NULL),
 (10, 0, '178.195.107.139', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0', 1095, 1098, '2015', '2016-11-05 17:45:13', 'completed', '', NULL),
 (11, 0, '178.195.107.139', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0', 1095, 1098, '2015', '2016-11-05 17:46:37', 'completed', '', NULL),
 (12, 0, '84.226.70.169', 'Microsoft Office Protocol Discovery', 1095, 1098, '2015', '2016-11-06 17:46:20', 'completed', '', NULL),
 (13, 0, '86.218.166.159', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0', 1095, 1098, '2015', '2016-11-22 17:57:19', 'completed', '', NULL),
 (14, 0, '86.218.166.159', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:49.0) Gecko/20100101 Firefox/49.0', 1095, 1098, '2015', '2016-11-22 17:58:31', 'completed', '', NULL),
 (15, 1, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-11-28 15:06:44', 'completed', '', NULL),
 (16, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-11-29 15:49:29', 'completed', '', NULL),
 (17, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-12-01 11:45:22', 'completed', '', NULL),
 (18, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2096, 2097, '', '2016-12-08 17:36:00', 'completed', '', NULL),
 (19, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2099, 2100, '', '2016-12-08 17:43:55', 'completed', '', NULL),
 (20, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2099, 2100, '', '2016-12-08 17:54:57', 'completed', '', NULL),
 (21, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-12-08 18:30:28', 'completed', '', NULL),
 (22, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2135, '', '2016-12-08 18:44:41', 'completed', '', NULL),
 (23, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2135, '', '2016-12-08 18:46:39', 'completed', '', NULL),
 (24, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2016-12-08 18:46:52', 'completed', '', NULL),
 (25, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2099, 2100, '', '2016-12-08 18:49:09', 'completed', '', NULL),
 (26, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2099, 2100, '', '2016-12-08 18:54:47', 'completed', '', NULL),
 (27, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2016-12-08 18:54:56', 'completed', '', NULL),
 (28, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2129, '', '2016-12-08 18:59:05', 'completed', '', NULL),
 (29, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-12-08 18:59:19', 'completed', '', NULL),
 (30, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2016-12-08 19:05:28', 'completed', '', NULL),
 (31, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2016-12-08 19:10:42', 'completed', '', NULL),
 (32, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2129, '', '2016-12-08 19:10:55', 'completed', '', NULL),
 (33, 0, '77.239.57.191', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-09 10:26:27', 'completed', '', NULL),
 (34, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2016-12-09 10:58:20', 'completed', '', NULL),
 (35, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2016-12-09 11:07:56', 'completed', '', NULL),
 (36, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1095, 1098, '2015', '2016-12-09 11:45:59', 'completed', '', NULL),
 (37, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-11 12:01:29', 'completed', '', NULL),
 (38, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-11 12:06:06', 'completed', '', NULL),
 (39, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-11 12:08:21', 'completed', '', NULL),
 (40, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2099, 2100, '', '2016-12-11 12:08:38', 'completed', '', NULL),
 (41, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-11 12:09:06', 'completed', '', NULL),
 (42, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-11 13:49:50', 'completed', '', NULL),
 (43, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2146, 2149, '', '2016-12-11 16:50:54', 'completed', '', NULL),
 (44, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-12 22:41:31', 'completed', '', NULL),
 (45, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-13 16:24:26', 'completed', '', NULL),
 (46, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2016-12-13 16:24:48', 'completed', '', NULL),
 (47, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2099, 2100, '', '2016-12-13 16:24:53', 'completed', '', NULL),
 (48, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2226, 2228, '', '2016-12-13 17:53:58', 'completed', '', NULL),
 (49, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2016-12-13 18:33:10', 'completed', '', NULL),
 (50, 0, '89.217.8.243', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2146, 2149, '', '2016-12-14 01:04:22', 'completed', '', NULL),
 (51, 0, '92.106.57.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-14 07:57:01', 'completed', '', NULL),
 (52, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2016-12-14 14:18:11', 'completed', '', NULL),
 (53, 0, '212.243.169.84', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2016-12-15 14:31:32', 'completed', '', NULL),
 (54, 0, '83.79.71.253', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2016-12-15 15:00:51', 'completed', '', NULL),
 (55, 0, '83.79.71.253', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-15 15:01:08', 'completed', '', NULL),
 (56, 0, '83.79.71.253', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2016-12-15 15:01:14', 'completed', '', NULL),
 (57, 0, '5.153.244.57', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2140, 2141, '', '2016-12-15 15:05:29', 'completed', '', NULL),
 (58, 0, '5.153.244.57', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2226, 2228, '', '2016-12-15 15:09:52', 'completed', '', NULL),
 (59, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1095, 1098, '2015', '2016-12-15 16:08:24', 'failed', 'Datei nicht gefunden.', NULL),
 (60, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2134, 2135, '', '2016-12-15 16:08:50', 'completed', '', NULL),
 (61, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1095, 1098, '2015', '2016-12-15 16:11:13', 'failed', 'Datei nicht gefunden.', NULL),
 (62, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2130, 2133, '', '2016-12-15 16:12:09', 'completed', '', NULL),
 (63, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2016-12-15 16:12:23', 'completed', '', NULL),
 (64, 0, '217.233.24.113', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1095, 1098, '2015', '2016-12-15 16:12:38', 'failed', 'Datei nicht gefunden.', NULL),
 (65, 0, '178.194.127.160', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2130, 2133, '', '2016-12-15 16:31:22', 'completed', '', NULL),
 (66, 0, '46.140.2.249', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2226, 2228, '', '2016-12-15 16:40:43', 'completed', '', NULL),
 (67, 0, '46.140.2.249', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2226, 2228, '', '2016-12-15 16:40:44', 'completed', '', NULL),
 (68, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2294, 2295, '', '2016-12-15 17:57:04', 'completed', '', NULL),
 (69, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-15 20:53:52', 'completed', '', NULL),
 (70, 0, '46.126.176.94', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2226, 2228, '', '2016-12-15 23:26:12', 'completed', '', NULL),
 (71, 0, '46.126.176.94', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-15 23:27:51', 'completed', '', NULL),
 (72, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2134, 2135, '', '2016-12-16 10:40:12', 'completed', '', NULL),
 (73, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2294, 2295, '', '2016-12-16 10:42:58', 'completed', '', NULL),
 (74, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2161, 2162, '', '2016-12-16 11:31:53', 'completed', '', NULL),
 (75, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2134, 2135, '', '2016-12-16 11:33:02', 'completed', '', NULL),
 (76, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2130, 2133, '', '2016-12-16 11:33:09', 'completed', '', NULL),
 (77, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2294, 2295, '', '2016-12-16 11:33:43', 'completed', '', NULL),
 (78, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2294, 2295, '', '2016-12-16 11:46:52', 'completed', '', NULL),
 (79, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2130, 2133, '', '2016-12-16 12:01:17', 'completed', '', NULL),
 (80, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2134, 2135, '', '2016-12-16 12:02:00', 'completed', '', NULL),
 (81, 0, '62.167.94.59', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2130, 2133, '', '2016-12-16 12:12:12', 'completed', '', NULL),
 (82, 0, '178.199.235.2', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2134, 2135, '', '2016-12-16 20:02:30', 'completed', '', NULL),
 (83, 0, '178.199.235.2', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2294, 2295, '', '2016-12-16 20:16:35', 'completed', '', NULL),
 (84, 0, '178.199.235.2', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2134, 2135, '', '2016-12-16 20:18:25', 'completed', '', NULL),
 (85, 0, '178.199.235.2', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2130, 2133, '', '2016-12-16 20:19:33', 'completed', '', NULL),
 (86, 0, '92.209.160.152', 'Java/1.6.0_04', 2146, 2149, '', '2016-12-17 01:17:48', 'completed', '', NULL),
 (87, 0, '92.209.160.152', 'Java/1.6.0_04', 2226, 2228, '', '2016-12-17 01:17:49', 'completed', '', NULL),
 (88, 0, '92.209.160.152', 'Java/1.6.0_04', 2140, 2141, '', '2016-12-17 01:17:54', 'completed', '', NULL),
 (89, 0, '92.209.160.152', 'Java/1.6.0_04', 2130, 2133, '', '2016-12-17 01:17:55', 'completed', '', NULL),
 (90, 0, '92.209.160.152', 'Java/1.6.0_04', 2134, 2135, '', '2016-12-17 01:17:57', 'completed', '', NULL),
 (91, 0, '92.209.160.152', 'Java/1.6.0_04', 2161, 2162, '', '2016-12-17 01:17:58', 'completed', '', NULL),
 (92, 0, '92.209.160.152', 'Java/1.6.0_04', 2294, 2295, '', '2016-12-17 01:18:00', 'completed', '', NULL),
 (93, 0, '31.10.143.249', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2140, 2141, '', '2016-12-17 09:02:33', 'completed', '', NULL),
 (94, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2016-12-17 10:23:54', 'completed', '', NULL),
 (95, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2016-12-17 10:26:46', 'completed', '', NULL),
 (96, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2135, '', '2016-12-17 10:31:42', 'completed', '', NULL),
 (97, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2130, 2133, '', '2016-12-17 10:31:42', 'completed', '', NULL),
 (98, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2016-12-17 10:31:49', 'completed', '', NULL),
 (99, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2294, 2295, '', '2016-12-17 10:41:53', 'completed', '', NULL),
 (100, 0, '68.180.231.27', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2226, 2228, '', '2016-12-17 11:05:03', 'completed', '', NULL),
 (101, 0, '83.79.71.253', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2016-12-17 11:53:44', 'completed', '', NULL),
 (102, 0, '83.79.71.253', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-17 11:54:24', 'completed', '', NULL),
 (103, 0, '108.58.36.131', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-17 12:47:13', 'completed', '', NULL),
 (104, 0, '108.58.36.131', 'Java/1.4.1_04', 2226, 2228, '', '2016-12-17 12:47:14', 'completed', '', NULL),
 (105, 0, '108.58.36.131', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-17 12:47:17', 'completed', '', NULL),
 (106, 0, '108.58.36.131', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-17 12:47:18', 'completed', '', NULL),
 (107, 0, '108.58.36.131', 'Java/1.4.1_04', 2134, 2135, '', '2016-12-17 12:47:21', 'completed', '', NULL),
 (108, 0, '108.58.36.131', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-17 12:47:23', 'completed', '', NULL),
 (109, 0, '108.58.36.131', 'Java/1.4.1_04', 2294, 2295, '', '2016-12-17 12:47:24', 'completed', '', NULL),
 (110, 0, '37.48.119.133', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-17 14:51:46', 'completed', '', NULL),
 (111, 0, '37.48.119.133', 'Java/1.4.1_04', 2226, 2228, '', '2016-12-17 14:51:46', 'completed', '', NULL),
 (112, 0, '37.48.119.133', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-17 14:51:48', 'completed', '', NULL),
 (113, 0, '37.48.119.133', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-17 14:51:49', 'completed', '', NULL),
 (114, 0, '37.48.119.133', 'Java/1.4.1_04', 2134, 2135, '', '2016-12-17 14:51:50', 'completed', '', NULL),
 (115, 0, '37.48.119.133', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-17 14:51:52', 'completed', '', NULL),
 (116, 0, '37.48.119.133', 'Java/1.4.1_04', 2294, 2295, '', '2016-12-17 14:51:53', 'completed', '', NULL),
 (117, 0, '192.99.119.165', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-18 03:24:23', 'completed', '', NULL),
 (118, 0, '192.99.119.165', 'Java/1.4.1_04', 2226, 2228, '', '2016-12-18 03:24:24', 'completed', '', NULL),
 (119, 0, '192.99.119.165', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-18 03:24:27', 'completed', '', NULL),
 (120, 0, '192.99.119.165', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-18 03:24:28', 'completed', '', NULL),
 (121, 0, '192.99.119.165', 'Java/1.4.1_04', 2134, 2135, '', '2016-12-18 03:24:30', 'completed', '', NULL),
 (122, 0, '192.99.119.165', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-18 03:24:33', 'completed', '', NULL),
 (123, 0, '192.99.119.165', 'Java/1.4.1_04', 2294, 2295, '', '2016-12-18 03:24:34', 'completed', '', NULL),
 (124, 0, '81.62.163.84', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2140, 2141, '', '2016-12-18 15:11:15', 'completed', '', NULL),
 (125, 0, '83.43.35.134', 'Java/1.8.0_51', 2146, 2149, '', '2016-12-18 17:47:00', 'completed', '', NULL),
 (126, 0, '83.43.35.134', 'Java/1.8.0_51', 2226, 2228, '', '2016-12-18 17:47:01', 'completed', '', NULL),
 (127, 0, '83.43.35.134', 'Java/1.8.0_51', 2140, 2141, '', '2016-12-18 17:47:04', 'completed', '', NULL),
 (128, 0, '83.43.35.134', 'Java/1.8.0_51', 2130, 2133, '', '2016-12-18 17:47:07', 'completed', '', NULL),
 (129, 0, '83.43.35.134', 'Java/1.8.0_51', 2134, 2135, '', '2016-12-18 17:47:10', 'completed', '', NULL),
 (130, 0, '83.43.35.134', 'Java/1.8.0_51', 2161, 2162, '', '2016-12-18 17:47:12', 'completed', '', NULL),
 (131, 0, '83.43.35.134', 'Java/1.8.0_51', 2294, 2295, '', '2016-12-18 17:47:13', 'completed', '', NULL),
 (132, 0, '46.127.37.168', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.78.2 (KHTML, like Gecko) Version/7.0.6 Safari/537.78.2', 2294, 2295, '', '2016-12-18 19:58:55', 'completed', '', NULL),
 (133, 0, '83.49.162.28', 'Java/1.8.0_65', 2146, 2149, '', '2016-12-18 22:27:51', 'completed', '', NULL),
 (134, 0, '83.49.162.28', 'Java/1.8.0_65', 2226, 2228, '', '2016-12-18 22:27:52', 'completed', '', NULL),
 (135, 0, '83.49.162.28', 'Java/1.8.0_65', 2140, 2141, '', '2016-12-18 22:27:56', 'completed', '', NULL),
 (136, 0, '83.49.162.28', 'Java/1.8.0_65', 2130, 2133, '', '2016-12-18 22:27:58', 'completed', '', NULL),
 (137, 0, '83.49.162.28', 'Java/1.8.0_65', 2134, 2135, '', '2016-12-18 22:28:01', 'completed', '', NULL),
 (138, 0, '83.49.162.28', 'Java/1.8.0_65', 2161, 2162, '', '2016-12-18 22:28:04', 'completed', '', NULL),
 (139, 0, '83.49.162.28', 'Java/1.8.0_65', 2294, 2295, '', '2016-12-18 22:28:06', 'completed', '', NULL),
 (140, 0, '84.73.216.26', 'Mozilla/5.0 (Linux; Android 7.0; Nexus 5X Build/NRD90R) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/537.36', 2134, 2135, '', '2016-12-18 22:33:14', 'completed', '', NULL),
 (141, 0, '84.73.216.26', 'Mozilla/5.0 (Linux; Android 7.0; Nexus 5X Build/NRD90R) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.85 Mobile Safari/537.36', 2130, 2133, '', '2016-12-18 22:34:19', 'completed', '', NULL),
 (142, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2146, 2149, '', '2016-12-19 14:06:59', 'completed', '', NULL),
 (143, 0, '85.0.132.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:49.0) Gecko/20100101 Firefox/49.0', 2140, 2141, '', '2016-12-19 14:46:46', 'completed', '', NULL),
 (144, 0, '85.0.132.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:49.0) Gecko/20100101 Firefox/49.0', 2146, 2149, '', '2016-12-19 14:48:48', 'completed', '', NULL),
 (145, 0, '178.197.224.142', 'Mozilla/5.0 (Linux; Android 4.4.4; de-ch; SAMSUNG SM-G850F Build/KTU84P) AppleWebKit/537.36 (KHTML, like Gecko) Version/1.6 Chrome/28.0.1500.94 Mobile Safari/537.36', 2294, 2295, '', '2016-12-19 16:19:35', 'completed', '', NULL),
 (146, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-19 19:20:25', 'completed', '', NULL),
 (147, 0, '89.217.192.67', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1 (KHTML, like Gecko) CriOS/55.0.2883.79 Mobile/13G36 Safari/601.1.46', 2146, 2149, '', '2016-12-19 21:37:47', 'completed', '', NULL),
 (148, 0, '84.227.222.236', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2140, 2141, '', '2016-12-20 00:17:19', 'completed', '', NULL),
 (149, 0, '84.227.222.236', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2016-12-20 00:18:45', 'completed', '', NULL),
 (150, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2140, 2141, '', '2016-12-20 09:14:03', 'completed', '', NULL),
 (151, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2226, 2228, '', '2016-12-20 09:14:15', 'completed', '', NULL),
 (152, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2130, 2133, '', '2016-12-20 09:22:49', 'completed', '', NULL),
 (153, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2134, 2135, '', '2016-12-20 09:23:00', 'completed', '', NULL),
 (154, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2161, 2162, '', '2016-12-20 09:23:12', 'completed', '', NULL),
 (155, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2294, 2295, '', '2016-12-20 09:23:25', 'completed', '', NULL),
 (156, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2302, 2305, '', '2016-12-20 15:27:29', 'completed', '', NULL),
 (157, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2016-12-20 15:33:17', 'completed', '', NULL),
 (158, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2302, 2305, '', '2016-12-20 16:52:02', 'completed', '', NULL),
 (159, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2302, 2305, '', '2016-12-20 16:59:46', 'completed', '', NULL),
 (160, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2302, 2305, '', '2016-12-20 17:43:18', 'completed', '', NULL),
 (161, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-20 17:44:05', 'completed', '', NULL),
 (162, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2302, 2305, '', '2016-12-20 18:21:40', 'completed', '', NULL),
 (163, 0, '178.39.165.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2016-12-20 21:18:11', 'completed', '', NULL),
 (164, 0, '178.39.165.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2016-12-20 21:23:47', 'completed', '', NULL),
 (165, 0, '178.39.165.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2016-12-20 21:33:29', 'completed', '', NULL),
 (166, 0, '178.39.165.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2016-12-20 21:34:30', 'completed', '', NULL),
 (167, 0, '178.39.165.222', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2016-12-20 21:35:22', 'completed', '', NULL),
 (168, 0, '84.227.222.236', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2140, 2141, '', '2016-12-20 22:47:00', 'completed', '', NULL),
 (169, 0, '192.99.119.164', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-20 23:38:37', 'completed', '', NULL),
 (170, 0, '192.99.119.164', 'Java/1.4.1_04', 2226, 2228, '', '2016-12-20 23:38:38', 'completed', '', NULL),
 (171, 0, '192.99.119.164', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-20 23:38:41', 'completed', '', NULL),
 (172, 0, '192.99.119.164', 'Java/1.4.1_04', 2302, 2305, '', '2016-12-20 23:38:42', 'completed', '', NULL),
 (173, 0, '192.99.119.164', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-20 23:38:44', 'completed', '', NULL),
 (174, 0, '192.99.119.164', 'Java/1.4.1_04', 2134, 2307, '', '2016-12-20 23:38:46', 'completed', '', NULL),
 (175, 0, '192.99.119.164', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-20 23:38:48', 'completed', '', NULL),
 (176, 0, '192.99.119.164', 'Java/1.4.1_04', 2294, 2295, '', '2016-12-20 23:38:49', 'completed', '', NULL),
 (177, 0, '85.4.251.168', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2016-12-21 09:44:16', 'completed', '', NULL),
 (178, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2302, 2305, '', '2016-12-21 15:12:29', 'completed', '', NULL),
 (179, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2016-12-21 17:03:35', 'completed', '', NULL),
 (180, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2016-12-21 17:04:11', 'completed', '', NULL),
 (181, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2343, '', '2016-12-21 17:04:53', 'completed', '', NULL),
 (182, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2016-12-21 17:05:50', 'completed', '', NULL),
 (183, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2016-12-21 17:26:29', 'completed', '', NULL),
 (184, 10, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2016-12-21 17:27:00', 'completed', '', NULL),
 (185, 0, '92.107.248.198', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2140, 2141, '', '2016-12-21 22:11:50', 'completed', '', NULL),
 (186, 0, '92.107.248.198', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2336, 2337, '', '2016-12-21 22:13:44', 'completed', '', NULL),
 (187, 0, '92.107.248.198', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2342, 2349, '', '2016-12-21 22:26:06', 'completed', '', NULL),
 (188, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-21 23:54:24', 'completed', '', NULL),
 (189, 0, '104.168.141.170', 'Java/1.6.0_04', 2146, 2149, '', '2016-12-22 01:29:32', 'completed', '', NULL),
 (190, 0, '104.168.141.170', 'Java/1.6.0_04', 2333, 2334, '', '2016-12-22 01:29:33', 'completed', '', NULL),
 (191, 0, '104.168.141.170', 'Java/1.6.0_04', 2140, 2141, '', '2016-12-22 01:29:38', 'completed', '', NULL),
 (192, 0, '104.168.141.170', 'Java/1.6.0_04', 2336, 2337, '', '2016-12-22 01:29:40', 'completed', '', NULL),
 (193, 0, '104.168.141.170', 'Java/1.6.0_04', 2339, 2340, '', '2016-12-22 01:29:44', 'completed', '', NULL),
 (194, 0, '104.168.141.170', 'Java/1.6.0_04', 2130, 2133, '', '2016-12-22 01:29:51', 'completed', '', NULL),
 (195, 0, '104.168.141.170', 'Java/1.6.0_04', 2134, 2307, '', '2016-12-22 01:29:53', 'completed', '', NULL),
 (196, 0, '104.168.141.170', 'Java/1.6.0_04', 2161, 2162, '', '2016-12-22 01:29:58', 'completed', '', NULL),
 (197, 0, '104.168.141.170', 'Java/1.6.0_04', 2342, 2349, '', '2016-12-22 01:29:59', 'completed', '', NULL),
 (198, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2146, 2149, '', '2016-12-22 14:04:58', 'completed', '', NULL),
 (199, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2339, 2340, '', '2016-12-22 14:19:04', 'completed', '', NULL),
 (200, 0, '81.62.85.240', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2016-12-23 10:24:17', 'completed', '', NULL),
 (201, 0, '81.62.85.240', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2016-12-23 10:24:26', 'completed', '', NULL),
 (202, 0, '62.202.31.225', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2016-12-23 12:53:49', 'completed', '', NULL),
 (203, 0, '62.202.31.225', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-23 12:53:56', 'completed', '', NULL),
 (204, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2016-12-23 14:23:57', 'completed', '', NULL),
 (205, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2016-12-23 14:23:58', 'completed', '', NULL),
 (206, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2016-12-23 14:24:03', 'completed', '', NULL),
 (207, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2016-12-23 14:24:04', 'completed', '', NULL),
 (208, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2016-12-23 14:24:07', 'completed', '', NULL),
 (209, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2016-12-23 14:24:09', 'completed', '', NULL),
 (210, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2016-12-23 14:24:11', 'completed', '', NULL),
 (211, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2016-12-23 14:24:13', 'completed', '', NULL),
 (212, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2016-12-23 14:24:15', 'completed', '', NULL),
 (213, 0, '46.127.52.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.59.10 (KHTML, like Gecko) Version/5.1.9 Safari/534.59.10', 2333, 2334, '', '2016-12-23 14:43:02', 'completed', '', NULL),
 (214, 0, '109.70.119.73', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2336, 2337, '', '2016-12-23 19:20:37', 'completed', '', NULL),
 (215, 0, '109.70.119.73', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2140, 2141, '', '2016-12-23 19:20:47', 'completed', '', NULL),
 (216, 0, '101.226.33.216', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; Trident/5.0)', 2336, 2337, '', '2016-12-23 19:20:55', 'completed', '', NULL),
 (217, 0, '61.135.187.48', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2336, 2337, '', '2016-12-23 19:21:01', 'completed', '', NULL),
 (218, 0, '101.226.99.196', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2140, 2141, '', '2016-12-23 19:21:14', 'completed', '', NULL),
 (219, 0, '117.185.27.115', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2140, 2141, '', '2016-12-23 19:21:17', 'completed', '', NULL),
 (220, 0, '175.155.25.12', 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/45.0.2454.101 Safari/537.36', 2140, 2141, '', '2016-12-23 19:21:24', 'completed', '', NULL),
 (221, 0, '112.195.98.241', 'Mozilla/5.0 (compatible; MSIE 9.0; Windows NT 6.1; WOW64; Trident/5.0)', 2140, 2141, '', '2016-12-23 19:21:26', 'completed', '', NULL),
 (222, 0, '109.70.119.73', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2339, 2340, '', '2016-12-23 19:22:10', 'completed', '', NULL),
 (223, 0, '101.226.99.196', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2339, 2340, '', '2016-12-23 19:22:29', 'completed', '', NULL),
 (224, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2016-12-23 22:21:37', 'completed', '', NULL),
 (225, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2339, 2340, '', '2016-12-23 22:23:11', 'completed', '', NULL),
 (226, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2016-12-23 22:27:22', 'completed', '', NULL),
 (227, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2016-12-24 10:16:41', 'completed', '', NULL),
 (228, 0, '68.180.230.58', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2016-12-24 10:48:05', 'completed', '', NULL),
 (229, 0, '68.180.230.58', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2336, 2337, '', '2016-12-24 11:26:52', 'completed', '', NULL),
 (230, 0, '37.49.225.68', 'Java/1.8.0_73', 2146, 2149, '', '2016-12-25 00:10:35', 'completed', '', NULL),
 (231, 0, '37.49.225.68', 'Java/1.8.0_73', 2333, 2334, '', '2016-12-25 00:10:36', 'completed', '', NULL),
 (232, 0, '37.49.225.68', 'Java/1.8.0_73', 2140, 2141, '', '2016-12-25 00:10:39', 'completed', '', NULL),
 (233, 0, '37.49.225.68', 'Java/1.8.0_73', 2336, 2337, '', '2016-12-25 00:10:41', 'completed', '', NULL),
 (234, 0, '37.49.225.68', 'Java/1.8.0_73', 2339, 2340, '', '2016-12-25 00:10:42', 'completed', '', NULL),
 (235, 0, '37.49.225.68', 'Java/1.8.0_73', 2130, 2133, '', '2016-12-25 00:10:44', 'completed', '', NULL),
 (236, 0, '37.49.225.68', 'Java/1.8.0_73', 2134, 2307, '', '2016-12-25 00:10:46', 'completed', '', NULL),
 (237, 0, '37.49.225.68', 'Java/1.8.0_73', 2161, 2162, '', '2016-12-25 00:10:51', 'completed', '', NULL),
 (238, 0, '37.49.225.68', 'Java/1.8.0_73', 2342, 2349, '', '2016-12-25 00:10:53', 'completed', '', NULL),
 (239, 0, '68.180.230.58', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2342, 2349, '', '2016-12-25 00:58:55', 'completed', '', NULL),
 (240, 0, '212.129.4.12', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-25 10:04:38', 'completed', '', NULL),
 (241, 0, '212.129.4.12', 'Java/1.4.1_04', 2333, 2334, '', '2016-12-25 10:04:39', 'completed', '', NULL),
 (242, 0, '212.129.4.12', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-25 10:04:42', 'completed', '', NULL),
 (243, 0, '212.129.4.12', 'Java/1.4.1_04', 2336, 2337, '', '2016-12-25 10:04:44', 'completed', '', NULL),
 (244, 0, '212.129.4.12', 'Java/1.4.1_04', 2339, 2340, '', '2016-12-25 10:04:46', 'completed', '', NULL),
 (245, 0, '212.129.4.12', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-25 10:04:49', 'completed', '', NULL),
 (246, 0, '212.129.4.12', 'Java/1.4.1_04', 2134, 2307, '', '2016-12-25 10:04:51', 'completed', '', NULL),
 (247, 0, '212.129.4.12', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-25 10:04:53', 'completed', '', NULL),
 (248, 0, '212.129.4.12', 'Java/1.4.1_04', 2342, 2349, '', '2016-12-25 10:04:55', 'completed', '', NULL),
 (249, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2016-12-26 19:16:40', 'completed', '', NULL),
 (250, 0, '81.137.223.148', 'Java/1.6.0_24', 2146, 2149, '', '2016-12-26 22:38:53', 'completed', '', NULL),
 (251, 0, '81.137.223.148', 'Java/1.6.0_24', 2333, 2334, '', '2016-12-26 22:38:53', 'completed', '', NULL),
 (252, 0, '81.137.223.148', 'Java/1.6.0_24', 2140, 2141, '', '2016-12-26 22:38:56', 'completed', '', NULL),
 (253, 0, '81.137.223.148', 'Java/1.6.0_24', 2336, 2337, '', '2016-12-26 22:38:57', 'completed', '', NULL),
 (254, 0, '81.137.223.148', 'Java/1.6.0_24', 2339, 2340, '', '2016-12-26 22:38:58', 'completed', '', NULL),
 (255, 0, '81.137.223.148', 'Java/1.6.0_24', 2130, 2133, '', '2016-12-26 22:38:59', 'completed', '', NULL),
 (256, 0, '81.137.223.148', 'Java/1.6.0_24', 2134, 2307, '', '2016-12-26 22:39:00', 'completed', '', NULL),
 (257, 0, '81.137.223.148', 'Java/1.6.0_24', 2161, 2162, '', '2016-12-26 22:39:02', 'completed', '', NULL),
 (258, 0, '81.137.223.148', 'Java/1.6.0_24', 2342, 2349, '', '2016-12-26 22:39:03', 'completed', '', NULL),
 (259, 0, '151.182.89.118', 'Java/1.6.0_04', 2146, 2149, '', '2016-12-27 02:33:49', 'completed', '', NULL),
 (260, 0, '151.182.89.118', 'Java/1.6.0_04', 2333, 2334, '', '2016-12-27 02:33:50', 'completed', '', NULL),
 (261, 0, '151.182.89.118', 'Java/1.6.0_04', 2140, 2141, '', '2016-12-27 02:33:54', 'completed', '', NULL),
 (262, 0, '151.182.89.118', 'Java/1.6.0_04', 2336, 2337, '', '2016-12-27 02:33:56', 'completed', '', NULL),
 (263, 0, '151.182.89.118', 'Java/1.6.0_04', 2339, 2340, '', '2016-12-27 02:33:58', 'completed', '', NULL),
 (264, 0, '151.182.89.118', 'Java/1.6.0_04', 2130, 2133, '', '2016-12-27 02:34:01', 'completed', '', NULL),
 (265, 0, '151.182.89.118', 'Java/1.6.0_04', 2134, 2307, '', '2016-12-27 02:34:03', 'completed', '', NULL),
 (266, 0, '151.182.89.118', 'Java/1.6.0_04', 2161, 2162, '', '2016-12-27 02:34:07', 'completed', '', NULL),
 (267, 0, '151.182.89.118', 'Java/1.6.0_04', 2342, 2349, '', '2016-12-27 02:34:09', 'completed', '', NULL),
 (268, 0, '158.181.109.12', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2140, 2141, '', '2016-12-27 09:18:14', 'completed', '', NULL),
 (269, 0, '158.181.109.12', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2333, 2334, '', '2016-12-27 11:02:32', 'completed', '', NULL),
 (270, 0, '194.209.160.146', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2016-12-27 12:35:06', 'completed', '', NULL),
 (271, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2146, 2149, '', '2016-12-27 13:28:06', 'completed', '', NULL),
 (272, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2339, 2340, '', '2016-12-27 13:28:16', 'completed', '', NULL),
 (273, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_1) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2146, 2149, '', '2016-12-27 13:28:52', 'completed', '', NULL),
 (274, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2016-12-27 14:23:33', 'completed', '', NULL),
 (275, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2339, 2340, '', '2016-12-27 14:27:59', 'completed', '', NULL),
 (276, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2146, 2149, '', '2016-12-27 14:35:27', 'completed', '', NULL),
 (277, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2339, 2340, '', '2016-12-27 14:50:08', 'completed', '', NULL),
 (278, 0, '178.195.104.199', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2016-12-27 21:46:24', 'completed', '', NULL),
 (279, 0, '212.129.49.187', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-27 22:47:12', 'completed', '', NULL),
 (280, 0, '212.129.49.187', 'Java/1.4.1_04', 2333, 2334, '', '2016-12-27 22:47:13', 'completed', '', NULL),
 (281, 0, '212.129.49.187', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-27 22:47:15', 'completed', '', NULL),
 (282, 0, '212.129.49.187', 'Java/1.4.1_04', 2336, 2337, '', '2016-12-27 22:47:16', 'completed', '', NULL),
 (283, 0, '212.129.49.187', 'Java/1.4.1_04', 2339, 2340, '', '2016-12-27 22:47:18', 'completed', '', NULL),
 (284, 0, '212.129.49.187', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-27 22:47:19', 'completed', '', NULL),
 (285, 0, '212.129.49.187', 'Java/1.4.1_04', 2134, 2307, '', '2016-12-27 22:47:21', 'completed', '', NULL),
 (286, 0, '212.129.49.187', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-27 22:47:22', 'completed', '', NULL),
 (287, 0, '212.129.49.187', 'Java/1.4.1_04', 2342, 2349, '', '2016-12-27 22:47:23', 'completed', '', NULL),
 (288, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2016-12-28 07:47:07', 'completed', '', NULL),
 (289, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2016-12-28 07:47:12', 'completed', '', NULL),
 (290, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2016-12-28 07:47:17', 'completed', '', NULL),
 (291, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2016-12-28 07:47:42', 'completed', '', NULL),
 (292, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2016-12-28 07:47:47', 'completed', '', NULL),
 (293, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2016-12-28 07:47:51', 'completed', '', NULL),
 (294, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2016-12-28 07:47:56', 'completed', '', NULL),
 (295, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2016-12-28 07:48:32', 'completed', '', NULL),
 (296, 0, '104.131.101.240', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2016-12-28 07:49:11', 'completed', '', NULL),
 (297, 0, '66.249.93.219', 'Mozilla/5.0 (Linux; Android 5.1.1; SM-J200G Build/LMY47X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.68 Mobile Safari/537.36', 2333, 2334, '', '2016-12-28 09:32:49', 'completed', '', NULL),
 (298, 0, '84.75.92.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2342, 2349, '', '2016-12-28 22:23:36', 'completed', '', NULL),
 (299, 0, '84.75.92.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2134, 2307, '', '2016-12-28 22:23:41', 'completed', '', NULL),
 (300, 0, '87.217.153.149', 'Java/1.8.0_71', 2146, 2149, '', '2016-12-29 07:39:04', 'completed', '', NULL),
 (301, 0, '87.217.153.149', 'Java/1.8.0_71', 2333, 2334, '', '2016-12-29 07:39:05', 'completed', '', NULL),
 (302, 0, '87.217.153.149', 'Java/1.8.0_71', 2140, 2141, '', '2016-12-29 07:39:09', 'completed', '', NULL),
 (303, 0, '87.217.153.149', 'Java/1.8.0_71', 2336, 2337, '', '2016-12-29 07:39:11', 'completed', '', NULL),
 (304, 0, '87.217.153.149', 'Java/1.8.0_71', 2339, 2340, '', '2016-12-29 07:39:13', 'completed', '', NULL),
 (305, 0, '87.217.153.149', 'Java/1.8.0_71', 2130, 2133, '', '2016-12-29 07:39:15', 'completed', '', NULL),
 (306, 0, '87.217.153.149', 'Java/1.8.0_71', 2134, 2307, '', '2016-12-29 07:39:17', 'completed', '', NULL),
 (307, 0, '87.217.153.149', 'Java/1.8.0_71', 2161, 2162, '', '2016-12-29 07:39:20', 'completed', '', NULL),
 (308, 0, '87.217.153.149', 'Java/1.8.0_71', 2342, 2349, '', '2016-12-29 07:39:21', 'completed', '', NULL),
 (309, 0, '188.155.56.54', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2016-12-29 09:44:23', 'completed', '', NULL),
 (310, 0, '62.202.31.225', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2016-12-29 12:13:16', 'completed', '', NULL),
 (311, 17, '213.189.148.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2016-12-29 13:57:09', 'completed', '', NULL),
 (312, 17, '213.189.148.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2016-12-29 13:57:25', 'completed', '', NULL),
 (313, 17, '213.189.148.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2016-12-29 14:01:03', 'completed', '', NULL),
 (314, 0, '83.78.233.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/600.6.3 (KHTML, like Gecko) Version/7.1.6 Safari/537.85.15', 2140, 2141, '', '2016-12-29 14:01:27', 'completed', '', NULL),
 (315, 0, '83.78.233.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/600.6.3 (KHTML, like Gecko) Version/7.1.6 Safari/537.85.15', 2336, 2337, '', '2016-12-29 14:07:47', 'completed', '', NULL),
 (316, 0, '31.10.150.160', 'Mozilla/5.0 (iPad; CPU OS 9_3_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13E238 Safari/601.1', 2140, 2141, '', '2016-12-29 18:21:06', 'completed', '', NULL),
 (317, 0, '62.202.189.38', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2016-12-29 19:56:55', 'completed', '', NULL),
 (318, 0, '83.41.1.40', 'Java/1.8.0_65', 2146, 2149, '', '2016-12-30 03:05:10', 'completed', '', NULL),
 (319, 0, '83.41.1.40', 'Java/1.8.0_65', 2333, 2334, '', '2016-12-30 03:05:11', 'completed', '', NULL),
 (320, 0, '83.41.1.40', 'Java/1.8.0_65', 2140, 2141, '', '2016-12-30 03:05:14', 'completed', '', NULL),
 (321, 0, '83.41.1.40', 'Java/1.8.0_65', 2336, 2337, '', '2016-12-30 03:05:16', 'completed', '', NULL),
 (322, 0, '83.41.1.40', 'Java/1.8.0_65', 2339, 2340, '', '2016-12-30 03:05:18', 'completed', '', NULL),
 (323, 0, '83.41.1.40', 'Java/1.8.0_65', 2130, 2133, '', '2016-12-30 03:05:20', 'completed', '', NULL),
 (324, 0, '83.41.1.40', 'Java/1.8.0_65', 2134, 2307, '', '2016-12-30 03:05:22', 'completed', '', NULL),
 (325, 0, '83.41.1.40', 'Java/1.8.0_65', 2161, 2162, '', '2016-12-30 03:05:27', 'completed', '', NULL),
 (326, 0, '83.41.1.40', 'Java/1.8.0_65', 2342, 2349, '', '2016-12-30 03:05:28', 'completed', '', NULL),
 (327, 0, '195.48.13.34', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2016-12-30 08:17:05', 'completed', '', NULL),
 (328, 0, '178.197.227.254', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14A456 Safari/600.1.4', 2140, 2141, '', '2016-12-30 13:57:39', 'completed', '', NULL),
 (329, 0, '178.197.227.254', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14A456 Safari/600.1.4', 2336, 2337, '', '2016-12-30 13:58:40', 'completed', '', NULL),
 (330, 0, '188.155.56.54', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2016-12-30 14:11:04', 'completed', '', NULL),
 (331, 0, '188.155.56.54', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2339, 2340, '', '2016-12-30 14:16:36', 'completed', '', NULL),
 (332, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2339, 2340, '', '2016-12-31 06:54:11', 'completed', '', NULL),
 (333, 0, '81.63.182.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0', 2140, 2141, '', '2016-12-31 11:33:09', 'completed', '', NULL),
 (334, 0, '81.63.182.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0', 2336, 2337, '', '2016-12-31 11:34:01', 'completed', '', NULL),
 (335, 0, '81.63.182.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2016-12-31 11:48:30', 'completed', '', NULL),
 (336, 0, '81.63.182.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2016-12-31 11:51:06', 'completed', '', NULL),
 (337, 0, '192.99.119.164', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-31 20:56:06', 'completed', '', NULL),
 (338, 0, '192.99.119.164', 'Java/1.4.1_04', 2333, 2334, '', '2016-12-31 20:56:07', 'completed', '', NULL),
 (339, 0, '192.99.119.164', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-31 20:56:10', 'completed', '', NULL),
 (340, 0, '192.99.119.164', 'Java/1.4.1_04', 2336, 2337, '', '2016-12-31 20:56:11', 'completed', '', NULL),
 (341, 0, '192.99.119.164', 'Java/1.4.1_04', 2339, 2340, '', '2016-12-31 20:56:13', 'completed', '', NULL),
 (342, 0, '192.99.119.164', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-31 20:56:15', 'completed', '', NULL),
 (343, 0, '192.99.119.164', 'Java/1.4.1_04', 2134, 2307, '', '2016-12-31 20:56:17', 'completed', '', NULL),
 (344, 0, '192.99.119.164', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-31 20:56:19', 'completed', '', NULL),
 (345, 0, '192.99.119.164', 'Java/1.4.1_04', 2342, 2349, '', '2016-12-31 20:56:20', 'completed', '', NULL),
 (346, 0, '212.129.49.187', 'Java/1.4.1_04', 2146, 2149, '', '2016-12-31 22:52:08', 'completed', '', NULL),
 (347, 0, '212.129.49.187', 'Java/1.4.1_04', 2333, 2334, '', '2016-12-31 22:52:09', 'completed', '', NULL),
 (348, 0, '212.129.49.187', 'Java/1.4.1_04', 2140, 2141, '', '2016-12-31 22:52:11', 'completed', '', NULL),
 (349, 0, '212.129.49.187', 'Java/1.4.1_04', 2336, 2337, '', '2016-12-31 22:52:12', 'completed', '', NULL),
 (350, 0, '212.129.49.187', 'Java/1.4.1_04', 2339, 2340, '', '2016-12-31 22:52:13', 'completed', '', NULL),
 (351, 0, '212.129.49.187', 'Java/1.4.1_04', 2130, 2133, '', '2016-12-31 22:52:15', 'completed', '', NULL),
 (352, 0, '212.129.49.187', 'Java/1.4.1_04', 2134, 2307, '', '2016-12-31 22:52:16', 'completed', '', NULL),
 (353, 0, '212.129.49.187', 'Java/1.4.1_04', 2161, 2162, '', '2016-12-31 22:52:17', 'completed', '', NULL),
 (354, 0, '212.129.49.187', 'Java/1.4.1_04', 2342, 2349, '', '2016-12-31 22:52:18', 'completed', '', NULL),
 (355, 0, '178.197.236.154', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2339, 2340, '', '2017-01-01 13:40:03', 'completed', '', NULL),
 (356, 0, '62.202.184.172', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_2) AppleWebKit/601.3.9 (KHTML, like Gecko) Version/9.0.2 Safari/601.3.9', 2140, 2141, '', '2017-01-01 17:39:46', 'completed', '', NULL),
 (357, 0, '176.127.71.71', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2134, 2307, '', '2017-01-02 01:02:57', 'completed', '', NULL),
 (358, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2146, 2149, '', '2017-01-02 13:14:19', 'completed', '', NULL),
 (359, 0, '178.197.228.75', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:51.0) Gecko/51.0 Firefox/51.0', 2146, 2149, '', '2017-01-02 15:05:48', 'completed', '', NULL),
 (360, 0, '178.197.228.75', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:51.0) Gecko/51.0 Firefox/51.0', 2342, 2349, '', '2017-01-02 15:06:28', 'completed', '', NULL),
 (361, 0, '178.197.228.75', 'Dalvik/2.1.0 (Linux; U; Android 6.0.1; SM-G935F Build/MMB29K)', 2342, 2349, '', '2017-01-02 15:06:30', 'completed', '', NULL),
 (362, 0, '178.197.228.75', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:51.0) Gecko/51.0 Firefox/51.0', 2134, 2307, '', '2017-01-02 15:09:42', 'completed', '', NULL),
 (363, 0, '178.197.228.75', 'Dalvik/2.1.0 (Linux; U; Android 6.0.1; SM-G935F Build/MMB29K)', 2134, 2307, '', '2017-01-02 15:09:43', 'completed', '', NULL),
 (364, 0, '91.190.25.163', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-02 16:07:13', 'completed', '', NULL),
 (365, 0, '176.86.156.223', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-02 19:18:47', 'completed', '', NULL),
 (366, 0, '176.86.156.223', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-02 19:18:48', 'completed', '', NULL),
 (367, 0, '176.86.156.223', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-02 19:18:52', 'completed', '', NULL),
 (368, 0, '176.86.156.223', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-02 19:18:54', 'completed', '', NULL),
 (369, 0, '176.86.156.223', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-02 19:18:58', 'completed', '', NULL),
 (370, 0, '176.86.156.223', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-02 19:19:02', 'completed', '', NULL),
 (371, 0, '176.86.156.223', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-02 19:19:05', 'completed', '', NULL),
 (372, 0, '176.86.156.223', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-02 19:19:09', 'completed', '', NULL),
 (373, 0, '176.86.156.223', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-02 19:19:11', 'completed', '', NULL),
 (374, 0, '81.137.223.148', 'Java/1.6.0_24', 2146, 2149, '', '2017-01-02 20:09:42', 'completed', '', NULL),
 (375, 0, '81.137.223.148', 'Java/1.6.0_24', 2333, 2334, '', '2017-01-02 20:09:42', 'completed', '', NULL),
 (376, 0, '81.137.223.148', 'Java/1.6.0_24', 2140, 2141, '', '2017-01-02 20:09:45', 'completed', '', NULL),
 (377, 0, '81.137.223.148', 'Java/1.6.0_24', 2336, 2337, '', '2017-01-02 20:09:46', 'completed', '', NULL),
 (378, 0, '81.137.223.148', 'Java/1.6.0_24', 2339, 2340, '', '2017-01-02 20:09:47', 'completed', '', NULL),
 (379, 0, '81.137.223.148', 'Java/1.6.0_24', 2130, 2133, '', '2017-01-02 20:09:48', 'completed', '', NULL),
 (380, 0, '81.137.223.148', 'Java/1.6.0_24', 2134, 2307, '', '2017-01-02 20:09:49', 'completed', '', NULL),
 (381, 0, '81.137.223.148', 'Java/1.6.0_24', 2161, 2162, '', '2017-01-02 20:09:50', 'completed', '', NULL),
 (382, 0, '81.137.223.148', 'Java/1.6.0_24', 2342, 2349, '', '2017-01-02 20:09:52', 'completed', '', NULL),
 (383, 0, '178.197.224.93', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14C92 Safari/600.1.4', 2140, 2141, '', '2017-01-02 22:57:21', 'completed', '', NULL),
 (384, 0, '178.197.224.93', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14C92 Safari/600.1.4', 2146, 2149, '', '2017-01-02 23:07:43', 'completed', '', NULL),
 (385, 0, '178.197.224.93', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14C92 Safari/600.1.4', 2140, 2141, '', '2017-01-02 23:08:06', 'completed', '', NULL),
 (386, 0, '178.197.224.93', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/14C92 Safari/600.1.4', 2336, 2337, '', '2017-01-02 23:10:52', 'completed', '', NULL),
 (387, 0, '176.86.172.46', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-03 08:18:53', 'completed', '', NULL),
 (388, 0, '176.86.172.46', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-03 08:18:54', 'completed', '', NULL),
 (389, 0, '176.86.172.46', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-03 08:18:56', 'completed', '', NULL),
 (390, 0, '176.86.172.46', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-03 08:18:58', 'completed', '', NULL),
 (391, 0, '176.86.172.46', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-03 08:19:00', 'completed', '', NULL),
 (392, 0, '176.86.172.46', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-03 08:19:02', 'completed', '', NULL),
 (393, 0, '176.86.172.46', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-03 08:19:03', 'completed', '', NULL),
 (394, 0, '176.86.172.46', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-03 08:19:05', 'completed', '', NULL),
 (395, 0, '176.86.172.46', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-03 08:19:07', 'completed', '', NULL),
 (396, 0, '85.5.182.20', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-03 12:54:03', 'completed', '', NULL),
 (397, 0, '85.5.182.20', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-03 12:55:36', 'completed', '', NULL),
 (398, 0, '83.77.47.27', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-03 17:22:34', 'completed', '', NULL),
 (399, 0, '83.77.47.27', 'WhatsApp/2.16.20/i', 2333, 2334, '', '2017-01-03 17:26:07', 'completed', '', NULL),
 (400, 0, '83.77.47.27', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-03 17:27:56', 'completed', '', NULL),
 (401, 0, '188.63.46.33', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-03 17:46:26', 'completed', '', NULL),
 (402, 0, '178.197.225.131', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2134, 2307, '', '2017-01-03 19:45:31', 'completed', '', NULL),
 (403, 0, '178.197.225.131', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2130, 2133, '', '2017-01-03 19:46:04', 'completed', '', NULL),
 (404, 0, '178.197.235.235', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2339, 2340, '', '2017-01-04 08:24:31', 'completed', '', NULL),
 (405, 0, '178.197.235.235', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-01-04 08:26:49', 'completed', '', NULL),
 (406, 0, '89.123.37.241', 'Java/1.6.0_22', 2146, 2149, '', '2017-01-04 10:16:39', 'completed', '', NULL),
 (407, 0, '89.123.37.241', 'Java/1.6.0_22', 2333, 2334, '', '2017-01-04 10:16:39', 'completed', '', NULL),
 (408, 0, '89.123.37.241', 'Java/1.6.0_22', 2140, 2141, '', '2017-01-04 10:16:43', 'completed', '', NULL),
 (409, 0, '89.123.37.241', 'Java/1.6.0_22', 2336, 2337, '', '2017-01-04 10:16:44', 'completed', '', NULL),
 (410, 0, '89.123.37.241', 'Java/1.6.0_22', 2339, 2340, '', '2017-01-04 10:16:47', 'completed', '', NULL),
 (411, 0, '89.123.37.241', 'Java/1.6.0_22', 2130, 2133, '', '2017-01-04 10:16:49', 'completed', '', NULL),
 (412, 0, '89.123.37.241', 'Java/1.6.0_22', 2134, 2307, '', '2017-01-04 10:16:51', 'completed', '', NULL),
 (413, 0, '89.123.37.241', 'Java/1.6.0_22', 2161, 2162, '', '2017-01-04 10:16:53', 'completed', '', NULL),
 (414, 0, '89.123.37.241', 'Java/1.6.0_22', 2342, 2349, '', '2017-01-04 10:16:54', 'completed', '', NULL),
 (415, 0, '178.83.153.172', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/22.0.141836113 Mobile/14C92 Safari/600.1.4', 2146, 2149, '', '2017-01-04 11:32:17', 'completed', '', NULL),
 (416, 0, '188.61.66.230', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2333, 2334, '', '2017-01-04 17:22:07', 'completed', '', NULL),
 (417, 0, '188.61.66.230', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2333, 2334, '', '2017-01-04 17:59:39', 'completed', '', NULL),
 (418, 0, '91.138.30.58', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2146, 2149, '', '2017-01-04 20:02:49', 'completed', '', NULL),
 (419, 0, '85.3.92.138', 'Mozilla/5.0 (Mobile; Windows Phone 8.1; Android 4.0; ARM; Trident/7.0; Touch; rv:11.0; IEMobile/11.0; NOKIA; Lumia 630) like iPhone OS 7_0_3 Mac OS X AppleWebKit/537 (KHTML, like Gecko) Mobile Safari', 2140, 2141, '', '2017-01-04 21:15:19', 'completed', '', NULL),
 (420, 0, '173.165.244.221', 'Java/1.8.0_31', 2146, 2149, '', '2017-01-04 21:28:02', 'completed', '', NULL),
 (421, 0, '173.165.244.221', 'Java/1.8.0_31', 2333, 2334, '', '2017-01-04 21:28:03', 'completed', '', NULL),
 (422, 0, '173.165.244.221', 'Java/1.8.0_31', 2140, 2141, '', '2017-01-04 21:28:12', 'completed', '', NULL),
 (423, 0, '173.165.244.221', 'Java/1.8.0_31', 2336, 2337, '', '2017-01-04 21:28:16', 'completed', '', NULL),
 (424, 0, '173.165.244.221', 'Java/1.8.0_31', 2339, 2340, '', '2017-01-04 21:28:22', 'completed', '', NULL),
 (425, 0, '173.165.244.221', 'Java/1.8.0_31', 2130, 2133, '', '2017-01-04 21:28:24', 'completed', '', NULL),
 (426, 0, '173.165.244.221', 'Java/1.8.0_31', 2134, 2307, '', '2017-01-04 21:28:27', 'completed', '', NULL),
 (427, 0, '173.165.244.221', 'Java/1.8.0_31', 2161, 2162, '', '2017-01-04 21:28:31', 'completed', '', NULL),
 (428, 0, '173.165.244.221', 'Java/1.8.0_31', 2342, 2349, '', '2017-01-04 21:28:34', 'completed', '', NULL),
 (429, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2342, 2349, '', '2017-01-04 21:43:38', 'completed', '', NULL),
 (430, 0, '80.218.10.62', 'Mozilla/5.0 (iPad; CPU OS 8_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/21.4.141508723 Mobile/12F69 Safari/600.1.4', 2140, 2141, '', '2017-01-04 23:16:06', 'completed', '', NULL),
 (431, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2130, 2133, '', '2017-01-04 23:17:38', 'completed', '', NULL),
 (432, 0, '178.199.181.136', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2342, 2349, '', '2017-01-05 03:37:36', 'completed', '', NULL),
 (433, 0, '178.199.181.136', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2134, 2307, '', '2017-01-05 03:42:43', 'completed', '', NULL),
 (434, 0, '178.199.181.136', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2130, 2133, '', '2017-01-05 03:44:56', 'completed', '', NULL),
 (435, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2134, 2307, '', '2017-01-05 05:25:51', 'completed', '', NULL),
 (436, 0, '62.202.31.225', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-05 12:22:31', 'completed', '', NULL),
 (437, 0, '31.164.149.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-01-05 17:56:55', 'completed', '', NULL),
 (438, 0, '31.164.149.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-01-05 17:58:16', 'completed', '', NULL),
 (439, 0, '83.78.233.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/600.6.3 (KHTML, like Gecko) Version/7.1.6 Safari/537.85.15', 2140, 2141, '', '2017-01-06 11:59:34', 'completed', '', NULL),
 (440, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-06 14:50:08', 'completed', '', NULL),
 (441, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-06 14:50:09', 'completed', '', NULL),
 (442, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-06 14:50:14', 'completed', '', NULL),
 (443, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-06 14:50:15', 'completed', '', NULL),
 (444, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-06 14:50:18', 'completed', '', NULL),
 (445, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-06 14:50:20', 'completed', '', NULL),
 (446, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-06 14:50:22', 'completed', '', NULL),
 (447, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-06 14:50:24', 'completed', '', NULL),
 (448, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-06 14:50:25', 'completed', '', NULL),
 (449, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2226, 2228, '', '2017-01-06 15:30:12', 'failed', 'Datei nicht gefunden.', NULL),
 (450, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-01-07 04:36:51', 'completed', '', NULL),
 (451, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-01-07 04:36:57', 'completed', '', NULL),
 (452, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-01-07 04:37:02', 'completed', '', NULL),
 (453, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-01-07 04:37:23', 'completed', '', NULL),
 (454, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-01-07 04:37:26', 'completed', '', NULL),
 (455, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-01-07 04:37:32', 'completed', '', NULL),
 (456, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-01-07 04:37:37', 'completed', '', NULL),
 (457, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-01-07 04:38:07', 'completed', '', NULL),
 (458, 0, '45.55.169.26', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-01-07 04:38:42', 'completed', '', NULL),
 (459, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2307, '', '2017-01-07 13:54:05', 'completed', '', NULL),
 (460, 0, '81.63.182.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:46.0) Gecko/20100101 Firefox/46.0', 2333, 2334, '', '2017-01-07 14:53:47', 'completed', '', NULL),
 (461, 0, '85.4.136.116', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2333, 2334, '', '2017-01-07 15:00:07', 'completed', '', NULL),
 (462, 0, '178.197.232.199', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2336, 2337, '', '2017-01-07 22:16:47', 'completed', '', NULL),
 (463, 0, '178.197.232.199', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2339, 2340, '', '2017-01-07 22:18:06', 'completed', '', NULL),
 (464, 0, '178.197.232.199', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2140, 2141, '', '2017-01-07 22:32:59', 'completed', '', NULL),
 (465, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2333, 2334, '', '2017-01-08 04:07:19', 'completed', '', NULL),
 (466, 0, '178.197.237.59', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2339, 2340, '', '2017-01-08 15:18:03', 'completed', '', NULL),
 (467, 0, '213.55.176.232', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2342, 2349, '', '2017-01-08 18:49:53', 'completed', '', NULL),
 (468, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-01-08 23:00:02', 'completed', '', NULL),
 (469, 0, '178.194.133.211', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-09 07:28:02', 'completed', '', NULL),
 (470, 0, '178.194.133.211', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-09 07:31:13', 'completed', '', NULL),
 (471, 0, '178.194.133.211', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-09 07:31:59', 'completed', '', NULL),
 (472, 0, '146.185.65.197', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-09 09:06:01', 'completed', '', NULL),
 (473, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2146, 2149, '', '2017-01-09 13:34:16', 'completed', '', NULL),
 (474, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-09 15:44:14', 'completed', '', NULL),
 (475, 0, '62.202.188.194', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BPH9 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2342, 2349, '', '2017-01-09 22:39:30', 'completed', '', NULL),
 (476, 0, '62.202.188.194', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BPH9 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2342, 2349, '', '2017-01-09 22:49:02', 'completed', '', NULL),
 (477, 0, '88.0.180.176', 'Java/1.8.0_51', 2146, 2149, '', '2017-01-10 03:29:30', 'completed', '', NULL),
 (478, 0, '88.0.180.176', 'Java/1.8.0_51', 2333, 2334, '', '2017-01-10 03:29:31', 'completed', '', NULL),
 (479, 0, '88.0.180.176', 'Java/1.8.0_51', 2140, 2141, '', '2017-01-10 03:29:34', 'completed', '', NULL),
 (480, 0, '88.0.180.176', 'Java/1.8.0_51', 2336, 2337, '', '2017-01-10 03:29:36', 'completed', '', NULL),
 (481, 0, '88.0.180.176', 'Java/1.8.0_51', 2339, 2340, '', '2017-01-10 03:29:38', 'completed', '', NULL),
 (482, 0, '88.0.180.176', 'Java/1.8.0_51', 2130, 2133, '', '2017-01-10 03:29:40', 'completed', '', NULL),
 (483, 0, '88.0.180.176', 'Java/1.8.0_51', 2134, 2307, '', '2017-01-10 03:29:42', 'completed', '', NULL),
 (484, 0, '88.0.180.176', 'Java/1.8.0_51', 2161, 2162, '', '2017-01-10 03:29:44', 'completed', '', NULL),
 (485, 0, '88.0.180.176', 'Java/1.8.0_51', 2342, 2349, '', '2017-01-10 03:29:46', 'completed', '', NULL),
 (486, 0, '194.150.244.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-10 09:09:26', 'completed', '', NULL),
 (487, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-10 09:09:26', 'completed', '', NULL),
 (488, 0, '194.150.244.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-10 09:26:08', 'completed', '', NULL),
 (489, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-10 09:26:08', 'completed', '', NULL),
 (490, 0, '194.150.244.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-10 09:27:32', 'completed', '', NULL),
 (491, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-10 09:27:33', 'completed', '', NULL),
 (492, 0, '194.150.244.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-10 10:07:48', 'completed', '', NULL),
 (493, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2339, 2340, '', '2017-01-10 14:02:11', 'completed', '', NULL),
 (494, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2146, 2149, '', '2017-01-10 14:04:51', 'completed', '', NULL),
 (495, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2336, 2337, '', '2017-01-10 14:51:14', 'completed', '', NULL),
 (496, 0, '178.192.235.188', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-10 17:18:12', 'completed', '', NULL),
 (497, 0, '85.1.245.221', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-10 18:28:52', 'completed', '', NULL),
 (498, 0, '80.255.12.237', 'Java/1.8.0_112', 2146, 2149, '', '2017-01-11 04:56:59', 'completed', '', NULL),
 (499, 0, '80.255.12.237', 'Java/1.8.0_112', 2333, 2334, '', '2017-01-11 04:56:59', 'completed', '', NULL),
 (500, 0, '80.255.12.237', 'Java/1.8.0_112', 2140, 2141, '', '2017-01-11 04:57:04', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(501, 0, '80.255.12.237', 'Java/1.8.0_112', 2336, 2337, '', '2017-01-11 04:57:06', 'completed', '', NULL),
 (502, 0, '80.255.12.237', 'Java/1.8.0_112', 2339, 2340, '', '2017-01-11 04:57:08', 'completed', '', NULL),
 (503, 0, '80.255.12.237', 'Java/1.8.0_112', 2130, 2133, '', '2017-01-11 04:57:10', 'completed', '', NULL),
 (504, 0, '80.255.12.237', 'Java/1.8.0_112', 2134, 2307, '', '2017-01-11 04:57:12', 'completed', '', NULL),
 (505, 0, '80.255.12.237', 'Java/1.8.0_112', 2161, 2162, '', '2017-01-11 04:57:13', 'completed', '', NULL),
 (506, 0, '80.255.12.237', 'Java/1.8.0_112', 2342, 2349, '', '2017-01-11 04:57:14', 'completed', '', NULL),
 (507, 0, '188.155.56.54', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-01-11 10:59:37', 'completed', '', NULL),
 (508, 0, '217.162.133.104', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-11 11:22:17', 'completed', '', NULL),
 (509, 0, '217.162.133.104', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-11 11:23:04', 'completed', '', NULL),
 (510, 0, '81.221.12.232', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-11 13:48:16', 'completed', '', NULL),
 (511, 0, '81.221.12.232', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-11 13:51:54', 'completed', '', NULL),
 (512, 0, '81.221.12.232', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-11 13:52:36', 'completed', '', NULL),
 (513, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2161, 2162, '', '2017-01-11 13:54:39', 'completed', '', NULL),
 (514, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-11 14:34:39', 'completed', '', NULL),
 (515, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-11 14:34:41', 'completed', '', NULL),
 (516, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-11 14:34:48', 'completed', '', NULL),
 (517, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-11 14:34:50', 'completed', '', NULL),
 (518, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-11 14:34:52', 'completed', '', NULL),
 (519, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-11 14:34:54', 'completed', '', NULL),
 (520, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-11 14:34:56', 'completed', '', NULL),
 (521, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-11 14:35:01', 'completed', '', NULL),
 (522, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-11 14:35:03', 'completed', '', NULL),
 (523, 0, '158.181.98.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/537.86.7', 2130, 2133, '', '2017-01-11 14:57:50', 'completed', '', NULL),
 (524, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-01-11 15:04:09', 'completed', '', NULL),
 (525, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-01-11 15:08:54', 'completed', '', NULL),
 (526, 0, '158.181.98.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/537.86.7', 2134, 2307, '', '2017-01-11 15:09:28', 'completed', '', NULL),
 (527, 0, '213.55.176.137', 'Mozilla/5.0 (iPhone; CPU iPhone OS 5_1 like Mac OS X) AppleWebKit/534.46 (KHTML, like Gecko) Version/5.1 Mobile/9B179 Safari/7534.48.3', 2336, 2337, '', '2017-01-11 16:07:14', 'completed', '', NULL),
 (528, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2130, 2133, '', '2017-01-11 20:08:29', 'completed', '', NULL),
 (529, 0, '92.104.230.218', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2140, 2141, '', '2017-01-11 21:25:34', 'completed', '', NULL),
 (530, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-12 07:30:08', 'completed', '', NULL),
 (531, 0, '92.106.240.84', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-01-12 10:45:12', 'completed', '', NULL),
 (532, 0, '151.248.128.173', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-01-12 14:00:59', 'completed', '', NULL),
 (533, 0, '151.248.128.173', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-01-12 14:03:19', 'completed', '', NULL),
 (534, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-12 14:08:14', 'completed', '', NULL),
 (535, 0, '92.106.240.84', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/600.5.17 (KHTML, like Gecko) Version/8.0.5 Safari/600.5.17', 2146, 2149, '', '2017-01-12 14:16:27', 'completed', '', NULL),
 (536, 0, '92.106.240.84', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/600.5.17 (KHTML, like Gecko) Version/8.0.5 Safari/600.5.17', 2146, 2149, '', '2017-01-12 14:19:25', 'completed', '', NULL),
 (537, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-01-12 16:43:30', 'completed', '', NULL),
 (538, 0, '108.58.36.131', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-13 08:59:19', 'completed', '', NULL),
 (539, 0, '108.58.36.131', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-13 08:59:20', 'completed', '', NULL),
 (540, 0, '108.58.36.131', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-13 08:59:21', 'completed', '', NULL),
 (541, 0, '108.58.36.131', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-13 08:59:24', 'completed', '', NULL),
 (542, 0, '108.58.36.131', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-13 08:59:25', 'completed', '', NULL),
 (543, 0, '108.58.36.131', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-13 08:59:27', 'completed', '', NULL),
 (544, 0, '108.58.36.131', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-13 08:59:29', 'completed', '', NULL),
 (545, 0, '108.58.36.131', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-13 08:59:30', 'completed', '', NULL),
 (546, 0, '108.58.36.131', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-13 08:59:32', 'completed', '', NULL),
 (547, 0, '108.58.36.131', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-13 08:59:34', 'completed', '', NULL),
 (548, 0, '108.58.36.131', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-13 08:59:36', 'completed', '', NULL),
 (549, 0, '108.58.36.131', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-13 08:59:38', 'completed', '', NULL),
 (550, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-01-13 14:24:36', 'completed', '', NULL),
 (551, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-13 14:26:38', 'completed', '', NULL),
 (552, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-01-13 14:54:15', 'completed', '', NULL),
 (553, 0, '195.65.154.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-01-13 15:01:58', 'completed', '', NULL),
 (554, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2134, 2307, '', '2017-01-14 01:49:34', 'completed', '', NULL),
 (555, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2146, 2149, '', '2017-01-14 03:01:31', 'completed', '', NULL),
 (556, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2017-01-14 03:22:28', 'completed', '', NULL),
 (557, 0, '77.56.27.103', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:50.0) Gecko/20100101 Firefox/50.0', 2134, 2307, '', '2017-01-14 08:41:20', 'completed', '', NULL),
 (558, 0, '85.5.240.182', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-14 11:01:22', 'completed', '', NULL),
 (559, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2342, 2349, '', '2017-01-14 12:16:48', 'completed', '', NULL),
 (560, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2140, 2141, '', '2017-01-14 12:31:20', 'completed', '', NULL),
 (561, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1844, 1845, '', '2017-01-14 13:14:14', 'completed', '', NULL),
 (562, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1837, 1839, '', '2017-01-14 13:18:39', 'completed', '', NULL),
 (563, 0, '213.180.191.82', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-01-14 13:32:19', 'completed', '', NULL),
 (564, 0, '178.195.127.250', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.95 Safari/537.36', 2333, 2334, '', '2017-01-14 15:55:38', 'completed', '', NULL),
 (565, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2017-01-15 01:14:03', 'completed', '', NULL),
 (566, 0, '178.197.232.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-15 09:16:02', 'completed', '', NULL),
 (567, 0, '68.180.229.163', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2017-01-15 10:49:16', 'completed', '', NULL),
 (568, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2336, 2337, '', '2017-01-15 11:40:50', 'completed', '', NULL),
 (569, 0, '158.181.109.12', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2128, 2367, '', '2017-01-15 11:41:54', 'completed', '', NULL),
 (570, 0, '194.209.190.122', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-01-16 11:08:06', 'completed', '', NULL),
 (571, 0, '194.209.190.122', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-16 11:08:31', 'completed', '', NULL),
 (572, 0, '62.202.183.142', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-01-16 13:41:59', 'completed', '', NULL),
 (573, 0, '89.248.148.225', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2333, 2334, '', '2017-01-16 13:49:21', 'completed', '', NULL),
 (574, 0, '89.248.148.225', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2128, 2367, '', '2017-01-16 13:50:34', 'completed', '', NULL),
 (575, 0, '89.248.148.225', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2146, 2149, '', '2017-01-16 13:54:50', 'completed', '', NULL),
 (576, 0, '62.2.210.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.116 Safari/537.36', 2134, 2307, '', '2017-01-16 15:42:10', 'completed', '', NULL),
 (577, 0, '62.2.201.50', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-16 17:10:23', 'completed', '', NULL),
 (578, 0, '68.180.230.25', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2333, 2334, '', '2017-01-16 19:21:30', 'completed', '', NULL),
 (579, 0, '84.146.244.32', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-16 19:52:03', 'completed', '', NULL),
 (580, 0, '84.146.244.32', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-16 19:53:33', 'completed', '', NULL),
 (581, 0, '84.146.244.32', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-16 19:54:26', 'completed', '', NULL),
 (582, 0, '37.48.119.133', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-16 19:58:34', 'completed', '', NULL),
 (583, 0, '37.48.119.133', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-16 19:58:35', 'completed', '', NULL),
 (584, 0, '37.48.119.133', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-16 19:58:36', 'completed', '', NULL),
 (585, 0, '37.48.119.133', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-16 19:58:38', 'completed', '', NULL),
 (586, 0, '37.48.119.133', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-16 19:58:39', 'completed', '', NULL),
 (587, 0, '37.48.119.133', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-16 19:58:40', 'completed', '', NULL),
 (588, 0, '37.48.119.133', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-16 19:58:41', 'completed', '', NULL),
 (589, 0, '37.48.119.133', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-16 19:58:42', 'completed', '', NULL),
 (590, 0, '37.48.119.133', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-16 19:58:43', 'completed', '', NULL),
 (591, 0, '37.48.119.133', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-16 19:58:44', 'completed', '', NULL),
 (592, 0, '37.48.119.133', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-16 19:58:45', 'completed', '', NULL),
 (593, 0, '37.48.119.133', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-16 19:58:46', 'completed', '', NULL),
 (594, 0, '83.77.82.240', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 1844, 1845, '', '2017-01-16 21:53:58', 'completed', '', NULL),
 (595, 0, '83.77.82.240', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-01-16 22:17:10', 'completed', '', NULL),
 (596, 0, '83.77.82.240', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-01-16 22:19:28', 'completed', '', NULL),
 (597, 0, '5.145.79.184', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-ch; SM-T310 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 1837, 1839, '', '2017-01-16 23:31:24', 'completed', '', NULL),
 (598, 0, '5.145.79.184', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-ch; SM-T310 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 1844, 1845, '', '2017-01-16 23:31:54', 'completed', '', NULL),
 (599, 0, '5.145.79.184', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-ch; SM-T310 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 2146, 2149, '', '2017-01-16 23:32:12', 'completed', '', NULL),
 (600, 0, '5.145.79.184', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-ch; SM-T310 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 2339, 2340, '', '2017-01-16 23:34:44', 'completed', '', NULL),
 (601, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-17 14:11:37', 'completed', '', NULL),
 (602, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-17 14:12:46', 'completed', '', NULL),
 (603, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-17 14:17:02', 'completed', '', NULL),
 (604, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-17 14:25:38', 'completed', '', NULL),
 (605, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-01-17 14:29:21', 'completed', '', NULL),
 (606, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-17 14:31:17', 'completed', '', NULL),
 (607, 0, '84.227.222.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2336, 2337, '', '2017-01-17 15:25:43', 'completed', '', NULL),
 (608, 0, '178.85.206.151', 'Java/1.8.0_111', 2128, 2367, '', '2017-01-17 15:49:42', 'completed', '', NULL),
 (609, 0, '178.85.206.151', 'Java/1.8.0_111', 2146, 2149, '', '2017-01-17 15:49:44', 'completed', '', NULL),
 (610, 0, '178.85.206.151', 'Java/1.8.0_111', 2333, 2334, '', '2017-01-17 15:49:45', 'completed', '', NULL),
 (611, 0, '178.85.206.151', 'Java/1.8.0_111', 2140, 2141, '', '2017-01-17 15:49:47', 'completed', '', NULL),
 (612, 0, '178.85.206.151', 'Java/1.8.0_111', 2336, 2337, '', '2017-01-17 15:49:49', 'completed', '', NULL),
 (613, 0, '178.85.206.151', 'Java/1.8.0_111', 1837, 1839, '', '2017-01-17 15:49:51', 'completed', '', NULL),
 (614, 0, '178.85.206.151', 'Java/1.8.0_111', 1844, 1845, '', '2017-01-17 15:49:52', 'completed', '', NULL),
 (615, 0, '178.85.206.151', 'Java/1.8.0_111', 2339, 2340, '', '2017-01-17 15:49:53', 'completed', '', NULL),
 (616, 0, '178.85.206.151', 'Java/1.8.0_111', 2130, 2133, '', '2017-01-17 15:49:54', 'completed', '', NULL),
 (617, 0, '178.85.206.151', 'Java/1.8.0_111', 2134, 2307, '', '2017-01-17 15:49:56', 'completed', '', NULL),
 (618, 0, '178.85.206.151', 'Java/1.8.0_111', 2161, 2162, '', '2017-01-17 15:49:58', 'completed', '', NULL),
 (619, 0, '178.85.206.151', 'Java/1.8.0_111', 2342, 2349, '', '2017-01-17 15:49:59', 'completed', '', NULL),
 (620, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2161, 2162, '', '2017-01-17 18:53:20', 'completed', '', NULL),
 (621, 0, '173.243.112.169', 'Java/1.6.0_04', 2128, 2367, '', '2017-01-17 19:49:08', 'completed', '', NULL),
 (622, 0, '173.243.112.169', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-17 19:49:10', 'completed', '', NULL),
 (623, 0, '173.243.112.169', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-17 19:49:12', 'completed', '', NULL),
 (624, 0, '173.243.112.169', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-17 19:49:23', 'completed', '', NULL),
 (625, 0, '173.243.112.169', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-17 19:49:41', 'completed', '', NULL),
 (626, 0, '173.243.112.169', 'Java/1.6.0_04', 1837, 1839, '', '2017-01-17 19:49:49', 'completed', '', NULL),
 (627, 0, '173.243.112.169', 'Java/1.6.0_04', 1844, 1845, '', '2017-01-17 19:49:57', 'completed', '', NULL),
 (628, 0, '173.243.112.169', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-17 19:50:10', 'completed', '', NULL),
 (629, 0, '173.243.112.169', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-17 19:50:25', 'completed', '', NULL),
 (630, 0, '173.243.112.169', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-17 19:50:52', 'completed', '', NULL),
 (631, 0, '173.243.112.169', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-17 19:51:01', 'completed', '', NULL),
 (632, 0, '173.243.112.169', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-17 19:51:09', 'completed', '', NULL),
 (633, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2339, 2340, '', '2017-01-17 20:12:16', 'completed', '', NULL),
 (634, 0, '5.145.20.162', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2134, 2307, '', '2017-01-17 21:20:31', 'completed', '', NULL),
 (635, 0, '178.195.69.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2128, 2367, '', '2017-01-17 21:21:37', 'completed', '', NULL),
 (636, 0, '68.180.230.25', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2128, 2367, '', '2017-01-18 03:32:53', 'completed', '', NULL),
 (637, 0, '85.25.210.41', 'Mozilla/5.0 (compatible; seoscanners.net/1; +spider@seoscanners.net)', 2342, 2349, '', '2017-01-18 05:41:15', 'completed', '', NULL),
 (638, 0, '178.85.206.151', 'Java/1.8.0_111', 2128, 2367, '', '2017-01-18 06:10:56', 'completed', '', NULL),
 (639, 0, '178.85.206.151', 'Java/1.8.0_111', 2146, 2149, '', '2017-01-18 06:10:57', 'completed', '', NULL),
 (640, 0, '178.85.206.151', 'Java/1.8.0_111', 2333, 2334, '', '2017-01-18 06:10:58', 'completed', '', NULL),
 (641, 0, '178.85.206.151', 'Java/1.8.0_111', 2140, 2141, '', '2017-01-18 06:11:01', 'completed', '', NULL),
 (642, 0, '178.85.206.151', 'Java/1.8.0_111', 2336, 2337, '', '2017-01-18 06:11:02', 'completed', '', NULL),
 (643, 0, '178.85.206.151', 'Java/1.8.0_111', 1837, 1839, '', '2017-01-18 06:11:04', 'completed', '', NULL),
 (644, 0, '178.85.206.151', 'Java/1.8.0_111', 1844, 1845, '', '2017-01-18 06:11:06', 'completed', '', NULL),
 (645, 0, '178.85.206.151', 'Java/1.8.0_111', 2339, 2340, '', '2017-01-18 06:11:07', 'completed', '', NULL),
 (646, 0, '178.85.206.151', 'Java/1.8.0_111', 2130, 2133, '', '2017-01-18 06:11:09', 'completed', '', NULL),
 (647, 0, '178.85.206.151', 'Java/1.8.0_111', 2134, 2307, '', '2017-01-18 06:11:11', 'completed', '', NULL),
 (648, 0, '178.85.206.151', 'Java/1.8.0_111', 2161, 2162, '', '2017-01-18 06:11:13', 'completed', '', NULL),
 (649, 0, '178.85.206.151', 'Java/1.8.0_111', 2342, 2349, '', '2017-01-18 06:11:14', 'completed', '', NULL),
 (650, 0, '158.181.98.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/537.86.7', 2134, 2307, '', '2017-01-18 11:21:38', 'completed', '', NULL),
 (651, 0, '31.164.149.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-18 11:23:59', 'completed', '', NULL),
 (652, 0, '31.164.149.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-01-18 11:24:06', 'completed', '', NULL),
 (653, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-18 11:26:02', 'completed', '', NULL),
 (654, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-18 11:26:48', 'completed', '', NULL),
 (655, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1844, 1845, '', '2017-01-18 11:28:17', 'completed', '', NULL),
 (656, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1837, 1839, '', '2017-01-18 11:28:56', 'completed', '', NULL),
 (657, 0, '31.164.149.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-01-18 11:30:07', 'completed', '', NULL),
 (658, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1837, 1839, '', '2017-01-18 11:30:23', 'completed', '', NULL),
 (659, 0, '185.32.221.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2339, 2340, '', '2017-01-18 11:30:41', 'completed', '', NULL),
 (660, 0, '62.167.42.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2342, 2349, '', '2017-01-18 11:33:10', 'completed', '', NULL),
 (661, 0, '62.167.42.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2134, 2307, '', '2017-01-18 11:38:12', 'completed', '', NULL),
 (662, 0, '62.167.42.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2130, 2133, '', '2017-01-18 11:39:13', 'completed', '', NULL),
 (663, 0, '185.145.108.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-01-18 12:31:52', 'completed', '', NULL),
 (664, 0, '62.167.42.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2342, 2349, '', '2017-01-18 13:25:58', 'completed', '', NULL),
 (665, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-01-18 14:25:22', 'completed', '', NULL),
 (666, 0, '68.180.230.25', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2294, 2295, '', '2017-01-18 14:44:39', 'failed', 'Datei nicht gefunden.', NULL),
 (667, 0, '178.38.129.39', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-18 16:15:45', 'completed', '', NULL),
 (668, 0, '168.224.160.22', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-18 17:10:14', 'completed', '', NULL),
 (669, 0, '168.224.160.22', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-18 17:10:16', 'completed', '', NULL),
 (670, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1844, 1845, '', '2017-01-18 17:45:02', 'completed', '', NULL),
 (671, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-18 17:46:33', 'completed', '', NULL),
 (672, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-18 17:49:15', 'completed', '', NULL),
 (673, 0, '81.137.223.148', 'Java/1.6.0_24', 2128, 2367, '', '2017-01-19 00:13:06', 'completed', '', NULL),
 (674, 0, '81.137.223.148', 'Java/1.6.0_24', 2146, 2149, '', '2017-01-19 00:13:07', 'completed', '', NULL),
 (675, 0, '81.137.223.148', 'Java/1.6.0_24', 2333, 2334, '', '2017-01-19 00:13:07', 'completed', '', NULL),
 (676, 0, '81.137.223.148', 'Java/1.6.0_24', 2140, 2141, '', '2017-01-19 00:13:10', 'completed', '', NULL),
 (677, 0, '81.137.223.148', 'Java/1.6.0_24', 2336, 2337, '', '2017-01-19 00:13:11', 'completed', '', NULL),
 (678, 0, '81.137.223.148', 'Java/1.6.0_24', 1837, 1839, '', '2017-01-19 00:13:12', 'completed', '', NULL),
 (679, 0, '81.137.223.148', 'Java/1.6.0_24', 1844, 1845, '', '2017-01-19 00:13:13', 'completed', '', NULL),
 (680, 0, '81.137.223.148', 'Java/1.6.0_24', 2339, 2340, '', '2017-01-19 00:13:14', 'completed', '', NULL),
 (681, 0, '81.137.223.148', 'Java/1.6.0_24', 2130, 2133, '', '2017-01-19 00:13:15', 'completed', '', NULL),
 (682, 0, '81.137.223.148', 'Java/1.6.0_24', 2134, 2307, '', '2017-01-19 00:13:16', 'completed', '', NULL),
 (683, 0, '81.137.223.148', 'Java/1.6.0_24', 2161, 2162, '', '2017-01-19 00:13:18', 'completed', '', NULL),
 (684, 0, '81.137.223.148', 'Java/1.6.0_24', 2342, 2349, '', '2017-01-19 00:13:19', 'completed', '', NULL),
 (685, 0, '195.65.152.103', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; MASBJS; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-19 08:46:35', 'completed', '', NULL),
 (686, 0, '178.197.228.138', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_4 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G35 Safari/601.1', 2140, 2141, '', '2017-01-19 10:55:34', 'completed', '', NULL),
 (687, 0, '46.126.116.157', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2140, 2141, '', '2017-01-19 15:45:36', 'completed', '', NULL),
 (688, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 1844, 1845, '', '2017-01-19 18:39:42', 'completed', '', NULL),
 (689, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 1837, 1839, '', '2017-01-19 18:40:52', 'completed', '', NULL),
 (690, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2017-01-19 18:41:01', 'completed', '', NULL),
 (691, 0, '31.10.143.249', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2140, 2141, '', '2017-01-20 12:08:57', 'completed', '', NULL),
 (692, 0, '31.10.143.249', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2336, 2337, '', '2017-01-20 12:10:13', 'completed', '', NULL),
 (693, 0, '188.62.119.98', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-01-20 13:23:51', 'completed', '', NULL),
 (694, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-20 13:32:48', 'completed', '', NULL),
 (695, 0, '80.114.90.93', 'Java/1.8.0_73', 2128, 2367, '', '2017-01-20 15:19:48', 'completed', '', NULL),
 (696, 0, '80.114.90.93', 'Java/1.8.0_73', 2146, 2149, '', '2017-01-20 15:19:52', 'completed', '', NULL),
 (697, 0, '80.114.90.93', 'Java/1.8.0_73', 2333, 2334, '', '2017-01-20 15:19:55', 'completed', '', NULL),
 (698, 0, '80.114.90.93', 'Java/1.8.0_73', 2140, 2141, '', '2017-01-20 15:20:07', 'completed', '', NULL),
 (699, 0, '80.114.90.93', 'Java/1.8.0_73', 2336, 2337, '', '2017-01-20 15:20:10', 'completed', '', NULL),
 (700, 0, '80.114.90.93', 'Java/1.8.0_73', 1837, 1839, '', '2017-01-20 15:20:16', 'completed', '', NULL),
 (701, 0, '80.114.90.93', 'Java/1.8.0_73', 1844, 1845, '', '2017-01-20 15:20:19', 'completed', '', NULL),
 (702, 0, '80.114.90.93', 'Java/1.8.0_73', 2339, 2340, '', '2017-01-20 15:20:20', 'completed', '', NULL),
 (703, 0, '80.114.90.93', 'Java/1.8.0_73', 2130, 2133, '', '2017-01-20 15:20:26', 'completed', '', NULL),
 (704, 0, '80.114.90.93', 'Java/1.8.0_73', 2134, 2307, '', '2017-01-20 15:20:32', 'completed', '', NULL),
 (705, 0, '80.114.90.93', 'Java/1.8.0_73', 2161, 2162, '', '2017-01-20 15:20:37', 'completed', '', NULL),
 (706, 0, '80.114.90.93', 'Java/1.8.0_73', 2342, 2349, '', '2017-01-20 15:20:42', 'completed', '', NULL),
 (707, 0, '83.55.33.31', 'Java/1.8.0_65', 2128, 2367, '', '2017-01-21 05:40:07', 'completed', '', NULL),
 (708, 0, '83.55.33.31', 'Java/1.8.0_65', 2146, 2149, '', '2017-01-21 05:40:09', 'completed', '', NULL),
 (709, 0, '83.55.33.31', 'Java/1.8.0_65', 2333, 2334, '', '2017-01-21 05:40:10', 'completed', '', NULL),
 (710, 0, '83.55.33.31', 'Java/1.8.0_65', 2140, 2141, '', '2017-01-21 05:40:13', 'completed', '', NULL),
 (711, 0, '83.55.33.31', 'Java/1.8.0_65', 2336, 2337, '', '2017-01-21 05:40:14', 'completed', '', NULL),
 (712, 0, '83.55.33.31', 'Java/1.8.0_65', 1837, 1839, '', '2017-01-21 05:40:16', 'completed', '', NULL),
 (713, 0, '83.55.33.31', 'Java/1.8.0_65', 1844, 1845, '', '2017-01-21 05:40:17', 'completed', '', NULL),
 (714, 0, '83.55.33.31', 'Java/1.8.0_65', 2339, 2340, '', '2017-01-21 05:40:18', 'completed', '', NULL),
 (715, 0, '83.55.33.31', 'Java/1.8.0_65', 2130, 2133, '', '2017-01-21 05:40:20', 'completed', '', NULL),
 (716, 0, '83.55.33.31', 'Java/1.8.0_65', 2134, 2307, '', '2017-01-21 05:40:22', 'completed', '', NULL),
 (717, 0, '83.55.33.31', 'Java/1.8.0_65', 2161, 2162, '', '2017-01-21 05:40:25', 'completed', '', NULL),
 (718, 0, '83.55.33.31', 'Java/1.8.0_65', 2342, 2349, '', '2017-01-21 05:40:26', 'completed', '', NULL),
 (719, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 1844, 1845, '', '2017-01-21 08:28:29', 'completed', '', NULL),
 (720, 0, '213.55.184.242', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 1844, 1845, '', '2017-01-21 14:43:09', 'completed', '', NULL),
 (721, 0, '188.93.37.197', 'Java/1.6.0_04', 2128, 2367, '', '2017-01-21 15:57:31', 'completed', '', NULL),
 (722, 0, '188.93.37.197', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-21 15:57:32', 'completed', '', NULL),
 (723, 0, '188.93.37.197', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-21 15:57:33', 'completed', '', NULL),
 (724, 0, '188.93.37.197', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-21 15:57:35', 'completed', '', NULL),
 (725, 0, '188.93.37.197', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-21 15:57:37', 'completed', '', NULL),
 (726, 0, '188.93.37.197', 'Java/1.6.0_04', 1837, 1839, '', '2017-01-21 15:57:38', 'completed', '', NULL),
 (727, 0, '188.93.37.197', 'Java/1.6.0_04', 1844, 1845, '', '2017-01-21 15:57:39', 'completed', '', NULL),
 (728, 0, '188.93.37.197', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-21 15:57:40', 'completed', '', NULL),
 (729, 0, '188.93.37.197', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-21 15:57:42', 'completed', '', NULL),
 (730, 0, '188.93.37.197', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-21 15:57:43', 'completed', '', NULL),
 (731, 0, '188.93.37.197', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-21 15:57:46', 'completed', '', NULL),
 (732, 0, '188.93.37.197', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-21 15:57:47', 'completed', '', NULL),
 (733, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-21 16:44:52', 'completed', '', NULL),
 (734, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-21 16:44:53', 'completed', '', NULL),
 (735, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 1844, 1845, '', '2017-01-22 08:16:30', 'completed', '', NULL),
 (736, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-22 08:29:26', 'completed', '', NULL),
 (737, 0, '62.167.42.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2146, 2149, '', '2017-01-22 10:50:10', 'completed', '', NULL),
 (738, 0, '151.248.135.201', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-22 11:19:44', 'completed', '', NULL),
 (739, 0, '83.78.50.50', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1844, 1845, '', '2017-01-22 13:23:10', 'completed', '', NULL),
 (740, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2140, 2141, '', '2017-01-22 16:06:08', 'completed', '', NULL),
 (741, 0, '88.78.203.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-01-22 16:35:50', 'completed', '', NULL),
 (742, 0, '83.78.50.50', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2339, 2340, '', '2017-01-22 16:59:46', 'completed', '', NULL),
 (743, 0, '83.78.50.50', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2339, 2340, '', '2017-01-22 17:04:40', 'completed', '', NULL),
 (744, 0, '178.82.244.139', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-01-22 17:20:50', 'completed', '', NULL),
 (745, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2336, 2337, '', '2017-01-22 17:26:25', 'completed', '', NULL),
 (746, 0, '188.60.0.28', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2333, 2334, '', '2017-01-22 20:59:31', 'completed', '', NULL),
 (747, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-22 21:03:49', 'completed', '', NULL),
 (748, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-22 21:06:31', 'completed', '', NULL),
 (749, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-22 21:24:06', 'completed', '', NULL),
 (750, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-22 21:36:23', 'completed', '', NULL),
 (751, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-22 21:55:06', 'completed', '', NULL),
 (752, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-22 21:58:47', 'completed', '', NULL),
 (753, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-22 22:01:40', 'completed', '', NULL),
 (754, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-22 22:02:26', 'completed', '', NULL),
 (755, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-22 22:03:27', 'completed', '', NULL),
 (756, 0, '178.39.134.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-22 22:12:54', 'completed', '', NULL),
 (757, 0, '178.39.134.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:50.0) Gecko/20100101 Firefox/50.0', 2333, 2334, '', '2017-01-22 22:14:28', 'completed', '', NULL),
 (758, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2339, 2340, '', '2017-01-23 09:44:52', 'completed', '', NULL),
 (759, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2336, 2337, '', '2017-01-23 09:46:52', 'completed', '', NULL),
 (760, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2342, 2349, '', '2017-01-23 09:48:34', 'completed', '', NULL),
 (761, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2333, 2334, '', '2017-01-23 09:50:13', 'completed', '', NULL),
 (762, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-23 10:49:55', 'completed', '', NULL),
 (763, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-23 10:49:55', 'completed', '', NULL),
 (764, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-23 10:52:23', 'completed', '', NULL),
 (765, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-23 10:52:23', 'completed', '', NULL),
 (766, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-23 10:52:36', 'completed', '', NULL),
 (767, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-23 10:52:37', 'completed', '', NULL),
 (768, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-23 11:14:24', 'completed', '', NULL),
 (769, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-01-23 11:14:24', 'completed', '', NULL),
 (770, 0, '83.78.125.75', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-23 12:30:33', 'completed', '', NULL),
 (771, 0, '83.78.125.75', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-23 12:33:40', 'completed', '', NULL),
 (772, 0, '195.154.43.210', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-23 13:02:12', 'completed', '', NULL),
 (773, 0, '195.154.43.210', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-23 13:02:13', 'completed', '', NULL),
 (774, 0, '195.154.43.210', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-23 13:02:14', 'completed', '', NULL),
 (775, 0, '195.154.43.210', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-23 13:02:17', 'completed', '', NULL),
 (776, 0, '195.154.43.210', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-23 13:02:18', 'completed', '', NULL),
 (777, 0, '195.154.43.210', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-23 13:02:19', 'completed', '', NULL),
 (778, 0, '195.154.43.210', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-23 13:02:20', 'completed', '', NULL),
 (779, 0, '195.154.43.210', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-23 13:02:20', 'completed', '', NULL),
 (780, 0, '195.154.43.210', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-23 13:02:22', 'completed', '', NULL),
 (781, 0, '195.154.43.210', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-23 13:02:24', 'completed', '', NULL),
 (782, 0, '195.154.43.210', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-23 13:02:25', 'completed', '', NULL),
 (783, 0, '195.154.43.210', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-23 13:02:26', 'completed', '', NULL),
 (784, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-23 14:28:30', 'completed', '', NULL),
 (785, 0, '188.61.235.28', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2140, 2141, '', '2017-01-23 14:30:17', 'completed', '', NULL),
 (786, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-23 14:31:54', 'completed', '', NULL),
 (787, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-23 14:32:15', 'completed', '', NULL),
 (788, 0, '188.61.235.28', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2134, 2307, '', '2017-01-23 14:32:34', 'completed', '', NULL),
 (789, 0, '188.61.235.28', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2130, 2133, '', '2017-01-23 14:33:26', 'completed', '', NULL),
 (790, 0, '188.61.235.28', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2146, 2149, '', '2017-01-23 14:34:24', 'completed', '', NULL),
 (791, 0, '95.152.102.162', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2140, 2141, '', '2017-01-23 14:52:36', 'completed', '', NULL),
 (792, 0, '193.246.68.29', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-23 15:18:26', 'completed', '', NULL),
 (793, 0, '193.246.68.29', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-23 15:19:37', 'completed', '', NULL),
 (794, 0, '83.77.204.218', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2128, 2367, '', '2017-01-23 17:30:56', 'completed', '', NULL),
 (795, 0, '83.77.204.218', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2333, 2334, '', '2017-01-23 17:31:34', 'completed', '', NULL),
 (796, 0, '195.154.43.210', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-23 17:52:51', 'completed', '', NULL),
 (797, 0, '195.154.43.210', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-23 17:52:52', 'completed', '', NULL),
 (798, 0, '195.154.43.210', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-23 17:52:53', 'completed', '', NULL),
 (799, 0, '195.154.43.210', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-23 17:52:55', 'completed', '', NULL),
 (800, 0, '195.154.43.210', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-23 17:52:56', 'completed', '', NULL),
 (801, 0, '195.154.43.210', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-23 17:52:57', 'completed', '', NULL),
 (802, 0, '195.154.43.210', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-23 17:52:58', 'completed', '', NULL),
 (803, 0, '195.154.43.210', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-23 17:52:59', 'completed', '', NULL),
 (804, 0, '195.154.43.210', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-23 17:53:00', 'completed', '', NULL),
 (805, 0, '195.154.43.210', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-23 17:53:02', 'completed', '', NULL),
 (806, 0, '195.154.43.210', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-23 17:53:03', 'completed', '', NULL),
 (807, 0, '195.154.43.210', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-23 17:53:04', 'completed', '', NULL),
 (808, 0, '185.29.11.16', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-24 07:27:40', 'completed', '', NULL),
 (809, 0, '185.29.11.16', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-24 07:27:41', 'completed', '', NULL),
 (810, 0, '185.29.11.16', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-24 07:27:42', 'completed', '', NULL),
 (811, 0, '185.29.11.16', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-24 07:27:45', 'completed', '', NULL),
 (812, 0, '185.29.11.16', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-24 07:27:46', 'completed', '', NULL),
 (813, 0, '185.29.11.16', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-24 07:27:48', 'completed', '', NULL),
 (814, 0, '185.29.11.16', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-24 07:27:49', 'completed', '', NULL),
 (815, 0, '185.29.11.16', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-24 07:27:50', 'completed', '', NULL),
 (816, 0, '185.29.11.16', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-24 07:27:52', 'completed', '', NULL),
 (817, 0, '185.29.11.16', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-24 07:27:53', 'completed', '', NULL),
 (818, 0, '185.29.11.16', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-24 07:27:55', 'completed', '', NULL),
 (819, 0, '185.29.11.16', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-24 07:27:57', 'completed', '', NULL),
 (820, 0, '188.155.180.198', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:49.0) Gecko/20100101 Firefox/49.0', 1844, 1845, '', '2017-01-24 14:39:10', 'completed', '', NULL),
 (821, 0, '176.127.150.13', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2130, 2133, '', '2017-01-24 15:17:34', 'completed', '', NULL),
 (822, 0, '188.155.56.54', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 1837, 1839, '', '2017-01-24 17:00:13', 'completed', '', NULL),
 (823, 0, '188.155.56.54', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-01-24 17:06:39', 'completed', '', NULL),
 (824, 0, '188.155.56.54', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2339, 2340, '', '2017-01-24 17:12:18', 'completed', '', NULL),
 (825, 0, '80.219.25.152', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-24 18:38:13', 'completed', '', NULL),
 (826, 0, '80.219.25.152', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 1837, 1839, '', '2017-01-24 18:39:31', 'completed', '', NULL),
 (827, 0, '31.10.146.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2146, 2149, '', '2017-01-24 19:12:38', 'completed', '', NULL),
 (828, 0, '188.63.90.128', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-N5110 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Safari/537.36', 2128, 2367, '', '2017-01-24 21:46:33', 'completed', '', NULL),
 (829, 0, '188.63.90.128', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-N5110 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Safari/537.36', 2333, 2334, '', '2017-01-24 21:47:41', 'completed', '', NULL),
 (830, 0, '178.197.229.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53', 2161, 2162, '', '2017-01-25 07:12:54', 'completed', '', NULL),
 (831, 0, '178.197.229.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53', 2342, 2349, '', '2017-01-25 07:16:06', 'completed', '', NULL),
 (832, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-01-25 07:40:29', 'completed', '', NULL),
 (833, 0, '81.185.237.185', 'Java/1.7.0_79', 2146, 2149, '', '2017-01-25 07:40:30', 'completed', '', NULL),
 (834, 0, '81.185.237.185', 'Java/1.7.0_79', 2333, 2334, '', '2017-01-25 07:40:31', 'completed', '', NULL),
 (835, 0, '81.185.237.185', 'Java/1.7.0_79', 2140, 2141, '', '2017-01-25 07:40:34', 'completed', '', NULL),
 (836, 0, '81.185.237.185', 'Java/1.7.0_79', 2336, 2337, '', '2017-01-25 07:40:35', 'completed', '', NULL),
 (837, 0, '81.185.237.185', 'Java/1.7.0_79', 1837, 1839, '', '2017-01-25 07:40:37', 'completed', '', NULL),
 (838, 0, '81.185.237.185', 'Java/1.7.0_79', 1844, 1845, '', '2017-01-25 07:40:37', 'completed', '', NULL),
 (839, 0, '81.185.237.185', 'Java/1.7.0_79', 2339, 2340, '', '2017-01-25 07:40:38', 'completed', '', NULL),
 (840, 0, '81.185.237.185', 'Java/1.7.0_79', 2130, 2133, '', '2017-01-25 07:40:40', 'completed', '', NULL),
 (841, 0, '81.185.237.185', 'Java/1.7.0_79', 2134, 2307, '', '2017-01-25 07:40:41', 'completed', '', NULL),
 (842, 0, '81.185.237.185', 'Java/1.7.0_79', 2161, 2162, '', '2017-01-25 07:40:43', 'completed', '', NULL),
 (843, 0, '81.185.237.185', 'Java/1.7.0_79', 2342, 2349, '', '2017-01-25 07:40:45', 'completed', '', NULL),
 (844, 0, '178.83.233.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2140, 2141, '', '2017-01-25 15:41:45', 'completed', '', NULL),
 (845, 0, '178.83.233.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2336, 2337, '', '2017-01-25 15:46:26', 'completed', '', NULL),
 (846, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-25 16:17:55', 'completed', '', NULL),
 (847, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-25 16:36:11', 'completed', '', NULL),
 (848, 0, '188.155.56.54', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-01-25 17:04:12', 'completed', '', NULL),
 (849, 0, '83.77.47.27', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2128, 2367, '', '2017-01-25 17:25:14', 'completed', '', NULL),
 (850, 0, '80.219.25.152', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2128, 2367, '', '2017-01-25 18:13:04', 'completed', '', NULL),
 (851, 0, '90.6.111.53', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2342, 2349, '', '2017-01-25 18:39:04', 'completed', '', NULL),
 (852, 0, '90.6.111.53', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2146, 2149, '', '2017-01-25 18:50:13', 'completed', '', NULL),
 (853, 0, '90.6.111.53', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2342, 2349, '', '2017-01-25 18:51:00', 'completed', '', NULL),
 (854, 0, '5.56.133.29', 'Java/1.8.0_121', 2128, 2367, '', '2017-01-25 19:29:32', 'completed', '', NULL),
 (855, 0, '5.56.133.29', 'Java/1.8.0_121', 2146, 2149, '', '2017-01-25 19:29:33', 'completed', '', NULL),
 (856, 0, '5.56.133.29', 'Java/1.8.0_121', 2333, 2334, '', '2017-01-25 19:29:34', 'completed', '', NULL),
 (857, 0, '5.56.133.29', 'Java/1.8.0_121', 2140, 2141, '', '2017-01-25 19:29:36', 'completed', '', NULL),
 (858, 0, '5.56.133.29', 'Java/1.8.0_121', 2336, 2337, '', '2017-01-25 19:29:37', 'completed', '', NULL),
 (859, 0, '5.56.133.29', 'Java/1.8.0_121', 1837, 1839, '', '2017-01-25 19:29:39', 'completed', '', NULL),
 (860, 0, '5.56.133.29', 'Java/1.8.0_121', 1844, 1845, '', '2017-01-25 19:29:39', 'completed', '', NULL),
 (861, 0, '5.56.133.29', 'Java/1.8.0_121', 2339, 2340, '', '2017-01-25 19:29:40', 'completed', '', NULL),
 (862, 0, '5.56.133.29', 'Java/1.8.0_121', 2130, 2133, '', '2017-01-25 19:29:42', 'completed', '', NULL),
 (863, 0, '5.56.133.29', 'Java/1.8.0_121', 2134, 2307, '', '2017-01-25 19:29:43', 'completed', '', NULL),
 (864, 0, '5.56.133.29', 'Java/1.8.0_121', 2161, 2162, '', '2017-01-25 19:29:44', 'completed', '', NULL),
 (865, 0, '5.56.133.29', 'Java/1.8.0_121', 2342, 2349, '', '2017-01-25 19:29:46', 'completed', '', NULL),
 (866, 0, '77.58.20.118', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-25 19:30:41', 'completed', '', NULL),
 (867, 0, '77.58.20.118', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2336, 2337, '', '2017-01-25 19:31:45', 'completed', '', NULL),
 (868, 0, '85.1.203.245', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2333, 2334, '', '2017-01-25 20:09:21', 'completed', '', NULL),
 (869, 0, '85.1.203.245', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2128, 2367, '', '2017-01-25 20:11:31', 'completed', '', NULL),
 (870, 0, '85.1.203.245', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2146, 2149, '', '2017-01-25 20:15:35', 'completed', '', NULL),
 (871, 0, '82.76.87.19', 'Java/1.6.0_04', 2128, 2367, '', '2017-01-25 20:22:57', 'completed', '', NULL),
 (872, 0, '82.76.87.19', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-25 20:22:58', 'completed', '', NULL),
 (873, 0, '82.76.87.19', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-25 20:22:59', 'completed', '', NULL),
 (874, 0, '82.76.87.19', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-25 20:23:02', 'completed', '', NULL),
 (875, 0, '82.76.87.19', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-25 20:23:04', 'completed', '', NULL),
 (876, 0, '82.76.87.19', 'Java/1.6.0_04', 1837, 1839, '', '2017-01-25 20:23:06', 'completed', '', NULL),
 (877, 0, '82.76.87.19', 'Java/1.6.0_04', 1844, 1845, '', '2017-01-25 20:23:07', 'completed', '', NULL),
 (878, 0, '82.76.87.19', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-25 20:23:08', 'completed', '', NULL),
 (879, 0, '82.76.87.19', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-25 20:23:10', 'completed', '', NULL),
 (880, 0, '82.76.87.19', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-25 20:23:12', 'completed', '', NULL),
 (881, 0, '82.76.87.19', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-25 20:23:14', 'completed', '', NULL),
 (882, 0, '82.76.87.19', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-25 20:23:16', 'completed', '', NULL),
 (883, 0, '62.155.131.112', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 1844, 1845, '', '2017-01-25 21:51:33', 'completed', '', NULL),
 (884, 0, '62.155.131.112', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2336, 2337, '', '2017-01-25 21:56:01', 'completed', '', NULL),
 (885, 0, '31.3.252.24', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-26 09:39:37', 'completed', '', NULL),
 (886, 0, '31.3.252.24', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-26 09:39:38', 'completed', '', NULL),
 (887, 0, '31.3.252.24', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-26 09:39:43', 'completed', '', NULL),
 (888, 0, '31.3.252.24', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-26 09:40:02', 'completed', '', NULL),
 (889, 0, '31.3.252.24', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-26 09:40:08', 'completed', '', NULL),
 (890, 0, '31.3.252.24', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-26 09:40:19', 'completed', '', NULL),
 (891, 0, '31.3.252.24', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-26 09:40:30', 'completed', '', NULL),
 (892, 0, '31.3.252.24', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-26 09:40:36', 'completed', '', NULL),
 (893, 0, '31.3.252.24', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-26 09:41:08', 'completed', '', NULL),
 (894, 0, '31.3.252.24', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-26 09:41:14', 'completed', '', NULL),
 (895, 0, '31.3.252.24', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-26 09:41:26', 'completed', '', NULL),
 (896, 0, '31.3.252.24', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-26 09:41:38', 'completed', '', NULL),
 (897, 0, '62.202.31.225', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:50.0) Gecko/20100101 Firefox/50.0', 2140, 2141, '', '2017-01-26 12:38:51', 'completed', '', NULL),
 (898, 0, '46.126.159.188', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2128, 2367, '', '2017-01-26 20:46:38', 'completed', '', NULL),
 (899, 0, '46.126.159.188', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2333, 2334, '', '2017-01-26 20:48:45', 'completed', '', NULL),
 (900, 0, '31.10.132.26', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1844, 1845, '', '2017-01-26 21:27:02', 'completed', '', NULL),
 (901, 0, '79.116.25.235', 'Java/1.7.0_79', 2128, 2367, '', '2017-01-26 23:31:34', 'completed', '', NULL),
 (902, 0, '79.116.25.235', 'Java/1.7.0_79', 2146, 2149, '', '2017-01-26 23:31:35', 'completed', '', NULL),
 (903, 0, '79.116.25.235', 'Java/1.7.0_79', 2333, 2334, '', '2017-01-26 23:31:44', 'completed', '', NULL),
 (904, 0, '79.116.25.235', 'Java/1.7.0_79', 2140, 2141, '', '2017-01-26 23:31:47', 'completed', '', NULL),
 (905, 0, '79.116.25.235', 'Java/1.7.0_79', 2336, 2337, '', '2017-01-26 23:31:48', 'completed', '', NULL),
 (906, 0, '79.116.25.235', 'Java/1.7.0_79', 1837, 1839, '', '2017-01-26 23:31:50', 'completed', '', NULL),
 (907, 0, '79.116.25.235', 'Java/1.7.0_79', 1844, 1845, '', '2017-01-26 23:31:52', 'completed', '', NULL),
 (908, 0, '79.116.25.235', 'Java/1.7.0_79', 2339, 2340, '', '2017-01-26 23:31:53', 'completed', '', NULL),
 (909, 0, '79.116.25.235', 'Java/1.7.0_79', 2130, 2133, '', '2017-01-26 23:31:56', 'completed', '', NULL),
 (910, 0, '79.116.25.235', 'Java/1.7.0_79', 2134, 2307, '', '2017-01-26 23:31:57', 'completed', '', NULL),
 (911, 0, '79.116.25.235', 'Java/1.7.0_79', 2161, 2162, '', '2017-01-26 23:32:00', 'completed', '', NULL),
 (912, 0, '79.116.25.235', 'Java/1.7.0_79', 2342, 2349, '', '2017-01-26 23:32:01', 'completed', '', NULL),
 (913, 0, '107.22.4.65', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-27 11:15:15', 'completed', '', NULL),
 (914, 0, '107.22.4.65', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-27 11:15:21', 'completed', '', NULL),
 (915, 0, '107.22.4.65', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-27 11:15:23', 'completed', '', NULL),
 (916, 0, '107.22.4.65', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-27 11:15:35', 'completed', '', NULL),
 (917, 0, '107.22.4.65', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-27 11:15:40', 'completed', '', NULL),
 (918, 0, '107.22.4.65', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-27 11:15:48', 'completed', '', NULL),
 (919, 0, '107.22.4.65', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-27 11:15:50', 'completed', '', NULL),
 (920, 0, '107.22.4.65', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-27 11:15:53', 'completed', '', NULL),
 (921, 0, '107.22.4.65', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-27 11:16:15', 'completed', '', NULL),
 (922, 0, '107.22.4.65', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-27 11:16:25', 'completed', '', NULL),
 (923, 0, '107.22.4.65', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-27 11:16:33', 'completed', '', NULL),
 (924, 0, '107.22.4.65', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-27 11:16:43', 'completed', '', NULL),
 (925, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2017-01-27 11:39:11', 'completed', '', NULL),
 (926, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-27 12:52:07', 'completed', '', NULL),
 (927, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-28 08:46:24', 'completed', '', NULL),
 (928, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-28 08:46:26', 'completed', '', NULL),
 (929, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-28 08:46:27', 'completed', '', NULL),
 (930, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-28 08:46:29', 'completed', '', NULL),
 (931, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-28 08:46:32', 'completed', '', NULL),
 (932, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-28 08:46:34', 'completed', '', NULL),
 (933, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-28 08:46:35', 'completed', '', NULL),
 (934, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-28 08:46:36', 'completed', '', NULL),
 (935, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-28 08:46:38', 'completed', '', NULL),
 (936, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-28 08:46:40', 'completed', '', NULL),
 (937, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-28 08:46:42', 'completed', '', NULL),
 (938, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-28 08:46:43', 'completed', '', NULL),
 (939, 0, '178.197.229.99', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-01-28 14:23:09', 'completed', '', NULL),
 (940, 0, '85.1.176.8', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A456 Safari/602.1', 1844, 1845, '', '2017-01-28 20:22:09', 'completed', '', NULL),
 (941, 0, '195.154.56.124', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-29 04:46:10', 'completed', '', NULL),
 (942, 0, '195.154.56.124', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-29 04:46:11', 'completed', '', NULL),
 (943, 0, '195.154.56.124', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-29 04:46:11', 'completed', '', NULL),
 (944, 0, '195.154.56.124', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-29 04:46:14', 'completed', '', NULL),
 (945, 0, '195.154.56.124', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-29 04:46:14', 'completed', '', NULL),
 (946, 0, '195.154.56.124', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-29 04:46:16', 'completed', '', NULL),
 (947, 0, '195.154.56.124', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-29 04:46:16', 'completed', '', NULL),
 (948, 0, '195.154.56.124', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-29 04:46:17', 'completed', '', NULL),
 (949, 0, '195.154.56.124', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-29 04:46:18', 'completed', '', NULL),
 (950, 0, '195.154.56.124', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-29 04:46:19', 'completed', '', NULL),
 (951, 0, '195.154.56.124', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-29 04:46:21', 'completed', '', NULL),
 (952, 0, '195.154.56.124', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-29 04:46:22', 'completed', '', NULL),
 (953, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-01-29 09:18:06', 'completed', '', NULL),
 (954, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1837, 1839, '', '2017-01-29 09:30:04', 'completed', '', NULL),
 (955, 0, '178.197.226.239', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-01-29 12:14:38', 'completed', '', NULL),
 (956, 0, '178.194.17.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-01-29 19:35:20', 'completed', '', NULL),
 (957, 0, '178.194.17.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-01-29 19:39:24', 'completed', '', NULL),
 (958, 0, '178.194.17.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-01-29 19:41:14', 'completed', '', NULL),
 (959, 0, '212.225.226.36', 'Java/1.4.1_04', 2128, 2367, '', '2017-01-29 19:49:16', 'completed', '', NULL),
 (960, 0, '212.225.226.36', 'Java/1.4.1_04', 2146, 2149, '', '2017-01-29 19:49:19', 'completed', '', NULL),
 (961, 0, '212.225.226.36', 'Java/1.4.1_04', 2333, 2334, '', '2017-01-29 19:49:20', 'completed', '', NULL),
 (962, 0, '212.225.226.36', 'Java/1.4.1_04', 2140, 2141, '', '2017-01-29 19:49:26', 'completed', '', NULL),
 (963, 0, '212.225.226.36', 'Java/1.4.1_04', 2336, 2337, '', '2017-01-29 19:49:28', 'completed', '', NULL),
 (964, 0, '212.225.226.36', 'Java/1.4.1_04', 1837, 1839, '', '2017-01-29 19:49:31', 'completed', '', NULL),
 (965, 0, '212.225.226.36', 'Java/1.4.1_04', 1844, 1845, '', '2017-01-29 19:49:32', 'completed', '', NULL),
 (966, 0, '212.225.226.36', 'Java/1.4.1_04', 2339, 2340, '', '2017-01-29 19:49:34', 'completed', '', NULL),
 (967, 0, '212.225.226.36', 'Java/1.4.1_04', 2130, 2133, '', '2017-01-29 19:49:37', 'completed', '', NULL),
 (968, 0, '212.225.226.36', 'Java/1.4.1_04', 2134, 2307, '', '2017-01-29 19:49:40', 'completed', '', NULL),
 (969, 0, '212.225.226.36', 'Java/1.4.1_04', 2161, 2162, '', '2017-01-29 19:49:43', 'completed', '', NULL),
 (970, 0, '212.225.226.36', 'Java/1.4.1_04', 2342, 2349, '', '2017-01-29 19:49:45', 'completed', '', NULL),
 (971, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36', 2342, 2349, '', '2017-01-29 20:57:33', 'completed', '', NULL),
 (972, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36', 2130, 2133, '', '2017-01-29 21:02:50', 'completed', '', NULL),
 (973, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-30 08:43:55', 'completed', '', NULL),
 (974, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-30 08:44:04', 'completed', '', NULL),
 (975, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-01-30 08:46:12', 'completed', '', NULL),
 (976, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-30 08:47:48', 'completed', '', NULL),
 (977, 0, '178.38.138.146', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-01-30 08:48:36', 'completed', '', NULL),
 (978, 0, '85.0.211.250', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2336, 2337, '', '2017-01-30 09:33:37', 'completed', '', NULL),
 (979, 0, '85.0.211.250', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-01-30 09:35:09', 'completed', '', NULL),
 (980, 0, '85.0.211.250', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2336, 2337, '', '2017-01-30 09:37:42', 'completed', '', NULL),
 (981, 0, '109.164.236.47', 'Mozilla/5.0 (Windows NT 6.1; rv:51.0) Gecko/20100101 Firefox/51.0', 2134, 2307, '', '2017-01-30 11:08:00', 'completed', '', NULL),
 (982, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-30 12:08:13', 'completed', '', NULL),
 (983, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-01-30 12:08:14', 'completed', '', NULL),
 (984, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36', 2134, 2307, '', '2017-01-30 14:34:20', 'completed', '', NULL),
 (985, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-01-30 14:35:29', 'completed', '', NULL),
 (986, 0, '78.43.234.59', 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2140, 2141, '', '2017-01-30 16:26:24', 'completed', '', NULL),
 (987, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36', 2134, 2307, '', '2017-01-30 16:38:36', 'completed', '', NULL),
 (988, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.76 Safari/537.36', 2130, 2133, '', '2017-01-30 16:38:39', 'completed', '', NULL),
 (989, 0, '84.227.86.197', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-01-30 17:12:59', 'completed', '', NULL),
 (990, 0, '84.227.86.197', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-01-30 17:15:13', 'completed', '', NULL),
 (991, 0, '149.255.36.136', 'Java/1.6.0_04', 2128, 2367, '', '2017-01-30 19:30:12', 'completed', '', NULL),
 (992, 0, '149.255.36.136', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-30 19:30:13', 'completed', '', NULL),
 (993, 0, '149.255.36.136', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-30 19:30:15', 'completed', '', NULL),
 (994, 0, '149.255.36.136', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-30 19:31:29', 'completed', '', NULL),
 (995, 0, '149.255.36.136', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-30 19:32:24', 'completed', '', NULL),
 (996, 0, '149.255.36.136', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-30 19:32:43', 'completed', '', NULL),
 (997, 0, '149.255.36.136', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-30 19:32:52', 'completed', '', NULL),
 (998, 0, '149.255.36.136', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-30 19:34:17', 'completed', '', NULL),
 (999, 0, '149.255.36.136', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-30 19:34:19', 'completed', '', NULL),
 (1000, 0, '178.38.138.146', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F/G930FXXS1BPI8 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-01-30 19:37:41', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(1001, 0, '178.38.138.146', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F/G930FXXS1BPI8 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2140, 2141, '', '2017-01-30 19:38:15', 'completed', '', NULL),
 (1002, 0, '178.38.138.146', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F/G930FXXS1BPI8 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-01-30 19:38:24', 'completed', '', NULL),
 (1003, 0, '178.197.235.146', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1', 2134, 2307, '', '2017-01-31 00:11:16', 'completed', '', NULL),
 (1004, 0, '178.197.235.146', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1', 2130, 2133, '', '2017-01-31 00:11:34', 'completed', '', NULL),
 (1005, 0, '178.197.235.146', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1', 2128, 2367, '', '2017-01-31 00:14:55', 'completed', '', NULL),
 (1006, 0, '68.180.229.227', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-01-31 11:33:26', 'completed', '', NULL),
 (1007, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2339, 2340, '', '2017-01-31 13:45:42', 'completed', '', NULL),
 (1008, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2336, 2337, '', '2017-01-31 13:54:33', 'completed', '', NULL),
 (1009, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2333, 2334, '', '2017-01-31 13:56:57', 'completed', '', NULL),
 (1010, 0, '85.195.224.51', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/54.0.2840.98 Safari/537.36', 2146, 2149, '', '2017-01-31 13:57:40', 'completed', '', NULL),
 (1011, 0, '84.74.217.65', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.87 Safari/537.36', 2333, 2334, '', '2017-01-31 15:26:29', 'completed', '', NULL),
 (1012, 0, '83.41.7.220', 'Java/1.8.0_65', 2128, 2367, '', '2017-01-31 17:29:43', 'completed', '', NULL),
 (1013, 0, '83.41.7.220', 'Java/1.8.0_65', 2146, 2149, '', '2017-01-31 17:29:45', 'completed', '', NULL),
 (1014, 0, '83.41.7.220', 'Java/1.8.0_65', 2333, 2334, '', '2017-01-31 17:29:45', 'completed', '', NULL),
 (1015, 0, '83.41.7.220', 'Java/1.8.0_65', 2140, 2141, '', '2017-01-31 17:29:48', 'completed', '', NULL),
 (1016, 0, '83.41.7.220', 'Java/1.8.0_65', 2336, 2337, '', '2017-01-31 17:29:50', 'completed', '', NULL),
 (1017, 0, '83.41.7.220', 'Java/1.8.0_65', 1837, 1839, '', '2017-01-31 17:29:52', 'completed', '', NULL),
 (1018, 0, '83.41.7.220', 'Java/1.8.0_65', 1844, 1845, '', '2017-01-31 17:29:53', 'completed', '', NULL),
 (1019, 0, '83.41.7.220', 'Java/1.8.0_65', 2339, 2340, '', '2017-01-31 17:29:54', 'completed', '', NULL),
 (1020, 0, '83.41.7.220', 'Java/1.8.0_65', 2130, 2133, '', '2017-01-31 17:29:56', 'completed', '', NULL),
 (1021, 0, '83.41.7.220', 'Java/1.8.0_65', 2134, 2307, '', '2017-01-31 17:29:58', 'completed', '', NULL),
 (1022, 0, '83.41.7.220', 'Java/1.8.0_65', 2161, 2162, '', '2017-01-31 17:30:00', 'completed', '', NULL),
 (1023, 0, '83.41.7.220', 'Java/1.8.0_65', 2342, 2349, '', '2017-01-31 17:30:02', 'completed', '', NULL),
 (1024, 0, '85.56.89.92', 'Java/1.6.0_04', 2128, 2367, '', '2017-01-31 19:12:09', 'completed', '', NULL),
 (1025, 0, '85.56.89.92', 'Java/1.6.0_04', 2146, 2149, '', '2017-01-31 19:12:10', 'completed', '', NULL),
 (1026, 0, '85.56.89.92', 'Java/1.6.0_04', 2333, 2334, '', '2017-01-31 19:12:11', 'completed', '', NULL),
 (1027, 0, '85.56.89.92', 'Java/1.6.0_04', 2140, 2141, '', '2017-01-31 19:12:17', 'completed', '', NULL),
 (1028, 0, '85.56.89.92', 'Java/1.6.0_04', 2336, 2337, '', '2017-01-31 19:12:19', 'completed', '', NULL),
 (1029, 0, '85.56.89.92', 'Java/1.6.0_04', 1837, 1839, '', '2017-01-31 19:12:22', 'completed', '', NULL),
 (1030, 0, '85.56.89.92', 'Java/1.6.0_04', 1844, 1845, '', '2017-01-31 19:12:24', 'completed', '', NULL),
 (1031, 0, '85.56.89.92', 'Java/1.6.0_04', 2339, 2340, '', '2017-01-31 19:12:25', 'completed', '', NULL),
 (1032, 0, '85.56.89.92', 'Java/1.6.0_04', 2130, 2133, '', '2017-01-31 19:12:27', 'completed', '', NULL),
 (1033, 0, '85.56.89.92', 'Java/1.6.0_04', 2134, 2307, '', '2017-01-31 19:12:30', 'completed', '', NULL),
 (1034, 0, '85.56.89.92', 'Java/1.6.0_04', 2161, 2162, '', '2017-01-31 19:12:33', 'completed', '', NULL),
 (1035, 0, '85.56.89.92', 'Java/1.6.0_04', 2342, 2349, '', '2017-01-31 19:12:34', 'completed', '', NULL),
 (1036, 0, '68.180.229.227', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2307, '', '2017-02-01 01:13:36', 'completed', '', NULL),
 (1037, 0, '193.223.193.102', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-02-01 07:42:16', 'completed', '', NULL),
 (1038, 0, '193.223.193.102', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-02-01 07:43:42', 'completed', '', NULL),
 (1039, 0, '86.123.245.254', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-01 14:12:49', 'completed', '', NULL),
 (1040, 0, '86.123.245.254', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-01 14:12:52', 'completed', '', NULL),
 (1041, 0, '86.123.245.254', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-01 14:12:53', 'completed', '', NULL),
 (1042, 0, '86.123.245.254', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-01 14:12:57', 'completed', '', NULL),
 (1043, 0, '86.123.245.254', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-01 14:12:59', 'completed', '', NULL),
 (1044, 0, '86.123.245.254', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-01 14:13:04', 'completed', '', NULL),
 (1045, 0, '86.123.245.254', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-01 14:13:06', 'completed', '', NULL),
 (1046, 0, '86.123.245.254', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-01 14:13:07', 'completed', '', NULL),
 (1047, 0, '86.123.245.254', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-01 14:13:10', 'completed', '', NULL),
 (1048, 0, '86.123.245.254', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-01 14:13:14', 'completed', '', NULL),
 (1049, 0, '86.123.245.254', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-01 14:13:17', 'completed', '', NULL),
 (1050, 0, '86.123.245.254', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-01 14:13:19', 'completed', '', NULL),
 (1051, 0, '95.18.207.174', 'Java/1.6.0_29', 2128, 2367, '', '2017-02-01 15:22:09', 'completed', '', NULL),
 (1052, 0, '95.18.207.174', 'Java/1.6.0_29', 2146, 2149, '', '2017-02-01 15:22:11', 'completed', '', NULL),
 (1053, 0, '95.18.207.174', 'Java/1.6.0_29', 2333, 2334, '', '2017-02-01 15:22:14', 'completed', '', NULL),
 (1054, 0, '95.18.207.174', 'Java/1.6.0_29', 2140, 2141, '', '2017-02-01 15:22:19', 'completed', '', NULL),
 (1055, 0, '95.18.207.174', 'Java/1.6.0_29', 2336, 2337, '', '2017-02-01 15:22:20', 'completed', '', NULL),
 (1056, 0, '95.18.207.174', 'Java/1.6.0_29', 1837, 1839, '', '2017-02-01 15:22:24', 'completed', '', NULL),
 (1057, 0, '95.18.207.174', 'Java/1.6.0_29', 1844, 1845, '', '2017-02-01 15:22:26', 'completed', '', NULL),
 (1058, 0, '95.18.207.174', 'Java/1.6.0_29', 2339, 2340, '', '2017-02-01 15:22:27', 'completed', '', NULL),
 (1059, 0, '95.18.207.174', 'Java/1.6.0_29', 2130, 2133, '', '2017-02-01 15:22:30', 'completed', '', NULL),
 (1060, 0, '95.18.207.174', 'Java/1.6.0_29', 2134, 2307, '', '2017-02-01 15:22:36', 'completed', '', NULL),
 (1061, 0, '95.18.207.174', 'Java/1.6.0_29', 2161, 2162, '', '2017-02-01 15:22:40', 'completed', '', NULL),
 (1062, 0, '95.18.207.174', 'Java/1.6.0_29', 2342, 2349, '', '2017-02-01 15:22:41', 'completed', '', NULL),
 (1063, 0, '194.230.155.218', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-02-01 18:00:18', 'completed', '', NULL),
 (1064, 0, '27.122.119.13', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-02 04:21:16', 'completed', '', NULL),
 (1065, 0, '27.122.119.13', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-02 04:21:21', 'completed', '', NULL),
 (1066, 0, '27.122.119.13', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-02 04:21:23', 'completed', '', NULL),
 (1067, 0, '27.122.119.13', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-02 04:21:30', 'completed', '', NULL),
 (1068, 0, '27.122.119.13', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-02 04:21:32', 'completed', '', NULL),
 (1069, 0, '27.122.119.13', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-02 04:21:36', 'completed', '', NULL),
 (1070, 0, '27.122.119.13', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-02 04:21:38', 'completed', '', NULL),
 (1071, 0, '27.122.119.13', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-02 04:21:39', 'completed', '', NULL),
 (1072, 0, '27.122.119.13', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-02 04:21:44', 'completed', '', NULL),
 (1073, 0, '27.122.119.13', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-02 04:21:48', 'completed', '', NULL),
 (1074, 0, '27.122.119.13', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-02 04:21:53', 'completed', '', NULL),
 (1075, 0, '27.122.119.13', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-02 04:21:55', 'completed', '', NULL),
 (1076, 0, '212.225.226.37', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-02 05:22:36', 'completed', '', NULL),
 (1077, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-02 05:22:38', 'completed', '', NULL),
 (1078, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-02 05:22:39', 'completed', '', NULL),
 (1079, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-02 05:22:43', 'completed', '', NULL),
 (1080, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-02 05:22:44', 'completed', '', NULL),
 (1081, 0, '212.225.226.37', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-02 05:22:46', 'completed', '', NULL),
 (1082, 0, '212.225.226.37', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-02 05:22:47', 'completed', '', NULL),
 (1083, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-02 05:22:48', 'completed', '', NULL),
 (1084, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-02 05:22:49', 'completed', '', NULL),
 (1085, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-02 05:22:51', 'completed', '', NULL),
 (1086, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-02 05:22:53', 'completed', '', NULL),
 (1087, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-02 05:22:54', 'completed', '', NULL),
 (1088, 0, '192.99.67.14', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-02 05:48:54', 'completed', '', NULL),
 (1089, 0, '192.99.67.14', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-02 05:49:25', 'completed', '', NULL),
 (1090, 0, '192.99.67.14', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-02 05:49:56', 'completed', '', NULL),
 (1091, 0, '192.99.67.14', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-02 05:50:26', 'completed', '', NULL),
 (1092, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-02-02 06:27:22', 'completed', '', NULL),
 (1093, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-02-02 06:27:28', 'completed', '', NULL),
 (1094, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-02-02 06:27:32', 'completed', '', NULL),
 (1095, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-02-02 06:27:48', 'completed', '', NULL),
 (1096, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-02-02 06:27:52', 'completed', '', NULL),
 (1097, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-02-02 06:27:58', 'completed', '', NULL),
 (1098, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-02-02 06:28:02', 'completed', '', NULL),
 (1099, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-02-02 06:28:37', 'completed', '', NULL),
 (1100, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-02-02 06:28:43', 'completed', '', NULL),
 (1101, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-02-02 06:29:17', 'completed', '', NULL),
 (1102, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-02-02 06:29:22', 'completed', '', NULL),
 (1103, 0, '45.55.203.234', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-02-02 06:29:28', 'completed', '', NULL),
 (1104, 0, '82.136.89.180', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-T813 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Safari/537.36', 2336, 2337, '', '2017-02-02 12:38:49', 'completed', '', NULL),
 (1105, 0, '82.136.89.180', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-T813 Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Safari/537.36', 2140, 2141, '', '2017-02-02 12:45:08', 'completed', '', NULL),
 (1106, 0, '85.5.179.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-02-02 14:07:53', 'completed', '', NULL),
 (1107, 0, '85.5.179.51', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-02-02 14:36:08', 'completed', '', NULL),
 (1108, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-02-02 17:17:14', 'completed', '', NULL),
 (1109, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-02-02 17:34:27', 'completed', '', NULL),
 (1110, 0, '212.35.24.87', 'Mozilla/5.0 (Linux; Android 6.0; CAM-L21 Build/HUAWEICAM-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 1844, 1845, '', '2017-02-02 20:15:41', 'completed', '', NULL),
 (1111, 0, '178.39.168.33', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2146, 2149, '', '2017-02-02 23:00:51', 'completed', '', NULL),
 (1112, 0, '68.180.228.252', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2336, 2337, '', '2017-02-03 04:32:11', 'completed', '', NULL),
 (1113, 0, '91.12.155.19', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-02-03 12:05:18', 'completed', '', NULL),
 (1114, 0, '104.236.221.212', '', 2339, 2340, '', '2017-02-03 14:44:02', 'completed', '', NULL),
 (1115, 0, '104.236.221.212', '', 1844, 1845, '', '2017-02-03 14:44:04', 'completed', '', NULL),
 (1116, 0, '104.236.221.212', '', 1837, 1839, '', '2017-02-03 14:44:06', 'completed', '', NULL),
 (1117, 0, '104.236.221.212', '', 2146, 2149, '', '2017-02-03 14:44:07', 'completed', '', NULL),
 (1118, 0, '104.236.221.212', '', 2336, 2337, '', '2017-02-03 14:44:11', 'completed', '', NULL),
 (1119, 0, '104.236.221.212', '', 2140, 2141, '', '2017-02-03 14:44:13', 'completed', '', NULL),
 (1120, 0, '104.236.221.212', '', 2161, 2162, '', '2017-02-03 14:44:17', 'completed', '', NULL),
 (1121, 0, '104.236.221.212', '', 2342, 2349, '', '2017-02-03 14:44:19', 'completed', '', NULL),
 (1122, 0, '104.236.221.212', '', 2134, 2307, '', '2017-02-03 14:44:21', 'completed', '', NULL),
 (1123, 0, '104.236.221.212', '', 2130, 2133, '', '2017-02-03 14:44:22', 'completed', '', NULL),
 (1124, 0, '104.236.221.212', '', 2333, 2334, '', '2017-02-03 14:44:25', 'completed', '', NULL),
 (1125, 0, '104.236.221.212', '', 2128, 2367, '', '2017-02-03 14:44:27', 'completed', '', NULL),
 (1126, 0, '91.102.197.108', 'Mozilla/5.0 (Linux; Android 6.0; HUAWEI NXT-L29 Build/HUAWEINXT-L29) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2336, 2337, '', '2017-02-04 02:07:30', 'completed', '', NULL),
 (1127, 0, '104.236.221.212', '', 2339, 2340, '', '2017-02-04 07:52:33', 'completed', '', NULL),
 (1128, 0, '104.236.221.212', '', 1844, 1845, '', '2017-02-04 07:52:35', 'completed', '', NULL),
 (1129, 0, '104.236.221.212', '', 1837, 1839, '', '2017-02-04 07:52:36', 'completed', '', NULL),
 (1130, 0, '104.236.221.212', '', 2146, 2149, '', '2017-02-04 07:52:37', 'completed', '', NULL),
 (1131, 0, '104.236.221.212', '', 2336, 2337, '', '2017-02-04 07:52:41', 'completed', '', NULL),
 (1132, 0, '104.236.221.212', '', 2140, 2141, '', '2017-02-04 07:52:43', 'completed', '', NULL),
 (1133, 0, '104.236.221.212', '', 2161, 2162, '', '2017-02-04 07:52:47', 'completed', '', NULL),
 (1134, 0, '104.236.221.212', '', 2342, 2349, '', '2017-02-04 07:52:48', 'completed', '', NULL),
 (1135, 0, '104.236.221.212', '', 2134, 2307, '', '2017-02-04 07:52:50', 'completed', '', NULL),
 (1136, 0, '104.236.221.212', '', 2130, 2133, '', '2017-02-04 07:52:51', 'completed', '', NULL),
 (1137, 0, '104.236.221.212', '', 2333, 2334, '', '2017-02-04 07:52:54', 'completed', '', NULL),
 (1138, 0, '104.236.221.212', '', 2128, 2367, '', '2017-02-04 07:52:56', 'completed', '', NULL),
 (1139, 0, '85.2.76.86', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-04 09:48:27', 'completed', '', NULL),
 (1140, 0, '85.2.76.86', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-04 09:49:23', 'completed', '', NULL),
 (1141, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2336, 2337, '', '2017-02-04 16:17:16', 'completed', '', NULL),
 (1142, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2342, 2349, '', '2017-02-04 16:17:43', 'completed', '', NULL),
 (1143, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2146, 2149, '', '2017-02-04 16:18:11', 'completed', '', NULL),
 (1144, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2134, 2307, '', '2017-02-04 16:18:28', 'completed', '', NULL),
 (1145, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2140, 2141, '', '2017-02-04 16:19:50', 'completed', '', NULL),
 (1146, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2333, 2334, '', '2017-02-04 16:20:35', 'completed', '', NULL),
 (1147, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2130, 2133, '', '2017-02-04 16:21:01', 'completed', '', NULL),
 (1148, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 1844, 1845, '', '2017-02-04 16:21:11', 'completed', '', NULL),
 (1149, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 1837, 1839, '', '2017-02-04 16:21:29', 'completed', '', NULL),
 (1150, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2128, 2367, '', '2017-02-04 16:21:37', 'completed', '', NULL),
 (1151, 0, '213.64.199.184', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2161, 2162, '', '2017-02-04 16:22:23', 'completed', '', NULL),
 (1152, 0, '77.165.180.98', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-05 00:30:41', 'completed', '', NULL),
 (1153, 0, '77.165.180.98', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-05 00:30:42', 'completed', '', NULL),
 (1154, 0, '77.165.180.98', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-05 00:30:44', 'completed', '', NULL),
 (1155, 0, '77.165.180.98', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-05 00:30:47', 'completed', '', NULL),
 (1156, 0, '77.165.180.98', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-05 00:30:49', 'completed', '', NULL),
 (1157, 0, '77.165.180.98', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-05 00:30:51', 'completed', '', NULL),
 (1158, 0, '77.165.180.98', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-05 00:30:52', 'completed', '', NULL),
 (1159, 0, '77.165.180.98', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-05 00:30:53', 'completed', '', NULL),
 (1160, 0, '77.165.180.98', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-05 00:30:54', 'completed', '', NULL),
 (1161, 0, '77.165.180.98', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-05 00:30:56', 'completed', '', NULL),
 (1162, 0, '77.165.180.98', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-05 00:30:59', 'completed', '', NULL),
 (1163, 0, '77.165.180.98', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-05 00:31:01', 'completed', '', NULL),
 (1164, 0, '72.214.133.30', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-05 04:23:02', 'completed', '', NULL),
 (1165, 0, '72.214.133.30', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-05 04:23:04', 'completed', '', NULL),
 (1166, 0, '72.214.133.30', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-05 04:23:05', 'completed', '', NULL),
 (1167, 0, '72.214.133.30', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-05 04:23:10', 'completed', '', NULL),
 (1168, 0, '72.214.133.30', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-05 04:23:11', 'completed', '', NULL),
 (1169, 0, '72.214.133.30', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-05 04:23:14', 'completed', '', NULL),
 (1170, 0, '72.214.133.30', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-05 04:23:16', 'completed', '', NULL),
 (1171, 0, '72.214.133.30', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-05 04:23:17', 'completed', '', NULL),
 (1172, 0, '72.214.133.30', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-05 04:23:21', 'completed', '', NULL),
 (1173, 0, '72.214.133.30', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-05 04:23:23', 'completed', '', NULL),
 (1174, 0, '72.214.133.30', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-05 04:23:28', 'completed', '', NULL),
 (1175, 0, '72.214.133.30', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-05 04:23:29', 'completed', '', NULL),
 (1176, 0, '81.62.51.23', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-02-06 10:16:18', 'completed', '', NULL),
 (1177, 0, '194.230.155.116', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-02-06 10:27:12', 'completed', '', NULL),
 (1178, 0, '178.197.228.241', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13F69 Safari/601.1', 2339, 2340, '', '2017-02-06 11:29:56', 'completed', '', NULL),
 (1179, 0, '178.197.228.241', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13F69 Safari/601.1', 1837, 1839, '', '2017-02-06 11:31:28', 'completed', '', NULL),
 (1180, 0, '178.197.228.241', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13F69 Safari/601.1', 2333, 2334, '', '2017-02-06 11:34:11', 'completed', '', NULL),
 (1181, 0, '92.107.176.140', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-02-06 18:08:02', 'completed', '', NULL),
 (1182, 0, '92.107.176.140', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1837, 1839, '', '2017-02-06 18:09:35', 'completed', '', NULL),
 (1183, 0, '92.107.176.140', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2339, 2340, '', '2017-02-06 18:10:19', 'completed', '', NULL),
 (1184, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-06 18:38:15', 'completed', '', NULL),
 (1185, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-06 18:38:17', 'completed', '', NULL),
 (1186, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-06 18:38:18', 'completed', '', NULL),
 (1187, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-06 18:38:21', 'completed', '', NULL),
 (1188, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-06 18:38:22', 'completed', '', NULL),
 (1189, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-06 18:38:25', 'completed', '', NULL),
 (1190, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-06 18:38:26', 'completed', '', NULL),
 (1191, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-06 18:38:27', 'completed', '', NULL),
 (1192, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-06 18:38:29', 'completed', '', NULL),
 (1193, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-06 18:38:31', 'completed', '', NULL),
 (1194, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-06 18:38:33', 'completed', '', NULL),
 (1195, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-06 18:38:34', 'completed', '', NULL),
 (1196, 0, '178.197.233.204', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B466 Safari/600.1.4', 2146, 2149, '', '2017-02-06 19:56:53', 'completed', '', NULL),
 (1197, 0, '178.197.233.204', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B466 Safari/600.1.4', 2140, 2141, '', '2017-02-06 19:57:13', 'completed', '', NULL),
 (1198, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-02-06 19:57:30', 'completed', '', NULL),
 (1199, 0, '178.197.233.204', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1_3 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B466 Safari/600.1.4', 2336, 2337, '', '2017-02-06 19:57:59', 'completed', '', NULL),
 (1200, 0, '62.203.192.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-06 20:41:39', 'completed', '', NULL),
 (1201, 0, '62.203.192.57', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-06 20:41:47', 'completed', '', NULL),
 (1202, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-02-07 08:01:00', 'completed', '', NULL),
 (1203, 0, '160.62.7.250', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-02-07 08:01:01', 'completed', '', NULL),
 (1204, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-07 09:24:53', 'completed', '', NULL),
 (1205, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-07 09:24:55', 'completed', '', NULL),
 (1206, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-07 09:24:56', 'completed', '', NULL),
 (1207, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-07 09:24:59', 'completed', '', NULL),
 (1208, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-07 09:25:01', 'completed', '', NULL),
 (1209, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-07 09:25:03', 'completed', '', NULL),
 (1210, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-07 09:25:04', 'completed', '', NULL),
 (1211, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-07 09:25:06', 'completed', '', NULL),
 (1212, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-07 09:25:09', 'completed', '', NULL),
 (1213, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-07 09:25:10', 'completed', '', NULL),
 (1214, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-07 09:25:13', 'completed', '', NULL),
 (1215, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-07 09:25:14', 'completed', '', NULL),
 (1216, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2130, 2133, '', '2017-02-07 11:29:18', 'completed', '', NULL),
 (1217, 0, '46.14.237.46', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-07 11:47:54', 'completed', '', NULL),
 (1218, 0, '46.14.237.46', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-02-07 11:50:19', 'completed', '', NULL),
 (1219, 0, '85.1.80.129', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-07 12:10:13', 'completed', '', NULL),
 (1220, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1837, 1839, '', '2017-02-07 14:32:56', 'completed', '', NULL),
 (1221, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2339, 2340, '', '2017-02-07 14:33:23', 'completed', '', NULL),
 (1222, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-02-07 14:43:35', 'completed', '', NULL),
 (1223, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1837, 1839, '', '2017-02-07 14:44:31', 'completed', '', NULL),
 (1224, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1844, 1845, '', '2017-02-07 14:45:27', 'completed', '', NULL),
 (1225, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2339, 2340, '', '2017-02-07 14:45:37', 'completed', '', NULL),
 (1226, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-02-07 14:45:52', 'completed', '', NULL),
 (1227, 0, '46.127.140.45', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-N910F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2128, 2367, '', '2017-02-07 15:06:20', 'completed', '', NULL),
 (1228, 0, '46.127.140.45', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-N910F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2333, 2334, '', '2017-02-07 15:07:02', 'completed', '', NULL),
 (1229, 0, '46.127.140.45', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-N910F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2140, 2141, '', '2017-02-07 15:10:24', 'completed', '', NULL),
 (1230, 0, '193.246.80.29', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-02-07 17:12:32', 'completed', '', NULL),
 (1231, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1844, 1845, '', '2017-02-07 19:34:58', 'completed', '', NULL),
 (1232, 0, '178.197.235.113', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A500FU Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2140, 2141, '', '2017-02-07 20:48:52', 'completed', '', NULL),
 (1233, 0, '178.197.235.113', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A500FU Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2140, 2141, '', '2017-02-07 20:51:03', 'completed', '', NULL),
 (1234, 0, '178.197.235.113', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A500FU Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2336, 2337, '', '2017-02-07 20:51:05', 'completed', '', NULL),
 (1235, 0, '178.197.235.113', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A500FU Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2146, 2149, '', '2017-02-07 20:53:16', 'completed', '', NULL),
 (1236, 0, '80.219.11.86', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2128, 2367, '', '2017-02-07 21:39:02', 'completed', '', NULL),
 (1237, 0, '80.219.11.86', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2333, 2334, '', '2017-02-07 21:39:22', 'completed', '', NULL),
 (1238, 0, '83.77.100.14', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-07 22:12:14', 'completed', '', NULL),
 (1239, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2017-02-08 03:25:49', 'completed', '', NULL),
 (1240, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-08 10:04:31', 'completed', '', NULL),
 (1241, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-02-08 10:05:33', 'completed', '', NULL),
 (1242, 0, '178.197.239.116', 'Mozilla/5.0 (Linux; Android 7.1.1; Nexus 9 Build/N4F26M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Safari/537.36', 2128, 2367, '', '2017-02-08 11:06:34', 'completed', '', NULL),
 (1243, 0, '178.197.239.116', 'Mozilla/5.0 (Linux; Android 7.1.1; Nexus 9 Build/N4F26M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Safari/537.36', 2333, 2334, '', '2017-02-08 11:07:10', 'completed', '', NULL),
 (1244, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-08 15:14:11', 'completed', '', NULL),
 (1245, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-02-08 15:18:58', 'completed', '', NULL),
 (1246, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-08 15:19:14', 'completed', '', NULL),
 (1247, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-08 15:33:48', 'completed', '', NULL),
 (1248, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-08 15:47:19', 'completed', '', NULL),
 (1249, 0, '83.78.216.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 1844, 1845, '', '2017-02-08 16:20:02', 'completed', '', NULL),
 (1250, 0, '83.78.216.185', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 1837, 1839, '', '2017-02-08 16:20:35', 'completed', '', NULL),
 (1251, 0, '195.141.126.4', 'searchch UltraSpider3000/2.0 (+http://www.search.ch/about.html)', 2146, 2149, '', '2017-02-08 16:22:30', 'completed', '', NULL),
 (1252, 0, '80.219.11.86', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2333, 2334, '', '2017-02-08 21:46:56', 'completed', '', NULL),
 (1253, 0, '80.219.11.86', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1837, 1839, '', '2017-02-08 21:48:17', 'completed', '', NULL),
 (1254, 0, '80.219.11.86', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-02-08 21:48:29', 'completed', '', NULL),
 (1255, 0, '188.63.54.63', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1837, 1839, '', '2017-02-08 21:56:06', 'completed', '', NULL),
 (1256, 0, '188.63.54.63', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-02-08 21:56:06', 'completed', '', NULL),
 (1257, 0, '188.63.54.63', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1837, 1839, '', '2017-02-08 21:56:06', 'completed', '', NULL),
 (1258, 0, '188.63.54.63', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-02-08 21:56:07', 'completed', '', NULL),
 (1259, 0, '81.63.151.157', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2339, 2340, '', '2017-02-09 12:37:47', 'completed', '', NULL),
 (1260, 0, '93.190.74.142', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-02-09 12:38:03', 'completed', '', NULL),
 (1261, 0, '81.63.151.157', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2146, 2149, '', '2017-02-09 12:43:28', 'completed', '', NULL),
 (1262, 0, '93.190.74.142', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-02-09 12:46:48', 'completed', '', NULL),
 (1263, 0, '93.190.74.142', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-02-09 12:48:34', 'completed', '', NULL),
 (1264, 0, '89.217.163.49', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2146, 2149, '', '2017-02-09 16:12:01', 'completed', '', NULL),
 (1265, 0, '89.217.163.49', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-09 16:12:19', 'completed', '', NULL),
 (1266, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-02-09 20:02:37', 'completed', '', NULL),
 (1267, 0, '83.79.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Mobile/14D27 [FBAN/FBIOS;FBAV/73.0.0.44.70;FBBV/44368320;FBRV/0;FBDV/iPhone5,4;FBMD/iPhone;FBSN/iOS;FB', 2336, 2337, '', '2017-02-09 21:17:29', 'completed', '', NULL),
 (1268, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-02-10 13:48:18', 'completed', '', NULL),
 (1269, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1837, 1839, '', '2017-02-10 13:54:17', 'completed', '', NULL),
 (1270, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-02-10 13:54:31', 'completed', '', NULL),
 (1271, 0, '84.227.71.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1837, 1839, '', '2017-02-10 13:56:16', 'completed', '', NULL),
 (1272, 0, '84.227.71.228', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-02-10 15:14:50', 'completed', '', NULL),
 (1273, 0, '84.227.71.228', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-02-10 15:19:48', 'completed', '', NULL),
 (1274, 0, '84.73.72.19', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-02-10 15:46:25', 'completed', '', NULL),
 (1275, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-10 16:33:41', 'completed', '', NULL),
 (1276, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1837, 1839, '', '2017-02-10 16:35:54', 'completed', '', NULL),
 (1277, 0, '178.193.53.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.59.10 (KHTML, like Gecko) Version/5.1.9 Safari/534.59.10', 2342, 2349, '', '2017-02-10 21:07:44', 'completed', '', NULL),
 (1278, 0, '178.193.53.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.59.10 (KHTML, like Gecko) Version/5.1.9 Safari/534.59.10', 2134, 2307, '', '2017-02-10 21:17:29', 'completed', '', NULL),
 (1279, 0, '178.193.53.235', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_6_8) AppleWebKit/534.59.10 (KHTML, like Gecko) Version/5.1.9 Safari/534.59.10', 2130, 2133, '', '2017-02-10 21:20:28', 'completed', '', NULL),
 (1280, 0, '178.255.215.65', 'Mozilla/5.0 (compatible; Exabot/3.0; +http://www.exabot.com/go/robot)', 2146, 2149, '', '2017-02-11 02:12:10', 'completed', '', NULL),
 (1281, 0, '83.40.4.163', 'Java/1.8.0_65', 2128, 2367, '', '2017-02-11 05:27:31', 'completed', '', NULL),
 (1282, 0, '83.40.4.163', 'Java/1.8.0_65', 2146, 2149, '', '2017-02-11 05:27:32', 'completed', '', NULL),
 (1283, 0, '83.40.4.163', 'Java/1.8.0_65', 2333, 2334, '', '2017-02-11 05:27:33', 'completed', '', NULL),
 (1284, 0, '83.40.4.163', 'Java/1.8.0_65', 2140, 2141, '', '2017-02-11 05:27:36', 'completed', '', NULL),
 (1285, 0, '83.40.4.163', 'Java/1.8.0_65', 2336, 2337, '', '2017-02-11 05:27:38', 'completed', '', NULL),
 (1286, 0, '83.40.4.163', 'Java/1.8.0_65', 1837, 1839, '', '2017-02-11 05:27:40', 'completed', '', NULL),
 (1287, 0, '83.40.4.163', 'Java/1.8.0_65', 1844, 1845, '', '2017-02-11 05:27:42', 'completed', '', NULL),
 (1288, 0, '83.40.4.163', 'Java/1.8.0_65', 2339, 2340, '', '2017-02-11 05:27:43', 'completed', '', NULL),
 (1289, 0, '83.40.4.163', 'Java/1.8.0_65', 2130, 2133, '', '2017-02-11 05:27:45', 'completed', '', NULL),
 (1290, 0, '83.40.4.163', 'Java/1.8.0_65', 2134, 2307, '', '2017-02-11 05:27:47', 'completed', '', NULL),
 (1291, 0, '83.40.4.163', 'Java/1.8.0_65', 2161, 2162, '', '2017-02-11 05:27:49', 'completed', '', NULL),
 (1292, 0, '83.40.4.163', 'Java/1.8.0_65', 2342, 2349, '', '2017-02-11 05:27:52', 'completed', '', NULL),
 (1293, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:14', 'completed', '', NULL),
 (1294, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:23', 'completed', '', NULL),
 (1295, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:24', 'completed', '', NULL),
 (1296, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:25', 'completed', '', NULL),
 (1297, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:30', 'completed', '', NULL),
 (1298, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:44', 'completed', '', NULL),
 (1299, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:53', 'completed', '', NULL),
 (1300, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:54', 'completed', '', NULL),
 (1301, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:43:56', 'completed', '', NULL),
 (1302, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 2339, 2340, '', '2017-02-11 11:44:00', 'completed', '', NULL),
 (1303, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:16', 'completed', '', NULL),
 (1304, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:24', 'completed', '', NULL),
 (1305, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:25', 'completed', '', NULL),
 (1306, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:27', 'completed', '', NULL),
 (1307, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:31', 'completed', '', NULL),
 (1308, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:45', 'completed', '', NULL),
 (1309, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:54', 'completed', '', NULL),
 (1310, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:55', 'completed', '', NULL),
 (1311, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:44:57', 'completed', '', NULL),
 (1312, 0, '192.99.67.13', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36', 1844, 1845, '', '2017-02-11 11:45:01', 'completed', '', NULL),
 (1313, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2333, 2334, '', '2017-02-11 13:32:36', 'completed', '', NULL),
 (1314, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-02-11 17:28:46', 'completed', '', NULL),
 (1315, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-02-11 17:28:51', 'completed', '', NULL),
 (1316, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-02-11 17:28:56', 'completed', '', NULL),
 (1317, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-02-11 17:29:11', 'completed', '', NULL),
 (1318, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-02-11 17:29:17', 'completed', '', NULL),
 (1319, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-02-11 17:29:22', 'completed', '', NULL),
 (1320, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-02-11 17:29:27', 'completed', '', NULL),
 (1321, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-02-11 17:29:57', 'completed', '', NULL),
 (1322, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-02-11 17:30:01', 'completed', '', NULL),
 (1323, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-02-11 17:30:42', 'completed', '', NULL),
 (1324, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-02-11 17:30:47', 'completed', '', NULL),
 (1325, 0, '104.236.61.92', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-02-11 17:30:51', 'completed', '', NULL),
 (1326, 0, '178.197.235.180', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-02-12 13:09:57', 'completed', '', NULL),
 (1327, 0, '178.197.235.180', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-02-12 13:10:28', 'completed', '', NULL),
 (1328, 0, '178.197.235.180', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.79 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-02-12 13:11:15', 'completed', '', NULL),
 (1329, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-02-12 13:57:39', 'completed', '', NULL),
 (1330, 0, '177.47.27.236', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-12 15:33:41', 'completed', '', NULL),
 (1331, 0, '177.47.27.236', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-12 15:33:44', 'completed', '', NULL),
 (1332, 0, '177.47.27.236', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-12 15:33:45', 'completed', '', NULL),
 (1333, 0, '177.47.27.236', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-12 15:33:50', 'completed', '', NULL),
 (1334, 0, '177.47.27.236', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-12 15:33:53', 'completed', '', NULL),
 (1335, 0, '177.47.27.236', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-12 15:33:56', 'completed', '', NULL),
 (1336, 0, '177.47.27.236', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-12 15:33:58', 'completed', '', NULL),
 (1337, 0, '177.47.27.236', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-12 15:34:00', 'completed', '', NULL),
 (1338, 0, '177.47.27.236', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-12 15:34:03', 'completed', '', NULL),
 (1339, 0, '177.47.27.236', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-12 15:34:07', 'completed', '', NULL),
 (1340, 0, '177.47.27.236', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-12 15:34:12', 'completed', '', NULL),
 (1341, 0, '177.47.27.236', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-12 15:34:16', 'completed', '', NULL),
 (1342, 0, '31.10.151.163', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-02-12 20:06:16', 'completed', '', NULL),
 (1343, 0, '31.10.151.163', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-02-12 20:10:29', 'completed', '', NULL),
 (1344, 0, '31.10.151.163', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-02-12 20:11:58', 'completed', '', NULL),
 (1345, 0, '31.10.151.163', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-02-12 20:13:43', 'completed', '', NULL),
 (1346, 0, '31.10.151.163', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-02-12 20:19:24', 'completed', '', NULL),
 (1347, 0, '80.219.46.48', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-02-12 21:43:14', 'completed', '', NULL),
 (1348, 0, '188.63.15.141', 'Mozilla/5.0 (Linux; Android 4.4.2; HTC One mini 2 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 2342, 2349, '', '2017-02-12 22:05:12', 'completed', '', NULL),
 (1349, 0, '217.11.209.59', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-02-12 23:56:57', 'completed', '', NULL),
 (1350, 0, '217.11.209.59', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-02-13 00:01:45', 'completed', '', NULL),
 (1351, 0, '217.11.209.59', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-02-13 00:03:05', 'completed', '', NULL),
 (1352, 0, '68.143.60.234', 'Java/1.7.0_11', 2128, 2367, '', '2017-02-13 04:41:16', 'completed', '', NULL),
 (1353, 0, '68.143.60.234', 'Java/1.7.0_11', 2146, 2149, '', '2017-02-13 04:41:18', 'completed', '', NULL),
 (1354, 0, '68.143.60.234', 'Java/1.7.0_11', 2333, 2334, '', '2017-02-13 04:41:19', 'completed', '', NULL),
 (1355, 0, '68.143.60.234', 'Java/1.7.0_11', 2140, 2141, '', '2017-02-13 04:41:22', 'completed', '', NULL),
 (1356, 0, '68.143.60.234', 'Java/1.7.0_11', 2336, 2337, '', '2017-02-13 04:41:23', 'completed', '', NULL),
 (1357, 0, '68.143.60.234', 'Java/1.7.0_11', 1837, 1839, '', '2017-02-13 04:41:26', 'completed', '', NULL),
 (1358, 0, '68.143.60.234', 'Java/1.7.0_11', 1844, 1845, '', '2017-02-13 04:41:27', 'completed', '', NULL),
 (1359, 0, '68.143.60.234', 'Java/1.7.0_11', 2339, 2340, '', '2017-02-13 04:41:28', 'completed', '', NULL),
 (1360, 0, '68.143.60.234', 'Java/1.7.0_11', 2130, 2133, '', '2017-02-13 04:41:30', 'completed', '', NULL),
 (1361, 0, '68.143.60.234', 'Java/1.7.0_11', 2134, 2307, '', '2017-02-13 04:41:32', 'completed', '', NULL),
 (1362, 0, '68.143.60.234', 'Java/1.7.0_11', 2161, 2162, '', '2017-02-13 04:41:34', 'completed', '', NULL),
 (1363, 0, '68.143.60.234', 'Java/1.7.0_11', 2342, 2349, '', '2017-02-13 04:41:36', 'completed', '', NULL),
 (1364, 0, '195.154.56.124', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-13 06:57:33', 'completed', '', NULL),
 (1365, 0, '195.154.56.124', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-13 06:57:34', 'completed', '', NULL),
 (1366, 0, '195.154.56.124', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-13 06:57:35', 'completed', '', NULL),
 (1367, 0, '195.154.56.124', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-13 06:57:37', 'completed', '', NULL),
 (1368, 0, '195.154.56.124', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-13 06:57:38', 'completed', '', NULL),
 (1369, 0, '195.154.56.124', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-13 06:57:39', 'completed', '', NULL),
 (1370, 0, '195.154.56.124', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-13 06:57:40', 'completed', '', NULL),
 (1371, 0, '195.154.56.124', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-13 06:57:41', 'completed', '', NULL),
 (1372, 0, '195.154.56.124', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-13 06:57:43', 'completed', '', NULL),
 (1373, 0, '195.154.56.124', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-13 06:57:44', 'completed', '', NULL),
 (1374, 0, '195.154.56.124', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-13 06:57:46', 'completed', '', NULL),
 (1375, 0, '195.154.56.124', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-13 06:57:47', 'completed', '', NULL),
 (1376, 0, '130.60.222.104', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-13 09:51:20', 'completed', '', NULL),
 (1377, 0, '77.239.57.191', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-02-13 09:52:02', 'completed', '', NULL),
 (1378, 0, '79.234.71.166', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-02-13 10:22:15', 'completed', '', NULL),
 (1379, 0, '79.234.71.166', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-13 10:22:32', 'completed', '', NULL),
 (1380, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-13 11:05:20', 'completed', '', NULL),
 (1381, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-13 14:30:15', 'completed', '', NULL),
 (1382, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2339, 2340, '', '2017-02-13 14:32:29', 'completed', '', NULL),
 (1383, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-13 14:34:38', 'completed', '', NULL),
 (1384, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-13 14:45:55', 'completed', '', NULL),
 (1385, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-02-13 14:45:56', 'completed', '', NULL),
 (1386, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-02-13 14:46:53', 'completed', '', NULL),
 (1387, 0, '62.2.131.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2017-02-13 15:16:00', 'completed', '', NULL),
 (1388, 0, '176.127.241.8', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-02-13 15:58:31', 'completed', '', NULL),
 (1389, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-02-13 16:00:41', 'completed', '', NULL),
 (1390, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-02-13 16:01:11', 'completed', '', NULL),
 (1391, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-02-13 17:22:02', 'completed', '', NULL),
 (1392, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-02-13 17:22:15', 'completed', '', NULL),
 (1393, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-13 17:23:40', 'completed', '', NULL),
 (1394, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-13 21:36:57', 'completed', '', NULL),
 (1395, 0, '212.35.24.87', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1837, 1839, '', '2017-02-13 21:38:10', 'completed', '', NULL),
 (1396, 0, '188.155.79.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2336, 2337, '', '2017-02-13 21:49:12', 'completed', '', NULL),
 (1397, 0, '188.155.79.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2140, 2141, '', '2017-02-13 21:52:36', 'completed', '', NULL),
 (1398, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-14 01:35:32', 'completed', '', NULL),
 (1399, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-14 01:35:34', 'completed', '', NULL),
 (1400, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-14 01:35:35', 'completed', '', NULL),
 (1401, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-14 01:35:38', 'completed', '', NULL),
 (1402, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-14 01:35:40', 'completed', '', NULL),
 (1403, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-14 01:35:42', 'completed', '', NULL),
 (1404, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-14 01:35:43', 'completed', '', NULL),
 (1405, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-14 01:35:44', 'completed', '', NULL),
 (1406, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-14 01:35:46', 'completed', '', NULL),
 (1407, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-14 01:35:48', 'completed', '', NULL),
 (1408, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-14 01:35:50', 'completed', '', NULL),
 (1409, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-14 01:35:52', 'completed', '', NULL),
 (1410, 0, '178.197.225.141', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/22.0.141836113 Mobile/13G36 Safari/600.1.4', 2130, 2133, '', '2017-02-14 02:04:13', 'completed', '', NULL),
 (1411, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2130, 2133, '', '2017-02-14 05:48:57', 'completed', '', NULL),
 (1412, 0, '212.225.226.37', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-14 12:35:10', 'completed', '', NULL),
 (1413, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-14 12:35:11', 'completed', '', NULL),
 (1414, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-14 12:35:12', 'completed', '', NULL),
 (1415, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-14 12:35:17', 'completed', '', NULL),
 (1416, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-14 12:35:18', 'completed', '', NULL),
 (1417, 0, '212.225.226.37', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-14 12:35:20', 'completed', '', NULL),
 (1418, 0, '212.225.226.37', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-14 12:35:22', 'completed', '', NULL),
 (1419, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-14 12:35:23', 'completed', '', NULL),
 (1420, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-14 12:35:25', 'completed', '', NULL),
 (1421, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-14 12:35:27', 'completed', '', NULL),
 (1422, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-14 12:35:29', 'completed', '', NULL),
 (1423, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-14 12:35:31', 'completed', '', NULL),
 (1424, 0, '217.122.185.187', 'Java/1.8.0_111', 2128, 2367, '', '2017-02-14 12:42:30', 'completed', '', NULL),
 (1425, 0, '217.122.185.187', 'Java/1.8.0_111', 2146, 2149, '', '2017-02-14 12:42:31', 'completed', '', NULL),
 (1426, 0, '217.122.185.187', 'Java/1.8.0_111', 2333, 2334, '', '2017-02-14 12:42:31', 'completed', '', NULL),
 (1427, 0, '217.122.185.187', 'Java/1.8.0_111', 2140, 2141, '', '2017-02-14 12:42:34', 'completed', '', NULL),
 (1428, 0, '217.122.185.187', 'Java/1.8.0_111', 2336, 2337, '', '2017-02-14 12:42:35', 'completed', '', NULL),
 (1429, 0, '217.122.185.187', 'Java/1.8.0_111', 1837, 1839, '', '2017-02-14 12:42:36', 'completed', '', NULL),
 (1430, 0, '217.122.185.187', 'Java/1.8.0_111', 1844, 1845, '', '2017-02-14 12:42:37', 'completed', '', NULL),
 (1431, 0, '217.122.185.187', 'Java/1.8.0_111', 2339, 2340, '', '2017-02-14 12:42:38', 'completed', '', NULL),
 (1432, 0, '217.122.185.187', 'Java/1.8.0_111', 2130, 2133, '', '2017-02-14 12:42:39', 'completed', '', NULL),
 (1433, 0, '217.122.185.187', 'Java/1.8.0_111', 2134, 2307, '', '2017-02-14 12:42:40', 'completed', '', NULL),
 (1434, 0, '217.122.185.187', 'Java/1.8.0_111', 2342, 2349, '', '2017-02-14 12:42:43', 'completed', '', NULL),
 (1435, 0, '217.122.185.187', 'Java/1.8.0_111', 2161, 2162, '', '2017-02-14 12:47:43', 'completed', '', NULL),
 (1436, 0, '62.202.189.195', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2336, 2337, '', '2017-02-14 16:58:27', 'completed', '', NULL),
 (1437, 0, '213.213.189.241', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2140, 2141, '', '2017-02-14 18:47:24', 'completed', '', NULL),
 (1438, 0, '213.213.189.241', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G930F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-02-14 18:47:29', 'completed', '', NULL),
 (1439, 0, '62.15.204.24', 'Java/1.8.0_91', 2140, 2141, '', '2017-02-14 20:48:00', 'completed', '', NULL),
 (1440, 0, '62.15.204.24', 'Java/1.8.0_91', 2146, 2149, '', '2017-02-14 20:48:01', 'completed', '', NULL),
 (1441, 0, '62.15.204.24', 'Java/1.8.0_91', 2336, 2337, '', '2017-02-14 20:48:02', 'completed', '', NULL),
 (1442, 0, '62.15.204.24', 'Java/1.8.0_91', 1837, 1839, '', '2017-02-14 20:48:05', 'completed', '', NULL),
 (1443, 0, '62.15.204.24', 'Java/1.8.0_91', 1844, 1845, '', '2017-02-14 20:48:07', 'completed', '', NULL),
 (1444, 0, '62.15.204.24', 'Java/1.8.0_91', 2339, 2340, '', '2017-02-14 20:48:08', 'completed', '', NULL),
 (1445, 0, '72.214.133.30', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-15 06:48:18', 'completed', '', NULL),
 (1446, 0, '72.214.133.30', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-15 06:48:20', 'completed', '', NULL),
 (1447, 0, '72.214.133.30', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-15 06:48:21', 'completed', '', NULL),
 (1448, 0, '72.214.133.30', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-15 06:48:24', 'completed', '', NULL),
 (1449, 0, '72.214.133.30', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-15 06:48:26', 'completed', '', NULL),
 (1450, 0, '72.214.133.30', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-15 06:48:29', 'completed', '', NULL),
 (1451, 0, '72.214.133.30', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-15 06:48:30', 'completed', '', NULL),
 (1452, 0, '72.214.133.30', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-15 06:48:32', 'completed', '', NULL),
 (1453, 0, '72.214.133.30', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-15 06:48:35', 'completed', '', NULL),
 (1454, 0, '72.214.133.30', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-15 06:48:38', 'completed', '', NULL),
 (1455, 0, '72.214.133.30', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-15 06:48:41', 'completed', '', NULL),
 (1456, 0, '85.7.233.43', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-02-15 10:29:50', 'completed', '', NULL),
 (1457, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2146, 2149, '', '2017-02-15 18:29:18', 'completed', '', NULL),
 (1458, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2342, 2349, '', '2017-02-15 18:29:28', 'completed', '', NULL),
 (1459, 0, '62.195.2.147', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-15 19:17:11', 'completed', '', NULL),
 (1460, 0, '62.195.2.147', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-15 19:17:14', 'completed', '', NULL),
 (1461, 0, '62.195.2.147', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-15 19:17:16', 'completed', '', NULL),
 (1462, 0, '62.195.2.147', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-15 19:17:24', 'completed', '', NULL),
 (1463, 0, '62.195.2.147', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-15 19:17:28', 'completed', '', NULL),
 (1464, 0, '62.195.2.147', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-15 19:17:36', 'completed', '', NULL),
 (1465, 0, '62.195.2.147', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-15 19:17:40', 'completed', '', NULL),
 (1466, 0, '62.195.2.147', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-15 19:17:43', 'completed', '', NULL),
 (1467, 0, '62.195.2.147', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-15 19:17:52', 'completed', '', NULL),
 (1468, 0, '62.195.2.147', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-15 19:18:02', 'completed', '', NULL),
 (1469, 0, '62.195.2.147', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-15 19:18:10', 'completed', '', NULL),
 (1470, 0, '62.195.2.147', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-15 19:18:20', 'completed', '', NULL),
 (1471, 0, '192.254.79.81', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-16 04:42:37', 'completed', '', NULL),
 (1472, 0, '192.254.79.81', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-16 04:42:39', 'completed', '', NULL),
 (1473, 0, '192.254.79.81', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-16 04:42:40', 'completed', '', NULL),
 (1474, 0, '192.254.79.81', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-16 04:42:45', 'completed', '', NULL),
 (1475, 0, '192.254.79.81', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-16 04:42:47', 'completed', '', NULL),
 (1476, 0, '192.254.79.81', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-16 04:42:51', 'completed', '', NULL),
 (1477, 0, '192.254.79.81', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-16 04:42:52', 'completed', '', NULL),
 (1478, 0, '192.254.79.81', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-16 04:42:53', 'completed', '', NULL),
 (1479, 0, '192.254.79.81', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-16 04:42:56', 'completed', '', NULL),
 (1480, 0, '192.254.79.81', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-16 04:42:59', 'completed', '', NULL),
 (1481, 0, '192.254.79.81', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-16 04:43:02', 'completed', '', NULL),
 (1482, 0, '192.254.79.81', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-16 04:43:05', 'completed', '', NULL),
 (1483, 0, '209.222.108.83', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-16 06:15:35', 'completed', '', NULL),
 (1484, 0, '209.222.108.83', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-16 06:15:39', 'completed', '', NULL),
 (1485, 0, '209.222.108.83', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-16 06:15:41', 'completed', '', NULL),
 (1486, 0, '209.222.108.83', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-16 06:15:52', 'completed', '', NULL),
 (1487, 0, '209.222.108.83', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-16 06:15:56', 'completed', '', NULL),
 (1488, 0, '209.222.108.83', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-16 06:16:07', 'completed', '', NULL),
 (1489, 0, '209.222.108.83', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-16 06:16:09', 'completed', '', NULL),
 (1490, 0, '209.222.108.83', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-16 06:16:13', 'completed', '', NULL),
 (1491, 0, '209.222.108.83', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-16 06:16:20', 'completed', '', NULL),
 (1492, 0, '209.222.108.83', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-16 06:16:28', 'completed', '', NULL),
 (1493, 0, '209.222.108.83', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-16 06:16:37', 'completed', '', NULL),
 (1494, 0, '209.222.108.83', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-16 06:16:48', 'completed', '', NULL),
 (1495, 0, '192.254.79.81', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-16 13:55:19', 'completed', '', NULL),
 (1496, 0, '192.254.79.81', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-16 13:55:20', 'completed', '', NULL),
 (1497, 0, '192.254.79.81', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-16 13:55:22', 'completed', '', NULL),
 (1498, 0, '192.254.79.81', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-16 13:55:27', 'completed', '', NULL),
 (1499, 0, '192.254.79.81', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-16 13:55:28', 'completed', '', NULL),
 (1500, 0, '192.254.79.81', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-16 13:55:31', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(1501, 0, '192.254.79.81', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-16 13:55:32', 'completed', '', NULL),
 (1502, 0, '192.254.79.81', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-16 13:55:33', 'completed', '', NULL),
 (1503, 0, '192.254.79.81', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-16 13:55:38', 'completed', '', NULL),
 (1504, 0, '192.254.79.81', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-16 13:55:41', 'completed', '', NULL),
 (1505, 0, '192.254.79.81', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-16 13:55:45', 'completed', '', NULL),
 (1506, 0, '192.254.79.81', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-16 13:55:48', 'completed', '', NULL),
 (1507, 0, '92.104.30.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2161, 2162, '', '2017-02-17 00:33:14', 'completed', '', NULL),
 (1508, 0, '31.10.140.91', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2336, 2337, '', '2017-02-17 11:46:32', 'completed', '', NULL),
 (1509, 0, '84.253.55.210', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-17 16:42:27', 'completed', '', NULL),
 (1510, 0, '51.255.65.57', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-02-17 18:58:55', 'completed', '', NULL),
 (1511, 0, '83.77.42.104', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-02-17 19:26:45', 'completed', '', NULL),
 (1512, 0, '217.11.209.20', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-02-17 20:56:22', 'completed', '', NULL),
 (1513, 0, '217.11.209.20', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-02-17 20:56:22', 'completed', '', NULL),
 (1514, 0, '178.197.232.45', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-02-17 21:40:28', 'completed', '', NULL),
 (1515, 0, '164.132.161.6', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-02-17 21:52:28', 'completed', '', NULL),
 (1516, 0, '37.49.224.209', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-18 00:00:30', 'completed', '', NULL),
 (1517, 0, '37.49.224.209', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-18 00:00:31', 'completed', '', NULL),
 (1518, 0, '37.49.224.209', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-18 00:00:32', 'completed', '', NULL),
 (1519, 0, '37.49.224.209', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-18 00:00:36', 'completed', '', NULL),
 (1520, 0, '37.49.224.209', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-18 00:00:37', 'completed', '', NULL),
 (1521, 0, '37.49.224.209', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-18 00:00:38', 'completed', '', NULL),
 (1522, 0, '37.49.224.209', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-18 00:00:39', 'completed', '', NULL),
 (1523, 0, '37.49.224.209', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-18 00:00:40', 'completed', '', NULL),
 (1524, 0, '37.49.224.209', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-18 00:00:41', 'completed', '', NULL),
 (1525, 0, '37.49.224.209', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-18 00:00:42', 'completed', '', NULL),
 (1526, 0, '37.49.224.209', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-18 00:00:43', 'completed', '', NULL),
 (1527, 0, '37.49.224.209', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-18 00:00:44', 'completed', '', NULL),
 (1528, 0, '51.255.65.25', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-02-18 04:06:55', 'completed', '', NULL),
 (1529, 0, '192.69.95.152', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-18 07:08:02', 'completed', '', NULL),
 (1530, 0, '192.69.95.152', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-18 07:08:03', 'completed', '', NULL),
 (1531, 0, '192.69.95.152', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-18 07:08:04', 'completed', '', NULL),
 (1532, 0, '192.69.95.152', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-18 07:08:09', 'completed', '', NULL),
 (1533, 0, '192.69.95.152', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-18 07:08:11', 'completed', '', NULL),
 (1534, 0, '192.69.95.152', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-18 07:08:14', 'completed', '', NULL),
 (1535, 0, '192.69.95.152', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-18 07:08:16', 'completed', '', NULL),
 (1536, 0, '192.69.95.152', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-18 07:08:17', 'completed', '', NULL),
 (1537, 0, '192.69.95.152', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-18 07:08:20', 'completed', '', NULL),
 (1538, 0, '192.69.95.152', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-18 07:08:23', 'completed', '', NULL),
 (1539, 0, '192.69.95.152', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-18 07:08:27', 'completed', '', NULL),
 (1540, 0, '192.69.95.152', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-18 07:08:31', 'completed', '', NULL),
 (1541, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1837, 1839, '', '2017-02-18 11:14:04', 'completed', '', NULL),
 (1542, 0, '95.85.62.134', 'SafeDNSBot (https://www.safedns.com/searchbot)', 2336, 2337, '', '2017-02-18 14:20:31', 'completed', '', NULL),
 (1543, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2017-02-18 16:08:27', 'completed', '', NULL),
 (1544, 0, '40.77.167.56', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-02-18 16:50:05', 'completed', '', NULL),
 (1545, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-02-18 18:47:51', 'completed', '', NULL),
 (1546, 0, '81.185.237.185', 'Java/1.7.0_79', 2146, 2149, '', '2017-02-18 18:47:52', 'completed', '', NULL),
 (1547, 0, '81.185.237.185', 'Java/1.7.0_79', 2333, 2334, '', '2017-02-18 18:47:53', 'completed', '', NULL),
 (1548, 0, '81.185.237.185', 'Java/1.7.0_79', 2140, 2141, '', '2017-02-18 18:47:55', 'completed', '', NULL),
 (1549, 0, '81.185.237.185', 'Java/1.7.0_79', 2336, 2337, '', '2017-02-18 18:47:56', 'completed', '', NULL),
 (1550, 0, '81.185.237.185', 'Java/1.7.0_79', 1837, 1839, '', '2017-02-18 18:47:57', 'completed', '', NULL),
 (1551, 0, '81.185.237.185', 'Java/1.7.0_79', 1844, 1845, '', '2017-02-18 18:47:58', 'completed', '', NULL),
 (1552, 0, '81.185.237.185', 'Java/1.7.0_79', 2339, 2340, '', '2017-02-18 18:47:59', 'completed', '', NULL),
 (1553, 0, '81.185.237.185', 'Java/1.7.0_79', 2130, 2133, '', '2017-02-18 18:48:00', 'completed', '', NULL),
 (1554, 0, '81.185.237.185', 'Java/1.7.0_79', 2134, 2307, '', '2017-02-18 18:48:02', 'completed', '', NULL),
 (1555, 0, '81.185.237.185', 'Java/1.7.0_79', 2161, 2162, '', '2017-02-18 18:48:03', 'completed', '', NULL),
 (1556, 0, '81.185.237.185', 'Java/1.7.0_79', 2342, 2349, '', '2017-02-18 18:48:04', 'completed', '', NULL),
 (1557, 0, '40.77.167.56', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-02-18 19:44:41', 'completed', '', NULL),
 (1558, 0, '103.41.177.71', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-19 12:47:22', 'completed', '', NULL),
 (1559, 0, '103.41.177.71', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-19 12:47:31', 'completed', '', NULL),
 (1560, 0, '103.41.177.71', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-19 12:47:34', 'completed', '', NULL),
 (1561, 0, '103.41.177.71', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-19 12:47:45', 'completed', '', NULL),
 (1562, 0, '103.41.177.71', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-19 12:47:48', 'completed', '', NULL),
 (1563, 0, '103.41.177.71', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-19 12:47:56', 'completed', '', NULL),
 (1564, 0, '103.41.177.71', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-19 12:48:12', 'completed', '', NULL),
 (1565, 0, '103.41.177.71', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-19 12:48:14', 'completed', '', NULL),
 (1566, 0, '103.41.177.71', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-19 12:48:30', 'completed', '', NULL),
 (1567, 0, '103.41.177.71', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-19 12:48:56', 'completed', '', NULL),
 (1568, 0, '103.41.177.71', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-19 12:49:10', 'completed', '', NULL),
 (1569, 0, '103.41.177.71', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-19 12:49:22', 'completed', '', NULL),
 (1570, 0, '213.127.23.204', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-19 15:36:50', 'completed', '', NULL),
 (1571, 0, '213.127.23.204', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-19 15:36:53', 'completed', '', NULL),
 (1572, 0, '213.127.23.204', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-19 15:36:54', 'completed', '', NULL),
 (1573, 0, '213.127.23.204', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-19 15:37:03', 'completed', '', NULL),
 (1574, 0, '213.127.23.204', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-19 15:37:08', 'completed', '', NULL),
 (1575, 0, '213.127.23.204', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-19 15:37:15', 'completed', '', NULL),
 (1576, 0, '213.127.23.204', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-19 15:37:17', 'completed', '', NULL),
 (1577, 0, '213.127.23.204', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-19 15:37:20', 'completed', '', NULL),
 (1578, 0, '213.127.23.204', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-19 15:37:26', 'completed', '', NULL),
 (1579, 0, '213.127.23.204', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-19 15:37:33', 'completed', '', NULL),
 (1580, 0, '213.127.23.204', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-19 15:42:39', 'completed', '', NULL),
 (1581, 0, '213.127.23.204', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-19 15:42:43', 'completed', '', NULL),
 (1582, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2017-02-19 23:55:03', 'completed', '', NULL),
 (1583, 0, '178.196.91.211', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2134, 2307, '', '2017-02-20 09:48:50', 'completed', '', NULL),
 (1584, 0, '178.196.91.211', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2130, 2133, '', '2017-02-20 09:49:46', 'completed', '', NULL),
 (1585, 0, '176.127.198.41', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-20 11:07:03', 'completed', '', NULL),
 (1586, 0, '158.181.116.11', 'Mozilla/5.0 (Android 6.0.1; Tablet; rv:48.0) Gecko/48.0 Firefox/48.0', 2140, 2141, '', '2017-02-20 11:10:03', 'completed', '', NULL),
 (1587, 0, '158.181.116.11', 'Mozilla/5.0 (Android 6.0.1; Tablet; rv:48.0) Gecko/48.0 Firefox/48.0', 2336, 2337, '', '2017-02-20 11:10:25', 'completed', '', NULL),
 (1588, 0, '158.181.116.11', 'Mozilla/5.0 (Android 6.0.1; Tablet; rv:48.0) Gecko/48.0 Firefox/48.0', 2339, 2340, '', '2017-02-20 11:11:42', 'completed', '', NULL),
 (1589, 0, '158.181.116.11', 'Mozilla/5.0 (Android 6.0.1; Tablet; rv:48.0) Gecko/48.0 Firefox/48.0', 2342, 2349, '', '2017-02-20 11:13:51', 'completed', '', NULL),
 (1590, 0, '176.127.198.41', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2342, 2349, '', '2017-02-20 11:13:56', 'completed', '', NULL),
 (1591, 0, '176.127.198.41', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2130, 2133, '', '2017-02-20 11:15:25', 'completed', '', NULL),
 (1592, 0, '62.65.142.188', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_2) AppleWebKit/600.4.8 (KHTML, like Gecko) Version/8.0.3 Safari/600.4.8', 2134, 2307, '', '2017-02-20 11:34:09', 'completed', '', NULL),
 (1593, 0, '83.77.178.203', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2336, 2337, '', '2017-02-20 12:28:36', 'completed', '', NULL),
 (1594, 0, '83.77.178.203', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-20 12:32:11', 'completed', '', NULL),
 (1595, 0, '83.77.178.203', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-20 12:32:20', 'completed', '', NULL),
 (1596, 0, '71.167.24.28', 'Java/1.7.0_67', 2128, 2367, '', '2017-02-20 16:00:04', 'completed', '', NULL),
 (1597, 0, '71.167.24.28', 'Java/1.7.0_67', 2146, 2149, '', '2017-02-20 16:00:06', 'completed', '', NULL),
 (1598, 0, '71.167.24.28', 'Java/1.7.0_67', 2333, 2334, '', '2017-02-20 16:00:07', 'completed', '', NULL),
 (1599, 0, '71.167.24.28', 'Java/1.7.0_67', 2140, 2141, '', '2017-02-20 16:00:10', 'completed', '', NULL),
 (1600, 0, '71.167.24.28', 'Java/1.7.0_67', 2336, 2337, '', '2017-02-20 16:00:11', 'completed', '', NULL),
 (1601, 0, '71.167.24.28', 'Java/1.7.0_67', 1837, 1839, '', '2017-02-20 16:00:13', 'completed', '', NULL),
 (1602, 0, '71.167.24.28', 'Java/1.7.0_67', 1844, 1845, '', '2017-02-20 16:00:14', 'completed', '', NULL),
 (1603, 0, '71.167.24.28', 'Java/1.7.0_67', 2339, 2340, '', '2017-02-20 16:00:15', 'completed', '', NULL),
 (1604, 0, '71.167.24.28', 'Java/1.7.0_67', 2130, 2133, '', '2017-02-20 16:00:16', 'completed', '', NULL),
 (1605, 0, '71.167.24.28', 'Java/1.7.0_67', 2134, 2307, '', '2017-02-20 16:00:18', 'completed', '', NULL),
 (1606, 0, '71.167.24.28', 'Java/1.7.0_67', 2161, 2162, '', '2017-02-20 16:00:20', 'completed', '', NULL),
 (1607, 0, '71.167.24.28', 'Java/1.7.0_67', 2342, 2349, '', '2017-02-20 16:00:21', 'completed', '', NULL),
 (1608, 0, '178.198.162.174', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-20 16:50:50', 'completed', '', NULL),
 (1609, 0, '178.198.162.174', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2333, 2334, '', '2017-02-20 16:52:26', 'completed', '', NULL),
 (1610, 0, '178.198.162.174', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-20 20:27:48', 'completed', '', NULL),
 (1611, 0, '178.198.162.174', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-20 20:30:57', 'completed', '', NULL),
 (1612, 0, '178.198.162.174', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-02-20 20:32:56', 'completed', '', NULL),
 (1613, 0, '103.41.177.71', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-20 22:39:08', 'completed', '', NULL),
 (1614, 0, '103.41.177.71', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-20 22:39:14', 'completed', '', NULL),
 (1615, 0, '103.41.177.71', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-20 22:39:15', 'completed', '', NULL),
 (1616, 0, '103.41.177.71', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-20 22:39:31', 'completed', '', NULL),
 (1617, 0, '103.41.177.71', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-20 22:39:44', 'completed', '', NULL),
 (1618, 0, '103.41.177.71', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-20 22:40:04', 'completed', '', NULL),
 (1619, 0, '103.41.177.71', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-20 22:40:05', 'completed', '', NULL),
 (1620, 0, '103.41.177.71', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-20 22:40:17', 'completed', '', NULL),
 (1621, 0, '103.41.177.71', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-20 22:40:23', 'completed', '', NULL),
 (1622, 0, '103.41.177.71', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-20 22:40:32', 'completed', '', NULL),
 (1623, 0, '103.41.177.71', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-20 22:40:44', 'completed', '', NULL),
 (1624, 0, '103.41.177.71', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-20 22:40:55', 'completed', '', NULL),
 (1625, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-02-21 07:33:44', 'completed', '', NULL),
 (1626, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-02-21 07:33:49', 'completed', '', NULL),
 (1627, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-02-21 07:33:54', 'completed', '', NULL),
 (1628, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-02-21 07:34:14', 'completed', '', NULL),
 (1629, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-02-21 07:34:19', 'completed', '', NULL),
 (1630, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-02-21 07:34:24', 'completed', '', NULL),
 (1631, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-02-21 07:34:30', 'completed', '', NULL),
 (1632, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-02-21 07:35:04', 'completed', '', NULL),
 (1633, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-02-21 07:35:10', 'completed', '', NULL),
 (1634, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-02-21 07:35:44', 'completed', '', NULL),
 (1635, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-02-21 07:35:49', 'completed', '', NULL),
 (1636, 0, '138.197.114.102', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-02-21 07:35:53', 'completed', '', NULL),
 (1637, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-02-21 12:54:21', 'completed', '', NULL),
 (1638, 0, '77.59.254.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-02-21 15:54:38', 'completed', '', NULL),
 (1639, 0, '77.59.254.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-02-21 15:55:11', 'completed', '', NULL),
 (1640, 0, '77.59.254.10', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-21 15:57:12', 'completed', '', NULL),
 (1641, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-02-21 16:34:29', 'completed', '', NULL),
 (1642, 0, '85.6.140.26', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-02-21 16:37:04', 'completed', '', NULL),
 (1643, 0, '85.6.140.26', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-02-21 16:37:25', 'completed', '', NULL),
 (1644, 0, '85.6.140.26', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-02-21 16:42:14', 'completed', '', NULL),
 (1645, 0, '85.6.140.26', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-02-21 16:42:46', 'completed', '', NULL),
 (1646, 0, '178.197.225.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2161, 2162, '', '2017-02-21 19:16:58', 'completed', '', NULL),
 (1647, 0, '88.15.29.143', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-21 22:22:23', 'completed', '', NULL),
 (1648, 0, '88.15.29.143', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-21 22:22:24', 'completed', '', NULL),
 (1649, 0, '88.15.29.143', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-21 22:22:25', 'completed', '', NULL),
 (1650, 0, '88.15.29.143', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-21 22:22:28', 'completed', '', NULL),
 (1651, 0, '88.15.29.143', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-21 22:22:30', 'completed', '', NULL),
 (1652, 0, '88.15.29.143', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-21 22:22:34', 'completed', '', NULL),
 (1653, 0, '88.15.29.143', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-21 22:22:35', 'completed', '', NULL),
 (1654, 0, '88.15.29.143', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-21 22:22:36', 'completed', '', NULL),
 (1655, 0, '88.15.29.143', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-21 22:22:40', 'completed', '', NULL),
 (1656, 0, '88.15.29.143', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-21 22:22:43', 'completed', '', NULL),
 (1657, 0, '88.15.29.143', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-21 22:22:45', 'completed', '', NULL),
 (1658, 0, '88.15.29.143', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-21 22:22:47', 'completed', '', NULL),
 (1659, 0, '80.66.232.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-22 00:09:41', 'completed', '', NULL),
 (1660, 0, '80.66.232.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-02-22 00:11:54', 'completed', '', NULL),
 (1661, 0, '80.66.232.150', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-02-22 00:12:43', 'completed', '', NULL),
 (1662, 0, '86.126.151.171', 'Java/1.7.0_79', 2128, 2367, '', '2017-02-22 03:23:14', 'completed', '', NULL),
 (1663, 0, '86.126.151.171', 'Java/1.7.0_79', 2146, 2149, '', '2017-02-22 03:23:15', 'completed', '', NULL),
 (1664, 0, '86.126.151.171', 'Java/1.7.0_79', 2333, 2334, '', '2017-02-22 03:23:16', 'completed', '', NULL),
 (1665, 0, '86.126.151.171', 'Java/1.7.0_79', 2140, 2141, '', '2017-02-22 03:23:19', 'completed', '', NULL),
 (1666, 0, '86.126.151.171', 'Java/1.7.0_79', 2336, 2337, '', '2017-02-22 03:23:20', 'completed', '', NULL),
 (1667, 0, '86.126.151.171', 'Java/1.7.0_79', 1837, 1839, '', '2017-02-22 03:23:24', 'completed', '', NULL),
 (1668, 0, '86.126.151.171', 'Java/1.7.0_79', 1844, 1845, '', '2017-02-22 03:23:25', 'completed', '', NULL),
 (1669, 0, '86.126.151.171', 'Java/1.7.0_79', 2339, 2340, '', '2017-02-22 03:23:27', 'completed', '', NULL),
 (1670, 0, '86.126.151.171', 'Java/1.7.0_79', 2130, 2133, '', '2017-02-22 03:23:31', 'completed', '', NULL),
 (1671, 0, '86.126.151.171', 'Java/1.7.0_79', 2134, 2307, '', '2017-02-22 03:23:34', 'completed', '', NULL),
 (1672, 0, '86.126.151.171', 'Java/1.7.0_79', 2161, 2162, '', '2017-02-22 03:23:37', 'completed', '', NULL),
 (1673, 0, '86.126.151.171', 'Java/1.7.0_79', 2342, 2349, '', '2017-02-22 03:23:40', 'completed', '', NULL),
 (1674, 0, '217.27.111.24', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2017-02-22 09:13:33', 'completed', '', NULL),
 (1675, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-22 09:28:45', 'completed', '', NULL),
 (1676, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-22 09:28:47', 'completed', '', NULL),
 (1677, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-22 09:28:48', 'completed', '', NULL),
 (1678, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-22 09:28:50', 'completed', '', NULL),
 (1679, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-22 09:28:52', 'completed', '', NULL),
 (1680, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-22 09:28:54', 'completed', '', NULL),
 (1681, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-22 09:28:55', 'completed', '', NULL),
 (1682, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-22 09:28:57', 'completed', '', NULL),
 (1683, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-22 09:28:59', 'completed', '', NULL),
 (1684, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-22 09:29:01', 'completed', '', NULL),
 (1685, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-22 09:29:03', 'completed', '', NULL),
 (1686, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-22 09:29:07', 'completed', '', NULL),
 (1687, 0, '217.27.111.24', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-22 12:52:56', 'completed', '', NULL),
 (1688, 0, '62.167.140.5', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2140, 2141, '', '2017-02-22 12:53:51', 'completed', '', NULL),
 (1689, 0, '62.167.140.5', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2336, 2337, '', '2017-02-22 12:55:45', 'completed', '', NULL),
 (1690, 0, '217.27.111.24', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2161, 2162, '', '2017-02-22 12:55:53', 'completed', '', NULL),
 (1691, 0, '62.167.140.5', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2336, 2337, '', '2017-02-22 13:10:27', 'completed', '', NULL),
 (1692, 0, '77.245.183.208', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-02-22 14:59:43', 'completed', '', NULL),
 (1693, 0, '77.245.183.208', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-02-22 15:00:57', 'completed', '', NULL),
 (1694, 0, '109.106.53.160', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2339, 2340, '', '2017-02-22 15:19:28', 'completed', '', NULL),
 (1695, 0, '109.106.53.160', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-22 15:20:32', 'completed', '', NULL),
 (1696, 0, '77.250.67.242', 'Java/1.8.0_77', 2128, 2367, '', '2017-02-22 19:37:06', 'completed', '', NULL),
 (1697, 0, '77.250.67.242', 'Java/1.8.0_77', 2146, 2149, '', '2017-02-22 19:37:07', 'completed', '', NULL),
 (1698, 0, '77.250.67.242', 'Java/1.8.0_77', 2333, 2334, '', '2017-02-22 19:37:08', 'completed', '', NULL),
 (1699, 0, '77.250.67.242', 'Java/1.8.0_77', 2140, 2141, '', '2017-02-22 19:37:11', 'completed', '', NULL),
 (1700, 0, '77.250.67.242', 'Java/1.8.0_77', 2336, 2337, '', '2017-02-22 19:37:13', 'completed', '', NULL),
 (1701, 0, '77.250.67.242', 'Java/1.8.0_77', 1837, 1839, '', '2017-02-22 19:37:15', 'completed', '', NULL),
 (1702, 0, '77.250.67.242', 'Java/1.8.0_77', 1844, 1845, '', '2017-02-22 19:37:16', 'completed', '', NULL),
 (1703, 0, '77.250.67.242', 'Java/1.8.0_77', 2339, 2340, '', '2017-02-22 19:37:16', 'completed', '', NULL),
 (1704, 0, '77.250.67.242', 'Java/1.8.0_77', 2130, 2133, '', '2017-02-22 19:37:18', 'completed', '', NULL),
 (1705, 0, '77.250.67.242', 'Java/1.8.0_77', 2134, 2307, '', '2017-02-22 19:37:20', 'completed', '', NULL),
 (1706, 0, '77.250.67.242', 'Java/1.8.0_77', 2161, 2162, '', '2017-02-22 19:37:22', 'completed', '', NULL),
 (1707, 0, '77.250.67.242', 'Java/1.8.0_77', 2342, 2349, '', '2017-02-22 19:37:23', 'completed', '', NULL),
 (1708, 0, '68.180.230.224', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-02-23 13:42:24', 'completed', '', NULL),
 (1709, 0, '83.77.87.153', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-23 21:21:55', 'completed', '', NULL),
 (1710, 0, '83.77.87.153', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-23 21:23:18', 'completed', '', NULL),
 (1711, 0, '83.77.87.153', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-23 21:23:58', 'completed', '', NULL),
 (1712, 0, '40.77.167.97', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-02-23 23:32:48', 'completed', '', NULL),
 (1713, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-02-24 08:00:08', 'completed', '', NULL),
 (1714, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-02-24 10:11:37', 'completed', '', NULL),
 (1715, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-02-24 10:12:31', 'completed', '', NULL),
 (1716, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2336, 2337, '', '2017-02-24 10:19:14', 'completed', '', NULL),
 (1717, 0, '85.3.47.247', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2336, 2337, '', '2017-02-24 10:35:57', 'completed', '', NULL),
 (1718, 0, '62.202.189.72', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-02-24 12:10:43', 'completed', '', NULL),
 (1719, 0, '62.202.189.72', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-02-24 12:11:02', 'completed', '', NULL),
 (1720, 0, '80.218.40.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-02-24 14:24:40', 'completed', '', NULL),
 (1721, 0, '37.48.118.107', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-24 17:52:53', 'completed', '', NULL),
 (1722, 0, '37.48.118.107', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-24 17:52:54', 'completed', '', NULL),
 (1723, 0, '37.48.118.107', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-24 17:52:54', 'completed', '', NULL),
 (1724, 0, '37.48.118.107', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-24 17:52:56', 'completed', '', NULL),
 (1725, 0, '37.48.118.107', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-24 17:52:57', 'completed', '', NULL),
 (1726, 0, '37.48.118.107', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-24 17:52:59', 'completed', '', NULL),
 (1727, 0, '37.48.118.107', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-24 17:52:59', 'completed', '', NULL),
 (1728, 0, '37.48.118.107', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-24 17:53:00', 'completed', '', NULL),
 (1729, 0, '37.48.118.107', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-24 17:53:02', 'completed', '', NULL),
 (1730, 0, '37.48.118.107', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-24 17:53:03', 'completed', '', NULL),
 (1731, 0, '37.48.118.107', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-24 17:53:05', 'completed', '', NULL),
 (1732, 0, '37.48.118.107', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-24 17:53:07', 'completed', '', NULL),
 (1733, 0, '84.226.19.62', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2134, 2307, '', '2017-02-24 18:29:50', 'completed', '', NULL),
 (1734, 0, '84.226.19.62', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2134, 2307, '', '2017-02-24 20:05:10', 'completed', '', NULL),
 (1735, 0, '27.122.119.13', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-24 21:54:15', 'completed', '', NULL),
 (1736, 0, '27.122.119.13', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-24 21:54:17', 'completed', '', NULL),
 (1737, 0, '27.122.119.13', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-24 21:54:19', 'completed', '', NULL),
 (1738, 0, '27.122.119.13', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-24 21:54:23', 'completed', '', NULL),
 (1739, 0, '27.122.119.13', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-24 21:54:26', 'completed', '', NULL),
 (1740, 0, '27.122.119.13', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-24 21:54:29', 'completed', '', NULL),
 (1741, 0, '27.122.119.13', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-24 21:54:30', 'completed', '', NULL),
 (1742, 0, '27.122.119.13', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-24 21:54:32', 'completed', '', NULL),
 (1743, 0, '27.122.119.13', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-24 21:54:35', 'completed', '', NULL),
 (1744, 0, '27.122.119.13', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-24 21:54:39', 'completed', '', NULL),
 (1745, 0, '27.122.119.13', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-24 21:54:43', 'completed', '', NULL),
 (1746, 0, '27.122.119.13', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-24 21:54:46', 'completed', '', NULL),
 (1747, 0, '163.172.65.184', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-02-24 22:13:49', 'completed', '', NULL),
 (1748, 0, '62.84.152.162', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-24 23:26:32', 'completed', '', NULL),
 (1749, 0, '62.84.152.162', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-24 23:26:33', 'completed', '', NULL),
 (1750, 0, '62.84.152.162', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-24 23:26:33', 'completed', '', NULL),
 (1751, 0, '62.84.152.162', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-24 23:26:36', 'completed', '', NULL),
 (1752, 0, '62.84.152.162', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-24 23:26:38', 'completed', '', NULL),
 (1753, 0, '62.84.152.162', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-24 23:26:40', 'completed', '', NULL),
 (1754, 0, '62.84.152.162', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-24 23:26:41', 'completed', '', NULL),
 (1755, 0, '62.84.152.162', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-24 23:26:42', 'completed', '', NULL),
 (1756, 0, '62.84.152.162', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-24 23:26:43', 'completed', '', NULL),
 (1757, 0, '62.84.152.162', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-24 23:26:45', 'completed', '', NULL),
 (1758, 0, '62.84.152.162', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-24 23:26:46', 'completed', '', NULL),
 (1759, 0, '62.84.152.162', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-24 23:26:48', 'completed', '', NULL),
 (1760, 0, '51.255.65.65', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-02-25 01:43:57', 'completed', '', NULL),
 (1761, 0, '96.56.24.130', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-25 04:07:13', 'completed', '', NULL),
 (1762, 0, '96.56.24.130', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-25 04:07:14', 'completed', '', NULL),
 (1763, 0, '96.56.24.130', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-25 04:07:15', 'completed', '', NULL),
 (1764, 0, '96.56.24.130', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-25 04:07:18', 'completed', '', NULL),
 (1765, 0, '96.56.24.130', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-25 04:07:19', 'completed', '', NULL),
 (1766, 0, '96.56.24.130', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-25 04:07:25', 'completed', '', NULL),
 (1767, 0, '96.56.24.130', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-25 04:07:26', 'completed', '', NULL),
 (1768, 0, '96.56.24.130', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-25 04:07:27', 'completed', '', NULL),
 (1769, 0, '96.56.24.130', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-25 04:07:29', 'completed', '', NULL),
 (1770, 0, '96.56.24.130', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-25 04:07:31', 'completed', '', NULL),
 (1771, 0, '96.56.24.130', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-25 04:07:33', 'completed', '', NULL),
 (1772, 0, '96.56.24.130', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-25 04:07:35', 'completed', '', NULL),
 (1773, 0, '163.172.65.21', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-02-25 04:49:30', 'completed', '', NULL),
 (1774, 0, '84.226.19.62', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2130, 2133, '', '2017-02-25 09:37:49', 'completed', '', NULL),
 (1775, 0, '178.82.95.150', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-02-25 10:15:13', 'completed', '', NULL),
 (1776, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-02-25 11:00:06', 'completed', '', NULL),
 (1777, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-02-25 11:00:36', 'completed', '', NULL),
 (1778, 0, '51.255.65.26', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-02-25 11:09:18', 'completed', '', NULL),
 (1779, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-25 11:37:06', 'completed', '', NULL),
 (1780, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2130, 2133, '', '2017-02-25 11:37:13', 'completed', '', NULL),
 (1781, 0, '62.28.191.178', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-25 12:34:42', 'completed', '', NULL),
 (1782, 0, '62.28.191.178', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-25 12:34:43', 'completed', '', NULL),
 (1783, 0, '62.28.191.178', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-25 12:34:44', 'completed', '', NULL),
 (1784, 0, '62.28.191.178', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-25 12:34:46', 'completed', '', NULL),
 (1785, 0, '62.28.191.178', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-25 12:34:48', 'completed', '', NULL),
 (1786, 0, '62.28.191.178', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-25 12:34:49', 'completed', '', NULL),
 (1787, 0, '62.28.191.178', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-25 12:34:50', 'completed', '', NULL),
 (1788, 0, '62.28.191.178', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-25 12:34:51', 'completed', '', NULL),
 (1789, 0, '62.28.191.178', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-25 12:34:52', 'completed', '', NULL),
 (1790, 0, '62.28.191.178', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-25 12:34:54', 'completed', '', NULL),
 (1791, 0, '62.28.191.178', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-25 12:34:55', 'completed', '', NULL),
 (1792, 0, '62.28.191.178', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-25 12:34:57', 'completed', '', NULL),
 (1793, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-25 12:45:01', 'completed', '', NULL),
 (1794, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2336, 2337, '', '2017-02-25 12:47:58', 'completed', '', NULL),
 (1795, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-25 12:56:18', 'completed', '', NULL),
 (1796, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2146, 2149, '', '2017-02-25 12:57:28', 'completed', '', NULL),
 (1797, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2339, 2340, '', '2017-02-25 12:58:26', 'completed', '', NULL),
 (1798, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-02-25 13:07:57', 'completed', '', NULL),
 (1799, 0, '85.1.90.4', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-02-25 13:10:16', 'completed', '', NULL),
 (1800, 0, '84.226.19.62', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2134, 2307, '', '2017-02-25 15:03:50', 'completed', '', NULL),
 (1801, 0, '84.226.19.62', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_9_5) AppleWebKit/601.7.8 (KHTML, like Gecko) Version/9.1.3 Safari/537.86.7', 2342, 2349, '', '2017-02-25 15:04:15', 'completed', '', NULL),
 (1802, 0, '213.55.176.130', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G935F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-02-25 21:31:53', 'completed', '', NULL),
 (1803, 0, '213.55.176.130', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G935F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-02-25 21:31:56', 'completed', '', NULL),
 (1804, 0, '188.62.114.175', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2336, 2337, '', '2017-02-25 21:34:24', 'completed', '', NULL),
 (1805, 0, '194.230.159.190', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-02-26 00:12:02', 'completed', '', NULL),
 (1806, 0, '51.255.65.12', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-02-26 07:50:18', 'completed', '', NULL),
 (1807, 0, '188.155.56.150', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-02-26 20:16:15', 'completed', '', NULL),
 (1808, 0, '188.155.56.150', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-02-26 20:16:43', 'completed', '', NULL),
 (1809, 0, '188.155.56.150', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-02-26 20:18:49', 'completed', '', NULL),
 (1810, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2128, 2367, '', '2017-02-26 22:01:59', 'completed', '', NULL),
 (1811, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 1844, 1845, '', '2017-02-27 00:09:01', 'completed', '', NULL),
 (1812, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2339, 2340, '', '2017-02-27 00:10:03', 'completed', '', NULL),
 (1813, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 1837, 1839, '', '2017-02-27 00:10:58', 'completed', '', NULL),
 (1814, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-02-27 00:15:08', 'completed', '', NULL),
 (1815, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2161, 2162, '', '2017-02-27 00:16:31', 'completed', '', NULL),
 (1816, 0, '5.145.85.203', 'Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2161, 2162, '', '2017-02-27 00:16:32', 'completed', '', NULL),
 (1817, 0, '157.55.39.195', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-02-27 06:00:16', 'completed', '', NULL),
 (1818, 0, '89.206.64.5', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-02-27 11:02:33', 'completed', '', NULL),
 (1819, 0, '89.206.64.5', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-02-27 11:03:39', 'completed', '', NULL),
 (1820, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-02-27 16:31:11', 'completed', '', NULL),
 (1821, 0, '178.197.225.139', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-02-27 17:21:54', 'completed', '', NULL),
 (1822, 0, '178.197.225.139', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-02-27 17:22:30', 'completed', '', NULL),
 (1823, 0, '92.104.225.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-02-27 17:29:43', 'completed', '', NULL),
 (1824, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-27 18:24:23', 'completed', '', NULL),
 (1825, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-27 18:24:24', 'completed', '', NULL),
 (1826, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-27 18:24:25', 'completed', '', NULL),
 (1827, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-27 18:24:28', 'completed', '', NULL),
 (1828, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-27 18:24:29', 'completed', '', NULL),
 (1829, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-27 18:24:31', 'completed', '', NULL),
 (1830, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-27 18:24:32', 'completed', '', NULL),
 (1831, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-27 18:24:34', 'completed', '', NULL),
 (1832, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-27 18:24:36', 'completed', '', NULL),
 (1833, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-27 18:24:38', 'completed', '', NULL),
 (1834, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-27 18:24:40', 'completed', '', NULL),
 (1835, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-27 18:24:42', 'completed', '', NULL),
 (1836, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-02-27 23:05:22', 'completed', '', NULL),
 (1837, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-02-27 23:05:43', 'completed', '', NULL),
 (1838, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-02-27 23:06:58', 'completed', '', NULL),
 (1839, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1837, 1839, '', '2017-02-27 23:07:18', 'completed', '', NULL),
 (1840, 0, '62.84.152.162', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-27 23:50:19', 'completed', '', NULL),
 (1841, 0, '62.84.152.162', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-27 23:50:20', 'completed', '', NULL),
 (1842, 0, '62.84.152.162', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-27 23:50:21', 'completed', '', NULL),
 (1843, 0, '62.84.152.162', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-27 23:50:24', 'completed', '', NULL),
 (1844, 0, '62.84.152.162', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-27 23:50:26', 'completed', '', NULL),
 (1845, 0, '62.84.152.162', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-27 23:50:27', 'completed', '', NULL),
 (1846, 0, '62.84.152.162', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-27 23:50:28', 'completed', '', NULL),
 (1847, 0, '62.84.152.162', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-27 23:50:29', 'completed', '', NULL),
 (1848, 0, '62.84.152.162', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-27 23:50:30', 'completed', '', NULL),
 (1849, 0, '62.84.152.162', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-27 23:50:32', 'completed', '', NULL),
 (1850, 0, '62.84.152.162', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-27 23:50:33', 'completed', '', NULL),
 (1851, 0, '62.84.152.162', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-27 23:50:36', 'completed', '', NULL),
 (1852, 0, '62.84.152.162', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-28 04:29:59', 'completed', '', NULL),
 (1853, 0, '62.84.152.162', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-28 04:30:00', 'completed', '', NULL),
 (1854, 0, '62.84.152.162', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-28 04:30:01', 'completed', '', NULL),
 (1855, 0, '62.84.152.162', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-28 04:30:03', 'completed', '', NULL),
 (1856, 0, '62.84.152.162', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-28 04:30:04', 'completed', '', NULL),
 (1857, 0, '62.84.152.162', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-28 04:30:07', 'completed', '', NULL),
 (1858, 0, '62.84.152.162', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-28 04:30:08', 'completed', '', NULL),
 (1859, 0, '62.84.152.162', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-28 04:30:09', 'completed', '', NULL),
 (1860, 0, '62.84.152.162', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-28 04:30:11', 'completed', '', NULL),
 (1861, 0, '62.84.152.162', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-28 04:30:13', 'completed', '', NULL),
 (1862, 0, '62.84.152.162', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-28 04:30:15', 'completed', '', NULL),
 (1863, 0, '62.84.152.162', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-28 04:30:17', 'completed', '', NULL),
 (1864, 0, '85.148.42.242', 'Java/1.8.0_73', 2128, 2367, '', '2017-02-28 06:30:17', 'completed', '', NULL),
 (1865, 0, '85.148.42.242', 'Java/1.8.0_73', 2146, 2149, '', '2017-02-28 06:30:18', 'completed', '', NULL),
 (1866, 0, '85.148.42.242', 'Java/1.8.0_73', 2333, 2334, '', '2017-02-28 06:30:19', 'completed', '', NULL),
 (1867, 0, '85.148.42.242', 'Java/1.8.0_73', 2140, 2141, '', '2017-02-28 06:30:22', 'completed', '', NULL),
 (1868, 0, '85.148.42.242', 'Java/1.8.0_73', 2336, 2337, '', '2017-02-28 06:30:23', 'completed', '', NULL),
 (1869, 0, '85.148.42.242', 'Java/1.8.0_73', 1837, 1839, '', '2017-02-28 06:30:25', 'completed', '', NULL),
 (1870, 0, '85.148.42.242', 'Java/1.8.0_73', 1844, 1845, '', '2017-02-28 06:30:26', 'completed', '', NULL),
 (1871, 0, '85.148.42.242', 'Java/1.8.0_73', 2339, 2340, '', '2017-02-28 06:30:27', 'completed', '', NULL),
 (1872, 0, '85.148.42.242', 'Java/1.8.0_73', 2130, 2133, '', '2017-02-28 06:30:28', 'completed', '', NULL),
 (1873, 0, '85.148.42.242', 'Java/1.8.0_73', 2134, 2307, '', '2017-02-28 06:30:30', 'completed', '', NULL),
 (1874, 0, '85.148.42.242', 'Java/1.8.0_73', 2161, 2162, '', '2017-02-28 06:30:32', 'completed', '', NULL),
 (1875, 0, '85.148.42.242', 'Java/1.8.0_73', 2342, 2349, '', '2017-02-28 06:30:34', 'completed', '', NULL),
 (1876, 0, '194.230.159.153', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-02-28 10:40:17', 'completed', '', NULL),
 (1877, 0, '72.214.133.30', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-28 13:21:06', 'completed', '', NULL),
 (1878, 0, '72.214.133.30', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-28 13:21:08', 'completed', '', NULL),
 (1879, 0, '72.214.133.30', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-28 13:21:09', 'completed', '', NULL),
 (1880, 0, '72.214.133.30', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-28 13:21:13', 'completed', '', NULL),
 (1881, 0, '72.214.133.30', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-28 13:21:15', 'completed', '', NULL),
 (1882, 0, '72.214.133.30', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-28 13:21:17', 'completed', '', NULL),
 (1883, 0, '72.214.133.30', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-28 13:21:19', 'completed', '', NULL),
 (1884, 0, '72.214.133.30', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-28 13:21:20', 'completed', '', NULL),
 (1885, 0, '72.214.133.30', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-28 13:21:23', 'completed', '', NULL),
 (1886, 0, '72.214.133.30', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-28 13:21:25', 'completed', '', NULL),
 (1887, 0, '72.214.133.30', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-28 13:21:29', 'completed', '', NULL),
 (1888, 0, '72.214.133.30', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-28 13:21:32', 'completed', '', NULL),
 (1889, 0, '178.39.153.102', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-02-28 13:36:19', 'completed', '', NULL),
 (1890, 0, '77.58.164.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-02-28 13:53:35', 'completed', '', NULL),
 (1891, 0, '62.202.184.172', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_2) AppleWebKit/601.3.9 (KHTML, like Gecko) Version/9.0.2 Safari/601.3.9', 2140, 2141, '', '2017-02-28 16:27:56', 'completed', '', NULL),
 (1892, 0, '207.46.13.94', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-02-28 16:35:53', 'completed', '', NULL),
 (1893, 0, '178.60.16.188', 'Java/1.6.0_04', 2128, 2367, '', '2017-02-28 17:27:32', 'completed', '', NULL),
 (1894, 0, '178.60.16.188', 'Java/1.6.0_04', 2146, 2149, '', '2017-02-28 17:27:34', 'completed', '', NULL),
 (1895, 0, '178.60.16.188', 'Java/1.6.0_04', 2333, 2334, '', '2017-02-28 17:27:34', 'completed', '', NULL),
 (1896, 0, '178.60.16.188', 'Java/1.6.0_04', 2140, 2141, '', '2017-02-28 17:27:38', 'completed', '', NULL),
 (1897, 0, '178.60.16.188', 'Java/1.6.0_04', 2336, 2337, '', '2017-02-28 17:27:39', 'completed', '', NULL),
 (1898, 0, '178.60.16.188', 'Java/1.6.0_04', 1837, 1839, '', '2017-02-28 17:27:42', 'completed', '', NULL),
 (1899, 0, '178.60.16.188', 'Java/1.6.0_04', 1844, 1845, '', '2017-02-28 17:27:43', 'completed', '', NULL),
 (1900, 0, '178.60.16.188', 'Java/1.6.0_04', 2339, 2340, '', '2017-02-28 17:27:44', 'completed', '', NULL),
 (1901, 0, '178.60.16.188', 'Java/1.6.0_04', 2130, 2133, '', '2017-02-28 17:27:46', 'completed', '', NULL),
 (1902, 0, '178.60.16.188', 'Java/1.6.0_04', 2134, 2307, '', '2017-02-28 17:27:49', 'completed', '', NULL),
 (1903, 0, '178.60.16.188', 'Java/1.6.0_04', 2161, 2162, '', '2017-02-28 17:27:51', 'completed', '', NULL),
 (1904, 0, '178.60.16.188', 'Java/1.6.0_04', 2342, 2349, '', '2017-02-28 17:27:53', 'completed', '', NULL),
 (1905, 0, '37.49.224.209', 'Java/1.4.1_04', 2128, 2367, '', '2017-02-28 20:00:40', 'completed', '', NULL),
 (1906, 0, '37.49.224.209', 'Java/1.4.1_04', 2146, 2149, '', '2017-02-28 20:00:41', 'completed', '', NULL),
 (1907, 0, '37.49.224.209', 'Java/1.4.1_04', 2333, 2334, '', '2017-02-28 20:00:42', 'completed', '', NULL),
 (1908, 0, '37.49.224.209', 'Java/1.4.1_04', 2140, 2141, '', '2017-02-28 20:00:43', 'completed', '', NULL),
 (1909, 0, '37.49.224.209', 'Java/1.4.1_04', 2336, 2337, '', '2017-02-28 20:00:44', 'completed', '', NULL),
 (1910, 0, '37.49.224.209', 'Java/1.4.1_04', 1837, 1839, '', '2017-02-28 20:00:46', 'completed', '', NULL),
 (1911, 0, '37.49.224.209', 'Java/1.4.1_04', 1844, 1845, '', '2017-02-28 20:00:47', 'completed', '', NULL),
 (1912, 0, '37.49.224.209', 'Java/1.4.1_04', 2339, 2340, '', '2017-02-28 20:00:47', 'completed', '', NULL),
 (1913, 0, '37.49.224.209', 'Java/1.4.1_04', 2130, 2133, '', '2017-02-28 20:00:49', 'completed', '', NULL),
 (1914, 0, '37.49.224.209', 'Java/1.4.1_04', 2134, 2307, '', '2017-02-28 20:00:50', 'completed', '', NULL),
 (1915, 0, '37.49.224.209', 'Java/1.4.1_04', 2161, 2162, '', '2017-02-28 20:00:51', 'completed', '', NULL),
 (1916, 0, '37.49.224.209', 'Java/1.4.1_04', 2342, 2349, '', '2017-02-28 20:00:52', 'completed', '', NULL),
 (1917, 0, '89.217.197.21', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-01 06:49:22', 'completed', '', NULL),
 (1918, 0, '84.73.156.195', 'Mozilla/5.0 (Linux; Android 5.1.1; SGP311 Build/10.7.A.0.228) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2336, 2337, '', '2017-03-01 10:28:41', 'completed', '', NULL),
 (1919, 0, '84.73.156.195', 'Mozilla/5.0 (Linux; Android 5.1.1; SGP311 Build/10.7.A.0.228) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2140, 2141, '', '2017-03-01 10:41:28', 'completed', '', NULL),
 (1920, 0, '83.49.161.132', 'Java/1.8.0_65', 2128, 2367, '', '2017-03-02 00:55:50', 'completed', '', NULL),
 (1921, 0, '83.49.161.132', 'Java/1.8.0_65', 2146, 2149, '', '2017-03-02 00:55:52', 'completed', '', NULL),
 (1922, 0, '83.49.161.132', 'Java/1.8.0_65', 2333, 2334, '', '2017-03-02 00:55:53', 'completed', '', NULL),
 (1923, 0, '83.49.161.132', 'Java/1.8.0_65', 2140, 2141, '', '2017-03-02 00:55:57', 'completed', '', NULL),
 (1924, 0, '83.49.161.132', 'Java/1.8.0_65', 2336, 2337, '', '2017-03-02 00:56:00', 'completed', '', NULL),
 (1925, 0, '83.49.161.132', 'Java/1.8.0_65', 1837, 1839, '', '2017-03-02 00:56:03', 'completed', '', NULL),
 (1926, 0, '83.49.161.132', 'Java/1.8.0_65', 1844, 1845, '', '2017-03-02 00:56:04', 'completed', '', NULL),
 (1927, 0, '83.49.161.132', 'Java/1.8.0_65', 2339, 2340, '', '2017-03-02 00:56:06', 'completed', '', NULL),
 (1928, 0, '83.49.161.132', 'Java/1.8.0_65', 2130, 2133, '', '2017-03-02 00:56:10', 'completed', '', NULL),
 (1929, 0, '83.49.161.132', 'Java/1.8.0_65', 2134, 2307, '', '2017-03-02 00:56:13', 'completed', '', NULL),
 (1930, 0, '83.49.161.132', 'Java/1.8.0_65', 2161, 2162, '', '2017-03-02 00:56:15', 'completed', '', NULL),
 (1931, 0, '83.49.161.132', 'Java/1.8.0_65', 2342, 2349, '', '2017-03-02 00:56:18', 'completed', '', NULL),
 (1932, 0, '54.89.90.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-02 02:48:22', 'completed', '', NULL),
 (1933, 0, '54.89.90.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-02 02:48:27', 'completed', '', NULL),
 (1934, 0, '54.89.90.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-02 02:48:29', 'completed', '', NULL),
 (1935, 0, '54.89.90.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-02 02:48:44', 'completed', '', NULL),
 (1936, 0, '54.89.90.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-02 02:48:52', 'completed', '', NULL),
 (1937, 0, '54.89.90.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-02 02:49:04', 'completed', '', NULL),
 (1938, 0, '54.89.90.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-02 02:49:10', 'completed', '', NULL),
 (1939, 0, '54.89.90.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-02 02:49:14', 'completed', '', NULL),
 (1940, 0, '54.89.90.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-02 02:49:27', 'completed', '', NULL),
 (1941, 0, '54.89.90.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-02 02:49:42', 'completed', '', NULL),
 (1942, 0, '54.89.90.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-02 02:49:52', 'completed', '', NULL),
 (1943, 0, '54.89.90.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-02 02:50:14', 'completed', '', NULL),
 (1944, 0, '83.49.161.132', 'Java/1.8.0_65', 2128, 2367, '', '2017-03-02 04:37:10', 'completed', '', NULL),
 (1945, 0, '83.49.161.132', 'Java/1.8.0_65', 2146, 2149, '', '2017-03-02 04:37:11', 'completed', '', NULL),
 (1946, 0, '83.49.161.132', 'Java/1.8.0_65', 2333, 2334, '', '2017-03-02 04:37:13', 'completed', '', NULL),
 (1947, 0, '83.49.161.132', 'Java/1.8.0_65', 2140, 2141, '', '2017-03-02 04:37:17', 'completed', '', NULL),
 (1948, 0, '83.49.161.132', 'Java/1.8.0_65', 2336, 2337, '', '2017-03-02 04:37:18', 'completed', '', NULL),
 (1949, 0, '83.49.161.132', 'Java/1.8.0_65', 1837, 1839, '', '2017-03-02 04:37:21', 'completed', '', NULL),
 (1950, 0, '83.49.161.132', 'Java/1.8.0_65', 1844, 1845, '', '2017-03-02 04:37:22', 'completed', '', NULL),
 (1951, 0, '83.49.161.132', 'Java/1.8.0_65', 2339, 2340, '', '2017-03-02 04:37:24', 'completed', '', NULL),
 (1952, 0, '83.49.161.132', 'Java/1.8.0_65', 2130, 2133, '', '2017-03-02 04:37:27', 'completed', '', NULL),
 (1953, 0, '83.49.161.132', 'Java/1.8.0_65', 2134, 2307, '', '2017-03-02 04:37:29', 'completed', '', NULL),
 (1954, 0, '83.49.161.132', 'Java/1.8.0_65', 2161, 2162, '', '2017-03-02 04:37:32', 'completed', '', NULL),
 (1955, 0, '83.49.161.132', 'Java/1.8.0_65', 2342, 2349, '', '2017-03-02 04:37:34', 'completed', '', NULL),
 (1956, 0, '83.77.178.245', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1', 2146, 2149, '', '2017-03-02 09:45:19', 'completed', '', NULL),
 (1957, 0, '195.65.152.65', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-03-02 13:16:36', 'completed', '', NULL),
 (1958, 0, '188.61.54.241', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-03-02 13:25:21', 'completed', '', NULL),
 (1959, 0, '83.77.178.245', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Mobile/14A403 Safari/602.1', 2146, 2149, '', '2017-03-02 13:52:57', 'completed', '', NULL),
 (1960, 0, '188.61.54.241', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-03-02 14:07:01', 'completed', '', NULL),
 (1961, 0, '188.61.54.241', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2336, 2337, '', '2017-03-02 14:10:18', 'completed', '', NULL),
 (1962, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-02 14:29:26', 'completed', '', NULL),
 (1963, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-02 14:31:22', 'completed', '', NULL),
 (1964, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-02 14:31:30', 'completed', '', NULL),
 (1965, 0, '77.58.164.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-03-02 18:00:26', 'completed', '', NULL),
 (1966, 0, '212.225.226.47', 'Java/1.7.0_25', 2128, 2367, '', '2017-03-02 19:11:32', 'completed', '', NULL),
 (1967, 0, '212.225.226.47', 'Java/1.7.0_25', 2146, 2149, '', '2017-03-02 19:11:33', 'completed', '', NULL),
 (1968, 0, '212.225.226.47', 'Java/1.7.0_25', 2333, 2334, '', '2017-03-02 19:11:34', 'completed', '', NULL),
 (1969, 0, '212.225.226.47', 'Java/1.7.0_25', 2140, 2141, '', '2017-03-02 19:11:44', 'completed', '', NULL),
 (1970, 0, '212.225.226.47', 'Java/1.7.0_25', 2336, 2337, '', '2017-03-02 19:11:45', 'completed', '', NULL),
 (1971, 0, '212.225.226.47', 'Java/1.7.0_25', 1837, 1839, '', '2017-03-02 19:11:52', 'completed', '', NULL),
 (1972, 0, '212.225.226.47', 'Java/1.7.0_25', 1844, 1845, '', '2017-03-02 19:11:53', 'completed', '', NULL),
 (1973, 0, '212.225.226.47', 'Java/1.7.0_25', 2339, 2340, '', '2017-03-02 19:11:55', 'completed', '', NULL),
 (1974, 0, '212.225.226.47', 'Java/1.7.0_25', 2130, 2133, '', '2017-03-02 19:12:01', 'completed', '', NULL),
 (1975, 0, '212.225.226.47', 'Java/1.7.0_25', 2134, 2307, '', '2017-03-02 19:12:08', 'completed', '', NULL),
 (1976, 0, '212.225.226.47', 'Java/1.7.0_25', 2161, 2162, '', '2017-03-02 19:12:20', 'completed', '', NULL),
 (1977, 0, '212.225.226.47', 'Java/1.7.0_25', 2342, 2349, '', '2017-03-02 19:12:32', 'completed', '', NULL),
 (1978, 0, '83.76.170.50', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-02 19:30:57', 'completed', '', NULL),
 (1979, 0, '83.76.170.50', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-03-02 19:31:02', 'completed', '', NULL),
 (1980, 0, '83.76.170.50', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-02 19:52:51', 'completed', '', NULL),
 (1981, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1844, 1845, '', '2017-03-03 08:07:32', 'completed', '', NULL),
 (1982, 0, '103.41.177.71', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-03 16:31:03', 'completed', '', NULL),
 (1983, 0, '103.41.177.71', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-03 16:31:13', 'completed', '', NULL),
 (1984, 0, '103.41.177.71', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-03 16:31:14', 'completed', '', NULL),
 (1985, 0, '103.41.177.71', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-03 16:31:36', 'completed', '', NULL),
 (1986, 0, '103.41.177.71', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-03 16:31:44', 'completed', '', NULL),
 (1987, 0, '103.41.177.71', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-03 16:32:07', 'completed', '', NULL),
 (1988, 0, '103.41.177.71', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-03 16:32:14', 'completed', '', NULL),
 (1989, 0, '103.41.177.71', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-03 16:32:17', 'completed', '', NULL),
 (1990, 0, '103.41.177.71', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-03 16:32:35', 'completed', '', NULL),
 (1991, 0, '103.41.177.71', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-03 16:32:37', 'completed', '', NULL),
 (1992, 0, '103.41.177.71', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-03 16:32:58', 'completed', '', NULL),
 (1993, 0, '103.41.177.71', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-03 16:33:14', 'completed', '', NULL),
 (1994, 0, '178.197.232.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/23.0.147401934 Mobile/14D27 Safari/600.1.4', 2134, 2307, '', '2017-03-03 21:11:52', 'completed', '', NULL),
 (1995, 0, '178.197.232.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/23.0.147401934 Mobile/14D27 Safari/600.1.4', 2130, 2133, '', '2017-03-03 21:12:41', 'completed', '', NULL),
 (1996, 0, '163.172.66.135', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-03-04 04:29:05', 'completed', '', NULL),
 (1997, 0, '77.58.164.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-03-04 12:58:10', 'completed', '', NULL),
 (1998, 0, '31.10.169.146', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-03-04 16:46:21', 'completed', '', NULL),
 (1999, 0, '31.10.169.146', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-03-04 16:49:58', 'completed', '', NULL),
 (2000, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2342, 2349, '', '2017-03-04 17:33:50', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(2001, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-03-04 19:00:36', 'completed', '', NULL),
 (2002, 0, '163.172.73.28', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-03-04 21:00:57', 'completed', '', NULL),
 (2003, 0, '51.255.65.61', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-03-04 22:29:34', 'completed', '', NULL),
 (2004, 0, '164.132.161.77', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-03-04 22:59:50', 'completed', '', NULL),
 (2005, 0, '157.55.39.5', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-03-04 23:22:07', 'completed', '', NULL),
 (2006, 0, '77.58.164.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-03-04 23:39:30', 'completed', '', NULL),
 (2007, 0, '85.7.23.146', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; MASBJS; rv:11.0) like Gecko', 2339, 2340, '', '2017-03-05 00:32:35', 'completed', '', NULL),
 (2008, 0, '85.7.23.146', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; MASBJS; rv:11.0) like Gecko', 2140, 2141, '', '2017-03-05 00:36:22', 'completed', '', NULL),
 (2009, 0, '85.7.23.146', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; MASBJS; rv:11.0) like Gecko', 2336, 2337, '', '2017-03-05 00:37:02', 'completed', '', NULL),
 (2010, 0, '81.62.94.10', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MALNJS; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-05 05:52:13', 'completed', '', NULL),
 (2011, 0, '81.62.94.10', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MALNJS; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-05 06:00:43', 'completed', '', NULL),
 (2012, 0, '81.62.94.10', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MALNJS; rv:11.0) like Gecko', 2146, 2149, '', '2017-03-05 06:01:59', 'completed', '', NULL),
 (2013, 0, '81.62.94.10', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MALNJS; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-05 06:04:16', 'completed', '', NULL),
 (2014, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-03-05 11:17:12', 'completed', '', NULL),
 (2015, 0, '188.155.56.150', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-05 11:17:31', 'completed', '', NULL),
 (2016, 0, '77.58.164.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2140, 2141, '', '2017-03-05 11:44:01', 'completed', '', NULL),
 (2017, 0, '213.221.205.230', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-03-05 13:53:27', 'completed', '', NULL),
 (2018, 0, '5.144.14.167', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-05 15:11:44', 'completed', '', NULL),
 (2019, 0, '5.144.14.167', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-03-05 15:15:27', 'completed', '', NULL),
 (2020, 0, '5.144.14.167', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-03-05 15:16:42', 'completed', '', NULL),
 (2021, 0, '5.144.14.167', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-05 15:18:05', 'completed', '', NULL),
 (2022, 0, '5.144.14.167', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-03-05 15:25:27', 'completed', '', NULL),
 (2023, 0, '92.104.78.130', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-03-05 19:41:31', 'completed', '', NULL),
 (2024, 0, '178.199.191.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-05 19:51:20', 'completed', '', NULL),
 (2025, 0, '178.199.191.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-03-05 19:55:35', 'completed', '', NULL),
 (2026, 0, '178.199.191.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-05 19:56:35', 'completed', '', NULL),
 (2027, 0, '178.199.191.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-03-05 19:56:45', 'completed', '', NULL),
 (2028, 0, '178.193.141.194', 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; Touch; rv:11.0) like Gecko', 2140, 2141, '', '2017-03-05 21:21:18', 'completed', '', NULL),
 (2029, 0, '178.193.141.194', 'Mozilla/5.0 (Windows NT 6.3; Trident/7.0; Touch; rv:11.0) like Gecko', 2146, 2149, '', '2017-03-05 21:22:54', 'completed', '', NULL),
 (2030, 0, '51.255.65.36', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2130, 2133, '', '2017-03-05 21:53:32', 'completed', '', NULL),
 (2031, 0, '157.55.39.129', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-03-06 05:27:28', 'completed', '', NULL),
 (2032, 0, '163.172.66.13', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-03-06 06:14:33', 'completed', '', NULL),
 (2033, 0, '178.197.230.210', 'Mozilla/5.0 (Linux; Android 4.4.2; de-ch; SAMSUNG SM-G900F Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/1.6 Chrome/28.0.1500.94 Mobile Safari/537.36', 1844, 1845, '', '2017-03-06 09:32:52', 'completed', '', NULL),
 (2034, 0, '178.197.230.210', 'Mozilla/5.0 (Linux; Android 4.4.2; de-ch; SAMSUNG SM-G900F Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/1.6 Chrome/28.0.1500.94 Mobile Safari/537.36', 2140, 2141, '', '2017-03-06 09:38:27', 'completed', '', NULL),
 (2035, 0, '178.199.191.14', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-06 10:22:42', 'completed', '', NULL),
 (2036, 0, '178.199.191.14', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-03-06 14:27:28', 'completed', '', NULL),
 (2037, 0, '178.199.191.14', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-03-06 14:28:18', 'completed', '', NULL),
 (2038, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-03-06 14:34:43', 'completed', '', NULL),
 (2039, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-03-06 14:35:06', 'completed', '', NULL),
 (2040, 0, '62.167.115.31', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2339, 2340, '', '2017-03-06 15:08:33', 'completed', '', NULL),
 (2041, 0, '81.62.48.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-03-06 15:17:53', 'completed', '', NULL),
 (2042, 0, '81.62.48.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-03-06 15:18:53', 'completed', '', NULL),
 (2043, 0, '81.62.48.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2333, 2334, '', '2017-03-06 15:20:10', 'completed', '', NULL),
 (2044, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-03-06 16:35:28', 'completed', '', NULL),
 (2045, 0, '62.203.188.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-03-06 16:35:45', 'completed', '', NULL),
 (2046, 0, '62.203.188.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-03-06 16:39:30', 'completed', '', NULL),
 (2047, 0, '62.203.188.39', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-03-06 16:55:21', 'completed', '', NULL),
 (2048, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2130, 2133, '', '2017-03-06 18:49:27', 'completed', '', NULL),
 (2049, 0, '31.10.159.35', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2146, 2149, '', '2017-03-06 21:39:12', 'completed', '', NULL),
 (2050, 0, '5.145.86.239', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-03-07 10:05:25', 'completed', '', NULL),
 (2051, 0, '5.145.86.239', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2134, 2307, '', '2017-03-07 10:07:24', 'completed', '', NULL),
 (2052, 0, '5.145.86.239', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2342, 2349, '', '2017-03-07 10:18:15', 'completed', '', NULL),
 (2053, 0, '5.145.86.239', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-03-07 10:20:30', 'completed', '', NULL),
 (2054, 0, '83.79.129.179', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2342, 2349, '', '2017-03-07 11:50:03', 'completed', '', NULL),
 (2055, 0, '213.193.100.98', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-03-07 12:56:30', 'completed', '', NULL),
 (2056, 0, '213.193.100.98', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2146, 2149, '', '2017-03-07 12:57:01', 'completed', '', NULL),
 (2057, 0, '213.193.100.98', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-03-07 12:57:19', 'completed', '', NULL),
 (2058, 0, '213.193.100.98', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-03-07 12:58:09', 'completed', '', NULL),
 (2059, 0, '178.199.191.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-03-07 13:31:04', 'completed', '', NULL),
 (2060, 0, '84.241.68.201', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-03-07 17:51:12', 'completed', '', NULL),
 (2061, 0, '84.241.68.201', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2146, 2149, '', '2017-03-07 17:51:49', 'completed', '', NULL),
 (2062, 0, '84.241.68.201', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-03-07 17:52:12', 'completed', '', NULL),
 (2063, 0, '162.250.8.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-08 03:09:33', 'completed', '', NULL),
 (2064, 0, '162.250.8.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-08 03:09:35', 'completed', '', NULL),
 (2065, 0, '162.250.8.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-08 03:09:36', 'completed', '', NULL),
 (2066, 0, '162.250.8.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-08 03:09:40', 'completed', '', NULL),
 (2067, 0, '162.250.8.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-08 03:09:42', 'completed', '', NULL),
 (2068, 0, '162.250.8.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-08 03:09:54', 'completed', '', NULL),
 (2069, 0, '162.250.8.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-08 03:09:55', 'completed', '', NULL),
 (2070, 0, '162.250.8.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-08 03:09:57', 'completed', '', NULL),
 (2071, 0, '162.250.8.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-08 03:09:59', 'completed', '', NULL),
 (2072, 0, '162.250.8.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-08 03:10:02', 'completed', '', NULL),
 (2073, 0, '162.250.8.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-08 03:10:05', 'completed', '', NULL),
 (2074, 0, '162.250.8.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-08 03:10:08', 'completed', '', NULL),
 (2075, 0, '40.77.167.125', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-03-08 04:09:12', 'completed', '', NULL),
 (2076, 0, '92.107.212.196', 'Mozilla/5.0 (Windows NT 6.1; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-03-08 05:12:09', 'completed', '', NULL),
 (2077, 0, '188.63.59.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2161, 2162, '', '2017-03-08 09:21:32', 'completed', '', NULL),
 (2078, 0, '188.63.59.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2134, 2307, '', '2017-03-08 09:24:40', 'completed', '', NULL),
 (2079, 0, '188.63.59.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2130, 2133, '', '2017-03-08 09:25:54', 'completed', '', NULL),
 (2080, 0, '188.63.59.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2146, 2149, '', '2017-03-08 09:27:11', 'completed', '', NULL),
 (2081, 0, '188.63.59.117', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2128, 2367, '', '2017-03-08 09:30:30', 'completed', '', NULL),
 (2082, 0, '96.56.24.130', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-08 10:48:11', 'completed', '', NULL),
 (2083, 0, '96.56.24.130', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-08 10:48:12', 'completed', '', NULL),
 (2084, 0, '96.56.24.130', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-08 10:48:13', 'completed', '', NULL),
 (2085, 0, '96.56.24.130', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-08 10:48:16', 'completed', '', NULL),
 (2086, 0, '96.56.24.130', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-08 10:48:18', 'completed', '', NULL),
 (2087, 0, '96.56.24.130', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-08 10:48:20', 'completed', '', NULL),
 (2088, 0, '96.56.24.130', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-08 10:48:21', 'completed', '', NULL),
 (2089, 0, '96.56.24.130', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-08 10:48:23', 'completed', '', NULL),
 (2090, 0, '96.56.24.130', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-08 10:48:25', 'completed', '', NULL),
 (2091, 0, '96.56.24.130', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-08 10:48:27', 'completed', '', NULL),
 (2092, 0, '96.56.24.130', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-08 10:48:30', 'completed', '', NULL),
 (2093, 0, '96.56.24.130', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-08 10:48:33', 'completed', '', NULL),
 (2094, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-03-08 11:35:43', 'completed', '', NULL),
 (2095, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 1837, 1839, '', '2017-03-08 11:36:52', 'completed', '', NULL),
 (2096, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-03-08 11:37:43', 'completed', '', NULL),
 (2097, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-03-08 11:39:46', 'completed', '', NULL),
 (2098, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-03-08 11:42:24', 'completed', '', NULL),
 (2099, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-03-08 11:47:17', 'completed', '', NULL),
 (2100, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2333, 2334, '', '2017-03-08 14:34:41', 'completed', '', NULL),
 (2101, 0, '207.46.13.61', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-03-08 17:13:15', 'completed', '', NULL),
 (2102, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2307, '', '2017-03-08 17:24:58', 'completed', '', NULL),
 (2103, 0, '31.25.126.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/23.0.147401934 Mobile/14D27 Safari/600.1.4', 2128, 2367, '', '2017-03-08 17:38:30', 'completed', '', NULL),
 (2104, 0, '31.25.126.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/23.0.147401934 Mobile/14D27 Safari/600.1.4', 2333, 2334, '', '2017-03-08 17:39:13', 'completed', '', NULL),
 (2105, 0, '31.25.126.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/23.0.147401934 Mobile/14D27 Safari/600.1.4', 2146, 2149, '', '2017-03-08 17:40:16', 'completed', '', NULL),
 (2106, 0, '77.245.183.217', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2146, 2149, '', '2017-03-08 18:42:06', 'completed', '', NULL),
 (2107, 0, '77.245.183.217', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-03-08 18:43:11', 'completed', '', NULL),
 (2108, 0, '77.245.183.217', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2342, 2349, '', '2017-03-08 18:43:16', 'completed', '', NULL),
 (2109, 0, '178.195.175.246', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-03-08 21:22:17', 'completed', '', NULL),
 (2110, 0, '81.221.71.55', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2342, 2349, '', '2017-03-09 09:30:50', 'completed', '', NULL),
 (2111, 0, '193.246.80.29', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-09 11:11:58', 'completed', '', NULL),
 (2112, 0, '193.246.80.29', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-09 11:13:42', 'completed', '', NULL),
 (2113, 0, '193.246.80.29', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-09 11:14:28', 'completed', '', NULL),
 (2114, 0, '178.197.232.20', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A510F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2134, 2307, '', '2017-03-09 13:43:30', 'completed', '', NULL),
 (2115, 0, '178.197.236.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-03-09 15:52:16', 'completed', '', NULL),
 (2116, 0, '178.197.236.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-09 15:52:45', 'completed', '', NULL),
 (2117, 0, '198.240.212.2', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-03-09 16:37:31', 'completed', '', NULL),
 (2118, 0, '85.5.180.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-03-09 18:30:00', 'completed', '', NULL),
 (2119, 0, '85.5.180.30', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2339, 2340, '', '2017-03-09 18:31:24', 'completed', '', NULL),
 (2120, 0, '188.155.56.150', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-03-09 20:18:25', 'completed', '', NULL),
 (2121, 0, '212.225.226.47', 'Java/1.8.0_121', 2128, 2367, '', '2017-03-09 21:40:02', 'completed', '', NULL),
 (2122, 0, '212.225.226.47', 'Java/1.8.0_121', 2146, 2149, '', '2017-03-09 21:40:03', 'completed', '', NULL),
 (2123, 0, '212.225.226.47', 'Java/1.8.0_121', 2333, 2334, '', '2017-03-09 21:40:04', 'completed', '', NULL),
 (2124, 0, '212.225.226.47', 'Java/1.8.0_121', 2140, 2141, '', '2017-03-09 21:40:09', 'completed', '', NULL),
 (2125, 0, '212.225.226.47', 'Java/1.8.0_121', 2336, 2337, '', '2017-03-09 21:40:11', 'completed', '', NULL),
 (2126, 0, '212.225.226.47', 'Java/1.8.0_121', 1837, 1839, '', '2017-03-09 21:40:13', 'completed', '', NULL),
 (2127, 0, '212.225.226.47', 'Java/1.8.0_121', 1844, 1845, '', '2017-03-09 21:40:14', 'completed', '', NULL),
 (2128, 0, '212.225.226.47', 'Java/1.8.0_121', 2339, 2340, '', '2017-03-09 21:40:16', 'completed', '', NULL),
 (2129, 0, '212.225.226.47', 'Java/1.8.0_121', 2130, 2133, '', '2017-03-09 21:40:18', 'completed', '', NULL),
 (2130, 0, '212.225.226.47', 'Java/1.8.0_121', 2134, 2307, '', '2017-03-09 21:40:21', 'completed', '', NULL),
 (2131, 0, '212.225.226.47', 'Java/1.8.0_121', 2161, 2162, '', '2017-03-09 21:40:23', 'completed', '', NULL),
 (2132, 0, '212.225.226.47', 'Java/1.8.0_121', 2342, 2349, '', '2017-03-09 21:40:26', 'completed', '', NULL),
 (2133, 0, '178.197.225.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H321 Safari/600.1.4', 2146, 2149, '', '2017-03-09 22:07:59', 'completed', '', NULL),
 (2134, 0, '178.197.225.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H321 Safari/600.1.4', 2128, 2367, '', '2017-03-09 22:08:48', 'completed', '', NULL),
 (2135, 0, '213.55.211.22', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-03-10 08:28:32', 'completed', '', NULL),
 (2136, 0, '70.119.209.29', 'Java/1.8.0_121', 2128, 2367, '', '2017-03-10 09:37:15', 'completed', '', NULL),
 (2137, 0, '70.119.209.29', 'Java/1.8.0_121', 2146, 2149, '', '2017-03-10 09:37:16', 'completed', '', NULL),
 (2138, 0, '70.119.209.29', 'Java/1.8.0_121', 2333, 2334, '', '2017-03-10 09:37:17', 'completed', '', NULL),
 (2139, 0, '70.119.209.29', 'Java/1.8.0_121', 2140, 2141, '', '2017-03-10 09:37:20', 'completed', '', NULL),
 (2140, 0, '70.119.209.29', 'Java/1.8.0_121', 2336, 2337, '', '2017-03-10 09:37:22', 'completed', '', NULL),
 (2141, 0, '70.119.209.29', 'Java/1.8.0_121', 1837, 1839, '', '2017-03-10 09:37:24', 'completed', '', NULL),
 (2142, 0, '70.119.209.29', 'Java/1.8.0_121', 1844, 1845, '', '2017-03-10 09:37:25', 'completed', '', NULL),
 (2143, 0, '70.119.209.29', 'Java/1.8.0_121', 2339, 2340, '', '2017-03-10 09:37:26', 'completed', '', NULL),
 (2144, 0, '70.119.209.29', 'Java/1.8.0_121', 2130, 2133, '', '2017-03-10 09:37:28', 'completed', '', NULL),
 (2145, 0, '70.119.209.29', 'Java/1.8.0_121', 2134, 2307, '', '2017-03-10 09:37:30', 'completed', '', NULL),
 (2146, 0, '70.119.209.29', 'Java/1.8.0_121', 2161, 2162, '', '2017-03-10 09:37:33', 'completed', '', NULL),
 (2147, 0, '70.119.209.29', 'Java/1.8.0_121', 2342, 2349, '', '2017-03-10 09:37:35', 'completed', '', NULL),
 (2148, 0, '178.199.189.47', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:51.0) Gecko/20100101 Firefox/51.0', 2140, 2141, '', '2017-03-10 10:48:28', 'completed', '', NULL),
 (2149, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-03-10 14:47:44', 'completed', '', NULL),
 (2150, 0, '198.240.213.21', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-03-10 14:47:45', 'completed', '', NULL),
 (2151, 0, '208.100.13.19', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-10 15:03:44', 'completed', '', NULL),
 (2152, 0, '208.100.13.19', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-10 15:03:45', 'completed', '', NULL),
 (2153, 0, '208.100.13.19', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-10 15:03:46', 'completed', '', NULL),
 (2154, 0, '208.100.13.19', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-10 15:03:50', 'completed', '', NULL),
 (2155, 0, '208.100.13.19', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-10 15:03:52', 'completed', '', NULL),
 (2156, 0, '208.100.13.19', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-10 15:03:55', 'completed', '', NULL),
 (2157, 0, '208.100.13.19', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-10 15:03:56', 'completed', '', NULL),
 (2158, 0, '208.100.13.19', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-10 15:03:57', 'completed', '', NULL),
 (2159, 0, '208.100.13.19', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-10 15:04:00', 'completed', '', NULL),
 (2160, 0, '208.100.13.19', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-10 15:04:02', 'completed', '', NULL),
 (2161, 0, '208.100.13.19', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-10 15:04:05', 'completed', '', NULL),
 (2162, 0, '208.100.13.19', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-10 15:04:08', 'completed', '', NULL),
 (2163, 0, '213.55.211.22', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-03-10 16:55:16', 'completed', '', NULL),
 (2164, 0, '54.197.34.154', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-10 17:31:39', 'completed', '', NULL),
 (2165, 0, '54.197.34.154', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-10 17:31:44', 'completed', '', NULL),
 (2166, 0, '54.197.34.154', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-10 17:31:49', 'completed', '', NULL),
 (2167, 0, '54.197.34.154', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-10 17:32:04', 'completed', '', NULL),
 (2168, 0, '54.197.34.154', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-10 17:32:11', 'completed', '', NULL),
 (2169, 0, '54.197.34.154', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-10 17:32:21', 'completed', '', NULL),
 (2170, 0, '54.197.34.154', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-10 17:32:25', 'completed', '', NULL),
 (2171, 0, '54.197.34.154', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-10 17:32:27', 'completed', '', NULL),
 (2172, 0, '54.197.34.154', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-10 17:32:40', 'completed', '', NULL),
 (2173, 0, '54.197.34.154', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-10 17:32:51', 'completed', '', NULL),
 (2174, 0, '54.197.34.154', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-10 17:32:59', 'completed', '', NULL),
 (2175, 0, '54.197.34.154', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-10 17:33:12', 'completed', '', NULL),
 (2176, 0, '77.250.67.242', 'Java/1.8.0_77', 2128, 2367, '', '2017-03-11 18:00:52', 'completed', '', NULL),
 (2177, 0, '77.250.67.242', 'Java/1.8.0_77', 2146, 2149, '', '2017-03-11 18:00:53', 'completed', '', NULL),
 (2178, 0, '77.250.67.242', 'Java/1.8.0_77', 2333, 2334, '', '2017-03-11 18:00:54', 'completed', '', NULL),
 (2179, 0, '77.250.67.242', 'Java/1.8.0_77', 2140, 2141, '', '2017-03-11 18:00:57', 'completed', '', NULL),
 (2180, 0, '77.250.67.242', 'Java/1.8.0_77', 2336, 2337, '', '2017-03-11 18:00:59', 'completed', '', NULL),
 (2181, 0, '77.250.67.242', 'Java/1.8.0_77', 1837, 1839, '', '2017-03-11 18:01:00', 'completed', '', NULL),
 (2182, 0, '77.250.67.242', 'Java/1.8.0_77', 1844, 1845, '', '2017-03-11 18:01:01', 'completed', '', NULL),
 (2183, 0, '77.250.67.242', 'Java/1.8.0_77', 2339, 2340, '', '2017-03-11 18:01:02', 'completed', '', NULL),
 (2184, 0, '77.250.67.242', 'Java/1.8.0_77', 2130, 2133, '', '2017-03-11 18:01:04', 'completed', '', NULL),
 (2185, 0, '77.250.67.242', 'Java/1.8.0_77', 2134, 2307, '', '2017-03-11 18:01:07', 'completed', '', NULL),
 (2186, 0, '77.250.67.242', 'Java/1.8.0_77', 2161, 2162, '', '2017-03-11 18:01:08', 'completed', '', NULL),
 (2187, 0, '77.250.67.242', 'Java/1.8.0_77', 2342, 2349, '', '2017-03-11 18:01:10', 'completed', '', NULL),
 (2188, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-03-11 19:28:38', 'completed', '', NULL),
 (2189, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-03-11 19:28:44', 'completed', '', NULL),
 (2190, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-03-11 19:28:49', 'completed', '', NULL),
 (2191, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-03-11 19:29:03', 'completed', '', NULL),
 (2192, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-03-11 19:29:10', 'completed', '', NULL),
 (2193, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-03-11 19:29:14', 'completed', '', NULL),
 (2194, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-03-11 19:29:20', 'completed', '', NULL),
 (2195, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-03-11 19:29:54', 'completed', '', NULL),
 (2196, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-03-11 19:29:59', 'completed', '', NULL),
 (2197, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-03-11 19:30:39', 'completed', '', NULL),
 (2198, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-03-11 19:30:44', 'completed', '', NULL),
 (2199, 0, '104.236.207.39', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-03-11 19:30:49', 'completed', '', NULL),
 (2200, 0, '91.192.111.68', 'Java/1.8.0_121', 2128, 2367, '', '2017-03-12 01:12:33', 'completed', '', NULL),
 (2201, 0, '91.192.111.68', 'Java/1.8.0_121', 2146, 2149, '', '2017-03-12 01:12:34', 'completed', '', NULL),
 (2202, 0, '91.192.111.68', 'Java/1.8.0_121', 2333, 2334, '', '2017-03-12 01:12:35', 'completed', '', NULL),
 (2203, 0, '91.192.111.68', 'Java/1.8.0_121', 2140, 2141, '', '2017-03-12 01:12:38', 'completed', '', NULL),
 (2204, 0, '91.192.111.68', 'Java/1.8.0_121', 2336, 2337, '', '2017-03-12 01:12:39', 'completed', '', NULL),
 (2205, 0, '91.192.111.68', 'Java/1.8.0_121', 1837, 1839, '', '2017-03-12 01:12:41', 'completed', '', NULL),
 (2206, 0, '91.192.111.68', 'Java/1.8.0_121', 1844, 1845, '', '2017-03-12 01:12:42', 'completed', '', NULL),
 (2207, 0, '91.192.111.68', 'Java/1.8.0_121', 2339, 2340, '', '2017-03-12 01:12:43', 'completed', '', NULL),
 (2208, 0, '91.192.111.68', 'Java/1.8.0_121', 2130, 2133, '', '2017-03-12 01:12:45', 'completed', '', NULL),
 (2209, 0, '91.192.111.68', 'Java/1.8.0_121', 2134, 2307, '', '2017-03-12 01:12:46', 'completed', '', NULL),
 (2210, 0, '91.192.111.68', 'Java/1.8.0_121', 2161, 2162, '', '2017-03-12 01:12:48', 'completed', '', NULL),
 (2211, 0, '91.192.111.68', 'Java/1.8.0_121', 2342, 2349, '', '2017-03-12 01:12:50', 'completed', '', NULL),
 (2212, 0, '163.172.231.186', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-12 02:52:34', 'completed', '', NULL),
 (2213, 0, '163.172.231.186', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-12 02:52:35', 'completed', '', NULL),
 (2214, 0, '163.172.231.186', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-12 02:52:36', 'completed', '', NULL),
 (2215, 0, '163.172.231.186', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-12 02:52:38', 'completed', '', NULL),
 (2216, 0, '163.172.231.186', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-12 02:52:38', 'completed', '', NULL),
 (2217, 0, '163.172.231.186', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-12 02:52:39', 'completed', '', NULL),
 (2218, 0, '163.172.231.186', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-12 02:52:40', 'completed', '', NULL),
 (2219, 0, '163.172.231.186', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-12 02:52:41', 'completed', '', NULL),
 (2220, 0, '163.172.231.186', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-12 02:52:42', 'completed', '', NULL),
 (2221, 0, '163.172.231.186', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-12 02:52:43', 'completed', '', NULL),
 (2222, 0, '163.172.231.186', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-12 02:52:44', 'completed', '', NULL),
 (2223, 0, '163.172.231.186', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-12 02:52:45', 'completed', '', NULL),
 (2224, 0, '40.77.167.45', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-03-12 16:08:05', 'completed', '', NULL),
 (2225, 0, '40.77.167.37', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-03-12 17:53:12', 'completed', '', NULL),
 (2226, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2017-03-12 17:57:23', 'completed', '', NULL),
 (2227, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-12 20:28:36', 'completed', '', NULL),
 (2228, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-12 20:28:38', 'completed', '', NULL),
 (2229, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-12 20:28:38', 'completed', '', NULL),
 (2230, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-12 20:28:42', 'completed', '', NULL),
 (2231, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-12 20:28:43', 'completed', '', NULL),
 (2232, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-12 20:28:45', 'completed', '', NULL),
 (2233, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-12 20:28:46', 'completed', '', NULL),
 (2234, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-12 20:28:47', 'completed', '', NULL),
 (2235, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-12 20:28:49', 'completed', '', NULL),
 (2236, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-12 20:28:51', 'completed', '', NULL),
 (2237, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-12 20:28:53', 'completed', '', NULL),
 (2238, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-12 20:28:55', 'completed', '', NULL),
 (2239, 0, '68.180.228.98', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1837, 1839, '', '2017-03-12 21:15:31', 'completed', '', NULL),
 (2240, 0, '62.167.140.249', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:51.0) Gecko/20100101 Firefox/51.0', 2128, 2367, '', '2017-03-12 21:21:15', 'completed', '', NULL),
 (2241, 0, '163.172.65.59', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2161, 2162, '', '2017-03-13 01:16:33', 'completed', '', NULL),
 (2242, 0, '62.84.152.162', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-13 04:17:44', 'completed', '', NULL),
 (2243, 0, '62.84.152.162', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-13 04:17:44', 'completed', '', NULL),
 (2244, 0, '62.84.152.162', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-13 04:17:45', 'completed', '', NULL),
 (2245, 0, '62.84.152.162', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-13 04:17:47', 'completed', '', NULL),
 (2246, 0, '62.84.152.162', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-13 04:17:49', 'completed', '', NULL),
 (2247, 0, '62.84.152.162', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-13 04:17:50', 'completed', '', NULL),
 (2248, 0, '62.84.152.162', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-13 04:17:51', 'completed', '', NULL),
 (2249, 0, '62.84.152.162', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-13 04:17:52', 'completed', '', NULL),
 (2250, 0, '62.84.152.162', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-13 04:17:53', 'completed', '', NULL),
 (2251, 0, '62.84.152.162', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-13 04:17:55', 'completed', '', NULL),
 (2252, 0, '62.84.152.162', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-13 04:17:56', 'completed', '', NULL),
 (2253, 0, '62.84.152.162', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-13 04:17:58', 'completed', '', NULL),
 (2254, 0, '85.228.161.40', 'Java/1.8.0_121', 2128, 2367, '', '2017-03-13 06:27:00', 'completed', '', NULL),
 (2255, 0, '85.228.161.40', 'Java/1.8.0_121', 2146, 2149, '', '2017-03-13 06:27:01', 'completed', '', NULL),
 (2256, 0, '85.228.161.40', 'Java/1.8.0_121', 2333, 2334, '', '2017-03-13 06:27:02', 'completed', '', NULL),
 (2257, 0, '85.228.161.40', 'Java/1.8.0_121', 2140, 2141, '', '2017-03-13 06:27:04', 'completed', '', NULL),
 (2258, 0, '85.228.161.40', 'Java/1.8.0_121', 2336, 2337, '', '2017-03-13 06:27:06', 'completed', '', NULL),
 (2259, 0, '85.228.161.40', 'Java/1.8.0_121', 1837, 1839, '', '2017-03-13 06:27:08', 'completed', '', NULL),
 (2260, 0, '85.228.161.40', 'Java/1.8.0_121', 1844, 1845, '', '2017-03-13 06:27:09', 'completed', '', NULL),
 (2261, 0, '85.228.161.40', 'Java/1.8.0_121', 2339, 2340, '', '2017-03-13 06:27:10', 'completed', '', NULL),
 (2262, 0, '85.228.161.40', 'Java/1.8.0_121', 2130, 2133, '', '2017-03-13 06:27:12', 'completed', '', NULL),
 (2263, 0, '85.228.161.40', 'Java/1.8.0_121', 2134, 2307, '', '2017-03-13 06:27:13', 'completed', '', NULL),
 (2264, 0, '85.228.161.40', 'Java/1.8.0_121', 2161, 2162, '', '2017-03-13 06:27:15', 'completed', '', NULL),
 (2265, 0, '85.228.161.40', 'Java/1.8.0_121', 2342, 2349, '', '2017-03-13 06:27:16', 'completed', '', NULL),
 (2266, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-03-13 10:05:34', 'completed', '', NULL),
 (2267, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2336, 2337, '', '2017-03-13 10:09:45', 'completed', '', NULL),
 (2268, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-03-13 10:09:56', 'completed', '', NULL),
 (2269, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-03-13 10:23:51', 'completed', '', NULL),
 (2270, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-03-13 10:28:55', 'completed', '', NULL),
 (2271, 0, '77.239.57.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2140, 2141, '', '2017-03-13 10:30:45', 'completed', '', NULL),
 (2272, 0, '100.36.205.85', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-13 13:21:27', 'completed', '', NULL),
 (2273, 0, '100.36.205.85', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-13 13:21:28', 'completed', '', NULL),
 (2274, 0, '100.36.205.85', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-13 13:21:29', 'completed', '', NULL),
 (2275, 0, '100.36.205.85', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-13 13:21:32', 'completed', '', NULL),
 (2276, 0, '100.36.205.85', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-13 13:21:33', 'completed', '', NULL),
 (2277, 0, '100.36.205.85', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-13 13:21:35', 'completed', '', NULL),
 (2278, 0, '100.36.205.85', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-13 13:21:36', 'completed', '', NULL),
 (2279, 0, '100.36.205.85', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-13 13:21:38', 'completed', '', NULL),
 (2280, 0, '100.36.205.85', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-13 13:21:40', 'completed', '', NULL),
 (2281, 0, '100.36.205.85', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-13 13:21:42', 'completed', '', NULL),
 (2282, 0, '100.36.205.85', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-13 13:21:44', 'completed', '', NULL),
 (2283, 0, '100.36.205.85', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-13 13:21:46', 'completed', '', NULL),
 (2284, 0, '109.164.220.46', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-03-13 19:28:46', 'completed', '', NULL),
 (2285, 0, '109.164.220.46', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-03-13 19:49:48', 'completed', '', NULL),
 (2286, 0, '207.46.13.193', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-03-13 20:15:36', 'completed', '', NULL),
 (2287, 0, '5.230.195.116', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-14 10:03:33', 'completed', '', NULL),
 (2288, 0, '5.230.195.116', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-14 10:03:34', 'completed', '', NULL),
 (2289, 0, '5.230.195.116', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-14 10:03:35', 'completed', '', NULL),
 (2290, 0, '5.230.195.116', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-14 10:03:37', 'completed', '', NULL),
 (2291, 0, '5.230.195.116', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-14 10:03:37', 'completed', '', NULL),
 (2292, 0, '5.230.195.116', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-14 10:03:38', 'completed', '', NULL),
 (2293, 0, '5.230.195.116', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-14 10:03:39', 'completed', '', NULL),
 (2294, 0, '5.230.195.116', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-14 10:03:40', 'completed', '', NULL),
 (2295, 0, '5.230.195.116', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-14 10:03:41', 'completed', '', NULL),
 (2296, 0, '5.230.195.116', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-14 10:03:42', 'completed', '', NULL),
 (2297, 0, '5.230.195.116', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-14 10:03:42', 'completed', '', NULL),
 (2298, 0, '5.230.195.116', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-14 10:03:43', 'completed', '', NULL),
 (2299, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-03-14 13:57:09', 'completed', '', NULL),
 (2300, 0, '81.185.237.185', 'Java/1.7.0_79', 2146, 2149, '', '2017-03-14 13:57:10', 'completed', '', NULL),
 (2301, 0, '81.185.237.185', 'Java/1.7.0_79', 2333, 2334, '', '2017-03-14 13:57:11', 'completed', '', NULL),
 (2302, 0, '81.185.237.185', 'Java/1.7.0_79', 2140, 2141, '', '2017-03-14 13:57:13', 'completed', '', NULL),
 (2303, 0, '81.185.237.185', 'Java/1.7.0_79', 2336, 2337, '', '2017-03-14 13:57:14', 'completed', '', NULL),
 (2304, 0, '81.185.237.185', 'Java/1.7.0_79', 1837, 1839, '', '2017-03-14 13:57:16', 'completed', '', NULL),
 (2305, 0, '81.185.237.185', 'Java/1.7.0_79', 1844, 1845, '', '2017-03-14 13:57:17', 'completed', '', NULL),
 (2306, 0, '81.185.237.185', 'Java/1.7.0_79', 2339, 2340, '', '2017-03-14 13:57:17', 'completed', '', NULL),
 (2307, 0, '81.185.237.185', 'Java/1.7.0_79', 2130, 2133, '', '2017-03-14 13:57:19', 'completed', '', NULL),
 (2308, 0, '81.185.237.185', 'Java/1.7.0_79', 2134, 2307, '', '2017-03-14 13:57:20', 'completed', '', NULL),
 (2309, 0, '81.185.237.185', 'Java/1.7.0_79', 2161, 2162, '', '2017-03-14 13:57:22', 'completed', '', NULL),
 (2310, 0, '81.185.237.185', 'Java/1.7.0_79', 2342, 2349, '', '2017-03-14 13:57:24', 'completed', '', NULL),
 (2311, 0, '178.197.234.184', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-03-14 15:23:52', 'completed', '', NULL),
 (2312, 0, '212.225.226.37', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-14 19:12:26', 'completed', '', NULL),
 (2313, 0, '212.225.226.37', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-14 19:12:27', 'completed', '', NULL),
 (2314, 0, '212.225.226.37', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-14 19:12:28', 'completed', '', NULL),
 (2315, 0, '212.225.226.37', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-14 19:12:32', 'completed', '', NULL),
 (2316, 0, '212.225.226.37', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-14 19:12:34', 'completed', '', NULL),
 (2317, 0, '212.225.226.37', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-14 19:12:36', 'completed', '', NULL),
 (2318, 0, '212.225.226.37', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-14 19:12:37', 'completed', '', NULL),
 (2319, 0, '212.225.226.37', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-14 19:12:38', 'completed', '', NULL),
 (2320, 0, '212.225.226.37', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-14 19:12:40', 'completed', '', NULL),
 (2321, 0, '212.225.226.37', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-14 19:12:42', 'completed', '', NULL),
 (2322, 0, '212.225.226.37', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-14 19:12:44', 'completed', '', NULL),
 (2323, 0, '212.225.226.37', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-14 19:12:46', 'completed', '', NULL),
 (2324, 0, '27.122.119.13', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-14 22:07:49', 'completed', '', NULL),
 (2325, 0, '27.122.119.13', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-14 22:07:52', 'completed', '', NULL),
 (2326, 0, '27.122.119.13', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-14 22:07:53', 'completed', '', NULL),
 (2327, 0, '27.122.119.13', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-14 22:07:57', 'completed', '', NULL),
 (2328, 0, '27.122.119.13', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-14 22:08:00', 'completed', '', NULL),
 (2329, 0, '27.122.119.13', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-14 22:08:02', 'completed', '', NULL),
 (2330, 0, '27.122.119.13', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-14 22:08:04', 'completed', '', NULL),
 (2331, 0, '27.122.119.13', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-14 22:08:07', 'completed', '', NULL),
 (2332, 0, '27.122.119.13', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-14 22:08:10', 'completed', '', NULL),
 (2333, 0, '27.122.119.13', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-14 22:08:14', 'completed', '', NULL),
 (2334, 0, '27.122.119.13', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-14 22:08:17', 'completed', '', NULL),
 (2335, 0, '27.122.119.13', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-14 22:08:22', 'completed', '', NULL),
 (2336, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2336, 2337, '', '2017-03-14 23:38:13', 'completed', '', NULL),
 (2337, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-03-15 02:57:18', 'completed', '', NULL),
 (2338, 0, '81.185.237.185', 'Java/1.7.0_79', 2146, 2149, '', '2017-03-15 02:57:19', 'completed', '', NULL),
 (2339, 0, '81.185.237.185', 'Java/1.7.0_79', 2333, 2334, '', '2017-03-15 02:57:20', 'completed', '', NULL),
 (2340, 0, '81.185.237.185', 'Java/1.7.0_79', 2140, 2141, '', '2017-03-15 02:57:22', 'completed', '', NULL),
 (2341, 0, '81.185.237.185', 'Java/1.7.0_79', 2336, 2337, '', '2017-03-15 02:57:23', 'completed', '', NULL),
 (2342, 0, '81.185.237.185', 'Java/1.7.0_79', 1837, 1839, '', '2017-03-15 02:57:24', 'completed', '', NULL),
 (2343, 0, '81.185.237.185', 'Java/1.7.0_79', 1844, 1845, '', '2017-03-15 02:57:25', 'completed', '', NULL),
 (2344, 0, '81.185.237.185', 'Java/1.7.0_79', 2339, 2340, '', '2017-03-15 02:57:26', 'completed', '', NULL),
 (2345, 0, '81.185.237.185', 'Java/1.7.0_79', 2130, 2133, '', '2017-03-15 02:57:28', 'completed', '', NULL),
 (2346, 0, '81.185.237.185', 'Java/1.7.0_79', 2134, 2307, '', '2017-03-15 02:57:29', 'completed', '', NULL),
 (2347, 0, '81.185.237.185', 'Java/1.7.0_79', 2161, 2162, '', '2017-03-15 02:57:30', 'completed', '', NULL),
 (2348, 0, '81.185.237.185', 'Java/1.7.0_79', 2342, 2349, '', '2017-03-15 02:57:32', 'completed', '', NULL),
 (2349, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2336, 2337, '', '2017-03-15 11:27:34', 'completed', '', NULL),
 (2350, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2140, 2141, '', '2017-03-15 11:27:44', 'completed', '', NULL),
 (2351, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2146, 2149, '', '2017-03-15 11:28:00', 'completed', '', NULL),
 (2352, 0, '212.225.226.62', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-15 11:31:57', 'completed', '', NULL),
 (2353, 0, '212.225.226.62', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-15 11:31:58', 'completed', '', NULL),
 (2354, 0, '212.225.226.62', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-15 11:31:59', 'completed', '', NULL),
 (2355, 0, '212.225.226.62', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-15 11:32:02', 'completed', '', NULL),
 (2356, 0, '212.225.226.62', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-15 11:32:03', 'completed', '', NULL),
 (2357, 0, '212.225.226.62', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-15 11:32:05', 'completed', '', NULL),
 (2358, 0, '212.225.226.62', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-15 11:32:07', 'completed', '', NULL),
 (2359, 0, '212.225.226.62', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-15 11:32:08', 'completed', '', NULL),
 (2360, 0, '212.225.226.62', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-15 11:32:09', 'completed', '', NULL),
 (2361, 0, '212.225.226.62', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-15 11:32:11', 'completed', '', NULL),
 (2362, 0, '212.225.226.62', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-15 11:32:13', 'completed', '', NULL),
 (2363, 0, '212.225.226.62', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-15 11:32:18', 'completed', '', NULL),
 (2364, 0, '191.101.31.6', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-15 12:35:55', 'completed', '', NULL),
 (2365, 0, '191.101.31.6', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-15 12:35:58', 'completed', '', NULL),
 (2366, 0, '191.101.31.6', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-15 12:35:59', 'completed', '', NULL),
 (2367, 0, '191.101.31.6', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-15 12:36:03', 'completed', '', NULL),
 (2368, 0, '191.101.31.6', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-15 12:36:06', 'completed', '', NULL),
 (2369, 0, '191.101.31.6', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-15 12:36:07', 'completed', '', NULL),
 (2370, 0, '191.101.31.6', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-15 12:36:08', 'completed', '', NULL),
 (2371, 0, '191.101.31.6', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-15 12:36:09', 'completed', '', NULL),
 (2372, 0, '191.101.31.6', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-15 12:36:12', 'completed', '', NULL),
 (2373, 0, '191.101.31.6', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-15 12:36:14', 'completed', '', NULL),
 (2374, 0, '191.101.31.6', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-15 12:36:18', 'completed', '', NULL),
 (2375, 0, '191.101.31.6', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-15 12:36:19', 'completed', '', NULL),
 (2376, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-16 00:11:32', 'completed', '', NULL),
 (2377, 0, '194.56.4.54', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-16 00:11:33', 'completed', '', NULL),
 (2378, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-16 00:12:25', 'completed', '', NULL),
 (2379, 0, '194.56.4.54', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-16 00:12:26', 'completed', '', NULL),
 (2380, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2017-03-16 07:54:46', 'completed', '', NULL),
 (2381, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-03-16 14:02:37', 'completed', '', NULL),
 (2382, 0, '79.114.248.49', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-16 22:22:53', 'completed', '', NULL),
 (2383, 0, '79.114.248.49', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-16 22:22:54', 'completed', '', NULL),
 (2384, 0, '79.114.248.49', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-16 22:22:54', 'completed', '', NULL),
 (2385, 0, '79.114.248.49', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-16 22:22:57', 'completed', '', NULL),
 (2386, 0, '79.114.248.49', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-16 22:22:58', 'completed', '', NULL),
 (2387, 0, '79.114.248.49', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-16 22:23:00', 'completed', '', NULL),
 (2388, 0, '79.114.248.49', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-16 22:23:01', 'completed', '', NULL),
 (2389, 0, '79.114.248.49', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-16 22:23:02', 'completed', '', NULL),
 (2390, 0, '79.114.248.49', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-16 22:23:03', 'completed', '', NULL),
 (2391, 0, '79.114.248.49', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-16 22:23:05', 'completed', '', NULL),
 (2392, 0, '79.114.248.49', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-16 22:23:07', 'completed', '', NULL),
 (2393, 0, '79.114.248.49', 'Java/1.6.0_04', 2342, 2349, '', '2017-03-16 22:23:08', 'completed', '', NULL),
 (2394, 0, '87.102.158.202', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-16 22:51:23', 'completed', '', NULL),
 (2395, 0, '213.200.234.182', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-03-17 10:04:45', 'completed', '', NULL),
 (2396, 0, '191.101.31.114', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-17 14:54:36', 'completed', '', NULL),
 (2397, 0, '191.101.31.114', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-17 14:54:37', 'completed', '', NULL),
 (2398, 0, '191.101.31.114', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-17 14:54:38', 'completed', '', NULL),
 (2399, 0, '191.101.31.114', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-17 14:54:40', 'completed', '', NULL),
 (2400, 0, '191.101.31.114', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-17 14:54:40', 'completed', '', NULL),
 (2401, 0, '191.101.31.114', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-17 14:54:41', 'completed', '', NULL),
 (2402, 0, '191.101.31.114', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-17 14:54:42', 'completed', '', NULL),
 (2403, 0, '191.101.31.114', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-17 14:54:43', 'completed', '', NULL),
 (2404, 0, '191.101.31.114', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-17 14:54:44', 'completed', '', NULL),
 (2405, 0, '191.101.31.114', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-17 14:54:45', 'completed', '', NULL),
 (2406, 0, '191.101.31.114', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-17 14:54:46', 'completed', '', NULL),
 (2407, 0, '191.101.31.114', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-17 14:54:47', 'completed', '', NULL),
 (2408, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-17 22:30:27', 'completed', '', NULL),
 (2409, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-03-17 22:35:37', 'completed', '', NULL),
 (2410, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-03-17 22:38:13', 'completed', '', NULL),
 (2411, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-17 22:39:31', 'completed', '', NULL),
 (2412, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-03-17 22:40:59', 'completed', '', NULL),
 (2413, 0, '178.38.131.105', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-03-17 22:43:31', 'completed', '', NULL),
 (2414, 0, '97.76.22.83', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-18 01:29:27', 'completed', '', NULL),
 (2415, 0, '97.76.22.83', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-18 01:29:28', 'completed', '', NULL),
 (2416, 0, '97.76.22.83', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-18 01:29:30', 'completed', '', NULL),
 (2417, 0, '97.76.22.83', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-18 01:29:34', 'completed', '', NULL),
 (2418, 0, '97.76.22.83', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-18 01:29:36', 'completed', '', NULL),
 (2419, 0, '97.76.22.83', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-18 01:29:38', 'completed', '', NULL),
 (2420, 0, '97.76.22.83', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-18 01:29:39', 'completed', '', NULL),
 (2421, 0, '97.76.22.83', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-18 01:29:41', 'completed', '', NULL),
 (2422, 0, '97.76.22.83', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-18 01:29:43', 'completed', '', NULL),
 (2423, 0, '97.76.22.83', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-18 01:29:46', 'completed', '', NULL),
 (2424, 0, '97.76.22.83', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-18 01:29:49', 'completed', '', NULL),
 (2425, 0, '97.76.22.83', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-18 01:29:52', 'completed', '', NULL),
 (2426, 0, '83.32.160.250', 'Java/1.8.0_65', 2128, 2367, '', '2017-03-18 05:10:46', 'completed', '', NULL),
 (2427, 0, '83.32.160.250', 'Java/1.8.0_65', 2146, 2149, '', '2017-03-18 05:10:48', 'completed', '', NULL),
 (2428, 0, '83.32.160.250', 'Java/1.8.0_65', 2333, 2334, '', '2017-03-18 05:10:49', 'completed', '', NULL),
 (2429, 0, '83.32.160.250', 'Java/1.8.0_65', 2140, 2141, '', '2017-03-18 05:10:52', 'completed', '', NULL),
 (2430, 0, '83.32.160.250', 'Java/1.8.0_65', 2336, 2337, '', '2017-03-18 05:10:53', 'completed', '', NULL),
 (2431, 0, '83.32.160.250', 'Java/1.8.0_65', 1837, 1839, '', '2017-03-18 05:10:55', 'completed', '', NULL),
 (2432, 0, '83.32.160.250', 'Java/1.8.0_65', 1844, 1845, '', '2017-03-18 05:10:56', 'completed', '', NULL),
 (2433, 0, '83.32.160.250', 'Java/1.8.0_65', 2339, 2340, '', '2017-03-18 05:10:57', 'completed', '', NULL),
 (2434, 0, '83.32.160.250', 'Java/1.8.0_65', 2130, 2133, '', '2017-03-18 05:10:59', 'completed', '', NULL),
 (2435, 0, '83.32.160.250', 'Java/1.8.0_65', 2134, 2307, '', '2017-03-18 05:11:02', 'completed', '', NULL),
 (2436, 0, '83.32.160.250', 'Java/1.8.0_65', 2161, 2162, '', '2017-03-18 05:11:04', 'completed', '', NULL),
 (2437, 0, '83.32.160.250', 'Java/1.8.0_65', 2342, 2349, '', '2017-03-18 05:11:07', 'completed', '', NULL),
 (2438, 0, '175.34.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-18 12:05:18', 'completed', '', NULL),
 (2439, 0, '175.34.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-18 12:06:40', 'completed', '', NULL),
 (2440, 0, '175.34.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-03-18 12:24:49', 'completed', '', NULL),
 (2441, 0, '175.34.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-03-18 12:36:58', 'completed', '', NULL),
 (2442, 0, '157.55.39.96', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-03-18 13:29:46', 'completed', '', NULL),
 (2443, 0, '188.61.185.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2336, 2337, '', '2017-03-18 14:54:57', 'completed', '', NULL),
 (2444, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-03-18 20:10:41', 'completed', '', NULL),
 (2445, 0, '209.90.232.106', 'Java/1.6.0_04', 2146, 2149, '', '2017-03-18 20:10:43', 'completed', '', NULL),
 (2446, 0, '209.90.232.106', 'Java/1.6.0_04', 2333, 2334, '', '2017-03-18 20:10:44', 'completed', '', NULL),
 (2447, 0, '209.90.232.106', 'Java/1.6.0_04', 2140, 2141, '', '2017-03-18 20:10:48', 'completed', '', NULL),
 (2448, 0, '209.90.232.106', 'Java/1.6.0_04', 2336, 2337, '', '2017-03-18 20:10:50', 'completed', '', NULL),
 (2449, 0, '209.90.232.106', 'Java/1.6.0_04', 1837, 1839, '', '2017-03-18 20:10:53', 'completed', '', NULL),
 (2450, 0, '209.90.232.106', 'Java/1.6.0_04', 1844, 1845, '', '2017-03-18 20:10:55', 'completed', '', NULL),
 (2451, 0, '209.90.232.106', 'Java/1.6.0_04', 2339, 2340, '', '2017-03-18 20:10:56', 'completed', '', NULL),
 (2452, 0, '209.90.232.106', 'Java/1.6.0_04', 2130, 2133, '', '2017-03-18 20:11:00', 'completed', '', NULL),
 (2453, 0, '209.90.232.106', 'Java/1.6.0_04', 2134, 2307, '', '2017-03-18 20:11:03', 'completed', '', NULL),
 (2454, 0, '209.90.232.106', 'Java/1.6.0_04', 2161, 2162, '', '2017-03-18 20:11:08', 'completed', '', NULL),
 (2455, 0, '178.197.234.162', 'Mozilla/5.0 (iPad; CPU OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-03-19 11:11:01', 'completed', '', NULL),
 (2456, 0, '175.34.71.253', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-03-19 11:59:04', 'completed', '', NULL),
 (2457, 0, '87.102.168.105', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2342, 2349, '', '2017-03-19 15:36:02', 'completed', '', NULL),
 (2458, 0, '85.6.200.83', 'Mozilla/5.0 (X11; Linux x86_64; rv:45.0) Gecko/20100101 Firefox/45.0', 2146, 2149, '', '2017-03-19 16:25:07', 'completed', '', NULL),
 (2459, 0, '62.28.191.178', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-19 17:18:52', 'completed', '', NULL),
 (2460, 0, '62.28.191.178', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-19 17:18:53', 'completed', '', NULL),
 (2461, 0, '62.28.191.178', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-19 17:18:54', 'completed', '', NULL),
 (2462, 0, '62.28.191.178', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-19 17:18:56', 'completed', '', NULL),
 (2463, 0, '62.28.191.178', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-19 17:18:57', 'completed', '', NULL),
 (2464, 0, '62.28.191.178', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-19 17:18:59', 'completed', '', NULL),
 (2465, 0, '62.28.191.178', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-19 17:19:00', 'completed', '', NULL),
 (2466, 0, '62.28.191.178', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-19 17:19:01', 'completed', '', NULL),
 (2467, 0, '62.28.191.178', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-19 17:19:03', 'completed', '', NULL),
 (2468, 0, '62.28.191.178', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-19 17:19:05', 'completed', '', NULL),
 (2469, 0, '62.28.191.178', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-19 17:19:07', 'completed', '', NULL),
 (2470, 0, '62.28.191.178', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-19 17:19:09', 'completed', '', NULL),
 (2471, 0, '82.192.246.195', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2128, 2367, '', '2017-03-19 19:24:10', 'completed', '', NULL),
 (2472, 0, '107.23.228.27', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-20 02:17:26', 'completed', '', NULL),
 (2473, 0, '107.23.228.27', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-20 02:17:32', 'completed', '', NULL),
 (2474, 0, '107.23.228.27', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-20 02:17:33', 'completed', '', NULL),
 (2475, 0, '107.23.228.27', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-20 02:17:54', 'completed', '', NULL),
 (2476, 0, '107.23.228.27', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-20 02:18:01', 'completed', '', NULL),
 (2477, 0, '107.23.228.27', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-20 02:18:17', 'completed', '', NULL),
 (2478, 0, '107.23.228.27', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-20 02:18:22', 'completed', '', NULL),
 (2479, 0, '107.23.228.27', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-20 02:18:29', 'completed', '', NULL),
 (2480, 0, '107.23.228.27', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-20 02:18:39', 'completed', '', NULL),
 (2481, 0, '107.23.228.27', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-20 02:18:47', 'completed', '', NULL),
 (2482, 0, '107.23.228.27', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-20 02:18:55', 'completed', '', NULL),
 (2483, 0, '107.23.228.27', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-20 02:19:04', 'completed', '', NULL),
 (2484, 0, '27.122.119.13', 'Java/1.4.1_04', 2128, 2367, '', '2017-03-20 04:55:29', 'completed', '', NULL),
 (2485, 0, '27.122.119.13', 'Java/1.4.1_04', 2146, 2149, '', '2017-03-20 04:55:31', 'completed', '', NULL),
 (2486, 0, '27.122.119.13', 'Java/1.4.1_04', 2333, 2334, '', '2017-03-20 04:55:32', 'completed', '', NULL),
 (2487, 0, '27.122.119.13', 'Java/1.4.1_04', 2140, 2141, '', '2017-03-20 04:55:37', 'completed', '', NULL),
 (2488, 0, '27.122.119.13', 'Java/1.4.1_04', 2336, 2337, '', '2017-03-20 04:55:40', 'completed', '', NULL),
 (2489, 0, '27.122.119.13', 'Java/1.4.1_04', 1837, 1839, '', '2017-03-20 04:55:44', 'completed', '', NULL),
 (2490, 0, '27.122.119.13', 'Java/1.4.1_04', 1844, 1845, '', '2017-03-20 04:55:46', 'completed', '', NULL),
 (2491, 0, '27.122.119.13', 'Java/1.4.1_04', 2339, 2340, '', '2017-03-20 04:55:47', 'completed', '', NULL),
 (2492, 0, '27.122.119.13', 'Java/1.4.1_04', 2130, 2133, '', '2017-03-20 04:55:51', 'completed', '', NULL),
 (2493, 0, '27.122.119.13', 'Java/1.4.1_04', 2134, 2307, '', '2017-03-20 04:55:55', 'completed', '', NULL),
 (2494, 0, '27.122.119.13', 'Java/1.4.1_04', 2161, 2162, '', '2017-03-20 04:56:00', 'completed', '', NULL),
 (2495, 0, '27.122.119.13', 'Java/1.4.1_04', 2342, 2349, '', '2017-03-20 04:56:05', 'completed', '', NULL),
 (2496, 0, '163.172.64.235', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-03-20 08:02:09', 'completed', '', NULL),
 (2497, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-03-20 17:15:02', 'completed', '', NULL),
 (2498, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2017-03-21 08:43:38', 'completed', '', NULL),
 (2499, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-03-22 02:15:00', 'completed', '', NULL),
 (2500, 0, '178.197.235.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-03-22 07:24:25', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(2501, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2130, 2133, '', '2017-03-22 09:30:11', 'completed', '', NULL),
 (2502, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2134, 2307, '', '2017-03-22 09:33:15', 'completed', '', NULL),
 (2503, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2342, 2349, '', '2017-03-22 09:34:16', 'completed', '', NULL),
 (2504, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2134, 2307, '', '2017-03-22 09:46:30', 'completed', '', NULL),
 (2505, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2130, 2133, '', '2017-03-22 09:48:37', 'completed', '', NULL),
 (2506, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-03-22 12:07:16', 'completed', '', NULL),
 (2507, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-03-22 13:32:33', 'completed', '', NULL),
 (2508, 0, '85.5.64.140', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-22 14:00:47', 'completed', '', NULL),
 (2509, 0, '85.5.64.140', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-03-22 14:01:42', 'completed', '', NULL),
 (2510, 0, '85.5.64.140', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-22 14:02:46', 'completed', '', NULL),
 (2511, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-22 14:11:27', 'completed', '', NULL),
 (2512, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-22 14:11:50', 'completed', '', NULL),
 (2513, 0, '85.3.29.24', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G920F/G920FXXU5EQBG Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.0 Chrome/51.0.2704.106 Mobile Safari/537.36', 2342, 2349, '', '2017-03-22 14:13:01', 'completed', '', NULL),
 (2514, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-22 14:13:13', 'completed', '', NULL),
 (2515, 0, '85.5.64.140', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-22 14:13:23', 'completed', '', NULL),
 (2516, 0, '194.230.155.115', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2342, 2349, '', '2017-03-22 14:23:47', 'completed', '', NULL),
 (2517, 0, '194.230.155.115', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2342, 2349, '', '2017-03-22 14:24:56', 'completed', '', NULL),
 (2518, 0, '85.5.64.140', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-22 14:32:29', 'completed', '', NULL),
 (2519, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-22 14:32:52', 'completed', '', NULL),
 (2520, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-22 14:38:34', 'completed', '', NULL),
 (2521, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-22 15:12:10', 'completed', '', NULL),
 (2522, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-22 15:12:58', 'failed', 'Datei nicht gefunden.', NULL),
 (2523, 0, '176.127.230.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-22 15:17:11', 'completed', '', NULL),
 (2524, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-22 15:18:56', 'completed', '', NULL),
 (2525, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-22 15:19:11', 'completed', '', NULL),
 (2526, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-22 15:20:40', 'completed', '', NULL),
 (2527, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-03-22 15:21:04', 'completed', '', NULL),
 (2528, 0, '85.3.123.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-22 15:55:45', 'completed', '', NULL),
 (2529, 0, '92.104.98.255', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-03-22 16:03:13', 'completed', '', NULL),
 (2530, 0, '92.104.98.255', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-03-22 16:03:32', 'completed', '', NULL),
 (2531, 0, '194.230.155.115', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2342, 2349, '', '2017-03-22 16:15:21', 'completed', '', NULL),
 (2532, 0, '194.230.155.115', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2342, 2349, '', '2017-03-22 16:16:31', 'completed', '', NULL),
 (2533, 0, '164.132.161.21', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-03-22 19:31:17', 'completed', '', NULL),
 (2534, 0, '40.77.167.94', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-03-23 03:30:16', 'completed', '', NULL),
 (2535, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2339, 2340, '', '2017-03-23 06:30:27', 'completed', '', NULL),
 (2536, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 1844, 1845, '', '2017-03-23 06:30:31', 'completed', '', NULL),
 (2537, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 1837, 1839, '', '2017-03-23 06:30:35', 'completed', '', NULL),
 (2538, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2146, 2149, '', '2017-03-23 06:30:39', 'completed', '', NULL),
 (2539, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2336, 2337, '', '2017-03-23 06:30:51', 'completed', '', NULL),
 (2540, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2140, 2141, '', '2017-03-23 06:30:57', 'completed', '', NULL),
 (2541, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2161, 2162, '', '2017-03-23 06:31:01', 'completed', '', NULL),
 (2542, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2342, 2349, '', '2017-03-23 06:31:07', 'completed', '', NULL),
 (2543, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2134, 2307, '', '2017-03-23 06:31:12', 'completed', '', NULL),
 (2544, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2130, 2133, '', '2017-03-23 06:31:16', 'completed', '', NULL),
 (2545, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2333, 2334, '', '2017-03-23 06:31:27', 'completed', '', NULL),
 (2546, 0, '93.84.105.89', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/37.0.2049.0 Safari/537.36', 2128, 2367, '', '2017-03-23 06:31:30', 'completed', '', NULL),
 (2547, 0, '176.127.230.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-23 06:40:39', 'completed', '', NULL),
 (2548, 0, '85.5.64.140', 'WhatsApp/2.17.7/i', 2342, 2349, '', '2017-03-23 07:20:02', 'completed', '', NULL),
 (2549, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-03-23 08:34:02', 'completed', '', NULL),
 (2550, 0, '207.46.13.83', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-03-23 10:41:30', 'completed', '', NULL),
 (2551, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-03-23 17:33:43', 'completed', '', NULL),
 (2552, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-03-23 17:40:03', 'completed', '', NULL),
 (2553, 0, '85.1.155.189', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2130, 2133, '', '2017-03-23 18:25:33', 'completed', '', NULL),
 (2554, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2128, 2367, '', '2017-03-23 21:50:40', 'completed', '', NULL),
 (2555, 0, '189.162.248.72', 'Mozilla/5.0 (Android 4.4.2; Tablet; rv:50.0) Gecko/50.0 Firefox/50.0', 2146, 2149, '', '2017-03-24 04:56:20', 'completed', '', NULL),
 (2556, 0, '178.197.236.26', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2130, 2133, '', '2017-03-24 09:51:12', 'completed', '', NULL),
 (2557, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-03-24 10:32:51', 'completed', '', NULL),
 (2558, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-03-24 11:56:47', 'completed', '', NULL),
 (2559, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-03-24 19:33:45', 'completed', '', NULL),
 (2560, 0, '157.55.39.8', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-03-24 22:37:51', 'completed', '', NULL),
 (2561, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-03-25 06:24:11', 'completed', '', NULL),
 (2562, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-03-25 09:19:36', 'completed', '', NULL),
 (2563, 0, '176.127.230.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-03-26 00:40:19', 'completed', '', NULL),
 (2564, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-03-26 01:17:06', 'completed', '', NULL),
 (2565, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-03-26 11:12:50', 'completed', '', NULL),
 (2566, 0, '40.77.167.88', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-03-26 20:12:13', 'completed', '', NULL),
 (2567, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-03-26 22:14:07', 'completed', '', NULL),
 (2568, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-26 22:14:46', 'completed', '', NULL),
 (2569, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-03-27 02:34:20', 'completed', '', NULL),
 (2570, 0, '178.38.28.21', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 1844, 1845, '', '2017-03-27 09:17:01', 'completed', '', NULL),
 (2571, 0, '194.209.83.231', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-03-27 10:35:25', 'completed', '', NULL),
 (2572, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-03-27 10:35:26', 'completed', '', NULL),
 (2573, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-27 10:40:55', 'completed', '', NULL),
 (2574, 0, '194.209.83.231', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-03-27 10:40:56', 'completed', '', NULL),
 (2575, 0, '178.196.216.214', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2140, 2141, '', '2017-03-27 15:22:52', 'completed', '', NULL),
 (2576, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-03-27 19:21:42', 'completed', '', NULL),
 (2577, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-03-27 23:48:52', 'completed', '', NULL),
 (2578, 0, '146.185.137.78', 'SafeDNSBot (https://www.safedns.com/searchbot)', 1844, 1845, '', '2017-03-28 11:18:35', 'completed', '', NULL),
 (2579, 0, '195.65.152.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 1844, 1845, '', '2017-03-28 13:09:17', 'completed', '', NULL),
 (2580, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-03-28 16:14:28', 'completed', '', NULL),
 (2581, 0, '85.1.210.217', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/24.1.151204851 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-03-28 16:40:22', 'completed', '', NULL),
 (2582, 0, '85.1.210.217', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/24.1.151204851 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-03-28 16:50:13', 'completed', '', NULL),
 (2583, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-03-28 22:32:55', 'completed', '', NULL),
 (2584, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-03-29 00:55:57', 'completed', '', NULL),
 (2585, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-03-29 12:30:12', 'completed', '', NULL),
 (2586, 0, '77.239.32.108', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-03-29 13:32:48', 'completed', '', NULL),
 (2587, 0, '157.55.39.87', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-03-29 13:59:32', 'completed', '', NULL),
 (2588, 0, '216.244.66.226', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-03-29 14:23:07', 'completed', '', NULL),
 (2589, 0, '40.77.167.88', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-03-29 14:29:46', 'completed', '', NULL),
 (2590, 0, '212.4.83.76', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-03-29 21:44:24', 'completed', '', NULL),
 (2591, 0, '46.127.233.98', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2336, 2337, '', '2017-03-29 21:49:55', 'completed', '', NULL),
 (2592, 0, '46.127.233.98', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-03-29 21:52:24', 'completed', '', NULL),
 (2593, 0, '157.55.39.18', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-03-30 02:27:06', 'completed', '', NULL),
 (2594, 0, '77.57.107.123', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2339, 2340, '', '2017-03-30 09:58:47', 'completed', '', NULL),
 (2595, 0, '77.57.107.123', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1844, 1845, '', '2017-03-30 10:00:44', 'completed', '', NULL),
 (2596, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-03-30 14:59:20', 'completed', '', NULL),
 (2597, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-03-30 14:59:25', 'completed', '', NULL),
 (2598, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-03-30 14:59:30', 'completed', '', NULL),
 (2599, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-03-30 14:59:51', 'completed', '', NULL),
 (2600, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-03-30 14:59:55', 'completed', '', NULL),
 (2601, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-03-30 15:00:00', 'completed', '', NULL),
 (2602, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-03-30 15:00:07', 'completed', '', NULL),
 (2603, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-03-30 15:00:35', 'completed', '', NULL),
 (2604, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-03-30 15:00:41', 'completed', '', NULL),
 (2605, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-03-30 15:01:20', 'completed', '', NULL),
 (2606, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-03-30 15:01:25', 'completed', '', NULL),
 (2607, 0, '45.55.171.70', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-03-30 15:01:31', 'completed', '', NULL),
 (2608, 0, '216.244.66.236', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-03-30 20:30:09', 'completed', '', NULL),
 (2609, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2140, 2141, '', '2017-03-30 22:24:31', 'completed', '', NULL),
 (2610, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2336, 2337, '', '2017-03-30 22:25:50', 'completed', '', NULL),
 (2611, 0, '207.46.13.28', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-03-31 00:39:34', 'completed', '', NULL),
 (2612, 0, '188.61.202.229', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-03-31 10:41:36', 'completed', '', NULL),
 (2613, 0, '188.61.202.229', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2333, 2334, '', '2017-03-31 10:41:52', 'completed', '', NULL),
 (2614, 0, '52.4.48.181', 'ia_archiver', 2339, 2340, '', '2017-03-31 10:47:09', 'completed', '', NULL),
 (2615, 0, '52.4.48.181', 'ia_archiver', 1837, 1839, '', '2017-03-31 10:52:38', 'completed', '', NULL),
 (2616, 0, '83.150.61.49', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2336, 2337, '', '2017-03-31 11:12:36', 'completed', '', NULL),
 (2617, 0, '83.150.61.49', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2140, 2141, '', '2017-03-31 11:22:24', 'completed', '', NULL),
 (2618, 0, '83.150.61.49', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2146, 2149, '', '2017-03-31 11:25:23', 'completed', '', NULL),
 (2619, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-03-31 13:34:35', 'completed', '', NULL),
 (2620, 0, '185.37.75.11', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-03-31 16:10:26', 'completed', '', NULL),
 (2621, 0, '5.153.125.143', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-03-31 17:24:45', 'completed', '', NULL),
 (2622, 0, '5.153.125.143', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-03-31 17:27:00', 'completed', '', NULL),
 (2623, 0, '5.153.125.143', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-03-31 17:30:55', 'completed', '', NULL),
 (2624, 0, '5.153.125.143', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-03-31 17:32:09', 'completed', '', NULL),
 (2625, 0, '185.74.120.42', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-03-31 21:53:44', 'completed', '', NULL),
 (2626, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-03-31 22:45:50', 'completed', '', NULL),
 (2627, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-03-31 22:52:46', 'completed', '', NULL),
 (2628, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2146, 2149, '', '2017-03-31 22:54:04', 'completed', '', NULL),
 (2629, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-03-31 22:54:15', 'completed', '', NULL),
 (2630, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2140, 2141, '', '2017-03-31 23:14:52', 'completed', '', NULL),
 (2631, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2336, 2337, '', '2017-03-31 23:15:20', 'completed', '', NULL),
 (2632, 0, '188.62.168.48', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-03-31 23:38:41', 'completed', '', NULL),
 (2633, 0, '188.62.168.48', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-03-31 23:47:14', 'completed', '', NULL),
 (2634, 0, '188.62.168.48', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-03-31 23:49:04', 'completed', '', NULL),
 (2635, 0, '185.27.4.225', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-04-01 10:58:52', 'completed', '', NULL),
 (2636, 0, '185.27.4.225', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-01 11:00:02', 'completed', '', NULL),
 (2637, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2333, 2334, '', '2017-04-01 13:05:56', 'completed', '', NULL),
 (2638, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-04-01 13:11:26', 'completed', '', NULL),
 (2639, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1844, 1845, '', '2017-04-01 13:13:33', 'completed', '', NULL),
 (2640, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1837, 1839, '', '2017-04-01 13:14:57', 'completed', '', NULL),
 (2641, 0, '52.4.48.181', 'ia_archiver', 2146, 2149, '', '2017-04-01 15:13:29', 'completed', '', NULL),
 (2642, 0, '178.197.229.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-04-01 18:05:58', 'completed', '', NULL),
 (2643, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-04-01 18:31:18', 'completed', '', NULL),
 (2644, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2339, 2340, '', '2017-04-01 20:25:01', 'completed', '', NULL),
 (2645, 0, '109.70.118.233', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2134, 2307, '', '2017-04-01 21:44:25', 'completed', '', NULL),
 (2646, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-02 06:10:42', 'completed', '', NULL),
 (2647, 0, '81.185.237.185', 'Java/1.7.0_79', 2128, 2367, '', '2017-04-02 09:14:42', 'completed', '', NULL),
 (2648, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-02 10:48:08', 'completed', '', NULL),
 (2649, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-04-02 10:51:24', 'completed', '', NULL),
 (2650, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2146, 2149, '', '2017-04-02 10:51:32', 'completed', '', NULL),
 (2651, 0, '92.104.225.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1844, 1845, '', '2017-04-02 10:53:55', 'completed', '', NULL),
 (2652, 0, '92.104.225.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2339, 2340, '', '2017-04-02 10:54:48', 'completed', '', NULL),
 (2653, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-02 11:27:08', 'completed', '', NULL),
 (2654, 0, '185.74.120.42', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-04-02 12:40:46', 'completed', '', NULL),
 (2655, 0, '185.74.120.42', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-04-02 12:45:09', 'completed', '', NULL),
 (2656, 0, '185.74.120.42', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-04-02 12:49:53', 'completed', '', NULL),
 (2657, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2134, 2307, '', '2017-04-02 17:42:18', 'completed', '', NULL),
 (2658, 0, '5.145.92.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2130, 2133, '', '2017-04-02 17:43:41', 'completed', '', NULL),
 (2659, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-02 20:46:50', 'completed', '', NULL),
 (2660, 0, '54.197.34.154', 'Java/1.4.1_04', 2128, 2367, '', '2017-04-02 21:39:53', 'completed', '', NULL),
 (2661, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-03 07:15:26', 'completed', '', NULL),
 (2662, 0, '178.195.175.246', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-04-03 07:38:28', 'completed', '', NULL),
 (2663, 0, '79.242.148.139', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36', 2333, 2334, '', '2017-04-03 13:49:56', 'completed', '', NULL),
 (2664, 0, '79.242.148.139', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.93 Safari/537.36', 2128, 2367, '', '2017-04-03 13:52:10', 'completed', '', NULL),
 (2665, 0, '5.153.115.58', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-04-03 14:51:24', 'completed', '', NULL),
 (2666, 0, '5.153.115.58', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-04-03 14:54:11', 'completed', '', NULL),
 (2667, 0, '31.165.157.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2140, 2141, '', '2017-04-03 17:13:26', 'completed', '', NULL),
 (2668, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-03 22:05:19', 'completed', '', NULL),
 (2669, 0, '89.217.236.198', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/601.6.17 (KHTML, like Gecko) Version/9.1.1 Safari/601.6.17', 2140, 2141, '', '2017-04-04 00:09:56', 'completed', '', NULL),
 (2670, 0, '46.140.26.250', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2146, 2149, '', '2017-04-04 12:26:42', 'completed', '', NULL),
 (2671, 0, '207.46.13.186', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-04-04 12:33:52', 'completed', '', NULL),
 (2672, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2307, '', '2017-04-04 12:51:53', 'completed', '', NULL),
 (2673, 0, '31.11.22.200', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-04-04 14:09:34', 'completed', '', NULL),
 (2674, 0, '194.230.155.178', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-04 18:53:50', 'completed', '', NULL),
 (2675, 0, '68.180.229.52', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1844, 1845, '', '2017-04-04 19:18:09', 'completed', '', NULL),
 (2676, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-04-04 21:53:11', 'completed', '', NULL),
 (2677, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-04-04 21:53:40', 'completed', '', NULL),
 (2678, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-04 21:55:24', 'completed', '', NULL),
 (2679, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-04 21:59:28', 'completed', '', NULL),
 (2680, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-04-04 21:59:30', 'completed', '', NULL),
 (2681, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-04-04 22:00:15', 'completed', '', NULL),
 (2682, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-04 22:04:57', 'completed', '', NULL),
 (2683, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2336, 2337, '', '2017-04-04 22:09:42', 'completed', '', NULL),
 (2684, 0, '85.1.203.245', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2333, 2334, '', '2017-04-04 22:20:55', 'completed', '', NULL),
 (2685, 0, '85.1.203.245', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2146, 2149, '', '2017-04-04 22:24:15', 'completed', '', NULL),
 (2686, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2333, 2334, '', '2017-04-05 02:02:09', 'completed', '', NULL),
 (2687, 0, '40.77.167.59', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-04-05 10:10:29', 'completed', '', NULL),
 (2688, 0, '188.155.180.198', 'Mozilla/5.0 (Linux; Android 6.0.1; D5803 Build/23.5.A.1.291) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.91 Mobile Safari/537.36', 1844, 1845, '', '2017-04-05 10:17:25', 'completed', '', NULL),
 (2689, 0, '89.217.245.253', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-04-05 10:27:32', 'completed', '', NULL),
 (2690, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2342, 2349, '', '2017-04-05 13:18:57', 'completed', '', NULL),
 (2691, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1837, 1839, '', '2017-04-05 15:26:14', 'completed', '', NULL),
 (2692, 0, '78.110.140.19', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0', 2342, 2349, '', '2017-04-05 16:55:31', 'completed', '', NULL),
 (2693, 0, '194.230.155.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-05 18:12:30', 'completed', '', NULL),
 (2694, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-05 22:17:20', 'completed', '', NULL),
 (2695, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-04-05 22:18:31', 'completed', '', NULL),
 (2696, 0, '157.55.39.17', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-04-06 02:28:55', 'completed', '', NULL),
 (2697, 0, '194.230.140.158', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-04-06 10:19:34', 'completed', '', NULL),
 (2698, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2017-04-06 10:36:34', 'completed', '', NULL),
 (2699, 0, '178.196.91.125', 'Mozilla/5.0 (Windows NT 6.1; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 10:38:09', 'completed', '', NULL),
 (2700, 0, '178.197.235.211', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-04-06 11:39:57', 'completed', '', NULL),
 (2701, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2342, 2349, '', '2017-04-06 13:58:07', 'completed', '', NULL),
 (2702, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 14:30:32', 'completed', '', NULL),
 (2703, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 14:37:19', 'completed', '', NULL),
 (2704, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 14:40:07', 'completed', '', NULL),
 (2705, 0, '81.62.72.195', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2146, 2149, '', '2017-04-06 14:45:26', 'completed', '', NULL),
 (2706, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-04-06 14:52:06', 'completed', '', NULL),
 (2707, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 15:04:13', 'completed', '', NULL),
 (2708, 0, '84.227.71.228', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-06 15:05:30', 'completed', '', NULL),
 (2709, 0, '178.197.232.252', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2140, 2141, '', '2017-04-06 18:40:33', 'completed', '', NULL),
 (2710, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2140, 2141, '', '2017-04-06 18:59:31', 'completed', '', NULL),
 (2711, 0, '85.1.141.113', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2339, 2340, '', '2017-04-06 21:13:19', 'completed', '', NULL),
 (2712, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-06 21:45:35', 'completed', '', NULL),
 (2713, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-04-06 21:45:57', 'completed', '', NULL),
 (2714, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-04-06 21:46:44', 'completed', '', NULL),
 (2715, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2140, 2141, '', '2017-04-06 22:38:42', 'completed', '', NULL),
 (2716, 0, '84.75.250.10', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-04-07 00:45:42', 'completed', '', NULL),
 (2717, 0, '84.75.250.10', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1844, 1845, '', '2017-04-07 00:49:44', 'completed', '', NULL),
 (2718, 0, '84.75.250.10', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1837, 1839, '', '2017-04-07 00:53:36', 'completed', '', NULL),
 (2719, 0, '84.75.250.10', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2128, 2367, '', '2017-04-07 01:32:42', 'completed', '', NULL),
 (2720, 0, '83.79.169.13', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2017-04-07 09:26:46', 'completed', '', NULL),
 (2721, 0, '83.79.169.13', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1837, 1839, '', '2017-04-07 09:27:27', 'completed', '', NULL),
 (2722, 0, '213.200.210.62', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2342, 2349, '', '2017-04-07 10:49:14', 'completed', '', NULL),
 (2723, 0, '213.200.210.62', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2134, 2307, '', '2017-04-07 10:51:03', 'completed', '', NULL),
 (2724, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2339, 2340, '', '2017-04-07 13:20:34', 'completed', '', NULL),
 (2725, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-04-07 13:26:46', 'completed', '', NULL),
 (2726, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2336, 2337, '', '2017-04-07 13:27:56', 'completed', '', NULL),
 (2727, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-04-07 13:28:12', 'completed', '', NULL),
 (2728, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2342, 2349, '', '2017-04-07 13:28:54', 'completed', '', NULL),
 (2729, 0, '46.127.35.185', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_3 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G34 Safari/601.1', 2146, 2149, '', '2017-04-07 19:49:41', 'completed', '', NULL),
 (2730, 0, '68.180.228.61', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2017-04-08 00:27:42', 'completed', '', NULL),
 (2731, 0, '68.180.228.48', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-04-08 05:19:50', 'completed', '', NULL),
 (2732, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-08 07:40:24', 'completed', '', NULL),
 (2733, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-04-08 07:42:36', 'completed', '', NULL),
 (2734, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-08 07:49:35', 'completed', '', NULL),
 (2735, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-08 21:34:10', 'completed', '', NULL),
 (2736, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-08 21:36:55', 'completed', '', NULL),
 (2737, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-04-08 21:42:19', 'completed', '', NULL),
 (2738, 0, '188.61.135.46', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-04-09 00:10:28', 'completed', '', NULL),
 (2739, 0, '188.61.135.46', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-09 00:12:30', 'completed', '', NULL),
 (2740, 0, '85.5.168.116', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2339, 2340, '', '2017-04-09 21:42:06', 'completed', '', NULL),
 (2741, 0, '212.25.3.240', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:51.0) Gecko/20100101 Firefox/51.0', 2130, 2133, '', '2017-04-10 10:39:04', 'completed', '', NULL),
 (2742, 0, '94.217.216.202', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-de; GT-P5210 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 2140, 2141, '', '2017-04-10 11:04:29', 'completed', '', NULL),
 (2743, 0, '94.217.216.202', 'Mozilla/5.0 (Linux; U; Android 4.4.2; de-de; GT-P5210 Build/KOT49H) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Safari/534.30', 2130, 2133, '', '2017-04-10 11:06:14', 'completed', '', NULL),
 (2744, 0, '213.55.184.251', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-04-10 13:13:07', 'completed', '', NULL),
 (2745, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1837, 1839, '', '2017-04-10 21:18:47', 'completed', '', NULL),
 (2746, 0, '80.219.11.86', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2146, 2149, '', '2017-04-10 21:23:24', 'completed', '', NULL),
 (2747, 0, '163.172.66.9', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-04-10 21:23:53', 'completed', '', NULL),
 (2748, 0, '157.55.39.87', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-04-10 21:29:27', 'completed', '', NULL),
 (2749, 0, '178.197.239.109', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-04-11 12:12:42', 'completed', '', NULL),
 (2750, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-04-11 19:14:00', 'completed', '', NULL),
 (2751, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1837, 1839, '', '2017-04-11 19:14:24', 'completed', '', NULL),
 (2752, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1844, 1845, '', '2017-04-11 19:14:33', 'completed', '', NULL),
 (2753, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-04-11 19:22:07', 'completed', '', NULL),
 (2754, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2333, 2334, '', '2017-04-11 19:59:47', 'completed', '', NULL),
 (2755, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2128, 2367, '', '2017-04-11 20:00:22', 'completed', '', NULL),
 (2756, 0, '178.196.97.236', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2336, 2337, '', '2017-04-11 20:01:19', 'completed', '', NULL),
 (2757, 0, '62.2.219.218', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-04-11 20:04:41', 'completed', '', NULL),
 (2758, 0, '62.2.219.218', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 1844, 1845, '', '2017-04-11 20:41:25', 'completed', '', NULL),
 (2759, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2339, 2340, '', '2017-04-11 21:35:50', 'completed', '', NULL),
 (2760, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 1844, 1845, '', '2017-04-11 21:35:51', 'completed', '', NULL),
 (2761, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 1837, 1839, '', '2017-04-11 21:35:52', 'completed', '', NULL),
 (2762, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2146, 2149, '', '2017-04-11 21:35:52', 'completed', '', NULL),
 (2763, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2336, 2337, '', '2017-04-11 21:35:57', 'completed', '', NULL),
 (2764, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2140, 2141, '', '2017-04-11 21:35:58', 'completed', '', NULL),
 (2765, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2161, 2162, '', '2017-04-11 21:35:59', 'completed', '', NULL),
 (2766, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2342, 2349, '', '2017-04-11 21:36:06', 'completed', '', NULL),
 (2767, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2134, 2307, '', '2017-04-11 21:36:08', 'completed', '', NULL),
 (2768, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2130, 2133, '', '2017-04-11 21:36:09', 'completed', '', NULL),
 (2769, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2333, 2334, '', '2017-04-11 21:36:12', 'completed', '', NULL),
 (2770, 0, '188.138.57.145', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2128, 2367, '', '2017-04-11 21:36:13', 'completed', '', NULL),
 (2771, 0, '178.82.222.200', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1844, 1845, '', '2017-04-11 22:29:09', 'completed', '', NULL),
 (2772, 0, '178.82.222.200', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1844, 1845, '', '2017-04-11 22:31:33', 'completed', '', NULL),
 (2773, 0, '178.82.222.200', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2339, 2340, '', '2017-04-11 22:33:53', 'completed', '', NULL),
 (2774, 0, '178.198.24.118', 'Mozilla/5.0 (iPad; CPU OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53', 2333, 2334, '', '2017-04-11 22:38:36', 'completed', '', NULL),
 (2775, 0, '85.7.55.2', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A510F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2146, 2149, '', '2017-04-11 23:11:50', 'completed', '', NULL),
 (2776, 0, '68.180.230.124', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2017-04-11 23:42:38', 'completed', '', NULL),
 (2777, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2339, 2340, '', '2017-04-12 03:25:56', 'completed', '', NULL),
 (2778, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 1844, 1845, '', '2017-04-12 03:26:06', 'completed', '', NULL),
 (2779, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 1837, 1839, '', '2017-04-12 03:26:19', 'completed', '', NULL),
 (2780, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2146, 2149, '', '2017-04-12 03:26:28', 'completed', '', NULL),
 (2781, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2336, 2337, '', '2017-04-12 03:28:57', 'completed', '', NULL),
 (2782, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2140, 2141, '', '2017-04-12 03:29:07', 'completed', '', NULL),
 (2783, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2161, 2162, '', '2017-04-12 03:29:22', 'completed', '', NULL),
 (2784, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2134, 2307, '', '2017-04-12 03:29:39', 'completed', '', NULL),
 (2785, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2130, 2133, '', '2017-04-12 03:29:48', 'completed', '', NULL),
 (2786, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2333, 2334, '', '2017-04-12 03:30:07', 'completed', '', NULL),
 (2787, 0, '139.18.2.132', 'LCC (+http://corpora.informatik.uni-leipzig.de/crawler_faq.html)', 2128, 2367, '', '2017-04-12 03:30:20', 'completed', '', NULL),
 (2788, 0, '207.46.13.62', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-04-12 10:00:12', 'completed', '', NULL),
 (2789, 0, '194.230.159.88', 'Mozilla/5.0 (Linux; Android 6.0; HUAWEI GRA-L09 Build/HUAWEIGRA-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Mobile Safari/537.36', 2128, 2367, '', '2017-04-12 11:44:23', 'completed', '', NULL),
 (2790, 0, '62.203.131.237', 'Mozilla/5.0 (iPad; CPU OS 7_1_2 like Mac OS X) AppleWebKit/537.51.2 (KHTML, like Gecko) Version/7.0 Mobile/11D257 Safari/9537.53', 2333, 2334, '', '2017-04-12 16:13:17', 'completed', '', NULL),
 (2791, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2146, 2149, '', '2017-04-12 19:38:26', 'completed', '', NULL),
 (2792, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2130, 2133, '', '2017-04-12 20:39:18', 'completed', '', NULL),
 (2793, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2128, 2367, '', '2017-04-12 20:54:21', 'completed', '', NULL),
 (2794, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2336, 2337, '', '2017-04-12 22:42:38', 'completed', '', NULL),
 (2795, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2333, 2334, '', '2017-04-12 23:43:56', 'completed', '', NULL),
 (2796, 0, '68.180.230.124', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2128, 2367, '', '2017-04-13 06:04:44', 'completed', '', NULL),
 (2797, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2161, 2162, '', '2017-04-13 06:08:53', 'completed', '', NULL),
 (2798, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 1837, 1839, '', '2017-04-13 06:24:26', 'completed', '', NULL),
 (2799, 0, '157.55.39.173', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-04-13 06:33:26', 'completed', '', NULL),
 (2800, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2342, 2349, '', '2017-04-13 08:12:01', 'completed', '', NULL),
 (2801, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 1844, 1845, '', '2017-04-13 08:27:21', 'completed', '', NULL),
 (2802, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2339, 2340, '', '2017-04-13 10:09:14', 'completed', '', NULL),
 (2803, 0, '194.150.244.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2339, 2340, '', '2017-04-13 10:09:15', 'completed', '', NULL),
 (2804, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2134, 2307, '', '2017-04-13 11:46:40', 'completed', '', NULL),
 (2805, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2339, 2340, '', '2017-04-13 13:33:52', 'completed', '', NULL),
 (2806, 0, '80.74.128.217', 'wiederfreibot/1.0 (+http://twitter.com/wiederfrei)', 2140, 2141, '', '2017-04-13 15:23:06', 'completed', '', NULL),
 (2807, 0, '178.38.56.17', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MALNJS; rv:11.0) like Gecko', 2146, 2149, '', '2017-04-13 18:19:02', 'completed', '', NULL),
 (2808, 0, '178.197.224.208', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-13 23:38:31', 'completed', '', NULL),
 (2809, 0, '178.197.224.208', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-04-13 23:39:13', 'completed', '', NULL),
 (2810, 0, '178.193.42.205', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G920F/G920FXXU5EQBG Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.0 Chrome/51.0.2704.106 Mobile Safari/537.36', 2128, 2367, '', '2017-04-14 08:05:40', 'completed', '', NULL),
 (2811, 0, '212.35.12.34', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G935F/G935FXXU1DQBO Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.0 Chrome/51.0.2704.106 Mobile Safari/537.36', 2342, 2349, '', '2017-04-14 09:10:47', 'completed', '', NULL),
 (2812, 0, '212.35.12.34', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2134, 2307, '', '2017-04-14 09:34:59', 'completed', '', NULL),
 (2813, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-04-14 19:08:04', 'completed', '', NULL),
 (2814, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-14 23:14:16', 'completed', '', NULL),
 (2815, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-04-14 23:14:38', 'completed', '', NULL),
 (2816, 0, '40.77.167.125', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-04-15 09:04:12', 'completed', '', NULL),
 (2817, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-04-15 11:16:30', 'completed', '', NULL),
 (2818, 0, '51.255.65.88', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-04-15 14:41:20', 'completed', '', NULL),
 (2819, 0, '84.73.216.26', 'Mozilla/5.0 (Linux; Android 7.1.1; Nexus 5X Build/N4F26T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2134, 2307, '', '2017-04-15 18:00:45', 'completed', '', NULL),
 (2820, 0, '84.73.216.26', 'Mozilla/5.0 (Linux; Android 7.1.1; Nexus 5X Build/N4F26T) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2130, 2133, '', '2017-04-15 18:02:07', 'completed', '', NULL),
 (2821, 0, '213.58.162.61', 'Java/1.6.0_26', 2128, 2367, '', '2017-04-15 23:17:41', 'completed', '', NULL),
 (2822, 0, '213.58.162.61', 'Java/1.6.0_26', 2146, 2149, '', '2017-04-15 23:17:43', 'completed', '', NULL),
 (2823, 0, '213.58.162.61', 'Java/1.6.0_26', 2333, 2334, '', '2017-04-15 23:17:44', 'completed', '', NULL),
 (2824, 0, '213.58.162.61', 'Java/1.6.0_26', 2140, 2141, '', '2017-04-15 23:17:48', 'completed', '', NULL),
 (2825, 0, '213.58.162.61', 'Java/1.6.0_26', 2336, 2337, '', '2017-04-15 23:17:49', 'completed', '', NULL),
 (2826, 0, '213.58.162.61', 'Java/1.6.0_26', 1837, 1839, '', '2017-04-15 23:17:51', 'completed', '', NULL),
 (2827, 0, '213.58.162.61', 'Java/1.6.0_26', 1844, 1845, '', '2017-04-15 23:17:52', 'completed', '', NULL),
 (2828, 0, '213.58.162.61', 'Java/1.6.0_26', 2339, 2340, '', '2017-04-15 23:17:54', 'completed', '', NULL),
 (2829, 0, '213.58.162.61', 'Java/1.6.0_26', 2130, 2133, '', '2017-04-15 23:17:56', 'completed', '', NULL),
 (2830, 0, '213.58.162.61', 'Java/1.6.0_26', 2134, 2307, '', '2017-04-15 23:17:57', 'completed', '', NULL),
 (2831, 0, '213.58.162.61', 'Java/1.6.0_26', 2161, 2162, '', '2017-04-15 23:17:59', 'completed', '', NULL),
 (2832, 0, '213.58.162.61', 'Java/1.6.0_26', 2342, 2349, '', '2017-04-15 23:18:12', 'completed', '', NULL),
 (2833, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2130, 2133, '', '2017-04-16 01:43:33', 'completed', '', NULL),
 (2834, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2140, 2141, '', '2017-04-16 01:43:51', 'completed', '', NULL),
 (2835, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2336, 2337, '', '2017-04-16 01:44:09', 'completed', '', NULL),
 (2836, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2342, 2349, '', '2017-04-16 01:44:19', 'completed', '', NULL),
 (2837, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2161, 2162, '', '2017-04-16 01:45:39', 'completed', '', NULL),
 (2838, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 1844, 1845, '', '2017-04-16 01:45:57', 'completed', '', NULL),
 (2839, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2339, 2340, '', '2017-04-16 01:46:34', 'completed', '', NULL),
 (2840, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 2134, 2307, '', '2017-04-16 01:47:00', 'completed', '', NULL),
 (2841, 0, '2.248.63.47', 'Mozilla/5.0 (Windows NT 5.1; rv:26.0) Gecko/20100101 Firefox/26.0', 1837, 1839, '', '2017-04-16 01:47:36', 'completed', '', NULL),
 (2842, 0, '164.132.162.187', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-04-16 16:56:13', 'completed', '', NULL),
 (2843, 0, '137.74.207.102', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-04-16 17:31:39', 'completed', '', NULL),
 (2844, 0, '40.77.167.4', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-04-16 21:07:13', 'completed', '', NULL),
 (2845, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-16 21:16:01', 'completed', '', NULL),
 (2846, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-16 21:16:02', 'completed', '', NULL),
 (2847, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-16 21:16:03', 'completed', '', NULL),
 (2848, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-16 21:16:06', 'completed', '', NULL),
 (2849, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-16 21:16:07', 'completed', '', NULL),
 (2850, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-16 21:16:08', 'completed', '', NULL),
 (2851, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-16 21:16:09', 'completed', '', NULL),
 (2852, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-16 21:16:10', 'completed', '', NULL),
 (2853, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-16 21:16:12', 'completed', '', NULL),
 (2854, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-16 21:16:13', 'completed', '', NULL),
 (2855, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-16 21:16:14', 'completed', '', NULL),
 (2856, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-16 21:16:16', 'completed', '', NULL),
 (2857, 0, '188.61.103.59', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0', 2140, 2141, '', '2017-04-17 14:22:52', 'completed', '', NULL),
 (2858, 0, '188.61.103.59', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0', 2146, 2149, '', '2017-04-17 14:24:07', 'completed', '', NULL),
 (2859, 0, '188.61.103.59', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:41.0) Gecko/20100101 Firefox/41.0', 2128, 2367, '', '2017-04-17 14:25:25', 'completed', '', NULL),
 (2860, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 1844, 1845, '', '2017-04-17 15:25:41', 'completed', '', NULL),
 (2861, 0, '31.10.166.2', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-04-17 18:42:13', 'completed', '', NULL),
 (2862, 0, '31.10.166.2', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-04-17 19:05:16', 'completed', '', NULL),
 (2863, 0, '51.255.65.62', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2161, 2162, '', '2017-04-17 20:14:59', 'completed', '', NULL),
 (2864, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2130, 2133, '', '2017-04-17 22:41:33', 'completed', '', NULL),
 (2865, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2134, 2307, '', '2017-04-17 22:47:31', 'completed', '', NULL),
 (2866, 0, '178.193.124.127', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:52.0) Gecko/20100101 Firefox/52.0', 2342, 2349, '', '2017-04-17 22:53:44', 'completed', '', NULL),
 (2867, 0, '178.197.227.87', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A510F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-04-17 23:07:21', 'completed', '', NULL),
 (2868, 0, '178.197.227.87', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A510F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-04-17 23:07:22', 'completed', '', NULL),
 (2869, 0, '145.250.209.1', 'Mozilla/5.0 (compatible; MSIE 10.0; Windows NT 6.1; WOW64; Trident/6.0)', 2140, 2141, '', '2017-04-18 02:06:17', 'completed', '', NULL),
 (2870, 0, '77.56.30.216', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-04-18 09:43:43', 'completed', '', NULL),
 (2871, 0, '77.56.30.216', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-04-18 09:44:44', 'completed', '', NULL),
 (2872, 0, '77.56.30.216', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2146, 2149, '', '2017-04-18 09:47:17', 'completed', '', NULL),
 (2873, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-04-18 11:31:20', 'completed', '', NULL),
 (2874, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-04-18 11:31:25', 'completed', '', NULL),
 (2875, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-04-18 11:31:31', 'completed', '', NULL),
 (2876, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-04-18 11:31:50', 'completed', '', NULL),
 (2877, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-04-18 11:31:56', 'completed', '', NULL),
 (2878, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-04-18 11:32:01', 'completed', '', NULL),
 (2879, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-04-18 11:32:06', 'completed', '', NULL),
 (2880, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-04-18 11:32:31', 'completed', '', NULL),
 (2881, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-04-18 11:32:36', 'completed', '', NULL),
 (2882, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-04-18 11:33:15', 'completed', '', NULL),
 (2883, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-04-18 11:33:20', 'completed', '', NULL),
 (2884, 0, '104.131.29.255', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-04-18 11:33:25', 'completed', '', NULL),
 (2885, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2140, 2141, '', '2017-04-18 18:02:54', 'completed', '', NULL),
 (2886, 0, '84.227.253.134', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2140, 2141, '', '2017-04-19 00:12:26', 'completed', '', NULL),
 (2887, 0, '85.3.49.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2134, 2307, '', '2017-04-19 10:36:28', 'completed', '', NULL),
 (2888, 0, '85.3.49.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2342, 2349, '', '2017-04-19 10:39:01', 'completed', '', NULL),
 (2889, 0, '85.3.49.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2130, 2133, '', '2017-04-19 10:45:00', 'completed', '', NULL),
 (2890, 0, '85.3.49.178', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2146, 2149, '', '2017-04-19 10:48:56', 'completed', '', NULL),
 (2891, 0, '88.75.116.108', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:52.0) Gecko/20100101 Firefox/52.0', 2146, 2149, '', '2017-04-19 14:18:56', 'completed', '', NULL),
 (2892, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2140, 2141, '', '2017-04-19 14:30:29', 'completed', '', NULL),
 (2893, 0, '88.75.116.108', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:52.0) Gecko/20100101 Firefox/52.0', 2140, 2141, '', '2017-04-19 15:21:22', 'completed', '', NULL),
 (2894, 0, '88.75.116.108', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; rv:52.0) Gecko/20100101 Firefox/52.0', 2336, 2337, '', '2017-04-19 15:22:00', 'completed', '', NULL),
 (2895, 0, '178.197.237.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 1844, 1845, '', '2017-04-19 20:52:22', 'completed', '', NULL),
 (2896, 0, '178.197.237.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2130, 2133, '', '2017-04-19 20:53:11', 'completed', '', NULL),
 (2897, 0, '178.197.237.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-04-19 20:53:37', 'completed', '', NULL),
 (2898, 0, '195.154.55.124', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-20 02:03:47', 'completed', '', NULL),
 (2899, 0, '195.154.55.124', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-20 02:03:50', 'completed', '', NULL),
 (2900, 0, '195.154.55.124', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-20 02:03:51', 'completed', '', NULL),
 (2901, 0, '195.154.55.124', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-20 02:03:56', 'completed', '', NULL),
 (2902, 0, '195.154.55.124', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-20 02:03:57', 'completed', '', NULL),
 (2903, 0, '195.154.55.124', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-20 02:04:00', 'completed', '', NULL),
 (2904, 0, '195.154.55.124', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-20 02:04:02', 'completed', '', NULL),
 (2905, 0, '195.154.55.124', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-20 02:04:04', 'completed', '', NULL),
 (2906, 0, '195.154.55.124', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-20 02:04:07', 'completed', '', NULL),
 (2907, 0, '195.154.55.124', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-20 02:04:11', 'completed', '', NULL),
 (2908, 0, '195.154.55.124', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-20 02:04:13', 'completed', '', NULL),
 (2909, 0, '195.154.55.124', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-20 02:04:16', 'completed', '', NULL),
 (2910, 0, '85.5.62.179', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-04-20 10:00:03', 'completed', '', NULL),
 (2911, 0, '85.5.62.179', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-04-20 10:02:06', 'completed', '', NULL),
 (2912, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2140, 2141, '', '2017-04-20 15:18:04', 'completed', '', NULL),
 (2913, 0, '84.227.253.134', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_3) AppleWebKit/601.4.4 (KHTML, like Gecko) Version/9.0.3 Safari/601.4.4', 2146, 2149, '', '2017-04-20 15:18:48', 'completed', '', NULL),
 (2914, 0, '178.192.40.134', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2134, 2307, '', '2017-04-20 23:54:56', 'completed', '', NULL),
 (2915, 0, '178.192.40.134', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2342, 2349, '', '2017-04-20 23:55:13', 'completed', '', NULL),
 (2916, 0, '80.219.169.25', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2342, 2349, '', '2017-04-21 04:25:25', 'completed', '', NULL),
 (2917, 0, '217.182.132.86', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-04-21 14:04:39', 'completed', '', NULL),
 (2918, 0, '178.39.138.181', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2333, 2334, '', '2017-04-21 15:55:54', 'completed', '', NULL),
 (2919, 0, '178.39.138.181', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-04-21 15:56:46', 'completed', '', NULL),
 (2920, 0, '83.78.90.132', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2336, 2337, '', '2017-04-21 16:50:42', 'completed', '', NULL),
 (2921, 0, '83.78.90.132', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-04-21 17:00:24', 'completed', '', NULL),
 (2922, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1844, 1845, '', '2017-04-21 20:25:39', 'completed', '', NULL),
 (2923, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1837, 1839, '', '2017-04-21 20:26:16', 'completed', '', NULL),
 (2924, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1844, 1845, '', '2017-04-21 20:26:47', 'completed', '', NULL),
 (2925, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-04-21 20:27:57', 'completed', '', NULL),
 (2926, 0, '195.154.55.124', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-21 22:15:18', 'completed', '', NULL),
 (2927, 0, '195.154.55.124', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-21 22:15:19', 'completed', '', NULL),
 (2928, 0, '195.154.55.124', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-21 22:15:20', 'completed', '', NULL),
 (2929, 0, '195.154.55.124', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-21 22:15:22', 'completed', '', NULL),
 (2930, 0, '195.154.55.124', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-21 22:15:23', 'completed', '', NULL),
 (2931, 0, '195.154.55.124', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-21 22:15:25', 'completed', '', NULL),
 (2932, 0, '195.154.55.124', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-21 22:15:26', 'completed', '', NULL),
 (2933, 0, '195.154.55.124', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-21 22:15:27', 'completed', '', NULL),
 (2934, 0, '195.154.55.124', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-21 22:15:29', 'completed', '', NULL),
 (2935, 0, '195.154.55.124', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-21 22:15:30', 'completed', '', NULL),
 (2936, 0, '195.154.55.124', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-21 22:15:32', 'completed', '', NULL),
 (2937, 0, '195.154.55.124', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-21 22:15:34', 'completed', '', NULL),
 (2938, 0, '178.197.236.67', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-04-22 10:58:22', 'completed', '', NULL),
 (2939, 0, '178.197.236.67', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2342, 2349, '', '2017-04-22 10:58:44', 'completed', '', NULL),
 (2940, 0, '46.127.57.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2336, 2337, '', '2017-04-22 16:19:58', 'completed', '', NULL),
 (2941, 0, '40.77.167.96', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-04-22 20:51:08', 'completed', '', NULL),
 (2942, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-23 00:48:35', 'completed', '', NULL),
 (2943, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-23 00:48:36', 'completed', '', NULL),
 (2944, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-23 00:48:37', 'completed', '', NULL),
 (2945, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-23 00:48:40', 'completed', '', NULL),
 (2946, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-23 00:48:41', 'completed', '', NULL),
 (2947, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-23 00:48:42', 'completed', '', NULL),
 (2948, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-23 00:48:43', 'completed', '', NULL),
 (2949, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-23 00:48:45', 'completed', '', NULL),
 (2950, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-23 00:48:46', 'completed', '', NULL),
 (2951, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-23 00:48:48', 'completed', '', NULL),
 (2952, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-23 00:48:49', 'completed', '', NULL),
 (2953, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-23 00:48:51', 'completed', '', NULL),
 (2954, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-23 10:00:09', 'completed', '', NULL),
 (2955, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-23 10:00:13', 'completed', '', NULL),
 (2956, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-23 10:00:14', 'completed', '', NULL),
 (2957, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-23 10:00:20', 'completed', '', NULL),
 (2958, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-23 10:00:21', 'completed', '', NULL),
 (2959, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-23 10:00:23', 'completed', '', NULL),
 (2960, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-23 10:00:24', 'completed', '', NULL),
 (2961, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-23 10:00:27', 'completed', '', NULL),
 (2962, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-23 10:00:29', 'completed', '', NULL),
 (2963, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-23 10:00:31', 'completed', '', NULL),
 (2964, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-23 10:00:33', 'completed', '', NULL),
 (2965, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-23 10:00:34', 'completed', '', NULL),
 (2966, 0, '158.181.109.12', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2128, 2367, '', '2017-04-23 10:10:52', 'completed', '', NULL),
 (2967, 0, '178.82.222.200', 'Mozilla/5.0 (Linux; Android 4.4.4; SM-T560 Build/KTU84P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.109 Safari/537.36', 1844, 1845, '', '2017-04-23 13:42:49', 'completed', '', NULL),
 (2968, 0, '94.16.166.201', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:52.0) Gecko/20100101 Firefox/52.0', 2134, 2307, '', '2017-04-23 15:47:20', 'completed', '', NULL),
 (2969, 0, '188.62.244.34', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2130, 2133, '', '2017-04-23 20:01:44', 'completed', '', NULL),
 (2970, 0, '31.10.167.71', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1844, 1845, '', '2017-04-23 21:35:16', 'completed', '', NULL),
 (2971, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2134, 2307, '', '2017-04-25 08:02:35', 'completed', '', NULL),
 (2972, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2130, 2133, '', '2017-04-25 08:03:12', 'completed', '', NULL),
 (2973, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-04-25 08:03:46', 'completed', '', NULL),
 (2974, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2342, 2349, '', '2017-04-25 08:04:11', 'completed', '', NULL),
 (2975, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-04-25 08:11:33', 'completed', '', NULL),
 (2976, 0, '93.174.190.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2130, 2133, '', '2017-04-25 08:14:50', 'completed', '', NULL),
 (2977, 0, '158.181.109.12', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2128, 2367, '', '2017-04-25 10:06:40', 'completed', '', NULL),
 (2978, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-25 11:27:44', 'completed', '', NULL),
 (2979, 0, '198.240.212.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-25 11:27:47', 'completed', '', NULL),
 (2980, 0, '198.240.212.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-25 11:29:35', 'completed', '', NULL),
 (2981, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-04-25 11:29:49', 'completed', '', NULL),
 (2982, 0, '198.240.212.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-04-25 11:29:49', 'completed', '', NULL),
 (2983, 0, '198.240.212.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-04-25 11:30:02', 'completed', '', NULL),
 (2984, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-04-25 11:30:14', 'completed', '', NULL),
 (2985, 0, '198.240.212.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-04-25 11:30:14', 'completed', '', NULL),
 (2986, 0, '213.58.162.61', 'Java/1.6.0_26', 2128, 2367, '', '2017-04-25 14:26:15', 'completed', '', NULL),
 (2987, 0, '213.58.162.61', 'Java/1.6.0_26', 2146, 2149, '', '2017-04-25 14:26:17', 'completed', '', NULL),
 (2988, 0, '213.58.162.61', 'Java/1.6.0_26', 2333, 2334, '', '2017-04-25 14:26:19', 'completed', '', NULL),
 (2989, 0, '213.58.162.61', 'Java/1.6.0_26', 2140, 2141, '', '2017-04-25 14:26:24', 'completed', '', NULL),
 (2990, 0, '213.58.162.61', 'Java/1.6.0_26', 2336, 2337, '', '2017-04-25 14:26:26', 'completed', '', NULL),
 (2991, 0, '213.58.162.61', 'Java/1.6.0_26', 1837, 1839, '', '2017-04-25 14:26:28', 'completed', '', NULL),
 (2992, 0, '213.58.162.61', 'Java/1.6.0_26', 1844, 1845, '', '2017-04-25 14:26:30', 'completed', '', NULL),
 (2993, 0, '213.58.162.61', 'Java/1.6.0_26', 2339, 2340, '', '2017-04-25 14:26:31', 'completed', '', NULL),
 (2994, 0, '213.58.162.61', 'Java/1.6.0_26', 2130, 2133, '', '2017-04-25 14:26:33', 'completed', '', NULL),
 (2995, 0, '213.58.162.61', 'Java/1.6.0_26', 2134, 2307, '', '2017-04-25 14:26:36', 'completed', '', NULL),
 (2996, 0, '213.58.162.61', 'Java/1.6.0_26', 2161, 2162, '', '2017-04-25 14:26:40', 'completed', '', NULL),
 (2997, 0, '213.58.162.61', 'Java/1.6.0_26', 2342, 2349, '', '2017-04-25 14:26:42', 'completed', '', NULL),
 (2998, 0, '164.132.161.90', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-04-25 14:33:40', 'completed', '', NULL),
 (2999, 0, '207.46.13.25', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-04-25 15:04:34', 'completed', '', NULL),
 (3000, 0, '85.7.54.6', 'Mozilla/5.0 (Linux; Android 5.0; SAMSUNG SM-N9005 Build/LRX21V) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2140, 2141, '', '2017-04-25 21:03:25', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(3001, 0, '85.7.54.6', 'Mozilla/5.0 (Linux; Android 5.0; SAMSUNG SM-N9005 Build/LRX21V) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-04-25 21:04:49', 'completed', '', NULL),
 (3002, 0, '85.7.54.6', 'Mozilla/5.0 (Linux; Android 5.0; SAMSUNG SM-N9005 Build/LRX21V) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-04-25 21:06:17', 'completed', '', NULL),
 (3003, 0, '207.46.13.4', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-04-26 12:29:32', 'completed', '', NULL),
 (3004, 0, '178.197.227.135', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-04-26 18:10:41', 'completed', '', NULL),
 (3005, 0, '178.197.227.135', 'WhatsApp/2.17.11/i', 2339, 2340, '', '2017-04-26 18:11:49', 'completed', '', NULL),
 (3006, 0, '85.0.164.42', 'Mozilla/5.0 (Android 7.0; Mobile; rv:53.0) Gecko/53.0 Firefox/53.0', 2339, 2340, '', '2017-04-26 18:53:41', 'completed', '', NULL),
 (3007, 0, '85.0.164.42', 'Dalvik/2.1.0 (Linux; U; Android 7.0; HTC One M9 Build/NRD90M)', 2339, 2340, '', '2017-04-26 18:54:40', 'completed', '', NULL),
 (3008, 0, '213.55.184.145', 'Mozilla/5.0 (Android 7.0; Mobile; rv:53.0) Gecko/53.0 Firefox/53.0', 2339, 2340, '', '2017-04-26 20:10:37', 'completed', '', NULL),
 (3009, 0, '213.55.184.145', 'Dalvik/2.1.0 (Linux; U; Android 7.0; HTC One M9 Build/NRD90M)', 2339, 2340, '', '2017-04-26 20:10:51', 'completed', '', NULL),
 (3010, 0, '31.10.157.104', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2146, 2149, '', '2017-04-26 21:09:32', 'completed', '', NULL),
 (3011, 0, '31.10.157.104', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2140, 2141, '', '2017-04-26 21:10:36', 'completed', '', NULL),
 (3012, 0, '213.58.162.61', 'Java/1.6.0_26', 2128, 2367, '', '2017-04-26 23:43:37', 'completed', '', NULL),
 (3013, 0, '213.58.162.61', 'Java/1.6.0_26', 2146, 2149, '', '2017-04-26 23:43:39', 'completed', '', NULL),
 (3014, 0, '213.58.162.61', 'Java/1.6.0_26', 2333, 2334, '', '2017-04-26 23:43:41', 'completed', '', NULL),
 (3015, 0, '213.58.162.61', 'Java/1.6.0_26', 2140, 2141, '', '2017-04-26 23:43:45', 'completed', '', NULL),
 (3016, 0, '213.58.162.61', 'Java/1.6.0_26', 2336, 2337, '', '2017-04-26 23:43:46', 'completed', '', NULL),
 (3017, 0, '213.58.162.61', 'Java/1.6.0_26', 1837, 1839, '', '2017-04-26 23:43:48', 'completed', '', NULL),
 (3018, 0, '213.58.162.61', 'Java/1.6.0_26', 1844, 1845, '', '2017-04-26 23:43:49', 'completed', '', NULL),
 (3019, 0, '213.58.162.61', 'Java/1.6.0_26', 2339, 2340, '', '2017-04-26 23:43:51', 'completed', '', NULL),
 (3020, 0, '213.58.162.61', 'Java/1.6.0_26', 2130, 2133, '', '2017-04-26 23:43:52', 'completed', '', NULL),
 (3021, 0, '213.58.162.61', 'Java/1.6.0_26', 2134, 2307, '', '2017-04-26 23:43:57', 'completed', '', NULL),
 (3022, 0, '213.58.162.61', 'Java/1.6.0_26', 2161, 2162, '', '2017-04-26 23:44:10', 'completed', '', NULL),
 (3023, 0, '213.58.162.61', 'Java/1.6.0_26', 2342, 2349, '', '2017-04-26 23:44:13', 'completed', '', NULL),
 (3024, 0, '51.255.65.17', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-04-27 00:50:54', 'completed', '', NULL),
 (3025, 0, '157.55.39.235', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-04-27 03:09:04', 'completed', '', NULL),
 (3026, 0, '157.55.39.255', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-04-27 05:50:08', 'completed', '', NULL),
 (3027, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-04-27 10:09:48', 'completed', '', NULL),
 (3028, 0, '84.226.44.186', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-04-27 11:08:42', 'completed', '', NULL),
 (3029, 0, '84.226.44.186', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-04-27 11:10:46', 'completed', '', NULL),
 (3030, 0, '85.5.125.248', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2339, 2340, '', '2017-04-27 14:23:35', 'completed', '', NULL),
 (3031, 0, '188.60.199.48', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-04-27 17:13:54', 'completed', '', NULL),
 (3032, 0, '188.60.199.48', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-04-27 17:16:06', 'completed', '', NULL),
 (3033, 0, '188.60.199.48', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-04-27 17:16:51', 'completed', '', NULL),
 (3034, 0, '193.135.75.80', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-04-27 17:33:35', 'completed', '', NULL),
 (3035, 0, '213.142.165.174', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BQB1 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2336, 2337, '', '2017-04-27 18:00:03', 'completed', '', NULL),
 (3036, 0, '213.142.165.174', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BQB1 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2140, 2141, '', '2017-04-27 18:07:47', 'completed', '', NULL),
 (3037, 0, '213.142.165.174', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BQB1 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-04-27 18:09:53', 'completed', '', NULL),
 (3038, 0, '84.226.119.197', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2134, 2307, '', '2017-04-27 19:21:35', 'completed', '', NULL),
 (3039, 0, '84.226.119.197', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2130, 2133, '', '2017-04-27 19:24:13', 'completed', '', NULL),
 (3040, 0, '84.226.119.197', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2134, 2307, '', '2017-04-27 19:29:08', 'completed', '', NULL),
 (3041, 0, '84.226.119.197', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2342, 2349, '', '2017-04-27 19:29:20', 'completed', '', NULL),
 (3042, 0, '178.195.23.183', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-04-27 20:15:45', 'completed', '', NULL),
 (3043, 0, '178.238.175.125', 'Mozilla/5.0 (Android 4.4.2; Tablet; rv:53.0) Gecko/53.0 Firefox/53.0', 2140, 2141, '', '2017-04-27 22:42:27', 'completed', '', NULL),
 (3044, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-28 04:05:16', 'completed', '', NULL),
 (3045, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-28 04:05:20', 'completed', '', NULL),
 (3046, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-28 04:05:21', 'completed', '', NULL),
 (3047, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-28 04:05:28', 'completed', '', NULL),
 (3048, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-28 04:05:32', 'completed', '', NULL),
 (3049, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-28 04:05:35', 'completed', '', NULL),
 (3050, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-28 04:05:37', 'completed', '', NULL),
 (3051, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-28 04:05:39', 'completed', '', NULL),
 (3052, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-28 04:05:47', 'completed', '', NULL),
 (3053, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-28 04:05:52', 'completed', '', NULL),
 (3054, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-28 04:05:56', 'completed', '', NULL),
 (3055, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-28 04:06:02', 'completed', '', NULL),
 (3056, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-04-28 06:04:30', 'completed', '', NULL),
 (3057, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-04-28 06:04:34', 'completed', '', NULL),
 (3058, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-04-28 06:04:40', 'completed', '', NULL),
 (3059, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-04-28 06:05:01', 'completed', '', NULL),
 (3060, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-04-28 06:05:05', 'completed', '', NULL),
 (3061, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-04-28 06:05:12', 'completed', '', NULL),
 (3062, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-04-28 06:05:14', 'completed', '', NULL),
 (3063, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-04-28 06:05:45', 'completed', '', NULL),
 (3064, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-04-28 06:05:49', 'completed', '', NULL),
 (3065, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-04-28 06:06:25', 'completed', '', NULL),
 (3066, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-04-28 06:06:29', 'completed', '', NULL),
 (3067, 0, '104.131.171.126', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-04-28 06:06:35', 'completed', '', NULL),
 (3068, 0, '188.155.178.247', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-04-28 13:47:24', 'completed', '', NULL),
 (3069, 0, '188.155.178.247', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-04-28 13:48:48', 'completed', '', NULL),
 (3070, 0, '31.11.22.162', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-04-28 15:09:50', 'completed', '', NULL),
 (3071, 0, '178.38.129.115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-04-28 19:57:02', 'completed', '', NULL),
 (3072, 0, '178.38.129.115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-04-28 19:58:21', 'completed', '', NULL),
 (3073, 0, '178.38.129.115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2146, 2149, '', '2017-04-28 19:59:17', 'completed', '', NULL),
 (3074, 0, '178.38.129.115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-04-28 20:00:08', 'completed', '', NULL),
 (3075, 0, '178.38.129.115', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-04-28 20:01:38', 'completed', '', NULL),
 (3076, 0, '84.226.119.197', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-J510FN Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2134, 2307, '', '2017-04-28 20:47:32', 'completed', '', NULL),
 (3077, 0, '51.255.65.8', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-04-29 09:59:56', 'completed', '', NULL),
 (3078, 0, '84.72.54.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1837, 1839, '', '2017-04-29 11:27:38', 'completed', '', NULL),
 (3079, 0, '117.241.36.56', 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2146, 2149, '', '2017-04-29 12:15:46', 'completed', '', NULL),
 (3080, 0, '117.241.36.56', 'Mozilla/5.0 (Windows NT 5.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/49.0.2623.112 Safari/537.36', 2342, 2349, '', '2017-04-29 12:16:25', 'completed', '', NULL),
 (3081, 0, '85.5.7.27', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2128, 2367, '', '2017-04-29 15:34:06', 'completed', '', NULL),
 (3082, 0, '157.55.39.89', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-04-29 19:27:56', 'completed', '', NULL),
 (3083, 0, '91.138.79.64', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2339, 2340, '', '2017-04-29 20:08:49', 'completed', '', NULL),
 (3084, 0, '178.238.175.21', 'Mozilla/5.0 (Android 4.4.2; Mobile; rv:50.0) Gecko/50.0 Firefox/50.0', 2140, 2141, '', '2017-04-29 23:19:32', 'completed', '', NULL),
 (3085, 0, '37.139.26.195', 'SafeDNSBot (https://www.safedns.com/searchbot)', 1844, 1845, '', '2017-04-30 10:13:05', 'completed', '', NULL),
 (3086, 0, '37.139.26.195', 'SafeDNSBot (https://www.safedns.com/searchbot)', 2336, 2337, '', '2017-04-30 10:23:55', 'completed', '', NULL),
 (3087, 0, '142.4.200.50', 'Java/1.6.0_04', 2128, 2367, '', '2017-04-30 11:00:59', 'completed', '', NULL),
 (3088, 0, '142.4.200.50', 'Java/1.6.0_04', 2146, 2149, '', '2017-04-30 11:01:01', 'completed', '', NULL),
 (3089, 0, '142.4.200.50', 'Java/1.6.0_04', 2333, 2334, '', '2017-04-30 11:01:02', 'completed', '', NULL),
 (3090, 0, '142.4.200.50', 'Java/1.6.0_04', 2140, 2141, '', '2017-04-30 11:01:06', 'completed', '', NULL),
 (3091, 0, '142.4.200.50', 'Java/1.6.0_04', 2336, 2337, '', '2017-04-30 11:01:08', 'completed', '', NULL),
 (3092, 0, '142.4.200.50', 'Java/1.6.0_04', 1837, 1839, '', '2017-04-30 11:01:09', 'completed', '', NULL),
 (3093, 0, '142.4.200.50', 'Java/1.6.0_04', 1844, 1845, '', '2017-04-30 11:01:11', 'completed', '', NULL),
 (3094, 0, '142.4.200.50', 'Java/1.6.0_04', 2339, 2340, '', '2017-04-30 11:01:12', 'completed', '', NULL),
 (3095, 0, '142.4.200.50', 'Java/1.6.0_04', 2130, 2133, '', '2017-04-30 11:01:14', 'completed', '', NULL),
 (3096, 0, '142.4.200.50', 'Java/1.6.0_04', 2134, 2307, '', '2017-04-30 11:01:16', 'completed', '', NULL),
 (3097, 0, '142.4.200.50', 'Java/1.6.0_04', 2161, 2162, '', '2017-04-30 11:01:18', 'completed', '', NULL),
 (3098, 0, '142.4.200.50', 'Java/1.6.0_04', 2342, 2349, '', '2017-04-30 11:01:20', 'completed', '', NULL),
 (3099, 0, '31.11.22.162', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-04-30 13:03:02', 'completed', '', NULL),
 (3100, 0, '31.11.22.162', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-04-30 13:08:16', 'completed', '', NULL),
 (3101, 0, '178.197.227.162', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2134, 2307, '', '2017-04-30 14:55:16', 'completed', '', NULL),
 (3102, 0, '178.197.227.162', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2130, 2133, '', '2017-04-30 14:55:39', 'completed', '', NULL),
 (3103, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-04-30 21:01:44', 'completed', '', NULL),
 (3104, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-04-30 21:03:54', 'completed', '', NULL),
 (3105, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-04-30 21:06:18', 'completed', '', NULL),
 (3106, 0, '88.39.23.77', 'Java/1.8.0_101', 2128, 2367, '', '2017-05-01 05:33:21', 'completed', '', NULL),
 (3107, 0, '88.39.23.77', 'Java/1.8.0_101', 2146, 2149, '', '2017-05-01 05:33:23', 'completed', '', NULL),
 (3108, 0, '88.39.23.77', 'Java/1.8.0_101', 2333, 2334, '', '2017-05-01 05:33:24', 'completed', '', NULL),
 (3109, 0, '88.39.23.77', 'Java/1.8.0_101', 2140, 2141, '', '2017-05-01 05:33:30', 'completed', '', NULL),
 (3110, 0, '88.39.23.77', 'Java/1.8.0_101', 2336, 2337, '', '2017-05-01 05:33:32', 'completed', '', NULL),
 (3111, 0, '88.39.23.77', 'Java/1.8.0_101', 1837, 1839, '', '2017-05-01 05:33:34', 'completed', '', NULL),
 (3112, 0, '88.39.23.77', 'Java/1.8.0_101', 1844, 1845, '', '2017-05-01 05:33:35', 'completed', '', NULL),
 (3113, 0, '88.39.23.77', 'Java/1.8.0_101', 2339, 2340, '', '2017-05-01 05:33:37', 'completed', '', NULL),
 (3114, 0, '88.39.23.77', 'Java/1.8.0_101', 2130, 2133, '', '2017-05-01 05:33:41', 'completed', '', NULL),
 (3115, 0, '212.225.226.36', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-01 07:48:26', 'completed', '', NULL),
 (3116, 0, '77.239.63.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-01 09:10:12', 'completed', '', NULL),
 (3117, 0, '178.195.228.9', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.81 Safari/537.36', 2128, 2367, '', '2017-05-01 09:37:12', 'completed', '', NULL),
 (3118, 0, '109.70.118.233', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2130, 2133, '', '2017-05-01 10:23:07', 'completed', '', NULL),
 (3119, 0, '178.197.225.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2134, 2307, '', '2017-05-01 14:13:43', 'completed', '', NULL),
 (3120, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-01 14:18:09', 'completed', '', NULL),
 (3121, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-01 14:18:12', 'completed', '', NULL),
 (3122, 0, '83.77.36.221', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-05-01 16:08:50', 'completed', '', NULL),
 (3123, 0, '83.77.36.221', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1837, 1839, '', '2017-05-01 16:22:24', 'completed', '', NULL),
 (3124, 0, '83.78.99.37', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/25.0.152548370 Mobile/14E304 Safari/602.1', 2342, 2349, '', '2017-05-01 17:34:44', 'completed', '', NULL),
 (3125, 0, '83.78.99.37', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/25.0.152548370 Mobile/14E304 Safari/602.1', 2342, 2349, '', '2017-05-01 17:49:12', 'completed', '', NULL),
 (3126, 0, '83.78.99.37', 'Mozilla/5.0 (Linux; Android 7.0; HTC One A9 Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2336, 2337, '', '2017-05-01 17:50:44', 'completed', '', NULL),
 (3127, 0, '94.16.164.2', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-01 18:04:48', 'completed', '', NULL),
 (3128, 0, '94.16.164.2', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-05-01 18:06:10', 'completed', '', NULL),
 (3129, 0, '94.16.164.2', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-05-01 18:08:01', 'completed', '', NULL),
 (3130, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-01 19:47:54', 'completed', '', NULL),
 (3131, 0, '31.24.14.66', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2128, 2367, '', '2017-05-01 19:55:13', 'completed', '', NULL),
 (3132, 0, '31.24.14.66', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2333, 2334, '', '2017-05-01 19:56:06', 'completed', '', NULL),
 (3133, 0, '31.24.14.66', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1844, 1845, '', '2017-05-01 19:56:54', 'completed', '', NULL),
 (3134, 0, '31.24.14.66', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1837, 1839, '', '2017-05-01 19:59:26', 'completed', '', NULL),
 (3135, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-01 20:56:38', 'completed', '', NULL),
 (3136, 0, '62.203.233.69', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2017-05-01 21:08:32', 'completed', '', NULL),
 (3137, 0, '62.203.233.69', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 1844, 1845, '', '2017-05-01 21:09:17', 'completed', '', NULL),
 (3138, 0, '62.203.233.69', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-05-01 21:09:43', 'completed', '', NULL),
 (3139, 0, '207.46.13.163', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-05-02 03:51:48', 'completed', '', NULL),
 (3140, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-02 15:48:55', 'completed', '', NULL),
 (3141, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-02 17:32:05', 'completed', '', NULL),
 (3142, 0, '212.147.7.138', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-02 17:35:41', 'completed', '', NULL),
 (3143, 0, '46.140.80.122', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-05-02 18:36:24', 'completed', '', NULL),
 (3144, 0, '46.140.80.122', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-02 18:38:41', 'completed', '', NULL),
 (3145, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-02 18:45:31', 'completed', '', NULL),
 (3146, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-02 18:45:41', 'completed', '', NULL),
 (3147, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-02 18:45:45', 'completed', '', NULL),
 (3148, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-02 18:45:54', 'completed', '', NULL),
 (3149, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-02 18:46:03', 'completed', '', NULL),
 (3150, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-02 18:46:12', 'completed', '', NULL),
 (3151, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-02 18:46:15', 'completed', '', NULL),
 (3152, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-02 18:46:18', 'completed', '', NULL),
 (3153, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-02 18:46:28', 'completed', '', NULL),
 (3154, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-02 18:46:34', 'completed', '', NULL),
 (3155, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-02 18:46:40', 'completed', '', NULL),
 (3156, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-02 18:46:44', 'completed', '', NULL),
 (3157, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2146, 2149, '', '2017-05-02 20:48:12', 'completed', '', NULL),
 (3158, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2140, 2141, '', '2017-05-02 21:03:09', 'completed', '', NULL),
 (3159, 0, '181.215.244.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-02 21:04:19', 'completed', '', NULL),
 (3160, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2336, 2337, '', '2017-05-02 21:05:56', 'completed', '', NULL),
 (3161, 0, '188.63.90.128', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BQB1 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2128, 2367, '', '2017-05-02 21:44:23', 'completed', '', NULL),
 (3162, 0, '188.63.90.128', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A310F/A310FXXU2BQB1 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2333, 2334, '', '2017-05-02 21:47:04', 'completed', '', NULL),
 (3163, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-02 22:08:15', 'completed', '', NULL),
 (3164, 0, '85.3.226.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2130, 2133, '', '2017-05-02 22:22:59', 'completed', '', NULL),
 (3165, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-02 23:12:38', 'completed', '', NULL),
 (3166, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-02 23:17:03', 'completed', '', NULL),
 (3167, 0, '40.77.167.31', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-05-02 23:26:08', 'completed', '', NULL),
 (3168, 0, '85.5.65.232', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2017-05-02 23:36:02', 'completed', '', NULL),
 (3169, 0, '192.99.79.242', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-03 00:04:42', 'completed', '', NULL),
 (3170, 0, '192.99.79.242', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-03 00:04:55', 'completed', '', NULL),
 (3171, 0, '192.99.79.242', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-03 00:04:57', 'completed', '', NULL),
 (3172, 0, '192.99.79.242', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-03 00:05:10', 'completed', '', NULL),
 (3173, 0, '192.99.79.242', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-03 00:05:15', 'completed', '', NULL),
 (3174, 0, '192.99.79.242', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-03 00:05:32', 'completed', '', NULL),
 (3175, 0, '192.99.79.242', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-03 00:05:41', 'completed', '', NULL),
 (3176, 0, '192.99.79.242', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-03 00:05:46', 'completed', '', NULL),
 (3177, 0, '192.99.79.242', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-03 00:06:00', 'completed', '', NULL),
 (3178, 0, '192.99.79.242', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-03 00:06:22', 'completed', '', NULL),
 (3179, 0, '192.99.79.242', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-03 00:06:34', 'completed', '', NULL),
 (3180, 0, '192.99.79.242', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-03 00:07:00', 'completed', '', NULL),
 (3181, 0, '84.85.74.170', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-03 03:45:33', 'completed', '', NULL),
 (3182, 0, '82.220.75.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-03 08:27:51', 'completed', '', NULL),
 (3183, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-03 09:18:28', 'completed', '', NULL),
 (3184, 0, '84.120.163.180', 'Java/1.8.0_101', 2128, 2367, '', '2017-05-03 10:03:32', 'completed', '', NULL),
 (3185, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-03 14:06:29', 'completed', '', NULL),
 (3186, 0, '217.162.176.69', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', 2140, 2141, '', '2017-05-03 14:08:06', 'completed', '', NULL),
 (3187, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-03 17:46:44', 'completed', '', NULL),
 (3188, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-03 18:06:14', 'completed', '', NULL),
 (3189, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-03 18:14:09', 'completed', '', NULL),
 (3190, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-03 18:14:14', 'completed', '', NULL),
 (3191, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-03 18:14:15', 'completed', '', NULL),
 (3192, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-03 18:14:24', 'completed', '', NULL),
 (3193, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-03 18:14:28', 'completed', '', NULL),
 (3194, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-03 18:14:39', 'completed', '', NULL),
 (3195, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-03 18:14:43', 'completed', '', NULL),
 (3196, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-03 18:14:48', 'completed', '', NULL),
 (3197, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-03 18:14:58', 'completed', '', NULL),
 (3198, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-03 18:15:06', 'completed', '', NULL),
 (3199, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-03 18:15:12', 'completed', '', NULL),
 (3200, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-03 18:15:18', 'completed', '', NULL),
 (3201, 0, '194.230.159.150', 'Mozilla/5.0 (Android 5.0; Mobile; rv:42.0) Gecko/42.0 Firefox/42.0', 2128, 2367, '', '2017-05-03 18:28:54', 'completed', '', NULL),
 (3202, 0, '178.197.227.129', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Klar/3.1 Mobile/14D27', 2333, 2334, '', '2017-05-03 18:55:49', 'completed', '', NULL),
 (3203, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-03 19:36:22', 'completed', '', NULL),
 (3204, 0, '84.127.26.90', 'Java/1.8.0_121', 2128, 2367, '', '2017-05-03 19:55:00', 'completed', '', NULL),
 (3205, 0, '85.2.19.54', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-05-03 20:15:44', 'completed', '', NULL),
 (3206, 0, '85.3.227.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 1844, 1845, '', '2017-05-03 21:21:22', 'completed', '', NULL),
 (3207, 0, '85.3.227.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-05-03 21:21:44', 'completed', '', NULL),
 (3208, 0, '84.85.74.170', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-03 23:25:19', 'completed', '', NULL),
 (3209, 0, '207.46.13.143', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-04 03:20:53', 'completed', '', NULL),
 (3210, 0, '176.127.140.227', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2339, 2340, '', '2017-05-04 08:07:34', 'completed', '', NULL),
 (3211, 0, '178.197.226.154', 'Mozilla/5.0 (Linux; Android 5.1.1; HUAWEI CRR-L09 Build/HUAWEICRR-L09C02B122) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2128, 2367, '', '2017-05-04 08:51:24', 'completed', '', NULL),
 (3212, 0, '178.197.226.154', 'Mozilla/5.0 (Linux; Android 5.1.1; HUAWEI CRR-L09 Build/HUAWEICRR-L09C02B122) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2333, 2334, '', '2017-05-04 08:53:05', 'completed', '', NULL),
 (3213, 0, '178.197.226.154', 'Mozilla/5.0 (Linux; Android 5.1.1; HUAWEI CRR-L09 Build/HUAWEICRR-L09C02B122) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 1844, 1845, '', '2017-05-04 08:58:41', 'completed', '', NULL),
 (3214, 0, '178.197.226.154', 'Mozilla/5.0 (Linux; Android 5.1.1; HUAWEI CRR-L09 Build/HUAWEICRR-L09C02B122) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 1837, 1839, '', '2017-05-04 08:58:52', 'completed', '', NULL),
 (3215, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-04 09:22:28', 'completed', '', NULL),
 (3216, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-04 09:23:00', 'completed', '', NULL),
 (3217, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-04 09:24:44', 'completed', '', NULL),
 (3218, 0, '178.197.227.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-04 09:50:33', 'completed', '', NULL),
 (3219, 0, '85.6.135.195', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2333, 2334, '', '2017-05-04 10:01:21', 'completed', '', NULL),
 (3220, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-05-04 10:02:44', 'completed', '', NULL),
 (3221, 0, '5.104.94.100', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-05-04 10:02:45', 'completed', '', NULL),
 (3222, 0, '85.6.135.195', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2128, 2367, '', '2017-05-04 10:05:03', 'completed', '', NULL),
 (3223, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-05-04 10:07:02', 'completed', '', NULL),
 (3224, 0, '5.104.94.100', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-05-04 10:07:03', 'completed', '', NULL),
 (3225, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-04 10:07:56', 'completed', '', NULL),
 (3226, 0, '5.104.94.100', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-04 10:07:57', 'completed', '', NULL),
 (3227, 0, '85.6.135.195', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 1837, 1839, '', '2017-05-04 10:26:36', 'completed', '', NULL),
 (3228, 0, '62.195.2.147', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-04 11:34:10', 'completed', '', NULL),
 (3229, 0, '62.195.2.147', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-04 11:34:11', 'completed', '', NULL),
 (3230, 0, '62.195.2.147', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-04 11:34:12', 'completed', '', NULL),
 (3231, 0, '62.195.2.147', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-04 11:34:15', 'completed', '', NULL),
 (3232, 0, '62.195.2.147', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-04 11:34:16', 'completed', '', NULL),
 (3233, 0, '62.195.2.147', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-04 11:34:18', 'completed', '', NULL),
 (3234, 0, '62.195.2.147', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-04 11:34:19', 'completed', '', NULL),
 (3235, 0, '62.195.2.147', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-04 11:34:21', 'completed', '', NULL),
 (3236, 0, '62.195.2.147', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-04 11:34:22', 'completed', '', NULL),
 (3237, 0, '62.195.2.147', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-04 11:34:24', 'completed', '', NULL),
 (3238, 0, '62.195.2.147', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-04 11:34:26', 'completed', '', NULL),
 (3239, 0, '62.195.2.147', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-04 11:34:27', 'completed', '', NULL),
 (3240, 0, '157.55.39.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-04 18:25:58', 'completed', '', NULL),
 (3241, 0, '157.55.39.99', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-04 21:18:59', 'completed', '', NULL),
 (3242, 0, '157.55.39.99', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-04 22:10:05', 'completed', '', NULL),
 (3243, 0, '37.48.119.245', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-04 23:00:44', 'completed', '', NULL),
 (3244, 0, '37.48.119.245', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-04 23:00:46', 'completed', '', NULL),
 (3245, 0, '37.48.119.245', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-04 23:00:48', 'completed', '', NULL),
 (3246, 0, '37.48.119.245', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-04 23:00:59', 'completed', '', NULL),
 (3247, 0, '37.48.119.245', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-04 23:01:05', 'completed', '', NULL),
 (3248, 0, '37.48.119.245', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-04 23:01:11', 'completed', '', NULL),
 (3249, 0, '37.48.119.245', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-04 23:01:13', 'completed', '', NULL),
 (3250, 0, '37.48.119.245', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-04 23:01:15', 'completed', '', NULL),
 (3251, 0, '37.48.119.245', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-04 23:01:21', 'completed', '', NULL),
 (3252, 0, '37.48.119.245', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-04 23:01:29', 'completed', '', NULL),
 (3253, 0, '37.48.119.245', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-04 23:01:34', 'completed', '', NULL),
 (3254, 0, '37.48.119.245', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-04 23:01:39', 'completed', '', NULL),
 (3255, 0, '164.132.161.16', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-05-05 02:50:03', 'completed', '', NULL),
 (3256, 0, '201.219.233.1', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2140, 2141, '', '2017-05-05 03:55:48', 'completed', '', NULL),
 (3257, 0, '201.219.233.1', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-05 03:56:08', 'completed', '', NULL),
 (3258, 0, '157.55.39.41', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-05 05:28:16', 'completed', '', NULL),
 (3259, 0, '80.255.97.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 1844, 1845, '', '2017-05-05 14:35:54', 'completed', '', NULL),
 (3260, 0, '80.255.97.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 1837, 1839, '', '2017-05-05 14:36:27', 'completed', '', NULL),
 (3261, 0, '80.255.97.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2339, 2340, '', '2017-05-05 14:36:43', 'completed', '', NULL),
 (3262, 0, '80.255.97.36', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2140, 2141, '', '2017-05-05 14:37:46', 'completed', '', NULL),
 (3263, 0, '178.238.175.15', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-05-05 14:55:15', 'completed', '', NULL),
 (3264, 0, '178.238.175.15', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-05-05 15:41:32', 'completed', '', NULL),
 (3265, 0, '77.224.114.142', 'Java/1.8.0_45', 2128, 2367, '', '2017-05-05 17:52:36', 'completed', '', NULL),
 (3266, 0, '157.55.39.54', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-05 18:09:54', 'completed', '', NULL),
 (3267, 0, '157.55.39.41', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-05 18:21:27', 'completed', '', NULL),
 (3268, 0, '62.202.181.235', 'Mozilla/5.0 (Linux; Android 4.4.2; de-ch; SAMSUNG SM-T230 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/1.5 Chrome/28.0.1500.94 Safari/537.36', 2146, 2149, '', '2017-05-05 18:41:45', 'completed', '', NULL),
 (3269, 0, '157.55.2.131', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-05 19:11:13', 'completed', '', NULL),
 (3270, 0, '178.194.91.37', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-05-05 20:29:52', 'completed', '', NULL),
 (3271, 0, '85.6.135.195', 'Mozilla/5.0 (Linux; Android 5.1.1; HUAWEI CRR-L09 Build/HUAWEICRR-L09C02B122) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 1837, 1839, '', '2017-05-05 21:57:48', 'completed', '', NULL),
 (3272, 0, '213.112.106.20', 'Java/1.8.0_121', 2128, 2367, '', '2017-05-06 00:11:38', 'completed', '', NULL),
 (3273, 0, '157.55.39.41', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-06 01:56:23', 'completed', '', NULL),
 (3274, 0, '164.132.161.79', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-05-06 02:35:48', 'completed', '', NULL),
 (3275, 0, '188.127.172.169', 'Java/1.8.0_66', 2128, 2367, '', '2017-05-06 03:09:58', 'completed', '', NULL),
 (3276, 0, '157.55.39.41', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-06 05:32:44', 'completed', '', NULL),
 (3277, 0, '84.75.250.10', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2339, 2340, '', '2017-05-06 11:01:58', 'completed', '', NULL),
 (3278, 0, '157.55.39.54', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-06 11:48:02', 'completed', '', NULL),
 (3279, 0, '157.55.39.41', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-06 20:08:08', 'completed', '', NULL),
 (3280, 0, '157.55.39.41', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-07 05:43:30', 'completed', '', NULL),
 (3281, 0, '178.197.228.224', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_4_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H321 Safari/600.1.4', 2342, 2349, '', '2017-05-07 08:39:57', 'completed', '', NULL),
 (3282, 0, '195.154.47.79', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-07 12:43:38', 'completed', '', NULL),
 (3283, 0, '195.154.47.79', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-07 12:43:39', 'completed', '', NULL),
 (3284, 0, '195.154.47.79', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-07 12:43:40', 'completed', '', NULL),
 (3285, 0, '195.154.47.79', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-07 12:43:45', 'completed', '', NULL),
 (3286, 0, '195.154.47.79', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-07 12:43:47', 'completed', '', NULL),
 (3287, 0, '195.154.47.79', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-07 12:43:49', 'completed', '', NULL),
 (3288, 0, '195.154.47.79', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-07 12:43:51', 'completed', '', NULL),
 (3289, 0, '195.154.47.79', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-07 12:43:52', 'completed', '', NULL),
 (3290, 0, '195.154.47.79', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-07 12:43:54', 'completed', '', NULL),
 (3291, 0, '195.154.47.79', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-07 12:43:57', 'completed', '', NULL),
 (3292, 0, '195.154.47.79', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-07 12:43:59', 'completed', '', NULL),
 (3293, 0, '195.154.47.79', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-07 12:44:02', 'completed', '', NULL),
 (3294, 0, '62.138.14.180', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2339, 2340, '', '2017-05-07 14:56:23', 'completed', '', NULL),
 (3295, 0, '62.138.14.180', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 1844, 1845, '', '2017-05-07 14:56:28', 'completed', '', NULL),
 (3296, 0, '62.138.14.180', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 1837, 1839, '', '2017-05-07 14:56:30', 'completed', '', NULL),
 (3297, 0, '62.138.14.180', 'Linguee Bot (http://www.linguee.com/bot; bot@linguee.com)', 2146, 2149, '', '2017-05-07 14:56:32', 'completed', '', NULL),
 (3298, 0, '192.99.79.243', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-07 16:33:01', 'completed', '', NULL),
 (3299, 0, '192.99.79.243', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-07 16:33:07', 'completed', '', NULL),
 (3300, 0, '192.99.79.243', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-07 16:33:09', 'completed', '', NULL),
 (3301, 0, '192.99.79.243', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-07 16:33:22', 'completed', '', NULL),
 (3302, 0, '192.99.79.243', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-07 16:33:26', 'completed', '', NULL),
 (3303, 0, '192.99.79.243', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-07 16:33:34', 'completed', '', NULL),
 (3304, 0, '192.99.79.243', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-07 16:33:37', 'completed', '', NULL),
 (3305, 0, '192.99.79.243', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-07 16:33:41', 'completed', '', NULL),
 (3306, 0, '192.99.79.243', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-07 16:33:52', 'completed', '', NULL),
 (3307, 0, '192.99.79.243', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-07 16:34:04', 'completed', '', NULL),
 (3308, 0, '192.99.79.243', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-07 16:34:11', 'completed', '', NULL),
 (3309, 0, '192.99.79.243', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-07 16:34:17', 'completed', '', NULL),
 (3310, 0, '46.140.0.123', 'Mozilla/5.0 (Linux; Android 7.1.2; Nexus 5X Build/N2G47F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2134, 2307, '', '2017-05-07 21:03:36', 'completed', '', NULL),
 (3311, 0, '46.140.0.123', 'Mozilla/5.0 (Linux; Android 7.1.2; Nexus 5X Build/N2G47F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2130, 2133, '', '2017-05-07 21:04:14', 'completed', '', NULL),
 (3312, 0, '46.140.0.123', 'Mozilla/5.0 (Linux; Android 7.1.2; Nexus 5X Build/N2G47F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2342, 2349, '', '2017-05-07 21:05:00', 'completed', '', NULL),
 (3313, 0, '195.154.47.79', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-08 01:42:37', 'completed', '', NULL),
 (3314, 0, '195.154.47.79', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-08 01:42:38', 'completed', '', NULL),
 (3315, 0, '195.154.47.79', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-08 01:42:40', 'completed', '', NULL),
 (3316, 0, '195.154.47.79', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-08 01:42:43', 'completed', '', NULL),
 (3317, 0, '195.154.47.79', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-08 01:42:46', 'completed', '', NULL),
 (3318, 0, '195.154.47.79', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-08 01:42:49', 'completed', '', NULL),
 (3319, 0, '195.154.47.79', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-08 01:42:51', 'completed', '', NULL),
 (3320, 0, '195.154.47.79', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-08 01:42:53', 'completed', '', NULL),
 (3321, 0, '195.154.47.79', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-08 01:42:55', 'completed', '', NULL),
 (3322, 0, '195.154.47.79', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-08 01:42:57', 'completed', '', NULL),
 (3323, 0, '195.154.47.79', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-08 01:42:59', 'completed', '', NULL),
 (3324, 0, '195.154.47.79', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-08 01:43:02', 'completed', '', NULL),
 (3325, 0, '207.46.13.73', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-08 02:04:02', 'completed', '', NULL),
 (3326, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-05-08 03:04:32', 'completed', '', NULL),
 (3327, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-05-08 03:04:37', 'completed', '', NULL),
 (3328, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-05-08 03:04:42', 'completed', '', NULL),
 (3329, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-05-08 03:04:57', 'completed', '', NULL),
 (3330, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-05-08 03:05:04', 'completed', '', NULL),
 (3331, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-05-08 03:05:08', 'completed', '', NULL),
 (3332, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-05-08 03:05:13', 'completed', '', NULL),
 (3333, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-05-08 03:05:48', 'completed', '', NULL),
 (3334, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-05-08 03:05:53', 'completed', '', NULL),
 (3335, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-05-08 03:06:22', 'completed', '', NULL),
 (3336, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-05-08 03:06:28', 'completed', '', NULL),
 (3337, 0, '104.236.126.178', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-05-08 03:06:32', 'completed', '', NULL),
 (3338, 0, '207.46.13.73', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-08 03:07:58', 'completed', '', NULL),
 (3339, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-05-08 07:05:22', 'completed', '', NULL),
 (3340, 0, '207.46.13.164', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-08 09:12:14', 'completed', '', NULL),
 (3341, 0, '188.63.89.87', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2342, 2349, '', '2017-05-08 12:17:37', 'completed', '', NULL),
 (3342, 0, '46.235.158.196', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-08 13:03:23', 'completed', '', NULL),
 (3343, 0, '194.209.146.71', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-08 13:03:24', 'completed', '', NULL),
 (3344, 0, '178.197.227.216', 'Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2134, 2307, '', '2017-05-08 14:12:29', 'completed', '', NULL),
 (3345, 0, '178.197.227.216', 'Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2342, 2349, '', '2017-05-08 14:14:09', 'completed', '', NULL),
 (3346, 0, '178.197.227.216', 'Mozilla/5.0 (Linux; Android 5.0.2; SM-A300F Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2130, 2133, '', '2017-05-08 14:14:20', 'completed', '', NULL),
 (3347, 0, '207.46.13.164', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-05-08 18:57:10', 'completed', '', NULL),
 (3348, 0, '62.202.188.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2134, 2307, '', '2017-05-08 20:31:38', 'completed', '', NULL),
 (3349, 0, '62.202.188.192', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2130, 2133, '', '2017-05-08 20:32:21', 'completed', '', NULL),
 (3350, 0, '77.59.144.73', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-05-09 00:36:50', 'completed', '', NULL),
 (3351, 0, '192.99.79.242', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-09 00:58:44', 'completed', '', NULL),
 (3352, 0, '192.99.79.242', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-09 00:58:51', 'completed', '', NULL),
 (3353, 0, '192.99.79.242', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-09 00:58:53', 'completed', '', NULL),
 (3354, 0, '192.99.79.242', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-09 00:59:09', 'completed', '', NULL),
 (3355, 0, '192.99.79.242', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-09 00:59:12', 'completed', '', NULL),
 (3356, 0, '192.99.79.242', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-09 00:59:25', 'completed', '', NULL),
 (3357, 0, '192.99.79.242', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-09 00:59:28', 'completed', '', NULL),
 (3358, 0, '192.99.79.242', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-09 00:59:33', 'completed', '', NULL),
 (3359, 0, '192.99.79.242', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-09 00:59:46', 'completed', '', NULL),
 (3360, 0, '192.99.79.242', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-09 01:00:05', 'completed', '', NULL),
 (3361, 0, '192.99.79.242', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-09 01:00:16', 'completed', '', NULL),
 (3362, 0, '192.99.79.242', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-09 01:00:27', 'completed', '', NULL),
 (3363, 0, '195.154.47.79', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-09 04:19:31', 'completed', '', NULL),
 (3364, 0, '195.154.47.79', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-09 04:19:33', 'completed', '', NULL),
 (3365, 0, '195.154.47.79', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-09 04:19:34', 'completed', '', NULL),
 (3366, 0, '195.154.47.79', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-09 04:19:40', 'completed', '', NULL),
 (3367, 0, '195.154.47.79', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-09 04:19:44', 'completed', '', NULL),
 (3368, 0, '195.154.47.79', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-09 04:19:47', 'completed', '', NULL),
 (3369, 0, '195.154.47.79', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-09 04:19:49', 'completed', '', NULL),
 (3370, 0, '195.154.47.79', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-09 04:19:52', 'completed', '', NULL),
 (3371, 0, '195.154.47.79', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-09 04:20:00', 'completed', '', NULL),
 (3372, 0, '195.154.47.79', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-09 04:20:02', 'completed', '', NULL),
 (3373, 0, '195.154.47.79', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-09 04:20:07', 'completed', '', NULL),
 (3374, 0, '195.154.47.79', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-09 04:20:11', 'completed', '', NULL),
 (3375, 0, '195.154.47.79', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-09 04:35:16', 'completed', '', NULL),
 (3376, 0, '195.154.47.79', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-09 04:35:17', 'completed', '', NULL),
 (3377, 0, '195.154.47.79', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-09 04:35:18', 'completed', '', NULL),
 (3378, 0, '195.154.47.79', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-09 04:35:21', 'completed', '', NULL),
 (3379, 0, '195.154.47.79', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-09 04:35:23', 'completed', '', NULL),
 (3380, 0, '195.154.47.79', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-09 04:35:24', 'completed', '', NULL),
 (3381, 0, '195.154.47.79', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-09 04:35:25', 'completed', '', NULL),
 (3382, 0, '195.154.47.79', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-09 04:35:26', 'completed', '', NULL),
 (3383, 0, '195.154.47.79', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-09 04:35:28', 'completed', '', NULL),
 (3384, 0, '195.154.47.79', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-09 04:35:29', 'completed', '', NULL),
 (3385, 0, '195.154.47.79', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-09 04:35:31', 'completed', '', NULL),
 (3386, 0, '195.154.47.79', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-09 04:35:33', 'completed', '', NULL),
 (3387, 0, '84.72.110.60', 'Mozilla/5.0 (Windows NT 6.2; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 1844, 1845, '', '2017-05-09 11:28:44', 'completed', '', NULL),
 (3388, 0, '46.14.129.35', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-05-09 16:16:57', 'completed', '', NULL),
 (3389, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-05-09 18:38:45', 'completed', '', NULL),
 (3390, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-05-09 18:49:47', 'completed', '', NULL),
 (3391, 0, '178.195.40.104', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/19.0.133715217 Mobile/14D27 Safari/600.1.4', 2130, 2133, '', '2017-05-09 19:31:23', 'completed', '', NULL),
 (3392, 0, '178.195.40.104', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/19.0.133715217 Mobile/14D27 Safari/600.1.4', 2130, 2133, '', '2017-05-09 19:37:01', 'completed', '', NULL),
 (3393, 0, '85.0.207.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/26.0.154727556 Mobile/14E304 Safari/602.1', 2130, 2133, '', '2017-05-09 20:47:28', 'completed', '', NULL),
 (3394, 0, '85.0.207.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/26.0.154727556 Mobile/14E304 Safari/602.1', 2134, 2307, '', '2017-05-09 20:47:41', 'completed', '', NULL),
 (3395, 0, '40.77.167.102', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-09 23:33:55', 'completed', '', NULL),
 (3396, 0, '178.197.232.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-05-10 06:29:30', 'completed', '', NULL),
 (3397, 0, '40.77.167.102', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-10 06:49:51', 'completed', '', NULL),
 (3398, 0, '178.196.181.195', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2342, 2349, '', '2017-05-10 07:24:19', 'completed', '', NULL),
 (3399, 0, '178.196.181.195', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2342, 2349, '', '2017-05-10 07:32:24', 'completed', '', NULL),
 (3400, 0, '178.196.181.195', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2134, 2307, '', '2017-05-10 07:33:04', 'completed', '', NULL),
 (3401, 0, '89.217.233.218', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-05-10 09:10:00', 'completed', '', NULL),
 (3402, 0, '213.3.15.207', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-05-10 11:52:46', 'completed', '', NULL),
 (3403, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-10 13:24:49', 'completed', '', NULL),
 (3404, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-10 13:25:39', 'completed', '', NULL),
 (3405, 0, '87.102.132.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2128, 2367, '', '2017-05-10 13:34:28', 'completed', '', NULL),
 (3406, 0, '87.102.132.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2333, 2334, '', '2017-05-10 13:35:40', 'completed', '', NULL),
 (3407, 0, '87.102.132.194', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2146, 2149, '', '2017-05-10 13:42:25', 'completed', '', NULL),
 (3408, 0, '89.186.215.129', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-05-10 15:29:10', 'completed', '', NULL),
 (3409, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-10 15:59:56', 'completed', '', NULL),
 (3410, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-05-10 16:01:51', 'completed', '', NULL),
 (3411, 0, '207.46.13.164', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-10 19:11:07', 'completed', '', NULL),
 (3412, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1837, 1839, '', '2017-05-10 19:16:38', 'completed', '', NULL),
 (3413, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1844, 1845, '', '2017-05-10 19:16:48', 'completed', '', NULL),
 (3414, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2339, 2340, '', '2017-05-10 19:16:59', 'completed', '', NULL),
 (3415, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2130, 2133, '', '2017-05-10 19:28:06', 'completed', '', NULL),
 (3416, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2134, 2307, '', '2017-05-10 19:28:17', 'completed', '', NULL),
 (3417, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2161, 2162, '', '2017-05-10 19:28:29', 'completed', '', NULL),
 (3418, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2342, 2349, '', '2017-05-10 19:28:41', 'completed', '', NULL),
 (3419, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2140, 2141, '', '2017-05-10 19:29:21', 'completed', '', NULL),
 (3420, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2336, 2337, '', '2017-05-10 19:29:31', 'completed', '', NULL),
 (3421, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2128, 2367, '', '2017-05-10 19:32:55', 'completed', '', NULL),
 (3422, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2333, 2334, '', '2017-05-10 19:33:07', 'completed', '', NULL),
 (3423, 0, '212.129.53.68', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-11 08:17:40', 'completed', '', NULL),
 (3424, 0, '212.129.53.68', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-11 08:17:42', 'completed', '', NULL),
 (3425, 0, '212.129.53.68', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-11 08:17:43', 'completed', '', NULL),
 (3426, 0, '212.129.53.68', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-11 08:17:45', 'completed', '', NULL),
 (3427, 0, '212.129.53.68', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-11 08:17:46', 'completed', '', NULL),
 (3428, 0, '212.129.53.68', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-11 08:17:48', 'completed', '', NULL),
 (3429, 0, '212.129.53.68', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-11 08:17:49', 'completed', '', NULL),
 (3430, 0, '212.129.53.68', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-11 08:17:50', 'completed', '', NULL),
 (3431, 0, '212.129.53.68', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-11 08:17:51', 'completed', '', NULL),
 (3432, 0, '212.129.53.68', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-11 08:17:52', 'completed', '', NULL),
 (3433, 0, '212.129.53.68', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-11 08:17:53', 'completed', '', NULL),
 (3434, 0, '212.129.53.68', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-11 08:17:55', 'completed', '', NULL),
 (3435, 21, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-11 10:55:40', 'completed', '', NULL),
 (3436, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-11 10:56:49', 'completed', '', NULL),
 (3437, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-11 10:57:35', 'completed', '', NULL),
 (3438, 0, '40.77.167.102', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-11 11:03:24', 'completed', '', NULL),
 (3439, 0, '94.209.237.27', 'Java/1.8.0_121', 2128, 2367, '', '2017-05-11 11:21:22', 'completed', '', NULL),
 (3440, 0, '185.33.144.112', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-11 12:07:52', 'completed', '', NULL),
 (3441, 0, '80.219.214.194', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-05-11 14:20:33', 'completed', '', NULL),
 (3442, 0, '85.3.201.135', 'Mozilla/5.0 (Linux; Android 5.0.1; SAMSUNG GT-I9505 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2128, 2367, '', '2017-05-11 16:40:26', 'completed', '', NULL),
 (3443, 0, '85.4.99.34', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2339, 2340, '', '2017-05-11 18:45:33', 'completed', '', NULL),
 (3444, 0, '188.63.145.198', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2134, 2307, '', '2017-05-11 19:29:42', 'completed', '', NULL),
 (3445, 0, '188.63.145.198', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2342, 2349, '', '2017-05-11 19:31:13', 'completed', '', NULL),
 (3446, 0, '188.63.145.198', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2342, 2349, '', '2017-05-11 19:38:39', 'completed', '', NULL),
 (3447, 0, '212.129.53.68', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-11 19:58:22', 'completed', '', NULL),
 (3448, 0, '212.129.53.68', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-11 19:58:24', 'completed', '', NULL),
 (3449, 0, '212.129.53.68', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-11 19:58:25', 'completed', '', NULL),
 (3450, 0, '212.129.53.68', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-11 19:58:27', 'completed', '', NULL),
 (3451, 0, '212.129.53.68', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-11 19:58:29', 'completed', '', NULL),
 (3452, 0, '212.129.53.68', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-11 19:58:30', 'completed', '', NULL),
 (3453, 0, '212.129.53.68', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-11 19:58:31', 'completed', '', NULL),
 (3454, 0, '212.129.53.68', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-11 19:58:32', 'completed', '', NULL),
 (3455, 0, '212.129.53.68', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-11 19:58:34', 'completed', '', NULL),
 (3456, 0, '212.129.53.68', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-11 19:58:36', 'completed', '', NULL),
 (3457, 0, '212.129.53.68', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-11 19:58:37', 'completed', '', NULL),
 (3458, 0, '212.129.53.68', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-11 19:58:39', 'completed', '', NULL),
 (3459, 0, '212.129.53.68', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-11 20:52:10', 'completed', '', NULL),
 (3460, 0, '212.129.53.68', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-11 20:52:11', 'completed', '', NULL),
 (3461, 0, '212.129.53.68', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-11 20:52:12', 'completed', '', NULL),
 (3462, 0, '212.129.53.68', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-11 20:52:15', 'completed', '', NULL),
 (3463, 0, '212.129.53.68', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-11 20:52:16', 'completed', '', NULL),
 (3464, 0, '212.129.53.68', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-11 20:52:18', 'completed', '', NULL),
 (3465, 0, '212.129.53.68', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-11 20:52:19', 'completed', '', NULL),
 (3466, 0, '212.129.53.68', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-11 20:52:20', 'completed', '', NULL),
 (3467, 0, '212.129.53.68', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-11 20:52:22', 'completed', '', NULL),
 (3468, 0, '212.129.53.68', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-11 20:52:23', 'completed', '', NULL),
 (3469, 0, '212.129.53.68', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-11 20:52:25', 'completed', '', NULL),
 (3470, 0, '212.129.53.68', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-11 20:52:27', 'completed', '', NULL),
 (3471, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-12 00:49:14', 'completed', '', NULL),
 (3472, 0, '192.99.79.240', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-12 04:20:01', 'completed', '', NULL),
 (3473, 0, '192.99.79.240', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-12 04:20:06', 'completed', '', NULL),
 (3474, 0, '192.99.79.240', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-12 04:20:11', 'completed', '', NULL),
 (3475, 0, '192.99.79.240', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-12 04:20:22', 'completed', '', NULL),
 (3476, 0, '192.99.79.240', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-12 04:20:25', 'completed', '', NULL),
 (3477, 0, '192.99.79.240', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-12 04:20:33', 'completed', '', NULL),
 (3478, 0, '192.99.79.240', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-12 04:20:36', 'completed', '', NULL),
 (3479, 0, '192.99.79.240', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-12 04:20:40', 'completed', '', NULL),
 (3480, 0, '192.99.79.240', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-12 04:20:50', 'completed', '', NULL),
 (3481, 0, '192.99.79.240', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-12 04:20:57', 'completed', '', NULL),
 (3482, 0, '192.99.79.240', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-12 04:21:03', 'completed', '', NULL),
 (3483, 0, '192.99.79.240', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-12 04:21:12', 'completed', '', NULL),
 (3484, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2128, 2367, '', '2017-05-12 07:23:52', 'completed', '', NULL),
 (3485, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-05-12 08:38:23', 'completed', '', NULL),
 (3486, 0, '83.173.223.202', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', 2342, 2349, '', '2017-05-12 09:52:56', 'completed', '', NULL),
 (3487, 0, '83.173.223.202', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', 2134, 2307, '', '2017-05-12 09:53:08', 'completed', '', NULL),
 (3488, 0, '83.173.223.202', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', 2130, 2133, '', '2017-05-12 09:53:24', 'completed', '', NULL),
 (3489, 0, '85.7.167.164', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-05-12 11:28:09', 'completed', '', NULL),
 (3490, 0, '178.197.238.152', 'Mozilla/5.0 (Linux; U; Android 4.3; de-ch; GT-I9300 Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', 2134, 2307, '', '2017-05-12 15:30:03', 'completed', '', NULL),
 (3491, 0, '178.197.228.254', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A320FL/A320FLXXU1AQA8 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.2 Chrome/44.0.2403.133 Mobile Safari/537.36', 2134, 2307, '', '2017-05-12 15:30:45', 'completed', '', NULL),
 (3492, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12D508 Safari/600.1.4', 2134, 2307, '', '2017-05-12 15:31:34', 'completed', '', NULL),
 (3493, 0, '178.197.225.216', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_2 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12D508 Safari/600.1.4', 2134, 2307, '', '2017-05-12 15:52:39', 'completed', '', NULL),
 (3494, 0, '192.99.79.240', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-12 20:27:32', 'completed', '', NULL),
 (3495, 0, '192.99.79.240', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-12 20:27:37', 'completed', '', NULL),
 (3496, 0, '192.99.79.240', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-12 20:27:40', 'completed', '', NULL),
 (3497, 0, '192.99.79.240', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-12 20:27:48', 'completed', '', NULL),
 (3498, 0, '192.99.79.240', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-12 20:27:54', 'completed', '', NULL),
 (3499, 0, '192.99.79.240', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-12 20:28:00', 'completed', '', NULL),
 (3500, 0, '192.99.79.240', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-12 20:28:06', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(3501, 0, '192.99.79.240', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-12 20:28:10', 'completed', '', NULL),
 (3502, 0, '192.99.79.240', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-12 20:28:22', 'completed', '', NULL),
 (3503, 0, '192.99.79.240', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-12 20:28:29', 'completed', '', NULL),
 (3504, 0, '192.99.79.240', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-12 20:28:44', 'completed', '', NULL),
 (3505, 0, '192.99.79.240', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-12 20:28:56', 'completed', '', NULL),
 (3506, 0, '157.55.39.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-13 04:19:36', 'completed', '', NULL),
 (3507, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-13 04:41:23', 'completed', '', NULL),
 (3508, 0, '68.180.230.184', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-05-13 06:25:10', 'completed', '', NULL),
 (3509, 0, '65.55.210.80', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-13 06:28:32', 'completed', '', NULL),
 (3510, 0, '192.99.79.240', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-13 06:30:09', 'completed', '', NULL),
 (3511, 0, '192.99.79.240', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-13 06:30:18', 'completed', '', NULL),
 (3512, 0, '192.99.79.240', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-13 06:30:21', 'completed', '', NULL),
 (3513, 0, '192.99.79.240', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-13 06:30:28', 'completed', '', NULL),
 (3514, 0, '192.99.79.240', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-13 06:30:37', 'completed', '', NULL),
 (3515, 0, '192.99.79.240', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-13 06:30:48', 'completed', '', NULL),
 (3516, 0, '192.99.79.240', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-13 06:30:55', 'completed', '', NULL),
 (3517, 0, '192.99.79.240', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-13 06:30:59', 'completed', '', NULL),
 (3518, 0, '192.99.79.240', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-13 06:31:12', 'completed', '', NULL),
 (3519, 0, '192.99.79.240', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-13 06:31:25', 'completed', '', NULL),
 (3520, 0, '192.99.79.240', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-13 06:31:39', 'completed', '', NULL),
 (3521, 0, '192.99.79.240', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-13 06:31:50', 'completed', '', NULL),
 (3522, 0, '85.148.42.242', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-13 10:35:08', 'completed', '', NULL),
 (3523, 0, '213.200.225.144', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2146, 2149, '', '2017-05-13 11:34:58', 'completed', '', NULL),
 (3524, 0, '213.200.225.144', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2336, 2337, '', '2017-05-13 11:35:26', 'completed', '', NULL),
 (3525, 0, '40.77.167.131', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-13 15:57:37', 'completed', '', NULL),
 (3526, 0, '213.55.176.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2342, 2349, '', '2017-05-13 17:42:47', 'completed', '', NULL),
 (3527, 0, '62.12.234.66', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-13 17:50:22', 'completed', '', NULL),
 (3528, 0, '213.55.176.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-05-13 17:58:14', 'completed', '', NULL),
 (3529, 0, '213.55.176.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2134, 2307, '', '2017-05-13 17:58:47', 'completed', '', NULL),
 (3530, 0, '213.55.176.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-05-13 18:03:50', 'completed', '', NULL),
 (3531, 0, '213.55.176.160', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-05-13 18:05:50', 'completed', '', NULL),
 (3532, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-13 19:25:54', 'completed', '', NULL),
 (3533, 0, '157.55.39.205', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-05-13 20:11:01', 'completed', '', NULL),
 (3534, 0, '88.84.22.202', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2130, 2133, '', '2017-05-13 21:23:09', 'completed', '', NULL),
 (3535, 0, '157.55.39.205', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-05-14 07:12:06', 'completed', '', NULL),
 (3536, 0, '207.46.13.65', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-05-14 12:13:28', 'completed', '', NULL),
 (3537, 0, '157.55.39.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-14 18:02:07', 'completed', '', NULL),
 (3538, 0, '131.253.25.183', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-14 19:03:47', 'completed', '', NULL),
 (3539, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2161, 2162, '', '2017-05-14 19:21:14', 'completed', '', NULL),
 (3540, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2342, 2349, '', '2017-05-14 19:21:47', 'completed', '', NULL),
 (3541, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2134, 2307, '', '2017-05-14 19:21:58', 'completed', '', NULL),
 (3542, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-14 19:23:13', 'completed', '', NULL),
 (3543, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-14 19:24:41', 'completed', '', NULL),
 (3544, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2342, 2349, '', '2017-05-14 19:25:15', 'completed', '', NULL),
 (3545, 0, '188.62.200.172', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2342, 2349, '', '2017-05-14 19:25:41', 'completed', '', NULL),
 (3546, 0, '51.255.65.73', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2130, 2133, '', '2017-05-15 02:27:01', 'completed', '', NULL),
 (3547, 0, '40.77.167.131', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-15 07:33:49', 'completed', '', NULL),
 (3548, 0, '85.0.0.112', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-05-15 08:10:01', 'completed', '', NULL),
 (3549, 0, '85.0.0.112', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-05-15 08:12:13', 'completed', '', NULL),
 (3550, 0, '85.0.0.112', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 1844, 1845, '', '2017-05-15 08:24:00', 'completed', '', NULL),
 (3551, 0, '85.0.0.112', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-05-15 08:26:14', 'completed', '', NULL),
 (3552, 0, '85.0.0.112', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-05-15 08:26:28', 'completed', '', NULL),
 (3553, 0, '193.246.80.28', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-05-15 11:37:15', 'completed', '', NULL),
 (3554, 0, '193.246.80.28', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-15 12:47:04', 'completed', '', NULL),
 (3555, 0, '193.246.80.28', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-05-15 12:49:51', 'completed', '', NULL),
 (3556, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-15 12:52:00', 'completed', '', NULL),
 (3557, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-15 13:41:38', 'completed', '', NULL),
 (3558, 0, '178.192.110.163', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-05-15 16:11:27', 'completed', '', NULL),
 (3559, 0, '194.230.122.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-15 16:21:26', 'completed', '', NULL),
 (3560, 0, '194.230.122.94', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-05-15 16:23:04', 'completed', '', NULL),
 (3561, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-05-15 16:45:06', 'completed', '', NULL),
 (3562, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-05-15 22:29:24', 'completed', '', NULL),
 (3563, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-05-15 22:29:56', 'completed', '', NULL),
 (3564, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-05-15 22:31:54', 'completed', '', NULL),
 (3565, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-05-15 22:32:17', 'completed', '', NULL),
 (3566, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-16 02:08:28', 'completed', '', NULL),
 (3567, 0, '181.215.244.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-16 06:13:17', 'completed', '', NULL),
 (3568, 0, '91.213.77.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-05-16 11:07:54', 'completed', '', NULL),
 (3569, 0, '91.213.77.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2140, 2141, '', '2017-05-16 11:09:18', 'completed', '', NULL),
 (3570, 0, '91.213.77.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2336, 2337, '', '2017-05-16 11:09:45', 'completed', '', NULL),
 (3571, 0, '157.55.39.129', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-05-16 12:37:36', 'completed', '', NULL),
 (3572, 0, '84.72.54.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1837, 1839, '', '2017-05-16 13:53:19', 'completed', '', NULL),
 (3573, 0, '84.72.54.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2128, 2367, '', '2017-05-16 13:55:01', 'completed', '', NULL),
 (3574, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-16 15:21:48', 'completed', '', NULL),
 (3575, 0, '157.55.39.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-16 17:30:25', 'completed', '', NULL),
 (3576, 0, '199.30.25.74', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-16 18:31:57', 'completed', '', NULL),
 (3577, 0, '88.84.22.202', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2130, 2133, '', '2017-05-16 22:32:53', 'completed', '', NULL),
 (3578, 0, '198.22.66.170', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-17 02:15:09', 'completed', '', NULL),
 (3579, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-17 04:46:04', 'completed', '', NULL),
 (3580, 0, '85.7.167.164', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-05-17 07:06:21', 'completed', '', NULL),
 (3581, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-17 07:32:20', 'completed', '', NULL),
 (3582, 0, '178.198.138.213', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/46.0.2486.0 Safari/537.36 Edge/13.10586', 2339, 2340, '', '2017-05-17 09:40:53', 'completed', '', NULL),
 (3583, 0, '212.129.53.68', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-17 14:43:31', 'completed', '', NULL),
 (3584, 0, '212.129.53.68', 'Java/1.6.0_04', 2146, 2149, '', '2017-05-17 14:43:32', 'completed', '', NULL),
 (3585, 0, '212.129.53.68', 'Java/1.6.0_04', 2333, 2334, '', '2017-05-17 14:43:33', 'completed', '', NULL),
 (3586, 0, '212.129.53.68', 'Java/1.6.0_04', 2140, 2141, '', '2017-05-17 14:43:36', 'completed', '', NULL),
 (3587, 0, '212.129.53.68', 'Java/1.6.0_04', 2336, 2337, '', '2017-05-17 14:43:37', 'completed', '', NULL),
 (3588, 0, '212.129.53.68', 'Java/1.6.0_04', 1837, 1839, '', '2017-05-17 14:43:39', 'completed', '', NULL),
 (3589, 0, '212.129.53.68', 'Java/1.6.0_04', 1844, 1845, '', '2017-05-17 14:43:40', 'completed', '', NULL),
 (3590, 0, '212.129.53.68', 'Java/1.6.0_04', 2339, 2340, '', '2017-05-17 14:43:41', 'completed', '', NULL),
 (3591, 0, '212.129.53.68', 'Java/1.6.0_04', 2130, 2133, '', '2017-05-17 14:43:43', 'completed', '', NULL),
 (3592, 0, '212.129.53.68', 'Java/1.6.0_04', 2134, 2307, '', '2017-05-17 14:43:45', 'completed', '', NULL),
 (3593, 0, '212.129.53.68', 'Java/1.6.0_04', 2161, 2162, '', '2017-05-17 14:43:47', 'completed', '', NULL),
 (3594, 0, '212.129.53.68', 'Java/1.6.0_04', 2342, 2349, '', '2017-05-17 14:43:49', 'completed', '', NULL),
 (3595, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-05-17 18:43:16', 'completed', '', NULL),
 (3596, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2130, 2133, '', '2017-05-17 18:43:30', 'completed', '', NULL),
 (3597, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-05-17 18:44:02', 'completed', '', NULL),
 (3598, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2140, 2141, '', '2017-05-17 18:50:49', 'completed', '', NULL),
 (3599, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-05-17 19:03:24', 'completed', '', NULL),
 (3600, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-05-17 19:03:29', 'completed', '', NULL),
 (3601, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-05-17 19:03:34', 'completed', '', NULL),
 (3602, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-05-17 19:03:54', 'completed', '', NULL),
 (3603, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-05-17 19:03:59', 'completed', '', NULL),
 (3604, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-05-17 19:04:04', 'completed', '', NULL),
 (3605, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-05-17 19:04:09', 'completed', '', NULL),
 (3606, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-05-17 19:04:43', 'completed', '', NULL),
 (3607, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-05-17 19:04:48', 'completed', '', NULL),
 (3608, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-05-17 19:05:18', 'completed', '', NULL),
 (3609, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-05-17 19:05:24', 'completed', '', NULL),
 (3610, 0, '159.203.86.106', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-05-17 19:05:28', 'completed', '', NULL),
 (3611, 0, '178.195.43.155', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2339, 2340, '', '2017-05-17 21:27:48', 'completed', '', NULL),
 (3612, 0, '178.195.43.155', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2339, 2340, '', '2017-05-17 21:36:16', 'completed', '', NULL),
 (3613, 0, '31.10.135.143', 'Mozilla/5.0 (Linux; Android 7.0; SM-G930F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2146, 2149, '', '2017-05-17 21:49:34', 'completed', '', NULL),
 (3614, 0, '51.255.65.81', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-05-18 06:42:56', 'completed', '', NULL),
 (3615, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1837, 1839, '', '2017-05-18 06:47:01', 'completed', '', NULL),
 (3616, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1844, 1845, '', '2017-05-18 06:47:14', 'completed', '', NULL),
 (3617, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2339, 2340, '', '2017-05-18 06:47:24', 'completed', '', NULL),
 (3618, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-18 06:48:41', 'completed', '', NULL),
 (3619, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2130, 2133, '', '2017-05-18 06:55:40', 'completed', '', NULL),
 (3620, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2134, 2307, '', '2017-05-18 06:55:51', 'completed', '', NULL),
 (3621, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2161, 2162, '', '2017-05-18 06:56:03', 'completed', '', NULL),
 (3622, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2342, 2349, '', '2017-05-18 06:56:15', 'completed', '', NULL),
 (3623, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2140, 2141, '', '2017-05-18 06:56:27', 'completed', '', NULL),
 (3624, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2336, 2337, '', '2017-05-18 06:56:38', 'completed', '', NULL),
 (3625, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2128, 2367, '', '2017-05-18 06:56:52', 'completed', '', NULL),
 (3626, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2333, 2334, '', '2017-05-18 06:57:04', 'completed', '', NULL),
 (3627, 0, '195.65.255.66', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-05-18 10:30:30', 'completed', '', NULL),
 (3628, 0, '195.65.255.66', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-05-18 10:30:58', 'completed', '', NULL),
 (3629, 0, '213.196.164.116', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A500FU Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/4.0 Chrome/44.0.2403.133 Mobile Safari/537.36', 2146, 2149, '', '2017-05-18 12:46:26', 'completed', '', NULL),
 (3630, 0, '40.77.167.79', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-18 15:21:32', 'completed', '', NULL),
 (3631, 0, '65.55.210.109', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-18 17:19:15', 'completed', '', NULL),
 (3632, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-18 22:41:25', 'completed', '', NULL),
 (3633, 0, '157.55.39.66', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-18 22:43:54', 'completed', '', NULL),
 (3634, 0, '157.55.39.52', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-19 02:06:43', 'completed', '', NULL),
 (3635, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-19 04:41:00', 'completed', '', NULL),
 (3636, 0, '85.7.167.164', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2333, 2334, '', '2017-05-19 07:30:20', 'completed', '', NULL),
 (3637, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-19 08:43:08', 'completed', '', NULL),
 (3638, 0, '193.17.194.226', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2339, 2340, '', '2017-05-19 13:24:38', 'completed', '', NULL),
 (3639, 0, '178.197.237.73', 'Mozilla/5.0 (iPad; CPU OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2336, 2337, '', '2017-05-19 14:51:45', 'completed', '', NULL),
 (3640, 0, '178.197.237.73', 'Mozilla/5.0 (iPad; CPU OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2140, 2141, '', '2017-05-19 14:55:15', 'completed', '', NULL),
 (3641, 0, '178.197.237.73', 'Mozilla/5.0 (iPad; CPU OS 8_4 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12H143 Safari/600.1.4', 2146, 2149, '', '2017-05-19 14:56:12', 'completed', '', NULL),
 (3642, 0, '78.250.204.178', 'Java/1.8.0_121', 2128, 2367, '', '2017-05-19 16:07:56', 'completed', '', NULL),
 (3643, 0, '178.197.227.28', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/26.0.154727556 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-05-19 17:05:38', 'completed', '', NULL),
 (3644, 0, '178.197.227.28', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/26.0.154727556 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-05-19 17:05:59', 'completed', '', NULL),
 (3645, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-19 18:50:41', 'completed', '', NULL),
 (3646, 0, '84.72.65.31', 'Mozilla/5.0 (iPad; CPU OS 9_0_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13A404 Safari/601.1', 2342, 2349, '', '2017-05-19 20:11:20', 'completed', '', NULL),
 (3647, 0, '212.203.51.67', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2336, 2337, '', '2017-05-19 22:27:06', 'completed', '', NULL),
 (3648, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-19 23:54:48', 'completed', '', NULL),
 (3649, 0, '164.132.161.26', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-05-20 00:35:58', 'completed', '', NULL),
 (3650, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-05-20 06:31:39', 'completed', '', NULL),
 (3651, 0, '91.138.72.149', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-05-20 08:32:28', 'completed', '', NULL),
 (3652, 0, '85.4.93.226', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-05-20 09:39:41', 'completed', '', NULL),
 (3653, 0, '85.7.233.43', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-20 09:50:21', 'completed', '', NULL),
 (3654, 0, '85.7.233.43', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-05-20 09:53:42', 'completed', '', NULL),
 (3655, 0, '85.7.233.43', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-05-20 09:54:12', 'completed', '', NULL),
 (3656, 0, '40.77.167.45', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-20 14:34:10', 'completed', '', NULL),
 (3657, 0, '199.30.25.99', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-20 15:40:58', 'completed', '', NULL),
 (3658, 0, '84.74.168.128', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-05-20 18:32:29', 'completed', '', NULL),
 (3659, 0, '84.74.168.128', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2140, 2141, '', '2017-05-20 18:32:49', 'completed', '', NULL),
 (3660, 0, '208.83.67.98', 'Java/1.8.0_71', 2128, 2367, '', '2017-05-20 19:27:17', 'completed', '', NULL),
 (3661, 0, '178.198.154.4', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-05-20 19:58:23', 'completed', '', NULL),
 (3662, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-20 22:12:41', 'completed', '', NULL),
 (3663, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-21 04:24:32', 'completed', '', NULL),
 (3664, 0, '199.180.118.247', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-21 07:19:36', 'completed', '', NULL),
 (3665, 0, '213.196.187.234', 'Mozilla/5.0 (Linux; Android 5.0.1; ALE-L21 Build/HuaweiALE-L21) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2146, 2149, '', '2017-05-21 09:34:24', 'completed', '', NULL),
 (3666, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-05-21 09:48:41', 'completed', '', NULL),
 (3667, 0, '157.55.39.52', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-21 11:10:44', 'completed', '', NULL),
 (3668, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-21 17:47:00', 'completed', '', NULL),
 (3669, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-21 18:11:26', 'completed', '', NULL),
 (3670, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-05-21 22:32:52', 'completed', '', NULL),
 (3671, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2128, 2367, '', '2017-05-21 23:11:30', 'completed', '', NULL),
 (3672, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 1837, 1839, '', '2017-05-21 23:14:41', 'completed', '', NULL),
 (3673, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 1844, 1845, '', '2017-05-21 23:15:08', 'completed', '', NULL),
 (3674, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2339, 2340, '', '2017-05-21 23:15:27', 'completed', '', NULL),
 (3675, 0, '208.83.67.98', 'Java/1.8.0_71', 2128, 2367, '', '2017-05-21 23:29:30', 'completed', '', NULL),
 (3676, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-22 00:45:53', 'completed', '', NULL),
 (3677, 0, '91.198.72.10', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-05-22 04:53:58', 'completed', '', NULL),
 (3678, 0, '138.190.132.12', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-05-22 10:14:37', 'completed', '', NULL),
 (3679, 0, '208.83.67.98', 'Java/1.8.0_71', 2128, 2367, '', '2017-05-22 20:31:56', 'completed', '', NULL),
 (3680, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-22 21:25:39', 'completed', '', NULL),
 (3681, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-22 21:49:42', 'completed', '', NULL),
 (3682, 0, '157.55.39.52', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-23 02:51:18', 'completed', '', NULL),
 (3683, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-23 04:15:19', 'completed', '', NULL),
 (3684, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-05-23 04:43:55', 'completed', '', NULL),
 (3685, 0, '77.56.242.214', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2333, 2334, '', '2017-05-23 15:52:20', 'completed', '', NULL),
 (3686, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-23 16:09:47', 'completed', '', NULL),
 (3687, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-23 17:29:56', 'completed', '', NULL),
 (3688, 0, '79.116.25.128', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-23 18:36:23', 'completed', '', NULL),
 (3689, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-05-23 19:39:42', 'completed', '', NULL),
 (3690, 0, '178.196.199.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-05-23 20:17:53', 'completed', '', NULL),
 (3691, 0, '178.196.199.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2140, 2141, '', '2017-05-23 20:35:58', 'completed', '', NULL),
 (3692, 0, '178.82.34.155', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-05-23 20:47:46', 'completed', '', NULL),
 (3693, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-05-23 22:51:20', 'completed', '', NULL),
 (3694, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-23 23:16:07', 'completed', '', NULL),
 (3695, 0, '83.42.218.225', 'Java/1.8.0_121', 2128, 2367, '', '2017-05-24 01:10:36', 'completed', '', NULL),
 (3696, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-24 12:27:39', 'completed', '', NULL),
 (3697, 0, '178.197.229.94', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-05-24 12:46:52', 'completed', '', NULL),
 (3698, 0, '92.106.28.57', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-05-24 15:33:27', 'completed', '', NULL),
 (3699, 0, '157.55.39.66', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-24 18:22:28', 'completed', '', NULL),
 (3700, 0, '207.46.13.102', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-24 21:20:02', 'completed', '', NULL),
 (3701, 0, '199.30.24.226', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-24 22:21:34', 'completed', '', NULL),
 (3702, 0, '157.55.39.66', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-24 22:29:24', 'completed', '', NULL),
 (3703, 0, '178.197.226.125', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2342, 2349, '', '2017-05-24 22:39:08', 'completed', '', NULL),
 (3704, 0, '51.255.65.33', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-05-24 22:43:04', 'completed', '', NULL),
 (3705, 0, '178.197.226.125', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2134, 2307, '', '2017-05-24 22:46:35', 'completed', '', NULL),
 (3706, 0, '178.197.226.125', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2130, 2133, '', '2017-05-24 22:47:46', 'completed', '', NULL),
 (3707, 0, '207.46.13.102', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-25 04:09:41', 'completed', '', NULL),
 (3708, 0, '207.46.13.102', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-25 05:25:34', 'completed', '', NULL),
 (3709, 0, '65.55.210.2', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-25 06:27:05', 'completed', '', NULL),
 (3710, 0, '178.197.229.63', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2342, 2349, '', '2017-05-25 10:48:55', 'completed', '', NULL),
 (3711, 0, '93.56.174.2', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2134, 2307, '', '2017-05-25 17:45:18', 'completed', '', NULL),
 (3712, 0, '93.56.174.2', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2130, 2133, '', '2017-05-25 17:45:34', 'completed', '', NULL),
 (3713, 0, '93.56.174.2', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2342, 2349, '', '2017-05-25 17:46:36', 'completed', '', NULL),
 (3714, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-26 01:33:02', 'completed', '', NULL),
 (3715, 0, '40.77.167.29', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-26 07:21:42', 'completed', '', NULL),
 (3716, 0, '79.155.245.19', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-26 10:30:27', 'completed', '', NULL),
 (3717, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-26 11:45:31', 'completed', '', NULL),
 (3718, 0, '178.197.226.197', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2130, 2133, '', '2017-05-26 23:30:28', 'completed', '', NULL),
 (3719, 0, '89.141.84.37', 'Java/1.8.0_111', 2128, 2367, '', '2017-05-27 02:50:51', 'completed', '', NULL),
 (3720, 0, '164.132.161.20', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-05-27 05:16:24', 'completed', '', NULL),
 (3721, 0, '217.162.166.39', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2140, 2141, '', '2017-05-27 08:45:49', 'completed', '', NULL),
 (3722, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-05-27 17:46:36', 'completed', '', NULL),
 (3723, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-05-27 17:46:41', 'completed', '', NULL),
 (3724, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-05-27 17:46:46', 'completed', '', NULL),
 (3725, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-05-27 17:47:08', 'completed', '', NULL),
 (3726, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-05-27 17:47:11', 'completed', '', NULL),
 (3727, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-05-27 17:47:17', 'completed', '', NULL),
 (3728, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-05-27 17:47:21', 'completed', '', NULL),
 (3729, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-05-27 17:47:46', 'completed', '', NULL),
 (3730, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-05-27 17:47:51', 'completed', '', NULL),
 (3731, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-05-27 17:48:30', 'completed', '', NULL),
 (3732, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-05-27 17:48:36', 'completed', '', NULL),
 (3733, 0, '45.55.196.1', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-05-27 17:48:41', 'completed', '', NULL),
 (3734, 0, '178.197.224.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-05-27 20:25:06', 'completed', '', NULL),
 (3735, 0, '178.197.224.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2140, 2141, '', '2017-05-27 20:26:06', 'completed', '', NULL),
 (3736, 0, '178.197.224.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2134, 2307, '', '2017-05-27 20:26:46', 'completed', '', NULL),
 (3737, 0, '178.197.224.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13C75 Safari/601.1', 2130, 2133, '', '2017-05-27 20:26:51', 'completed', '', NULL),
 (3738, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-28 06:46:28', 'completed', '', NULL),
 (3739, 0, '51.254.190.52', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-28 06:58:40', 'completed', '', NULL),
 (3740, 0, '85.4.136.230', 'Mozilla/5.0 (Windows NT 6.1; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-05-28 07:19:55', 'completed', '', NULL),
 (3741, 0, '85.4.136.230', 'Mozilla/5.0 (Windows NT 6.1; rv:53.0) Gecko/20100101 Firefox/53.0', 2146, 2149, '', '2017-05-28 07:20:10', 'completed', '', NULL),
 (3742, 0, '51.254.190.52', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-28 07:55:43', 'completed', '', NULL),
 (3743, 0, '51.254.190.52', 'Java/1.4.1_04', 2128, 2367, '', '2017-05-28 09:05:51', 'completed', '', NULL),
 (3744, 0, '40.77.167.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-28 15:16:24', 'completed', '', NULL),
 (3745, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-28 15:39:23', 'completed', '', NULL),
 (3746, 0, '65.55.210.143', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-28 16:17:54', 'completed', '', NULL),
 (3747, 0, '31.10.151.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-05-28 22:42:50', 'completed', '', NULL),
 (3748, 0, '31.10.151.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-05-28 22:45:29', 'completed', '', NULL),
 (3749, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-28 23:14:01', 'completed', '', NULL),
 (3750, 0, '207.46.13.111', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-05-29 02:14:32', 'completed', '', NULL),
 (3751, 0, '207.46.13.111', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-29 02:25:41', 'completed', '', NULL),
 (3752, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-29 05:55:26', 'completed', '', NULL),
 (3753, 0, '207.46.13.111', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-29 07:03:59', 'completed', '', NULL),
 (3754, 0, '207.46.13.111', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-05-29 07:17:26', 'completed', '', NULL),
 (3755, 0, '207.46.13.111', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-05-29 07:24:53', 'completed', '', NULL),
 (3756, 0, '164.132.161.84', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-05-29 09:24:27', 'completed', '', NULL),
 (3757, 0, '31.10.151.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-05-29 14:08:40', 'completed', '', NULL),
 (3758, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-29 16:08:24', 'completed', '', NULL),
 (3759, 0, '178.197.229.1', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/27.0.155813979 Mobile/14E304 Safari/602.1', 2134, 2307, '', '2017-05-29 20:06:49', 'completed', '', NULL),
 (3760, 0, '31.10.149.19', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2339, 2340, '', '2017-05-29 20:47:17', 'completed', '', NULL),
 (3761, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-05-29 23:33:54', 'completed', '', NULL),
 (3762, 0, '172.245.164.40', 'Java/1.7.0_79', 2128, 2367, '', '2017-05-30 02:22:43', 'completed', '', NULL),
 (3763, 0, '178.38.68.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2128, 2367, '', '2017-05-30 07:13:08', 'completed', '', NULL),
 (3764, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1837, 1839, '', '2017-05-30 07:42:54', 'completed', '', NULL),
 (3765, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1844, 1845, '', '2017-05-30 07:43:06', 'completed', '', NULL),
 (3766, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2339, 2340, '', '2017-05-30 07:43:18', 'completed', '', NULL),
 (3767, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2130, 2133, '', '2017-05-30 07:45:36', 'completed', '', NULL),
 (3768, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2134, 2307, '', '2017-05-30 07:45:46', 'completed', '', NULL),
 (3769, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2161, 2162, '', '2017-05-30 07:45:58', 'completed', '', NULL),
 (3770, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2342, 2349, '', '2017-05-30 07:46:10', 'completed', '', NULL),
 (3771, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2128, 2367, '', '2017-05-30 07:54:25', 'completed', '', NULL),
 (3772, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2333, 2334, '', '2017-05-30 07:54:38', 'completed', '', NULL),
 (3773, 0, '178.197.224.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/27.0.155813979 Mobile/14F89 Safari/602.1', 2134, 2307, '', '2017-05-30 07:54:42', 'completed', '', NULL),
 (3774, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2140, 2141, '', '2017-05-30 07:54:49', 'completed', '', NULL),
 (3775, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2336, 2337, '', '2017-05-30 07:55:00', 'completed', '', NULL),
 (3776, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-05-30 10:18:50', 'completed', '', NULL),
 (3777, 0, '157.55.39.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-05-30 14:36:50', 'completed', '', NULL),
 (3778, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-05-30 14:49:42', 'completed', '', NULL),
 (3779, 0, '199.30.25.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-05-30 15:38:08', 'completed', '', NULL),
 (3780, 0, '194.230.236.46', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 1844, 1845, '', '2017-05-30 17:53:51', 'completed', '', NULL),
 (3781, 0, '207.46.13.108', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-05-30 21:59:42', 'completed', '', NULL),
 (3782, 0, '178.197.227.71', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2130, 2133, '', '2017-05-31 00:08:18', 'completed', '', NULL),
 (3783, 0, '207.46.13.89', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-05-31 02:26:33', 'completed', '', NULL),
 (3784, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-31 08:48:57', 'completed', '', NULL),
 (3785, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-05-31 09:29:40', 'completed', '', NULL),
 (3786, 0, '157.55.39.161', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-05-31 11:55:19', 'completed', '', NULL),
 (3787, 0, '152.88.80.63', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2342, 2349, '', '2017-05-31 11:56:56', 'completed', '', NULL),
 (3788, 0, '152.88.80.63', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2134, 2307, '', '2017-05-31 11:56:58', 'completed', '', NULL),
 (3789, 0, '152.88.80.63', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2130, 2133, '', '2017-05-31 11:57:21', 'completed', '', NULL),
 (3790, 0, '217.182.132.241', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-05-31 13:44:54', 'completed', '', NULL),
 (3791, 0, '40.77.167.33', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-05-31 14:56:26', 'completed', '', NULL),
 (3792, 0, '157.55.39.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-05-31 15:35:11', 'completed', '', NULL),
 (3793, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-05-31 19:39:14', 'completed', '', NULL),
 (3794, 0, '157.55.39.248', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-01 01:29:17', 'completed', '', NULL),
 (3795, 0, '157.55.39.248', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-01 01:35:16', 'completed', '', NULL),
 (3796, 0, '157.55.39.188', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-01 03:17:58', 'completed', '', NULL),
 (3797, 0, '213.127.113.89', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-01 04:13:38', 'completed', '', NULL),
 (3798, 0, '40.77.167.33', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-01 04:54:14', 'completed', '', NULL),
 (3799, 0, '83.150.58.184', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-06-01 06:16:44', 'completed', '', NULL),
 (3800, 0, '83.150.58.184', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.9; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-06-01 06:24:24', 'completed', '', NULL),
 (3801, 0, '40.77.167.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-01 08:47:53', 'completed', '', NULL),
 (3802, 0, '212.187.77.34', 'Java/1.8.0_71', 2128, 2367, '', '2017-06-01 09:47:55', 'completed', '', NULL),
 (3803, 0, '178.192.240.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-01 10:11:59', 'completed', '', NULL),
 (3804, 0, '178.192.240.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-01 10:14:00', 'completed', '', NULL),
 (3805, 0, '178.192.240.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-01 10:15:39', 'completed', '', NULL),
 (3806, 0, '178.192.240.195', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2336, 2337, '', '2017-06-01 10:16:17', 'completed', '', NULL),
 (3807, 0, '178.38.84.72', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/27.0.155813979 Mobile/14A456 Safari/602.1', 2140, 2141, '', '2017-06-01 11:25:25', 'completed', '', NULL),
 (3808, 0, '207.46.13.38', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-01 14:36:42', 'completed', '', NULL),
 (3809, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-06-01 16:44:58', 'completed', '', NULL),
 (3810, 0, '77.250.67.242', 'Java/1.8.0_77', 2128, 2367, '', '2017-06-01 18:54:12', 'completed', '', NULL),
 (3811, 0, '207.46.13.38', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-01 19:58:53', 'completed', '', NULL),
 (3812, 0, '65.55.213.25', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-01 21:00:18', 'completed', '', NULL),
 (3813, 0, '40.77.167.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-01 21:08:01', 'completed', '', NULL),
 (3814, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-06-01 22:13:41', 'completed', '', NULL),
 (3815, 0, '40.77.167.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-02 07:36:16', 'completed', '', NULL),
 (3816, 0, '92.104.155.163', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A310F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2140, 2141, '', '2017-06-02 08:56:14', 'completed', '', NULL),
 (3817, 0, '92.104.155.163', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-A310F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2146, 2149, '', '2017-06-02 08:57:10', 'completed', '', NULL),
 (3818, 0, '83.244.128.114', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/43.0.2357.134 Safari/537.36', 2128, 2367, '', '2017-06-02 09:23:10', 'completed', '', NULL),
 (3819, 0, '62.202.180.160', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-06-02 11:05:43', 'completed', '', NULL),
 (3820, 0, '62.202.180.160', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-06-02 11:06:18', 'completed', '', NULL),
 (3821, 0, '62.202.180.160', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2333, 2334, '', '2017-06-02 11:06:53', 'completed', '', NULL),
 (3822, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2342, 2349, '', '2017-06-02 12:55:04', 'completed', '', NULL),
 (3823, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2134, 2307, '', '2017-06-02 12:59:59', 'completed', '', NULL),
 (3824, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2130, 2133, '', '2017-06-02 13:00:56', 'completed', '', NULL),
 (3825, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2146, 2149, '', '2017-06-02 13:01:57', 'completed', '', NULL),
 (3826, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2146, 2149, '', '2017-06-02 13:03:16', 'completed', '', NULL),
 (3827, 0, '40.77.167.33', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-02 13:03:52', 'completed', '', NULL),
 (3828, 0, '178.238.175.135', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G900F Build/MMB29M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2134, 2307, '', '2017-06-02 13:05:07', 'completed', '', NULL),
 (3829, 0, '40.77.167.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-02 14:57:30', 'completed', '', NULL),
 (3830, 0, '40.77.167.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-02 15:31:07', 'completed', '', NULL),
 (3831, 0, '83.78.254.142', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2140, 2141, '', '2017-06-02 15:54:25', 'completed', '', NULL),
 (3832, 0, '40.77.167.107', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-02 18:21:44', 'completed', '', NULL),
 (3833, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-06-02 21:02:30', 'completed', '', NULL),
 (3834, 0, '40.77.167.109', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-02 22:01:30', 'completed', '', NULL),
 (3835, 0, '40.77.167.33', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-02 22:38:57', 'completed', '', NULL),
 (3836, 0, '40.77.167.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-03 02:50:05', 'completed', '', NULL),
 (3837, 0, '40.77.167.109', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-03 03:03:32', 'completed', '', NULL),
 (3838, 0, '40.77.167.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-03 04:54:49', 'completed', '', NULL),
 (3839, 0, '40.77.167.33', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-03 07:24:33', 'completed', '', NULL),
 (3840, 0, '89.206.64.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2339, 2340, '', '2017-06-03 11:37:40', 'completed', '', NULL),
 (3841, 0, '178.197.236.11', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2130, 2133, '', '2017-06-03 13:04:35', 'completed', '', NULL),
 (3842, 0, '164.132.161.86', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-06-03 17:43:06', 'completed', '', NULL),
 (3843, 0, '85.7.128.159', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2333, 2334, '', '2017-06-03 18:31:33', 'completed', '', NULL),
 (3844, 0, '85.7.128.159', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2146, 2149, '', '2017-06-03 18:31:36', 'completed', '', NULL),
 (3845, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 1844, 1845, '', '2017-06-03 20:43:19', 'completed', '', NULL),
 (3846, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-06-03 20:44:19', 'completed', '', NULL),
 (3847, 0, '188.62.20.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_0_1 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/27.0.155813979 Mobile/14A403 Safari/602.1', 2336, 2337, '', '2017-06-03 20:59:40', 'completed', '', NULL),
 (3848, 0, '157.55.39.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-03 21:28:37', 'completed', '', NULL),
 (3849, 0, '84.227.7.108', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2128, 2367, '', '2017-06-03 23:27:30', 'completed', '', NULL),
 (3850, 0, '194.56.48.113', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-06-04 00:32:02', 'completed', '', NULL),
 (3851, 0, '194.56.48.113', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-06-04 00:32:58', 'completed', '', NULL),
 (3852, 0, '194.56.48.113', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-06-04 00:33:17', 'completed', '', NULL),
 (3853, 0, '194.56.48.113', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-06-04 00:34:18', 'completed', '', NULL),
 (3854, 0, '207.46.13.14', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-04 02:33:45', 'completed', '', NULL),
 (3855, 0, '157.55.39.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-04 05:02:00', 'completed', '', NULL),
 (3856, 0, '40.77.167.42', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-04 12:44:58', 'completed', '', NULL),
 (3857, 0, '207.46.13.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-04 14:27:53', 'completed', '', NULL),
 (3858, 0, '157.55.39.200', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-04 15:52:31', 'completed', '', NULL),
 (3859, 0, '77.229.129.3', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-04 17:54:23', 'completed', '', NULL),
 (3860, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-04 20:19:31', 'completed', '', NULL),
 (3861, 0, '31.10.151.163', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-04 20:29:43', 'completed', '', NULL),
 (3862, 0, '157.55.39.161', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-05 00:56:40', 'completed', '', NULL),
 (3863, 0, '178.197.234.224', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_2_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13D15 Safari/601.1', 2130, 2133, '', '2017-06-05 01:06:44', 'completed', '', NULL),
 (3864, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-05 01:34:14', 'completed', '', NULL),
 (3865, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-05 02:36:36', 'completed', '', NULL),
 (3866, 0, '157.55.39.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-05 02:53:13', 'completed', '', NULL),
 (3867, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-06-05 05:33:17', 'completed', '', NULL),
 (3868, 0, '157.55.39.149', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-05 08:18:29', 'completed', '', NULL),
 (3869, 0, '157.55.39.142', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-05 09:12:01', 'completed', '', NULL),
 (3870, 0, '157.55.39.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-05 14:12:13', 'completed', '', NULL),
 (3871, 0, '199.30.24.167', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-05 15:13:48', 'completed', '', NULL),
 (3872, 0, '157.55.39.142', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-05 15:52:12', 'completed', '', NULL),
 (3873, 0, '88.26.18.228', 'Java/1.8.0_121', 2128, 2367, '', '2017-06-05 17:42:45', 'completed', '', NULL),
 (3874, 0, '157.55.39.142', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-05 20:41:58', 'completed', '', NULL),
 (3875, 0, '84.73.234.85', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:53.0) Gecko/20100101 Firefox/53.0', 2336, 2337, '', '2017-06-05 20:53:38', 'completed', '', NULL),
 (3876, 0, '178.197.233.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-05 21:08:40', 'completed', '', NULL),
 (3877, 0, '178.197.233.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-05 21:09:11', 'completed', '', NULL),
 (3878, 0, '149.202.7.207', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-05 23:17:26', 'completed', '', NULL),
 (3879, 0, '80.219.214.194', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-06-06 09:01:43', 'completed', '', NULL),
 (3880, 0, '40.77.167.42', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-06 10:22:54', 'completed', '', NULL),
 (3881, 0, '40.77.167.42', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-06 13:35:36', 'completed', '', NULL),
 (3882, 0, '80.67.147.15', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-06-06 14:22:11', 'completed', '', NULL),
 (3883, 0, '80.67.147.15', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-06-06 14:22:34', 'completed', '', NULL),
 (3884, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-06-06 14:57:14', 'completed', '', NULL),
 (3885, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-06-06 14:57:19', 'completed', '', NULL),
 (3886, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-06-06 14:57:24', 'completed', '', NULL),
 (3887, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-06-06 14:57:39', 'completed', '', NULL),
 (3888, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-06-06 14:57:44', 'completed', '', NULL),
 (3889, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-06-06 14:57:50', 'completed', '', NULL),
 (3890, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-06-06 14:57:55', 'completed', '', NULL),
 (3891, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-06-06 14:58:29', 'completed', '', NULL),
 (3892, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-06-06 14:58:34', 'completed', '', NULL),
 (3893, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-06-06 14:59:10', 'completed', '', NULL),
 (3894, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-06-06 14:59:14', 'completed', '', NULL),
 (3895, 0, '104.236.2.75', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-06-06 14:59:19', 'completed', '', NULL),
 (3896, 0, '157.55.39.234', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-06 15:27:22', 'completed', '', NULL),
 (3897, 0, '145.250.209.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-06-06 16:19:01', 'completed', '', NULL),
 (3898, 0, '157.55.39.142', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-06 16:45:19', 'completed', '', NULL),
 (3899, 0, '207.46.13.110', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-06 22:03:02', 'completed', '', NULL),
 (3900, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-06-07 02:11:11', 'completed', '', NULL),
 (3901, 0, '207.46.13.110', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-07 02:35:48', 'completed', '', NULL),
 (3902, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-07 02:38:42', 'completed', '', NULL),
 (3903, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-06-07 02:52:17', 'completed', '', NULL),
 (3904, 0, '207.46.13.110', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-07 03:43:02', 'completed', '', NULL),
 (3905, 0, '157.55.39.239', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-07 04:19:13', 'completed', '', NULL),
 (3906, 0, '198.199.124.107', 'SafeDNSBot (https://www.safedns.com/searchbot)', 2134, 2307, '', '2017-06-07 06:38:10', 'completed', '', NULL),
 (3907, 0, '40.77.167.42', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-07 06:41:34', 'completed', '', NULL),
 (3908, 0, '157.55.39.239', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-07 14:55:52', 'completed', '', NULL),
 (3909, 0, '80.243.212.228', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:53.0) Gecko/20100101 Firefox/53.0', 2134, 2307, '', '2017-06-07 14:57:30', 'completed', '', NULL),
 (3910, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-07 15:10:48', 'completed', '', NULL),
 (3911, 0, '199.30.24.249', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-07 15:59:53', 'completed', '', NULL),
 (3912, 0, '178.197.225.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2333, 2334, '', '2017-06-07 17:31:03', 'completed', '', NULL),
 (3913, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-07 21:44:33', 'completed', '', NULL),
 (3914, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1837, 1839, '', '2017-06-08 02:20:31', 'completed', '', NULL),
 (3915, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 1844, 1845, '', '2017-06-08 02:20:42', 'completed', '', NULL),
 (3916, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2339, 2340, '', '2017-06-08 02:20:54', 'completed', '', NULL),
 (3917, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2128, 2367, '', '2017-06-08 02:36:41', 'completed', '', NULL),
 (3918, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2333, 2334, '', '2017-06-08 02:36:53', 'completed', '', NULL),
 (3919, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2130, 2133, '', '2017-06-08 02:37:08', 'completed', '', NULL),
 (3920, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2134, 2307, '', '2017-06-08 02:37:21', 'completed', '', NULL),
 (3921, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2161, 2162, '', '2017-06-08 02:37:33', 'completed', '', NULL),
 (3922, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2342, 2349, '', '2017-06-08 02:37:50', 'completed', '', NULL),
 (3923, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2140, 2141, '', '2017-06-08 02:38:04', 'completed', '', NULL),
 (3924, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2336, 2337, '', '2017-06-08 02:38:18', 'completed', '', NULL),
 (3925, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-08 03:20:16', 'completed', '', NULL),
 (3926, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-08 04:16:43', 'completed', '', NULL),
 (3927, 0, '188.60.94.43', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:53.0) Gecko/20100101 Firefox/53.0', 2333, 2334, '', '2017-06-08 10:50:49', 'completed', '', NULL),
 (3928, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-06-08 14:30:27', 'completed', '', NULL),
 (3929, 0, '40.77.167.120', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-08 16:36:10', 'completed', '', NULL),
 (3930, 0, '5.196.87.175', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-06-08 18:23:42', 'completed', '', NULL),
 (3931, 0, '157.55.39.124', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-08 19:36:39', 'completed', '', NULL),
 (3932, 0, '5.196.87.174', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-06-08 20:32:23', 'completed', '', NULL),
 (3933, 0, '5.196.87.172', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-06-08 20:36:35', 'completed', '', NULL),
 (3934, 0, '178.82.23.116', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2339, 2340, '', '2017-06-08 21:10:41', 'completed', '', NULL),
 (3935, 0, '157.55.39.187', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-09 03:16:10', 'completed', '', NULL),
 (3936, 0, '157.55.39.124', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-09 06:59:18', 'completed', '', NULL),
 (3937, 0, '207.46.13.31', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-09 10:59:13', 'completed', '', NULL),
 (3938, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-06-09 11:29:00', 'completed', '', NULL),
 (3939, 0, '207.46.13.31', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-09 12:41:08', 'completed', '', NULL),
 (3940, 0, '157.55.39.124', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-09 19:12:18', 'completed', '', NULL),
 (3941, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-09 19:19:45', 'completed', '', NULL),
 (3942, 0, '40.77.177.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-09 20:13:58', 'completed', '', NULL),
 (3943, 0, '217.182.132.82', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2161, 2162, '', '2017-06-09 22:27:28', 'completed', '', NULL),
 (3944, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-09 23:15:37', 'completed', '', NULL),
 (3945, 0, '85.5.79.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2146, 2149, '', '2017-06-10 06:39:21', 'completed', '', NULL),
 (3946, 0, '85.5.79.234', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2134, 2307, '', '2017-06-10 06:39:37', 'completed', '', NULL),
 (3947, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-10 06:43:42', 'completed', '', NULL),
 (3948, 0, '157.55.39.187', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-10 06:58:42', 'completed', '', NULL),
 (3949, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-10 07:52:03', 'completed', '', NULL),
 (3950, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-06-10 07:52:11', 'completed', '', NULL),
 (3951, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-06-10 07:53:03', 'completed', '', NULL),
 (3952, 0, '68.180.228.112', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1844, 1845, '', '2017-06-10 11:52:02', 'completed', '', NULL),
 (3953, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-10 14:06:58', 'completed', '', NULL),
 (3954, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-10 20:57:42', 'completed', '', NULL),
 (3955, 0, '68.180.228.112', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-06-10 22:05:59', 'completed', '', NULL),
 (3956, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-10 22:12:48', 'completed', '', NULL),
 (3957, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-06-10 22:26:52', 'completed', '', NULL),
 (3958, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-10 22:27:08', 'completed', '', NULL),
 (3959, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-06-10 22:29:50', 'completed', '', NULL),
 (3960, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-10 23:10:05', 'completed', '', NULL),
 (3961, 0, '157.55.39.243', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-11 03:27:21', 'completed', '', NULL),
 (3962, 0, '207.46.13.31', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-11 05:58:42', 'completed', '', NULL),
 (3963, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-11 09:07:53', 'completed', '', NULL),
 (3964, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-11 09:44:51', 'completed', '', NULL),
 (3965, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2134, 2307, '', '2017-06-11 13:17:27', 'completed', '', NULL),
 (3966, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2130, 2133, '', '2017-06-11 13:18:00', 'completed', '', NULL),
 (3967, 0, '85.7.219.140', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0.2 Safari/602.3.12', 2130, 2133, '', '2017-06-11 13:19:36', 'completed', '', NULL),
 (3968, 0, '80.218.0.135', 'Mozilla/5.0 (Linux; Android 6.0; HTC One M9 Build/MRA58K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 1844, 1845, '', '2017-06-11 14:08:08', 'completed', '', NULL),
 (3969, 0, '80.218.0.135', 'Mozilla/5.0 (Linux; Android 6.0; HTC One M9 Build/MRA58K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 1837, 1839, '', '2017-06-11 14:09:27', 'completed', '', NULL),
 (3970, 0, '194.230.185.91', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2130, 2133, '', '2017-06-11 14:23:12', 'completed', '', NULL),
 (3971, 0, '194.230.185.91', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2134, 2307, '', '2017-06-11 14:23:31', 'completed', '', NULL),
 (3972, 0, '207.46.13.19', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-11 16:57:19', 'completed', '', NULL),
 (3973, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-11 17:03:26', 'completed', '', NULL),
 (3974, 0, '178.197.227.77', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/17.1.129017588 Mobile/14E304 Safari/600.1.4', 2146, 2149, '', '2017-06-11 17:23:24', 'completed', '', NULL),
 (3975, 0, '199.30.24.249', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-11 18:04:56', 'completed', '', NULL),
 (3976, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-11 18:49:02', 'completed', '', NULL),
 (3977, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2130, 2133, '', '2017-06-11 22:23:00', 'completed', '', NULL),
 (3978, 0, '157.55.39.243', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-12 04:04:07', 'completed', '', NULL),
 (3979, 0, '217.182.132.82', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-06-12 12:49:23', 'completed', '', NULL),
 (3980, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-12 15:24:30', 'completed', '', NULL),
 (3981, 0, '207.46.13.2', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-12 15:34:56', 'completed', '', NULL),
 (3982, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2339, 2340, '', '2017-06-12 16:26:22', 'completed', '', NULL),
 (3983, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2333, 2334, '', '2017-06-12 16:28:51', 'completed', '', NULL),
 (3984, 0, '188.103.26.123', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36', 2140, 2141, '', '2017-06-12 17:32:03', 'completed', '', NULL),
 (3985, 0, '77.12.53.132', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36', 2336, 2337, '', '2017-06-12 17:32:08', 'completed', '', NULL),
 (3986, 0, '94.134.150.79', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36', 2146, 2149, '', '2017-06-12 17:32:13', 'completed', '', NULL),
 (3987, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-12 17:35:21', 'completed', '', NULL),
 (3988, 0, '217.182.132.186', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-06-12 19:25:44', 'completed', '', NULL),
 (3989, 0, '84.73.234.85', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:53.0) Gecko/20100101 Firefox/53.0', 2140, 2141, '', '2017-06-12 21:11:27', 'completed', '', NULL),
 (3990, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-12 22:12:01', 'completed', '', NULL),
 (3991, 0, '104.171.119.202', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-12 22:40:03', 'completed', '', NULL),
 (3992, 0, '181.41.204.175', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 00:43:42', 'completed', '', NULL),
 (3993, 0, '157.55.39.243', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-13 02:42:43', 'completed', '', NULL),
 (3994, 0, '157.55.39.243', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-13 03:40:00', 'completed', '', NULL),
 (3995, 0, '181.41.204.175', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 03:44:27', 'completed', '', NULL),
 (3996, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-13 04:11:51', 'completed', '', NULL),
 (3997, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-13 04:44:32', 'completed', '', NULL),
 (3998, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-06-13 06:21:29', 'completed', '', NULL),
 (3999, 0, '5.196.87.172', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-06-13 09:03:19', 'completed', '', NULL),
 (4000, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 09:14:09', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(4001, 0, '79.116.29.254', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 09:21:34', 'completed', '', NULL),
 (4002, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-13 10:35:59', 'completed', '', NULL),
 (4003, 0, '178.194.100.236', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; ASU2JS; rv:11.0) like Gecko', 2161, 2162, '', '2017-06-13 11:28:40', 'completed', '', NULL),
 (4004, 0, '5.196.87.171', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-06-13 11:31:47', 'completed', '', NULL),
 (4005, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 12:10:31', 'completed', '', NULL),
 (4006, 0, '5.196.87.171', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-06-13 12:25:23', 'completed', '', NULL),
 (4007, 0, '207.46.13.176', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-13 13:58:20', 'completed', '', NULL),
 (4008, 0, '194.191.233.196', 'Mozilla/5.0 (Linux; Android 4.1.1; AT300 Build/JRO03C) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Safari/537.36', 2140, 2141, '', '2017-06-13 14:28:13', 'completed', '', NULL),
 (4009, 0, '178.82.40.165', 'Mozilla/5.0 (Windows NT 6.1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.96 Safari/537.36', 2336, 2337, '', '2017-06-13 16:55:18', 'completed', '', NULL),
 (4010, 0, '5.196.87.173', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-06-13 17:03:19', 'completed', '', NULL),
 (4011, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-13 17:50:37', 'completed', '', NULL),
 (4012, 0, '5.196.87.171', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-06-13 17:57:26', 'completed', '', NULL),
 (4013, 0, '181.41.204.175', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 18:08:22', 'completed', '', NULL),
 (4014, 0, '65.55.210.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-13 18:52:09', 'completed', '', NULL),
 (4015, 0, '31.25.123.93', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2333, 2334, '', '2017-06-13 20:00:55', 'completed', '', NULL),
 (4016, 0, '144.217.200.53', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 20:02:10', 'completed', '', NULL),
 (4017, 0, '144.217.200.53', 'Java/1.6.0_04', 2146, 2149, '', '2017-06-13 20:02:28', 'completed', '', NULL),
 (4018, 0, '144.217.200.53', 'Java/1.6.0_04', 2333, 2334, '', '2017-06-13 20:02:33', 'completed', '', NULL),
 (4019, 0, '144.217.200.53', 'Java/1.6.0_04', 2140, 2141, '', '2017-06-13 20:02:47', 'completed', '', NULL),
 (4020, 0, '144.217.200.53', 'Java/1.6.0_04', 2336, 2337, '', '2017-06-13 20:02:59', 'completed', '', NULL),
 (4021, 0, '144.217.200.53', 'Java/1.6.0_04', 1837, 1839, '', '2017-06-13 20:03:15', 'completed', '', NULL),
 (4022, 0, '144.217.200.53', 'Java/1.6.0_04', 1844, 1845, '', '2017-06-13 20:03:27', 'completed', '', NULL),
 (4023, 0, '144.217.200.53', 'Java/1.6.0_04', 2339, 2340, '', '2017-06-13 20:03:33', 'completed', '', NULL),
 (4024, 0, '144.217.200.53', 'Java/1.6.0_04', 2130, 2133, '', '2017-06-13 20:03:49', 'completed', '', NULL),
 (4025, 0, '144.217.200.53', 'Java/1.6.0_04', 2134, 2307, '', '2017-06-13 20:03:57', 'completed', '', NULL),
 (4026, 0, '144.217.200.53', 'Java/1.6.0_04', 2161, 2162, '', '2017-06-13 20:04:20', 'completed', '', NULL),
 (4027, 0, '144.217.200.53', 'Java/1.6.0_04', 2342, 2349, '', '2017-06-13 20:04:35', 'completed', '', NULL),
 (4028, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-13 21:24:08', 'completed', '', NULL),
 (4029, 0, '5.196.87.171', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-06-13 23:05:22', 'completed', '', NULL),
 (4030, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-14 07:29:35', 'completed', '', NULL),
 (4031, 0, '181.215.244.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-14 07:40:32', 'completed', '', NULL),
 (4032, 0, '178.174.79.82', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2333, 2334, '', '2017-06-14 08:11:26', 'completed', '', NULL),
 (4033, 0, '178.174.79.82', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2128, 2367, '', '2017-06-14 08:11:27', 'completed', '', NULL),
 (4034, 0, '178.174.79.82', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36', 2146, 2149, '', '2017-06-14 08:11:29', 'completed', '', NULL),
 (4035, 0, '5.196.87.174', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-06-14 11:27:02', 'completed', '', NULL),
 (4036, 0, '178.199.88.181', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-06-14 12:05:36', 'completed', '', NULL),
 (4037, 0, '178.199.88.181', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-06-14 12:19:36', 'completed', '', NULL),
 (4038, 0, '178.199.88.181', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-06-14 12:19:50', 'completed', '', NULL),
 (4039, 0, '178.199.21.37', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2339, 2340, '', '2017-06-14 13:22:58', 'completed', '', NULL),
 (4040, 0, '178.199.21.37', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 1844, 1845, '', '2017-06-14 13:24:41', 'completed', '', NULL),
 (4041, 0, '207.46.13.2', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-14 16:00:55', 'completed', '', NULL),
 (4042, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-14 17:29:22', 'completed', '', NULL),
 (4043, 0, '5.196.87.175', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-06-14 19:46:56', 'completed', '', NULL),
 (4044, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-14 19:53:54', 'completed', '', NULL),
 (4045, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2342, 2349, '', '2017-06-14 20:17:21', 'completed', '', NULL),
 (4046, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2134, 2307, '', '2017-06-14 20:22:02', 'completed', '', NULL),
 (4047, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2130, 2133, '', '2017-06-14 20:23:23', 'completed', '', NULL),
 (4048, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-14 21:48:08', 'completed', '', NULL),
 (4049, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-14 22:59:38', 'completed', '', NULL),
 (4050, 0, '5.196.87.175', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-06-15 01:02:25', 'completed', '', NULL),
 (4051, 0, '207.46.13.176', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-15 01:30:58', 'completed', '', NULL),
 (4052, 0, '207.46.13.176', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-15 01:42:59', 'completed', '', NULL),
 (4053, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-15 03:37:45', 'completed', '', NULL),
 (4054, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-15 04:07:13', 'completed', '', NULL),
 (4055, 0, '207.46.13.176', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-15 07:15:44', 'completed', '', NULL),
 (4056, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-15 07:15:49', 'completed', '', NULL),
 (4057, 0, '5.196.87.171', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-06-15 19:52:20', 'completed', '', NULL),
 (4058, 0, '5.196.87.174', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-06-16 02:25:26', 'completed', '', NULL),
 (4059, 0, '69.146.169.206', 'Java/1.8.0_121', 2128, 2367, '', '2017-06-16 07:44:30', 'completed', '', NULL),
 (4060, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-06-16 09:35:28', 'completed', '', NULL),
 (4061, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-06-16 09:35:34', 'completed', '', NULL),
 (4062, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-06-16 09:35:39', 'completed', '', NULL),
 (4063, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-06-16 09:35:58', 'completed', '', NULL),
 (4064, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-06-16 09:36:03', 'completed', '', NULL),
 (4065, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-06-16 09:36:14', 'completed', '', NULL),
 (4066, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-06-16 09:36:48', 'completed', '', NULL),
 (4067, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-06-16 09:36:54', 'completed', '', NULL),
 (4068, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-06-16 09:37:23', 'completed', '', NULL),
 (4069, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-06-16 09:37:29', 'completed', '', NULL),
 (4070, 0, '104.236.97.46', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-06-16 09:37:33', 'completed', '', NULL),
 (4071, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-16 11:35:16', 'completed', '', NULL),
 (4072, 0, '31.10.153.238', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-06-16 12:11:26', 'completed', '', NULL),
 (4073, 0, '31.10.153.238', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-06-16 12:14:28', 'completed', '', NULL),
 (4074, 0, '31.10.153.238', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-06-16 12:15:08', 'completed', '', NULL),
 (4075, 0, '185.29.10.56', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-16 14:34:40', 'completed', '', NULL),
 (4076, 0, '157.55.39.233', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-16 15:21:42', 'completed', '', NULL),
 (4077, 0, '83.76.65.155', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2339, 2340, '', '2017-06-16 15:26:58', 'completed', '', NULL),
 (4078, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-16 16:29:43', 'completed', '', NULL),
 (4079, 0, '157.55.39.149', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-16 17:40:31', 'completed', '', NULL),
 (4080, 0, '178.39.121.23', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-06-16 18:04:49', 'completed', '', NULL),
 (4081, 0, '178.39.121.23', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1837, 1839, '', '2017-06-16 18:06:27', 'completed', '', NULL),
 (4082, 0, '178.39.121.23', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2342, 2349, '', '2017-06-16 18:07:14', 'completed', '', NULL),
 (4083, 0, '178.39.121.23', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-06-16 18:07:17', 'completed', '', NULL),
 (4084, 0, '84.226.64.251', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-06-16 18:26:47', 'completed', '', NULL),
 (4085, 0, '199.168.138.182', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-16 19:24:11', 'completed', '', NULL),
 (4086, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-16 19:34:12', 'completed', '', NULL),
 (4087, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-16 20:30:58', 'completed', '', NULL),
 (4088, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2342, 2349, '', '2017-06-16 23:52:21', 'completed', '', NULL),
 (4089, 0, '157.55.39.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-16 23:53:12', 'completed', '', NULL),
 (4090, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2134, 2307, '', '2017-06-16 23:55:58', 'completed', '', NULL),
 (4091, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2336, 2337, '', '2017-06-17 00:10:16', 'completed', '', NULL),
 (4092, 0, '157.55.39.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-17 00:52:08', 'completed', '', NULL),
 (4093, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-17 02:32:36', 'completed', '', NULL),
 (4094, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-17 02:38:13', 'completed', '', NULL),
 (4095, 0, '157.55.39.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-17 04:50:46', 'completed', '', NULL),
 (4096, 0, '40.77.167.55', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-17 04:50:54', 'completed', '', NULL),
 (4097, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2161, 2162, '', '2017-06-17 07:37:10', 'completed', '', NULL),
 (4098, 0, '40.77.167.86', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-17 09:45:07', 'completed', '', NULL),
 (4099, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2128, 2367, '', '2017-06-17 11:08:02', 'completed', '', NULL),
 (4100, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 1837, 1839, '', '2017-06-17 11:11:08', 'completed', '', NULL),
 (4101, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 1844, 1845, '', '2017-06-17 11:12:32', 'completed', '', NULL),
 (4102, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:53.0) Gecko/20100101 Firefox/53.0', 2339, 2340, '', '2017-06-17 11:12:46', 'completed', '', NULL),
 (4103, 0, '178.9.173.15', 'Java/1.7.0_79', 2128, 2367, '', '2017-06-17 11:43:35', 'completed', '', NULL),
 (4104, 0, '178.9.173.15', 'Java/1.7.0_79', 2146, 2149, '', '2017-06-17 11:43:37', 'completed', '', NULL),
 (4105, 0, '178.9.173.15', 'Java/1.7.0_79', 2333, 2334, '', '2017-06-17 11:43:38', 'completed', '', NULL),
 (4106, 0, '178.9.173.15', 'Java/1.7.0_79', 2140, 2141, '', '2017-06-17 11:43:42', 'completed', '', NULL),
 (4107, 0, '178.9.173.15', 'Java/1.7.0_79', 2336, 2337, '', '2017-06-17 11:43:44', 'completed', '', NULL),
 (4108, 0, '178.9.173.15', 'Java/1.7.0_79', 1837, 1839, '', '2017-06-17 11:43:46', 'completed', '', NULL),
 (4109, 0, '178.9.173.15', 'Java/1.7.0_79', 1844, 1845, '', '2017-06-17 11:43:48', 'completed', '', NULL),
 (4110, 0, '178.9.173.15', 'Java/1.7.0_79', 2339, 2340, '', '2017-06-17 11:43:49', 'completed', '', NULL),
 (4111, 0, '178.9.173.15', 'Java/1.7.0_79', 2130, 2133, '', '2017-06-17 11:43:51', 'completed', '', NULL),
 (4112, 0, '178.9.173.15', 'Java/1.7.0_79', 2134, 2307, '', '2017-06-17 11:43:53', 'completed', '', NULL),
 (4113, 0, '178.9.173.15', 'Java/1.7.0_79', 2161, 2162, '', '2017-06-17 11:43:55', 'completed', '', NULL),
 (4114, 0, '178.9.173.15', 'Java/1.7.0_79', 2342, 2349, '', '2017-06-17 11:43:58', 'completed', '', NULL),
 (4115, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 1837, 1839, '', '2017-06-17 12:16:21', 'completed', '', NULL),
 (4116, 0, '83.77.30.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2146, 2149, '', '2017-06-17 16:10:59', 'completed', '', NULL),
 (4117, 0, '83.77.30.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2336, 2337, '', '2017-06-17 16:32:19', 'completed', '', NULL),
 (4118, 0, '157.55.39.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-17 18:03:38', 'completed', '', NULL),
 (4119, 0, '40.77.177.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-17 19:05:11', 'completed', '', NULL),
 (4120, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-17 23:58:02', 'completed', '', NULL),
 (4121, 0, '178.192.196.19', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 2146, 2149, '', '2017-06-18 15:11:39', 'completed', '', NULL),
 (4122, 0, '178.192.196.19', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_3) AppleWebKit/602.4.8 (KHTML, like Gecko) Version/10.0.3 Safari/602.4.8', 1844, 1845, '', '2017-06-18 15:11:52', 'completed', '', NULL),
 (4123, 0, '40.77.167.24', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-18 15:28:10', 'completed', '', NULL),
 (4124, 0, '178.39.112.159', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 1844, 1845, '', '2017-06-18 16:34:14', 'completed', '', NULL),
 (4125, 0, '157.55.39.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-18 17:36:48', 'completed', '', NULL),
 (4126, 0, '40.77.167.21', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-18 18:33:11', 'completed', '', NULL),
 (4127, 0, '207.46.13.112', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-18 23:24:02', 'completed', '', NULL),
 (4128, 0, '207.46.13.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-18 23:34:28', 'completed', '', NULL),
 (4129, 0, '207.46.13.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-18 23:35:44', 'completed', '', NULL),
 (4130, 0, '186.64.111.227', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-19 02:07:52', 'completed', '', NULL),
 (4131, 0, '207.46.13.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-19 02:58:45', 'completed', '', NULL),
 (4132, 0, '157.55.39.7', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-19 02:58:48', 'completed', '', NULL),
 (4133, 0, '5.196.87.173', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2130, 2133, '', '2017-06-19 03:35:05', 'completed', '', NULL),
 (4134, 0, '207.46.13.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-19 07:02:42', 'completed', '', NULL),
 (4135, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-19 07:57:35', 'completed', '', NULL),
 (4136, 0, '195.141.126.4', 'Mozilla/5.0 (compatible; localsearch-web/2.0; +http://www.localsearch.ch/en/legal-notice)', 2146, 2149, '', '2017-06-19 08:19:15', 'completed', '', NULL),
 (4137, 0, '5.196.87.172', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-06-19 09:49:32', 'completed', '', NULL),
 (4138, 0, '107.174.16.72', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-19 10:15:42', 'completed', '', NULL),
 (4139, 0, '194.209.188.212', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-06-19 10:23:37', 'completed', '', NULL),
 (4140, 0, '40.77.167.17', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-19 11:24:12', 'completed', '', NULL),
 (4141, 0, '83.76.130.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2128, 2367, '', '2017-06-19 12:00:40', 'completed', '', NULL),
 (4142, 0, '83.76.130.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2 like Mac OS X) AppleWebKit/602.3.12 (KHTML, like Gecko) Version/10.0 Mobile/14C92 Safari/602.1', 2333, 2334, '', '2017-06-19 12:01:43', 'completed', '', NULL),
 (4143, 0, '85.2.187.223', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2342, 2349, '', '2017-06-19 14:54:44', 'completed', '', NULL),
 (4144, 0, '145.250.209.1', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-06-19 16:02:19', 'completed', '', NULL),
 (4145, 0, '89.123.16.24', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-19 16:13:25', 'completed', '', NULL),
 (4146, 0, '157.55.39.206', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-19 17:29:51', 'completed', '', NULL),
 (4147, 0, '199.30.25.58', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-19 20:39:59', 'completed', '', NULL),
 (4148, 0, '37.11.109.188', 'Java/1.8.0_77', 2128, 2367, '', '2017-06-20 00:12:58', 'completed', '', NULL),
 (4149, 0, '37.11.109.188', 'Java/1.8.0_77', 2146, 2149, '', '2017-06-20 00:13:01', 'completed', '', NULL),
 (4150, 0, '37.11.109.188', 'Java/1.8.0_77', 2333, 2334, '', '2017-06-20 00:13:03', 'completed', '', NULL),
 (4151, 0, '37.11.109.188', 'Java/1.8.0_77', 2140, 2141, '', '2017-06-20 00:13:15', 'completed', '', NULL),
 (4152, 0, '37.11.109.188', 'Java/1.8.0_77', 2336, 2337, '', '2017-06-20 00:13:20', 'completed', '', NULL),
 (4153, 0, '37.11.109.188', 'Java/1.8.0_77', 1837, 1839, '', '2017-06-20 00:13:27', 'completed', '', NULL),
 (4154, 0, '37.11.109.188', 'Java/1.8.0_77', 1844, 1845, '', '2017-06-20 00:13:30', 'completed', '', NULL),
 (4155, 0, '37.11.109.188', 'Java/1.8.0_77', 2339, 2340, '', '2017-06-20 00:13:33', 'completed', '', NULL),
 (4156, 0, '37.11.109.188', 'Java/1.8.0_77', 2130, 2133, '', '2017-06-20 00:13:39', 'completed', '', NULL),
 (4157, 0, '37.11.109.188', 'Java/1.8.0_77', 2134, 2307, '', '2017-06-20 00:13:45', 'completed', '', NULL),
 (4158, 0, '37.11.109.188', 'Java/1.8.0_77', 2161, 2162, '', '2017-06-20 00:13:51', 'completed', '', NULL),
 (4159, 0, '37.11.109.188', 'Java/1.8.0_77', 2342, 2349, '', '2017-06-20 00:13:59', 'completed', '', NULL),
 (4160, 0, '89.123.16.24', 'Java/1.6.0_04', 2130, 2133, '', '2017-06-20 02:57:30', 'completed', '', NULL),
 (4161, 0, '89.123.16.24', 'Java/1.6.0_04', 2134, 2307, '', '2017-06-20 02:57:34', 'completed', '', NULL),
 (4162, 0, '68.180.228.23', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2130, 2133, '', '2017-06-20 03:50:37', 'completed', '', NULL),
 (4163, 0, '5.196.87.175', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-06-20 04:16:18', 'completed', '', NULL),
 (4164, 0, '217.182.132.157', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-06-20 08:23:00', 'completed', '', NULL),
 (4165, 0, '129.132.81.6', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-06-20 11:32:47', 'completed', '', NULL),
 (4166, 0, '40.77.167.17', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-20 16:18:46', 'completed', '', NULL),
 (4167, 0, '157.55.39.169', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-20 18:05:04', 'completed', '', NULL),
 (4168, 0, '207.46.13.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-21 02:34:21', 'completed', '', NULL),
 (4169, 0, '85.2.164.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2146, 2149, '', '2017-06-21 08:56:26', 'completed', '', NULL),
 (4170, 0, '85.2.164.130', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2128, 2367, '', '2017-06-21 08:56:50', 'completed', '', NULL),
 (4171, 0, '146.148.64.128', 'ltx71 - (http://ltx71.com/)', 2128, 2367, '', '2017-06-21 09:30:52', 'completed', '', NULL),
 (4172, 0, '207.46.13.112', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-21 10:14:03', 'completed', '', NULL),
 (4173, 0, '207.46.13.112', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-21 10:27:54', 'completed', '', NULL),
 (4174, 0, '188.154.10.131', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv:48.0) Gecko/20100101 Firefox/48.0', 2342, 2349, '', '2017-06-21 10:40:51', 'completed', '', NULL),
 (4175, 0, '62.167.68.57', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-06-21 11:33:11', 'completed', '', NULL),
 (4176, 0, '62.167.68.57', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-06-21 11:36:46', 'completed', '', NULL),
 (4177, 0, '164.132.161.74', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2130, 2133, '', '2017-06-21 12:03:46', 'completed', '', NULL),
 (4178, 0, '157.55.39.239', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-21 12:22:07', 'completed', '', NULL),
 (4179, 0, '178.83.82.204', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2339, 2340, '', '2017-06-21 17:38:56', 'completed', '', NULL),
 (4180, 0, '178.83.82.204', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 1844, 1845, '', '2017-06-21 17:41:13', 'completed', '', NULL),
 (4181, 0, '40.77.167.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-21 18:20:47', 'completed', '', NULL),
 (4182, 0, '157.55.39.239', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-21 18:54:26', 'completed', '', NULL),
 (4183, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-21 19:06:20', 'completed', '', NULL),
 (4184, 0, '181.41.204.175', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-21 19:23:28', 'completed', '', NULL),
 (4185, 0, '83.79.254.68', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.1.50 (KHTML, like Gecko) Version/10.0 Safari/602.1.50', 2128, 2367, '', '2017-06-21 19:29:07', 'completed', '', NULL),
 (4186, 0, '199.30.25.77', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-21 21:00:55', 'completed', '', NULL),
 (4187, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2134, 2307, '', '2017-06-21 22:28:36', 'completed', '', NULL),
 (4188, 0, '85.7.219.140', 'Mozilla/5.0 (iPad; CPU OS 10_3 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E277 Safari/602.1', 2342, 2349, '', '2017-06-21 22:28:37', 'completed', '', NULL),
 (4189, 0, '207.46.13.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-22 06:07:46', 'completed', '', NULL),
 (4190, 0, '40.77.167.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-22 06:25:28', 'completed', '', NULL),
 (4191, 0, '188.60.76.251', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-T810 Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.2 Chrome/51.0.2704.106 Safari/537.36', 2336, 2337, '', '2017-06-22 07:39:33', 'completed', '', NULL),
 (4192, 0, '194.230.155.115', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-22 09:30:15', 'completed', '', NULL),
 (4193, 0, '194.230.155.115', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1837, 1839, '', '2017-06-22 09:37:34', 'completed', '', NULL),
 (4194, 0, '194.230.155.115', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-06-22 09:37:39', 'completed', '', NULL),
 (4195, 0, '194.230.155.115', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-06-22 09:46:16', 'completed', '', NULL),
 (4196, 0, '192.99.79.240', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-22 10:53:07', 'completed', '', NULL),
 (4197, 0, '192.99.79.240', 'Java/1.6.0_04', 2146, 2149, '', '2017-06-22 10:53:09', 'completed', '', NULL),
 (4198, 0, '192.99.79.240', 'Java/1.6.0_04', 2333, 2334, '', '2017-06-22 10:53:11', 'completed', '', NULL),
 (4199, 0, '192.99.79.240', 'Java/1.6.0_04', 2140, 2141, '', '2017-06-22 10:53:15', 'completed', '', NULL),
 (4200, 0, '192.99.79.240', 'Java/1.6.0_04', 2336, 2337, '', '2017-06-22 10:53:17', 'completed', '', NULL),
 (4201, 0, '192.99.79.240', 'Java/1.6.0_04', 1837, 1839, '', '2017-06-22 10:53:19', 'completed', '', NULL),
 (4202, 0, '192.99.79.240', 'Java/1.6.0_04', 1844, 1845, '', '2017-06-22 10:53:21', 'completed', '', NULL),
 (4203, 0, '192.99.79.240', 'Java/1.6.0_04', 2339, 2340, '', '2017-06-22 10:53:22', 'completed', '', NULL),
 (4204, 0, '192.99.79.240', 'Java/1.6.0_04', 2130, 2133, '', '2017-06-22 10:53:25', 'completed', '', NULL),
 (4205, 0, '192.99.79.240', 'Java/1.6.0_04', 2134, 2307, '', '2017-06-22 10:53:27', 'completed', '', NULL),
 (4206, 0, '192.99.79.240', 'Java/1.6.0_04', 2161, 2162, '', '2017-06-22 10:53:30', 'completed', '', NULL),
 (4207, 0, '192.99.79.240', 'Java/1.6.0_04', 2342, 2349, '', '2017-06-22 10:53:33', 'completed', '', NULL),
 (4208, 0, '188.155.230.54', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2146, 2149, '', '2017-06-22 11:51:15', 'completed', '', NULL),
 (4209, 0, '40.77.167.53', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-22 13:05:31', 'completed', '', NULL),
 (4210, 0, '62.202.25.191', 'Mozilla/5.0 (X11; Linux x86_64; rv:54.0) Gecko/20100101 Firefox/54.0', 2134, 2307, '', '2017-06-22 14:03:20', 'completed', '', NULL),
 (4211, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-22 15:29:37', 'completed', '', NULL),
 (4212, 0, '40.77.167.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-22 22:51:07', 'completed', '', NULL),
 (4213, 0, '207.46.13.189', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-23 02:16:34', 'completed', '', NULL),
 (4214, 0, '40.77.167.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-23 05:01:56', 'completed', '', NULL),
 (4215, 0, '207.46.13.183', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-23 06:09:07', 'completed', '', NULL),
 (4216, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-23 06:14:03', 'completed', '', NULL),
 (4217, 0, '178.192.196.228', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-23 07:00:40', 'completed', '', NULL),
 (4218, 0, '207.46.13.112', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-23 08:52:32', 'completed', '', NULL),
 (4219, 0, '74.208.83.209', 'Java/1.8.0_131', 2128, 2367, '', '2017-06-23 15:40:48', 'completed', '', NULL),
 (4220, 0, '84.226.105.32', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G930F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.0 Chrome/51.0.2704.106 Mobile Safari/537.36', 2146, 2149, '', '2017-06-23 17:33:33', 'completed', '', NULL),
 (4221, 0, '84.226.105.32', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G930F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.0 Chrome/51.0.2704.106 Mobile Safari/537.36', 2336, 2337, '', '2017-06-23 17:33:38', 'completed', '', NULL),
 (4222, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 1837, 1839, '', '2017-06-23 17:45:44', 'completed', '', NULL),
 (4223, 0, '40.77.167.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-23 17:46:48', 'completed', '', NULL),
 (4224, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 1837, 1839, '', '2017-06-23 17:53:52', 'completed', '', NULL),
 (4225, 0, '46.127.1.62', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2128, 2367, '', '2017-06-23 17:55:41', 'completed', '', NULL),
 (4226, 0, '40.77.167.8', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-23 18:06:17', 'completed', '', NULL),
 (4227, 0, '146.148.64.128', 'ltx71 - (http://ltx71.com/)', 2140, 2141, '', '2017-06-23 18:31:20', 'completed', '', NULL),
 (4228, 0, '40.77.177.230', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-23 19:07:57', 'completed', '', NULL),
 (4229, 0, '176.127.23.22', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2017-06-23 19:51:21', 'completed', '', NULL),
 (4230, 0, '209.90.232.11', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-23 20:36:03', 'completed', '', NULL),
 (4231, 0, '84.227.43.107', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-06-24 07:06:44', 'completed', '', NULL),
 (4232, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-24 07:38:31', 'completed', '', NULL),
 (4233, 0, '179.43.145.236', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-24 07:44:03', 'completed', '', NULL),
 (4234, 0, '164.132.162.153', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-06-24 09:38:04', 'completed', '', NULL),
 (4235, 0, '68.180.229.223', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2140, 2141, '', '2017-06-24 09:56:03', 'completed', '', NULL),
 (4236, 0, '68.180.229.36', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2339, 2340, '', '2017-06-24 12:07:09', 'completed', '', NULL),
 (4237, 0, '68.180.229.36', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2128, 2367, '', '2017-06-24 12:43:31', 'completed', '', NULL),
 (4238, 0, '40.77.167.8', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-24 16:58:28', 'completed', '', NULL),
 (4239, 0, '178.195.98.217', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2336, 2337, '', '2017-06-24 17:16:43', 'completed', '', NULL),
 (4240, 0, '178.195.98.217', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2146, 2149, '', '2017-06-24 17:22:15', 'completed', '', NULL),
 (4241, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-24 19:22:19', 'completed', '', NULL),
 (4242, 0, '157.55.39.245', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-24 22:29:40', 'completed', '', NULL),
 (4243, 0, '51.255.65.30', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-06-25 03:12:51', 'completed', '', NULL),
 (4244, 0, '40.77.167.8', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-25 03:28:56', 'completed', '', NULL),
 (4245, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-25 05:05:02', 'completed', '', NULL),
 (4246, 0, '157.55.39.245', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-25 05:25:49', 'completed', '', NULL),
 (4247, 0, '40.77.167.0', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-25 07:44:04', 'completed', '', NULL),
 (4248, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-25 09:53:00', 'completed', '', NULL),
 (4249, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-25 10:50:21', 'completed', '', NULL),
 (4250, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2128, 2367, '', '2017-06-25 10:51:02', 'completed', '', NULL),
 (4251, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-25 10:51:16', 'completed', '', NULL),
 (4252, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-06-25 10:51:21', 'completed', '', NULL),
 (4253, 0, '149.202.7.207', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-25 11:25:44', 'completed', '', NULL),
 (4254, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-06-25 13:59:31', 'completed', '', NULL),
 (4255, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-06-25 14:00:05', 'completed', '', NULL),
 (4256, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-06-25 14:02:19', 'completed', '', NULL),
 (4257, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1837, 1839, '', '2017-06-25 14:02:35', 'completed', '', NULL),
 (4258, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-25 14:02:58', 'completed', '', NULL),
 (4259, 0, '40.77.167.8', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-25 17:25:37', 'completed', '', NULL),
 (4260, 0, '199.30.24.106', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-25 18:27:35', 'completed', '', NULL),
 (4261, 0, '82.192.229.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-06-25 18:46:51', 'completed', '', NULL),
 (4262, 0, '5.144.15.22', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-06-25 21:58:52', 'completed', '', NULL),
 (4263, 0, '157.55.39.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-26 04:39:31', 'completed', '', NULL),
 (4264, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-06-26 05:33:42', 'completed', '', NULL),
 (4265, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-06-26 05:33:48', 'completed', '', NULL),
 (4266, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-06-26 05:33:53', 'completed', '', NULL),
 (4267, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-06-26 05:34:13', 'completed', '', NULL),
 (4268, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-06-26 05:34:18', 'completed', '', NULL),
 (4269, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-06-26 05:34:24', 'completed', '', NULL),
 (4270, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-06-26 05:34:28', 'completed', '', NULL),
 (4271, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-06-26 05:34:59', 'completed', '', NULL),
 (4272, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-06-26 05:35:03', 'completed', '', NULL),
 (4273, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-06-26 05:35:38', 'completed', '', NULL),
 (4274, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-06-26 05:35:43', 'completed', '', NULL),
 (4275, 0, '159.203.160.202', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-06-26 05:35:48', 'completed', '', NULL),
 (4276, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-26 11:10:31', 'completed', '', NULL),
 (4277, 0, '40.77.167.0', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-26 12:36:04', 'completed', '', NULL),
 (4278, 0, '40.77.167.0', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-26 15:11:36', 'completed', '', NULL),
 (4279, 0, '178.197.230.165', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G800F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2130, 2133, '', '2017-06-26 15:59:52', 'completed', '', NULL),
 (4280, 0, '178.197.230.165', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-G800F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.83 Mobile Safari/537.36', 2134, 2307, '', '2017-06-26 16:00:41', 'completed', '', NULL),
 (4281, 0, '157.55.39.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-26 17:33:06', 'completed', '', NULL),
 (4282, 0, '92.104.172.16', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2146, 2149, '', '2017-06-26 20:56:31', 'completed', '', NULL),
 (4283, 0, '157.55.39.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-26 22:26:38', 'completed', '', NULL),
 (4284, 0, '217.162.245.54', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2339, 2340, '', '2017-06-26 22:50:42', 'completed', '', NULL),
 (4285, 0, '217.162.245.54', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 1837, 1839, '', '2017-06-26 22:52:37', 'completed', '', NULL),
 (4286, 0, '217.162.245.54', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_4) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.1 Safari/603.1.30', 2339, 2340, '', '2017-06-26 23:25:13', 'completed', '', NULL),
 (4287, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-27 02:41:29', 'completed', '', NULL),
 (4288, 0, '185.29.10.71', 'Java/1.8.0_131', 2128, 2367, '', '2017-06-27 03:11:51', 'completed', '', NULL),
 (4289, 0, '157.55.39.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-27 04:57:38', 'completed', '', NULL),
 (4290, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-27 05:08:22', 'completed', '', NULL),
 (4291, 0, '157.55.39.180', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-27 05:13:34', 'completed', '', NULL),
 (4292, 0, '157.55.39.174', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-27 08:01:17', 'completed', '', NULL),
 (4293, 0, '37.11.11.42', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-27 11:40:01', 'completed', '', NULL),
 (4294, 0, '83.79.191.91', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:54.0) Gecko/54.0 Firefox/54.0', 2140, 2141, '', '2017-06-27 13:33:45', 'completed', '', NULL),
 (4295, 0, '85.5.182.179', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-06-27 13:34:28', 'completed', '', NULL),
 (4296, 0, '81.62.96.214', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2342, 2349, '', '2017-06-27 13:45:16', 'completed', '', NULL),
 (4297, 0, '37.11.11.42', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-27 19:39:30', 'completed', '', NULL),
 (4298, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2134, 2307, '', '2017-06-27 22:59:29', 'completed', '', NULL),
 (4299, 0, '157.55.39.151', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-28 07:57:14', 'completed', '', NULL),
 (4300, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2336, 2337, '', '2017-06-28 11:22:22', 'completed', '', NULL),
 (4301, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2140, 2141, '', '2017-06-28 11:23:06', 'completed', '', NULL),
 (4302, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2140, 2141, '', '2017-06-28 11:26:35', 'completed', '', NULL),
 (4303, 0, '62.202.189.251', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 1844, 1845, '', '2017-06-28 11:37:57', 'completed', '', NULL),
 (4304, 0, '217.11.41.10', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-06-28 13:59:01', 'completed', '', NULL),
 (4305, 0, '176.86.140.113', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-28 14:14:21', 'completed', '', NULL),
 (4306, 0, '207.46.13.4', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-28 15:37:51', 'completed', '', NULL),
 (4307, 0, '157.55.39.255', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-06-28 16:03:25', 'completed', '', NULL),
 (4308, 0, '81.62.77.93', 'Mozilla/5.0 (Linux; Android 5.0.1; SAMSUNG GT-I9505 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 2333, 2334, '', '2017-06-28 16:14:19', 'completed', '', NULL),
 (4309, 0, '40.77.167.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-06-28 18:09:49', 'completed', '', NULL),
 (4310, 0, '207.46.13.4', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-06-28 18:25:30', 'completed', '', NULL),
 (4311, 0, '40.77.167.30', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-06-28 23:13:14', 'completed', '', NULL),
 (4312, 0, '40.77.167.100', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-29 02:33:14', 'completed', '', NULL),
 (4313, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-06-29 03:05:00', 'completed', '', NULL),
 (4314, 0, '212.83.130.164', 'Java/1.6.0_04', 2128, 2367, '', '2017-06-29 03:36:54', 'completed', '', NULL),
 (4315, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-06-29 05:28:32', 'completed', '', NULL),
 (4316, 0, '31.165.30.126', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2130, 2133, '', '2017-06-29 06:07:36', 'completed', '', NULL),
 (4317, 0, '62.202.221.132', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2336, 2337, '', '2017-06-29 07:34:04', 'completed', '', NULL),
 (4318, 0, '40.77.167.48', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-06-29 08:25:48', 'completed', '', NULL),
 (4319, 0, '40.77.167.100', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-06-29 08:25:52', 'completed', '', NULL),
 (4320, 0, '207.46.13.21', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-06-29 08:27:03', 'completed', '', NULL),
 (4321, 0, '81.62.69.106', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36', 2336, 2337, '', '2017-06-29 09:00:12', 'completed', '', NULL),
 (4322, 0, '80.110.119.117', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-06-29 14:06:17', 'completed', '', NULL),
 (4323, 0, '80.110.119.117', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2336, 2337, '', '2017-06-29 14:06:20', 'completed', '', NULL),
 (4324, 0, '40.77.167.48', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-06-29 17:26:49', 'completed', '', NULL),
 (4325, 0, '51.255.65.73', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2140, 2141, '', '2017-06-29 18:45:15', 'completed', '', NULL),
 (4326, 0, '65.55.210.187', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-06-29 20:26:01', 'completed', '', NULL),
 (4327, 0, '83.77.41.89', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2128, 2367, '', '2017-06-29 21:25:42', 'completed', '', NULL),
 (4328, 0, '83.77.41.89', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 1837, 1839, '', '2017-06-29 21:27:09', 'completed', '', NULL),
 (4329, 0, '207.46.13.46', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-06-30 03:52:24', 'completed', '', NULL),
 (4330, 0, '207.46.13.46', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-06-30 04:48:54', 'completed', '', NULL),
 (4331, 0, '186.64.111.227', 'Java/1.4.1_04', 2128, 2367, '', '2017-06-30 08:51:51', 'completed', '', NULL),
 (4332, 0, '186.64.111.227', 'Java/1.4.1_04', 2146, 2149, '', '2017-06-30 08:51:54', 'completed', '', NULL),
 (4333, 0, '186.64.111.227', 'Java/1.4.1_04', 2333, 2334, '', '2017-06-30 08:51:55', 'completed', '', NULL),
 (4334, 0, '186.64.111.227', 'Java/1.4.1_04', 2140, 2141, '', '2017-06-30 08:52:03', 'completed', '', NULL),
 (4335, 0, '186.64.111.227', 'Java/1.4.1_04', 2336, 2337, '', '2017-06-30 08:52:07', 'completed', '', NULL),
 (4336, 0, '186.64.111.227', 'Java/1.4.1_04', 1837, 1839, '', '2017-06-30 08:52:11', 'completed', '', NULL),
 (4337, 0, '186.64.111.227', 'Java/1.4.1_04', 1844, 1845, '', '2017-06-30 08:52:13', 'completed', '', NULL),
 (4338, 0, '186.64.111.227', 'Java/1.4.1_04', 2339, 2340, '', '2017-06-30 08:52:15', 'completed', '', NULL),
 (4339, 0, '186.64.111.227', 'Java/1.4.1_04', 2130, 2133, '', '2017-06-30 08:52:20', 'completed', '', NULL),
 (4340, 0, '186.64.111.227', 'Java/1.4.1_04', 2134, 2307, '', '2017-06-30 08:52:25', 'completed', '', NULL),
 (4341, 0, '186.64.111.227', 'Java/1.4.1_04', 2161, 2162, '', '2017-06-30 08:52:40', 'completed', '', NULL),
 (4342, 0, '186.64.111.227', 'Java/1.4.1_04', 2342, 2349, '', '2017-06-30 08:52:55', 'completed', '', NULL),
 (4343, 0, '31.24.14.145', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-A320FL Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 2140, 2141, '', '2017-06-30 10:44:38', 'completed', '', NULL),
 (4344, 0, '185.29.9.63', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-01 17:02:33', 'completed', '', NULL),
 (4345, 0, '185.29.9.63', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-01 17:03:09', 'completed', '', NULL),
 (4346, 0, '185.29.9.63', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-01 17:03:10', 'completed', '', NULL),
 (4347, 0, '185.29.9.63', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-01 17:03:21', 'completed', '', NULL),
 (4348, 0, '185.29.9.63', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-01 17:03:28', 'completed', '', NULL),
 (4349, 0, '185.29.9.63', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-01 17:03:39', 'completed', '', NULL),
 (4350, 0, '185.29.9.63', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-01 17:03:43', 'completed', '', NULL),
 (4351, 0, '185.29.9.63', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-01 17:03:58', 'completed', '', NULL),
 (4352, 0, '185.29.9.63', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-01 17:04:04', 'completed', '', NULL),
 (4353, 0, '185.29.9.63', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-01 17:04:12', 'completed', '', NULL),
 (4354, 0, '185.29.9.63', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-01 17:04:17', 'completed', '', NULL),
 (4355, 0, '185.29.9.63', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-01 17:04:23', 'completed', '', NULL),
 (4356, 0, '178.82.117.149', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G800F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 1844, 1845, '', '2017-07-01 19:53:19', 'completed', '', NULL),
 (4357, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-07-02 00:04:30', 'completed', '', NULL),
 (4358, 0, '178.193.89.207', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 1844, 1845, '', '2017-07-02 00:28:54', 'completed', '', NULL),
 (4359, 0, '178.193.89.207', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 1837, 1839, '', '2017-07-02 00:29:25', 'completed', '', NULL),
 (4360, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-02 09:14:10', 'completed', '', NULL),
 (4361, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-07-02 11:36:27', 'completed', '', NULL),
 (4362, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-07-02 13:44:02', 'completed', '', NULL),
 (4363, 0, '178.83.54.146', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2128, 2367, '', '2017-07-02 16:46:16', 'completed', '', NULL),
 (4364, 0, '178.83.54.146', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 1844, 1845, '', '2017-07-02 16:47:43', 'completed', '', NULL),
 (4365, 0, '178.83.54.146', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2339, 2340, '', '2017-07-02 16:47:55', 'completed', '', NULL),
 (4366, 0, '178.198.232.148', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MAARJS; rv:11.0) like Gecko', 2333, 2334, '', '2017-07-02 18:00:05', 'completed', '', NULL),
 (4367, 0, '178.198.232.148', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; MAARJS; rv:11.0) like Gecko', 2128, 2367, '', '2017-07-02 18:06:11', 'completed', '', NULL),
 (4368, 0, '188.62.105.42', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-02 20:43:46', 'completed', '', NULL),
 (4369, 0, '188.62.105.42', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-02 21:04:23', 'completed', '', NULL),
 (4370, 0, '188.62.105.42', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-07-02 21:08:27', 'completed', '', NULL),
 (4371, 0, '91.138.6.32', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:54.0) Gecko/20100101 Firefox/54.0', 2146, 2149, '', '2017-07-02 21:12:16', 'completed', '', NULL),
 (4372, 0, '188.62.105.42', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-07-02 21:17:10', 'completed', '', NULL),
 (4373, 0, '188.62.105.42', 'Mozilla/5.0 (iPad; CPU OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2339, 2340, '', '2017-07-02 21:20:08', 'completed', '', NULL),
 (4374, 0, '31.24.13.78', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-02 21:35:36', 'completed', '', NULL),
 (4375, 0, '31.24.13.78', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-07-02 21:35:56', 'completed', '', NULL),
 (4376, 0, '84.226.141.13', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:54.0) Gecko/54.0 Firefox/54.0', 2134, 2307, '', '2017-07-02 21:43:43', 'completed', '', NULL),
 (4377, 0, '84.226.141.13', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:54.0) Gecko/54.0 Firefox/54.0', 2146, 2149, '', '2017-07-02 21:44:13', 'completed', '', NULL),
 (4378, 0, '84.226.141.13', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:54.0) Gecko/54.0 Firefox/54.0', 2130, 2133, '', '2017-07-02 21:44:18', 'completed', '', NULL),
 (4379, 0, '84.226.141.13', 'Mozilla/5.0 (Android 6.0.1; Mobile; rv:54.0) Gecko/54.0 Firefox/54.0', 2146, 2149, '', '2017-07-02 21:44:23', 'completed', '', NULL),
 (4380, 0, '185.64.196.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2134, 2307, '', '2017-07-02 22:37:39', 'completed', '', NULL),
 (4381, 0, '185.64.196.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2342, 2349, '', '2017-07-02 22:39:13', 'completed', '', NULL),
 (4382, 0, '185.64.196.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2130, 2133, '', '2017-07-02 22:39:33', 'completed', '', NULL),
 (4383, 0, '185.64.196.174', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2134, 2307, '', '2017-07-02 22:40:01', 'completed', '', NULL),
 (4384, 0, '176.127.140.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-02 22:44:30', 'completed', '', NULL),
 (4385, 0, '84.226.255.110', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-07-02 23:54:37', 'completed', '', NULL),
 (4386, 0, '84.226.255.110', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2336, 2337, '', '2017-07-02 23:54:43', 'completed', '', NULL),
 (4387, 0, '84.226.255.110', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2146, 2149, '', '2017-07-02 23:54:49', 'completed', '', NULL),
 (4388, 0, '178.197.227.121', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-03 08:08:48', 'completed', '', NULL),
 (4389, 0, '185.64.196.150', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2134, 2307, '', '2017-07-03 08:20:14', 'completed', '', NULL),
 (4390, 0, '185.64.196.150', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2342, 2349, '', '2017-07-03 08:25:30', 'completed', '', NULL),
 (4391, 0, '217.112.98.164', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-03 10:37:30', 'completed', '', NULL),
 (4392, 0, '178.197.226.50', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2339, 2340, '', '2017-07-03 11:28:13', 'completed', '', NULL),
 (4393, 0, '178.197.226.50', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2339, 2340, '', '2017-07-03 11:31:16', 'completed', '', NULL),
 (4394, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-07-03 12:48:47', 'completed', '', NULL),
 (4395, 0, '62.202.191.103', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2130, 2133, '', '2017-07-03 13:50:44', 'completed', '', NULL),
 (4396, 0, '62.202.191.103', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2134, 2307, '', '2017-07-03 13:51:32', 'completed', '', NULL),
 (4397, 0, '193.134.10.34', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0', 2339, 2340, '', '2017-07-03 14:21:34', 'completed', '', NULL),
 (4398, 0, '178.197.230.9', 'Mozilla/5.0 (Linux; U; Android 4.3; de-ch; GT-I9300 Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', 2130, 2133, '', '2017-07-03 16:12:25', 'completed', '', NULL),
 (4399, 0, '178.197.230.9', 'Mozilla/5.0 (Linux; U; Android 4.3; de-ch; GT-I9300 Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', 2130, 2133, '', '2017-07-03 16:16:20', 'completed', '', NULL),
 (4400, 0, '178.197.230.9', 'Mozilla/5.0 (Linux; U; Android 4.3; de-ch; GT-I9300 Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', 2134, 2307, '', '2017-07-03 16:17:35', 'completed', '', NULL),
 (4401, 0, '178.197.230.9', 'Mozilla/5.0 (Linux; U; Android 4.3; de-ch; GT-I9300 Build/JSS15J) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30', 2146, 2149, '', '2017-07-03 16:22:31', 'completed', '', NULL),
 (4402, 0, '104.238.195.195', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-04 03:13:43', 'completed', '', NULL),
 (4403, 0, '104.238.195.195', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-04 03:13:44', 'completed', '', NULL),
 (4404, 0, '104.238.195.195', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-04 03:13:46', 'completed', '', NULL),
 (4405, 0, '104.238.195.195', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-04 03:13:50', 'completed', '', NULL),
 (4406, 0, '104.238.195.195', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-04 03:13:52', 'completed', '', NULL),
 (4407, 0, '104.238.195.195', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-04 03:13:55', 'completed', '', NULL),
 (4408, 0, '104.238.195.195', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-04 03:13:56', 'completed', '', NULL),
 (4409, 0, '104.238.195.195', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-04 03:13:58', 'completed', '', NULL),
 (4410, 0, '104.238.195.195', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-04 03:14:01', 'completed', '', NULL),
 (4411, 0, '104.238.195.195', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-04 03:14:03', 'completed', '', NULL),
 (4412, 0, '104.238.195.195', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-04 03:14:08', 'completed', '', NULL),
 (4413, 0, '104.238.195.195', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-04 03:14:12', 'completed', '', NULL),
 (4414, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2161, 2162, '', '2017-07-04 07:57:41', 'completed', '', NULL),
 (4415, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2342, 2349, '', '2017-07-04 07:57:45', 'completed', '', NULL),
 (4416, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2134, 2307, '', '2017-07-04 07:57:49', 'completed', '', NULL),
 (4417, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2146, 2149, '', '2017-07-04 07:57:53', 'completed', '', NULL),
 (4418, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2130, 2133, '', '2017-07-04 07:57:57', 'completed', '', NULL),
 (4419, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2339, 2340, '', '2017-07-04 07:59:14', 'completed', '', NULL),
 (4420, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 1844, 1845, '', '2017-07-04 07:59:18', 'completed', '', NULL),
 (4421, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 1837, 1839, '', '2017-07-04 07:59:22', 'completed', '', NULL),
 (4422, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2336, 2337, '', '2017-07-04 07:59:26', 'completed', '', NULL),
 (4423, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2140, 2141, '', '2017-07-04 07:59:30', 'completed', '', NULL),
 (4424, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2333, 2334, '', '2017-07-04 07:59:39', 'completed', '', NULL),
 (4425, 0, '136.243.155.93', 'Mozilla/5.0 (compatible; SEOkicks-Robot; +http://www.seokicks.de/robot.html)', 2128, 2367, '', '2017-07-04 07:59:44', 'completed', '', NULL),
 (4426, 0, '217.182.132.193', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1844, 1845, '', '2017-07-04 15:53:56', 'completed', '', NULL),
 (4427, 0, '31.10.132.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-07-04 16:31:49', 'completed', '', NULL),
 (4428, 0, '31.10.132.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-04 16:33:31', 'completed', '', NULL),
 (4429, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-07-04 17:31:16', 'completed', '', NULL),
 (4430, 0, '95.149.249.160', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-04 18:05:18', 'completed', '', NULL),
 (4431, 0, '95.149.249.160', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-04 18:05:20', 'completed', '', NULL),
 (4432, 0, '95.149.249.160', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-04 18:05:21', 'completed', '', NULL),
 (4433, 0, '95.149.249.160', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-04 18:05:25', 'completed', '', NULL),
 (4434, 0, '95.149.249.160', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-04 18:05:27', 'completed', '', NULL),
 (4435, 0, '95.149.249.160', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-04 18:05:29', 'completed', '', NULL),
 (4436, 0, '95.149.249.160', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-04 18:05:31', 'completed', '', NULL),
 (4437, 0, '95.149.249.160', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-04 18:05:33', 'completed', '', NULL),
 (4438, 0, '95.149.249.160', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-04 18:05:35', 'completed', '', NULL),
 (4439, 0, '95.149.249.160', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-04 18:05:39', 'completed', '', NULL),
 (4440, 0, '95.149.249.160', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-04 18:05:41', 'completed', '', NULL),
 (4441, 0, '95.149.249.160', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-04 18:05:45', 'completed', '', NULL),
 (4442, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-07-04 19:13:18', 'completed', '', NULL),
 (4443, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-07-05 05:21:55', 'completed', '', NULL),
 (4444, 0, '89.123.5.73', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-05 07:18:36', 'completed', '', NULL),
 (4445, 0, '89.123.5.73', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-05 07:18:37', 'completed', '', NULL),
 (4446, 0, '89.123.5.73', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-05 07:18:38', 'completed', '', NULL),
 (4447, 0, '89.123.5.73', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-05 07:18:42', 'completed', '', NULL),
 (4448, 0, '89.123.5.73', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-05 07:18:44', 'completed', '', NULL),
 (4449, 0, '89.123.5.73', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-05 07:18:47', 'completed', '', NULL),
 (4450, 0, '89.123.5.73', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-05 07:18:49', 'completed', '', NULL),
 (4451, 0, '89.123.5.73', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-05 07:18:50', 'completed', '', NULL),
 (4452, 0, '89.123.5.73', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-05 07:18:54', 'completed', '', NULL),
 (4453, 0, '89.123.5.73', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-05 07:18:56', 'completed', '', NULL),
 (4454, 0, '89.123.5.73', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-05 07:19:00', 'completed', '', NULL),
 (4455, 0, '89.123.5.73', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-05 07:19:02', 'completed', '', NULL),
 (4456, 0, '31.10.132.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-05 07:55:55', 'completed', '', NULL),
 (4457, 0, '23.249.166.166', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-05 13:01:18', 'completed', '', NULL),
 (4458, 0, '23.249.166.166', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-05 13:01:22', 'completed', '', NULL),
 (4459, 0, '23.249.166.166', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-05 13:01:27', 'completed', '', NULL),
 (4460, 0, '23.249.166.166', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-05 13:01:40', 'completed', '', NULL),
 (4461, 0, '23.249.166.166', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-05 13:01:43', 'completed', '', NULL),
 (4462, 0, '23.249.166.166', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-05 13:01:48', 'completed', '', NULL),
 (4463, 0, '23.249.166.166', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-05 13:01:52', 'completed', '', NULL),
 (4464, 0, '23.249.166.166', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-05 13:01:58', 'completed', '', NULL),
 (4465, 0, '23.249.166.166', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-05 13:02:12', 'completed', '', NULL),
 (4466, 0, '23.249.166.166', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-05 13:02:17', 'completed', '', NULL),
 (4467, 0, '23.249.166.166', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-05 13:02:21', 'completed', '', NULL),
 (4468, 0, '23.249.166.166', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-05 13:02:32', 'completed', '', NULL),
 (4469, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-07-05 13:57:42', 'completed', '', NULL),
 (4470, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-07-05 15:56:16', 'completed', '', NULL),
 (4471, 0, '37.11.10.36', 'Java/1.8.0_60', 2128, 2367, '', '2017-07-05 15:58:18', 'completed', '', NULL),
 (4472, 0, '37.11.10.36', 'Java/1.8.0_60', 2146, 2149, '', '2017-07-05 15:58:23', 'completed', '', NULL),
 (4473, 0, '37.11.10.36', 'Java/1.8.0_60', 2333, 2334, '', '2017-07-05 15:58:24', 'completed', '', NULL),
 (4474, 0, '37.11.10.36', 'Java/1.8.0_60', 2140, 2141, '', '2017-07-05 15:58:27', 'completed', '', NULL),
 (4475, 0, '37.11.10.36', 'Java/1.8.0_60', 2336, 2337, '', '2017-07-05 15:58:34', 'completed', '', NULL),
 (4476, 0, '62.2.210.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2146, 2149, '', '2017-07-05 15:58:37', 'completed', '', NULL),
 (4477, 0, '37.11.10.36', 'Java/1.8.0_60', 1837, 1839, '', '2017-07-05 15:58:37', 'completed', '', NULL),
 (4478, 0, '37.11.10.36', 'Java/1.8.0_60', 1844, 1845, '', '2017-07-05 15:58:39', 'completed', '', NULL),
 (4479, 0, '37.11.10.36', 'Java/1.8.0_60', 2339, 2340, '', '2017-07-05 15:58:42', 'completed', '', NULL),
 (4480, 0, '37.11.10.36', 'Java/1.8.0_60', 2130, 2133, '', '2017-07-05 15:58:47', 'completed', '', NULL),
 (4481, 0, '37.11.10.36', 'Java/1.8.0_60', 2134, 2307, '', '2017-07-05 15:58:49', 'completed', '', NULL),
 (4482, 0, '37.11.10.36', 'Java/1.8.0_60', 2161, 2162, '', '2017-07-05 15:58:55', 'completed', '', NULL),
 (4483, 0, '37.11.10.36', 'Java/1.8.0_60', 2342, 2349, '', '2017-07-05 15:58:58', 'completed', '', NULL),
 (4484, 0, '62.2.210.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2342, 2349, '', '2017-07-05 15:59:32', 'completed', '', NULL),
 (4485, 0, '62.2.210.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2130, 2133, '', '2017-07-05 16:13:23', 'completed', '', NULL),
 (4486, 0, '62.2.210.98', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', 2134, 2307, '', '2017-07-05 16:14:25', 'completed', '', NULL),
 (4487, 0, '185.114.193.99', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-05 17:27:54', 'completed', '', NULL),
 (4488, 0, '185.114.193.99', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-05 17:27:56', 'completed', '', NULL),
 (4489, 0, '185.114.193.99', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-05 17:27:57', 'completed', '', NULL),
 (4490, 0, '185.114.193.99', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-05 17:27:59', 'completed', '', NULL),
 (4491, 0, '185.114.193.99', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-05 17:28:01', 'completed', '', NULL),
 (4492, 0, '185.114.193.99', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-05 17:28:02', 'completed', '', NULL),
 (4493, 0, '185.114.193.99', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-05 17:28:03', 'completed', '', NULL),
 (4494, 0, '185.114.193.99', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-05 17:28:04', 'completed', '', NULL),
 (4495, 0, '185.114.193.99', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-05 17:28:07', 'completed', '', NULL),
 (4496, 0, '185.114.193.99', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-05 17:28:08', 'completed', '', NULL),
 (4497, 0, '185.114.193.99', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-05 17:28:10', 'completed', '', NULL),
 (4498, 0, '185.114.193.99', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-05 17:28:12', 'completed', '', NULL),
 (4499, 0, '90.77.145.248', 'Java/1.8.0_91', 2128, 2367, '', '2017-07-05 18:38:20', 'completed', '', NULL),
 (4500, 0, '90.77.145.248', 'Java/1.8.0_91', 2146, 2149, '', '2017-07-05 18:38:22', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(4501, 0, '90.77.145.248', 'Java/1.8.0_91', 2333, 2334, '', '2017-07-05 18:38:23', 'completed', '', NULL),
 (4502, 0, '90.77.145.248', 'Java/1.8.0_91', 2140, 2141, '', '2017-07-05 18:38:28', 'completed', '', NULL),
 (4503, 0, '90.77.145.248', 'Java/1.8.0_91', 2336, 2337, '', '2017-07-05 18:38:29', 'completed', '', NULL),
 (4504, 0, '90.77.145.248', 'Java/1.8.0_91', 1837, 1839, '', '2017-07-05 18:38:33', 'completed', '', NULL),
 (4505, 0, '90.77.145.248', 'Java/1.8.0_91', 1844, 1845, '', '2017-07-05 18:38:34', 'completed', '', NULL),
 (4506, 0, '90.77.145.248', 'Java/1.8.0_91', 2339, 2340, '', '2017-07-05 18:38:35', 'completed', '', NULL),
 (4507, 0, '90.77.145.248', 'Java/1.8.0_91', 2130, 2133, '', '2017-07-05 18:38:38', 'completed', '', NULL),
 (4508, 0, '90.77.145.248', 'Java/1.8.0_91', 2134, 2307, '', '2017-07-05 18:38:40', 'completed', '', NULL),
 (4509, 0, '90.77.145.248', 'Java/1.8.0_91', 2161, 2162, '', '2017-07-05 18:38:42', 'completed', '', NULL),
 (4510, 0, '90.77.145.248', 'Java/1.8.0_91', 2342, 2349, '', '2017-07-05 18:38:44', 'completed', '', NULL),
 (4511, 0, '178.194.91.37', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-05 21:25:35', 'completed', '', NULL),
 (4512, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2128, 2367, '', '2017-07-05 21:58:17', 'completed', '', NULL),
 (4513, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1837, 1839, '', '2017-07-05 22:00:02', 'completed', '', NULL),
 (4514, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-07-05 22:00:22', 'completed', '', NULL),
 (4515, 0, '188.62.232.66', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-05 22:00:45', 'completed', '', NULL),
 (4516, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-07-06 00:10:17', 'completed', '', NULL),
 (4517, 0, '83.54.102.102', 'Java/1.8.0_111', 2140, 2141, '', '2017-07-06 02:59:25', 'completed', '', NULL),
 (4518, 0, '83.54.102.102', 'Java/1.8.0_111', 2146, 2149, '', '2017-07-06 02:59:47', 'completed', '', NULL),
 (4519, 0, '83.54.102.102', 'Java/1.8.0_111', 2336, 2337, '', '2017-07-06 02:59:52', 'completed', '', NULL),
 (4520, 0, '83.54.102.102', 'Java/1.8.0_111', 1837, 1839, '', '2017-07-06 03:01:06', 'completed', '', NULL),
 (4521, 0, '83.54.102.102', 'Java/1.8.0_111', 1844, 1845, '', '2017-07-06 03:01:20', 'completed', '', NULL),
 (4522, 0, '83.54.102.102', 'Java/1.8.0_111', 2339, 2340, '', '2017-07-06 03:01:43', 'completed', '', NULL),
 (4523, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-07-06 03:36:50', 'completed', '', NULL),
 (4524, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-07-06 03:36:54', 'completed', '', NULL),
 (4525, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-07-06 03:36:59', 'completed', '', NULL),
 (4526, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-07-06 03:37:15', 'completed', '', NULL),
 (4527, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-07-06 03:37:19', 'completed', '', NULL),
 (4528, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-07-06 03:37:24', 'completed', '', NULL),
 (4529, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-07-06 03:37:29', 'completed', '', NULL),
 (4530, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-07-06 03:37:59', 'completed', '', NULL),
 (4531, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-07-06 03:38:06', 'completed', '', NULL),
 (4532, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-07-06 03:38:39', 'completed', '', NULL),
 (4533, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-07-06 03:38:44', 'completed', '', NULL),
 (4534, 0, '45.55.67.157', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-07-06 03:38:49', 'completed', '', NULL),
 (4535, 0, '104.171.125.103', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-06 04:33:59', 'completed', '', NULL),
 (4536, 0, '104.171.125.103', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-06 04:34:01', 'completed', '', NULL),
 (4537, 0, '104.171.125.103', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-06 04:34:03', 'completed', '', NULL),
 (4538, 0, '104.171.125.103', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-06 04:34:08', 'completed', '', NULL),
 (4539, 0, '104.171.125.103', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-06 04:34:09', 'completed', '', NULL),
 (4540, 0, '104.171.125.103', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-06 04:34:13', 'completed', '', NULL),
 (4541, 0, '104.171.125.103', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-06 04:34:15', 'completed', '', NULL),
 (4542, 0, '104.171.125.103', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-06 04:34:16', 'completed', '', NULL),
 (4543, 0, '104.171.125.103', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-06 04:34:19', 'completed', '', NULL),
 (4544, 0, '104.171.125.103', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-06 04:34:24', 'completed', '', NULL),
 (4545, 0, '104.171.125.103', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-06 04:34:26', 'completed', '', NULL),
 (4546, 0, '104.171.125.103', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-06 04:34:29', 'completed', '', NULL),
 (4547, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-06 04:50:53', 'completed', '', NULL),
 (4548, 0, '90.77.145.248', 'Java/1.8.0_91', 2128, 2367, '', '2017-07-06 05:53:07', 'completed', '', NULL),
 (4549, 0, '90.77.145.248', 'Java/1.8.0_91', 2146, 2149, '', '2017-07-06 05:53:08', 'completed', '', NULL),
 (4550, 0, '90.77.145.248', 'Java/1.8.0_91', 2333, 2334, '', '2017-07-06 05:53:09', 'completed', '', NULL),
 (4551, 0, '90.77.145.248', 'Java/1.8.0_91', 2140, 2141, '', '2017-07-06 05:53:13', 'completed', '', NULL),
 (4552, 0, '90.77.145.248', 'Java/1.8.0_91', 2336, 2337, '', '2017-07-06 05:53:15', 'completed', '', NULL),
 (4553, 0, '90.77.145.248', 'Java/1.8.0_91', 1837, 1839, '', '2017-07-06 05:53:18', 'completed', '', NULL),
 (4554, 0, '90.77.145.248', 'Java/1.8.0_91', 1844, 1845, '', '2017-07-06 05:53:19', 'completed', '', NULL),
 (4555, 0, '90.77.145.248', 'Java/1.8.0_91', 2339, 2340, '', '2017-07-06 05:53:20', 'completed', '', NULL),
 (4556, 0, '90.77.145.248', 'Java/1.8.0_91', 2130, 2133, '', '2017-07-06 05:53:24', 'completed', '', NULL),
 (4557, 0, '90.77.145.248', 'Java/1.8.0_91', 2134, 2307, '', '2017-07-06 05:53:26', 'completed', '', NULL),
 (4558, 0, '90.77.145.248', 'Java/1.8.0_91', 2161, 2162, '', '2017-07-06 05:53:28', 'completed', '', NULL),
 (4559, 0, '90.77.145.248', 'Java/1.8.0_91', 2342, 2349, '', '2017-07-06 05:53:59', 'completed', '', NULL),
 (4560, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-07-06 06:11:02', 'completed', '', NULL),
 (4561, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-07-06 08:11:31', 'completed', '', NULL),
 (4562, 0, '178.39.185.242', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2333, 2334, '', '2017-07-06 16:56:15', 'completed', '', NULL),
 (4563, 0, '178.39.185.242', 'Mozilla/5.0 (Windows NT 6.3; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2128, 2367, '', '2017-07-06 17:01:35', 'completed', '', NULL),
 (4564, 0, '178.198.37.183', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2146, 2149, '', '2017-07-06 17:28:19', 'completed', '', NULL),
 (4565, 0, '178.196.159.168', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2333, 2334, '', '2017-07-06 19:24:17', 'completed', '', NULL),
 (4566, 0, '164.132.161.41', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2339, 2340, '', '2017-07-06 21:23:16', 'completed', '', NULL),
 (4567, 0, '164.132.161.16', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2342, 2349, '', '2017-07-07 01:03:16', 'completed', '', NULL),
 (4568, 0, '104.171.125.103', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-07 01:12:36', 'completed', '', NULL),
 (4569, 0, '104.171.125.103', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-07 01:12:38', 'completed', '', NULL),
 (4570, 0, '104.171.125.103', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-07 01:12:42', 'completed', '', NULL),
 (4571, 0, '104.171.125.103', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-07 01:12:53', 'completed', '', NULL),
 (4572, 0, '104.171.125.103', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-07 01:12:55', 'completed', '', NULL),
 (4573, 0, '104.171.125.103', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-07 01:12:59', 'completed', '', NULL),
 (4574, 0, '104.171.125.103', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-07 01:13:02', 'completed', '', NULL),
 (4575, 0, '104.171.125.103', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-07 01:13:04', 'completed', '', NULL),
 (4576, 0, '104.171.125.103', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-07 01:13:09', 'completed', '', NULL),
 (4577, 0, '104.171.125.103', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-07 01:13:12', 'completed', '', NULL),
 (4578, 0, '104.171.125.103', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-07 01:13:15', 'completed', '', NULL),
 (4579, 0, '104.171.125.103', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-07 01:13:18', 'completed', '', NULL),
 (4580, 0, '178.197.233.155', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2128, 2367, '', '2017-07-07 10:34:45', 'completed', '', NULL),
 (4581, 0, '178.197.233.155', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-07-07 10:35:23', 'completed', '', NULL),
 (4582, 0, '95.16.118.94', 'Java/1.8.0_25', 2128, 2367, '', '2017-07-07 14:20:58', 'completed', '', NULL),
 (4583, 0, '95.16.118.94', 'Java/1.8.0_25', 2146, 2149, '', '2017-07-07 14:21:00', 'completed', '', NULL),
 (4584, 0, '95.16.118.94', 'Java/1.8.0_25', 2333, 2334, '', '2017-07-07 14:21:01', 'completed', '', NULL),
 (4585, 0, '95.16.118.94', 'Java/1.8.0_25', 2140, 2141, '', '2017-07-07 14:21:06', 'completed', '', NULL),
 (4586, 0, '95.16.118.94', 'Java/1.8.0_25', 2336, 2337, '', '2017-07-07 14:21:08', 'completed', '', NULL),
 (4587, 0, '95.16.118.94', 'Java/1.8.0_25', 1837, 1839, '', '2017-07-07 14:21:11', 'completed', '', NULL),
 (4588, 0, '95.16.118.94', 'Java/1.8.0_25', 1844, 1845, '', '2017-07-07 14:21:12', 'completed', '', NULL),
 (4589, 0, '95.16.118.94', 'Java/1.8.0_25', 2339, 2340, '', '2017-07-07 14:21:14', 'completed', '', NULL),
 (4590, 0, '95.16.118.94', 'Java/1.8.0_25', 2130, 2133, '', '2017-07-07 14:21:16', 'completed', '', NULL),
 (4591, 0, '95.16.118.94', 'Java/1.8.0_25', 2134, 2307, '', '2017-07-07 14:21:18', 'completed', '', NULL),
 (4592, 0, '95.16.118.94', 'Java/1.8.0_25', 2161, 2162, '', '2017-07-07 14:21:21', 'completed', '', NULL),
 (4593, 0, '95.16.118.94', 'Java/1.8.0_25', 2342, 2349, '', '2017-07-07 14:21:24', 'completed', '', NULL),
 (4594, 0, '178.197.237.61', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B411 Safari/600.1.4', 2146, 2149, '', '2017-07-07 16:47:59', 'completed', '', NULL),
 (4595, 0, '178.197.237.61', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B411 Safari/600.1.4', 2128, 2367, '', '2017-07-07 17:01:49', 'completed', '', NULL),
 (4596, 0, '178.197.237.61', 'Mozilla/5.0 (iPhone; CPU iPhone OS 8_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) Version/8.0 Mobile/12B411 Safari/600.1.4', 2333, 2334, '', '2017-07-07 17:18:50', 'completed', '', NULL),
 (4597, 0, '212.83.130.164', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-07 17:40:37', 'completed', '', NULL),
 (4598, 0, '212.83.130.164', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-07 17:40:38', 'completed', '', NULL),
 (4599, 0, '212.83.130.164', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-07 17:40:39', 'completed', '', NULL),
 (4600, 0, '212.83.130.164', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-07 17:40:41', 'completed', '', NULL),
 (4601, 0, '212.83.130.164', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-07 17:40:42', 'completed', '', NULL),
 (4602, 0, '212.83.130.164', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-07 17:40:44', 'completed', '', NULL),
 (4603, 0, '212.83.130.164', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-07 17:40:45', 'completed', '', NULL),
 (4604, 0, '212.83.130.164', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-07 17:40:46', 'completed', '', NULL),
 (4605, 0, '212.83.130.164', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-07 17:40:47', 'completed', '', NULL),
 (4606, 0, '212.83.130.164', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-07 17:40:48', 'completed', '', NULL),
 (4607, 0, '212.83.130.164', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-07 17:40:49', 'completed', '', NULL),
 (4608, 0, '212.83.130.164', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-07 17:40:50', 'completed', '', NULL),
 (4609, 0, '212.4.83.74', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:54.0) Gecko/20100101 Firefox/54.0', 2336, 2337, '', '2017-07-07 20:27:57', 'completed', '', NULL),
 (4610, 0, '212.4.83.74', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.12; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-07-07 20:28:13', 'completed', '', NULL),
 (4611, 0, '82.192.229.181', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2333, 2334, '', '2017-07-07 21:39:48', 'completed', '', NULL),
 (4612, 0, '82.192.229.181', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-07-07 21:53:33', 'completed', '', NULL),
 (4613, 0, '82.192.229.181', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2128, 2367, '', '2017-07-07 21:54:21', 'completed', '', NULL),
 (4614, 0, '79.116.24.138', 'Java/1.7.0_79', 2128, 2367, '', '2017-07-08 00:24:38', 'completed', '', NULL),
 (4615, 0, '79.116.24.138', 'Java/1.7.0_79', 2146, 2149, '', '2017-07-08 00:24:42', 'completed', '', NULL),
 (4616, 0, '79.116.24.138', 'Java/1.7.0_79', 2333, 2334, '', '2017-07-08 00:24:45', 'completed', '', NULL),
 (4617, 0, '79.116.24.138', 'Java/1.7.0_79', 2140, 2141, '', '2017-07-08 00:24:51', 'completed', '', NULL),
 (4618, 0, '79.116.24.138', 'Java/1.7.0_79', 2336, 2337, '', '2017-07-08 00:24:55', 'completed', '', NULL),
 (4619, 0, '79.116.24.138', 'Java/1.7.0_79', 1837, 1839, '', '2017-07-08 00:24:58', 'completed', '', NULL),
 (4620, 0, '79.116.24.138', 'Java/1.7.0_79', 1844, 1845, '', '2017-07-08 00:25:01', 'completed', '', NULL),
 (4621, 0, '79.116.24.138', 'Java/1.7.0_79', 2339, 2340, '', '2017-07-08 00:25:02', 'completed', '', NULL),
 (4622, 0, '79.116.24.138', 'Java/1.7.0_79', 2130, 2133, '', '2017-07-08 00:25:06', 'completed', '', NULL),
 (4623, 0, '79.116.24.138', 'Java/1.7.0_79', 2134, 2307, '', '2017-07-08 00:25:08', 'completed', '', NULL),
 (4624, 0, '79.116.24.138', 'Java/1.7.0_79', 2161, 2162, '', '2017-07-08 00:25:12', 'completed', '', NULL),
 (4625, 0, '79.116.24.138', 'Java/1.7.0_79', 2342, 2349, '', '2017-07-08 00:25:16', 'completed', '', NULL),
 (4626, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-07-08 01:57:10', 'completed', '', NULL),
 (4627, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-08 09:37:37', 'completed', '', NULL),
 (4628, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-08 09:37:39', 'completed', '', NULL),
 (4629, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-08 09:37:40', 'completed', '', NULL),
 (4630, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-08 09:37:46', 'completed', '', NULL),
 (4631, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-08 09:37:48', 'completed', '', NULL),
 (4632, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-08 09:37:52', 'completed', '', NULL),
 (4633, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-08 09:37:54', 'completed', '', NULL),
 (4634, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-08 09:37:55', 'completed', '', NULL),
 (4635, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-08 09:37:58', 'completed', '', NULL),
 (4636, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-08 09:38:01', 'completed', '', NULL),
 (4637, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-08 09:38:06', 'completed', '', NULL),
 (4638, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-08 09:38:11', 'completed', '', NULL),
 (4639, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-07-08 13:49:42', 'completed', '', NULL),
 (4640, 0, '84.72.54.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2128, 2367, '', '2017-07-08 15:56:58', 'completed', '', NULL),
 (4641, 0, '68.180.229.28', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2333, 2334, '', '2017-07-08 16:16:08', 'completed', '', NULL),
 (4642, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-08 20:16:07', 'completed', '', NULL),
 (4643, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-08 22:15:41', 'completed', '', NULL),
 (4644, 0, '65.183.102.54', 'Java/1.8.0_66', 2128, 2367, '', '2017-07-09 05:23:54', 'completed', '', NULL),
 (4645, 0, '65.183.102.54', 'Java/1.8.0_66', 2146, 2149, '', '2017-07-09 05:23:56', 'completed', '', NULL),
 (4646, 0, '65.183.102.54', 'Java/1.8.0_66', 2333, 2334, '', '2017-07-09 05:23:57', 'completed', '', NULL),
 (4647, 0, '65.183.102.54', 'Java/1.8.0_66', 2140, 2141, '', '2017-07-09 05:24:01', 'completed', '', NULL),
 (4648, 0, '65.183.102.54', 'Java/1.8.0_66', 2336, 2337, '', '2017-07-09 05:24:03', 'completed', '', NULL),
 (4649, 0, '65.183.102.54', 'Java/1.8.0_66', 1837, 1839, '', '2017-07-09 05:24:07', 'completed', '', NULL),
 (4650, 0, '65.183.102.54', 'Java/1.8.0_66', 1844, 1845, '', '2017-07-09 05:24:08', 'completed', '', NULL),
 (4651, 0, '65.183.102.54', 'Java/1.8.0_66', 2339, 2340, '', '2017-07-09 05:24:10', 'completed', '', NULL),
 (4652, 0, '65.183.102.54', 'Java/1.8.0_66', 2130, 2133, '', '2017-07-09 05:24:12', 'completed', '', NULL),
 (4653, 0, '65.183.102.54', 'Java/1.8.0_66', 2134, 2307, '', '2017-07-09 05:24:15', 'completed', '', NULL),
 (4654, 0, '65.183.102.54', 'Java/1.8.0_66', 2161, 2162, '', '2017-07-09 05:24:18', 'completed', '', NULL),
 (4655, 0, '65.183.102.54', 'Java/1.8.0_66', 2342, 2349, '', '2017-07-09 05:24:21', 'completed', '', NULL),
 (4656, 0, '31.10.132.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-09 06:24:58', 'completed', '', NULL),
 (4657, 0, '84.75.91.94', 'Mozilla/5.0 (iPad; CPU OS 9_3_5 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G36 Safari/601.1', 2146, 2149, '', '2017-07-09 13:29:52', 'completed', '', NULL),
 (4658, 0, '31.10.157.0', 'Mozilla/5.0 (Linux; Android 5.0.2; SAMSUNG SM-T535 Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/3.3 Chrome/38.0.2125.102 Safari/537.36', 2130, 2133, '', '2017-07-09 14:03:21', 'completed', '', NULL),
 (4659, 0, '31.10.157.0', 'Mozilla/5.0 (Linux; Android 5.0.2; SAMSUNG SM-T535 Build/LRX22G) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/3.3 Chrome/38.0.2125.102 Safari/537.36', 2134, 2307, '', '2017-07-09 14:03:27', 'completed', '', NULL),
 (4660, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-07-09 14:18:39', 'completed', '', NULL),
 (4661, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-07-09 14:22:06', 'completed', '', NULL),
 (4662, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-07-09 14:24:09', 'completed', '', NULL),
 (4663, 0, '217.182.132.37', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2146, 2149, '', '2017-07-09 15:56:56', 'completed', '', NULL),
 (4664, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-07-09 21:42:13', 'completed', '', NULL),
 (4665, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-07-09 23:43:52', 'completed', '', NULL),
 (4666, 0, '194.230.155.234', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G930F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 2146, 2149, '', '2017-07-10 09:07:23', 'completed', '', NULL),
 (4667, 0, '193.47.168.241', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-07-10 12:16:46', 'completed', '', NULL),
 (4668, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-07-10 14:44:04', 'completed', '', NULL),
 (4669, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-10 15:17:17', 'completed', '', NULL),
 (4670, 0, '209.90.232.106', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-10 15:17:19', 'completed', '', NULL),
 (4671, 0, '209.90.232.106', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-10 15:17:20', 'completed', '', NULL),
 (4672, 0, '209.90.232.106', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-10 15:17:24', 'completed', '', NULL),
 (4673, 0, '209.90.232.106', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-10 15:17:26', 'completed', '', NULL),
 (4674, 0, '209.90.232.106', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-10 15:17:30', 'completed', '', NULL),
 (4675, 0, '209.90.232.106', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-10 15:17:32', 'completed', '', NULL),
 (4676, 0, '209.90.232.106', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-10 15:17:33', 'completed', '', NULL),
 (4677, 0, '209.90.232.106', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-10 15:17:36', 'completed', '', NULL),
 (4678, 0, '209.90.232.106', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-10 15:17:39', 'completed', '', NULL),
 (4679, 0, '209.90.232.106', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-10 15:17:43', 'completed', '', NULL),
 (4680, 0, '209.90.232.106', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-10 15:17:46', 'completed', '', NULL),
 (4681, 0, '93.184.21.11', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.10; rv:54.0) Gecko/20100101 Firefox/54.0', 2339, 2340, '', '2017-07-10 16:17:22', 'completed', '', NULL),
 (4682, 0, '109.102.111.67', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-10 19:44:56', 'completed', '', NULL),
 (4683, 0, '109.102.111.67', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-10 19:44:57', 'completed', '', NULL),
 (4684, 0, '109.102.111.67', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-10 19:44:58', 'completed', '', NULL),
 (4685, 0, '109.102.111.67', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-10 19:45:01', 'completed', '', NULL),
 (4686, 0, '109.102.111.67', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-10 19:45:03', 'completed', '', NULL),
 (4687, 0, '109.102.111.67', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-10 19:45:06', 'completed', '', NULL),
 (4688, 0, '109.102.111.67', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-10 19:45:07', 'completed', '', NULL),
 (4689, 0, '109.102.111.67', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-10 19:45:08', 'completed', '', NULL),
 (4690, 0, '109.102.111.67', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-10 19:45:10', 'completed', '', NULL),
 (4691, 0, '109.102.111.67', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-10 19:45:12', 'completed', '', NULL),
 (4692, 0, '109.102.111.67', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-10 19:45:15', 'completed', '', NULL),
 (4693, 0, '109.102.111.67', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-10 19:45:17', 'completed', '', NULL),
 (4694, 0, '179.43.145.236', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-10 20:16:44', 'completed', '', NULL),
 (4695, 0, '179.43.145.236', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-10 20:16:46', 'completed', '', NULL),
 (4696, 0, '179.43.145.236', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-10 20:16:47', 'completed', '', NULL),
 (4697, 0, '179.43.145.236', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-10 20:16:54', 'completed', '', NULL),
 (4698, 0, '179.43.145.236', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-10 20:16:58', 'completed', '', NULL),
 (4699, 0, '179.43.145.236', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-10 20:17:02', 'completed', '', NULL),
 (4700, 0, '179.43.145.236', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-10 20:17:03', 'completed', '', NULL),
 (4701, 0, '179.43.145.236', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-10 20:17:06', 'completed', '', NULL),
 (4702, 0, '179.43.145.236', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-10 20:17:11', 'completed', '', NULL),
 (4703, 0, '179.43.145.236', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-10 20:17:13', 'completed', '', NULL),
 (4704, 0, '179.43.145.236', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-10 20:17:18', 'completed', '', NULL),
 (4705, 0, '179.43.145.236', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-10 20:17:20', 'completed', '', NULL),
 (4706, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-10 20:52:01', 'completed', '', NULL),
 (4707, 0, '181.41.204.150', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-10 20:52:03', 'completed', '', NULL),
 (4708, 0, '181.41.204.150', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-10 20:52:06', 'completed', '', NULL),
 (4709, 0, '181.41.204.150', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-10 20:52:11', 'completed', '', NULL),
 (4710, 0, '181.41.204.150', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-10 20:52:14', 'completed', '', NULL),
 (4711, 0, '181.41.204.150', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-10 20:52:17', 'completed', '', NULL),
 (4712, 0, '181.41.204.150', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-10 20:52:25', 'completed', '', NULL),
 (4713, 0, '181.41.204.150', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-10 20:52:27', 'completed', '', NULL),
 (4714, 0, '181.41.204.150', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-10 20:52:32', 'completed', '', NULL),
 (4715, 0, '181.41.204.150', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-10 20:52:36', 'completed', '', NULL),
 (4716, 0, '181.41.204.150', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-10 20:52:40', 'completed', '', NULL),
 (4717, 0, '181.41.204.150', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-10 20:52:46', 'completed', '', NULL),
 (4718, 0, '82.192.229.181', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2333, 2334, '', '2017-07-10 21:13:12', 'completed', '', NULL),
 (4719, 0, '82.192.229.181', 'Mozilla/5.0 (iPad; CPU OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2146, 2149, '', '2017-07-10 21:13:12', 'completed', '', NULL),
 (4720, 0, '31.164.172.46', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 2336, 2337, '', '2017-07-10 21:25:57', 'completed', '', NULL),
 (4721, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2140, 2141, '', '2017-07-10 23:38:25', 'completed', '', NULL),
 (4722, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-11 00:50:39', 'completed', '', NULL),
 (4723, 0, '181.41.204.150', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-11 00:50:43', 'completed', '', NULL),
 (4724, 0, '181.41.204.150', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-11 00:50:44', 'completed', '', NULL),
 (4725, 0, '181.41.204.150', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-11 00:50:50', 'completed', '', NULL),
 (4726, 0, '181.41.204.150', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-11 00:50:52', 'completed', '', NULL),
 (4727, 0, '181.41.204.150', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-11 00:50:56', 'completed', '', NULL),
 (4728, 0, '181.41.204.150', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-11 00:51:02', 'completed', '', NULL),
 (4729, 0, '181.41.204.150', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-11 00:51:06', 'completed', '', NULL),
 (4730, 0, '181.41.204.150', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-11 00:51:10', 'completed', '', NULL),
 (4731, 0, '181.41.204.150', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-11 00:51:14', 'completed', '', NULL),
 (4732, 0, '181.41.204.150', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-11 00:51:19', 'completed', '', NULL),
 (4733, 0, '181.41.204.150', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-11 00:51:22', 'completed', '', NULL),
 (4734, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-07-11 05:27:09', 'completed', '', NULL),
 (4735, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-07-11 10:52:07', 'completed', '', NULL),
 (4736, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-07-11 17:22:07', 'completed', '', NULL),
 (4737, 0, '80.110.12.19', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-11 17:41:27', 'completed', '', NULL),
 (4738, 0, '80.110.12.19', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-07-11 17:43:12', 'completed', '', NULL),
 (4739, 0, '80.110.12.19', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1837, 1839, '', '2017-07-11 17:43:40', 'completed', '', NULL),
 (4740, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-07-11 19:49:44', 'completed', '', NULL),
 (4741, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-12 00:25:18', 'completed', '', NULL),
 (4742, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-12 02:22:45', 'completed', '', NULL),
 (4743, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-12 04:24:27', 'completed', '', NULL),
 (4744, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-12 06:32:38', 'completed', '', NULL),
 (4745, 0, '89.7.19.158', 'Java/1.8.0_121', 2128, 2367, '', '2017-07-12 07:06:39', 'completed', '', NULL),
 (4746, 0, '89.7.19.158', 'Java/1.8.0_121', 2146, 2149, '', '2017-07-12 07:06:41', 'completed', '', NULL),
 (4747, 0, '89.7.19.158', 'Java/1.8.0_121', 2333, 2334, '', '2017-07-12 07:06:42', 'completed', '', NULL),
 (4748, 0, '89.7.19.158', 'Java/1.8.0_121', 2140, 2141, '', '2017-07-12 07:06:45', 'completed', '', NULL),
 (4749, 0, '89.7.19.158', 'Java/1.8.0_121', 2336, 2337, '', '2017-07-12 07:06:46', 'completed', '', NULL),
 (4750, 0, '89.7.19.158', 'Java/1.8.0_121', 1837, 1839, '', '2017-07-12 07:06:50', 'completed', '', NULL),
 (4751, 0, '89.7.19.158', 'Java/1.8.0_121', 1844, 1845, '', '2017-07-12 07:06:52', 'completed', '', NULL),
 (4752, 0, '89.7.19.158', 'Java/1.8.0_121', 2339, 2340, '', '2017-07-12 07:06:54', 'completed', '', NULL),
 (4753, 0, '89.7.19.158', 'Java/1.8.0_121', 2130, 2133, '', '2017-07-12 07:06:57', 'completed', '', NULL),
 (4754, 0, '89.7.19.158', 'Java/1.8.0_121', 2134, 2307, '', '2017-07-12 07:07:01', 'completed', '', NULL),
 (4755, 0, '89.7.19.158', 'Java/1.8.0_121', 2161, 2162, '', '2017-07-12 07:07:03', 'completed', '', NULL),
 (4756, 0, '89.7.19.158', 'Java/1.8.0_121', 2342, 2349, '', '2017-07-12 07:07:09', 'completed', '', NULL),
 (4757, 0, '89.7.19.158', 'Java/1.8.0_121', 2128, 2367, '', '2017-07-12 07:08:08', 'completed', '', NULL),
 (4758, 0, '89.7.19.158', 'Java/1.8.0_121', 2146, 2149, '', '2017-07-12 07:08:10', 'completed', '', NULL),
 (4759, 0, '89.7.19.158', 'Java/1.8.0_121', 2333, 2334, '', '2017-07-12 07:08:11', 'completed', '', NULL),
 (4760, 0, '89.7.19.158', 'Java/1.8.0_121', 2140, 2141, '', '2017-07-12 07:08:17', 'completed', '', NULL),
 (4761, 0, '89.7.19.158', 'Java/1.8.0_121', 2336, 2337, '', '2017-07-12 07:08:19', 'completed', '', NULL),
 (4762, 0, '89.7.19.158', 'Java/1.8.0_121', 1837, 1839, '', '2017-07-12 07:08:22', 'completed', '', NULL),
 (4763, 0, '89.7.19.158', 'Java/1.8.0_121', 1844, 1845, '', '2017-07-12 07:08:24', 'completed', '', NULL),
 (4764, 0, '89.7.19.158', 'Java/1.8.0_121', 2339, 2340, '', '2017-07-12 07:08:25', 'completed', '', NULL),
 (4765, 0, '89.7.19.158', 'Java/1.8.0_121', 2130, 2133, '', '2017-07-12 07:08:29', 'completed', '', NULL),
 (4766, 0, '89.7.19.158', 'Java/1.8.0_121', 2134, 2307, '', '2017-07-12 07:08:32', 'completed', '', NULL),
 (4767, 0, '89.7.19.158', 'Java/1.8.0_121', 2161, 2162, '', '2017-07-12 07:08:36', 'completed', '', NULL),
 (4768, 0, '89.7.19.158', 'Java/1.8.0_121', 2342, 2349, '', '2017-07-12 07:08:40', 'completed', '', NULL),
 (4769, 0, '178.197.225.97', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-12 07:09:22', 'completed', '', NULL),
 (4770, 0, '213.127.18.62', 'Java/1.8.0_65', 2128, 2367, '', '2017-07-12 10:38:04', 'completed', '', NULL),
 (4771, 0, '213.127.18.62', 'Java/1.8.0_65', 2146, 2149, '', '2017-07-12 10:38:06', 'completed', '', NULL),
 (4772, 0, '213.127.18.62', 'Java/1.8.0_65', 2333, 2334, '', '2017-07-12 10:38:07', 'completed', '', NULL),
 (4773, 0, '213.127.18.62', 'Java/1.8.0_65', 2140, 2141, '', '2017-07-12 10:38:11', 'completed', '', NULL),
 (4774, 0, '213.127.18.62', 'Java/1.8.0_65', 2336, 2337, '', '2017-07-12 10:38:12', 'completed', '', NULL),
 (4775, 0, '213.127.18.62', 'Java/1.8.0_65', 1837, 1839, '', '2017-07-12 10:38:14', 'completed', '', NULL),
 (4776, 0, '213.127.18.62', 'Java/1.8.0_65', 1844, 1845, '', '2017-07-12 10:38:15', 'completed', '', NULL),
 (4777, 0, '213.127.18.62', 'Java/1.8.0_65', 2339, 2340, '', '2017-07-12 10:38:16', 'completed', '', NULL),
 (4778, 0, '213.127.18.62', 'Java/1.8.0_65', 2130, 2133, '', '2017-07-12 10:38:20', 'completed', '', NULL),
 (4779, 0, '213.127.18.62', 'Java/1.8.0_65', 2134, 2307, '', '2017-07-12 10:38:22', 'completed', '', NULL),
 (4780, 0, '213.127.18.62', 'Java/1.8.0_65', 2161, 2162, '', '2017-07-12 10:38:24', 'completed', '', NULL),
 (4781, 0, '213.127.18.62', 'Java/1.8.0_65', 2342, 2349, '', '2017-07-12 10:38:25', 'completed', '', NULL),
 (4782, 0, '178.82.210.254', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2336, 2337, '', '2017-07-12 11:55:09', 'completed', '', NULL),
 (4783, 0, '178.82.210.254', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-07-12 12:01:38', 'completed', '', NULL),
 (4784, 0, '178.82.210.254', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2146, 2149, '', '2017-07-12 12:08:00', 'completed', '', NULL),
 (4785, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-07-12 15:45:26', 'completed', '', NULL),
 (4786, 0, '147.87.126.17', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0', 2146, 2149, '', '2017-07-12 17:16:57', 'completed', '', NULL),
 (4787, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-07-12 17:48:53', 'completed', '', NULL),
 (4788, 0, '188.72.124.19', 'Java/1.7.0_79', 2128, 2367, '', '2017-07-12 19:45:39', 'completed', '', NULL),
 (4789, 0, '188.72.124.19', 'Java/1.7.0_79', 2146, 2149, '', '2017-07-12 19:45:40', 'completed', '', NULL),
 (4790, 0, '188.72.124.19', 'Java/1.7.0_79', 2333, 2334, '', '2017-07-12 19:45:41', 'completed', '', NULL),
 (4791, 0, '188.72.124.19', 'Java/1.7.0_79', 2140, 2141, '', '2017-07-12 19:45:44', 'completed', '', NULL),
 (4792, 0, '188.72.124.19', 'Java/1.7.0_79', 2336, 2337, '', '2017-07-12 19:45:45', 'completed', '', NULL),
 (4793, 0, '188.72.124.19', 'Java/1.7.0_79', 1837, 1839, '', '2017-07-12 19:45:46', 'completed', '', NULL),
 (4794, 0, '188.72.124.19', 'Java/1.7.0_79', 1844, 1845, '', '2017-07-12 19:45:47', 'completed', '', NULL),
 (4795, 0, '188.72.124.19', 'Java/1.7.0_79', 2339, 2340, '', '2017-07-12 19:45:49', 'completed', '', NULL),
 (4796, 0, '188.72.124.19', 'Java/1.7.0_79', 2130, 2133, '', '2017-07-12 19:45:50', 'completed', '', NULL),
 (4797, 0, '188.72.124.19', 'Java/1.7.0_79', 2134, 2307, '', '2017-07-12 19:45:51', 'completed', '', NULL),
 (4798, 0, '188.72.124.19', 'Java/1.7.0_79', 2161, 2162, '', '2017-07-12 19:45:53', 'completed', '', NULL),
 (4799, 0, '188.72.124.19', 'Java/1.7.0_79', 2342, 2349, '', '2017-07-12 19:45:54', 'completed', '', NULL),
 (4800, 0, '40.77.167.62', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-13 01:56:21', 'completed', '', NULL),
 (4801, 0, '207.46.13.174', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-13 02:38:33', 'completed', '', NULL),
 (4802, 0, '40.77.179.144', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-13 02:58:04', 'completed', '', NULL),
 (4803, 0, '157.55.39.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-13 03:39:28', 'completed', '', NULL),
 (4804, 0, '157.55.39.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-13 05:55:32', 'completed', '', NULL),
 (4805, 0, '40.77.167.62', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-13 06:02:52', 'completed', '', NULL),
 (4806, 0, '37.49.224.69', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-13 07:26:20', 'completed', '', NULL),
 (4807, 0, '37.49.224.69', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-13 07:26:22', 'completed', '', NULL),
 (4808, 0, '37.49.224.69', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-13 07:26:23', 'completed', '', NULL),
 (4809, 0, '37.49.224.69', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-13 07:26:29', 'completed', '', NULL),
 (4810, 0, '37.49.224.69', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-13 07:26:30', 'completed', '', NULL),
 (4811, 0, '37.49.224.69', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-13 07:26:35', 'completed', '', NULL),
 (4812, 0, '37.49.224.69', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-13 07:26:37', 'completed', '', NULL),
 (4813, 0, '37.49.224.69', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-13 07:26:39', 'completed', '', NULL),
 (4814, 0, '37.49.224.69', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-13 07:26:45', 'completed', '', NULL),
 (4815, 0, '37.49.224.69', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-13 07:26:48', 'completed', '', NULL),
 (4816, 0, '37.49.224.69', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-13 07:26:51', 'completed', '', NULL),
 (4817, 0, '37.49.224.69', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-13 07:26:54', 'completed', '', NULL),
 (4818, 0, '207.46.13.174', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-13 10:50:52', 'completed', '', NULL),
 (4819, 0, '31.10.133.36', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2339, 2340, '', '2017-07-13 11:03:03', 'completed', '', NULL),
 (4820, 0, '194.11.209.54', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-07-13 14:26:09', 'completed', '', NULL),
 (4821, 0, '198.240.213.22', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2146, 2149, '', '2017-07-13 14:30:54', 'completed', '', NULL),
 (4822, 0, '213.196.161.49', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-07-13 16:20:11', 'completed', '', NULL),
 (4823, 0, '213.196.161.49', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-13 16:23:56', 'completed', '', NULL),
 (4824, 0, '207.46.13.174', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-07-13 20:59:58', 'completed', '', NULL),
 (4825, 0, '178.39.220.13', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/29.0.159059490 Mobile/14A456 Safari/602.1', 2146, 2149, '', '2017-07-13 22:50:22', 'completed', '', NULL),
 (4826, 0, '178.39.220.13', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/29.0.159059490 Mobile/14A456 Safari/602.1', 2140, 2141, '', '2017-07-13 22:50:39', 'completed', '', NULL),
 (4827, 0, '178.39.220.13', 'Mozilla/5.0 (iPad; CPU OS 10_0_2 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) GSA/29.0.159059490 Mobile/14A456 Safari/602.1', 2336, 2337, '', '2017-07-13 22:53:03', 'completed', '', NULL),
 (4828, 0, '157.55.39.94', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-14 02:46:28', 'completed', '', NULL),
 (4829, 0, '157.55.39.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-07-14 03:16:00', 'completed', '', NULL),
 (4830, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-07-14 03:31:02', 'completed', '', NULL),
 (4831, 0, '207.46.13.74', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-14 05:00:17', 'completed', '', NULL),
 (4832, 0, '157.55.39.198', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-14 10:05:52', 'completed', '', NULL),
 (4833, 0, '207.46.13.74', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-07-14 14:57:59', 'completed', '', NULL),
 (4834, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-07-14 16:35:26', 'completed', '', NULL),
 (4835, 0, '157.55.39.94', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-14 16:54:43', 'completed', '', NULL),
 (4836, 0, '40.77.167.62', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-14 17:00:00', 'completed', '', NULL),
 (4837, 0, '40.77.167.62', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-07-14 17:29:25', 'completed', '', NULL),
 (4838, 0, '65.55.210.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-14 18:01:36', 'completed', '', NULL),
 (4839, 0, '80.219.177.167', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36 OPR/46.0.2597.46', 1837, 1839, '', '2017-07-14 19:47:42', 'completed', '', NULL),
 (4840, 0, '104.138.200.36', 'Java/1.7.0_55', 2128, 2367, '', '2017-07-14 21:10:18', 'completed', '', NULL),
 (4841, 0, '104.138.200.36', 'Java/1.7.0_55', 2146, 2149, '', '2017-07-14 21:10:21', 'completed', '', NULL),
 (4842, 0, '104.138.200.36', 'Java/1.7.0_55', 2333, 2334, '', '2017-07-14 21:10:23', 'completed', '', NULL),
 (4843, 0, '104.138.200.36', 'Java/1.7.0_55', 2140, 2141, '', '2017-07-14 21:10:32', 'completed', '', NULL),
 (4844, 0, '104.138.200.36', 'Java/1.7.0_55', 2336, 2337, '', '2017-07-14 21:10:37', 'completed', '', NULL),
 (4845, 0, '104.138.200.36', 'Java/1.7.0_55', 1837, 1839, '', '2017-07-14 21:10:42', 'completed', '', NULL),
 (4846, 0, '104.138.200.36', 'Java/1.7.0_55', 1844, 1845, '', '2017-07-14 21:10:46', 'completed', '', NULL),
 (4847, 0, '104.138.200.36', 'Java/1.7.0_55', 2339, 2340, '', '2017-07-14 21:10:48', 'completed', '', NULL),
 (4848, 0, '104.138.200.36', 'Java/1.7.0_55', 2130, 2133, '', '2017-07-14 21:10:54', 'completed', '', NULL),
 (4849, 0, '104.138.200.36', 'Java/1.7.0_55', 2134, 2307, '', '2017-07-14 21:11:00', 'completed', '', NULL),
 (4850, 0, '104.138.200.36', 'Java/1.7.0_55', 2161, 2162, '', '2017-07-14 21:11:09', 'completed', '', NULL),
 (4851, 0, '104.138.200.36', 'Java/1.7.0_55', 2342, 2349, '', '2017-07-14 21:11:16', 'completed', '', NULL),
 (4852, 0, '157.55.39.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-15 03:12:15', 'completed', '', NULL),
 (4853, 0, '68.180.229.28', 'Mozilla/5.0 (compatible; Yahoo! Slurp; http://help.yahoo.com/help/us/ysearch/slurp)', 2146, 2149, '', '2017-07-15 03:27:11', 'completed', '', NULL),
 (4854, 0, '157.55.39.94', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-15 04:22:44', 'completed', '', NULL),
 (4855, 0, '157.55.39.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-15 05:06:57', 'completed', '', NULL),
 (4856, 0, '40.77.167.62', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-15 05:07:18', 'completed', '', NULL),
 (4857, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-15 10:00:45', 'completed', '', NULL),
 (4858, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-15 12:03:23', 'completed', '', NULL),
 (4859, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-15 12:21:06', 'completed', '', NULL),
 (4860, 0, '209.90.232.106', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-15 12:21:08', 'completed', '', NULL),
 (4861, 0, '209.90.232.106', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-15 12:21:09', 'completed', '', NULL),
 (4862, 0, '209.90.232.106', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-15 12:21:14', 'completed', '', NULL),
 (4863, 0, '209.90.232.106', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-15 12:21:16', 'completed', '', NULL),
 (4864, 0, '209.90.232.106', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-15 12:21:20', 'completed', '', NULL),
 (4865, 0, '209.90.232.106', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-15 12:21:22', 'completed', '', NULL),
 (4866, 0, '209.90.232.106', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-15 12:21:23', 'completed', '', NULL),
 (4867, 0, '209.90.232.106', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-15 12:21:26', 'completed', '', NULL),
 (4868, 0, '209.90.232.106', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-15 12:21:29', 'completed', '', NULL),
 (4869, 0, '209.90.232.106', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-15 12:21:33', 'completed', '', NULL),
 (4870, 0, '209.90.232.106', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-15 12:21:36', 'completed', '', NULL),
 (4871, 0, '212.187.87.113', 'Java/1.8.0_71', 2128, 2367, '', '2017-07-15 14:06:41', 'completed', '', NULL),
 (4872, 0, '212.187.87.113', 'Java/1.8.0_71', 2146, 2149, '', '2017-07-15 14:06:42', 'completed', '', NULL),
 (4873, 0, '212.187.87.113', 'Java/1.8.0_71', 2333, 2334, '', '2017-07-15 14:06:43', 'completed', '', NULL),
 (4874, 0, '212.187.87.113', 'Java/1.8.0_71', 2140, 2141, '', '2017-07-15 14:06:46', 'completed', '', NULL),
 (4875, 0, '212.187.87.113', 'Java/1.8.0_71', 2336, 2337, '', '2017-07-15 14:06:47', 'completed', '', NULL),
 (4876, 0, '212.187.87.113', 'Java/1.8.0_71', 1837, 1839, '', '2017-07-15 14:06:49', 'completed', '', NULL),
 (4877, 0, '212.187.87.113', 'Java/1.8.0_71', 1844, 1845, '', '2017-07-15 14:06:50', 'completed', '', NULL),
 (4878, 0, '212.187.87.113', 'Java/1.8.0_71', 2339, 2340, '', '2017-07-15 14:06:51', 'completed', '', NULL),
 (4879, 0, '212.187.87.113', 'Java/1.8.0_71', 2130, 2133, '', '2017-07-15 14:06:53', 'completed', '', NULL),
 (4880, 0, '212.187.87.113', 'Java/1.8.0_71', 2134, 2307, '', '2017-07-15 14:06:55', 'completed', '', NULL),
 (4881, 0, '212.187.87.113', 'Java/1.8.0_71', 2161, 2162, '', '2017-07-15 14:06:57', 'completed', '', NULL),
 (4882, 0, '212.187.87.113', 'Java/1.8.0_71', 2342, 2349, '', '2017-07-15 14:06:58', 'completed', '', NULL),
 (4883, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-07-15 20:48:00', 'completed', '', NULL),
 (4884, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-07-16 01:00:06', 'completed', '', NULL),
 (4885, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-07-16 01:00:10', 'completed', '', NULL),
 (4886, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-07-16 01:00:15', 'completed', '', NULL),
 (4887, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-07-16 01:01:00', 'completed', '', NULL),
 (4888, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-07-16 01:01:06', 'completed', '', NULL),
 (4889, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-07-16 01:01:35', 'completed', '', NULL),
 (4890, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-07-16 01:01:41', 'completed', '', NULL),
 (4891, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-07-16 01:01:45', 'completed', '', NULL),
 (4892, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-07-16 01:02:26', 'completed', '', NULL),
 (4893, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-07-16 01:02:30', 'completed', '', NULL),
 (4894, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-07-16 01:02:35', 'completed', '', NULL),
 (4895, 0, '45.55.167.117', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-07-16 01:02:40', 'completed', '', NULL),
 (4896, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-07-16 01:28:41', 'completed', '', NULL),
 (4897, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-16 02:33:12', 'completed', '', NULL),
 (4898, 0, '40.77.167.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-16 04:44:21', 'completed', '', NULL),
 (4899, 0, '89.7.19.158', 'Java/1.8.0_121', 2128, 2367, '', '2017-07-16 08:05:19', 'completed', '', NULL),
 (4900, 0, '89.7.19.158', 'Java/1.8.0_121', 2146, 2149, '', '2017-07-16 08:05:21', 'completed', '', NULL),
 (4901, 0, '89.7.19.158', 'Java/1.8.0_121', 2333, 2334, '', '2017-07-16 08:05:22', 'completed', '', NULL),
 (4902, 0, '89.7.19.158', 'Java/1.8.0_121', 2140, 2141, '', '2017-07-16 08:05:26', 'completed', '', NULL),
 (4903, 0, '89.7.19.158', 'Java/1.8.0_121', 2336, 2337, '', '2017-07-16 08:05:28', 'completed', '', NULL),
 (4904, 0, '89.7.19.158', 'Java/1.8.0_121', 1837, 1839, '', '2017-07-16 08:05:31', 'completed', '', NULL),
 (4905, 0, '89.7.19.158', 'Java/1.8.0_121', 1844, 1845, '', '2017-07-16 08:05:32', 'completed', '', NULL),
 (4906, 0, '89.7.19.158', 'Java/1.8.0_121', 2339, 2340, '', '2017-07-16 08:05:33', 'completed', '', NULL),
 (4907, 0, '89.7.19.158', 'Java/1.8.0_121', 2130, 2133, '', '2017-07-16 08:05:36', 'completed', '', NULL),
 (4908, 0, '89.7.19.158', 'Java/1.8.0_121', 2134, 2307, '', '2017-07-16 08:05:38', 'completed', '', NULL),
 (4909, 0, '89.7.19.158', 'Java/1.8.0_121', 2161, 2162, '', '2017-07-16 08:05:40', 'completed', '', NULL),
 (4910, 0, '89.7.19.158', 'Java/1.8.0_121', 2342, 2349, '', '2017-07-16 08:05:42', 'completed', '', NULL),
 (4911, 0, '164.132.161.80', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2161, 2162, '', '2017-07-16 11:57:53', 'completed', '', NULL),
 (4912, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-16 12:24:36', 'completed', '', NULL),
 (4913, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-16 12:25:30', 'completed', '', NULL),
 (4914, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-16 12:34:40', 'completed', '', NULL),
 (4915, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2146, 2149, '', '2017-07-16 12:55:35', 'completed', '', NULL),
 (4916, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-16 12:55:45', 'completed', '', NULL),
 (4917, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-16 12:56:29', 'completed', '', NULL),
 (4918, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1844, 1845, '', '2017-07-16 14:48:56', 'completed', '', NULL),
 (4919, 0, '40.77.167.125', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-07-16 15:36:43', 'completed', '', NULL),
 (4920, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-16 17:43:17', 'completed', '', NULL),
 (4921, 0, '157.55.39.219', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-16 17:56:29', 'completed', '', NULL),
 (4922, 0, '157.55.39.219', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-07-16 17:56:36', 'completed', '', NULL),
 (4923, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-07-16 18:06:20', 'completed', '', NULL),
 (4924, 0, '40.77.177.134', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-16 18:57:59', 'completed', '', NULL),
 (4925, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-17 04:02:32', 'completed', '', NULL),
 (4926, 0, '37.11.8.79', 'Java/1.8.0_131', 2128, 2367, '', '2017-07-17 04:43:35', 'completed', '', NULL),
 (4927, 0, '37.11.8.79', 'Java/1.8.0_131', 2146, 2149, '', '2017-07-17 04:43:40', 'completed', '', NULL),
 (4928, 0, '37.11.8.79', 'Java/1.8.0_131', 2333, 2334, '', '2017-07-17 04:43:42', 'completed', '', NULL),
 (4929, 0, '37.11.8.79', 'Java/1.8.0_131', 2140, 2141, '', '2017-07-17 04:43:58', 'completed', '', NULL),
 (4930, 0, '37.11.8.79', 'Java/1.8.0_131', 2336, 2337, '', '2017-07-17 04:44:01', 'completed', '', NULL),
 (4931, 0, '37.11.8.79', 'Java/1.8.0_131', 1837, 1839, '', '2017-07-17 04:44:11', 'completed', '', NULL),
 (4932, 0, '37.11.8.79', 'Java/1.8.0_131', 1844, 1845, '', '2017-07-17 04:44:13', 'completed', '', NULL),
 (4933, 0, '37.11.8.79', 'Java/1.8.0_131', 2339, 2340, '', '2017-07-17 04:44:15', 'completed', '', NULL),
 (4934, 0, '37.11.8.79', 'Java/1.8.0_131', 2130, 2133, '', '2017-07-17 04:44:23', 'completed', '', NULL),
 (4935, 0, '37.11.8.79', 'Java/1.8.0_131', 2134, 2307, '', '2017-07-17 04:44:32', 'completed', '', NULL),
 (4936, 0, '37.11.8.79', 'Java/1.8.0_131', 2161, 2162, '', '2017-07-17 04:44:41', 'completed', '', NULL),
 (4937, 0, '37.11.8.79', 'Java/1.8.0_131', 2342, 2349, '', '2017-07-17 04:44:56', 'completed', '', NULL),
 (4938, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-17 04:57:35', 'completed', '', NULL),
 (4939, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-17 05:16:19', 'completed', '', NULL),
 (4940, 0, '157.55.39.36', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-17 05:16:23', 'completed', '', NULL),
 (4941, 0, '178.197.226.247', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-17 09:09:15', 'completed', '', NULL),
 (4942, 0, '194.169.219.9', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:54.0) Gecko/20100101 Firefox/54.0', 2342, 2349, '', '2017-07-17 10:33:49', 'completed', '', NULL),
 (4943, 0, '62.203.116.118', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; LCTE; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-17 10:52:41', 'completed', '', NULL),
 (4944, 0, '62.203.116.118', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; LCTE; rv:11.0) like Gecko', 2342, 2349, '', '2017-07-17 10:52:51', 'completed', '', NULL),
 (4945, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2342, 2349, '', '2017-07-17 11:42:41', 'completed', '', NULL),
 (4946, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-17 12:15:30', 'completed', '', NULL),
 (4947, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-07-17 12:15:36', 'completed', '', NULL),
 (4948, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-17 12:15:40', 'completed', '', NULL),
 (4949, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1844, 1845, '', '2017-07-17 12:15:44', 'completed', '', NULL),
 (4950, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2128, 2367, '', '2017-07-17 12:16:54', 'completed', '', NULL),
 (4951, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-17 12:16:57', 'completed', '', NULL),
 (4952, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2333, 2334, '', '2017-07-17 12:17:00', 'completed', '', NULL),
 (4953, 0, '46.255.172.33', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2140, 2141, '', '2017-07-17 14:23:48', 'completed', '', NULL),
 (4954, 0, '164.132.162.188', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2336, 2337, '', '2017-07-17 15:58:46', 'completed', '', NULL),
 (4955, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2140, 2141, '', '2017-07-17 16:55:20', 'completed', '', NULL),
 (4956, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-07-17 19:54:48', 'completed', '', NULL),
 (4957, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-07-17 22:01:01', 'completed', '', NULL),
 (4958, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-07-17 22:39:50', 'completed', '', NULL),
 (4959, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2339, 2340, '', '2017-07-18 00:10:11', 'completed', '', NULL),
 (4960, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-07-18 00:40:44', 'completed', '', NULL),
 (4961, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-18 01:18:38', 'completed', '', NULL),
 (4962, 0, '209.90.232.106', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-18 01:18:40', 'completed', '', NULL),
 (4963, 0, '209.90.232.106', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-18 01:18:41', 'completed', '', NULL),
 (4964, 0, '209.90.232.106', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-18 01:18:46', 'completed', '', NULL),
 (4965, 0, '209.90.232.106', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-18 01:18:47', 'completed', '', NULL),
 (4966, 0, '209.90.232.106', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-18 01:18:50', 'completed', '', NULL),
 (4967, 0, '209.90.232.106', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-18 01:18:51', 'completed', '', NULL),
 (4968, 0, '209.90.232.106', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-18 01:18:54', 'completed', '', NULL),
 (4969, 0, '209.90.232.106', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-18 01:18:56', 'completed', '', NULL),
 (4970, 0, '209.90.232.106', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-18 01:18:59', 'completed', '', NULL),
 (4971, 0, '209.90.232.106', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-18 01:19:02', 'completed', '', NULL),
 (4972, 0, '209.90.232.106', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-18 01:19:07', 'completed', '', NULL),
 (4973, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-07-18 01:57:50', 'completed', '', NULL),
 (4974, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2336, 2337, '', '2017-07-18 02:41:12', 'completed', '', NULL),
 (4975, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2130, 2133, '', '2017-07-18 03:01:17', 'completed', '', NULL),
 (4976, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-07-18 04:10:05', 'completed', '', NULL),
 (4977, 0, '157.55.39.214', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-18 04:50:39', 'completed', '', NULL),
 (4978, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-18 10:57:32', 'completed', '', NULL),
 (4979, 0, '157.55.39.214', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1837, 1839, '', '2017-07-18 16:14:59', 'completed', '', NULL),
 (4980, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2128, 2367, '', '2017-07-18 16:35:40', 'completed', '', NULL),
 (4981, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-18 18:12:09', 'completed', '', NULL),
 (4982, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-07-18 19:25:24', 'completed', '', NULL),
 (4983, 0, '85.6.193.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-07-18 19:34:05', 'completed', '', NULL),
 (4984, 0, '85.6.193.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-07-18 19:37:22', 'completed', '', NULL),
 (4985, 0, '85.6.193.43', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-07-18 19:39:03', 'completed', '', NULL),
 (4986, 0, '207.46.13.96', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-18 22:35:40', 'completed', '', NULL),
 (4987, 0, '95.61.43.55', 'Java/1.8.0_131', 2128, 2367, '', '2017-07-19 02:32:20', 'completed', '', NULL),
 (4988, 0, '95.61.43.55', 'Java/1.8.0_131', 2146, 2149, '', '2017-07-19 02:32:22', 'completed', '', NULL),
 (4989, 0, '95.61.43.55', 'Java/1.8.0_131', 2333, 2334, '', '2017-07-19 02:32:23', 'completed', '', NULL),
 (4990, 0, '95.61.43.55', 'Java/1.8.0_131', 2140, 2141, '', '2017-07-19 02:32:27', 'completed', '', NULL),
 (4991, 0, '95.61.43.55', 'Java/1.8.0_131', 2336, 2337, '', '2017-07-19 02:32:29', 'completed', '', NULL),
 (4992, 0, '95.61.43.55', 'Java/1.8.0_131', 1837, 1839, '', '2017-07-19 02:32:31', 'completed', '', NULL),
 (4993, 0, '95.61.43.55', 'Java/1.8.0_131', 1844, 1845, '', '2017-07-19 02:32:33', 'completed', '', NULL),
 (4994, 0, '95.61.43.55', 'Java/1.8.0_131', 2339, 2340, '', '2017-07-19 02:32:34', 'completed', '', NULL),
 (4995, 0, '95.61.43.55', 'Java/1.8.0_131', 2130, 2133, '', '2017-07-19 02:32:36', 'completed', '', NULL),
 (4996, 0, '95.61.43.55', 'Java/1.8.0_131', 2134, 2307, '', '2017-07-19 02:32:38', 'completed', '', NULL),
 (4997, 0, '95.61.43.55', 'Java/1.8.0_131', 2161, 2162, '', '2017-07-19 02:32:41', 'completed', '', NULL),
 (4998, 0, '95.61.43.55', 'Java/1.8.0_131', 2342, 2349, '', '2017-07-19 02:32:44', 'completed', '', NULL),
 (4999, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-19 03:54:37', 'completed', '', NULL),
 (5000, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2161, 2162, '', '2017-07-19 05:02:44', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(5001, 0, '191.101.31.80', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-19 05:19:11', 'completed', '', NULL),
 (5002, 0, '191.101.31.80', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-19 05:19:12', 'completed', '', NULL),
 (5003, 0, '191.101.31.80', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-19 05:19:13', 'completed', '', NULL),
 (5004, 0, '191.101.31.80', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-19 05:19:15', 'completed', '', NULL),
 (5005, 0, '191.101.31.80', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-19 05:19:16', 'completed', '', NULL),
 (5006, 0, '191.101.31.80', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-19 05:19:17', 'completed', '', NULL),
 (5007, 0, '191.101.31.80', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-19 05:19:18', 'completed', '', NULL),
 (5008, 0, '191.101.31.80', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-19 05:19:19', 'completed', '', NULL),
 (5009, 0, '191.101.31.80', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-19 05:19:20', 'completed', '', NULL),
 (5010, 0, '191.101.31.80', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-19 05:19:21', 'completed', '', NULL),
 (5011, 0, '191.101.31.80', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-19 05:19:22', 'completed', '', NULL),
 (5012, 0, '191.101.31.80', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-19 05:19:23', 'completed', '', NULL),
 (5013, 0, '207.46.13.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-19 05:51:19', 'completed', '', NULL),
 (5014, 0, '207.46.13.9', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-19 06:00:41', 'completed', '', NULL),
 (5015, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-19 06:00:45', 'completed', '', NULL),
 (5016, 0, '62.202.189.177', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-19 08:36:57', 'completed', '', NULL),
 (5017, 0, '90.173.111.11', 'Java/1.7.0_79', 2128, 2367, '', '2017-07-19 11:37:55', 'completed', '', NULL),
 (5018, 0, '90.173.111.11', 'Java/1.7.0_79', 2146, 2149, '', '2017-07-19 11:37:56', 'completed', '', NULL),
 (5019, 0, '90.173.111.11', 'Java/1.7.0_79', 2333, 2334, '', '2017-07-19 11:37:57', 'completed', '', NULL),
 (5020, 0, '90.173.111.11', 'Java/1.7.0_79', 2140, 2141, '', '2017-07-19 11:38:00', 'completed', '', NULL),
 (5021, 0, '90.173.111.11', 'Java/1.7.0_79', 2336, 2337, '', '2017-07-19 11:38:02', 'completed', '', NULL),
 (5022, 0, '90.173.111.11', 'Java/1.7.0_79', 1837, 1839, '', '2017-07-19 11:38:03', 'completed', '', NULL),
 (5023, 0, '90.173.111.11', 'Java/1.7.0_79', 1844, 1845, '', '2017-07-19 11:38:05', 'completed', '', NULL),
 (5024, 0, '90.173.111.11', 'Java/1.7.0_79', 2339, 2340, '', '2017-07-19 11:38:07', 'completed', '', NULL),
 (5025, 0, '90.173.111.11', 'Java/1.7.0_79', 2130, 2133, '', '2017-07-19 11:38:09', 'completed', '', NULL),
 (5026, 0, '90.173.111.11', 'Java/1.7.0_79', 2134, 2307, '', '2017-07-19 11:38:11', 'completed', '', NULL),
 (5027, 0, '90.173.111.11', 'Java/1.7.0_79', 2161, 2162, '', '2017-07-19 11:38:13', 'completed', '', NULL),
 (5028, 0, '90.173.111.11', 'Java/1.7.0_79', 2342, 2349, '', '2017-07-19 11:38:15', 'completed', '', NULL),
 (5029, 0, '193.5.216.100', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-19 13:44:21', 'completed', '', NULL),
 (5030, 0, '193.5.216.100', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-07-19 13:45:17', 'completed', '', NULL),
 (5031, 0, '194.230.159.107', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-19 16:05:46', 'completed', '', NULL),
 (5032, 0, '31.165.153.162', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-T580 Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.2 Chrome/51.0.2704.106 Safari/537.36', 2342, 2349, '', '2017-07-19 20:42:31', 'completed', '', NULL),
 (5033, 0, '90.77.145.248', 'Java/1.8.0_91', 2128, 2367, '', '2017-07-19 22:30:19', 'completed', '', NULL),
 (5034, 0, '90.77.145.248', 'Java/1.8.0_91', 2146, 2149, '', '2017-07-19 22:30:20', 'completed', '', NULL),
 (5035, 0, '90.77.145.248', 'Java/1.8.0_91', 2333, 2334, '', '2017-07-19 22:30:22', 'completed', '', NULL),
 (5036, 0, '90.77.145.248', 'Java/1.8.0_91', 2140, 2141, '', '2017-07-19 22:30:30', 'completed', '', NULL),
 (5037, 0, '90.77.145.248', 'Java/1.8.0_91', 2336, 2337, '', '2017-07-19 22:30:31', 'completed', '', NULL),
 (5038, 0, '90.77.145.248', 'Java/1.8.0_91', 1837, 1839, '', '2017-07-19 22:30:35', 'completed', '', NULL),
 (5039, 0, '90.77.145.248', 'Java/1.8.0_91', 1844, 1845, '', '2017-07-19 22:30:37', 'completed', '', NULL),
 (5040, 0, '90.77.145.248', 'Java/1.8.0_91', 2339, 2340, '', '2017-07-19 22:30:38', 'completed', '', NULL),
 (5041, 0, '90.77.145.248', 'Java/1.8.0_91', 2130, 2133, '', '2017-07-19 22:30:42', 'completed', '', NULL),
 (5042, 0, '90.77.145.248', 'Java/1.8.0_91', 2134, 2307, '', '2017-07-19 22:30:44', 'completed', '', NULL),
 (5043, 0, '90.77.145.248', 'Java/1.8.0_91', 2161, 2162, '', '2017-07-19 22:30:46', 'completed', '', NULL),
 (5044, 0, '90.77.145.248', 'Java/1.8.0_91', 2342, 2349, '', '2017-07-19 22:30:49', 'completed', '', NULL),
 (5045, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2146, 2149, '', '2017-07-19 23:44:44', 'completed', '', NULL),
 (5046, 0, '181.41.204.150', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-20 01:01:53', 'completed', '', NULL),
 (5047, 0, '181.41.204.150', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-20 01:01:55', 'completed', '', NULL),
 (5048, 0, '181.41.204.150', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-20 01:01:57', 'completed', '', NULL),
 (5049, 0, '181.41.204.150', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-20 01:02:00', 'completed', '', NULL),
 (5050, 0, '181.41.204.150', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-20 01:02:02', 'completed', '', NULL),
 (5051, 0, '181.41.204.150', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-20 01:02:06', 'completed', '', NULL),
 (5052, 0, '181.41.204.150', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-20 01:02:08', 'completed', '', NULL),
 (5053, 0, '181.41.204.150', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-20 01:02:10', 'completed', '', NULL),
 (5054, 0, '181.41.204.150', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-20 01:02:13', 'completed', '', NULL),
 (5055, 0, '181.41.204.150', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-20 01:02:15', 'completed', '', NULL),
 (5056, 0, '181.41.204.150', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-20 01:02:18', 'completed', '', NULL),
 (5057, 0, '181.41.204.150', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-20 01:02:21', 'completed', '', NULL),
 (5058, 0, '157.55.39.222', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 1844, 1845, '', '2017-07-20 01:13:27', 'completed', '', NULL),
 (5059, 0, '217.192.101.114', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 1837, 1839, '', '2017-07-20 01:45:10', 'completed', '', NULL),
 (5060, 0, '217.192.101.114', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-20 01:46:30', 'completed', '', NULL),
 (5061, 0, '217.192.101.114', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-20 01:57:14', 'completed', '', NULL),
 (5062, 0, '40.77.167.137', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-07-20 02:39:14', 'completed', '', NULL),
 (5063, 0, '157.55.39.214', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-20 05:46:31', 'completed', '', NULL),
 (5064, 0, '157.55.39.222', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-20 10:08:48', 'completed', '', NULL),
 (5065, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2333, 2334, '', '2017-07-20 11:19:32', 'completed', '', NULL),
 (5066, 0, '157.55.39.222', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-20 17:14:52', 'completed', '', NULL),
 (5067, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-20 18:20:32', 'completed', '', NULL),
 (5068, 0, '65.55.210.201', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-20 19:53:42', 'completed', '', NULL),
 (5069, 0, '40.77.167.137', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-21 02:50:16', 'completed', '', NULL),
 (5070, 0, '207.46.13.170', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-21 03:22:05', 'completed', '', NULL),
 (5071, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-21 05:40:30', 'completed', '', NULL),
 (5072, 0, '40.77.167.137', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-21 10:11:19', 'completed', '', NULL),
 (5073, 0, '92.106.28.57', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2140, 2141, '', '2017-07-21 10:17:46', 'completed', '', NULL),
 (5074, 0, '87.250.224.102', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2342, 2349, '', '2017-07-21 14:12:53', 'completed', '', NULL),
 (5075, 0, '213.55.184.179', 'Mozilla/5.0 (Linux; Android 6.0; PLK-L01 Build/HONORPLK-L01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2140, 2141, '', '2017-07-21 14:32:55', 'completed', '', NULL),
 (5076, 0, '213.55.184.179', 'Mozilla/5.0 (Linux; Android 6.0; PLK-L01 Build/HONORPLK-L01) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.132 Mobile Safari/537.36', 2140, 2141, '', '2017-07-21 14:34:11', 'completed', '', NULL),
 (5077, 0, '37.9.113.110', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2134, 2307, '', '2017-07-21 14:53:58', 'completed', '', NULL),
 (5078, 0, '62.202.189.177', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2140, 2141, '', '2017-07-21 16:00:57', 'completed', '', NULL),
 (5079, 0, '216.244.66.194', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 1837, 1839, '', '2017-07-21 20:00:12', 'completed', '', NULL),
 (5080, 0, '82.192.229.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2339, 2340, '', '2017-07-21 22:07:04', 'completed', '', NULL),
 (5081, 0, '82.192.229.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 1844, 1845, '', '2017-07-21 22:07:27', 'completed', '', NULL),
 (5082, 0, '82.192.229.181', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.2.5 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.5', 2146, 2149, '', '2017-07-21 22:08:07', 'completed', '', NULL),
 (5083, 0, '94.4.28.168', 'Java/1.4.1_04', 2128, 2367, '', '2017-07-22 06:19:41', 'completed', '', NULL),
 (5084, 0, '94.4.28.168', 'Java/1.4.1_04', 2146, 2149, '', '2017-07-22 06:19:43', 'completed', '', NULL),
 (5085, 0, '94.4.28.168', 'Java/1.4.1_04', 2333, 2334, '', '2017-07-22 06:19:44', 'completed', '', NULL),
 (5086, 0, '94.4.28.168', 'Java/1.4.1_04', 2140, 2141, '', '2017-07-22 06:19:49', 'completed', '', NULL),
 (5087, 0, '94.4.28.168', 'Java/1.4.1_04', 2336, 2337, '', '2017-07-22 06:19:51', 'completed', '', NULL),
 (5088, 0, '94.4.28.168', 'Java/1.4.1_04', 1837, 1839, '', '2017-07-22 06:19:54', 'completed', '', NULL),
 (5089, 0, '94.4.28.168', 'Java/1.4.1_04', 1844, 1845, '', '2017-07-22 06:19:56', 'completed', '', NULL),
 (5090, 0, '94.4.28.168', 'Java/1.4.1_04', 2339, 2340, '', '2017-07-22 06:19:58', 'completed', '', NULL),
 (5091, 0, '94.4.28.168', 'Java/1.4.1_04', 2130, 2133, '', '2017-07-22 06:20:01', 'completed', '', NULL),
 (5092, 0, '94.4.28.168', 'Java/1.4.1_04', 2134, 2307, '', '2017-07-22 06:20:06', 'completed', '', NULL),
 (5093, 0, '94.4.28.168', 'Java/1.4.1_04', 2161, 2162, '', '2017-07-22 06:20:09', 'completed', '', NULL),
 (5094, 0, '94.4.28.168', 'Java/1.4.1_04', 2342, 2349, '', '2017-07-22 06:20:12', 'completed', '', NULL),
 (5095, 0, '69.146.169.206', 'Java/1.8.0_121', 2128, 2367, '', '2017-07-22 06:43:50', 'completed', '', NULL),
 (5096, 0, '69.146.169.206', 'Java/1.8.0_121', 2146, 2149, '', '2017-07-22 06:43:51', 'completed', '', NULL),
 (5097, 0, '69.146.169.206', 'Java/1.8.0_121', 2333, 2334, '', '2017-07-22 06:43:53', 'completed', '', NULL),
 (5098, 0, '69.146.169.206', 'Java/1.8.0_121', 2140, 2141, '', '2017-07-22 06:43:56', 'completed', '', NULL),
 (5099, 0, '69.146.169.206', 'Java/1.8.0_121', 2336, 2337, '', '2017-07-22 06:43:58', 'completed', '', NULL),
 (5100, 0, '69.146.169.206', 'Java/1.8.0_121', 1837, 1839, '', '2017-07-22 06:44:00', 'completed', '', NULL),
 (5101, 0, '69.146.169.206', 'Java/1.8.0_121', 1844, 1845, '', '2017-07-22 06:44:02', 'completed', '', NULL),
 (5102, 0, '69.146.169.206', 'Java/1.8.0_121', 2339, 2340, '', '2017-07-22 06:44:03', 'completed', '', NULL),
 (5103, 0, '69.146.169.206', 'Java/1.8.0_121', 2130, 2133, '', '2017-07-22 06:44:07', 'completed', '', NULL),
 (5104, 0, '69.146.169.206', 'Java/1.8.0_121', 2134, 2307, '', '2017-07-22 06:44:09', 'completed', '', NULL),
 (5105, 0, '69.146.169.206', 'Java/1.8.0_121', 2342, 2349, '', '2017-07-22 06:44:15', 'completed', '', NULL),
 (5106, 0, '69.146.169.206', 'Java/1.8.0_121', 2161, 2162, '', '2017-07-22 06:49:14', 'completed', '', NULL),
 (5107, 0, '157.55.39.214', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-22 07:48:33', 'completed', '', NULL),
 (5108, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-22 07:51:56', 'completed', '', NULL),
 (5109, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-22 07:51:58', 'completed', '', NULL),
 (5110, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-22 07:52:00', 'completed', '', NULL),
 (5111, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-22 07:52:06', 'completed', '', NULL),
 (5112, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-22 07:52:09', 'completed', '', NULL),
 (5113, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-22 07:52:12', 'completed', '', NULL),
 (5114, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-22 07:52:13', 'completed', '', NULL),
 (5115, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-22 07:52:15', 'completed', '', NULL),
 (5116, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-22 07:52:19', 'completed', '', NULL),
 (5117, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-22 07:52:21', 'completed', '', NULL),
 (5118, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-22 07:52:25', 'completed', '', NULL),
 (5119, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-22 07:52:27', 'completed', '', NULL),
 (5120, 0, '188.60.170.94', 'Mozilla/5.0 (Linux; Android 7.0; SAMSUNG SM-G925F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 2146, 2149, '', '2017-07-22 09:08:44', 'completed', '', NULL),
 (5121, 0, '89.7.19.158', 'Java/1.8.0_121', 2128, 2367, '', '2017-07-22 12:05:52', 'completed', '', NULL),
 (5122, 0, '89.7.19.158', 'Java/1.8.0_121', 2146, 2149, '', '2017-07-22 12:05:57', 'completed', '', NULL),
 (5123, 0, '89.7.19.158', 'Java/1.8.0_121', 2333, 2334, '', '2017-07-22 12:05:58', 'completed', '', NULL),
 (5124, 0, '89.7.19.158', 'Java/1.8.0_121', 2140, 2141, '', '2017-07-22 12:06:13', 'completed', '', NULL),
 (5125, 0, '89.7.19.158', 'Java/1.8.0_121', 2336, 2337, '', '2017-07-22 12:06:19', 'completed', '', NULL),
 (5126, 0, '89.7.19.158', 'Java/1.8.0_121', 1837, 1839, '', '2017-07-22 12:06:32', 'completed', '', NULL),
 (5127, 0, '89.7.19.158', 'Java/1.8.0_121', 1844, 1845, '', '2017-07-22 12:06:36', 'completed', '', NULL),
 (5128, 0, '89.7.19.158', 'Java/1.8.0_121', 2339, 2340, '', '2017-07-22 12:06:41', 'completed', '', NULL),
 (5129, 0, '89.7.19.158', 'Java/1.8.0_121', 2130, 2133, '', '2017-07-22 12:06:53', 'completed', '', NULL),
 (5130, 0, '89.7.19.158', 'Java/1.8.0_121', 2134, 2307, '', '2017-07-22 12:07:00', 'completed', '', NULL),
 (5131, 0, '89.7.19.158', 'Java/1.8.0_121', 2161, 2162, '', '2017-07-22 12:07:09', 'completed', '', NULL),
 (5132, 0, '89.7.19.158', 'Java/1.8.0_121', 2342, 2349, '', '2017-07-22 12:07:19', 'completed', '', NULL),
 (5133, 0, '37.9.113.110', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2339, 2340, '', '2017-07-22 16:12:40', 'completed', '', NULL),
 (5134, 0, '216.244.66.246', 'Mozilla/5.0 (compatible; DotBot/1.1; http://www.opensiteexplorer.org/dotbot, help@moz.com)', 2134, 2307, '', '2017-07-22 17:00:40', 'completed', '', NULL),
 (5135, 0, '157.55.39.88', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-22 18:44:39', 'completed', '', NULL),
 (5136, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-22 19:39:01', 'completed', '', NULL),
 (5137, 0, '131.253.25.201', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-22 20:40:44', 'completed', '', NULL),
 (5138, 0, '77.56.21.17', 'Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2342, 2349, '', '2017-07-23 00:31:09', 'completed', '', NULL),
 (5139, 0, '157.55.39.88', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-23 01:03:00', 'completed', '', NULL),
 (5140, 0, '181.41.204.210', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-23 06:49:20', 'completed', '', NULL),
 (5141, 0, '181.41.204.210', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-23 06:49:22', 'completed', '', NULL),
 (5142, 0, '181.41.204.210', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-23 06:49:23', 'completed', '', NULL),
 (5143, 0, '181.41.204.210', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-23 06:49:32', 'completed', '', NULL),
 (5144, 0, '181.41.204.210', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-23 06:49:35', 'completed', '', NULL),
 (5145, 0, '181.41.204.210', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-23 06:49:43', 'completed', '', NULL),
 (5146, 0, '181.41.204.210', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-23 06:49:45', 'completed', '', NULL),
 (5147, 0, '181.41.204.210', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-23 06:49:46', 'completed', '', NULL),
 (5148, 0, '181.41.204.210', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-23 06:49:52', 'completed', '', NULL),
 (5149, 0, '181.41.204.210', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-23 06:49:57', 'completed', '', NULL),
 (5150, 0, '181.41.204.210', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-23 06:50:02', 'completed', '', NULL),
 (5151, 0, '181.41.204.210', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-23 06:50:05', 'completed', '', NULL),
 (5152, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-23 08:09:50', 'completed', '', NULL),
 (5153, 0, '209.90.232.120', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-23 11:00:04', 'completed', '', NULL),
 (5154, 0, '209.90.232.120', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-23 11:00:07', 'completed', '', NULL),
 (5155, 0, '209.90.232.120', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-23 11:00:08', 'completed', '', NULL),
 (5156, 0, '209.90.232.120', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-23 11:00:13', 'completed', '', NULL),
 (5157, 0, '209.90.232.120', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-23 11:00:15', 'completed', '', NULL),
 (5158, 0, '209.90.232.120', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-23 11:00:19', 'completed', '', NULL),
 (5159, 0, '209.90.232.120', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-23 11:00:21', 'completed', '', NULL),
 (5160, 0, '209.90.232.120', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-23 11:00:22', 'completed', '', NULL),
 (5161, 0, '209.90.232.120', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-23 11:00:26', 'completed', '', NULL),
 (5162, 0, '209.90.232.120', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-23 11:00:28', 'completed', '', NULL),
 (5163, 0, '209.90.232.120', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-23 11:00:31', 'completed', '', NULL),
 (5164, 0, '209.90.232.120', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-23 11:00:35', 'completed', '', NULL),
 (5165, 0, '181.41.204.210', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-23 11:07:36', 'completed', '', NULL),
 (5166, 0, '181.41.204.210', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-23 11:07:44', 'completed', '', NULL),
 (5167, 0, '181.41.204.210', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-23 11:07:46', 'completed', '', NULL),
 (5168, 0, '181.41.204.210', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-23 11:07:51', 'completed', '', NULL),
 (5169, 0, '181.41.204.210', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-23 11:07:55', 'completed', '', NULL),
 (5170, 0, '181.41.204.210', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-23 11:08:04', 'completed', '', NULL),
 (5171, 0, '181.41.204.210', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-23 11:08:07', 'completed', '', NULL),
 (5172, 0, '181.41.204.210', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-23 11:08:09', 'completed', '', NULL),
 (5173, 0, '181.41.204.210', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-23 11:08:18', 'completed', '', NULL),
 (5174, 0, '181.41.204.210', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-23 11:08:27', 'completed', '', NULL),
 (5175, 0, '181.41.204.210', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-23 11:08:34', 'completed', '', NULL),
 (5176, 0, '181.41.204.210', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-23 11:08:44', 'completed', '', NULL),
 (5177, 0, '40.77.167.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-23 11:14:51', 'completed', '', NULL),
 (5178, 0, '37.9.113.53', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2161, 2162, '', '2017-07-23 12:42:00', 'completed', '', NULL),
 (5179, 0, '37.9.113.110', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2134, 2307, '', '2017-07-23 16:40:35', 'completed', '', NULL),
 (5180, 0, '181.41.204.210', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-23 17:10:58', 'completed', '', NULL),
 (5181, 0, '181.41.204.210', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-23 17:11:00', 'completed', '', NULL),
 (5182, 0, '181.41.204.210', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-23 17:11:01', 'completed', '', NULL),
 (5183, 0, '181.41.204.210', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-23 17:11:09', 'completed', '', NULL),
 (5184, 0, '181.41.204.210', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-23 17:11:11', 'completed', '', NULL),
 (5185, 0, '181.41.204.210', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-23 17:11:14', 'completed', '', NULL),
 (5186, 0, '181.41.204.210', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-23 17:11:15', 'completed', '', NULL),
 (5187, 0, '181.41.204.210', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-23 17:11:18', 'completed', '', NULL),
 (5188, 0, '181.41.204.210', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-23 17:11:25', 'completed', '', NULL),
 (5189, 0, '181.41.204.210', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-23 17:11:32', 'completed', '', NULL),
 (5190, 0, '181.41.204.210', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-23 17:11:40', 'completed', '', NULL),
 (5191, 0, '181.41.204.210', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-23 17:11:49', 'completed', '', NULL),
 (5192, 0, '84.72.92.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/601.5.17 (KHTML, like Gecko) Version/9.1 Safari/601.5.17', 2146, 2149, '', '2017-07-24 09:30:02', 'completed', '', NULL),
 (5193, 0, '84.72.92.15', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/601.5.17 (KHTML, like Gecko) Version/9.1 Safari/601.5.17', 2140, 2141, '', '2017-07-24 09:31:01', 'completed', '', NULL),
 (5194, 0, '157.55.39.214', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-24 10:24:28', 'completed', '', NULL),
 (5195, 0, '84.73.226.165', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2342, 2349, '', '2017-07-24 11:00:09', 'completed', '', NULL),
 (5196, 0, '37.9.113.110', 'Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)', 2130, 2133, '', '2017-07-24 12:35:49', 'completed', '', NULL),
 (5197, 0, '145.234.241.102', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 1844, 1845, '', '2017-07-24 14:17:18', 'completed', '', NULL),
 (5198, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2146, 2149, '', '2017-07-24 14:19:46', 'completed', '', NULL),
 (5199, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-07-24 14:21:23', 'completed', '', NULL),
 (5200, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-07-24 14:24:08', 'completed', '', NULL),
 (5201, 0, '159.168.7.144', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-07-24 14:24:26', 'completed', '', NULL),
 (5202, 0, '145.234.241.102', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2140, 2141, '', '2017-07-24 14:41:24', 'completed', '', NULL),
 (5203, 0, '145.234.241.102', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36', 2339, 2340, '', '2017-07-24 16:12:35', 'completed', '', NULL),
 (5204, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-24 17:17:46', 'completed', '', NULL),
 (5205, 0, '157.55.39.88', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-24 18:03:26', 'completed', '', NULL),
 (5206, 0, '131.253.27.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-24 19:50:44', 'completed', '', NULL),
 (5207, 0, '37.35.179.75', 'Java/1.8.0_131', 2128, 2367, '', '2017-07-24 20:46:32', 'completed', '', NULL),
 (5208, 0, '37.35.179.75', 'Java/1.8.0_131', 2146, 2149, '', '2017-07-24 20:46:41', 'completed', '', NULL),
 (5209, 0, '37.35.179.75', 'Java/1.8.0_131', 2333, 2334, '', '2017-07-24 20:46:43', 'completed', '', NULL),
 (5210, 0, '37.35.179.75', 'Java/1.8.0_131', 2140, 2141, '', '2017-07-24 20:47:02', 'completed', '', NULL),
 (5211, 0, '37.35.179.75', 'Java/1.8.0_131', 2336, 2337, '', '2017-07-24 20:47:11', 'completed', '', NULL),
 (5212, 0, '37.35.179.75', 'Java/1.8.0_131', 1837, 1839, '', '2017-07-24 20:47:29', 'completed', '', NULL),
 (5213, 0, '37.35.179.75', 'Java/1.8.0_131', 1844, 1845, '', '2017-07-24 20:47:34', 'completed', '', NULL),
 (5214, 0, '37.35.179.75', 'Java/1.8.0_131', 2339, 2340, '', '2017-07-24 20:47:38', 'completed', '', NULL),
 (5215, 0, '37.35.179.75', 'Java/1.8.0_131', 2130, 2133, '', '2017-07-24 20:47:53', 'completed', '', NULL),
 (5216, 0, '37.35.179.75', 'Java/1.8.0_131', 2134, 2307, '', '2017-07-24 20:48:08', 'completed', '', NULL),
 (5217, 0, '37.35.179.75', 'Java/1.8.0_131', 2161, 2162, '', '2017-07-24 20:48:24', 'completed', '', NULL),
 (5218, 0, '37.35.179.75', 'Java/1.8.0_131', 2342, 2349, '', '2017-07-24 20:48:39', 'completed', '', NULL),
 (5219, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-24 22:21:15', 'completed', '', NULL),
 (5220, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-24 22:21:17', 'completed', '', NULL),
 (5221, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-24 22:21:18', 'completed', '', NULL),
 (5222, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-24 22:21:24', 'completed', '', NULL),
 (5223, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-24 22:21:26', 'completed', '', NULL),
 (5224, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-24 22:21:29', 'completed', '', NULL),
 (5225, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-24 22:21:31', 'completed', '', NULL),
 (5226, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-24 22:21:33', 'completed', '', NULL),
 (5227, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-24 22:21:37', 'completed', '', NULL),
 (5228, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-24 22:21:40', 'completed', '', NULL),
 (5229, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-24 22:21:44', 'completed', '', NULL),
 (5230, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-24 22:21:47', 'completed', '', NULL),
 (5231, 0, '40.77.167.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-24 23:39:08', 'completed', '', NULL),
 (5232, 0, '54.165.90.203', 'ia_archiver', 2161, 2162, '', '2017-07-25 01:05:52', 'completed', '', NULL),
 (5233, 0, '54.165.90.203', 'ia_archiver', 2342, 2349, '', '2017-07-25 01:08:52', 'completed', '', NULL),
 (5234, 0, '54.165.90.203', 'ia_archiver', 2134, 2307, '', '2017-07-25 01:39:34', 'completed', '', NULL),
 (5235, 0, '54.165.90.203', 'ia_archiver', 2146, 2149, '', '2017-07-25 02:01:57', 'completed', '', NULL),
 (5236, 0, '40.77.167.14', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-25 06:24:00', 'completed', '', NULL),
 (5237, 0, '157.55.39.92', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-25 08:42:24', 'completed', '', NULL),
 (5238, 0, '194.40.145.19', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-07-25 08:58:13', 'completed', '', NULL),
 (5239, 0, '194.40.145.19', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-07-25 08:59:07', 'completed', '', NULL),
 (5240, 0, '194.40.145.19', 'Mozilla/5.0 (Windows NT 6.3; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-07-25 08:59:55', 'completed', '', NULL),
 (5241, 0, '77.224.114.142', 'Java/1.8.0_45', 2128, 2367, '', '2017-07-25 12:54:12', 'completed', '', NULL),
 (5242, 0, '77.224.114.142', 'Java/1.8.0_45', 2146, 2149, '', '2017-07-25 12:54:17', 'completed', '', NULL),
 (5243, 0, '77.224.114.142', 'Java/1.8.0_45', 2333, 2334, '', '2017-07-25 12:54:18', 'completed', '', NULL),
 (5244, 0, '77.224.114.142', 'Java/1.8.0_45', 2140, 2141, '', '2017-07-25 12:54:33', 'completed', '', NULL),
 (5245, 0, '77.224.114.142', 'Java/1.8.0_45', 2336, 2337, '', '2017-07-25 12:54:41', 'completed', '', NULL),
 (5246, 0, '77.224.114.142', 'Java/1.8.0_45', 1837, 1839, '', '2017-07-25 12:54:49', 'completed', '', NULL),
 (5247, 0, '77.224.114.142', 'Java/1.8.0_45', 1844, 1845, '', '2017-07-25 12:54:58', 'completed', '', NULL),
 (5248, 0, '77.224.114.142', 'Java/1.8.0_45', 2339, 2340, '', '2017-07-25 12:55:02', 'completed', '', NULL),
 (5249, 0, '77.224.114.142', 'Java/1.8.0_45', 2130, 2133, '', '2017-07-25 12:55:08', 'completed', '', NULL),
 (5250, 0, '77.224.114.142', 'Java/1.8.0_45', 2134, 2307, '', '2017-07-25 12:55:14', 'completed', '', NULL),
 (5251, 0, '77.224.114.142', 'Java/1.8.0_45', 2161, 2162, '', '2017-07-25 12:55:20', 'completed', '', NULL),
 (5252, 0, '77.224.114.142', 'Java/1.8.0_45', 2342, 2349, '', '2017-07-25 12:55:27', 'completed', '', NULL),
 (5253, 0, '188.63.22.49', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1844, 1845, '', '2017-07-25 20:19:41', 'completed', '', NULL),
 (5254, 0, '178.197.227.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2134, 2307, '', '2017-07-25 21:17:56', 'completed', '', NULL),
 (5255, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-07-25 21:58:11', 'completed', '', NULL),
 (5256, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-07-25 21:58:17', 'completed', '', NULL),
 (5257, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-07-25 21:58:22', 'completed', '', NULL),
 (5258, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-07-25 21:59:07', 'completed', '', NULL),
 (5259, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-07-25 21:59:11', 'completed', '', NULL),
 (5260, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-07-25 21:59:43', 'completed', '', NULL),
 (5261, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-07-25 21:59:47', 'completed', '', NULL),
 (5262, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-07-25 21:59:51', 'completed', '', NULL),
 (5263, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-07-25 22:00:31', 'completed', '', NULL),
 (5264, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-07-25 22:00:37', 'completed', '', NULL),
 (5265, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-07-25 22:00:42', 'completed', '', NULL),
 (5266, 0, '159.203.172.249', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-07-25 22:00:48', 'completed', '', NULL),
 (5267, 0, '157.55.39.88', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-26 01:06:18', 'completed', '', NULL),
 (5268, 0, '37.35.179.75', 'Java/1.8.0_131', 2128, 2367, '', '2017-07-26 01:34:06', 'completed', '', NULL),
 (5269, 0, '37.35.179.75', 'Java/1.8.0_131', 2146, 2149, '', '2017-07-26 01:34:09', 'completed', '', NULL),
 (5270, 0, '37.35.179.75', 'Java/1.8.0_131', 2333, 2334, '', '2017-07-26 01:34:10', 'completed', '', NULL),
 (5271, 0, '37.35.179.75', 'Java/1.8.0_131', 2140, 2141, '', '2017-07-26 01:34:18', 'completed', '', NULL),
 (5272, 0, '37.35.179.75', 'Java/1.8.0_131', 2336, 2337, '', '2017-07-26 01:34:22', 'completed', '', NULL),
 (5273, 0, '37.35.179.75', 'Java/1.8.0_131', 1837, 1839, '', '2017-07-26 01:34:26', 'completed', '', NULL),
 (5274, 0, '37.35.179.75', 'Java/1.8.0_131', 1844, 1845, '', '2017-07-26 01:34:29', 'completed', '', NULL),
 (5275, 0, '37.35.179.75', 'Java/1.8.0_131', 2339, 2340, '', '2017-07-26 01:34:31', 'completed', '', NULL),
 (5276, 0, '37.35.179.75', 'Java/1.8.0_131', 2130, 2133, '', '2017-07-26 01:34:35', 'completed', '', NULL),
 (5277, 0, '37.35.179.75', 'Java/1.8.0_131', 2134, 2307, '', '2017-07-26 01:34:39', 'completed', '', NULL),
 (5278, 0, '37.35.179.75', 'Java/1.8.0_131', 2161, 2162, '', '2017-07-26 01:34:44', 'completed', '', NULL),
 (5279, 0, '37.35.179.75', 'Java/1.8.0_131', 2342, 2349, '', '2017-07-26 01:34:49', 'completed', '', NULL),
 (5280, 0, '157.55.39.247', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-26 02:57:36', 'completed', '', NULL),
 (5281, 0, '40.77.167.45', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-26 08:02:28', 'completed', '', NULL),
 (5282, 0, '157.55.39.84', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-26 12:39:15', 'completed', '', NULL),
 (5283, 0, '51.255.65.17', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2128, 2367, '', '2017-07-26 15:23:15', 'completed', '', NULL),
 (5284, 0, '178.83.168.90', 'Mozilla/5.0 (Linux; Android 6.0.1; SAMSUNG SM-G800F Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) SamsungBrowser/5.4 Chrome/51.0.2704.106 Mobile Safari/537.36', 2128, 2367, '', '2017-07-26 17:21:41', 'completed', '', NULL),
 (5285, 0, '81.17.30.19', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-26 20:54:42', 'completed', '', NULL),
 (5286, 0, '81.17.30.19', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-26 20:54:43', 'completed', '', NULL),
 (5287, 0, '81.17.30.19', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-26 20:54:44', 'completed', '', NULL),
 (5288, 0, '81.17.30.19', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-26 20:54:47', 'completed', '', NULL),
 (5289, 0, '81.17.30.19', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-26 20:54:49', 'completed', '', NULL),
 (5290, 0, '81.17.30.19', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-26 20:54:51', 'completed', '', NULL),
 (5291, 0, '81.17.30.19', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-26 20:54:52', 'completed', '', NULL),
 (5292, 0, '81.17.30.19', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-26 20:54:53', 'completed', '', NULL),
 (5293, 0, '81.17.30.19', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-26 20:54:54', 'completed', '', NULL),
 (5294, 0, '81.17.30.19', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-26 20:54:56', 'completed', '', NULL),
 (5295, 0, '81.17.30.19', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-26 20:54:58', 'completed', '', NULL),
 (5296, 0, '81.17.30.19', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-26 20:55:01', 'completed', '', NULL),
 (5297, 0, '188.60.169.34', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:54.0) Gecko/20100101 Firefox/54.0', 2333, 2334, '', '2017-07-26 21:55:28', 'completed', '', NULL),
 (5298, 0, '186.151.63.142', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2128, 2367, '', '2017-07-27 01:41:32', 'completed', '', NULL),
 (5299, 0, '186.151.63.142', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2333, 2334, '', '2017-07-27 01:43:35', 'completed', '', NULL),
 (5300, 0, '85.5.224.244', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1844, 1845, '', '2017-07-27 01:50:57', 'completed', '', NULL),
 (5301, 0, '85.5.224.244', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1844, 1845, '', '2017-07-27 01:53:09', 'completed', '', NULL),
 (5302, 0, '157.55.39.211', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-27 04:25:12', 'completed', '', NULL),
 (5303, 0, '213.221.250.148', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-07-27 08:55:24', 'completed', '', NULL),
 (5304, 0, '157.55.39.84', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-27 09:52:34', 'completed', '', NULL),
 (5305, 0, '212.126.160.9', 'Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2128, 2367, '', '2017-07-27 13:21:00', 'completed', '', NULL),
 (5306, 0, '188.63.22.49', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 1844, 1845, '', '2017-07-27 14:34:40', 'completed', '', NULL),
 (5307, 0, '188.63.22.49', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 1837, 1839, '', '2017-07-27 14:35:22', 'completed', '', NULL),
 (5308, 0, '188.63.22.49', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-27 14:37:39', 'completed', '', NULL),
 (5309, 0, '188.63.22.49', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 1844, 1845, '', '2017-07-27 14:40:00', 'completed', '', NULL),
 (5310, 0, '188.63.22.49', 'Mozilla/5.0 (Windows NT 10.0; WOW64; Trident/7.0; Touch; rv:11.0) like Gecko', 2339, 2340, '', '2017-07-27 14:41:27', 'completed', '', NULL),
 (5311, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-07-27 15:59:20', 'completed', '', NULL),
 (5312, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-07-27 16:01:49', 'completed', '', NULL),
 (5313, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2333, 2334, '', '2017-07-27 16:02:53', 'completed', '', NULL),
 (5314, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-07-27 16:11:56', 'completed', '', NULL),
 (5315, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2128, 2367, '', '2017-07-27 16:41:50', 'completed', '', NULL),
 (5316, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-07-27 16:51:26', 'completed', '', NULL),
 (5317, 0, '80.218.146.128', 'Mozilla/5.0 (Linux; Android 6.0; HTC One M9 Build/MRA58K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 1844, 1845, '', '2017-07-27 20:00:55', 'completed', '', NULL),
 (5318, 0, '80.218.146.128', 'Mozilla/5.0 (Linux; Android 6.0; HTC One M9 Build/MRA58K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 1837, 1839, '', '2017-07-27 20:01:32', 'completed', '', NULL),
 (5319, 0, '194.230.155.221', 'Mozilla/5.0 (iPad; CPU OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2336, 2337, '', '2017-07-27 20:25:29', 'completed', '', NULL),
 (5320, 0, '62.203.238.23', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.2988.0 Safari/537.36', 2146, 2149, '', '2017-07-27 21:18:40', 'completed', '', NULL),
 (5321, 0, '77.56.21.205', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2333, 2334, '', '2017-07-27 22:25:57', 'completed', '', NULL),
 (5322, 0, '40.77.167.106', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-28 03:38:34', 'completed', '', NULL),
 (5323, 0, '185.13.202.218', 'Java/1.8.0_131', 2128, 2367, '', '2017-07-28 05:38:14', 'completed', '', NULL),
 (5324, 0, '185.13.202.218', 'Java/1.8.0_131', 2146, 2149, '', '2017-07-28 05:38:16', 'completed', '', NULL),
 (5325, 0, '185.13.202.218', 'Java/1.8.0_131', 2333, 2334, '', '2017-07-28 05:38:17', 'completed', '', NULL),
 (5326, 0, '185.13.202.218', 'Java/1.8.0_131', 2140, 2141, '', '2017-07-28 05:38:21', 'completed', '', NULL),
 (5327, 0, '185.13.202.218', 'Java/1.8.0_131', 2336, 2337, '', '2017-07-28 05:38:23', 'completed', '', NULL),
 (5328, 0, '185.13.202.218', 'Java/1.8.0_131', 1837, 1839, '', '2017-07-28 05:38:26', 'completed', '', NULL),
 (5329, 0, '185.13.202.218', 'Java/1.8.0_131', 1844, 1845, '', '2017-07-28 05:38:28', 'completed', '', NULL),
 (5330, 0, '185.13.202.218', 'Java/1.8.0_131', 2339, 2340, '', '2017-07-28 05:38:29', 'completed', '', NULL),
 (5331, 0, '185.13.202.218', 'Java/1.8.0_131', 2130, 2133, '', '2017-07-28 05:38:33', 'completed', '', NULL),
 (5332, 0, '185.13.202.218', 'Java/1.8.0_131', 2134, 2307, '', '2017-07-28 05:38:36', 'completed', '', NULL),
 (5333, 0, '185.13.202.218', 'Java/1.8.0_131', 2161, 2162, '', '2017-07-28 05:38:39', 'completed', '', NULL),
 (5334, 0, '185.13.202.218', 'Java/1.8.0_131', 2342, 2349, '', '2017-07-28 05:38:42', 'completed', '', NULL),
 (5335, 0, '178.199.88.181', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2130, 2133, '', '2017-07-28 08:20:15', 'completed', '', NULL),
 (5336, 0, '93.191.248.48', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-07-28 08:55:56', 'completed', '', NULL),
 (5337, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-28 10:39:30', 'completed', '', NULL),
 (5338, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-28 10:51:23', 'completed', '', NULL),
 (5339, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-28 10:52:08', 'completed', '', NULL),
 (5340, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2128, 2367, '', '2017-07-28 10:53:49', 'completed', '', NULL),
 (5341, 0, '164.132.161.56', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2134, 2307, '', '2017-07-28 14:31:39', 'completed', '', NULL),
 (5342, 0, '212.225.226.62', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-28 15:57:24', 'completed', '', NULL),
 (5343, 0, '212.225.226.62', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-28 15:57:25', 'completed', '', NULL),
 (5344, 0, '212.225.226.62', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-28 15:57:26', 'completed', '', NULL),
 (5345, 0, '212.225.226.62', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-28 15:57:29', 'completed', '', NULL),
 (5346, 0, '212.225.226.62', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-28 15:57:31', 'completed', '', NULL),
 (5347, 0, '212.225.226.62', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-28 15:57:33', 'completed', '', NULL),
 (5348, 0, '212.225.226.62', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-28 15:57:34', 'completed', '', NULL),
 (5349, 0, '212.225.226.62', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-28 15:57:35', 'completed', '', NULL),
 (5350, 0, '212.225.226.62', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-28 15:57:37', 'completed', '', NULL),
 (5351, 0, '212.225.226.62', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-28 15:57:39', 'completed', '', NULL),
 (5352, 0, '212.225.226.62', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-28 15:57:41', 'completed', '', NULL),
 (5353, 0, '212.225.226.62', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-28 15:57:43', 'completed', '', NULL),
 (5354, 0, '178.197.225.142', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2134, 2307, '', '2017-07-28 21:42:31', 'completed', '', NULL),
 (5355, 0, '178.198.20.56', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_2_1 like Mac OS X) AppleWebKit/602.4.6 (KHTML, like Gecko) Version/10.0 Mobile/14D27 Safari/602.1', 2333, 2334, '', '2017-07-28 22:29:01', 'completed', '', NULL),
 (5356, 0, '207.46.13.12', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-28 22:41:21', 'completed', '', NULL),
 (5357, 0, '157.55.39.167', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-29 02:05:38', 'completed', '', NULL),
 (5358, 0, '157.55.39.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-29 03:44:13', 'completed', '', NULL),
 (5359, 0, '157.55.39.103', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-29 05:59:30', 'completed', '', NULL),
 (5360, 0, '65.55.210.124', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-29 07:02:52', 'completed', '', NULL),
 (5361, 0, '157.55.39.167', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-29 11:41:51', 'completed', '', NULL),
 (5362, 0, '40.77.167.129', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-07-30 03:22:15', 'completed', '', NULL),
 (5363, 0, '194.209.200.2', 'TMM Crawler/0.1', 2146, 2149, '', '2017-07-30 03:25:37', 'completed', '', NULL),
 (5364, 0, '40.77.167.129', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-07-30 05:59:56', 'completed', '', NULL),
 (5365, 0, '194.209.200.2', 'TMM Crawler/0.1', 2333, 2334, '', '2017-07-30 06:06:36', 'completed', '', NULL),
 (5366, 0, '194.209.200.2', 'TMM Crawler/0.1', 2339, 2340, '', '2017-07-30 08:18:27', 'completed', '', NULL),
 (5367, 0, '194.209.200.2', 'TMM Crawler/0.1', 2342, 2349, '', '2017-07-30 08:36:07', 'completed', '', NULL),
 (5368, 0, '194.209.200.2', 'TMM Crawler/0.1', 1844, 1845, '', '2017-07-30 10:53:24', 'completed', '', NULL),
 (5369, 0, '62.202.191.177', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2339, 2340, '', '2017-07-30 12:40:30', 'completed', '', NULL),
 (5370, 0, '62.202.191.177', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2146, 2149, '', '2017-07-30 12:43:11', 'completed', '', NULL),
 (5371, 0, '62.202.191.177', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2339, 2340, '', '2017-07-30 12:48:34', 'completed', '', NULL),
 (5372, 0, '62.202.191.177', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 1837, 1839, '', '2017-07-30 12:48:54', 'completed', '', NULL),
 (5373, 0, '62.202.191.177', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_5) AppleWebKit/600.8.9 (KHTML, like Gecko) Version/6.2.8 Safari/537.85.17', 2146, 2149, '', '2017-07-30 12:52:10', 'completed', '', NULL),
 (5374, 0, '178.197.236.192', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/17.1.129017588 Mobile/14E304 Safari/600.1.4', 2146, 2149, '', '2017-07-30 13:41:41', 'completed', '', NULL),
 (5375, 0, '178.197.236.192', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/600.1.4 (KHTML, like Gecko) GSA/17.1.129017588 Mobile/14E304 Safari/600.1.4', 2342, 2349, '', '2017-07-30 13:42:02', 'completed', '', NULL),
 (5376, 0, '194.209.200.2', 'TMM Crawler/0.1', 2134, 2307, '', '2017-07-30 14:28:43', 'completed', '', NULL),
 (5377, 0, '209.90.232.106', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-30 15:27:53', 'completed', '', NULL),
 (5378, 0, '209.90.232.106', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-30 15:27:56', 'completed', '', NULL),
 (5379, 0, '209.90.232.106', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-30 15:27:57', 'completed', '', NULL),
 (5380, 0, '209.90.232.106', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-30 15:28:01', 'completed', '', NULL),
 (5381, 0, '209.90.232.106', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-30 15:28:03', 'completed', '', NULL),
 (5382, 0, '209.90.232.106', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-30 15:28:06', 'completed', '', NULL),
 (5383, 0, '209.90.232.106', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-30 15:28:08', 'completed', '', NULL),
 (5384, 0, '209.90.232.106', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-30 15:28:09', 'completed', '', NULL),
 (5385, 0, '209.90.232.106', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-30 15:28:12', 'completed', '', NULL),
 (5386, 0, '209.90.232.106', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-30 15:28:14', 'completed', '', NULL),
 (5387, 0, '209.90.232.106', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-30 15:28:18', 'completed', '', NULL),
 (5388, 0, '209.90.232.106', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-30 15:28:20', 'completed', '', NULL),
 (5389, 0, '51.255.65.79', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 1837, 1839, '', '2017-07-30 16:22:22', 'completed', '', NULL),
 (5390, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-07-30 17:10:00', 'completed', '', NULL),
 (5391, 0, '157.55.39.69', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-07-30 17:13:05', 'completed', '', NULL),
 (5392, 0, '157.55.39.157', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-07-30 18:27:05', 'completed', '', NULL),
 (5393, 0, '194.209.200.2', 'TMM Crawler/0.1', 1837, 1839, '', '2017-07-30 18:37:09', 'completed', '', NULL),
 (5394, 0, '185.37.75.64', 'Mozilla/5.0 (iPhone; CPU iPhone OS 9_3_3 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13G34 Safari/601.1', 2146, 2149, '', '2017-07-30 20:32:22', 'completed', '', NULL),
 (5395, 0, '40.77.178.87', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-07-30 20:43:16', 'completed', '', NULL),
 (5396, 0, '194.209.200.2', 'TMM Crawler/0.1', 2336, 2337, '', '2017-07-30 21:31:26', 'completed', '', NULL),
 (5397, 0, '194.209.200.2', 'TMM Crawler/0.1', 2161, 2162, '', '2017-07-30 21:46:34', 'completed', '', NULL),
 (5398, 0, '194.209.200.2', 'TMM Crawler/0.1', 2130, 2133, '', '2017-07-30 22:41:44', 'completed', '', NULL),
 (5399, 0, '144.217.213.129', 'Java/1.6.0_04', 2128, 2367, '', '2017-07-31 00:18:57', 'completed', '', NULL),
 (5400, 0, '144.217.213.129', 'Java/1.6.0_04', 2146, 2149, '', '2017-07-31 00:18:58', 'completed', '', NULL),
 (5401, 0, '144.217.213.129', 'Java/1.6.0_04', 2333, 2334, '', '2017-07-31 00:18:59', 'completed', '', NULL),
 (5402, 0, '144.217.213.129', 'Java/1.6.0_04', 2140, 2141, '', '2017-07-31 00:19:02', 'completed', '', NULL),
 (5403, 0, '144.217.213.129', 'Java/1.6.0_04', 2336, 2337, '', '2017-07-31 00:19:04', 'completed', '', NULL),
 (5404, 0, '144.217.213.129', 'Java/1.6.0_04', 1837, 1839, '', '2017-07-31 00:19:07', 'completed', '', NULL),
 (5405, 0, '144.217.213.129', 'Java/1.6.0_04', 1844, 1845, '', '2017-07-31 00:19:08', 'completed', '', NULL),
 (5406, 0, '144.217.213.129', 'Java/1.6.0_04', 2339, 2340, '', '2017-07-31 00:19:09', 'completed', '', NULL),
 (5407, 0, '144.217.213.129', 'Java/1.6.0_04', 2130, 2133, '', '2017-07-31 00:19:11', 'completed', '', NULL),
 (5408, 0, '144.217.213.129', 'Java/1.6.0_04', 2134, 2307, '', '2017-07-31 00:19:12', 'completed', '', NULL),
 (5409, 0, '144.217.213.129', 'Java/1.6.0_04', 2161, 2162, '', '2017-07-31 00:19:15', 'completed', '', NULL),
 (5410, 0, '144.217.213.129', 'Java/1.6.0_04', 2342, 2349, '', '2017-07-31 00:19:17', 'completed', '', NULL),
 (5411, 0, '157.55.39.167', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-07-31 03:11:40', 'completed', '', NULL),
 (5412, 0, '194.209.200.2', 'TMM Crawler/0.1', 2128, 2367, '', '2017-07-31 04:36:21', 'completed', '', NULL),
 (5413, 0, '157.55.39.167', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-07-31 06:01:22', 'completed', '', NULL),
 (5414, 0, '157.55.39.69', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-07-31 08:18:08', 'completed', '', NULL),
 (5415, 0, '194.209.200.2', 'TMM Crawler/0.1', 2140, 2141, '', '2017-07-31 09:08:23', 'completed', '', NULL),
 (5416, 0, '77.74.0.4', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 1844, 1845, '', '2017-07-31 11:25:52', 'completed', '', NULL),
 (5417, 0, '77.74.0.4', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2339, 2340, '', '2017-07-31 11:26:37', 'completed', '', NULL),
 (5418, 0, '77.56.21.17', 'Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2342, 2349, '', '2017-07-31 17:54:43', 'completed', '', NULL),
 (5419, 0, '77.56.21.17', 'Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2134, 2307, '', '2017-07-31 18:35:30', 'completed', '', NULL),
 (5420, 0, '77.56.21.17', 'Mozilla/5.0 (Linux; Android 7.0; SM-G935F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2130, 2133, '', '2017-07-31 18:36:17', 'completed', '', NULL),
 (5421, 0, '178.38.114.64', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-07-31 20:10:37', 'completed', '', NULL),
 (5422, 0, '178.38.114.64', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2336, 2337, '', '2017-07-31 20:11:37', 'completed', '', NULL),
 (5423, 0, '178.197.229.82', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 1837, 1839, '', '2017-07-31 22:57:36', 'completed', '', NULL),
 (5424, 0, '178.197.229.82', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-07-31 23:36:27', 'completed', '', NULL),
 (5425, 0, '151.80.27.118', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2333, 2334, '', '2017-08-01 00:27:53', 'completed', '', NULL),
 (5426, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-08-01 05:09:04', 'completed', '', NULL),
 (5427, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-08-01 08:09:04', 'completed', '', NULL),
 (5428, 0, '178.197.229.82', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-08-01 11:35:38', 'completed', '', NULL),
 (5429, 0, '178.197.229.82', 'WhatsApp/2.17.40 i', 2333, 2334, '', '2017-08-01 11:35:54', 'completed', '', NULL),
 (5430, 0, '178.197.226.118', 'Mozilla/5.0 (Linux; Android 4.4.2; HIGHWAY 4G Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36;native-20minDE;app-android-smartphone-2', 2140, 2141, '', '2017-08-01 11:44:39', 'completed', '', NULL),
 (5431, 0, '178.197.229.20', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-08-01 16:49:02', 'completed', '', NULL),
 (5432, 0, '178.197.229.20', 'WhatsApp/2.17.40 i', 2333, 2334, '', '2017-08-01 16:49:13', 'completed', '', NULL),
 (5433, 0, '157.55.39.59', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-01 17:32:28', 'completed', '', NULL),
 (5434, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-08-01 19:50:47', 'completed', '', NULL),
 (5435, 0, '178.197.229.25', 'Mozilla/5.0 (Linux; Android 6.0; HUAWEI GRA-L09 Build/HUAWEIGRA-L09) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.89 Mobile Safari/537.36', 2333, 2334, '', '2017-08-01 20:55:24', 'completed', '', NULL),
 (5436, 0, '178.197.224.198', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2333, 2334, '', '2017-08-01 22:46:20', 'completed', '', NULL),
 (5437, 0, '178.197.224.198', 'WhatsApp/2.17.40 i', 2333, 2334, '', '2017-08-01 22:46:31', 'completed', '', NULL),
 (5438, 0, '157.55.39.96', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-08-02 01:58:14', 'completed', '', NULL),
 (5439, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-08-02 02:03:21', 'completed', '', NULL),
 (5440, 0, '199.30.24.232', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-08-02 03:58:20', 'completed', '', NULL),
 (5441, 0, '178.197.236.213', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2333, 2334, '', '2017-08-02 07:14:07', 'completed', '', NULL),
 (5442, 0, '178.197.236.213', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1844, 1845, '', '2017-08-02 07:22:53', 'completed', '', NULL),
 (5443, 0, '178.197.236.213', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2128, 2367, '', '2017-08-02 07:24:10', 'completed', '', NULL),
 (5444, 0, '178.197.236.213', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2333, 2334, '', '2017-08-02 11:18:01', 'completed', '', NULL),
 (5445, 0, '188.62.244.114', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2336, 2337, '', '2017-08-02 14:21:53', 'completed', '', NULL),
 (5446, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-08-02 14:28:00', 'completed', '', NULL),
 (5447, 0, '178.38.165.35', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8', 2134, 2307, '', '2017-08-02 15:37:13', 'completed', '', NULL),
 (5448, 0, '194.41.216.154', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2342, 2349, '', '2017-08-02 18:07:50', 'completed', '', NULL),
 (5449, 0, '194.41.216.154', 'Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko', 2134, 2307, '', '2017-08-02 18:09:54', 'completed', '', NULL),
 (5450, 0, '178.197.228.205', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2333, 2334, '', '2017-08-02 19:26:06', 'completed', '', NULL),
 (5451, 0, '178.197.228.226', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2333, 2334, '', '2017-08-02 19:28:32', 'completed', '', NULL),
 (5452, 0, '178.197.227.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 1844, 1845, '', '2017-08-02 21:12:37', 'completed', '', NULL),
 (5453, 0, '178.197.227.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/601.7.7 (KHTML, like Gecko) Version/9.1.2 Safari/601.7.7', 2128, 2367, '', '2017-08-02 21:15:15', 'completed', '', NULL),
 (5454, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2342, 2349, '', '2017-08-02 21:44:41', 'completed', '', NULL),
 (5455, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2134, 2307, '', '2017-08-02 21:48:19', 'completed', '', NULL),
 (5456, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2130, 2133, '', '2017-08-02 21:49:44', 'completed', '', NULL),
 (5457, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2134, 2307, '', '2017-08-02 21:49:55', 'completed', '', NULL),
 (5458, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2146, 2149, '', '2017-08-02 21:50:38', 'completed', '', NULL),
 (5459, 0, '51.255.65.20', 'Mozilla/5.0 (compatible; AhrefsBot/5.2; +http://ahrefs.com/robot/)', 2130, 2133, '', '2017-08-03 00:01:54', 'completed', '', NULL),
 (5460, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-08-03 03:43:31', 'completed', '', NULL),
 (5461, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-08-03 06:20:58', 'completed', '', NULL),
 (5462, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-08-03 08:18:46', 'completed', '', NULL),
 (5463, 0, '188.63.22.49', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2339, 2340, '', '2017-08-03 10:11:54', 'completed', '', NULL),
 (5464, 0, '188.63.22.49', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1844, 1845, '', '2017-08-03 10:12:10', 'completed', '', NULL),
 (5465, 0, '188.62.244.114', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/52.0.2743.116 Safari/537.36 Edge/15.15063', 2140, 2141, '', '2017-08-03 10:38:07', 'completed', '', NULL),
 (5466, 0, '157.55.39.191', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-08-03 12:28:29', 'completed', '', NULL),
 (5467, 0, '84.72.54.100', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_5) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.1.1 Safari/603.2.4', 1837, 1839, '', '2017-08-03 13:43:45', 'completed', '', NULL),
 (5468, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-03 13:52:17', 'completed', '', NULL),
 (5469, 0, '178.197.235.151', 'Mozilla/5.0 (Linux; Android 7.0; SM-G930F Build/NRD90M) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2134, 2307, '', '2017-08-03 17:16:45', 'completed', '', NULL),
 (5470, 0, '157.55.39.191', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-08-03 18:06:22', 'completed', '', NULL),
 (5471, 0, '199.30.25.5', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-08-03 19:07:55', 'completed', '', NULL),
 (5472, 0, '178.193.142.100', 'Mozilla/5.0 (Linux; Android 6.0.1; SM-T800 Build/MMB29K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2342, 2349, '', '2017-08-03 19:12:18', 'completed', '', NULL),
 (5473, 0, '207.46.13.78', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-08-03 20:21:58', 'completed', '', NULL),
 (5474, 0, '178.197.229.27', 'Mozilla/5.0 (Linux; Android 7.1.1; E5823 Build/32.4.A.0.160) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2339, 2340, '', '2017-08-03 20:34:20', 'completed', '', NULL),
 (5475, 0, '37.35.178.222', 'Java/1.8.0_60', 2128, 2367, '', '2017-08-03 20:42:23', 'completed', '', NULL),
 (5476, 0, '37.35.178.222', 'Java/1.8.0_60', 2146, 2149, '', '2017-08-03 20:42:32', 'completed', '', NULL),
 (5477, 0, '37.35.178.222', 'Java/1.8.0_60', 2333, 2334, '', '2017-08-03 20:42:33', 'completed', '', NULL),
 (5478, 0, '37.35.178.222', 'Java/1.8.0_60', 2140, 2141, '', '2017-08-03 20:42:52', 'completed', '', NULL),
 (5479, 0, '37.35.178.222', 'Java/1.8.0_60', 2336, 2337, '', '2017-08-03 20:43:09', 'completed', '', NULL),
 (5480, 0, '37.35.178.222', 'Java/1.8.0_60', 1837, 1839, '', '2017-08-03 20:43:39', 'completed', '', NULL),
 (5481, 0, '37.35.178.222', 'Java/1.8.0_60', 1844, 1845, '', '2017-08-03 20:43:47', 'completed', '', NULL),
 (5482, 0, '37.35.178.222', 'Java/1.8.0_60', 2339, 2340, '', '2017-08-03 20:43:51', 'completed', '', NULL),
 (5483, 0, '37.35.178.222', 'Java/1.8.0_60', 2130, 2133, '', '2017-08-03 20:44:02', 'completed', '', NULL),
 (5484, 0, '37.35.178.222', 'Java/1.8.0_60', 2134, 2307, '', '2017-08-03 20:44:05', 'completed', '', NULL),
 (5485, 0, '37.35.178.222', 'Java/1.8.0_60', 2161, 2162, '', '2017-08-03 20:44:47', 'completed', '', NULL),
 (5486, 0, '37.35.178.222', 'Java/1.8.0_60', 2342, 2349, '', '2017-08-03 20:44:59', 'completed', '', NULL),
 (5487, 0, '178.194.95.53', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1', 2342, 2349, '', '2017-08-04 00:18:09', 'completed', '', NULL),
 (5488, 0, '186.151.63.142', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2128, 2367, '', '2017-08-04 01:21:33', 'completed', '', NULL),
 (5489, 0, '186.151.63.142', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_5) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0.1 Safari/602.2.14', 2333, 2334, '', '2017-08-04 01:22:32', 'completed', '', NULL),
 (5490, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-08-04 06:32:34', 'completed', '', NULL),
 (5491, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-04 07:37:10', 'completed', '', NULL),
 (5492, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-04 07:37:12', 'completed', '', NULL),
 (5493, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-04 07:37:14', 'completed', '', NULL),
 (5494, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-04 07:37:18', 'completed', '', NULL),
 (5495, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-04 07:37:20', 'completed', '', NULL),
 (5496, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-04 07:37:23', 'completed', '', NULL),
 (5497, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-04 07:37:25', 'completed', '', NULL),
 (5498, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-04 07:37:27', 'completed', '', NULL),
 (5499, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-04 07:37:29', 'completed', '', NULL),
 (5500, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-04 07:37:32', 'completed', '', NULL);
INSERT INTO `wp_download_log` VALUES(5501, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-04 07:37:36', 'completed', '', NULL),
 (5502, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-04 07:37:39', 'completed', '', NULL),
 (5503, 0, '178.197.227.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2146, 2149, '', '2017-08-04 08:05:05', 'completed', '', NULL),
 (5504, 0, '178.197.227.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2134, 2307, '', '2017-08-04 08:05:39', 'completed', '', NULL),
 (5505, 0, '178.197.227.181', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_2 like Mac OS X) AppleWebKit/603.2.4 (KHTML, like Gecko) Version/10.0 Mobile/14F89 Safari/602.1', 2130, 2133, '', '2017-08-04 08:07:07', 'completed', '', NULL),
 (5506, 0, '157.55.39.191', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-08-04 08:35:27', 'completed', '', NULL),
 (5507, 0, '31.10.150.188', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.115 Safari/537.36 OPR/46.0.2597.57', 1844, 1845, '', '2017-08-04 18:14:58', 'completed', '', NULL),
 (5508, 0, '207.46.13.78', 'Mozilla/5.0 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-08-04 20:38:04', 'completed', '', NULL),
 (5509, 0, '81.17.30.19', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-04 20:51:07', 'completed', '', NULL),
 (5510, 0, '81.17.30.19', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-04 20:51:09', 'completed', '', NULL),
 (5511, 0, '81.17.30.19', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-04 20:51:11', 'completed', '', NULL),
 (5512, 0, '81.17.30.19', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-04 20:51:15', 'completed', '', NULL),
 (5513, 0, '81.17.30.19', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-04 20:51:16', 'completed', '', NULL),
 (5514, 0, '81.17.30.19', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-04 20:51:17', 'completed', '', NULL),
 (5515, 0, '31.11.18.6', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8', 1837, 1839, '', '2017-08-04 20:51:20', 'completed', '', NULL),
 (5516, 0, '81.17.30.19', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-04 20:51:21', 'completed', '', NULL),
 (5517, 0, '81.17.30.19', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-04 20:51:22', 'completed', '', NULL),
 (5518, 0, '81.17.30.19', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-04 20:51:25', 'completed', '', NULL),
 (5519, 0, '81.17.30.19', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-04 20:51:29', 'completed', '', NULL),
 (5520, 0, '81.17.30.19', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-04 20:51:31', 'completed', '', NULL),
 (5521, 0, '81.17.30.19', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-04 20:51:38', 'completed', '', NULL),
 (5522, 0, '31.11.18.6', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_6) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8', 2339, 2340, '', '2017-08-04 20:52:06', 'completed', '', NULL),
 (5523, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2140, 2141, '', '2017-08-04 21:01:25', 'completed', '', NULL),
 (5524, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2336, 2337, '', '2017-08-04 21:01:31', 'completed', '', NULL),
 (5525, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2146, 2149, '', '2017-08-04 21:01:35', 'completed', '', NULL),
 (5526, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2128, 2367, '', '2017-08-04 21:02:20', 'completed', '', NULL),
 (5527, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2333, 2334, '', '2017-08-04 21:02:25', 'completed', '', NULL),
 (5528, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2339, 2340, '', '2017-08-04 21:02:55', 'completed', '', NULL),
 (5529, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1837, 1839, '', '2017-08-04 21:03:00', 'completed', '', NULL),
 (5530, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 1844, 1845, '', '2017-08-04 21:03:06', 'completed', '', NULL),
 (5531, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2130, 2133, '', '2017-08-04 21:03:45', 'completed', '', NULL),
 (5532, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2161, 2162, '', '2017-08-04 21:03:51', 'completed', '', NULL),
 (5533, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2342, 2349, '', '2017-08-04 21:03:56', 'completed', '', NULL),
 (5534, 0, '104.236.113.27', 'Mozilla/5.0 (compatible; spbot/5.0.3; +http://OpenLinkProfiler.org/bot )', 2134, 2307, '', '2017-08-04 21:04:00', 'completed', '', NULL),
 (5535, 0, '157.55.39.191', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-08-04 21:53:35', 'completed', '', NULL),
 (5536, 0, '31.10.138.158', 'Mozilla/5.0 (Windows NT 6.1; rv:54.0) Gecko/20100101 Firefox/54.0', 2130, 2133, '', '2017-08-04 21:54:06', 'completed', '', NULL),
 (5537, 0, '31.10.138.158', 'Mozilla/5.0 (Windows NT 6.1; rv:54.0) Gecko/20100101 Firefox/54.0', 2134, 2307, '', '2017-08-04 21:54:48', 'completed', '', NULL),
 (5538, 0, '31.10.138.158', 'Mozilla/5.0 (Windows NT 6.1; rv:54.0) Gecko/20100101 Firefox/54.0', 2134, 2307, '', '2017-08-04 21:59:13', 'completed', '', NULL),
 (5539, 0, '178.196.133.139', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-P5210 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2342, 2349, '', '2017-08-04 22:48:12', 'completed', '', NULL),
 (5540, 0, '178.196.133.139', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-P5210 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2134, 2307, '', '2017-08-04 22:48:46', 'completed', '', NULL),
 (5541, 0, '178.196.133.139', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-P5210 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2130, 2133, '', '2017-08-04 22:50:24', 'completed', '', NULL),
 (5542, 0, '178.196.133.139', 'Mozilla/5.0 (Linux; Android 4.4.2; GT-P5210 Build/KOT49H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Safari/537.36', 2146, 2149, '', '2017-08-04 22:51:49', 'completed', '', NULL),
 (5543, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-08-05 04:30:21', 'completed', '', NULL),
 (5544, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-08-05 08:37:32', 'completed', '', NULL),
 (5545, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-05 12:50:35', 'completed', '', NULL),
 (5546, 0, '157.55.39.191', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-08-05 16:14:51', 'completed', '', NULL),
 (5547, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-08-05 16:28:29', 'completed', '', NULL),
 (5548, 0, '199.30.25.194', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-08-05 18:51:53', 'completed', '', NULL),
 (5549, 0, '188.60.166.249', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2128, 2367, '', '2017-08-05 19:57:20', 'completed', '', NULL),
 (5550, 0, '188.60.166.249', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2333, 2334, '', '2017-08-05 20:01:09', 'completed', '', NULL),
 (5551, 0, '37.35.179.75', 'Java/1.8.0_131', 2128, 2367, '', '2017-08-06 01:33:44', 'completed', '', NULL),
 (5552, 0, '37.35.179.75', 'Java/1.8.0_131', 2146, 2149, '', '2017-08-06 01:33:51', 'completed', '', NULL),
 (5553, 0, '37.35.179.75', 'Java/1.8.0_131', 2333, 2334, '', '2017-08-06 01:33:52', 'completed', '', NULL),
 (5554, 0, '37.35.179.75', 'Java/1.8.0_131', 2140, 2141, '', '2017-08-06 01:34:06', 'completed', '', NULL),
 (5555, 0, '37.35.179.75', 'Java/1.8.0_131', 2336, 2337, '', '2017-08-06 01:34:11', 'completed', '', NULL),
 (5556, 0, '37.35.179.75', 'Java/1.8.0_131', 1837, 1839, '', '2017-08-06 01:34:20', 'completed', '', NULL),
 (5557, 0, '37.35.179.75', 'Java/1.8.0_131', 1844, 1845, '', '2017-08-06 01:34:24', 'completed', '', NULL),
 (5558, 0, '37.35.179.75', 'Java/1.8.0_131', 2339, 2340, '', '2017-08-06 01:34:26', 'completed', '', NULL),
 (5559, 0, '37.35.179.75', 'Java/1.8.0_131', 2130, 2133, '', '2017-08-06 01:34:42', 'completed', '', NULL),
 (5560, 0, '37.35.179.75', 'Java/1.8.0_131', 2134, 2307, '', '2017-08-06 01:34:52', 'completed', '', NULL),
 (5561, 0, '37.35.179.75', 'Java/1.8.0_131', 2161, 2162, '', '2017-08-06 01:35:01', 'completed', '', NULL),
 (5562, 0, '37.35.179.75', 'Java/1.8.0_131', 2342, 2349, '', '2017-08-06 01:35:15', 'completed', '', NULL),
 (5563, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-08-06 01:51:13', 'completed', '', NULL),
 (5564, 0, '40.77.167.145', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-08-06 05:10:26', 'completed', '', NULL),
 (5565, 0, '37.49.224.135', 'Java/1.8.0_144', 2128, 2367, '', '2017-08-06 08:17:47', 'completed', '', NULL),
 (5566, 0, '37.49.224.135', 'Java/1.8.0_144', 2146, 2149, '', '2017-08-06 08:17:48', 'completed', '', NULL),
 (5567, 0, '37.49.224.135', 'Java/1.8.0_144', 2333, 2334, '', '2017-08-06 08:17:49', 'completed', '', NULL),
 (5568, 0, '37.49.224.135', 'Java/1.8.0_144', 2140, 2141, '', '2017-08-06 08:17:51', 'completed', '', NULL),
 (5569, 0, '37.49.224.135', 'Java/1.8.0_144', 2336, 2337, '', '2017-08-06 08:17:52', 'completed', '', NULL),
 (5570, 0, '37.49.224.135', 'Java/1.8.0_144', 1837, 1839, '', '2017-08-06 08:17:53', 'completed', '', NULL),
 (5571, 0, '37.49.224.135', 'Java/1.8.0_144', 1844, 1845, '', '2017-08-06 08:17:54', 'completed', '', NULL),
 (5572, 0, '37.49.224.135', 'Java/1.8.0_144', 2339, 2340, '', '2017-08-06 08:17:55', 'completed', '', NULL),
 (5573, 0, '37.49.224.135', 'Java/1.8.0_144', 2130, 2133, '', '2017-08-06 08:17:56', 'completed', '', NULL),
 (5574, 0, '37.49.224.135', 'Java/1.8.0_144', 2134, 2307, '', '2017-08-06 08:17:57', 'completed', '', NULL),
 (5575, 0, '37.49.224.135', 'Java/1.8.0_144', 2161, 2162, '', '2017-08-06 08:17:58', 'completed', '', NULL),
 (5576, 0, '37.49.224.135', 'Java/1.8.0_144', 2342, 2349, '', '2017-08-06 08:17:59', 'completed', '', NULL),
 (5577, 0, '83.76.39.207', 'Mozilla/5.0 (Windows NT 6.1; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2146, 2149, '', '2017-08-06 15:08:00', 'completed', '', NULL),
 (5578, 0, '188.60.166.249', 'Mozilla/5.0 (iPad; CPU OS 10_1_1 like Mac OS X) AppleWebKit/602.2.14 (KHTML, like Gecko) Version/10.0 Mobile/14B100 Safari/602.1', 2128, 2367, '', '2017-08-06 17:15:20', 'completed', '', NULL),
 (5579, 0, '188.61.254.244', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8', 2140, 2141, '', '2017-08-06 17:38:25', 'completed', '', NULL),
 (5580, 0, '207.46.13.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-08-06 18:40:21', 'completed', '', NULL),
 (5581, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-08-07 01:30:15', 'completed', '', NULL),
 (5582, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-08-07 03:03:34', 'completed', '', NULL),
 (5583, 0, '207.46.13.58', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-08-07 03:53:03', 'completed', '', NULL),
 (5584, 0, '207.46.13.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-08-07 06:03:37', 'completed', '', NULL),
 (5585, 0, '83.77.46.224', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_12_6) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.1.2 Safari/603.3.8', 1837, 1839, '', '2017-08-07 10:03:34', 'completed', '', NULL),
 (5586, 0, '197.96.129.180', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2134, 2307, '', '2017-08-07 10:14:30', 'completed', '', NULL),
 (5587, 0, '198.240.212.2', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2134, 2307, '', '2017-08-07 10:14:32', 'completed', '', NULL),
 (5588, 0, '197.96.129.180', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2130, 2133, '', '2017-08-07 10:15:22', 'completed', '', NULL),
 (5589, 0, '198.240.212.2', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2130, 2133, '', '2017-08-07 10:15:24', 'completed', '', NULL),
 (5590, 0, '197.96.129.180', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2146, 2149, '', '2017-08-07 10:16:00', 'completed', '', NULL),
 (5591, 0, '198.240.212.2', 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.98 Safari/537.36', 2146, 2149, '', '2017-08-07 10:16:01', 'completed', '', NULL),
 (5592, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-07 11:18:55', 'completed', '', NULL),
 (5593, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-07 11:19:15', 'completed', '', NULL),
 (5594, 0, '37.35.178.222', 'Java/1.8.0_60', 2128, 2367, '', '2017-08-07 11:44:57', 'completed', '', NULL),
 (5595, 0, '37.35.178.222', 'Java/1.8.0_60', 2146, 2149, '', '2017-08-07 11:45:01', 'completed', '', NULL),
 (5596, 0, '37.35.178.222', 'Java/1.8.0_60', 2333, 2334, '', '2017-08-07 11:45:03', 'completed', '', NULL),
 (5597, 0, '37.35.178.222', 'Java/1.8.0_60', 2140, 2141, '', '2017-08-07 11:45:16', 'completed', '', NULL),
 (5598, 0, '37.35.178.222', 'Java/1.8.0_60', 2336, 2337, '', '2017-08-07 11:45:21', 'completed', '', NULL),
 (5599, 0, '37.35.178.222', 'Java/1.8.0_60', 1837, 1839, '', '2017-08-07 11:45:31', 'completed', '', NULL),
 (5600, 0, '37.35.178.222', 'Java/1.8.0_60', 1844, 1845, '', '2017-08-07 11:45:34', 'completed', '', NULL),
 (5601, 0, '37.35.178.222', 'Java/1.8.0_60', 2339, 2340, '', '2017-08-07 11:45:36', 'completed', '', NULL),
 (5602, 0, '37.35.178.222', 'Java/1.8.0_60', 2130, 2133, '', '2017-08-07 11:45:46', 'completed', '', NULL),
 (5603, 0, '37.35.178.222', 'Java/1.8.0_60', 2134, 2307, '', '2017-08-07 11:45:59', 'completed', '', NULL),
 (5604, 0, '37.35.178.222', 'Java/1.8.0_60', 2161, 2162, '', '2017-08-07 11:46:13', 'completed', '', NULL),
 (5605, 0, '37.35.178.222', 'Java/1.8.0_60', 2342, 2349, '', '2017-08-07 11:46:28', 'completed', '', NULL),
 (5606, 0, '178.197.229.84', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2333, 2334, '', '2017-08-07 15:25:02', 'completed', '', NULL),
 (5607, 0, '207.46.13.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2342, 2349, '', '2017-08-07 18:47:02', 'completed', '', NULL),
 (5608, 0, '199.30.25.136', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2342, 2349, '', '2017-08-07 19:48:28', 'completed', '', NULL),
 (5609, 0, '139.47.18.201', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-07 22:41:18', 'completed', '', NULL),
 (5610, 0, '139.47.18.201', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-07 22:41:21', 'completed', '', NULL),
 (5611, 0, '139.47.18.201', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-07 22:41:22', 'completed', '', NULL),
 (5612, 0, '139.47.18.201', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-07 22:41:31', 'completed', '', NULL),
 (5613, 0, '139.47.18.201', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-07 22:41:33', 'completed', '', NULL),
 (5614, 0, '139.47.18.201', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-07 22:41:37', 'completed', '', NULL),
 (5615, 0, '139.47.18.201', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-07 22:41:39', 'completed', '', NULL),
 (5616, 0, '139.47.18.201', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-07 22:41:41', 'completed', '', NULL),
 (5617, 0, '139.47.18.201', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-07 22:41:44', 'completed', '', NULL),
 (5618, 0, '139.47.18.201', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-07 22:41:47', 'completed', '', NULL),
 (5619, 0, '139.47.18.201', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-07 22:41:53', 'completed', '', NULL),
 (5620, 0, '139.47.18.201', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-07 22:42:01', 'completed', '', NULL),
 (5621, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-08-07 23:27:21', 'completed', '', NULL),
 (5622, 0, '207.46.13.58', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-08-08 02:06:21', 'completed', '', NULL),
 (5623, 0, '207.46.13.58', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2134, 2307, '', '2017-08-08 07:12:03', 'completed', '', NULL),
 (5624, 0, '77.59.152.104', 'Mozilla/5.0 (Linux; Android 5.0.1; GT-I9505 Build/LRX22C) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/59.0.3071.125 Mobile Safari/537.36', 2342, 2349, '', '2017-08-08 13:11:23', 'completed', '', NULL),
 (5625, 0, '81.63.151.157', 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko', 2336, 2337, '', '2017-08-08 14:20:24', 'completed', '', NULL),
 (5626, 0, '86.87.197.7', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-08 14:56:21', 'completed', '', NULL),
 (5627, 0, '86.87.197.7', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-08 14:56:22', 'completed', '', NULL),
 (5628, 0, '86.87.197.7', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-08 14:56:23', 'completed', '', NULL),
 (5629, 0, '86.87.197.7', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-08 14:56:27', 'completed', '', NULL),
 (5630, 0, '86.87.197.7', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-08 14:56:28', 'completed', '', NULL),
 (5631, 0, '86.87.197.7', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-08 14:56:30', 'completed', '', NULL),
 (5632, 0, '86.87.197.7', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-08 14:56:32', 'completed', '', NULL),
 (5633, 0, '86.87.197.7', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-08 14:56:33', 'completed', '', NULL),
 (5634, 0, '86.87.197.7', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-08 14:56:36', 'completed', '', NULL),
 (5635, 0, '86.87.197.7', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-08 14:56:37', 'completed', '', NULL),
 (5636, 0, '86.87.197.7', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-08 14:56:40', 'completed', '', NULL),
 (5637, 0, '86.87.197.7', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-08 14:56:43', 'completed', '', NULL),
 (5638, 0, '87.154.123.97', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_5_8) AppleWebKit/534.50.2 (KHTML, like Gecko) Version/5.0.6 Safari/533.22.3', 2336, 2337, '', '2017-08-08 15:44:03', 'completed', '', NULL),
 (5639, 0, '87.154.123.97', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_5_8) AppleWebKit/534.50.2 (KHTML, like Gecko) Version/5.0.6 Safari/533.22.3', 2339, 2340, '', '2017-08-08 15:45:04', 'completed', '', NULL),
 (5640, 0, '84.226.41.253', 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.11; rv:54.0) Gecko/20100101 Firefox/54.0', 2339, 2340, '', '2017-08-08 18:17:07', 'completed', '', NULL),
 (5641, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-08 18:37:42', 'completed', '', NULL),
 (5642, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-08 18:37:44', 'completed', '', NULL),
 (5643, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-08 18:37:45', 'completed', '', NULL),
 (5644, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-08 18:37:49', 'completed', '', NULL),
 (5645, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-08 18:37:51', 'completed', '', NULL),
 (5646, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-08 18:37:54', 'completed', '', NULL),
 (5647, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-08 18:37:56', 'completed', '', NULL),
 (5648, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-08 18:37:57', 'completed', '', NULL),
 (5649, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-08 18:38:00', 'completed', '', NULL),
 (5650, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-08 18:38:03', 'completed', '', NULL),
 (5651, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-08 18:38:07', 'completed', '', NULL),
 (5652, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-08 18:38:10', 'completed', '', NULL),
 (5653, 0, '207.46.13.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2140, 2141, '', '2017-08-08 19:03:41', 'completed', '', NULL),
 (5654, 0, '181.41.204.15', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-09 00:10:11', 'completed', '', NULL),
 (5655, 0, '181.41.204.15', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-09 00:10:13', 'completed', '', NULL),
 (5656, 0, '181.41.204.15', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-09 00:10:14', 'completed', '', NULL),
 (5657, 0, '181.41.204.15', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-09 00:10:19', 'completed', '', NULL),
 (5658, 0, '181.41.204.15', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-09 00:10:20', 'completed', '', NULL),
 (5659, 0, '181.41.204.15', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-09 00:10:23', 'completed', '', NULL),
 (5660, 0, '181.41.204.15', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-09 00:10:25', 'completed', '', NULL),
 (5661, 0, '181.41.204.15', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-09 00:10:26', 'completed', '', NULL),
 (5662, 0, '181.41.204.15', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-09 00:10:30', 'completed', '', NULL),
 (5663, 0, '181.41.204.15', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-09 00:10:32', 'completed', '', NULL),
 (5664, 0, '181.41.204.15', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-09 00:10:36', 'completed', '', NULL),
 (5665, 0, '181.41.204.15', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-09 00:10:38', 'completed', '', NULL),
 (5666, 0, '194.209.200.2', 'TMM Crawler/0.1', 2146, 2149, '', '2017-08-09 01:55:29', 'completed', '', NULL),
 (5667, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2130, 2133, '', '2017-08-09 02:23:11', 'completed', '', NULL),
 (5668, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2339, 2340, '', '2017-08-09 03:39:07', 'completed', '', NULL),
 (5669, 0, '194.209.200.2', 'TMM Crawler/0.1', 2333, 2334, '', '2017-08-09 04:31:02', 'completed', '', NULL),
 (5670, 0, '207.46.13.77', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2336, 2337, '', '2017-08-09 04:50:15', 'completed', '', NULL),
 (5671, 0, '207.46.13.3', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2333, 2334, '', '2017-08-09 05:54:09', 'completed', '', NULL),
 (5672, 0, '194.209.200.2', 'TMM Crawler/0.1', 2339, 2340, '', '2017-08-09 06:36:00', 'completed', '', NULL),
 (5673, 0, '194.209.200.2', 'TMM Crawler/0.1', 2342, 2349, '', '2017-08-09 06:52:30', 'completed', '', NULL),
 (5674, 0, '194.209.200.2', 'TMM Crawler/0.1', 2146, 2149, '', '2017-08-09 08:14:01', 'completed', '', NULL),
 (5675, 0, '81.221.146.224', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2336, 2337, '', '2017-08-09 08:54:22', 'completed', '', NULL),
 (5676, 0, '81.221.146.224', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2140, 2141, '', '2017-08-09 08:57:59', 'completed', '', NULL),
 (5677, 0, '194.209.200.2', 'TMM Crawler/0.1', 1844, 1845, '', '2017-08-09 09:05:54', 'completed', '', NULL),
 (5678, 0, '194.209.200.2', 'TMM Crawler/0.1', 2333, 2334, '', '2017-08-09 10:29:34', 'completed', '', NULL),
 (5679, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-09 11:51:28', 'completed', '', NULL),
 (5680, 0, '194.209.200.2', 'TMM Crawler/0.1', 2339, 2340, '', '2017-08-09 12:25:48', 'completed', '', NULL),
 (5681, 0, '194.209.200.2', 'TMM Crawler/0.1', 2342, 2349, '', '2017-08-09 12:41:26', 'completed', '', NULL),
 (5682, 0, '194.209.200.2', 'TMM Crawler/0.1', 2134, 2307, '', '2017-08-09 12:44:44', 'completed', '', NULL),
 (5683, 0, '172.245.222.13', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-09 13:48:17', 'completed', '', NULL),
 (5684, 0, '172.245.222.13', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-09 13:48:19', 'completed', '', NULL),
 (5685, 0, '172.245.222.13', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-09 13:48:20', 'completed', '', NULL),
 (5686, 0, '172.245.222.13', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-09 13:48:25', 'completed', '', NULL),
 (5687, 0, '172.245.222.13', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-09 13:48:27', 'completed', '', NULL),
 (5688, 0, '172.245.222.13', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-09 13:48:30', 'completed', '', NULL),
 (5689, 0, '172.245.222.13', 'Java/1.6.0_04', 1844, 1845, '', '2017-08-09 13:48:33', 'completed', '', NULL),
 (5690, 0, '172.245.222.13', 'Java/1.6.0_04', 2339, 2340, '', '2017-08-09 13:48:35', 'completed', '', NULL),
 (5691, 0, '172.245.222.13', 'Java/1.6.0_04', 2130, 2133, '', '2017-08-09 13:48:38', 'completed', '', NULL),
 (5692, 0, '172.245.222.13', 'Java/1.6.0_04', 2134, 2307, '', '2017-08-09 13:48:40', 'completed', '', NULL),
 (5693, 0, '172.245.222.13', 'Java/1.6.0_04', 2161, 2162, '', '2017-08-09 13:48:44', 'completed', '', NULL),
 (5694, 0, '172.245.222.13', 'Java/1.6.0_04', 2342, 2349, '', '2017-08-09 13:48:48', 'completed', '', NULL),
 (5695, 0, '213.221.250.131', 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.90 Safari/537.36', 2128, 2367, '', '2017-08-09 13:59:46', 'completed', '', NULL),
 (5696, 0, '157.55.39.199', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2161, 2162, '', '2017-08-09 14:39:34', 'completed', '', NULL),
 (5697, 0, '194.209.200.2', 'TMM Crawler/0.1', 1844, 1845, '', '2017-08-09 14:43:46', 'completed', '', NULL),
 (5698, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2146, 2149, '', '2017-08-09 14:56:57', 'completed', '', NULL),
 (5699, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2140, 2141, '', '2017-08-09 14:58:08', 'completed', '', NULL),
 (5700, 0, '91.138.72.15', 'Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.79 Safari/537.36 Edge/14.14393', 2336, 2337, '', '2017-08-09 14:59:14', 'completed', '', NULL),
 (5701, 0, '65.55.210.22', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 BingPreview/1.0b', 2161, 2162, '', '2017-08-09 15:40:33', 'completed', '', NULL),
 (5702, 0, '5.40.19.104', 'Java/1.8.0_144', 2128, 2367, '', '2017-08-09 16:27:04', 'completed', '', NULL),
 (5703, 0, '5.40.19.104', 'Java/1.8.0_144', 2146, 2149, '', '2017-08-09 16:27:06', 'completed', '', NULL),
 (5704, 0, '5.40.19.104', 'Java/1.8.0_144', 2333, 2334, '', '2017-08-09 16:27:07', 'completed', '', NULL),
 (5705, 0, '5.40.19.104', 'Java/1.8.0_144', 2140, 2141, '', '2017-08-09 16:27:11', 'completed', '', NULL),
 (5706, 0, '5.40.19.104', 'Java/1.8.0_144', 2336, 2337, '', '2017-08-09 16:27:13', 'completed', '', NULL),
 (5707, 0, '5.40.19.104', 'Java/1.8.0_144', 1837, 1839, '', '2017-08-09 16:27:15', 'completed', '', NULL),
 (5708, 0, '5.40.19.104', 'Java/1.8.0_144', 1844, 1845, '', '2017-08-09 16:27:17', 'completed', '', NULL),
 (5709, 0, '5.40.19.104', 'Java/1.8.0_144', 2339, 2340, '', '2017-08-09 16:27:19', 'completed', '', NULL),
 (5710, 0, '5.40.19.104', 'Java/1.8.0_144', 2130, 2133, '', '2017-08-09 16:27:23', 'completed', '', NULL),
 (5711, 0, '5.40.19.104', 'Java/1.8.0_144', 2134, 2307, '', '2017-08-09 16:27:25', 'completed', '', NULL),
 (5712, 0, '5.40.19.104', 'Java/1.8.0_144', 2161, 2162, '', '2017-08-09 16:27:28', 'completed', '', NULL),
 (5713, 0, '5.40.19.104', 'Java/1.8.0_144', 2342, 2349, '', '2017-08-09 16:27:33', 'completed', '', NULL),
 (5714, 0, '194.209.200.2', 'TMM Crawler/0.1', 1837, 1839, '', '2017-08-09 16:57:04', 'completed', '', NULL),
 (5715, 0, '84.226.73.145', 'Mozilla/5.0 (Windows NT 10.0; WOW64; rv:54.0) Gecko/20100101 Firefox/54.0', 2342, 2349, '', '2017-08-09 16:59:05', 'completed', '', NULL),
 (5716, 0, '157.55.39.227', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2146, 2149, '', '2017-08-09 17:05:56', 'completed', '', NULL),
 (5717, 0, '194.209.200.2', 'TMM Crawler/0.1', 2134, 2307, '', '2017-08-09 17:59:11', 'completed', '', NULL),
 (5718, 0, '194.209.200.2', 'TMM Crawler/0.1', 2336, 2337, '', '2017-08-09 19:43:41', 'completed', '', NULL),
 (5719, 0, '194.209.200.2', 'TMM Crawler/0.1', 2161, 2162, '', '2017-08-09 19:56:59', 'completed', '', NULL),
 (5720, 0, '194.209.200.2', 'TMM Crawler/0.1', 2130, 2133, '', '2017-08-09 20:46:21', 'completed', '', NULL),
 (5721, 0, '194.209.200.2', 'TMM Crawler/0.1', 1837, 1839, '', '2017-08-09 21:43:07', 'completed', '', NULL),
 (5722, 0, '178.197.224.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2339, 2340, '', '2017-08-09 22:51:30', 'completed', '', NULL),
 (5723, 0, '178.197.224.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1837, 1839, '', '2017-08-09 22:52:48', 'completed', '', NULL),
 (5724, 0, '178.197.224.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 1837, 1839, '', '2017-08-09 23:35:50', 'completed', '', NULL),
 (5725, 0, '178.197.224.85', 'Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_3 like Mac OS X) AppleWebKit/603.3.8 (KHTML, like Gecko) Version/10.0 Mobile/14G60 Safari/602.1', 2339, 2340, '', '2017-08-09 23:58:04', 'completed', '', NULL),
 (5726, 0, '194.209.200.2', 'TMM Crawler/0.1', 2336, 2337, '', '2017-08-10 00:20:48', 'completed', '', NULL),
 (5727, 0, '194.209.200.2', 'TMM Crawler/0.1', 2161, 2162, '', '2017-08-10 00:33:58', 'completed', '', NULL),
 (5728, 0, '194.209.200.2', 'TMM Crawler/0.1', 2130, 2133, '', '2017-08-10 01:22:00', 'completed', '', NULL),
 (5729, 0, '194.209.200.2', 'TMM Crawler/0.1', 2128, 2367, '', '2017-08-10 01:43:19', 'completed', '', NULL),
 (5730, 0, '139.47.18.201', 'Java/1.8.0_25', 2128, 2367, '', '2017-08-10 01:46:41', 'completed', '', NULL),
 (5731, 0, '139.47.18.201', 'Java/1.8.0_25', 2146, 2149, '', '2017-08-10 01:46:45', 'completed', '', NULL),
 (5732, 0, '139.47.18.201', 'Java/1.8.0_25', 2333, 2334, '', '2017-08-10 01:46:48', 'completed', '', NULL),
 (5733, 0, '139.47.18.201', 'Java/1.8.0_25', 2140, 2141, '', '2017-08-10 01:47:03', 'completed', '', NULL),
 (5734, 0, '139.47.18.201', 'Java/1.8.0_25', 2336, 2337, '', '2017-08-10 01:47:06', 'completed', '', NULL),
 (5735, 0, '139.47.18.201', 'Java/1.8.0_25', 1837, 1839, '', '2017-08-10 01:47:18', 'completed', '', NULL),
 (5736, 0, '139.47.18.201', 'Java/1.8.0_25', 1844, 1845, '', '2017-08-10 01:47:20', 'completed', '', NULL),
 (5737, 0, '139.47.18.201', 'Java/1.8.0_25', 2339, 2340, '', '2017-08-10 01:47:25', 'completed', '', NULL),
 (5738, 0, '139.47.18.201', 'Java/1.8.0_25', 2130, 2133, '', '2017-08-10 01:47:29', 'completed', '', NULL),
 (5739, 0, '139.47.18.201', 'Java/1.8.0_25', 2134, 2307, '', '2017-08-10 01:47:33', 'completed', '', NULL),
 (5740, 0, '139.47.18.201', 'Java/1.8.0_25', 2161, 2162, '', '2017-08-10 01:47:45', 'completed', '', NULL),
 (5741, 0, '139.47.18.201', 'Java/1.8.0_25', 2342, 2349, '', '2017-08-10 01:47:51', 'completed', '', NULL),
 (5742, 0, '207.46.13.77', 'Mozilla/5.0 (iPhone; CPU iPhone OS 7_0 like Mac OS X) AppleWebKit/537.51.1 (KHTML, like Gecko) Version/7.0 Mobile/11A465 Safari/9537.53 (compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm)', 2128, 2367, '', '2017-08-10 01:58:04', 'completed', '', NULL),
 (5743, 0, '194.209.200.2', 'TMM Crawler/0.1', 2140, 2141, '', '2017-08-10 04:34:11', 'completed', '', NULL),
 (5744, 0, '194.209.200.2', 'TMM Crawler/0.1', 2128, 2367, '', '2017-08-10 05:58:57', 'completed', '', NULL),
 (5745, 0, '172.245.222.13', 'Java/1.6.0_04', 2128, 2367, '', '2017-08-10 07:42:15', 'completed', '', NULL),
 (5746, 0, '172.245.222.13', 'Java/1.6.0_04', 2146, 2149, '', '2017-08-10 07:42:17', 'completed', '', NULL),
 (5747, 0, '172.245.222.13', 'Java/1.6.0_04', 2333, 2334, '', '2017-08-10 07:42:21', 'completed', '', NULL),
 (5748, 0, '172.245.222.13', 'Java/1.6.0_04', 2140, 2141, '', '2017-08-10 07:42:30', 'completed', '', NULL),
 (5749, 0, '172.245.222.13', 'Java/1.6.0_04', 2336, 2337, '', '2017-08-10 07:42:32', 'completed', '', NULL),
 (5750, 0, '172.245.222.13', 'Java/1.6.0_04', 1837, 1839, '', '2017-08-10 07:42:41', 'completed', '', NULL