<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_filter( 'cmb2_admin_init', 'kadence_custom_fonts_metaboxes');
function kadence_custom_fonts_metaboxes(){
	$prefix = '_kad_';
	$kt_font_post = new_cmb2_box( array(
		'id'         	=> 'custom_fonts_metabox',
		'title'      	=> __("Font Details", 'kadence-custom-fonts'),
		'object_types'  => array('kt_font'),
		'priority'   	=> 'high',
	) );
	$kt_font_post->add_field( array(
		'name'    	=> __('Font Family Name', 'kadence-custom-fonts'),
		'desc'    	=> __('Make sure it matches exactly with the font e.g. Raleway', 'kadence-custom-fonts' ),
		'id'      	=> $prefix . 'font_name',
		'type'	  	=> 'text',
	) );
	$kt_font_post->add_field( array(
		'name'    	=> __('Font Specific Style Name - Optional', 'kadence-custom-fonts'),
		'desc'    	=> __('Make sure it matches exactly with the font e.g. Raleway Bold Italic', 'kadence-custom-fonts' ),
		'id'      	=> $prefix . 'font_style_name',
		'type'	  	=> 'text',
	) );
	$kt_font_post->add_field( array(
		'name'    => __('.eot Font file', 'kadence-custom-fonts' ),
		'desc'    => __('Upload .eot font file.', 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_eot',
		'type'    => 'file',
		// Optional:
		'options' => array(
			'url' => false, // Hide the text input for the url
		),
		'text'    => array(
			'add_upload_file_text' => 'Add Font' // Change upload button text. Default: "Add or Upload File"
		),
		'query_args' => array(
			'type' => 'application/vnd.ms-fontobject', // Make library only display eots.
		),
		'preview_size' => 'none', // Image size to use when previewing in the admin.
	) );
	$kt_font_post->add_field( array(
		'name'    => __('.woff2 Font file', 'kadence-custom-fonts' ),
		'desc'    => __('Upload .woff2 font file.', 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_woff2',
		'type'    => 'file',
		// Optional:
		'options' => array(
			'url' => false, // Hide the text input for the url
		),
		'text'    => array(
			'add_upload_file_text' => 'Add Font'
		),
		'query_args' => array(
			'type' => array(
				'application/font-woff2',
				'font/woff2',
			),
		),
		'preview_size' => 'none', // Image size to use when previewing in the admin.
	) );
	$kt_font_post->add_field( array(
		'name'    => __('.woff Font file', 'kadence-custom-fonts' ),
		'desc'    => __('Upload .woff font file.', 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_woff',
		'type'    => 'file',
		// Optional:
		'options' => array(
			'url' => false, // Hide the text input for the url
		),
		'text'    => array(
			'add_upload_file_text' => 'Add File' // Change upload button text. Default: "Add or Upload File"
		),
		'query_args' => array(
			'type' => 'application/font-woff', // Make library only display eots.
		),
		'preview_size' => 'none', // Image size to use when previewing in the admin.
	) );
	$kt_font_post->add_field( array(
		'name'    => __('.ttf Font file', 'kadence-custom-fonts' ),
		'desc'    => __('Upload .ttf font file.', 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_tiff',
		'type'    => 'file',
		'options' => array(
			'url' => false,
		),
		'text'    => array(
			'add_upload_file_text' => __('Add Font', 'kadence-custom-fonts' ),
		),
		'query_args' => array(
			'type' => array(
				'application/font-sfnt',
				'font/opentype',
			),
		),
		'preview_size' => 'none',
	) );
	$kt_font_post->add_field( array(
		'name'    => __('.svg Font file', 'kadence-custom-fonts' ),
		'desc'    => __('Upload .svg font file.', 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_svg',
		'type'    => 'file',
		'options' => array(
			'url' => false,
		),
		'text'    => array(
			'add_upload_file_text' => __('Add Font', 'kadence-custom-fonts' ),
		),
		'query_args' => array(
			'type' => 'image/svg+xml',
		),
		'preview_size' => 'none',
	) );
	$kt_font_post->add_field( array(
		'name'    => __("Font Weight", 'kadence-custom-fonts' ),
		'desc'    => '',
		'id'      => $prefix . 'font_weight',
		'type'    => 'select',
		'default' => '400',
		'options' => array(
			'100' => __('100', 'kadence-custom-fonts' ),
			'200' => __('200', 'kadence-custom-fonts' ),
			'300' => __('300', 'kadence-custom-fonts'),
			'400' => __('400', 'kadence-custom-fonts'),
			'500' => __('500', 'kadence-custom-fonts'),
			'600' => __('600', 'kadence-custom-fonts'),
			'700' => __('700', 'kadence-custom-fonts'),
			'800' => __('800', 'kadence-custom-fonts'),
			'900' => __('900', 'kadence-custom-fonts'),
			),
	) );
	$kt_font_post->add_field( array(
		'name'    => __("Font Style", 'kadence-custom-fonts' ),
		'id'      => $prefix . 'font_style',
		'type'    => 'select',
		'default' => 'normal',
		'options' => array(
			'normal' => __('Normal', 'kadence-custom-fonts' ),
			'italic' => __('Italic', 'kadence-custom-fonts' ),
			),
	) );
}