<?php

class KadencePricingTable_Output {

	// Shortcode
	public static function shortcode($atts) {
		extract(shortcode_atts(array(
		'id' => ''
		), $atts));

		if(empty($id)) {
			return '<p class="error">' . __( 'Please specify a table ID', 'kadence-pricing-table' ) . '</p>';
		} else {
			return KadencePricingTable_Output::output($id);
		}
	}

	public static function addShortcode() {
		add_shortcode('kadence_pricing_table', array( __CLASS__, 'shortcode'));
	}

	public static function output( $id ) {
			global $wpdb, $kadence_pricing_table;
			$table = $wpdb->get_row('SELECT * FROM ' . $wpdb->prefix . 'kpt_tables WHERE id = \'' . $id . '\'');

			if(! $table) {
				return '<p class="error">' . __( 'Could not find table', 'kadence-pricing-table' ) . '</p>';
			}
			$table_id = $table->id;
			$panes = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_panes WHERE table_parent = ' . $table_id . ' ORDER BY position');
			ob_start(); 
			if(isset($table->text_align) ){
				$aligncss = $table->text_align;
			} else {
				$aligncss = 'center';
			}
			if(isset($table->hover_effect) ){
				$hovercss = $table->hover_effect;
			} else {
				$hovercss = 'none';
			}
			if(isset($table->template) ){
				$skincss = $table->template;
			} else {
				$skincss = 'flat';
			}
			if(isset($table->animation) ){
				$animatecss = $table->animation;
			} else {
				$animatecss = 'none';
			}
			if(!isset($table->enable_top_row)){ $table->enable_top_row = '1';}
			if(!isset($table->enable_price_row)){ $table->enable_price_row = '1';}
			if(!isset($table->enable_description_row)){ $table->enable_description_row = '1';}
			if(!isset($table->enable_footer_row)){ $table->enable_footer_row = '1';}
			$tablenum = count($panes);
			echo '<div class="kpt-table-area-container">';
			echo '<ul class="kpt-clearfix kpt-table-area table-align-'.esc_attr($aligncss).' table-hover-'.esc_attr($hovercss).' table-skin-'.esc_attr($skincss).' table-animate-'.esc_attr($animatecss).' table-pane-count-'.esc_attr($tablenum).'" data-column-count="'.esc_attr($tablenum).'">';
			foreach($panes as $pane) {
				// top
				if(!isset($pane->top_head_background)) {$pane->top_head_background = '#f3733c';}
				if(!isset($pane->top_head_color)) {$pane->top_head_color = '#ffffff';}
				if(!isset($pane->top_head_font_size)) {$pane->top_head_font_size = '16';}
				if(!isset($pane->top_head_letter_spacing)) {$pane->top_head_letter_spacing = '0';}
				if(!isset($pane->top_head_line_height)) {$pane->top_head_line_height = '20';}
				if(!isset($pane->top_head_font)) {$pane->top_head_font = 'font_option_three';}
				if(!isset($pane->top_head_height)) {$pane->top_head_height = '40';}
				if(!isset($pane->top_head_padding)) {$pane->top_head_padding = '4';}
				if(!isset($pane->top_head_html)) {$pane->top_head_html = '';}
				if(!isset($pane->top_head_icon)) {$pane->top_head_icon = '';}
				if(!isset($pane->top_head_image)) {$pane->top_head_image = '';}
				if(isset($kadence_pricing_table[$pane->top_head_font]['font-family'])) {
					$top_font_family = 'font-family: ' . $kadence_pricing_table[$pane->top_head_font]['font-family'] . ';'; 
				} else {
					$top_font_family = 'font-family: inherit;'; 
				}
				if(isset($kadence_pricing_table[$pane->top_head_font]['font-weight'])) { 
					$top_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->top_head_font]['font-weight'] . ';'; 
				} else {
					$top_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->top_head_font]['font-style'])) { 
					$top_font_style = 'font-style: ' . $kadence_pricing_table[$pane->top_head_font]['font-style'] . ';'; 
				} else {
					$top_font_style = '';
				} 
				// price
				if(!isset($pane->price_background)) {$pane->price_background = '#f26224';}
				if(!isset($pane->price_color)) {$pane->price_color = '#ffffff';}
				if(!isset($pane->price_font_size)) {$pane->price_font_size = '50';}
				if(!isset($pane->price_letter_spacing)) {$pane->price_letter_spacing = '0';}
				if(!isset($pane->price_line_height)) {$pane->price_line_height = '60';}
				if(!isset($pane->price_font)) {$pane->price_font = 'font_option_one';}
				if(!isset($pane->price_sub_color)) {$pane->price_sub_color = '#ffffff';}
				if(!isset($pane->price_sub_font_size)) {$pane->price_sub_font_size = '12';}
				if(!isset($pane->price_sub_letter_spacing)) {$pane->price_sub_letter_spacing = '1';}
				if(!isset($pane->price_sub_line_height)) {$pane->price_sub_line_height = '20';}
				if(!isset($pane->price_sub_font)) {$pane->price_sub_font = 'font_option_three';}
				if(!isset($pane->price_height)) {$pane->price_height = '140';}
				if(!isset($pane->price_padding)) {$pane->price_padding = '10';}
				if(!isset($pane->price_html)) {$pane->price_html = '';}
				if(!isset($pane->price_sub_html)) {$pane->price_sub_html = '';}
				if(isset($kadence_pricing_table[$pane->price_font]['font-family'])) {
					$price_font_family = 'font-family: ' . $kadence_pricing_table[$pane->price_font]['font-family'] . ';'; 
				} else {
					$price_font_family = 'font-family: Open Sans;'; 
				}
				if(isset($kadence_pricing_table[$pane->price_font]['font-weight'])) { 
					$price_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->price_font]['font-weight'] . ';'; 
				} else {
					$price_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->price_font]['font-style'])) { 
					$price_font_style = 'font-style: ' . $kadence_pricing_table[$pane->price_font]['font-style'] . ';'; 
				} else {
					$price_font_style = '';
				} 
				if(isset($kadence_pricing_table[$pane->price_sub_font]['font-family'])) {
					$price_sub_font_family = 'font-family: ' . $kadence_pricing_table[$pane->price_sub_font]['font-family'] . ';'; 
				} else {
					$price_sub_font_family = 'font-family: Open Sans;'; 
				}
				if(isset($kadence_pricing_table[$pane->price_sub_font]['font-weight'])) { 
					$price_sub_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->price_sub_font]['font-weight'] . ';'; 
				} else {
					$price_sub_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->price_sub_font]['font-style'])) { 
					$price_sub_font_style = 'font-style: ' . $kadence_pricing_table[$pane->price_sub_font]['font-style'] . ';'; 
				} else {
					$price_sub_font_style = '';
				} 

				// Description section
				if(!isset($pane->description_background)) {$pane->description_background = '#ffffff';}
				if(!isset($pane->description_color)) {$pane->description_color = '#444444';}
				if(!isset($pane->description_font_size)) {$pane->description_font_size = '14';}
				if(!isset($pane->description_letter_spacing)) {$pane->description_letter_spacing = '0';}
				if(!isset($pane->description_line_height)) {$pane->description_line_height = '20';}
				if(!isset($pane->description_font)) {$pane->description_font = 'font_option_four';}
				if(!isset($pane->description_padding)) {$pane->description_padding = '10';}
				if(!isset($pane->description_height)) {$pane->description_height = '80';}
				if(!isset($pane->description_html)) {$pane->description_html = '';}
				
				if(isset($kadence_pricing_table[$pane->description_font]['font-family'])) {
					$description_font_family = 'font-family: ' . $kadence_pricing_table[$pane->description_font]['font-family'] . ';'; 
				} else {
					$description_font_family = 'font-family: Open Sans;'; 
				}
				if(isset($kadence_pricing_table[$pane->description_font]['font-weight'])) { 
					$description_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->description_font]['font-weight'] . ';'; 
				} else {
					$description_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->description_font]['font-style'])) { 
					$description_font_style = 'font-style: ' . $kadence_pricing_table[$pane->description_font]['font-style'] . ';'; 
				} else {
					$description_font_style = '';
				} 

				// Footer 

				if(!isset($pane->footer_background)) {$pane->footer_background = '#f26224';}
				if(!isset($pane->footer_color)) {$pane->footer_color = '#ffffff';}
				if(!isset($pane->footer_color_hover)) {$pane->footer_color_hover = '#ffffff';}
				if(!isset($pane->footer_font_size)) {$pane->footer_font_size = '14';}
				if(!isset($pane->footer_letter_spacing)) {$pane->footer_letter_spacing = '0';}
				if(!isset($pane->footer_line_height)) {$pane->footer_line_height = '30';}
				if(!isset($pane->footer_btn_background)) {$pane->footer_btn_background = '#f26224';}
				if(!isset($pane->footer_btn_background_hover)) {$pane->footer_btn_background_hover = '#f3733c';}
				if(!isset($pane->footer_btn_border_color)) {$pane->footer_btn_border_color = '#ffffff';}
				if(!isset($pane->footer_btn_border_color_hover)) {$pane->footer_btn_border_color_hover = '#ffffff';}
				if(!isset($pane->footer_btn_border_width)) {$pane->footer_btn_border_width = '2';}
				if(!isset($pane->footer_btn_border_radius)) {$pane->footer_btn_border_radius = '4';}
				if(!isset($pane->footer_btn_padding)) {$pane->footer_btn_padding = '8';}
				if(!isset($pane->footer_font)) {$pane->footer_font = 'font_option_one';}
				if(!isset($pane->footer_height)) {$pane->footer_height = '60';}
				if(!isset($pane->footer_link)) {$pane->footer_link = '';}
				if(!isset($pane->footer_link_new_tab)) {$pane->footer_link_new_tab = '0';}
				if(!isset($pane->footer_html)) {$pane->footer_html = '';}
			
				if(isset($kadence_pricing_table[$pane->footer_font]['font-family'])) {
					$footer_font_family = 'font-family: ' . $kadence_pricing_table[$pane->footer_font]['font-family'] . ';'; 
				} else {
					$footer_font_family = 'font-family: Open Sans;'; 
				}
				if(isset($kadence_pricing_table[$pane->footer_font]['font-weight'])) { 
					$footer_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->footer_font]['font-weight'] . ';'; 
				} else {
					$footer_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->footer_font]['font-style'])) { 
					$footer_font_style = 'font-style: ' . $kadence_pricing_table[$pane->footer_font]['font-style'] . ';'; 
				} else {
					$footer_font_style = '';
				} 

				if(!isset($pane->featured)) {$pane->featured = 'false';}
				if(!isset($pane->featured_background)) {$pane->featured_background = '#ffffff';}
				if(!isset($pane->featured_color)) {$pane->featured_color = '#f3733c';}
				if(!isset($pane->featured_font_size)) {$pane->featured_font_size = '16';}
				if(!isset($pane->featured_letter_spacing)) {$pane->featured_letter_spacing = '1';}
				if(!isset($pane->featured_line_height)) {$pane->featured_line_height = '20';}
				if(!isset($pane->featured_font)) {$pane->featured_font = 'font_option_three';}
				if(!isset($pane->featured_border_width)) {$pane->featured_border_width = '0';}
				if(!isset($pane->featured_border_color)) {$pane->featured_border_color = '#ffffff';}
				if(!isset($pane->featured_border_radius)) {$pane->featured_border_radius = '0';}
				if(!isset($pane->featured_size)) {$pane->featured_size = '60';}
				if(!isset($pane->featured_text)) {$pane->featured_text = '';}

				if(isset($kadence_pricing_table[$pane->featured_font]['font-family'])) {
					$featured_font_family = 'font-family: ' . $kadence_pricing_table[$pane->featured_font]['font-family'] . ';'; 
				} else {
					$featured_font_family = 'font-family: Open Sans;'; 
				}
				if(isset($kadence_pricing_table[$pane->featured_font]['font-weight'])) { 
					$featured_font_weight = 'font-weight: ' . $kadence_pricing_table[$pane->featured_font]['font-weight'] . ';'; 
				} else {
					$featured_font_weight = 'font-weight: 600;'; 
				}
				if(isset($kadence_pricing_table[$pane->featured_font]['font-style'])) { 
					$featured_font_style = 'font-style: ' . $kadence_pricing_table[$pane->featured_font]['font-style'] . ';'; 
				} else {
					$featured_font_style = '';
				} 
				echo '<li class="kpt-pane">';
				echo '<div class="kt-table-pane kt-pane-style-'.esc_attr($pane->featured).'" style="border-width:'.esc_attr($pane->featured_border_width).'px; border-color:'.esc_attr($pane->featured_border_color).'; border-radius:'.esc_attr($pane->featured_border_radius).'px">';
				$template_order = array('top_head', 'price', 'description', 'rows', 'footer');
				foreach ($template_order as $key) {
					switch($key) {

						case 'top_head':
							// Top Head
							if('1' == $table->enable_top_row){
								echo '<div class="kpt-pane-top-head kpt-section" style="background:'.esc_attr($pane->top_head_background).'; color:'.esc_attr($pane->top_head_color).'; font-size:'.esc_attr($pane->top_head_font_size).'px; letter-spacing:'.esc_attr($pane->top_head_letter_spacing).'px; line-height:'.esc_attr($pane->top_head_line_height).'px; padding-top:'.esc_attr($pane->top_head_padding).'px; padding-bottom:'.esc_attr($pane->top_head_padding).'px; min-height:'.esc_attr($pane->top_head_height).'px; '.esc_attr($top_font_family).' '.esc_attr($top_font_weight).' '.esc_attr($top_font_style).'">';
									echo '<div class="kpt-top-head-text">';
										echo wp_kses_post($pane->top_head_html);
									echo '</div>';
									if(!empty($pane->top_head_icon)) {
										echo '<div class="kpt-top-head-icon">';
											echo '<i class="'.esc_attr($pane->top_icon).'"></i>';
										echo '</div>';
									}
									if(!empty($pane->top_head_image)) {
										echo '<div class="kpt-top-head-image">';
											echo '<img src="'.esc_attr($pane->top_head_image).'" atr="'.esc_attr($pane->top_head_html).'" class="kpt-top-image">';
										echo '</div>';
									}
								echo '</div>';
							}
						break;
						case 'price': 
							// Price Section
							if('1' == $table->enable_price_row){
								echo '<div class="kpt-pane-price kpt-section" style="background:'.esc_attr($pane->price_background).'; color:'.esc_attr($pane->price_color).'; font-size:'.esc_attr($pane->price_font_size).'px; letter-spacing:'.esc_attr($pane->price_letter_spacing).'px; line-height:'.esc_attr($pane->price_line_height).'px; min-height:'.esc_attr($pane->price_height).'px; padding-top:'.esc_attr($pane->price_padding).'px; padding-bottom:'.esc_attr($pane->price_padding).'px; '.esc_attr($price_font_family).' '.esc_attr($price_font_weight).' '.esc_attr($price_font_style).'">';
									echo '<div class="kpt-price-inner">';
										echo wp_kses_post($pane->price_html);
									echo '</div>';
										echo '<div class="kpt-price-sub" style="color:'.esc_attr($pane->price_sub_color).'; font-size:'.esc_attr($pane->price_sub_font_size).'px; letter-spacing:'.esc_attr($pane->price_sub_letter_spacing).'px; line-height:'.esc_attr($pane->price_sub_line_height).'px; '.esc_attr($price_sub_font_family).' '.esc_attr($price_sub_font_weight).' '.esc_attr($price_sub_font_style).'">';
										if(!empty($pane->price_sub_html)) {
											echo wp_kses_post($pane->price_sub_html);
										}
										echo '</div>';
								echo '</div>';
							}
						break;
						case 'description':
							if('1' == $table->enable_description_row){
								// Description
								echo '<div class="kpt-pane-description kpt-section" style="background:'.esc_attr($pane->description_background).'; color:'.esc_attr($pane->description_color).'; font-size:'.esc_attr($pane->description_font_size).'px; letter-spacing:'.esc_attr($pane->description_letter_spacing).'px; line-height:'.esc_attr($pane->description_line_height).'px; padding-top:'.esc_attr($pane->description_padding).'px; padding-bottom:'.esc_attr($pane->description_padding).'px; min-height:'.esc_attr($pane->description_height).'px; '.esc_attr($description_font_family).' '.esc_attr($description_font_weight).' '.esc_attr($description_font_style).'">';
									echo wp_kses_post($pane->description_html);
								echo '</div>';
							}
						break;
						case 'rows': 
							echo '<div class="kpt-pane-rows kpt-section">';
							$pane_parent = $pane->position;
							$rows = $wpdb->get_results('SELECT * FROM ' . $wpdb->prefix . 'kpt_tablerows WHERE table_parent = ' . $table_id . ' AND pane_parent = ' . $pane_parent . ' ORDER BY position');	
							$l = 1;
							foreach($rows as $row) {

								if(!isset($row->background)) {$row->background = '#ffffff';}
								if(!isset($row->color)) {$row->color = '#444444';}
								if(!isset($row->font_size)) {$row->font_size = '14';}
								if(!isset($row->letter_spacing)) {$row->letter_spacing = '1';}
								if(!isset($row->line_height)) {$row->line_height = '20';}
								if(!isset($row->font)) {$row->font = 'font_option_three';}
								if(!isset($row->padding)) {$row->padding = '5';}
								if(!isset($row->height)) {$row->height = '40';}
								if(!isset($row->inner_html)) {$row->inner_html = '';}
							
								if(isset($kadence_pricing_table[$row->font]['font-family'])) {
									$row_font_family = 'font-family: ' . $kadence_pricing_table[$row->font]['font-family'] . ';'; 
								} else {
									$row_font_family = 'font-family: Open Sans;'; 
								}
								if(isset($kadence_pricing_table[$row->font]['font-weight'])) { 
									$row_font_weight = 'font-weight: ' . $kadence_pricing_table[$row->font]['font-weight'] . ';'; 
								} else {
									$row_font_weight = 'font-weight: 600;'; 
								}
								if(isset($kadence_pricing_table[$row->font]['font-style'])) { 
									$row_font_style = 'font-style: ' . $kadence_pricing_table[$row->font]['font-style'] . ';'; 
								} else {
									$row_font_style = '';
								}
									echo '<div class="kpt-pane-single-row" style="background:'.esc_attr($row->background).'; color:'.esc_attr($row->color).'; font-size:'.esc_attr($row->font_size).'px; letter-spacing:'.esc_attr($row->letter_spacing).'px; line-height:'.esc_attr($row->line_height).'px; padding-top:'.esc_attr($row->padding).'px; padding-bottom:'.esc_attr($row->padding).'px; min-height:'.esc_attr($row->height).'px; '.esc_attr($row_font_family).' '.esc_attr($row_font_weight).' '.esc_attr($row_font_style).'">';
										echo '<div class="kpt-pane-single-row-inner">';
											echo do_shortcode(wp_kses_post($row->inner_html));
										echo '</div>';
									echo '</div>';
																		
							}
							echo '</div>';
						break;
						case 'footer': 
							if('1' == $table->enable_footer_row){
								// $footer
								$target = $pane->footer_link_new_tab == 1 ? 'target="_blank"' : '';
								echo '<div class="kpt-pane-footer kpt-section" style="background:'.esc_attr($pane->footer_background).'; color:'.esc_attr($pane->footer_color).'; font-size:'.esc_attr($pane->footer_font_size).'px; letter-spacing:'.esc_attr($pane->footer_letter_spacing).'px; line-height:'.esc_attr($pane->footer_line_height).'px; height:'.esc_attr($pane->footer_height).'px; '.esc_attr($footer_font_family).' '.esc_attr($footer_font_weight).' '.esc_attr($footer_font_style).'">';
									echo '<a href="'.esc_url(do_shortcode($pane->footer_link)).'" '.$target.' class="kpt-footer-btn" style="background:'.esc_attr($pane->footer_btn_background).'; color:'.esc_attr($pane->footer_color).'; border:'.esc_attr($pane->footer_btn_border_width).'px solid; border-color:'.esc_attr($pane->footer_btn_border_color).'; border-radius:'.esc_attr($pane->footer_btn_border_radius).'px; padding-left:'.esc_attr($pane->footer_btn_padding).'px; padding-right:'.esc_attr($pane->footer_btn_padding).'px;" data-color="' . esc_attr($pane->footer_color). '" data-border-color="' . esc_attr($pane->footer_btn_border_color). '" data-background-color="' . esc_attr($pane->footer_btn_background). '" data-hcolor="' . esc_attr($pane->footer_color_hover). '" data-hborder-color="' . esc_attr($pane->footer_btn_border_color_hover). '" data-hbackground-color="' . esc_attr($pane->footer_btn_background_hover). '">'.wp_kses_post($pane->footer_html).'</a>';
								echo '</div>';
							}
						break;	
					}

				}
				if($pane->featured == 'badge' || $pane->featured == 'ribbon') {
					echo '<div class="kpt-featured-item featured-style-'.esc_attr($pane->featured).'" style="background:'.esc_attr($pane->featured_background).'; color:'.esc_attr($pane->featured_color).'; font-size:'.esc_attr($pane->featured_font_size).'px; letter-spacing:'.esc_attr($pane->featured_letter_spacing).'px; line-height:'.esc_attr($pane->featured_line_height).'px; height:'.esc_attr($pane->featured_size).'px; width:'.esc_attr($pane->featured_size).'px; '.esc_attr($featured_font_family).' '.esc_attr($featured_font_weight).' '.esc_attr($featured_font_style).'">';
							echo '<div class="kpt-featured_inner" style="background:'.esc_attr($pane->featured_background).';">';
								echo wp_kses_post($pane->featured_text);
							echo '</div>';
					echo '</div>';
				}



				echo '</div>';
				echo '</li>';
			}
			echo '</ul>';
			echo '</div>';
			$output = ob_get_contents();
			ob_end_clean();
			return $output;
		}
	}


