<?php
/**
 * Class to check if lazy load is enabled
 *
 * @package Pinnacle Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Class to check if lazy load is enabled
 *
 * @category Class
 */
class Pinnacle_Lazy_Load {
	/**
	 * Static var $lazyload
	 *
	 * @var $lazyload
	 */
	private static $lazyload = null;

	/**
	 * Function is_lazy check
	 */
	public static function is_lazy() {
		if ( is_null( self::$lazyload ) ) {
			$lazy = false;
			if ( ( function_exists( 'get_rocket_option' ) && get_rocket_option( 'lazyload' ) ) || ( function_exists( 'rocket_lazyload_get_option' ) && rocket_lazyload_get_option( 'images' ) ) ) {
				$lazy = true;
			}
			self::$lazyload = apply_filters( 'kad_lazy_load', $lazy );
		}
		return self::$lazyload;
	}
}
