<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'pinnacle_woocommerce_archive_init' );
function pinnacle_woocommerce_archive_init() {
	// Remove results count ( re-add later )
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
	// Remove ordering select ( re-add later )
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	// Remove content_wrapper ( add pinnacles later )
	remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
	// remove breadcrumbs
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
	// Remove content_wrapper ( add pinnacles later )
	remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);
	// Remove sidebar
	remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);

	// add slider/page title area
	add_action( 'woocommerce_before_main_content', 'pinnacle_woo_archive_page_header', 5 );
	function pinnacle_woo_archive_page_header() {
		global $pinnacle;  
 
		if (is_shop() && ! is_search() ) {
			if(isset($pinnacle['choose_shop_header'])) {
				$choose_shop_header = $pinnacle['choose_shop_header'];
			} else {
				$choose_shop_header = 'pagetitle';
			}
			if ($choose_shop_header == "rev") {
			get_template_part('templates/shop/rev', 'slider');
			}
			else if ($choose_shop_header == "flex") {
				get_template_part('templates/shop/flex', 'slider');
			}
			else if ($choose_shop_header == "carousel") {
				get_template_part('templates/shop/carousel', 'slider');
			}
			else if ($choose_shop_header == "cyclone") {
				get_template_part('templates/shop/cyclone', 'slider');
			}
			else if ($choose_shop_header == "ktslider") {
				get_template_part('templates/shop/kt', 'slider');
			} else if ($choose_shop_header == "ksp") {
				get_template_part('templates/shop/ksp', 'slider');
			} else if ($choose_shop_header == "none") {
				// do nothing //
			} else {
				get_template_part('templates/shop/shop', 'page-header');
			}
		} else if ( is_product_category() ) {
				$cat_term_id = get_queried_object()->term_id; $meta = get_option('product_cat_slider');
				if (empty($meta)) { $meta = array(); } if (!is_array($meta)) {$meta = (array) $meta;}
				$meta = isset($meta[$cat_term_id]) ? $meta[$cat_term_id] : array();
				if(isset($meta['cat_short_slider'])) { 
					echo '<div class="sliderclass kad_cat_slider">'. do_shortcode($meta['cat_short_slider']). '</div>';
						if(kadence_display_archive_breadcrumbs()) {?>
						<div class="container bc_nomargin">
							<?php kadence_breadcrumbs(); ?> 
						</div>
						<?php } 
				} else {
					get_template_part('templates/archive', 'header');
				}
		 } else if ( is_search() ) {
			get_template_part('templates/page', 'header'); 
		 } else if ( is_product() ) {
		 	get_template_part('templates/woo', 'product-header');
		 } else {
			get_template_part('templates/archive', 'header');
		 }
	}
	// Add wrapper
	add_action( 'woocommerce_before_main_content', 'pinnacle_woo_main_wrap_content_open', 10 );
	function pinnacle_woo_main_wrap_content_open() {
		echo '<div id="content" class="container"><div class="row"><div class="main '.esc_attr( kadence_main_class() ).'" role="main">';
	}
	// add closing wrapper
	add_action( 'woocommerce_after_main_content', 'pinnacle_woo_main_wrap_content_close', 20 );
	function pinnacle_woo_main_wrap_content_close() {
		echo '</div>';
	}
	// Re add results and ordering
	add_action( 'woocommerce_before_shop_loop', 'pinnacle_woo_archive_top', 20 );
	function pinnacle_woo_archive_top() {
		?>
		<div class="kad-shop-top">
			<div class="row">
				<div class="col-md-6 col-sm-6 col-xs-6">
					<?php woocommerce_result_count(); ?>
				</div>
				<div class="col-md-6 col-sm-6 col-xs-6">
					<?php woocommerce_catalog_ordering(); ?>
				</div>
			</div>
		</div>
		<?php 
	}
	// add iso filter 
	add_action( 'woocommerce_before_shop_loop', 'pinnacle_woo_loop_filter', 40 );
	function pinnacle_woo_loop_filter() {
		global $pinnacle, $wp_query;

		if ( 1 === $wp_query->found_posts || ! woocommerce_products_will_display() ) {
			return;
		}
		if( is_shop() && ! is_search() ){
			if( isset( $pinnacle['shop_filter'] ) && 1 == $pinnacle['shop_filter'] ) {
				echo '<div class="kad-shop-filter">';
			  			pinnacle_iso_filter('product_cat', null);
				echo '</div>';
			}
		} else if( is_product_category() ) {
			if(isset($pinnacle['cat_filter']) && $pinnacle['cat_filter'] == 1) {

				$cat_obj = $wp_query->get_queried_object();
				$product_cat_ID  = $cat_obj->term_id;

				$children = get_terms( 'product_cat', array(
					'parent'    => $product_cat_ID,
					'hide_empty' => false
				) );
				if ( $children ) {
					$termtypes = array( 'child_of' => $product_cat_ID);
					echo '<div class="kad-shop-filter">';
						pinnacle_iso_filter('product_cat', $termtypes);
					echo '</div>';
				}
			}
		}
	}
}
add_action( 'woocommerce_before_shop_loop', 'pinnacle_woo_cat_loop', 60 );
function pinnacle_woo_cat_loop() {
	if ( version_compare( WC_VERSION, '3.3', '<' ) ) {
		if ( ! is_search() ) {
			global $pinnacle, $woocommerce, $woocommerce_loop;
			if( isset( $pinnacle['product_fitrows'] ) && 1 == $pinnacle['product_fitrows'] ) {
				$style = 'fitRows';
			} else {
				$style = 'masonry';
			} 
			if( isset( $pinnacle['pinnacle_animate_in'] ) && 1 == $pinnacle['pinnacle_animate_in'] ) {
				$animate = 1;
			} else {
				$animate = 0;
			} ?>
			<div class="clearfix <?php echo kadence_category_layout_css(); ?> rowtight product_category_padding init-isotope" data-fade-in="<?php echo esc_attr($animate);?>" data-iso-selector=".kad_product" data-iso-style="<?php echo esc_attr($style);?>" data-iso-filter="false"> 
				<?php
				 if ( empty( $woocommerce_loop['columns'] ) ) $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
					woocommerce_product_subcategories();
				?>
			</div>
			<?php 
		}
	}
}