<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'init', 'pinnacle_woocommerce_single_init' );
function pinnacle_woocommerce_single_init() {
	function pinnacle_product_video_tab_content() {
		global $post, $pinnacle;
		if ( $videocode = get_post_meta( $post->ID, '_kad_product_video', true ) ) {
			if ( ! empty( $pinnacle[ 'video_title_text' ] ) ) {
				$product_video_title = $pinnacle[ 'video_title_text' ];
			} else {
				$product_video_title = __( 'Product Video', 'pinnacle' );
			}
			echo '<h2>'.esc_html( $product_video_title ).'</h2>';
			echo '<div class="videofit product_video_case">'.do_shortcode( $videocode ).'</div>';
		}
	}
	add_filter( 'woocommerce_product_tabs', 'pinnacle_product_video_tab');
	function pinnacle_product_video_tab($tabs) {
		global $post, $pinnacle;
		if ( $videocode = get_post_meta( $post->ID, '_kad_product_video', true ) ) {
			if ( ! empty( $pinnacle[ 'video_tab_text' ] ) ) {
				$product_video_title = $pinnacle[ 'video_tab_text' ];
			} else {
				$product_video_title = __( 'Product Video', 'pinnacle' );
			}
			$tabs[ 'video_tab' ] = array(
				'title' => esc_html( $product_video_title ),
				'priority' => 50,
				'callback' => 'pinnacle_product_video_tab_content'
			);
		}
		return $tabs;
	}
	add_filter( 'woocommerce_single_product_image_thumbnail_html', 'pinnacle_product_thumnbnail_image' );
	function pinnacle_product_thumnbnail_image( $html ) {
		$html = str_replace( 'data-rel="prettyPhoto', 'rel="lightbox', $html );
		return $html;
	}
	// Display product tabs?
	add_action( 'wp_head','pinnacle_tab_check' );
	if ( ! function_exists( 'pinnacle_tab_check' ) ) {
		function pinnacle_tab_check() {
			global $pinnacle;
			if ( isset( $pinnacle[ 'product_tabs' ] ) && $pinnacle[ 'product_tabs' ] == "0" ) {
				remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
			}
		}
	}
	// Display related products?
	add_action( 'wp_head', 'pinnacle_related_products' );
	if ( ! function_exists( 'pinnacle_related_products' ) ) {
		function pinnacle_related_products() {
			global $pinnacle;
			if ( isset( $pinnacle[ 'related_products' ] ) && $pinnacle[ 'related_products' ] == "0" ) {
				remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
			}
		}
	}
	// Change the tab title
	add_filter( 'woocommerce_product_tabs', 'pinnacle_woo_rename_tabs', 98 );
	function pinnacle_woo_rename_tabs( $tabs ) {
		global $pinnacle; 
		if ( ! empty( $pinnacle['description_tab_text'] ) && ! empty( $tabs['description']['title'] ) ) {
			$tabs['description']['title'] = $pinnacle['description_tab_text'];
		}
		if ( ! empty( $pinnacle['additional_information_tab_text'] ) && ! empty( $tabs['additional_information']['title'] ) ) {
			$tabs['additional_information']['title'] = $pinnacle['additional_information_tab_text'];
		}
		if ( !empty( $pinnacle['reviews_tab_text'] ) && !empty( $tabs['reviews']['title']) ) {
			$tabs['reviews']['title'] = $pinnacle['reviews_tab_text'];
		}
		return $tabs;
	}
	// Change the tab description heading
	add_filter( 'woocommerce_product_description_heading', 'pinnacle_description_tab_heading', 10, 1 );
	function pinnacle_description_tab_heading( $title ) {
		global $pinnacle; 
		if ( ! empty( $pinnacle['description_header_text'] ) ) {
			$title = $pinnacle['description_header_text'];
		}
		return $title;
	}
	// Change the tab aditional info heading
	add_filter( 'woocommerce_product_additional_information_heading', 'pinnacle_additional_information_tab_heading', 10, 1 );
	function pinnacle_additional_information_tab_heading( $title ) {
		global $pinnacle; 
		if ( ! empty( $pinnacle['additional_information_header_text'] ) ) {
			$title = $pinnacle['additional_information_header_text'];
		}
		return $title;
	}

	add_filter( 'woocommerce_product_tabs', 'pinnacle_woo_reorder_tabs', 98 );
	function pinnacle_woo_reorder_tabs( $tabs ) {
		global $pinnacle;

		if ( ! empty( $tabs['description'] ) ) {
			$tabs['description']['priority'] = ( isset( $pinnacle['ptab_description'] ) ? $pinnacle['ptab_description'] : 10 );
		}
		if ( ! empty( $tabs['additional_information'] ) ) {
			$tabs['additional_information']['priority'] = ( isset( $pinnacle['ptab_additional'] ) ? $pinnacle['ptab_additional'] : 20 );
		}
		if ( ! empty( $tabs['reviews'] ) ) {
			$tabs['reviews']['priority'] = ( isset( $pinnacle['ptab_reviews'] ) ? $pinnacle['ptab_reviews'] : 30 );
		}
		if ( ! empty( $tabs['video_tab'] ) ) {
			$tabs['video_tab']['priority'] = ( isset( $pinnacle['ptab_video'] ) ? $pinnacle['ptab_video'] : 40 );
		}

		return $tabs;
	}
	// Add the custom tabs

	function kad_custom_tab_01($tabs) {
		global $post;
		if( $tab_content = get_post_meta( $post->ID, '_kad_tab_content_01', true ) ) {
			$tab_title = get_post_meta( $post->ID, '_kad_tab_title_01', true );
			$tab_priority = get_post_meta( $post->ID, '_kad_tab_priority_01', true ); 
			if(!empty($tab_title)) {$product_tab_title = $tab_title;} else {$product_tab_title = __('Custom Tab', 'pinnacle');}
			if(!empty($tab_priority)) {$product_tab_priority = esc_attr($tab_priority);} else {$product_tab_priority = 45;}
			$tabs['kad_custom_tab_01'] = array(
				'title' => $product_tab_title,
				'priority' => $product_tab_priority,
				'callback' => 'kad_product_custom_tab_content_01'
			);
		}
		return $tabs;
	}

	function kad_product_custom_tab_content_01() {
		global $post; $tab_content_01 = wpautop(get_post_meta( $post->ID, '_kad_tab_content_01', true ));
		echo do_shortcode('<div class="product_custom_content_case">'.__($tab_content_01).'</div>');
	}

	function kad_custom_tab_02($tabs) {
		global $post; 
		if ( $tab_content = get_post_meta( $post->ID, '_kad_tab_content_02', true ) ) {
			$tab_title = get_post_meta( $post->ID, '_kad_tab_title_02', true );
			$tab_priority = get_post_meta( $post->ID, '_kad_tab_priority_02', true ); 
			if(!empty($tab_title)) {$product_tab_title = $tab_title;} else {$product_tab_title = __('Custom Tab', 'pinnacle');}
			if(!empty($tab_priority)) {$product_tab_priority = esc_attr($tab_priority);} else {$product_tab_priority = 50;}
			$tabs['kad_custom_tab_02'] = array(
				'title' => $product_tab_title,
				'priority' => $product_tab_priority,
				'callback' => 'kad_product_custom_tab_content_02'
			);
		}
		return $tabs;
	}

	function kad_product_custom_tab_content_02() {
		global $post; $tab_content_02 = wpautop(get_post_meta( $post->ID, '_kad_tab_content_02', true ));
		echo do_shortcode('<div class="product_custom_content_case">'.__($tab_content_02).'</div>');
	}

	function kad_custom_tab_03($tabs) {
		global $post;
		if ( $tab_content = get_post_meta( $post->ID, '_kad_tab_content_03', true ) ) {
		$tab_title = get_post_meta( $post->ID, '_kad_tab_title_03', true );
		$tab_priority = get_post_meta( $post->ID, '_kad_tab_priority_03', true ); 
		if(!empty($tab_title)) {$product_tab_title = $tab_title;} else {$product_tab_title = __('Custom Tab', 'pinnacle');}
		if(!empty($tab_priority)) {$product_tab_priority = esc_attr($tab_priority);} else {$product_tab_priority = 55;}
			$tabs['kad_custom_tab_03'] = array(
				'title' => $product_tab_title,
				'priority' => $product_tab_priority,
				'callback' => 'kad_product_custom_tab_content_03'
			);
		}

		return $tabs;
	}
	function kad_product_custom_tab_content_03() {
		global $post; 
		$tab_content_03 = wpautop( get_post_meta( $post->ID, '_kad_tab_content_03', true ) );
		echo do_shortcode('<div class="product_custom_content_case">'.__($tab_content_03).'</div>');
	}

	$pinnacle = get_option('pinnacle');
	if ( isset( $pinnacle['custom_tab_01'] ) && $pinnacle['custom_tab_01'] == 1 ) {
		add_filter( 'woocommerce_product_tabs', 'kad_custom_tab_01');
	}
	if ( isset( $pinnacle['custom_tab_02'] ) && $pinnacle['custom_tab_02'] == 1 ) {
		add_filter( 'woocommerce_product_tabs', 'kad_custom_tab_02');
	}
	if ( isset( $pinnacle['custom_tab_03'] ) && $pinnacle['custom_tab_03'] == 1 ) {
		add_filter( 'woocommerce_product_tabs', 'kad_custom_tab_03');
	}

	// Single Prodoct Title
	remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
	add_action( 'woocommerce_single_product_summary', 'pinnacle_single_product_title', 5 );
	function pinnacle_single_product_title() {
		global $pinnacle;
		if ( isset( $pinnacle[ 'default_showproducttitle_inpost' ] ) && 0 == $pinnacle[ 'default_showproducttitle_inpost' ] ) {
			the_title( '<span itemprop="name" class="product_title kt_title_hidden entry-title">', '</span>' );
		} else if( isset( $pinnacle[ 'single_product_title_output' ] ) && 'h2' == $pinnacle[ 'single_product_title_output' ] ) {
			the_title( '<h2 class="product_title entry-title">', '</h2>' );
		} else {
			the_title( '<h1 class="product_title entry-title">', '</h1>' );
		}
	}

}