<?php
/**
 * Comments Template
 *
 * @package Pinnacle Theme
 */

if ( post_password_required() ) {
	return;
}
echo '<div id="post_comments"></div>';
if ( have_comments() && ( comments_open() || get_comments_number() ) ) :
	?>
	<section id="comments">
		<h3 class="sectiontitle">
			<?php
			$comments_number = get_comments_number();
			if ( '1' === $comments_number ) {
				echo esc_html__( 'One Response', 'pinnacle' );
			} else {
				/* translators: %d comment count */
				printf( esc_html__( '%d Responses', 'pinnacle' ), $comments_number );
			}
			?>
		</h3>
		<ol class="media-list">
			<?php wp_list_comments( array( 'walker' => new Kadence_Walker_Comment() ) ); ?>
		</ol>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
			<nav>
				<ul class="pager">
				<?php if ( get_previous_comments_link() ) : ?>
					<li class="previous"><?php previous_comments_link( __( '&larr; Older comments', 'pinnacle' ) ); ?></li>
				<?php endif; ?>
				<?php if ( get_next_comments_link() ) : ?>
					<li class="next"><?php next_comments_link( __( 'Newer comments &rarr;', 'pinnacle' ) ); ?></li>
				<?php endif; ?>
				</ul>
			</nav>
		<?php endif; ?>

	<?php
	if ( ! comments_open() && ! is_page() && post_type_supports( get_post_type(), 'comments' ) ) :
		global $pinnacle;
		if ( isset( $pinnacle['close_comments'] ) ) {
			$show_closed_comment = $pinnacle['close_comments'];
		} else {
			$show_closed_comment = 1;
		}
		if ( 1 == $show_closed_comment ) {
			?>
			<div class="alert">
				<?php esc_html_e( 'Comments are closed.', 'pinnacle' ); ?>
			</div>
			<?php
		}
	endif;
	?>
	</section><!-- /#comments -->
<?php
endif;

if ( ! have_comments() && ! comments_open() && ! is_page() && post_type_supports( get_post_type(), 'comments' ) ) :
	global $pinnacle;
	if ( isset( $pinnacle['close_comments'] ) ) {
		$show_closed_comment = $pinnacle['close_comments'];
	} else {
		$show_closed_comment = 1;
	}
	if ( 1 == $show_closed_comment ) {
		?>
		<div class="alert">
			<?php esc_html_e( 'Comments are closed.', 'pinnacle' ); ?>
		</div>
		<?php
	}
endif;

if ( comments_open() ) :
	?>
	<section id="respond">
		<?php comment_form(); ?>
	</section><!-- /#respond -->
<?php endif; ?>
