<?php
/**
 * Template for displaying post featured image.
 */
global $post, $kt_feat_width;
if (has_post_thumbnail( $post->ID ) ) { 
	if ( has_post_format( 'gallery' ) ) {
		$swidth = get_post_meta( $post->ID, '_kad_gallery_posthead_width', true ); 
	} elseif (has_post_format( 'image' )) {
		$swidth = get_post_meta( $post->ID, '_kad_image_posthead_width', true );
	}
	if ( ! empty( $swidth ) ) {
		$slidewidth = $swidth;
	} else {
		$slidewidth = $kt_feat_width;
	}
	$img = pinnacle_get_image_array($slidewidth, null, true, null, null, get_post_thumbnail_id(), false);

	?>
	<section class="postfeat">
    	<div class="imghoverclass post-single-img" itemprop="image" itemscope itemtype="https://schema.org/ImageObject">
    		<a href="<?php echo esc_url( $img['full'] ); ?>" data-rel="lightbox" class="">
    			<img src="<?php echo esc_url( $img['src'] ); ?>" width="<?php echo esc_attr( $img['width'] ); ?>" height="<?php echo esc_attr( $img['height'] ); ?>" <?php echo wp_kses_post( $img['srcset'] ); ?> itemprop="contentUrl" alt="<?php the_title_attribute(); ?>" />
                <meta itemprop="url" content="<?php echo esc_url( $img['src'] ); ?>">
                <meta itemprop="width" content="<?php echo esc_attr( $img['width'] ); ?>px">
                <meta itemprop="height" content="<?php echo esc_attr( $img['height'] ); ?>px">
    		</a>
    	</div>
    </section>
<?php

} ?>