<?php 
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
return json_decode( '{
	"ABeeZee": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'ABeeZee Italic\'",
						"\'ABeeZee-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abeezee/v11/gdFHbjHcLYROorto_Tq2E_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gdFHbjHcLYROorto_Tq2E5bd9NUM7myrQQz30yPaGQ4&skey=7e1629e194fe8b7a&v=v11#ABeeZee",
						"ttf": "http://fonts.gstatic.com/s/abeezee/v11/gdFHbjHcLYROorto_Tq2E6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/abeezee/v11/gdFHbjHcLYROorto_Tq2Ez8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/abeezee/v11/gdFHbjHcLYROorto_Tq2E1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'ABeeZee Regular\'",
						"\'ABeeZee-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abeezee/v11/mHe7YG9wQgrkYxToGNllew.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Q9Ho64D2EGNbyR7RUlvCNQ&skey=abecda27d5b3409a&v=v11#ABeeZee",
						"ttf": "http://fonts.gstatic.com/s/abeezee/v11/JYPhMn-3Xw-JGuyB-fEdNA.ttf",
						"woff": "http://fonts.gstatic.com/s/abeezee/v11/m_J3nYLkIiGqm2wAiy01kg.woff",
						"woff2": "http://fonts.gstatic.com/s/abeezee/v11/TV7JXr7j4tW7mgYreANhGQ.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Abel": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Abel Regular\'",
						"\'Abel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abel/v8/3YEwT2a1878zysq92S8_9w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pb98amgrX4UHZo9JnVPobA&skey=bf47258294911e6d&v=v8#Abel",
						"ttf": "http://fonts.gstatic.com/s/abel/v8/N59kklKPso9WzbZH9jwJSg.ttf",
						"woff": "http://fonts.gstatic.com/s/abel/v8/EAqh528fFdbUek8UOky4sA.woff",
						"woff2": "http://fonts.gstatic.com/s/abel/v8/brdGGFwqYJxjg2CD1E9o7g.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Abhaya Libre": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"sinhala",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Abhaya Libre Regular\'",
						"\'AbhayaLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abhayalibre/v3/zTLc5Jxv6yvb1nHyqBasV3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zTLc5Jxv6yvb1nHyqBasV1lIn5tFQcqMuf-jhyJP0ps&skey=4aba808beb02377b&v=v3#AbhayaLibre",
						"ttf": "http://fonts.gstatic.com/s/abhayalibre/v3/zTLc5Jxv6yvb1nHyqBasV4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/abhayalibre/v3/zTLc5Jxv6yvb1nHyqBasV3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/abhayalibre/v3/zTLc5Jxv6yvb1nHyqBasV-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Abhaya Libre Medium\'",
						"\'AbhayaLibre-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrczHhXAPWOXQc-mHRKx4oalk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wBjdF6T34NCo7wQYXgzrc5XlX4y0PMY0_OO7hHc9JEY&skey=c9f234d72fbefdc5&v=v3#AbhayaLibre",
						"ttf": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrcyfxicYksyVqdB8nkjIZw2U.ttf",
						"woff": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrcxF47VQSRrvbVYTKIrepY7I.woff",
						"woff2": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc81Lch-SD8r0CsJ60meulZ8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Abhaya Libre SemiBold\'",
						"\'AbhayaLibre-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrczBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wBjdF6T34NCo7wQYXgzrcwmE8htD-SDrf7umQTfloJ8&skey=7806b586edfb51c5&v=v3#AbhayaLibre",
						"ttf": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc1FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc9Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Abhaya Libre Bold\'",
						"\'AbhayaLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc2msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wBjdF6T34NCo7wQYXgzrcway50PuN8loMJ9QAXsTs7U&skey=236daab164e65f82&v=v3#AbhayaLibre",
						"ttf": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc3l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc3NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				},
				"800": {
					"local": [
						"\'Abhaya Libre ExtraBold\'",
						"\'AbhayaLibre-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc9Kd--5SjvBBPdO8SYNBozY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wBjdF6T34NCo7wQYXgzrczkD3gkdjFTgxsLXLStRJKw&skey=e1f8d1be735feb1c&v=v3#AbhayaLibre",
						"ttf": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc7i9CBoQ1U4Q5PEtIDscMvI.ttf",
						"woff": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrc2pVmE9oLybi4D_AN-2K110.woff",
						"woff2": "http://fonts.gstatic.com/s/abhayalibre/v3/wBjdF6T34NCo7wQYXgzrcxqoE9FO9sRveXk8Nnop4Zo.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Abril Fatface": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Abril Fatface\'",
						"\'AbrilFatface-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/abrilfatface/v9/X1g_KwGeBV3ajZIXQ9VnDsOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=X1g_KwGeBV3ajZIXQ9VnDjyKAGS2js9R2mTcvyyc0eU&skey=3aaa84d7e0b4f9c7&v=v9#AbrilFatface",
						"ttf": "http://fonts.gstatic.com/s/abrilfatface/v9/X1g_KwGeBV3ajZIXQ9VnDibsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/abrilfatface/v9/X1g_KwGeBV3ajZIXQ9VnDvn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/abrilfatface/v9/X1g_KwGeBV3ajZIXQ9VnDjxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Aclonica": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aclonica Regular\'",
						"\'Aclonica-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/aclonica/v8/3DwzZU4UhPTPTJpeyrnTN_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KzDaYnc58_-JsKVgqlzSZvesZW2xOQ-xsNqO47m55DA&skey=a69e8e3b9073e390&v=v8#Aclonica",
						"ttf": "http://fonts.gstatic.com/s/aclonica/v8/SRPydzL0KLANO5G2lBcEnfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/aclonica/v8/VVH16EjBQLZ2NYB8eVnrO_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/aclonica/v8/KL5OjqZGxkpCc9qpqsIjA_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Acme": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Acme Regular\'",
						"\'Acme-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/acme/v7/NnjH_Kn2W_0sKAeu8NUy_g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AL_5hBTykkmi2e47bcAkZA&skey=dcf71eb6104dcefb&v=v7#Acme",
						"ttf": "http://fonts.gstatic.com/s/acme/v7/h0STFiiHJJuefGZJAxrSiA.ttf",
						"woff": "http://fonts.gstatic.com/s/acme/v7/-nVwQJDyFoBcrvpER8f-lA.woff",
						"woff2": "http://fonts.gstatic.com/s/acme/v7/CMfjQTCaAjBuWy3e4bQMZA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Actor": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Actor Regular\'",
						"\'Actor-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/actor/v7/7fVN2u3DZX4pZlPktnJolA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DxWkOgqTV0mZykvlmzW9aQ&skey=68222b0e89da6199&v=v7#Actor",
						"ttf": "http://fonts.gstatic.com/s/actor/v7/lbfQ5Skb-g1BK2njdJ0HIw.ttf",
						"woff": "http://fonts.gstatic.com/s/actor/v7/gZ8EM_Gzaq4WRjCimioyzQ.woff",
						"woff2": "http://fonts.gstatic.com/s/actor/v7/OxqeYhb8dn7VMNU4gi8OwA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Adamina": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Adamina Regular\'",
						"\'Adamina-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adamina/v10/MFBMttu035qipozFh_FC3g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PgoKm3el8k0WhdomOnmwfw&skey=fc252ad57fb072ab&v=v10#Adamina",
						"ttf": "http://fonts.gstatic.com/s/adamina/v10/6FkaXkveXKT6_fNDsDBhAQ.ttf",
						"woff": "http://fonts.gstatic.com/s/adamina/v10/yQWoe4dQl2wVxWej-ASAiA.woff",
						"woff2": "http://fonts.gstatic.com/s/adamina/v10/JAttAW9Rn8cZSbOU_aVAEQ.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Advent Pro": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"greek",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Advent Pro Thin\'",
						"\'AdventPro-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/87-JOpSUecTG50PBYK4ysnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=87-JOpSUecTG50PBYK4ysllIn5tFQcqMuf-jhyJP0ps&skey=39f352263cfcdefb&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/87-JOpSUecTG50PBYK4ysonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/87-JOpSUecTG50PBYK4ysnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/87-JOpSUecTG50PBYK4ysugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"200": {
					"local": [
						"\'Advent Pro ExtraLight\'",
						"\'AdventPro-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/URTSSjIp0Wr-GrjxFdFWnG6IuzAwjfI5Pbb6jofSqzk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=URTSSjIp0Wr-GrjxFdFWnIHOV2OKRwiym0CLWUSoXFs&skey=a8f9bab76971672c&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/URTSSjIp0Wr-GrjxFdFWnG2J9yQRHHBhlmQmXC5U5ok.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/URTSSjIp0Wr-GrjxFdFWnBp4ivTFcMoDJtPEqAe9hmM.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/URTSSjIp0Wr-GrjxFdFWnKEWXqnGSfwnQD3YDlprsb0.woff2"
					}
				},
				"300": {
					"local": [
						"\'Advent Pro Light\'",
						"\'AdventPro-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/sJaBfJYSFgoB80OL1_66m6SxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sJaBfJYSFgoB80OL1_66mzGefNBPGWcFPRAoUX_lgLU&skey=4515d2b87cabd51f&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/sJaBfJYSFgoB80OL1_66m-LrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/sJaBfJYSFgoB80OL1_66m9kZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/sJaBfJYSFgoB80OL1_66m8u2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Advent Pro Regular\'",
						"\'AdventPro-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/rT9jpj7pBpZV6AmssbZKk1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rT9jpj7pBpZV6AmssbZKk6WUboTb-jS2tyCOQMtm97g&skey=b056d67b39ce85&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/rT9jpj7pBpZV6AmssbZKky3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/rT9jpj7pBpZV6AmssbZKkxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/rT9jpj7pBpZV6AmssbZKk_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"500": {
					"local": [
						"\'Advent Pro Medium\'",
						"\'AdventPro-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/7kBth2-rT8tP40RmMMXMLIJh5taHiwXv-DjBEZUuYXM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7kBth2-rT8tP40RmMMXMLA0_qyNcOHZM04svgoBwoTA&skey=1e9961e60fd847ac&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/7kBth2-rT8tP40RmMMXMLNIZ6OFpBzzPr7LueGMiD8k.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/7kBth2-rT8tP40RmMMXMLO46x7QEqGuF-FJIFiH1W2g.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/7kBth2-rT8tP40RmMMXMLDOo-lJoxoMO4vrg2XwIHQk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Advent Pro SemiBold\'",
						"\'AdventPro-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/3Jo-2maCzv2QLzQBzaKHV8G3e9iX24ta7lLMfbqPFME.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3Jo-2maCzv2QLzQBzaKHV3XS6izMuFYFwSUB_9Omnz0&skey=cc01488abf93c39b&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/3Jo-2maCzv2QLzQBzaKHV7h9hBNNhK4RjzVManoH7kY.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/3Jo-2maCzv2QLzQBzaKHV24H_cQCpNmkmj7HsMzmiiM.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/3Jo-2maCzv2QLzQBzaKHV6VlZKEoJGujTpfWnQT9bUY.woff2"
					}
				},
				"700": {
					"local": [
						"\'Advent Pro Bold\'",
						"\'AdventPro-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/adventpro/v7/M4I6QiICt-ey_wZTpR2gK2zklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M4I6QiICt-ey_wZTpR2gKz9QLNJZUvW8xv4RpDkyVDQ&skey=2ccfc5338aad45a&v=v7#AdventPro",
						"ttf": "http://fonts.gstatic.com/s/adventpro/v7/M4I6QiICt-ey_wZTpR2gK_Er6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/adventpro/v7/M4I6QiICt-ey_wZTpR2gKwFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/adventpro/v7/M4I6QiICt-ey_wZTpR2gK4WiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Aguafina Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aguafina Script Regular\'",
						"\'AguafinaScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/aguafinascript/v6/65g7cgMtMGnNlNyq_Z6CvMRAjcwhH4MEdRofTbA0Ghw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=65g7cgMtMGnNlNyq_Z6CvDOOHwNldbZYpbzbEl7ku10&skey=572306981a7a1f93&v=v6#AguafinaScript",
						"ttf": "http://fonts.gstatic.com/s/aguafinascript/v6/65g7cgMtMGnNlNyq_Z6CvOCCe9ONX3soS2UUkIHWRRQ.ttf",
						"woff": "http://fonts.gstatic.com/s/aguafinascript/v6/65g7cgMtMGnNlNyq_Z6CvDVi_4UGEKHjyEZCTqR5Ysg.woff",
						"woff2": "http://fonts.gstatic.com/s/aguafinascript/v6/65g7cgMtMGnNlNyq_Z6CvJ6NrsdC0qWyfM-y9kwQ5jk.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Akronim": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Akronim Regular\'",
						"\'Akronim-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/akronim/v7/ABKKlaVPGzhBcBaq7iXm4A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=my9lqMPsywK_SeJl7gQNnQ&skey=a537edc4421490c4&v=v7#Akronim",
						"ttf": "http://fonts.gstatic.com/s/akronim/v7/fDoevPJqrGJH1YsbwQySbQ.ttf",
						"woff": "http://fonts.gstatic.com/s/akronim/v7/fJYaXTH6z-iiw8_UeEYH1g.woff",
						"woff2": "http://fonts.gstatic.com/s/akronim/v7/FwFWGsi7uh1p9mm50tEciw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Aladin": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aladin Regular\'",
						"\'Aladin-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/aladin/v6/daqId-n1hv3XxU9oQ-8Daw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=S_3Mkgcjdp9V6xfT62xXHA&skey=6a1ad71149991211&v=v6#Aladin",
						"ttf": "http://fonts.gstatic.com/s/aladin/v6/-YzDdFuv4tOQtGxvE0ZvXw.ttf",
						"woff": "http://fonts.gstatic.com/s/aladin/v6/buRUtoRWOWPeMPMKs6Y-uw.woff",
						"woff2": "http://fonts.gstatic.com/s/aladin/v6/wzM-ZeRLnblnioNhK00GaA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Aldrich": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aldrich Regular\'",
						"\'Aldrich-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/aldrich/v8/CbV6adQ0a77a6HkPxPvYiA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3H_bqUWQrhpCbJRKdvN6rw&skey=b376a342fbff0b06&v=v8#Aldrich",
						"ttf": "http://fonts.gstatic.com/s/aldrich/v8/BsJ0rSrq4pBC2xoMlek0Qg.ttf",
						"woff": "http://fonts.gstatic.com/s/aldrich/v8/Y0zWA9-hxl3_xvcxN-VXfA.woff",
						"woff2": "http://fonts.gstatic.com/s/aldrich/v8/j-NnyokbAnhXANS2iZ6Jew.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Alef": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"hebrew",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alef Regular\'",
						"\'Alef-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alef/v9/5jDodXBqLZ_uyhFtHw7V8A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FpiYdJYEktm6aYq7Zf_kvQ&skey=12751269588cd788&v=v9#Alef",
						"ttf": "http://fonts.gstatic.com/s/alef/v9/gzq6OSepdeZ1VdycsVw6Vg.ttf",
						"woff": "http://fonts.gstatic.com/s/alef/v9/C8wmYJieZdfX3SNk-GwKVA.woff",
						"woff2": "http://fonts.gstatic.com/s/alef/v9/PgKMCGPCV9cpBC0J2OLAhg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alef Bold\'",
						"\'Alef-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alef/v9/gekh88P-HCYLsYA_fiFX9A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=J-oyYujyQufb0ul2u7qxnA&skey=52f19229bca4351b&v=v9#Alef",
						"ttf": "http://fonts.gstatic.com/s/alef/v9/X0iSt6XzCfNbPTjLwRkb_Q.ttf",
						"woff": "http://fonts.gstatic.com/s/alef/v9/-Kr5IHxOfJcJ-pnH-9NRPA.woff",
						"woff2": "http://fonts.gstatic.com/s/alef/v9/a_b6i2iOdMAEMhttbuoj2g.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Alegreya": {
		"category": "serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Alegreya Italic\'",
						"\'Alegreya-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/Q-XbT1m22Fi9BEKb7y59O1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Q-XbT1m22Fi9BEKb7y59O6WUboTb-jS2tyCOQMtm97g&skey=144fc0c6d8ae8e92&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/Q-XbT1m22Fi9BEKb7y59Oy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/Q-XbT1m22Fi9BEKb7y59OxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/Q-XbT1m22Fi9BEKb7y59O_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Medium Italic\'",
						"\'Alegreya-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/baLsZTz4WeQ1BZAOY-Ma_YJh5taHiwXv-DjBEZUuYXM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=baLsZTz4WeQ1BZAOY-Ma_Q0_qyNcOHZM04svgoBwoTA&skey=3064962df60c5d50&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/baLsZTz4WeQ1BZAOY-Ma_dIZ6OFpBzzPr7LueGMiD8k.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/baLsZTz4WeQ1BZAOY-Ma_e46x7QEqGuF-FJIFiH1W2g.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/baLsZTz4WeQ1BZAOY-Ma_TOo-lJoxoMO4vrg2XwIHQk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Bold Italic\'",
						"\'Alegreya-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/IWi8e5bpnqhMRsZKTcTUWmzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IWi8e5bpnqhMRsZKTcTUWj9QLNJZUvW8xv4RpDkyVDQ&skey=946bf86ea46b6b75&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/IWi8e5bpnqhMRsZKTcTUWvEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/IWi8e5bpnqhMRsZKTcTUWgFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/IWi8e5bpnqhMRsZKTcTUWoWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya ExtraBold Italic\'",
						"\'Alegreya-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/zBzWGwjiXVY_eRAcMxLbPB8AHhEfjUJjouFVttJjJoo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zBzWGwjiXVY_eRAcMxLbPFrFCbvhIy2ZaAENKM-VgsA&skey=b8c16b97c6614872&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/zBzWGwjiXVY_eRAcMxLbPI3SmTH8Evs8V90CYwW3JLk.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/zBzWGwjiXVY_eRAcMxLbPCS-0kw_uRLN9JEz12uqVRQ.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/zBzWGwjiXVY_eRAcMxLbPAry2jK1Y0oNyoF1xLf3zMQ.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Black Italic\'",
						"\'Alegreya-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/-L71QLH_XqgYWaI1GbOVhsWwaGkf25P-zZOrMBTzpJc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-L71QLH_XqgYWaI1GbOVhgbguVsRAaYn2Q4xl-qnf-A&skey=4c81cd3fdf01aa1a&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/-L71QLH_XqgYWaI1GbOVhl6YDbH3175F1es-Zl7mOpU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/-L71QLH_XqgYWaI1GbOVhoPAkl-0rCkX4F4zIO7lYWE.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/-L71QLH_XqgYWaI1GbOVhsjsb7Oq0o-uqUFW7Ygu5rM.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Alegreya Regular\'",
						"\'Alegreya-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/ykkDjEglwboeUvfBbf-orfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wkeaMjRCVrYDy6_bxD9exvesZW2xOQ-xsNqO47m55DA&skey=a67f3093e1ad2d69&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/jvx_POxM6YeT6dBBhDfmufesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/MYFQxfgoxFvFirdbdLj3M_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/4vRXIs1BEbKX6mQ7lGu1I_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Medium\'",
						"\'Alegreya-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/eigJiMeOMKgnqM01RzR8dGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eigJiMeOMKgnqM01RzR8dHNsigHlcrQGNV8nkUSFQfc&skey=35c275bcbb1440e1&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/eigJiMeOMKgnqM01RzR8dJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/eigJiMeOMKgnqM01RzR8dIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/eigJiMeOMKgnqM01RzR8dI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Bold\'",
						"\'Alegreya-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/F5BSMOSf_T8GT2wiqqpj3WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=F5BSMOSf_T8GT2wiqqpj3XNsigHlcrQGNV8nkUSFQfc&skey=39b4f4f1343d121e&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/F5BSMOSf_T8GT2wiqqpj3Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/F5BSMOSf_T8GT2wiqqpj3YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/F5BSMOSf_T8GT2wiqqpj3Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya ExtraBold\'",
						"\'Alegreya-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/79w9sW82W0vL4JL3DXDBwmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=79w9sW82W0vL4JL3DXDBwnNsigHlcrQGNV8nkUSFQfc&skey=7632a94a62a8149&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/79w9sW82W0vL4JL3DXDBwp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/79w9sW82W0vL4JL3DXDBwobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/79w9sW82W0vL4JL3DXDBwo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Black\'",
						"\'Alegreya-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreya/v10/77GwhzeWPpmLIJUaM8KhxGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=77GwhzeWPpmLIJUaM8KhxHNsigHlcrQGNV8nkUSFQfc&skey=dc141b5d89ee0d73&v=v10#Alegreya",
						"ttf": "http://fonts.gstatic.com/s/alegreya/v10/77GwhzeWPpmLIJUaM8KhxJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreya/v10/77GwhzeWPpmLIJUaM8KhxIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreya/v10/77GwhzeWPpmLIJUaM8KhxI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Alegreya SC": {
		"category": "serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Alegreya SC Italic\'",
						"\'AlegreyaSC-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/GOqmv3FLsJ2r6ZALMZVBmqSxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GOqmv3FLsJ2r6ZALMZVBmjGefNBPGWcFPRAoUX_lgLU&skey=845e0c91d68ef2fd&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/GOqmv3FLsJ2r6ZALMZVBmuLrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/GOqmv3FLsJ2r6ZALMZVBmtkZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/GOqmv3FLsJ2r6ZALMZVBmsu2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya SC Medium Italic\'",
						"\'AlegreyaSC-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6fKmQu4cG5QnmuCFCsciK9o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5PCoU7IUfCicpKBJtBmP6bHPwKxjim0WhwsoE4U6r7E&skey=f70f00235db45ffc&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6X4elNPSrJo8K1X7hvJW37A.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6XsOjp2j4oPInuz1P52HMwA.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6Q28na7a-F9KZNLutV0Cpw0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya SC Bold Italic\'",
						"\'AlegreyaSC-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6dmkQI_kos-lIOeNt19QAas.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5PCoU7IUfCicpKBJtBmP6fXRuyUpAA8tGJEYgFPFMx8&skey=457a1804d9918cfb&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6WsGzsqhEorxQDpu60nfWEc.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6QRV2F9RPTaqyJ4QibDfkzM.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6Y9ObOXPY1wUIXqKtDjSdsY.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya SC ExtraBold Italic\'",
						"\'AlegreyaSC-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6cLz2C-02ajj1TbReB0cKr0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5PCoU7IUfCicpKBJtBmP6ZqHivf8szR_Pq9IwLuXxfc&skey=94bb0467eff0e386&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6eUiclUiImanXywmY6zS6xU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6Rubm17CrcCGdbJfM9gq12Y.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6UC6sznG7zHQDncEf6U2ato.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya SC Black Italic\'",
						"\'AlegreyaSC-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6WIj-mgkPb6qFXpKx84XxgI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5PCoU7IUfCicpKBJtBmP6S3qygzJ8QXGBKpBlejnEAY&skey=ba71b66ad36ffd97&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6Yz9vaEMf1KGK_8xIEQHrz4.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6R6wl36qhJi1relg7eY3aj0.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/5PCoU7IUfCicpKBJtBmP6Tf7N2bZoScLc-44q5CB23E.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Alegreya SC Regular\'",
						"\'AlegreyaSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/-74JUGs8W14C5cCBFRS302fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-74JUGs8W14C5cCBFRS303NsigHlcrQGNV8nkUSFQfc&skey=c9182af3dcd1bd2c&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/-74JUGs8W14C5cCBFRS3050EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/-74JUGs8W14C5cCBFRS304bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/-74JUGs8W14C5cCBFRS3044P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya SC Medium\'",
						"\'AlegreyaSC-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUqyGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M9OIREoxDkvynwTpBAYUq6057wUl25f8_0IloMUHk98&skey=6fb530d5a4aef674&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq_Mi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUqyqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq7BojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya SC Bold\'",
						"\'AlegreyaSC-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq7Ft29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M9OIREoxDkvynwTpBAYUq3tNmQEE9wZ6UZlmiISB1pg&skey=6aff66d9fa0eca05&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq5_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUqzqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq4lIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya SC ExtraBold\'",
						"\'AlegreyaSC-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq5hT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M9OIREoxDkvynwTpBAYUq0WkFefV8YEa5Z9BVNHdJ6k&skey=7995df6a714ce496&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq1DMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq0CDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq3ibbpXgLHK_uTT48UMyjSM.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya SC Black\'",
						"\'AlegreyaSC-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq68knJ7dcSpE9bYpElP8kOU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M9OIREoxDkvynwTpBAYUq8TCo6WkuhWceGynHdPeLtc&skey=7724af2489421d01&v=v9#AlegreyaSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUqxG4wFYO9UG-PxKqsSvMNyg.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq0ExzZ44ka2Lr5i-x5aWr0E.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasc/v9/M9OIREoxDkvynwTpBAYUq8pPZoEQdaDZ3o3Np19rzJk.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Alegreya Sans": {
		"category": "sans-serif",
		"lastModified": "2017-11-09",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Alegreya Sans Thin Italic\'",
						"\'AlegreyaSans-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/gRkSP2lBpqoMTVxg7DmVnx3_z7XAx40bZec3GAqBMUk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gRkSP2lBpqoMTVxg7DmVn0vx2OHas1l2wHkgd2Bw-ow&skey=d17c319c8d33a22d&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/gRkSP2lBpqoMTVxg7DmVn51GvkFS-1JdC_EuoCxkPxw.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/gRkSP2lBpqoMTVxg7DmVn4LP4UNA9D2z4ENPJ1-tqL0.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/gRkSP2lBpqoMTVxg7DmVn4b1dfXLIbKoNJCsg9ccTpk.woff2"
					}
				},
				"300": {
					"local": [
						"\'Alegreya Sans Light Italic\'",
						"\'AlegreyaSans-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CuG-WZz-1DTwgU2ia_tB6Qs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WfiXipsmjqRqsDBQ1bA9ClMLOeKR-1Kbd_MMvsUFZSs&skey=e304989c3a7d0d0c&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Cr6rH6_fD_-Le79V1-WjGD8.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CgoSvwt5Jk8V5Qzz5gxIVhE.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CmbgPR6on8bw8ywXjDqMUr4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Alegreya Sans Italic\'",
						"\'AlegreyaSans-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PEaA4UDuhMXS88OyPKPJRdI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TKyx_-JJ6MdpQruNk-t-PAaO9A8rbHcrtCtU7E2MJ98&skey=40e47c41c6236e80&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PMTRVpfLYDaJu02tGY_cDUU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PM_0Gg_psQEhwRxPwkVXUB8.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PPOSZGZVnZh1qFL4FBVulds.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Sans Medium Italic\'",
						"\'AlegreyaSans-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CgCONBFOVFsx-hK7IjrCMMY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WfiXipsmjqRqsDBQ1bA9CgRv__1KFBPX3lGrv8-gLKQ&skey=bc47a5fb3e95d107&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Csu5A6Q16drCslwRrweSiJM.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Cjz7UTTuXWmzX65m1n9Ltf4.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Ct_IqBrMQJeb3btf4G2wJuM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Sans Bold Italic\'",
						"\'AlegreyaSans-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CoN9v1E9s2s8jv6Rx3KRXFM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WfiXipsmjqRqsDBQ1bA9CjDUNo_fDsprKQliNc120xk&skey=f8e2c3e66945eca4&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CkXZMkInVmE5F43bEXap4GE.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CvQp_31g0rjXKZ8Gm9SMcKk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CsYBCjQycNOg465W8lWeYjs.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya Sans ExtraBold Italic\'",
						"\'AlegreyaSans-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CmB4IMcCdUYZiqJ1eKxqZBQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WfiXipsmjqRqsDBQ1bA9CrV2oPa1rBRc7g2EizsiWjA&skey=dd8d3088bec4f2ac&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Cs6zOI0pjlStGO1UwdkVvsA.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CrCg-HxJJqxN4VXdlZqPV8c.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CtoLup_JzTqNKwLJ6RzBh8g.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Sans Black Italic\'",
						"\'AlegreyaSans-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Ch_uNYChsUI31uc-KUBMwLs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WfiXipsmjqRqsDBQ1bA9CuDlhviHlUzmdam-kcgN4TQ&skey=109729c659157169&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CobCsgU_jp9Lq9WYUd4Zb_g.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9Cjd0jJVdcA9m8Zd2UWAUCg8.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/WfiXipsmjqRqsDBQ1bA9CuNlVeDectUokiFkVZNBZa4.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Alegreya Sans Thin\'",
						"\'AlegreyaSans-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PEj9jKN0mrW2JlfgpgABkXg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TKyx_-JJ6MdpQruNk-t-POUwc2Z2NccQRCLqma-87B8&skey=8dfa542415c8f18&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PMDtSOXLvbGaPuwEXJiol_g.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PIafd8OFeHte__SY0up2GVg.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/TKyx_-JJ6MdpQruNk-t-PNwUxhKezLbrdDqbhh7XPwM.woff2"
					}
				},
				"300": {
					"local": [
						"\'Alegreya Sans Light\'",
						"\'AlegreyaSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aXpzoWMhCGBxZR-F3lIjwoQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=11EDm-lum6tskJMBbdy9aVi23_SsAxI7ZCac_Xmke6w&skey=f97ac2795f49c08c&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9ac5nNYjIb-KbqEh50utxFtk.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aaWGgEO1vGR9ucXjKCo8vxU.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aeNC-0xib1SK7Oln1iLdt4o.woff2"
					}
				},
				"400": {
					"local": [
						"\'Alegreya Sans Regular\'",
						"\'AlegreyaSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/KYNzioYhDai7mTMnx_gDgrSL3g004LNKkgHM9a6X73A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KYNzioYhDai7mTMnx_gDgjjR3xVPJpEcWH1UXm1-s8c&skey=4d4d075d48809241&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/KYNzioYhDai7mTMnx_gDgoB9a16epZVaac-gfobfbfA.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/KYNzioYhDai7mTMnx_gDgtUFqmyT-Ih543PWa_C0ig4.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/KYNzioYhDai7mTMnx_gDgsmBRJoLbs7X6hY7yFEc97Q.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Sans Medium\'",
						"\'AlegreyaSans-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aavtqssTGFxKBYDOY35-ctA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=11EDm-lum6tskJMBbdy9aYAtZcN_2HNZOarCoCsaTns&skey=2fba1343c636ee49&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aYbHQgMiPeC0S_y2k9np4ck.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aeu_tG0Yx7qqITjSOZkMZIk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aVZp3tKiB9YnYzAIdkxupX8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Sans Bold\'",
						"\'AlegreyaSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aTaqlI4Zbww6vO_YCdhgxeo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=11EDm-lum6tskJMBbdy9aTMNmawHWsxtE2x84tjAX1I&skey=c542a612544589f2&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aX726VmFjkD_1knHNL407_k.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9ae1ouKFe7zgu3OIJnKP8_aw.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9acrysgx4XYXiGyd0rEkyLBs.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya Sans ExtraBold\'",
						"\'AlegreyaSans-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aWuju2IcSCG-a0B3cN-MAlc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=11EDm-lum6tskJMBbdy9aQpHooTm5SM-e0bYflhlpR8&skey=d3e7009e8a256442&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aRHnHbPwUmH7PMJEvaxN4tA.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aUpiVnwz0M_Hy6Y_FZjz5LA.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9aVvTxhR-HurA7zKsTVg5Awk.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Sans Black\'",
						"\'AlegreyaSans-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9adnBe0QciXpCzWCROFgtvMY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=11EDm-lum6tskJMBbdy9afLi8IWRaTV6sgt_Ubq0vts&skey=8820b7058d1ab315&v=v8#AlegreyaSans",
						"ttf": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9af2K_H9ZzEDNEtaqIAK-HoI.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9abdQ0nQrULdvYyyVgtJkSzU.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasans/v8/11EDm-lum6tskJMBbdy9acttC1UWWH1Hne0t2gWY82A.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Alegreya Sans SC": {
		"category": "sans-serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Alegreya Sans SC Thin Italic\'",
						"\'AlegreyaSansSC-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/qG3gA9iy5RpXMH4crZboqh4wsAlqwyk9UYuJPKa4azk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qG3gA9iy5RpXMH4crZboqunexgp0nRw7g6Ftb7hojys&skey=8582eb3998947588&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/qG3gA9iy5RpXMH4crZboqvGIBGuwc0Dc73iyU8odDUw.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/qG3gA9iy5RpXMH4crZboqqMsw6KPICDPw722XFBpMkE.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/qG3gA9iy5RpXMH4crZboqkoumYMHkyLFAGYCVGQRAgU.woff2"
					}
				},
				"300": {
					"local": [
						"\'Alegreya Sans SC Light Italic\'",
						"\'AlegreyaSansSC-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0NMJOMOfvRTvb0sCL4rXOss.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VweK-TO3aQgazdxg8fs0LI2Yw2K_nKPEj_rv06_LBE&skey=f145284eac56c3f9&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0O_TiAOp7FdCp_4lYO4iqFA.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0FjjKuEf0et_LI5sIM2AJoM.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0C84tYCpOrCow-vAUzBq_jI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Alegreya Sans SC Italic\'",
						"\'AlegreyaSansSC-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kUEoGlWNqPXSR-q5NY9jBJQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=trwFkDJLOJf6hqM93944kfXGRcTA4cGcnRd_EYh_wNs&skey=d45b3e8ce89552af&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kanwW7lADF4m5UvrnBy4Suw.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kfZ3aPmwBU9Ffnzf9nFAeC8.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kf6W3hK41fjTX2jZ56xSjUQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Sans SC Medium Italic\'",
						"\'AlegreyaSansSC-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0PTCK1_xo2KK9Rnhy3yPHaI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VweK-TO3aQgazdxg8fs0DU-QOAAVyXZeIpcA0pf0Os&skey=5bcc4619819d2ac8&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0F_DZYh_PPzIqGs0dh7SYZM.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0OvDMiQXwNOKnCwIuLC28zA.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0LWBQwozEUSmzvI1FE0onxg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Sans SC Bold Italic\'",
						"\'AlegreyaSansSC-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0NzUu5UuHS2qkaKy_gjq_y0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VweK-TO3aQgazdxg8fs0IeaWHmvZBZZUzt1dT5vlzU&skey=2391d100301cb557&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0CHPkILhDlFZRqOKYLbBLo0.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0A7mZI2J7KiG_JqiuD9J9kk.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0FqD4HUesBVbmAG990lI73o.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya Sans SC ExtraBold Italic\'",
						"\'AlegreyaSansSC-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0CGRtJxM0a9YfHFcV4g_Vyg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VweK-TO3aQgazdxg8fs0NFNxL1guU72OocBwuNJo68&skey=34f4a04d46db3929&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0BZ96r0NATfXe2rKSi9TgIY.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0NrXpOm10Q8-bLoQizC2M-s.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0C6T9VFpcONOD56nIjVydig.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Sans SC Black Italic\'",
						"\'AlegreyaSansSC-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0ATq5GAPHCPnNMrfJu7WNaM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VweK-TO3aQgazdxg8fs0KIVc1SPM-NatdKuEEHx2Qc&skey=135c7b0b7abd1331&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0EqtEDGlWsNVccB5NLdNpwQ.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0D01uGkNPrDwJOsWWyX9WMg.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/0VweK-TO3aQgazdxg8fs0APnLdJ9CkthbeWN8Ot0ta8.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Alegreya Sans SC Thin\'",
						"\'AlegreyaSansSC-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kSjmFNyjlfcs1-CUvmBvOhY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=trwFkDJLOJf6hqM93944kQhClbqiipjyf5JiwLNZ2QI&skey=a595ff14eb655a69&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kcXdg0c9qpFbtXAkcPslT20.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kS5IotXgj0_mHIXw2autu14.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/trwFkDJLOJf6hqM93944kQF2uMZgrec37bFtef5rA7g.woff2"
					}
				},
				"300": {
					"local": [
						"\'Alegreya Sans SC Light\'",
						"\'AlegreyaSansSC-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46z9at4pUvNcgoJNaqTz2-sw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjAmkoP1y0Vaad0UPPR469MlGGQZvnA54Ck9rIxJ9oA&skey=704b9e61376d7cb6&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR466Yg0IPT4GEZJSIWMW-0ug4.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46_2gvMAuz8C-YvH4pa35nq8.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR462t-_7FhVRyo3Q-fnbQ2rok.woff2"
					}
				},
				"400": {
					"local": [
						"\'Alegreya Sans SC Regular\'",
						"\'AlegreyaSansSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/6kgb6ZvOagoVIRZyl8XV-NHiSTJ5Psnp4HimG0ycv3w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6kgb6ZvOagoVIRZyl8XV-CSNX7PJx7R17Ky6JPhVMDk&skey=6a35e1ecdd8270ea&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/6kgb6ZvOagoVIRZyl8XV-F1_68YLtTmKn7AnUVga1YU.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/6kgb6ZvOagoVIRZyl8XV-KisNWI8qEu_hw_BXmaMF84.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/6kgb6ZvOagoVIRZyl8XV-GL2AW3E1oWj8j6lNowK7s4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Alegreya Sans SC Medium\'",
						"\'AlegreyaSansSC-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46-aH7RdSx8H9ZrlFfzxtB_c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjAmkoP1y0Vaad0UPPR460z0OkGkSfvWOjcfXRotbwE&skey=dfe3dbe00507cf7e&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR460hw8T3JzlsJFxhXJnERlgM.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46whJOZTZOJCgHOTlr0W59eQ.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46xOdcOOfPHgKP68z5TldyPo.woff2"
					}
				},
				"700": {
					"local": [
						"\'Alegreya Sans SC Bold\'",
						"\'AlegreyaSansSC-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46xSuwoOEPpMW2uwCryBfPIU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjAmkoP1y0Vaad0UPPR469X_M60Gbroib9-m3qlBXCM&skey=e9cd6cbb55b42f19&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR4612Hw7dCZcVb7jrxLR79C34.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR465pg9qZ23bCDPZI9Je_bw7E.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR469Ed9Pn-13-4Ar-ZJiKZb0s.woff2"
					}
				},
				"800": {
					"local": [
						"\'Alegreya Sans SC ExtraBold\'",
						"\'AlegreyaSansSC-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR4628NIhAkFnQlnWv9wQcduZI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjAmkoP1y0Vaad0UPPR46zMfjyzY7_pJTuim7eWaSi0&skey=de6b0ddaaaee4084&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR460_SGFAXhdx64LjQEhcQ6Fw.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR468y6vRMepCMP8fwNNQqXFDo.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR4602OkiCdAbSeZ8lARI5Qf6A.woff2"
					}
				},
				"900": {
					"local": [
						"\'Alegreya Sans SC Black\'",
						"\'AlegreyaSansSC-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR466g8Ssu5GtwsuXmenm26HAE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjAmkoP1y0Vaad0UPPR46yq5GgX8P0FE6TwXy6os49s&skey=e3ea47f86d3ed6ac&v=v7#AlegreyaSansSC",
						"ttf": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR465ymUkgA0ar0xI3S0YnMck4.ttf",
						"woff": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR46-s4332CIbGY9ipgCXO5zgA.woff",
						"woff2": "http://fonts.gstatic.com/s/alegreyasanssc/v7/AjAmkoP1y0Vaad0UPPR466YU_-P-PSoScPQN92M0xOA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Alex Brush": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alex Brush Regular\'",
						"\'AlexBrush-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alexbrush/v8/IdwaSrUcr-IskDo5YUNTVVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IdwaSrUcr-IskDo5YUNTVaWUboTb-jS2tyCOQMtm97g&skey=102cfecb8b7851f&v=v8#AlexBrush",
						"ttf": "http://fonts.gstatic.com/s/alexbrush/v8/IdwaSrUcr-IskDo5YUNTVS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/alexbrush/v8/IdwaSrUcr-IskDo5YUNTVRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/alexbrush/v8/IdwaSrUcr-IskDo5YUNTVfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Alfa Slab One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alfa Slab One Regular\'",
						"\'AlfaSlabOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alfaslabone/v7/Qx6FPcitRwTC_k88tLPc-cOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Qx6FPcitRwTC_k88tLPc-TyKAGS2js9R2mTcvyyc0eU&skey=eb2fdb158beaba49&v=v7#AlfaSlabOne",
						"ttf": "http://fonts.gstatic.com/s/alfaslabone/v7/Qx6FPcitRwTC_k88tLPc-SbsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/alfaslabone/v7/Qx6FPcitRwTC_k88tLPc-fn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/alfaslabone/v7/Qx6FPcitRwTC_k88tLPc-TxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Alice": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alice Regular\'",
						"\'Alice-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alice/v9/sZyKh5NKrCk1xkCk_F1S8A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1xLueNrnwaEUg1pDxEf7_A&skey=8a351bda90f672d8&v=v9#Alice",
						"ttf": "http://fonts.gstatic.com/s/alice/v9/acf9XsUhgp1k2j79ATk2cw.ttf",
						"woff": "http://fonts.gstatic.com/s/alice/v9/_H4kMcdhHr0B8RDaQcqpTA.woff",
						"woff2": "http://fonts.gstatic.com/s/alice/v9/l5RFQT5MQiajQkFxjDLySg.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Alike": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alike Regular\'",
						"\'Alike-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alike/v10/J5m43BJ9UV3_U0R3wm9e9g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NS6SXdfRi6o1SoBB8K6OnA&skey=281dd7008c53bd66&v=v10#Alike",
						"ttf": "http://fonts.gstatic.com/s/alike/v10/9YPgiMNwlj6YrTzCeqLufQ.ttf",
						"woff": "http://fonts.gstatic.com/s/alike/v10/0wlTTJEXU4hQ4azwPn6Wjw.woff",
						"woff2": "http://fonts.gstatic.com/s/alike/v10/ucX0vp16K9rM-IkH3z-oWA.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Alike Angular": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Alike Angular Regular\'",
						"\'AlikeAngular-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/alikeangular/v8/OpeCu4xxI3qO1C7CZcJtPVXZWpUaOgyRVNWD_aKPfNA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OpeCu4xxI3qO1C7CZcJtPUfLuVi45wAXoU9uBmww-CY&skey=bd21f13e6cde9ea2&v=v8#AlikeAngular",
						"ttf": "http://fonts.gstatic.com/s/alikeangular/v8/OpeCu4xxI3qO1C7CZcJtPdwTBhp0wCREnGrKOpMVvns.ttf",
						"woff": "http://fonts.gstatic.com/s/alikeangular/v8/OpeCu4xxI3qO1C7CZcJtPb6iX381CwN1C9yEk5y0JLs.woff",
						"woff2": "http://fonts.gstatic.com/s/alikeangular/v8/OpeCu4xxI3qO1C7CZcJtPXhbSNRWLU9030AtM4Q6g3Y.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Allan": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Allan Regular\'",
						"\'Allan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/allan/v9/Eir5oDuXSB1UWX3m64bf6Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1nYXAd_u0YWFFpGXL2HpLg&skey=47bae38e791f0fba&v=v9#Allan",
						"ttf": "http://fonts.gstatic.com/s/allan/v9/Pb6nMVFTTNIRQ-6dLfiuqg.ttf",
						"woff": "http://fonts.gstatic.com/s/allan/v9/5aqh4PlcZKVdCD6zaeSMnQ.woff",
						"woff2": "http://fonts.gstatic.com/s/allan/v9/IDtEQy3AyHFszsVmLG7PSg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Allan Bold\'",
						"\'Allan-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/allan/v9/r9xwRMq68sUghlYGmsDYq_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZbZIN4tHy6gxNRCGVjtiQfesZW2xOQ-xsNqO47m55DA&skey=67bf6cfd634a416d&v=v9#Allan",
						"ttf": "http://fonts.gstatic.com/s/allan/v9/QNNVW1nta25A1TfGw7wquPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/allan/v9/HDuJMALbbJ3Ny_JtXeABSfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/allan/v9/XrS3DTpK5zGDCQZc8I2ynvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Allerta": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Allerta Regular\'",
						"\'Allerta-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/allerta/v8/EU1CuJbZpvfr0oOMISsX5Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0_qDrImc64GADh3pCQk0NA&skey=ddece23091d07885&v=v8#Allerta",
						"ttf": "http://fonts.gstatic.com/s/allerta/v8/80JiVPiVsoLIvgdxfy_IFg.ttf",
						"woff": "http://fonts.gstatic.com/s/allerta/v8/URdUfE0ePw9inz9dceNoVA.woff",
						"woff2": "http://fonts.gstatic.com/s/allerta/v8/5tgwy7yYrNSzP9n8aR6sZg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Allerta Stencil": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Allerta Stencil Regular\'",
						"\'AllertaStencil-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/allertastencil/v8/CdSZfRtHbQrBohqmzSdDYKzUMVI64oN3fmj_7xTHOIo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CdSZfRtHbQrBohqmzSdDYDC6zcxMUvhSpjgTxUmhVAk&skey=8234201ddc67dd0e&v=v8#AllertaStencil",
						"ttf": "http://fonts.gstatic.com/s/allertastencil/v8/CdSZfRtHbQrBohqmzSdDYKx4dljS8LgdW1vxXN8xI8w.ttf",
						"woff": "http://fonts.gstatic.com/s/allertastencil/v8/CdSZfRtHbQrBohqmzSdDYHPCKOCMXSfEg7NxhSsqpWM.woff",
						"woff2": "http://fonts.gstatic.com/s/allertastencil/v8/CdSZfRtHbQrBohqmzSdDYHyjZGU_SYMIAZWjSGDHnGA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Allura": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Allura Regular\'",
						"\'Allura-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/allura/v6/eHzqqXtUkk0OczEgWMyQqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AEka2JHOeuH3N-ICt_dzng&skey=79209908b474aec&v=v6#Allura",
						"ttf": "http://fonts.gstatic.com/s/allura/v6/vepcd74zyZuQXtgnV3VOrg.ttf",
						"woff": "http://fonts.gstatic.com/s/allura/v6/ExiT4hKozv4E-LiOi2vvJA.woff",
						"woff2": "http://fonts.gstatic.com/s/allura/v6/POH_k539yBSzDKiiyA98Tg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Almendra": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Almendra Italic\'",
						"\'Almendra-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendra/v10/b8oLPOtioxOKaUF_o5IisFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=b8oLPOtioxOKaUF_o5IisKWUboTb-jS2tyCOQMtm97g&skey=5ab11c479664c481&v=v10#Almendra",
						"ttf": "http://fonts.gstatic.com/s/almendra/v10/b8oLPOtioxOKaUF_o5IisC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/almendra/v10/b8oLPOtioxOKaUF_o5IisBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/almendra/v10/b8oLPOtioxOKaUF_o5IisPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Almendra Bold Italic\'",
						"\'Almendra-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendra/v10/-tXHKMcnn6FqrhJV3l1e3Wzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-tXHKMcnn6FqrhJV3l1e3T9QLNJZUvW8xv4RpDkyVDQ&skey=442f2d445a8cddfc&v=v10#Almendra",
						"ttf": "http://fonts.gstatic.com/s/almendra/v10/-tXHKMcnn6FqrhJV3l1e3fEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/almendra/v10/-tXHKMcnn6FqrhJV3l1e3QFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/almendra/v10/-tXHKMcnn6FqrhJV3l1e3YWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Almendra Regular\'",
						"\'Almendra-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendra/v10/HqKkAz0JrIpF79DFVYpisPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=x4aeRaHrlHxrmwyDdZmxSPesZW2xOQ-xsNqO47m55DA&skey=5ada6a8138c83e09&v=v10#Almendra",
						"ttf": "http://fonts.gstatic.com/s/almendra/v10/873lN8UUm6Y6OO5JEM5rE_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/almendra/v10/EuUT8I7QXLgT3dVSB6wEd_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/almendra/v10/nn6qd3WfGL85pmBWUjz1lvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Almendra Bold\'",
						"\'Almendra-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendra/v10/7uClDfLGor3AEOOxrUeUhmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7uClDfLGor3AEOOxrUeUhnNsigHlcrQGNV8nkUSFQfc&skey=fc8bf3b077fdf497&v=v10#Almendra",
						"ttf": "http://fonts.gstatic.com/s/almendra/v10/7uClDfLGor3AEOOxrUeUhp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/almendra/v10/7uClDfLGor3AEOOxrUeUhobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/almendra/v10/7uClDfLGor3AEOOxrUeUho4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Almendra Display": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Almendra Display Regular\'",
						"\'AlmendraDisplay-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendradisplay/v8/2Zuu97WJ_ez-87yz5Ai8fLe3AsAJmdYwF3n7gHK4QTQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2Zuu97WJ_ez-87yz5Ai8fGrjLcHVtfJQyoPByBFBHV4&skey=5188b8576550a0ff&v=v8#AlmendraDisplay",
						"ttf": "http://fonts.gstatic.com/s/almendradisplay/v8/2Zuu97WJ_ez-87yz5Ai8fMzai8e7xzqnKiVb1EwOy0E.ttf",
						"woff": "http://fonts.gstatic.com/s/almendradisplay/v8/2Zuu97WJ_ez-87yz5Ai8fJa6Tn9fxpDPuRSK4Gn5Ybw.woff",
						"woff2": "http://fonts.gstatic.com/s/almendradisplay/v8/2Zuu97WJ_ez-87yz5Ai8fNhy5e3cTyNKTHXrP9DO-Rc.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Almendra SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Almendra SC Regular\'",
						"\'AlmendraSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/almendrasc/v8/qilwuKF0giI9Al2tghabrWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qilwuKF0giI9Al2tghabrXNsigHlcrQGNV8nkUSFQfc&skey=5f28d08bd71a54e3&v=v8#AlmendraSC",
						"ttf": "http://fonts.gstatic.com/s/almendrasc/v8/qilwuKF0giI9Al2tghabrZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/almendrasc/v8/qilwuKF0giI9Al2tghabrYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/almendrasc/v8/qilwuKF0giI9Al2tghabrY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Amarante": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Amarante Regular\'",
						"\'Amarante-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amarante/v5/ZG22qNCk9KRLvYun4zjSnfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YOHxl19HS4vDucfy5DQVe_esZW2xOQ-xsNqO47m55DA&skey=d53492408d13fc7d&v=v5#Amarante",
						"ttf": "http://fonts.gstatic.com/s/amarante/v5/7QYOnlvGMVlAzj6iP9gUMPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amarante/v5/5dF-vhm2PDTNvpxu3h5td_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amarante/v5/mf2HDk-wdi2JEvIxvmwX9vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Amaranth": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Amaranth Italic\'",
						"\'Amaranth-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaranth/v8/J0IatWFySU8P-ir89pUoJFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=J0IatWFySU8P-ir89pUoJKWUboTb-jS2tyCOQMtm97g&skey=dac6b44f9133488d&v=v8#Amaranth",
						"ttf": "http://fonts.gstatic.com/s/amaranth/v8/J0IatWFySU8P-ir89pUoJC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/amaranth/v8/J0IatWFySU8P-ir89pUoJBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/amaranth/v8/J0IatWFySU8P-ir89pUoJPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amaranth Bold Italic\'",
						"\'Amaranth-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaranth/v8/BHyuYFj9nqLFNvOvGh0xT2zklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BHyuYFj9nqLFNvOvGh0xTz9QLNJZUvW8xv4RpDkyVDQ&skey=bb7722acf0fb9a8b&v=v8#Amaranth",
						"ttf": "http://fonts.gstatic.com/s/amaranth/v8/BHyuYFj9nqLFNvOvGh0xT_Er6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/amaranth/v8/BHyuYFj9nqLFNvOvGh0xTwFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/amaranth/v8/BHyuYFj9nqLFNvOvGh0xT4WiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Amaranth Regular\'",
						"\'Amaranth-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaranth/v8/OVeYmpOgAXrJsaP-CIAb-fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-LNfY9gRr16z6WzAwCpbU_esZW2xOQ-xsNqO47m55DA&skey=a086a5f010412431&v=v8#Amaranth",
						"ttf": "http://fonts.gstatic.com/s/amaranth/v8/imfGW7soN-ntDfo1a_OKNPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amaranth/v8/RvdVaxHTnYbJDko8dLi4zvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amaranth/v8/No9yO-s63zoPZDtAqBg6OfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amaranth Bold\'",
						"\'Amaranth-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaranth/v8/hh4Od9pccylRpuf5LUPgEmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hh4Od9pccylRpuf5LUPgEnNsigHlcrQGNV8nkUSFQfc&skey=1f08e89f032cc13c&v=v8#Amaranth",
						"ttf": "http://fonts.gstatic.com/s/amaranth/v8/hh4Od9pccylRpuf5LUPgEp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/amaranth/v8/hh4Od9pccylRpuf5LUPgEobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/amaranth/v8/hh4Od9pccylRpuf5LUPgEo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Amatic SC": {
		"category": "handwriting",
		"lastModified": "2017-11-07",
		"subsets": [
			"hebrew",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Amatic SC Regular\'",
						"\'AmaticSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaticsc/v11/DPPfSFKxRTXvae2bKDzp5PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DPPfSFKxRTXvae2bKDzp5Jbd9NUM7myrQQz30yPaGQ4&skey=fb863bec8adba0c7&v=v11#AmaticSC",
						"ttf": "http://fonts.gstatic.com/s/amaticsc/v11/DPPfSFKxRTXvae2bKDzp5KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/amaticsc/v11/DPPfSFKxRTXvae2bKDzp5D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/amaticsc/v11/DPPfSFKxRTXvae2bKDzp5FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amatic SC Bold\'",
						"\'AmaticSC-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amaticsc/v11/IDnkRTPGcrSVo50UyYNK73Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IDnkRTPGcrSVo50UyYNK71lIn5tFQcqMuf-jhyJP0ps&skey=f5c87b6211811ffa&v=v11#AmaticSC",
						"ttf": "http://fonts.gstatic.com/s/amaticsc/v11/IDnkRTPGcrSVo50UyYNK74nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/amaticsc/v11/IDnkRTPGcrSVo50UyYNK73hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/amaticsc/v11/IDnkRTPGcrSVo50UyYNK7-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Amethysta": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Amethysta Regular\'",
						"\'Amethysta-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amethysta/v6/uuO0VFu8kdKx34ju6adj-PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uuO0VFu8kdKx34ju6adj-Jbd9NUM7myrQQz30yPaGQ4&skey=1bdab4974033da41&v=v6#Amethysta",
						"ttf": "http://fonts.gstatic.com/s/amethysta/v6/uuO0VFu8kdKx34ju6adj-KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/amethysta/v6/uuO0VFu8kdKx34ju6adj-D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/amethysta/v6/uuO0VFu8kdKx34ju6adj-FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Amiko": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Amiko\'",
						"\'Amiko-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiko/v2/GncWBp2brB1t3OwHKbAFbQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hyf8Ai8Gt5FX8m743xW0Yw&skey=9370075dbbb9661d&v=v2#Amiko",
						"ttf": "http://fonts.gstatic.com/s/amiko/v2/D46sH83KKHRKC0vmYJNKBg.ttf",
						"woff": "http://fonts.gstatic.com/s/amiko/v2/-2TKPifSJyig_SMlL82Wjg.woff",
						"woff2": "http://fonts.gstatic.com/s/amiko/v2/zUY3bIS78Lri9nXVNYdyrw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Amiko SemiBold\'",
						"\'Amiko-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiko/v2/Acl9Ekis9rqjtbydVLxoCPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lrHETyPThcepXQ84PlSXf_esZW2xOQ-xsNqO47m55DA&skey=dc341fb169f5b947&v=v2#Amiko",
						"ttf": "http://fonts.gstatic.com/s/amiko/v2/_3AZiSBLf-BoCM2IFSvJzfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amiko/v2/oWTWW915RefiSKQ4aJ1k7PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amiko/v2/fxM3mYvpwrCfuVHhMAeNOPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amiko Bold\'",
						"\'Amiko-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiko/v2/fssnpsVIrYjbo1IrnCG2h_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5UH5mRRK5jd07NceC14O4_esZW2xOQ-xsNqO47m55DA&skey=b0f97d34e902453e&v=v2#Amiko",
						"ttf": "http://fonts.gstatic.com/s/amiko/v2/Rjv4gjDcjtJZMWHYExTCtfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amiko/v2/JQTH97AvHeWpCBBMW-yDLfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amiko/v2/8a-gnb0G9uPWXYFVgB--bPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Amiri": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Amiri Italic\'",
						"\'Amiri-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiri/v9/uKPAo89zrlK46koRza4gnA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BKa_zbL_LlT4hxHpTASGMA&skey=6f7852bf6f540377&v=v9#Amiri",
						"ttf": "http://fonts.gstatic.com/s/amiri/v9/sISy_clj2xruN9DKJlcIUA.ttf",
						"woff": "http://fonts.gstatic.com/s/amiri/v9/4j8qo3wQOVnRZ5pcJuFmqQ.woff",
						"woff2": "http://fonts.gstatic.com/s/amiri/v9/RbwqXC6rEAVnJdiXvqbS8w.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amiri Bold Italic\'",
						"\'Amiri-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiri/v9/lS-dgDq2cQdc4hvy0c2SbFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lS-dgDq2cQdc4hvy0c2SbKWUboTb-jS2tyCOQMtm97g&skey=ccca51069e17c5a2&v=v9#Amiri",
						"ttf": "http://fonts.gstatic.com/s/amiri/v9/lS-dgDq2cQdc4hvy0c2SbC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/amiri/v9/lS-dgDq2cQdc4hvy0c2SbBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/amiri/v9/lS-dgDq2cQdc4hvy0c2SbPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Amiri Regular\'",
						"\'Amiri-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiri/v9/TsorXwX03RBzOupma1LFAQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6pVc4U0Slfp_5ZaMfPsPrA&skey=159039cc026b7e65&v=v9#Amiri",
						"ttf": "http://fonts.gstatic.com/s/amiri/v9/wBcuJyWqhu_7S194ktC46w.ttf",
						"woff": "http://fonts.gstatic.com/s/amiri/v9/9p4doK8R-5V3dBQvmi2RHA.woff",
						"woff2": "http://fonts.gstatic.com/s/amiri/v9/k2MEYNRoSfd5tdYW9SpWiA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amiri Bold\'",
						"\'Amiri-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amiri/v9/FjQ3a_S4JVVvLMCHPgrptPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wKZvsnE8Eck9V18TOtvCw_esZW2xOQ-xsNqO47m55DA&skey=5c9e4d49faf75fc2&v=v9#Amiri",
						"ttf": "http://fonts.gstatic.com/s/amiri/v9/B6S8dCfFrn6gDseBk3rdbPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amiri/v9/TpVfafqWNjMkfysbXq75T_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amiri/v9/8b_RNX_MuT-wzF5O8XZEVvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Amita": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Amita Regular\'",
						"\'Amita-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amita/v3/Lp7qUVMA-uDHBrc-jSpS8g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ruc8JfvbQGyR3hDFe2H7PA&skey=3dfbdf6b2e59f965&v=v3#Amita",
						"ttf": "http://fonts.gstatic.com/s/amita/v3/JIMOTIfjWMAlpTpCyTqxGg.ttf",
						"woff": "http://fonts.gstatic.com/s/amita/v3/eIbJIyD1K8LT294zvVLy5Q.woff",
						"woff2": "http://fonts.gstatic.com/s/amita/v3/w-qOziKJAgx5E2HjOMz-Yw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Amita Bold\'",
						"\'Amita-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/amita/v3/2A0grJv3qRTXkIaTtZH8PvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ICXX10z4ft7nyqYLBk-jbfesZW2xOQ-xsNqO47m55DA&skey=f4d9463ce099459b&v=v3#Amita",
						"ttf": "http://fonts.gstatic.com/s/amita/v3/MENZd8skxUDueEny-q58dvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/amita/v3/cyAMcfzsEgFYX-Ir717oIfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/amita/v3/xih-5WwEC1H2P3qJbGKjlvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Anaheim": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Anaheim\'",
						"\'Anaheim-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anaheim/v5/gDzLJUbBIMBbq2zoOWr_rA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1JQ0pz0jrP6PA2_TfWtEPQ&skey=3392fd8e53fdf730&v=v5#Anaheim",
						"ttf": "http://fonts.gstatic.com/s/anaheim/v5/Cvwn58PR0rYLGpoTMF4KMA.ttf",
						"woff": "http://fonts.gstatic.com/s/anaheim/v5/9grF9iDBrnUvUAGLpfiBHQ.woff",
						"woff2": "http://fonts.gstatic.com/s/anaheim/v5/UksPHcP0JWbD5D-eu-EeFA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Andada": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Andada Regular\'",
						"\'Andada-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/andada/v9/3fET6dL8q_vLZQs7bG9YYg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sR1uUTCKyRcaWb2FKpqYIQ&skey=dda1280d6527a3da&v=v9#Andada",
						"ttf": "http://fonts.gstatic.com/s/andada/v9/gFVZ8wlYe-dmg2udiSDS4w.ttf",
						"woff": "http://fonts.gstatic.com/s/andada/v9/QwS5dTKw__IJYf0VA876Iw.woff",
						"woff2": "http://fonts.gstatic.com/s/andada/v9/Hk-co7NNShGblEKzEnYCjw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Andika": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Andika Regular\'",
						"\'Andika-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/andika/v9/1yFTJDTBkJYuwToXd12EXw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8zU7RwTY9zrECNeIU4JXRQ&skey=c52ba807e15599a0&v=v9#Andika",
						"ttf": "http://fonts.gstatic.com/s/andika/v9/f6ETJtZ3CUmBRLiPKYV3VQ.ttf",
						"woff": "http://fonts.gstatic.com/s/andika/v9/7oCWhqd1EPSqB7_cG3_eAA.woff",
						"woff2": "http://fonts.gstatic.com/s/andika/v9/hqQcL6we-D2Rz2PEMZTt1g.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Angkor": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Angkor Regular\'",
						"\'Angkor-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/angkor/v10/pjQk_dtQHBspt5e5iAj2Iw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H7kB5SBAIaekErNBFX1lbQ&skey=92624971dae6a2d2&v=v10#Angkor",
						"ttf": "http://fonts.gstatic.com/s/angkor/v10/DLpLgIS-8F10ecwKqCm95Q.ttf",
						"woff": "http://fonts.gstatic.com/s/angkor/v10/xslVQL6ykAwGTOHOMdNP7w.woff",
						"woff2": "http://fonts.gstatic.com/s/angkor/v10/Vke_8K9OBrUfPOWx9oFNiPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Annie Use Your Telescope": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Annie Use Your Telescope Regular\'",
						"\'AnnieUseYourTelescope-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/annieuseyourtelescope/v8/2cuiO5VmaR09C8SLGEQjGmehdpvxL2DeiYJNaARJyxL3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2cuiO5VmaR09C8SLGEQjGoHD-AXxF7MVecTmkDB910r3rGVtsTkPsbDajuO5ueQw&skey=3d2407f15b0e226f&v=v8#AnnieUseYourTelescope",
						"ttf": "http://fonts.gstatic.com/s/annieuseyourtelescope/v8/2cuiO5VmaR09C8SLGEQjGtHf9zmWs0oMQOHwtCnidY73rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/annieuseyourtelescope/v8/2cuiO5VmaR09C8SLGEQjGgtSTT_xyPSRqbb82lxMsRH3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/annieuseyourtelescope/v8/2cuiO5VmaR09C8SLGEQjGka-vN3cnM35kL5a2hXIL_33rGVtsTkPsbDajuO5ueQw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Anonymous Pro": {
		"category": "monospace",
		"lastModified": "2017-10-10",
		"subsets": [
			"greek",
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Anonymous Pro Italic\'",
						"\'AnonymousPro-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anonymouspro/v11/q0u6LFHwttnT_69euiDbWIGc2Drk6OF7xzEFRuu1poY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=q0u6LFHwttnT_69euiDbWPDJtBPUO6DpQUINXeVpBhs&skey=8184eb3e0bc66eda&v=v11#AnonymousPro",
						"ttf": "http://fonts.gstatic.com/s/anonymouspro/v11/q0u6LFHwttnT_69euiDbWHYERyxqu4bunGuIRUtIkRI.ttf",
						"woff": "http://fonts.gstatic.com/s/anonymouspro/v11/q0u6LFHwttnT_69euiDbWEOc-qcyZDPXUzSso1bA9YE.woff",
						"woff2": "http://fonts.gstatic.com/s/anonymouspro/v11/q0u6LFHwttnT_69euiDbWC6lQeGIz_eTiUIAmQEHoRI.woff2"
					}
				},
				"700": {
					"local": [
						"\'Anonymous Pro Bold Italic\'",
						"\'AnonymousPro-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anonymouspro/v11/_fVr_XGln-cetWSUc-JpfONuiocNq7bs0SOFe77jKtE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_fVr_XGln-cetWSUc-JpfOpsXI5EXYXgCPFXjeMrPmg&skey=eade76c5c69b9140&v=v11#AnonymousPro",
						"ttf": "http://fonts.gstatic.com/s/anonymouspro/v11/_fVr_XGln-cetWSUc-JpfG5LgoF-04rdOuVmAyCISpg.ttf",
						"woff": "http://fonts.gstatic.com/s/anonymouspro/v11/_fVr_XGln-cetWSUc-JpfGLkIvtLOz01sdqGPgcEBM8.woff",
						"woff2": "http://fonts.gstatic.com/s/anonymouspro/v11/_fVr_XGln-cetWSUc-JpfOE-UnHJJqgmO_01JZd6B-Y.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Anonymous Pro Regular\'",
						"\'AnonymousPro-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anonymouspro/v11/Zhfjj_gat3waL4JSju74E3Xp_Gpx0-4m3wAn7HKLs74.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Zhfjj_gat3waL4JSju74E7-u5AnqG0eDkj80PwJxv48&skey=5f69fa382b387122&v=v11#AnonymousPro",
						"ttf": "http://fonts.gstatic.com/s/anonymouspro/v11/Zhfjj_gat3waL4JSju74Eyepy_bK1QysdtOeR9F4Ffs.ttf",
						"woff": "http://fonts.gstatic.com/s/anonymouspro/v11/Zhfjj_gat3waL4JSju74E1tUcs43uvLUMv3hfHgzs3w.woff",
						"woff2": "http://fonts.gstatic.com/s/anonymouspro/v11/Zhfjj_gat3waL4JSju74ExEOS6Aq7hJAAidQNR3rgdU.woff2"
					}
				},
				"700": {
					"local": [
						"\'Anonymous Pro Bold\'",
						"\'AnonymousPro-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anonymouspro/v11/WDf5lZYgdmmKhO8E1AQud30lRvvQrNeWza1BnlT_HW4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WDf5lZYgdmmKhO8E1AQud33bAnltpvfF9gZWJaPwp8U&skey=64760cc364a151ce&v=v11#AnonymousPro",
						"ttf": "http://fonts.gstatic.com/s/anonymouspro/v11/WDf5lZYgdmmKhO8E1AQud_PUlNJBs1LjT_hi6_KOI-I.ttf",
						"woff": "http://fonts.gstatic.com/s/anonymouspro/v11/WDf5lZYgdmmKhO8E1AQudy_O50XgJwSsgBhwZ9pjuTs.woff",
						"woff2": "http://fonts.gstatic.com/s/anonymouspro/v11/WDf5lZYgdmmKhO8E1AQud8GfYvzQ_DwqEC2arHsRzXk.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Antic": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Antic Regular\'",
						"\'Antic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/antic/v9/jrYPXvXYC1H4Vn_CQx7BJQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=auEONVTS9YXogC-LoZ073Q&skey=65ef8eb2e4187b6c&v=v9#Antic",
						"ttf": "http://fonts.gstatic.com/s/antic/v9/oPxV1dkj-zBXVn8gGPEP7w.ttf",
						"woff": "http://fonts.gstatic.com/s/antic/v9/2GNslY5EMAZwbbytmM9wFw.woff",
						"woff2": "http://fonts.gstatic.com/s/antic/v9/NHsS2_8AsBoNMVvtCA3aYA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Antic Didone": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Antic Didone Regular\'",
						"\'AnticDidone-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anticdidone/v6/r3nJcTDuOluOL6LGDV1vR3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r3nJcTDuOluOL6LGDV1vR1lIn5tFQcqMuf-jhyJP0ps&skey=619450f385a83a47&v=v6#AnticDidone",
						"ttf": "http://fonts.gstatic.com/s/anticdidone/v6/r3nJcTDuOluOL6LGDV1vR4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/anticdidone/v6/r3nJcTDuOluOL6LGDV1vR3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/anticdidone/v6/r3nJcTDuOluOL6LGDV1vR-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Antic Slab": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Antic Slab Regular\'",
						"\'AnticSlab-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anticslab/v6/8c9q46CAcsp9TiRX9KLgZFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8c9q46CAcsp9TiRX9KLgZKWUboTb-jS2tyCOQMtm97g&skey=2a7d5f3ad329463a&v=v6#AnticSlab",
						"ttf": "http://fonts.gstatic.com/s/anticslab/v6/8c9q46CAcsp9TiRX9KLgZC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/anticslab/v6/8c9q46CAcsp9TiRX9KLgZBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/anticslab/v6/8c9q46CAcsp9TiRX9KLgZPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Anton": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Anton Regular\'",
						"\'Anton-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/anton/v9/J56qdu2k8bTBzqj6o9e_cQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XMgIKp1BZj6JIXOPBGyt0g&skey=3e16a04254d4c9b3&v=v9#Anton",
						"ttf": "http://fonts.gstatic.com/s/anton/v9/5t8vP9Hx2udzw372glmOxA.ttf",
						"woff": "http://fonts.gstatic.com/s/anton/v9/tilmJBBU81h1G7ZsdY3Hmw.woff",
						"woff2": "http://fonts.gstatic.com/s/anton/v9/o-91-t7-bPc7W26HmS2N4Q.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Arapey": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Arapey Italic\'",
						"\'Arapey-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arapey/v6/vCF74OWelTm9xCi8kaFoefesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Fv1W7h7pmlJd2Bqn_jaR7PesZW2xOQ-xsNqO47m55DA&skey=681ef1f751ddde7&v=v6#Arapey",
						"ttf": "http://fonts.gstatic.com/s/arapey/v6/atOvJ76eT_9tVfcNjjnfrPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/arapey/v6/YQbRo6SDRtnzyJToW4DvyvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/arapey/v6/2fD9gIinOROmREwVfSHWKvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Arapey Regular\'",
						"\'Arapey-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arapey/v6/Y20fvhdRyG7gH-UdrhMuLQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XA7xbWov8nZdQTUSr08nug&skey=72771e7dd1745eb0&v=v6#Arapey",
						"ttf": "http://fonts.gstatic.com/s/arapey/v6/70NHEhnB-ZlzsDpQLtboKA.ttf",
						"woff": "http://fonts.gstatic.com/s/arapey/v6/hTZBMDBEmuM7E6AJpWkyGA.woff",
						"woff2": "http://fonts.gstatic.com/s/arapey/v6/UxBNFr2ZgBqbuTISOIrpmw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Arbutus": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Arbutus Regular\'",
						"\'Arbutus-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arbutus/v7/lbULOWzW6M8RCtlwjdKpog.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CfReKqfOtjFESfIgm5Nl8g&skey=d539f84867a5c63d&v=v7#Arbutus",
						"ttf": "http://fonts.gstatic.com/s/arbutus/v7/ePnQiV2KRI3kSCEP38mueA.ttf",
						"woff": "http://fonts.gstatic.com/s/arbutus/v7/ZIN1_iT2tfyR9znPvk0NwA.woff",
						"woff2": "http://fonts.gstatic.com/s/arbutus/v7/Es-r6R-ox_ENfIn2MQMcrQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Arbutus Slab": {
		"category": "serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Arbutus Slab Regular\'",
						"\'ArbutusSlab-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arbutusslab/v6/6k3Yp6iS9l4jRIpynA8qM3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6k3Yp6iS9l4jRIpynA8qM1lIn5tFQcqMuf-jhyJP0ps&skey=4b2cc8691b01771f&v=v6#ArbutusSlab",
						"ttf": "http://fonts.gstatic.com/s/arbutusslab/v6/6k3Yp6iS9l4jRIpynA8qM4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/arbutusslab/v6/6k3Yp6iS9l4jRIpynA8qM3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/arbutusslab/v6/6k3Yp6iS9l4jRIpynA8qM-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Architects Daughter": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Architects Daughter Regular\'",
						"\'ArchitectsDaughter-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/architectsdaughter/v8/RXTgOOQ9AAtaVOHxx0IUBAa3ceFz9lRYw95MoJAI43o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RXTgOOQ9AAtaVOHxx0IUBJ3EXhB8GVxcFukvVU0W_9E&skey=d34ee9a1a308e98b&v=v8#ArchitectsDaughter",
						"ttf": "http://fonts.gstatic.com/s/architectsdaughter/v8/RXTgOOQ9AAtaVOHxx0IUBOlC2pU_uJZcAXPUd4HCQp8.ttf",
						"woff": "http://fonts.gstatic.com/s/architectsdaughter/v8/RXTgOOQ9AAtaVOHxx0IUBOkI_DLF4EgbZt3mhU8gQFo.woff",
						"woff2": "http://fonts.gstatic.com/s/architectsdaughter/v8/RXTgOOQ9AAtaVOHxx0IUBM3t7GjCYufj5TXV5VnA2p8.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Archivo": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Archivo Italic\'",
						"\'Archivo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/lNfN2VnmsoFOyuA28PGzv_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lNfN2VnmsoFOyuA28PGzv5bd9NUM7myrQQz30yPaGQ4&skey=5baaa5f10d75e728&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/lNfN2VnmsoFOyuA28PGzv6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/lNfN2VnmsoFOyuA28PGzvz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/lNfN2VnmsoFOyuA28PGzv1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Archivo Medium Italic\'",
						"\'Archivo-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/MKuleTj-xvH_kzDLSfxAn3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MKuleTj-xvH_kzDLSfxAn1lIn5tFQcqMuf-jhyJP0ps&skey=5a268ba5363d1828&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/MKuleTj-xvH_kzDLSfxAn4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/MKuleTj-xvH_kzDLSfxAn3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/MKuleTj-xvH_kzDLSfxAn-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Archivo SemiBold Italic\'",
						"\'Archivo-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/yabYJWzTLFXwCTAuo02FTHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yabYJWzTLFXwCTAuo02FTFlIn5tFQcqMuf-jhyJP0ps&skey=19155be740f1ac51&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/yabYJWzTLFXwCTAuo02FTInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/yabYJWzTLFXwCTAuo02FTHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/yabYJWzTLFXwCTAuo02FTOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Archivo Bold Italic\'",
						"\'Archivo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/KPG24G28nybJri09faZ5f3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KPG24G28nybJri09faZ5f1lIn5tFQcqMuf-jhyJP0ps&skey=ef8746c0d377fd31&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/KPG24G28nybJri09faZ5f4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/KPG24G28nybJri09faZ5f3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/KPG24G28nybJri09faZ5f-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Archivo Regular\'",
						"\'Archivo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/EjuAQsT8CI5eN5NPsVO_yw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DDCh_P2WvPS9UEOPvultzg&skey=8131191f4580dfcb&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/niPExGfJuq69JozJ6FM77A.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/A8Xp8WsCRzX0Y5modSFi-g.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/i_GYShAf6lqmIBVzERdPZA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Archivo Medium\'",
						"\'Archivo-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/EQ3-KgeHKZW2vIQ-o6r3ilQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EQ3-KgeHKZW2vIQ-o6r3iqWUboTb-jS2tyCOQMtm97g&skey=55b166f29c61ce81&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/EQ3-KgeHKZW2vIQ-o6r3ii3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/EQ3-KgeHKZW2vIQ-o6r3ihsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/EQ3-KgeHKZW2vIQ-o6r3ivk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Archivo SemiBold\'",
						"\'Archivo-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/B620tdL36tfYNoAC4PY-llQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=B620tdL36tfYNoAC4PY-lqWUboTb-jS2tyCOQMtm97g&skey=f4ab601a8d6fbe6&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/B620tdL36tfYNoAC4PY-li3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/B620tdL36tfYNoAC4PY-lhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/B620tdL36tfYNoAC4PY-lvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Archivo Bold\'",
						"\'Archivo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivo/v3/BxPPCh4VtEXoqCgFOjwlRVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BxPPCh4VtEXoqCgFOjwlRaWUboTb-jS2tyCOQMtm97g&skey=fe22dd2b5a33cbb7&v=v3#Archivo",
						"ttf": "http://fonts.gstatic.com/s/archivo/v3/BxPPCh4VtEXoqCgFOjwlRS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/archivo/v3/BxPPCh4VtEXoqCgFOjwlRRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/archivo/v3/BxPPCh4VtEXoqCgFOjwlRfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Archivo Black": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Archivo Black Regular\'",
						"\'ArchivoBlack-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivoblack/v7/WoAoVT7K3k7hHfxKbvB6Bwav5M--_viT8jFKeYsHkCg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WoAoVT7K3k7hHfxKbvB6Byill4SiTBdQFL-JZbJTIJ0&skey=f0fab067ca5e2347&v=v7#ArchivoBlack",
						"ttf": "http://fonts.gstatic.com/s/archivoblack/v7/WoAoVT7K3k7hHfxKbvB6B0FBUwxZoPEX5aisj8qBSHE.ttf",
						"woff": "http://fonts.gstatic.com/s/archivoblack/v7/WoAoVT7K3k7hHfxKbvB6B0BTuPGxyeV-VBVV8KqqzrI.woff",
						"woff2": "http://fonts.gstatic.com/s/archivoblack/v7/WoAoVT7K3k7hHfxKbvB6B6GwZwAVuVwqynDPq0VH9Ho.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Archivo Narrow": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Archivo Narrow Italic\'",
						"\'ArchivoNarrow-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/vqsrtPCpTU3tJlKfuXP5zS8SVR2zLCpe0j5AErWNfEA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vqsrtPCpTU3tJlKfuXP5zfniXxCQ7rSjurIrySIOR1g&skey=ec1fde26e7c4f98c&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/vqsrtPCpTU3tJlKfuXP5zcnwn6e04auzqzWOIA_hv3E.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/vqsrtPCpTU3tJlKfuXP5zQ48yxcqlEd_9yiE-NHSCVQ.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/vqsrtPCpTU3tJlKfuXP5zeEHrUcvG35DlvKNjpX7jU4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Archivo Narrow Medium Italic\'",
						"\'ArchivoNarrow-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSagRZuNez2j27nFzsWMHmHM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wG6O733y5zHl4EKCOh8rScDwT-Tj2wZcbiucNdOZozY&skey=9262d601b46d99ee&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSQth8yTObpb7lj0zRsiAPyA.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSbsnXRkmjtbipT5eQEHAsMk.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSa847JQPGKml1HApt77lMTQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Archivo Narrow SemiBold Italic\'",
						"\'ArchivoNarrow-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSQsfdIEYhjPmwjJhZmM02Xk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wG6O733y5zHl4EKCOh8rSTS_UtwpyteDZMUOrOpTw90&skey=781263cf12939840&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSbsh2KuF1fqbZKZihtYX-sQ.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSat2_uWOrt8c59vDf0BjSts.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSS9r6YhzjQN6S1euVVZJlA0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Archivo Narrow Bold Italic\'",
						"\'ArchivoNarrow-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSXkD2mkXfCwYNZza0sFYEUs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wG6O733y5zHl4EKCOh8rSXOxM3Z0sV9wikYoCk6KaJo&skey=6e161893db35d59a&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSQKRIWFa_QDmOmnTt8LSaDQ.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSXbcqP1x1ie9hNBLFkS7zO0.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/wG6O733y5zHl4EKCOh8rSflEgKdwIoor_PG0pLo4YVU.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Archivo Narrow Regular\'",
						"\'ArchivoNarrow-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/DsLzC9scoPnrGiwYYMQXpj9sG6gyxihQGrqfBiBoCNc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DsLzC9scoPnrGiwYYMQXpo9qashOVerhvngxLEi9cx0&skey=345333fd7197b162&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/DsLzC9scoPnrGiwYYMQXpkpeNX8RPf6i6WQfJWyCWEs.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/DsLzC9scoPnrGiwYYMQXphdbPw3QSf9R-kE0EsQUn2A.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/DsLzC9scoPnrGiwYYMQXpkU-p1xzoRgkupcXIqgYFBc.woff2"
					}
				},
				"500": {
					"local": [
						"\'Archivo Narrow Medium\'",
						"\'ArchivoNarrow-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsCR7saYK0yXiJdcaRP31QBs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M__Wu4PAmHf4YZvQM8tWsOvSe1cFbsWfDJJRPrmxt64&skey=1d56e30506958c57&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsOLEA9hKR5QKzLnug_yMWHk.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsBuGfOPtaJ8KkJR0G2ySWEM.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsPhhvqDyemVUCbKWSBWdvAI.woff2"
					}
				},
				"600": {
					"local": [
						"\'Archivo Narrow SemiBold\'",
						"\'ArchivoNarrow-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsEGt7hnXTzyGuR4r6LHs9nw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M__Wu4PAmHf4YZvQM8tWsGWBEGjRmK8-bNo1DNNVHcU&skey=eefce3389ee8b5e5&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsNmgbAgzzXVEjfl6V7_ja00.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsJ8kjD_Vkuz3NIsGBICk14Q.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsGPneC5ocyk8Ocy49uVtLCA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Archivo Narrow Bold\'",
						"\'ArchivoNarrow-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsGT4ZFB4cX9NxOgt4NwF8dg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M__Wu4PAmHf4YZvQM8tWsBvdA8BQHjnCxNq-aqth-mQ&skey=3f6673ee0dfa8685&v=v8#ArchivoNarrow",
						"ttf": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsDnFfol0SnfBMmbnmUK0fZM.ttf",
						"woff": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsCylde52zikAzebNtJS89aM.woff",
						"woff2": "http://fonts.gstatic.com/s/archivonarrow/v8/M__Wu4PAmHf4YZvQM8tWsBKUK2vxztsQZZBkxIuj92o.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Aref Ruqaa": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aref Ruqaa Regular\'",
						"\'ArefRuqaa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arefruqaa/v4/OL82tuUS1uu6MwHjw_sLuVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OL82tuUS1uu6MwHjw_sLuaWUboTb-jS2tyCOQMtm97g&skey=42031ebbc54bfc32&v=v4#ArefRuqaa",
						"ttf": "http://fonts.gstatic.com/s/arefruqaa/v4/OL82tuUS1uu6MwHjw_sLuS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/arefruqaa/v4/OL82tuUS1uu6MwHjw_sLuRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/arefruqaa/v4/OL82tuUS1uu6MwHjw_sLufk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Aref Ruqaa Bold\'",
						"\'ArefRuqaa-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arefruqaa/v4/RT-Q5DVI9arM6ZKux-UmTGzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RT-Q5DVI9arM6ZKux-UmTD9QLNJZUvW8xv4RpDkyVDQ&skey=7bd179854eb23c4&v=v4#ArefRuqaa",
						"ttf": "http://fonts.gstatic.com/s/arefruqaa/v4/RT-Q5DVI9arM6ZKux-UmTPEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/arefruqaa/v4/RT-Q5DVI9arM6ZKux-UmTAFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/arefruqaa/v4/RT-Q5DVI9arM6ZKux-UmTIWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Arima Madurai": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"tamil",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Arima Madurai Thin\'",
						"\'ArimaMadurai-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/Q0tjl46beRRcUe3RlWWNrZT9PPV-4Y-SAy1cEikh3ng.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Q0tjl46beRRcUe3RlWWNraaD7ohSSghMW0vq6prQvs8&skey=57396a7df9c3908f&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/Q0tjl46beRRcUe3RlWWNrQxOrPRjWWEiNUR_6u_M3gc.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/Q0tjl46beRRcUe3RlWWNrY55fVJY4ESdHWLhOPK06Ss.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/Q0tjl46beRRcUe3RlWWNrY_cJWwiM8-y3kaJoY6Osr0.woff2"
					}
				},
				"200": {
					"local": [
						"\'Arima Madurai ExtraLight\'",
						"\'ArimaMadurai-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4o-5RQnMwpK-n0i-aoYLOgA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4uTeRtf92wU3LmycxQOdl2o&skey=95efad7c6d050c6e&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4hwQ5u7gBek1dlDxy8QNimY.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4gPhP1Wt4JA2FDzPVY7QHcQ.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4lYPQCeMY_OwzQauiV3XNbM.woff2"
					}
				},
				"300": {
					"local": [
						"\'Arima Madurai Light\'",
						"\'ArimaMadurai-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4n7FnRhObSQVCVUoSGiza-A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4lTseKZqar24O-knw2J63k4&skey=818df1b22b4fd8f8&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4pciFM2dQqR1ip9I-Bp8E7Q.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4qTRWX0g_-XoZCgdgBAVi88.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4qSQyxDdyh5J6kYir5a9n-w.woff2"
					}
				},
				"400": {
					"local": [
						"\'Arima Madurai\'",
						"\'ArimaMadurai-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/8fNfThKRw_pr7MwgNdcHiRjDPkejxwcpW9OWpajGJHw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8fNfThKRw_pr7MwgNdcHiYQpKbf4CYfIi0uw1R3YMwI&skey=ff016238820f95ab&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/8fNfThKRw_pr7MwgNdcHiUPlcwLEEFMaFVaeSfNKhMM.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/8fNfThKRw_pr7MwgNdcHiT4XNJenyR3sjrxR52gViYU.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/8fNfThKRw_pr7MwgNdcHiRBCek7ZypUE9OFPg18vTTM.woff2"
					}
				},
				"500": {
					"local": [
						"\'Arima Madurai Medium\'",
						"\'ArimaMadurai-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4uZlad--gq09YzS-6t5G4AM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4k7BHkil331PUTa7WSnH9HM&skey=7856d3737673f45d&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4gpRBgtkoBXOZ68qjHPpU4g.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4r2P_Uux-iHs2EwONVF7tE0.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4jeO7UKWTXK_MKhPYQqFnq0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arima Madurai Bold\'",
						"\'ArimaMadurai-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4nkG2xuzrZX6jefzCp6lpMs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4mWe_ISb6-g34WzcfIFiYzc&skey=eebd7aa0e29c4843&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4rA7MWNoqbMutNN7VW-98RM.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4sToxEMdItuzMyiS1f6iduE.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4la9Mi0HhaXJ2SLZ7weUeE8.woff2"
					}
				},
				"800": {
					"local": [
						"\'Arima Madurai ExtraBold\'",
						"\'ArimaMadurai-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4jrLKxBB3vJeXrZAgxo9QUI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4sXbrbzlzPzM9BS_1NP-wgM&skey=cea65f0bbc3a4136&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4uIAF_gw_l0sth9q2Q_vblE.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4ncfkcZwEGXO8Yg6pcZGJLE.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4nPUQl5hyrV7lE9fHUTYqEA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Arima Madurai Black\'",
						"\'ArimaMadurai-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4m8IoJHLlpuD1SL87898XgQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsCGNPwBfkMk17-w_DTJ4visizeWgWVnkp7UE5wiTx0&skey=7037dcde24f8c607&v=v3#ArimaMadurai",
						"ttf": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4jdDxvHJYd4gQGxXNudz3Ck.ttf",
						"woff": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4vjG8Fanh2UGEqANUz1R_RU.woff",
						"woff2": "http://fonts.gstatic.com/s/arimamadurai/v3/EsCGNPwBfkMk17-w_DTJ4iPaleyCH5zYojEeyqyTW1Y.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Arimo": {
		"category": "sans-serif",
		"lastModified": "2017-10-11",
		"subsets": [
			"cyrillic-ext",
			"hebrew",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Arimo Italic\'",
						"\'Arimo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimo/v11/thDv13z50gThh9VG9EA2iA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H0Sp6NAnAlMMwn1KAZAFYA&skey=cf144108a78a4937&v=v11#Arimo",
						"ttf": "http://fonts.gstatic.com/s/arimo/v11/FXJSZr9eE-OC5XY0iv8EtA.ttf",
						"woff": "http://fonts.gstatic.com/s/arimo/v11/8ezAIdgyp-Cm5_X7mWzP_g.woff",
						"woff2": "http://fonts.gstatic.com/s/arimo/v11/GYkAnzJvKnl5kOgLY6RO-w.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arimo Bold Italic\'",
						"\'Arimo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimo/v11/_K7sg-ijHdmkwPzV9FiqaFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_K7sg-ijHdmkwPzV9FiqaKWUboTb-jS2tyCOQMtm97g&skey=27fad731a46db7c8&v=v11#Arimo",
						"ttf": "http://fonts.gstatic.com/s/arimo/v11/_K7sg-ijHdmkwPzV9FiqaC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/arimo/v11/_K7sg-ijHdmkwPzV9FiqaBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/arimo/v11/_K7sg-ijHdmkwPzV9FiqaPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Arimo Regular\'",
						"\'Arimo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimo/v11/kJziZB9mN1Zz67hE4Xj10w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MAC8gSEKM0uvY1MLKI52lQ&skey=6457c0ab3b693f57&v=v11#Arimo",
						"ttf": "http://fonts.gstatic.com/s/arimo/v11/BkZwJXYnumPMepfEA344yQ.ttf",
						"woff": "http://fonts.gstatic.com/s/arimo/v11/wZLYhRRxZWGToTRP78bqJQ.woff",
						"woff2": "http://fonts.gstatic.com/s/arimo/v11/HNu4Nzh6q8Es60EMNZhs9w.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arimo Bold\'",
						"\'Arimo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arimo/v11/5Pu1hU3bOP0NyOZx3DCeVvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QC5QJrt6hqa8Ces_VomcO_esZW2xOQ-xsNqO47m55DA&skey=103f7caa82911f9&v=v11#Arimo",
						"ttf": "http://fonts.gstatic.com/s/arimo/v11/eFfAHNfFT0YtF77QmRKRj_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/arimo/v11/UnXpojilM3XslYxUnWuVe_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/arimo/v11/27rE5lMk9EHpLbxiIuGd0PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Arizonia": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Arizonia Regular\'",
						"\'Arizonia-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arizonia/v8/u7E0xBiSyufT4DCm3LWEtfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=chhbLkGewNLYmqFfOIjtafesZW2xOQ-xsNqO47m55DA&skey=940a156b384ad39&v=v8#Arizonia",
						"ttf": "http://fonts.gstatic.com/s/arizonia/v8/jk7b-Al_6RLn0YQzwF_1-fesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/arizonia/v8/8Usm7f8XTsZinW2e-ZMd5fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/arizonia/v8/PwrsyFTYH2Wmsvpn0dx4s_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Armata": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Armata Regular\'",
						"\'Armata-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/armata/v8/mXn3RSflvpp3Ikk20GkqJg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Wv3lUYn0mdwXVCPR4Md6bg&skey=3d0d3210c2915b4e&v=v8#Armata",
						"ttf": "http://fonts.gstatic.com/s/armata/v8/B4GpPiGyQcH-RTyb1Av4YA.ttf",
						"woff": "http://fonts.gstatic.com/s/armata/v8/FG9R9aX-RIX_AvJI8USOWg.woff",
						"woff2": "http://fonts.gstatic.com/s/armata/v8/DZkzoxG_919ddkf0Ia7hgQ.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Arsenal": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Arsenal Italic\'",
						"\'Arsenal-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arsenal/v2/SyXrdER51c-tA-DaBD7hCvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SyXrdER51c-tA-DaBD7hCpbd9NUM7myrQQz30yPaGQ4&skey=41b203aa8f6cac2&v=v2#Arsenal",
						"ttf": "http://fonts.gstatic.com/s/arsenal/v2/SyXrdER51c-tA-DaBD7hCqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/arsenal/v2/SyXrdER51c-tA-DaBD7hCj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/arsenal/v2/SyXrdER51c-tA-DaBD7hCltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arsenal Bold Italic\'",
						"\'Arsenal-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arsenal/v2/AnUIg26c0nuMZMpNWtsDF3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AnUIg26c0nuMZMpNWtsDF1lIn5tFQcqMuf-jhyJP0ps&skey=441c0d9389e70183&v=v2#Arsenal",
						"ttf": "http://fonts.gstatic.com/s/arsenal/v2/AnUIg26c0nuMZMpNWtsDF4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/arsenal/v2/AnUIg26c0nuMZMpNWtsDF3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/arsenal/v2/AnUIg26c0nuMZMpNWtsDF-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Arsenal Regular\'",
						"\'Arsenal-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arsenal/v2/RKIki6O-j2qPFG7SjU7jow.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oY9VFRmMz2YdTtZymf7AvQ&skey=af599ca341f4a7aa&v=v2#Arsenal",
						"ttf": "http://fonts.gstatic.com/s/arsenal/v2/GvA15TjFJjIZ9c33KSPTzQ.ttf",
						"woff": "http://fonts.gstatic.com/s/arsenal/v2/rPpk5HlqZn4Sk4kChKZ9mg.woff",
						"woff2": "http://fonts.gstatic.com/s/arsenal/v2/ERd8ystuACCAfABkUtpxuw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arsenal Bold\'",
						"\'Arsenal-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arsenal/v2/5vJ32Pe8BCA1NkX59B6Ks1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5vJ32Pe8BCA1NkX59B6Ks6WUboTb-jS2tyCOQMtm97g&skey=69954940f6d1b956&v=v2#Arsenal",
						"ttf": "http://fonts.gstatic.com/s/arsenal/v2/5vJ32Pe8BCA1NkX59B6Ksy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/arsenal/v2/5vJ32Pe8BCA1NkX59B6KsxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/arsenal/v2/5vJ32Pe8BCA1NkX59B6Ks_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Artifika": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Artifika Regular\'",
						"\'Artifika-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/artifika/v8/RP5Ct0gd7C4AOqw5-cEvqPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ozwezsReIgWy6igTj6niPesZW2xOQ-xsNqO47m55DA&skey=f89d96c36cb7c7be&v=v8#Artifika",
						"ttf": "http://fonts.gstatic.com/s/artifika/v8/z0sjSaXjDxxgrMTOLI1lSfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/artifika/v8/r0NXNnpds-Akyno8nTG0zfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/artifika/v8/KUmbsEUmwZBks8S_dFROo_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Arvo": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Arvo Italic\'",
						"\'Arvo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arvo/v10/bhhsw7SLyOcdOtDZH6IxQg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7m9CanwF1V0GD7L1HfQTuQ&skey=2dd72678c3f42e85&v=v10#Arvo",
						"ttf": "http://fonts.gstatic.com/s/arvo/v10/vQXokwpmxuSASZo9hjfj5g.ttf",
						"woff": "http://fonts.gstatic.com/s/arvo/v10/7solcx-ZQo6LBqJvZuxkkg.woff",
						"woff2": "http://fonts.gstatic.com/s/arvo/v10/Yl0tppep0-4db_jv2GpmdA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arvo Bold Italic\'",
						"\'Arvo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arvo/v10/Vj6JEk1YZr8j8R8H2j0b-vY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vj6JEk1YZr8j8R8H2j0b-pbd9NUM7myrQQz30yPaGQ4&skey=a6e16a2b31a2dc20&v=v10#Arvo",
						"ttf": "http://fonts.gstatic.com/s/arvo/v10/Vj6JEk1YZr8j8R8H2j0b-qCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/arvo/v10/Vj6JEk1YZr8j8R8H2j0b-j8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/arvo/v10/Vj6JEk1YZr8j8R8H2j0b-ltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Arvo\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arvo/v10/DOHAK8DimZJeSQQDpH-4yw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mfIKVv9ZziIYgQNVexudYw&skey=40c49b2c9e3d24ba&v=v10#Arvo",
						"ttf": "http://fonts.gstatic.com/s/arvo/v10/MViwy4K6e56oHcyeMzjbCQ.ttf",
						"woff": "http://fonts.gstatic.com/s/arvo/v10/WJ6D195CfbTRlIs49IbkFw.woff",
						"woff2": "http://fonts.gstatic.com/s/arvo/v10/J0GYVYTizO1mjpT3aOcSbQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arvo Bold\'",
						"\'Arvo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arvo/v10/yhrAT4vEkZxEF_O3V7wpSQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rKQ6EUxZvwI4WTC3OJsXGA&skey=32d0e4970a9f038b&v=v10#Arvo",
						"ttf": "http://fonts.gstatic.com/s/arvo/v10/F-uvpIj1hF17IDyvQvI50Q.ttf",
						"woff": "http://fonts.gstatic.com/s/arvo/v10/0Aa8aBJcGN1n1zDNhqNrnQ.woff",
						"woff2": "http://fonts.gstatic.com/s/arvo/v10/Ya11CJGBCnKoJHvb8B2EOw.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Arya": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Arya Regular\'",
						"\'Arya-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arya/v3/Ij-k8i95iVoiTKS86jTt3w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MGrejiwiq-7VCEvAsUXlyw&skey=1738d136b939f402&v=v3#Arya",
						"ttf": "http://fonts.gstatic.com/s/arya/v3/6O-z5Yh116br4RQpbC3V7Q.ttf",
						"woff": "http://fonts.gstatic.com/s/arya/v3/si76METEJxgDKIw3d8hYuQ.woff",
						"woff2": "http://fonts.gstatic.com/s/arya/v3/DebnMffpnI27Fvj6YT4RVg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Arya Bold\'",
						"\'Arya-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/arya/v3/jkr7APeI_aVvYp9WNnZfUA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hmff0egVhhoCSykRuokLpw&skey=80c71c480b2039a7&v=v3#Arya",
						"ttf": "http://fonts.gstatic.com/s/arya/v3/cWuoZn_-7yqsJUG3Wg1sUg.ttf",
						"woff": "http://fonts.gstatic.com/s/arya/v3/EdsxwtkTaIIxlC2mTUZy7w.woff",
						"woff2": "http://fonts.gstatic.com/s/arya/v3/ZqQkwG65xLqEs1IW2LdgYQ.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Asap": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Asap Italic\'",
						"\'Asap-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/GrwpWydk-X9BTbxj1iL9jg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CCJDIgT_caxmdwpYbudQfQ&skey=ed90f3b9cc892982&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/8YIp-EIJXA6NJdTPxy9qiQ.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/MdJnJ_Rxy6GcPmasGZsTfQ.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/fpSkRkcsVvo2_AnP2Zt5Yg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Asap Medium Italic\'",
						"\'Asap-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/LCCJ8c2RzIweiQY73wb28PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LCCJ8c2RzIweiQY73wb28Jbd9NUM7myrQQz30yPaGQ4&skey=8357f0a58b20dc07&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/LCCJ8c2RzIweiQY73wb28KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/LCCJ8c2RzIweiQY73wb28D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/LCCJ8c2RzIweiQY73wb28FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Asap SemiBold Italic\'",
						"\'Asap-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/MuMC94BBH79Mcr6JWhU9VPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MuMC94BBH79Mcr6JWhU9VJbd9NUM7myrQQz30yPaGQ4&skey=3f79d97a181f699d&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/MuMC94BBH79Mcr6JWhU9VKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/MuMC94BBH79Mcr6JWhU9VD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/MuMC94BBH79Mcr6JWhU9VFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Asap Bold Italic\'",
						"\'Asap-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/_sVKdO-TLWvaH-ptGimJBfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_sVKdO-TLWvaH-ptGimJBZbd9NUM7myrQQz30yPaGQ4&skey=45dbf840e00782fc&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/_sVKdO-TLWvaH-ptGimJBaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/_sVKdO-TLWvaH-ptGimJBT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/_sVKdO-TLWvaH-ptGimJBVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Asap Regular\'",
						"\'Asap-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/7U2WVQLzYo7fqCE9hsW0CA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l1PhYN9wwRtKpadC331j4Q&skey=1e05f6b66acebc28&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/-KZsao_xwBpcExaHoPH8_w.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/SgBaq0dzhSGNMfqm2JX5ng.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/oiVlPAjaPL0EznW3E5Z2DQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Asap Medium\'",
						"\'Asap-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/PsJ2SN2R1tc9du_RJFM2rA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jlzCtmumF9dHUJyrehB7BQ&skey=81073966f7643c90&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/5CGNNia4z04rXH-iABCwKg.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/5LPMv47DnkTSMsTmLffcAg.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/IQ_J-iW9w6_hWQNdfyeVJQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Asap SemiBold\'",
						"\'Asap-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/17_hscO6v4G2ihJaDWWw-Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZNLue_iMLs8O3s-Fg1WijA&skey=9ec9c99a6042f0d1&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/43ww_a20sHg2jrC24mEA9Q.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/B9FX6SpIi2IMx6v5ZsHSzg.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/W3fu5nIoa9HKKY8YYpCXbQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Asap Bold\'",
						"\'Asap-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asap/v7/KzpxSwmYdiqHjA_2Peg1Xw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CJrjw4xoDEQHEz0xOpNqmA&skey=74c571863af0d085&v=v7#Asap",
						"ttf": "http://fonts.gstatic.com/s/asap/v7/5DVGWnz9Skaq1amwwwGZEw.ttf",
						"woff": "http://fonts.gstatic.com/s/asap/v7/yVILXKVgPzaz72DegpV7Bg.woff",
						"woff2": "http://fonts.gstatic.com/s/asap/v7/YUlqaYZPVSsAAN2ZtG3iyA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Asap Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Asap Condensed Italic\'",
						"\'AsapCondensed-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/qnSL07X2cz9966iZSWZCBTUmL-49gGopnqBrXTvZ7dg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qnSL07X2cz9966iZSWZCBa9zezu6DrSzzSjpuBdBAiE&skey=2d37a410bdb336c1&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/qnSL07X2cz9966iZSWZCBWo9-ZX4YMqkHAbk68E1EUA.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/qnSL07X2cz9966iZSWZCBf6REmopvCeUL-pWGI7uC1U.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/qnSL07X2cz9966iZSWZCBXvxcxm8KIu1NsutkQJAPv4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Asap Condensed Medium Italic\'",
						"\'AsapCondensed-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUd0fw7lOs_P1f76UUSr-McA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9jDg2d4w2asxgWRh6ddxUaZGq1aPvjNLZfqEXR7dJLc&skey=edaa668f7858b5a&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUUFmapCttfxcfL78eA3e_zE.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUXN3enu4bfDYyz9FjGnVvvA.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUQWYkWI0QsVisMijC4tWcEI.woff2"
					}
				},
				"600": {
					"local": [
						"\'Asap Condensed SemiBold Italic\'",
						"\'AsapCondensed-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUZIOhGowKIR_O2NyEpdjWcU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9jDg2d4w2asxgWRh6ddxUUtFUasUNVfl7ehRvx8Rfrc&skey=f05d06452c96cb30&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUdPzafAFRcxOsAQJ9Mspd1k.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUcqyt-4XNtAvQhBJ03Kmkg8.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUbysG1U5_urmuenaM1txE7g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Asap Condensed Bold Italic\'",
						"\'AsapCondensed-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUTlh-7U132Ik9u1uTkzH5dE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9jDg2d4w2asxgWRh6ddxUdpZ7HoiAzbIGGPhs_IJBv0&skey=ecbbaedcef04de85&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUWPgn932PISw3xSg5nyJ_hw.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUR7tOcm-Pm8EMsjxXgd7ijQ.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/9jDg2d4w2asxgWRh6ddxUbNT4wfNA6X9XGo1x-7_nyI.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Asap Condensed Regular\'",
						"\'AsapCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/WnB1QP0n-KM9-GXLGChcYZq4Fp4-9ncj-hM6remEfI0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WnB1QP0n-KM9-GXLGChcYSGKFtiHGZ-syUIp1USKs0k&skey=3d36b4c4b66e38bb&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/WnB1QP0n-KM9-GXLGChcYYN2kJ1YtV290c6SflXXaeM.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/WnB1QP0n-KM9-GXLGChcYbCtw68oVo6xx8uxVjOYO2I.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/WnB1QP0n-KM9-GXLGChcYT0fyHAeQbnQTds-sNxfQyY.woff2"
					}
				},
				"500": {
					"local": [
						"\'Asap Condensed Medium\'",
						"\'AsapCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjHeFwge5kVaD_xkDiC7-e_Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TyBiCbCbffkYs45BrMexjNJdG4YOUSBgShEwJWp6Jz8&skey=ed1c2c5328bc22e&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjPtnjRZRqejVuHjRN4fKgFQ.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjCC-UyjiQyO_O0En_e10hQ0.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjMQ1-BIqgA3z-9ZCiAyo7cU.woff2"
					}
				},
				"600": {
					"local": [
						"\'Asap Condensed SemiBold\'",
						"\'AsapCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjNP-szkBohKF0SEmyhnlz6M.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TyBiCbCbffkYs45BrMexjMBifUG2xBqY41CM3TgikxU&skey=9706a0a39869c07b&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjPN0oW0fJVHhKJw1VGtkd10.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjLj2scv7-zb7urSSAl50_t0.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjCzwLjBzixYdU3chB0FqNhQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Asap Condensed Bold\'",
						"\'AsapCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjD15xFZrjKmkCN4dZh2kv9o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TyBiCbCbffkYs45BrMexjJVB8CCNuiqVO_-Whgnq9_s&skey=71e57623e2e66568&v=v2#AsapCondensed",
						"ttf": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjHEat47pqCK3iCMiuzAI_G8.ttf",
						"woff": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjGKgXndxNHDNFwWQvoQmBJo.woff",
						"woff2": "http://fonts.gstatic.com/s/asapcondensed/v2/TyBiCbCbffkYs45BrMexjN7U71yYcSybQTX0xJWx7kQ.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Asar": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Asar Regular\'",
						"\'Asar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asar/v4/Fk5kOPr_7GB82wPxQ_reig.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z0BPAu1W35K85SX1Dfofyg&skey=a29dbc6a54d5d953&v=v4#Asar",
						"ttf": "http://fonts.gstatic.com/s/asar/v4/fykYODT8pIpXUvIOHpwJ4g.ttf",
						"woff": "http://fonts.gstatic.com/s/asar/v4/yAYEslyDFC01WANeio4YqA.woff",
						"woff2": "http://fonts.gstatic.com/s/asar/v4/tSvkcRsK20mT1XkNDRgPfw.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Asset": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Asset Regular\'",
						"\'Asset-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asset/v8/y86qdcrGbCoKG7B1K-ecDw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CbIA9XgnRdDUV-GSJOFj-Q&skey=7cd3292c54a51ea0&v=v8#Asset",
						"ttf": "http://fonts.gstatic.com/s/asset/v8/h1rK36Q0eIQadG8NLDRuVQ.ttf",
						"woff": "http://fonts.gstatic.com/s/asset/v8/rlQUUz5yUCYvWCMjcvgo3A.woff",
						"woff2": "http://fonts.gstatic.com/s/asset/v8/qpj0JM0JWOg6Fb-1xdhTJA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Assistant": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"hebrew",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Assistant ExtraLight\'",
						"\'Assistant-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/xXstfiHQzjB9j5ZxYTBoZ3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xXstfiHQzjB9j5ZxYTBoZ1lIn5tFQcqMuf-jhyJP0ps&skey=dfefd67f2581d9e2&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/xXstfiHQzjB9j5ZxYTBoZ4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/xXstfiHQzjB9j5ZxYTBoZ3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/xXstfiHQzjB9j5ZxYTBoZ-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"300": {
					"local": [
						"\'Assistant Light\'",
						"\'Assistant-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/vPC3tCw3LOzCSeGCtVp5WnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vPC3tCw3LOzCSeGCtVp5WllIn5tFQcqMuf-jhyJP0ps&skey=4ce3b54f60163ab5&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/vPC3tCw3LOzCSeGCtVp5WonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/vPC3tCw3LOzCSeGCtVp5WnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/vPC3tCw3LOzCSeGCtVp5Wugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Assistant\'",
						"\'Assistant-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/Uc4viXlMMsk3-slnOukfHPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Uc4viXlMMsk3-slnOukfHJbd9NUM7myrQQz30yPaGQ4&skey=d0a91b9f68d720c8&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/Uc4viXlMMsk3-slnOukfHKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/Uc4viXlMMsk3-slnOukfHD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/Uc4viXlMMsk3-slnOukfHFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Assistant SemiBold\'",
						"\'Assistant-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/Y4UC5nQA69lWpfV0itoWLnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Y4UC5nQA69lWpfV0itoWLllIn5tFQcqMuf-jhyJP0ps&skey=b7a9095dd2feeac0&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/Y4UC5nQA69lWpfV0itoWLonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/Y4UC5nQA69lWpfV0itoWLnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/Y4UC5nQA69lWpfV0itoWLugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Assistant Bold\'",
						"\'Assistant-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/dZywGH4pMxP6OVyrppOJx3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dZywGH4pMxP6OVyrppOJx1lIn5tFQcqMuf-jhyJP0ps&skey=b4192a5faa2b691&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/dZywGH4pMxP6OVyrppOJx4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/dZywGH4pMxP6OVyrppOJx3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/dZywGH4pMxP6OVyrppOJx-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"800": {
					"local": [
						"\'Assistant ExtraBold\'",
						"\'Assistant-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/assistant/v2/-mTR0sX8a0RsadH4AMDT8HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-mTR0sX8a0RsadH4AMDT8FlIn5tFQcqMuf-jhyJP0ps&skey=7f1594a43bf6b558&v=v2#Assistant",
						"ttf": "http://fonts.gstatic.com/s/assistant/v2/-mTR0sX8a0RsadH4AMDT8InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/assistant/v2/-mTR0sX8a0RsadH4AMDT8HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/assistant/v2/-mTR0sX8a0RsadH4AMDT8Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Astloch": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Astloch Regular\'",
						"\'Astloch-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/astloch/v8/-yBHnPSE507NaUp9FWMfAA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=URt08xurqynnpQedAgTXAQ&skey=30fe264da3626cbd&v=v8#Astloch",
						"ttf": "http://fonts.gstatic.com/s/astloch/v8/4DQy6M2-Qccef2jRPPFLow.ttf",
						"woff": "http://fonts.gstatic.com/s/astloch/v8/Lip-aAC4yyZnegrgsi4iHA.woff",
						"woff2": "http://fonts.gstatic.com/s/astloch/v8/MZS6yKXraNNucOWHOsyIng.woff2"
					}
				},
				"700": {
					"local": [
						"\'Astloch Bold\'",
						"\'Astloch-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/astloch/v8/IjDNVaR3WOrQMh9cLq1mUlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IjDNVaR3WOrQMh9cLq1mUqWUboTb-jS2tyCOQMtm97g&skey=969de94cc0591ce8&v=v8#Astloch",
						"ttf": "http://fonts.gstatic.com/s/astloch/v8/IjDNVaR3WOrQMh9cLq1mUi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/astloch/v8/IjDNVaR3WOrQMh9cLq1mUhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/astloch/v8/IjDNVaR3WOrQMh9cLq1mUvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Asul": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Asul Regular\'",
						"\'Asul-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asul/v7/Y19UrEq8yFAbMLBkMslvug.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=knFEofXKdzHSGh0DQvKkEQ&skey=6f7d33b53db17df6&v=v7#Asul",
						"ttf": "http://fonts.gstatic.com/s/asul/v7/VAzkC2TIhQ2e4KQLDKf9Rw.ttf",
						"woff": "http://fonts.gstatic.com/s/asul/v7/nXGEE-SMYa-oGurFr0YHXw.woff",
						"woff2": "http://fonts.gstatic.com/s/asul/v7/z5y4FlQ1uiDBSZlyfABIIA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Asul Bold\'",
						"\'Asul-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/asul/v7/OoApJhEANXJdZEI6iEbpfA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JCxG0yXNoqQOnTiPZE3n8Q&skey=349ae3cc10487adc&v=v7#Asul",
						"ttf": "http://fonts.gstatic.com/s/asul/v7/PIPbG9KGodz5UM_VgnqMxw.ttf",
						"woff": "http://fonts.gstatic.com/s/asul/v7/P2z9YNrxqPjniGRboW2SJw.woff",
						"woff2": "http://fonts.gstatic.com/s/asul/v7/0tMuJ6TvjkBagvg1EX5MMQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Athiti": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Athiti ExtraLight\'",
						"\'Athiti-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/uOMlcP0zpARl5_AzC8Ze_PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uOMlcP0zpARl5_AzC8Ze_Jbd9NUM7myrQQz30yPaGQ4&skey=bcbc982d0b25e70c&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/uOMlcP0zpARl5_AzC8Ze_KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/uOMlcP0zpARl5_AzC8Ze_D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/uOMlcP0zpARl5_AzC8Ze_FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Athiti Light\'",
						"\'Athiti-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/_u250a4A3uV7uP527fjBaPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_u250a4A3uV7uP527fjBaJbd9NUM7myrQQz30yPaGQ4&skey=b8d03b3a95724f63&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/_u250a4A3uV7uP527fjBaKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/_u250a4A3uV7uP527fjBaD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/_u250a4A3uV7uP527fjBaFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Athiti\'",
						"\'Athiti-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/2GDXoW9SVvBlnNp4wL_EHQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=x6Z88nI6R9YAXP1G7aJqoQ&skey=a25e2ee822825b12&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/dUxF3SsuXBT_-BYHDblvag.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/wbe3bAZoRBUH7jE6WwbdFA.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/Qu8ThwHksrdlln0AKZNung.woff2"
					}
				},
				"500": {
					"local": [
						"\'Athiti Medium\'",
						"\'Athiti-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/IBcHkgc1LhFsu_zqATysTvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IBcHkgc1LhFsu_zqATysTpbd9NUM7myrQQz30yPaGQ4&skey=a9af0aff3636876a&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/IBcHkgc1LhFsu_zqATysTqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/IBcHkgc1LhFsu_zqATysTj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/IBcHkgc1LhFsu_zqATysTltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Athiti SemiBold\'",
						"\'Athiti-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/LdWPPmvQ79czkxVRijrcR_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LdWPPmvQ79czkxVRijrcR5bd9NUM7myrQQz30yPaGQ4&skey=777c730b5b3868b2&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/LdWPPmvQ79czkxVRijrcR6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/LdWPPmvQ79czkxVRijrcRz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/LdWPPmvQ79czkxVRijrcR1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Athiti Bold\'",
						"\'Athiti-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/athiti/v2/bSSEVUKD-jNZ7CyXjeWW8PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bSSEVUKD-jNZ7CyXjeWW8Jbd9NUM7myrQQz30yPaGQ4&skey=a60a8166ef402cc9&v=v2#Athiti",
						"ttf": "http://fonts.gstatic.com/s/athiti/v2/bSSEVUKD-jNZ7CyXjeWW8KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/athiti/v2/bSSEVUKD-jNZ7CyXjeWW8D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/athiti/v2/bSSEVUKD-jNZ7CyXjeWW8FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Atma": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin",
			"bengali"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Atma Light\'",
						"\'Atma-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atma/v3/hBSP4l-lRETrglAW1Lg71A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5zn5FhtBD_9dHpvjw64AeA&skey=1c5a42f4c83d56d1&v=v3#Atma",
						"ttf": "http://fonts.gstatic.com/s/atma/v3/fX5MbQUojCPmAymPnI9ujw.ttf",
						"woff": "http://fonts.gstatic.com/s/atma/v3/6y77pVl_5HNFfNd1wGwtzg.woff",
						"woff2": "http://fonts.gstatic.com/s/atma/v3/Od8cPWy9FXhZuP4h6II-Ag.woff2"
					}
				},
				"400": {
					"local": [
						"\'Atma Regular\'",
						"\'Atma-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atma/v3/qZvHJloLGB8p2dCo5LUk4g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-2Zgmjt6agWR1qTsYGu2tA&skey=ef0f4735d6c35705&v=v3#Atma",
						"ttf": "http://fonts.gstatic.com/s/atma/v3/Ca9FQNkREX9Mb-8NzZqSLg.ttf",
						"woff": "http://fonts.gstatic.com/s/atma/v3/MbS42iSaY4s8Vl_bBCu4ow.woff",
						"woff2": "http://fonts.gstatic.com/s/atma/v3/h3A1dHyu7MD1UIhUXOiGCQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Atma Medium\'",
						"\'Atma-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atma/v3/NjVI7_xkazNrfYk8G5eg-Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JLABOInA80CsaOiBaDWr-g&skey=8e8a91423c7cdf05&v=v3#Atma",
						"ttf": "http://fonts.gstatic.com/s/atma/v3/auHaA3ETZf1-efgPuCOJsw.ttf",
						"woff": "http://fonts.gstatic.com/s/atma/v3/7HwMjfkwhDciDHKNwuVBbg.woff",
						"woff2": "http://fonts.gstatic.com/s/atma/v3/sYx0uZ3R56QMuzBssF8kKA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Atma SemiBold\'",
						"\'Atma-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atma/v3/zBq7X4b2V_eC-CsDGqscYw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dUynN2xHcn3IqBQY26GbEQ&skey=e984897094fab105&v=v3#Atma",
						"ttf": "http://fonts.gstatic.com/s/atma/v3/hfI5gzwXOQVblB6Q6xK0RA.ttf",
						"woff": "http://fonts.gstatic.com/s/atma/v3/liqyb4uze9_dAoESmQKpuw.woff",
						"woff2": "http://fonts.gstatic.com/s/atma/v3/4VYRJUTmCFM7TxNGjTCblw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Atma Bold\'",
						"\'Atma-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atma/v3/ghhZiv6AHvdB-c6zjdaW2g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zgFnEMxqYqrQI3EtUN-dIg&skey=5ea54240f24e26e5&v=v3#Atma",
						"ttf": "http://fonts.gstatic.com/s/atma/v3/Jlis6jNmsIjBcFgMGA7NCg.ttf",
						"woff": "http://fonts.gstatic.com/s/atma/v3/INkD74wPkoLgP96CMU90kg.woff",
						"woff2": "http://fonts.gstatic.com/s/atma/v3/yI7-GEIMrsHmyHv3dO1c8g.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Atomic Age": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Atomic Age Regular\'",
						"\'AtomicAge-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/atomicage/v9/YWZsVkN6SDZ8jH2BPffNo1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YWZsVkN6SDZ8jH2BPffNo6WUboTb-jS2tyCOQMtm97g&skey=dbf7add47a92f990&v=v9#AtomicAge",
						"ttf": "http://fonts.gstatic.com/s/atomicage/v9/YWZsVkN6SDZ8jH2BPffNoy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/atomicage/v9/YWZsVkN6SDZ8jH2BPffNoxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/atomicage/v9/YWZsVkN6SDZ8jH2BPffNo_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Aubrey": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Aubrey Regular\'",
						"\'Aubrey-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/aubrey/v10/TIbx0mRlLVJfxWuIGjCgGA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GPvqMiotTk25uzDu2hxrLA&skey=f060869182c149a5&v=v10#Aubrey",
						"ttf": "http://fonts.gstatic.com/s/aubrey/v10/bF9J1Vntpq1kk5PYb6_uwg.ttf",
						"woff": "http://fonts.gstatic.com/s/aubrey/v10/nAlDRKsxGWlBMHgqN79Wqg.woff",
						"woff2": "http://fonts.gstatic.com/s/aubrey/v10/xgahevMliYbKS95vLy_e7A.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Audiowide": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Audiowide Regular\'",
						"\'Audiowide-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/audiowide/v6/8XtYtNKEyyZh481XVWfVOvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8XtYtNKEyyZh481XVWfVOpbd9NUM7myrQQz30yPaGQ4&skey=8f321fd369abd5f&v=v6#Audiowide",
						"ttf": "http://fonts.gstatic.com/s/audiowide/v6/8XtYtNKEyyZh481XVWfVOqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/audiowide/v6/8XtYtNKEyyZh481XVWfVOj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/audiowide/v6/8XtYtNKEyyZh481XVWfVOltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Autour One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Autour One Regular\'",
						"\'AutourOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/autourone/v7/7LzkKwczNE2R2ZQSt90y1VQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7LzkKwczNE2R2ZQSt90y1aWUboTb-jS2tyCOQMtm97g&skey=349fce4f261a2eda&v=v7#AutourOne",
						"ttf": "http://fonts.gstatic.com/s/autourone/v7/7LzkKwczNE2R2ZQSt90y1S3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/autourone/v7/7LzkKwczNE2R2ZQSt90y1RsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/autourone/v7/7LzkKwczNE2R2ZQSt90y1fk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Average": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Average Regular\'",
						"\'Average-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/average/v6/HzVsob_hiPr42bk9TzWBsQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cyCsOGFQCf36iTrH9lK5gw&skey=e8d3c78a1e722e05&v=v6#Average",
						"ttf": "http://fonts.gstatic.com/s/average/v6/IA8jQA5GFnMtnG2oawAIjw.ttf",
						"woff": "http://fonts.gstatic.com/s/average/v6/PT2T4EDE8LdI8iV2yQCkMA.woff",
						"woff2": "http://fonts.gstatic.com/s/average/v6/yOY_WO34FAtjzELSBI8hKg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Average Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Average Sans Regular\'",
						"\'AverageSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averagesans/v6/dnU3R-5A_43y5bIyLztPsXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dnU3R-5A_43y5bIyLztPsVlIn5tFQcqMuf-jhyJP0ps&skey=96ddd4e1c10cfd7f&v=v6#AverageSans",
						"ttf": "http://fonts.gstatic.com/s/averagesans/v6/dnU3R-5A_43y5bIyLztPsYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/averagesans/v6/dnU3R-5A_43y5bIyLztPsXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/averagesans/v6/dnU3R-5A_43y5bIyLztPsegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Averia Gruesa Libre": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Averia Gruesa Libre Regular\'",
						"\'AveriaGruesaLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiagruesalibre/v6/10vbZTOoN6T8D-nvDzwRFzdzAiDUj0oj7tHQ9el8-2k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=10vbZTOoN6T8D-nvDzwRF3_wOuBUDSiczLYXJiNmiOE&skey=1b05bd245828aab8&v=v6#AveriaGruesaLibre",
						"ttf": "http://fonts.gstatic.com/s/averiagruesalibre/v6/10vbZTOoN6T8D-nvDzwRF52VtiXDaDJux1YX1Y0t1wM.ttf",
						"woff": "http://fonts.gstatic.com/s/averiagruesalibre/v6/10vbZTOoN6T8D-nvDzwRF-n6_Kji9IOFAqEuXypQ7aQ.woff",
						"woff2": "http://fonts.gstatic.com/s/averiagruesalibre/v6/10vbZTOoN6T8D-nvDzwRF4JWVBtBpC2aP0cdwi-lS9I.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Averia Libre": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Averia Libre Light Italic\'",
						"\'AveriaLibre-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkiH_XWDaITL6s384ufbsW_o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=I6wAYuAvOgT7el2ePj2nktv65-B3V1C1aB1PFKVs0gQ&skey=26cddf79a124e29b&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkn3uxQAI1Bvm-GxtFNy4yl0.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkm0Xvi9kvVpeKmlONF1xhUs.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nknM1hBkL4m68a-ReB_y0NYc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Libre Italic\'",
						"\'AveriaLibre-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/1etzuoNxVHR8F533EkD1WToGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1etzuoNxVHR8F533EkD1WX2UFnxWCzsMUZbVj2XRF5M&skey=5e474d1c0d7c0bef&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/1etzuoNxVHR8F533EkD1WStfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/1etzuoNxVHR8F533EkD1WXpumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/1etzuoNxVHR8F533EkD1WRMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Libre Bold Italic\'",
						"\'AveriaLibre-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkiy7jlJQNiTiB3-MejPw_5E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=I6wAYuAvOgT7el2ePj2nkuiOBN1C42tFdXFKJTGlCXo&skey=da62cb8d9958ee96&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkixQL91WRy8t8mPvAX_dIgA.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkr0qgHI2SEqiJszC-CVc3gY.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/I6wAYuAvOgT7el2ePj2nkkcqRxak6Wc5LUVz-l064SE.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Averia Libre Light\'",
						"\'AveriaLibre-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XYySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r6hGL8sSLm4dTzOPXgx5XbJg1hA63dzswhy4NvEPrPM&skey=af90eef89c3f47a6&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XQV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XWFp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XU4GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Libre Regular\'",
						"\'AveriaLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/rYVgHZZQICWnhjguGsBspHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rYVgHZZQICWnhjguGsBspFlIn5tFQcqMuf-jhyJP0ps&skey=b7894c4b70c11e4a&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/rYVgHZZQICWnhjguGsBspInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/rYVgHZZQICWnhjguGsBspHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/rYVgHZZQICWnhjguGsBspOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Libre Bold\'",
						"\'AveriaLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XWmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r6hGL8sSLm4dTzOPXgx5XQay50PuN8loMJ9QAXsTs7U&skey=393dd94c066675da&v=v6#AveriaLibre",
						"ttf": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XX06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XXl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/averialibre/v6/r6hGL8sSLm4dTzOPXgx5XXNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Averia Sans Libre": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Averia Sans Libre Light Italic\'",
						"\'AveriaSansLibre-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88YTQqF0J0_IdPuyxQ0IuPoA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o7BEIK-fG3Ykc5Rzteh88RcNRepsUl-Tqsa6N3JVUtE&skey=cc92f7efd2e5f097&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88V6ukrnR1WWV5prWGwA_FiA.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88TwGJe1Ritukzj9KLPliaHs.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88c0xyglSOGBsOthtopnAv1Q.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Sans Libre Italic\'",
						"\'AveriaSansLibre-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/COEzR_NPBSUOl3pFwPbPoBNjXYcyPyBbNO7kqk7e-1w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=COEzR_NPBSUOl3pFwPbPoGXr1eu2OnnsESm59_Qc73E&skey=2dd373ecc45974ca&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/COEzR_NPBSUOl3pFwPbPoA00n4zq5SPrxa3X3MvZicE.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/COEzR_NPBSUOl3pFwPbPoMNLJTKM-wYHphDyVtfwW4w.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/COEzR_NPBSUOl3pFwPbPoJSGm6KUljklxXWJovNuIXQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Sans Libre Bold Italic\'",
						"\'AveriaSansLibre-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88WeOLIJvwVVhNQvC6QavgkU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o7BEIK-fG3Ykc5Rzteh88ULb1GOZhot8_EfYnySu9MY&skey=cb465f0d8f628d06&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88cK1OonvZ4BbNrtvLBuG6Oo.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88QJL7NOZp8eSaCZz-rd3Fm8.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/o7BEIK-fG3Ykc5Rzteh88YCrS3mRKslbT_6zMFa4Fn4.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Averia Sans Libre Light\'",
						"\'AveriaSansLibre-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-V8CakL-g7UrbSzm4u7UCrmI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_9-jTfQjaBsWAF_yp5z-V9ffZRXGJTjr2vETzLxm2p4&skey=5ac284c42aba46e&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-VxehFIEDOSimo2zCth9Etz8.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-V5LWksJ7nlJfeDowzbnpcks.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-V4k-BIBg9prQ4wH-tA3JwFI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Sans Libre Regular\'",
						"\'AveriaSansLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/yRJpjT39KxACO9F31mj_LsSE4kVLkq_pGA03sQp_CCE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yRJpjT39KxACO9F31mj_Ltb_q8jEjTdQ_rhQsRV2s6c&skey=9a217332e7950b30&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/yRJpjT39KxACO9F31mj_LsevLjdB67LO9Bn4JiESQyE.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/yRJpjT39KxACO9F31mj_LqOxStDXxcWVrHkhVmjuyZ8.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/yRJpjT39KxACO9F31mj_LvcOZQNxZYPRP1ijOpfvkPY.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Sans Libre Bold\'",
						"\'AveriaSansLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-V4ji_pEj67p6jFeMnjcYHRU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_9-jTfQjaBsWAF_yp5z-V7vq_b3S9qK2R9SxjqEVCPE&skey=b9be244018d12c07&v=v6#AveriaSansLibre",
						"ttf": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-Vz_6X-A3FfKNV9045Ixic8Y.ttf",
						"woff": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-V3KEJwgChdNFxj_gxVyEQ-M.woff",
						"woff2": "http://fonts.gstatic.com/s/averiasanslibre/v6/_9-jTfQjaBsWAF_yp5z-VzA4WgwRdM3rsK409NefW5E.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Averia Serif Libre": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Averia Serif Libre Light Italic\'",
						"\'AveriaSerifLibre-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCKp1baenvciZ4sXzzt2tZeU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YOLFXyye4sZt6AZk1QybCDhC2FQz69JefsjlNh6GDng&skey=f35ea043f7924d59&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCFdEioULeFcHi5J7zgvFXEk.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCBj1oTEUTm_pnlXVK4m9LQc.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCDPuAC2_UmSRcXwtnwHsdTU.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Serif Libre Italic\'",
						"\'AveriaSerifLibre-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/o9qhvK9iT5iDWfyhQUe-6duw6tO_tm8pDDl45WU--Pk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o9qhvK9iT5iDWfyhQUe-6XLiXq4dH1NwHwIGbXYaG6U&skey=5e38bb1b0870a70a&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/o9qhvK9iT5iDWfyhQUe-6U3nux3buPNiczSnNy82W7U.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/o9qhvK9iT5iDWfyhQUe-6YG7QaYXOwxha5kOEu8mxmY.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/o9qhvK9iT5iDWfyhQUe-6Q0EDuLyW4WENqbPkj8OYUM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Serif Libre Bold Italic\'",
						"\'AveriaSerifLibre-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCHbvW2IWCm-C39Mgf4FY0uk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YOLFXyye4sZt6AZk1QybCGFYf_GxWa734S63lO4rSVs&skey=ff4838218fd906ae&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCLUTHSiWi-2ZvWwnwBnKZSo.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCC9nBt--hyWLm1TwfB5dKeA.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/YOLFXyye4sZt6AZk1QybCOJgjW6oyF_MACtJBtnlvMc.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Averia Serif Libre Light\'",
						"\'AveriaSerifLibre-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8WgX3QDqvwWPiL6lBpdtUx4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yvITAdr5D1nlsdFswJAb8QrD1k7XElXTUYbyUqOaDTI&skey=e679fe809815f8e7&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8QAVPhI-iwHhniq94Ibhb88.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8e-YWq385IAVPzMD4l9v7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8Vos2Pdf-dQN4tJmHAEs2hQ.woff2"
					}
				},
				"400": {
					"local": [
						"\'Averia Serif Libre Regular\'",
						"\'AveriaSerifLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/fdtF30xa_Erw0zAzOoG4BWp6H4BTyJJdE4vyP0FMenE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fdtF30xa_Erw0zAzOoG4BXp7vDrPjfrK2CZIqqpil6I&skey=842fb58b948b1460&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/fdtF30xa_Erw0zAzOoG4BeKzPr0x8JMzFIz_Js1kWgQ.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/fdtF30xa_Erw0zAzOoG4Bacli1JbuwfBLEwdK1GZsB8.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/fdtF30xa_Erw0zAzOoG4BVVaXhodyZpwkPyKEugoMLo.woff2"
					}
				},
				"700": {
					"local": [
						"\'Averia Serif Libre Bold\'",
						"\'AveriaSerifLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8bSYTaPzVX5WQ-Y4pf693iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yvITAdr5D1nlsdFswJAb8XoYeI1kvriyRd7a25Ihdxc&skey=af4fc39b5a4d449a&v=v7#AveriaSerifLibre",
						"ttf": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8eRPvo9J2jdoeZpTRw7FKiI.ttf",
						"woff": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8THZVF17dzMyghxCGC07ZIg.woff",
						"woff2": "http://fonts.gstatic.com/s/averiaseriflibre/v7/yvITAdr5D1nlsdFswJAb8bRvF9TtTS_X8aoI_M_kMjc.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Bad Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bad Script Regular\'",
						"\'BadScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/badscript/v6/rL_b2ND61EQmMOJ8CRr1flQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rL_b2ND61EQmMOJ8CRr1fqWUboTb-jS2tyCOQMtm97g&skey=bab4df51e3e7f1cf&v=v6#BadScript",
						"ttf": "http://fonts.gstatic.com/s/badscript/v6/rL_b2ND61EQmMOJ8CRr1fi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/badscript/v6/rL_b2ND61EQmMOJ8CRr1fhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/badscript/v6/rL_b2ND61EQmMOJ8CRr1fvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bahiana": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bahiana Regular\'",
						"\'Bahiana-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bahiana/v2/cAYz-AXyhO83OXbWaihFzA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GsCm4E3gQw2SQgYktcKxyQ&skey=3cf698d11caf64aa&v=v2#Bahiana",
						"ttf": "http://fonts.gstatic.com/s/bahiana/v2/iMLVTDVRUIucf97aNHdQug.ttf",
						"woff": "http://fonts.gstatic.com/s/bahiana/v2/MHuvwnVVD9kSy-ADhqmDgA.woff",
						"woff2": "http://fonts.gstatic.com/s/bahiana/v2/-RY91ALayRKBoudC01XTCA.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Baloo": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Regular\'",
						"\'Baloo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloo/v3/53W3qNRA9yCP81mpyLTLIA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZOcxBRsF_MHn_2f9A8qZ8w&skey=909b6264e020bb06&v=v3#Baloo",
						"ttf": "http://fonts.gstatic.com/s/baloo/v3/PRpq0YMT-nughnhZGXjn2g.ttf",
						"woff": "http://fonts.gstatic.com/s/baloo/v3/vi7PMxrcqrWOBYSFqU_EgA.woff",
						"woff2": "http://fonts.gstatic.com/s/baloo/v3/RFm9MaodarSezi9FSqQmfw.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Bhai": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"gujarati",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Bhai Regular\'",
						"\'BalooBhai-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloobhai/v3/D9UwT_bpBzKK7vWnCxsnw1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=D9UwT_bpBzKK7vWnCxsnw6WUboTb-jS2tyCOQMtm97g&skey=e7a671cb55faf8b9&v=v3#BalooBhai",
						"ttf": "http://fonts.gstatic.com/s/baloobhai/v3/D9UwT_bpBzKK7vWnCxsnwy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/baloobhai/v3/D9UwT_bpBzKK7vWnCxsnwxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/baloobhai/v3/D9UwT_bpBzKK7vWnCxsnw_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Bhaijaan": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"arabic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Bhaijaan Regular\'",
						"\'BalooBhaijaan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloobhaijaan/v2/WADJjVg5Kkv7JQ_7Ty9eDmBz5J4XM0tc7MzoXZtzJQM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WADJjVg5Kkv7JQ_7Ty9eDg4T36nfNfd1l_qBIu84pjI&skey=92e89f03757ce841&v=v2#BalooBhaijaan",
						"ttf": "http://fonts.gstatic.com/s/baloobhaijaan/v2/WADJjVg5Kkv7JQ_7Ty9eDssvLjVo3EeTYranYOq3MO0.ttf",
						"woff": "http://fonts.gstatic.com/s/baloobhaijaan/v2/WADJjVg5Kkv7JQ_7Ty9eDmt1_gXQkYzMmB3g_onED28.woff",
						"woff2": "http://fonts.gstatic.com/s/baloobhaijaan/v2/WADJjVg5Kkv7JQ_7Ty9eDsqqVmu99WGkHhq_COviWBY.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Baloo Bhaina": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"oriya",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Bhaina Regular\'",
						"\'BalooBhaina-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloobhaina/v3/HxxbxOVf9WQem_hKo1MXSnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HxxbxOVf9WQem_hKo1MXSllIn5tFQcqMuf-jhyJP0ps&skey=3699402d0d6ef054&v=v3#BalooBhaina",
						"ttf": "http://fonts.gstatic.com/s/baloobhaina/v3/HxxbxOVf9WQem_hKo1MXSonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/baloobhaina/v3/HxxbxOVf9WQem_hKo1MXSnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/baloobhaina/v3/HxxbxOVf9WQem_hKo1MXSugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Chettan": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"malayalam",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Chettan Regular\'",
						"\'BalooChettan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloochettan/v3/ODsFofLybGVOJ90e_EwdFYuF69CdJnV5iEpeMqnlXwQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ODsFofLybGVOJ90e_EwdFTCPfD0HDxPxjGzQKGA7iK4&skey=9b43171ff32af80b&v=v3#BalooChettan",
						"ttf": "http://fonts.gstatic.com/s/baloochettan/v3/ODsFofLybGVOJ90e_EwdFaeKqSXbK4zswt1r_OKLqf8.ttf",
						"woff": "http://fonts.gstatic.com/s/baloochettan/v3/ODsFofLybGVOJ90e_EwdFUVDxRBEc4RmgnrdkbHRYVo.woff",
						"woff2": "http://fonts.gstatic.com/s/baloochettan/v3/ODsFofLybGVOJ90e_EwdFSPOCIAftl0JjyAbK_MREh4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Da": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin",
			"bengali"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Da Regular\'",
						"\'BalooDa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/balooda/v3/ijMpLsBDS2177ncurd0PhfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oCSMkG5rqvThphMYf8TLlPesZW2xOQ-xsNqO47m55DA&skey=f08c23aac4b612f6&v=v3#BalooDa",
						"ttf": "http://fonts.gstatic.com/s/balooda/v3/aQsFrVH2rkyf2an66x6l0PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/balooda/v3/KFC2-vJK_ICmgrwiO1qVh_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/balooda/v3/iG3AW_qczXmCJOjnWOGIRfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Paaji": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"gurmukhi",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Paaji Regular\'",
						"\'BalooPaaji-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloopaaji/v3/zcOxsgjL4TWgCkkTN4pnQWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zcOxsgjL4TWgCkkTN4pnQXNsigHlcrQGNV8nkUSFQfc&skey=caf630a2319205bb&v=v3#BalooPaaji",
						"ttf": "http://fonts.gstatic.com/s/baloopaaji/v3/zcOxsgjL4TWgCkkTN4pnQZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/baloopaaji/v3/zcOxsgjL4TWgCkkTN4pnQYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/baloopaaji/v3/zcOxsgjL4TWgCkkTN4pnQY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Tamma": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin",
			"kannada"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Tamma Regular\'",
						"\'BalooTamma-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/balootamma/v3/M9jLCKQXJLpx_E5bTHjE-GfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M9jLCKQXJLpx_E5bTHjE-HNsigHlcrQGNV8nkUSFQfc&skey=4e17e9c5a355a699&v=v3#BalooTamma",
						"ttf": "http://fonts.gstatic.com/s/balootamma/v3/M9jLCKQXJLpx_E5bTHjE-J0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/balootamma/v3/M9jLCKQXJLpx_E5bTHjE-IbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/balootamma/v3/M9jLCKQXJLpx_E5bTHjE-I4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Tammudu": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Tammudu Regular\'",
						"\'BalooTammudu-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/balootammudu/v3/_VlYJH4sGzgC_fTDQEKfT5R9Ryi_i77z6ySk9_1AAjU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_VlYJH4sGzgC_fTDQEKfTwgUaSN0jnKByYfbEcCUP8g&skey=d052ee0a0f623158&v=v3#BalooTammudu",
						"ttf": "http://fonts.gstatic.com/s/balootammudu/v3/_VlYJH4sGzgC_fTDQEKfT0eN9_PuYDYSdhd-BG-vTKk.ttf",
						"woff": "http://fonts.gstatic.com/s/balootammudu/v3/_VlYJH4sGzgC_fTDQEKfT2Vh_0KSj_oIslA1hnt_9wE.woff",
						"woff2": "http://fonts.gstatic.com/s/balootammudu/v3/_VlYJH4sGzgC_fTDQEKfT0L0QWH-sxoOqIWNGQmMQmc.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Baloo Thambi": {
		"category": "display",
		"lastModified": "2017-11-21",
		"subsets": [
			"tamil",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baloo Thambi Regular\'",
						"\'BalooThambi-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baloothambi/v3/qXK3dZIeU-O-HruaN5cK03Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qXK3dZIeU-O-HruaN5cK01lIn5tFQcqMuf-jhyJP0ps&skey=8868b806ee96bb3b&v=v3#BalooThambi",
						"ttf": "http://fonts.gstatic.com/s/baloothambi/v3/qXK3dZIeU-O-HruaN5cK04nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/baloothambi/v3/qXK3dZIeU-O-HruaN5cK03hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/baloothambi/v3/qXK3dZIeU-O-HruaN5cK0-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Balthazar": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Balthazar Regular\'",
						"\'Balthazar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/balthazar/v6/E9s_OrHc1N8XyvXr2y-jyvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=E9s_OrHc1N8XyvXr2y-jypbd9NUM7myrQQz30yPaGQ4&skey=eb41b13c48ddda62&v=v6#Balthazar",
						"ttf": "http://fonts.gstatic.com/s/balthazar/v6/E9s_OrHc1N8XyvXr2y-jyqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/balthazar/v6/E9s_OrHc1N8XyvXr2y-jyj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/balthazar/v6/E9s_OrHc1N8XyvXr2y-jyltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bangers": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bangers Regular\'",
						"\'Bangers-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bangers/v10/ybYXAFtWOVmmrWj_aZCIlg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5AsVHAIAfLGFHGihuf6qOQ&skey=80f504448509eaf7&v=v10#Bangers",
						"ttf": "http://fonts.gstatic.com/s/bangers/v10/_Kq7Xa_aavBxPnttrBeaoQ.ttf",
						"woff": "http://fonts.gstatic.com/s/bangers/v10/DqeGA7eaz0hhOYTfkeJBIA.woff",
						"woff2": "http://fonts.gstatic.com/s/bangers/v10/yJQgrSMUoqRj-0SbnQsv4g.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Barlow": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Barlow Thin Italic\'",
						"\'Barlow-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/9fdthHUhSzIX1ODg7pB9clQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9fdthHUhSzIX1ODg7pB9cqWUboTb-jS2tyCOQMtm97g&skey=c079aaa284cdfedf&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/9fdthHUhSzIX1ODg7pB9ci3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/9fdthHUhSzIX1ODg7pB9chsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/9fdthHUhSzIX1ODg7pB9cvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow ExtraLight Italic\'",
						"\'Barlow-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/14AxwKgJhKIO-YYUP_KtZWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=14AxwKgJhKIO-YYUP_KtZXNsigHlcrQGNV8nkUSFQfc&skey=9a40589dc4645af7&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/14AxwKgJhKIO-YYUP_KtZZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/14AxwKgJhKIO-YYUP_KtZYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/14AxwKgJhKIO-YYUP_KtZY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Light Italic\'",
						"\'Barlow-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/UD7Inm3zNeYNXv1kqpDpHWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UD7Inm3zNeYNXv1kqpDpHXNsigHlcrQGNV8nkUSFQfc&skey=cff9305546dac9b9&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/UD7Inm3zNeYNXv1kqpDpHZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/UD7Inm3zNeYNXv1kqpDpHYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/UD7Inm3zNeYNXv1kqpDpHY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Italic\'",
						"\'Barlow-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/_7W9u7Rg5JeEYyB4I-5pOfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uQw8bxE1eu3m7J6a_Nu0AvesZW2xOQ-xsNqO47m55DA&skey=ae428d300932fbee&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/Dh2QeZ-HyPDCq6TsH8nLZ_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/EA74Wmdq84g25fIP_ijgmfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/vADDAxUPaKLGvzvvbT2jcPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Medium Italic\'",
						"\'Barlow-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/xJLokI-F3wr7NRWXgS0pZ2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xJLokI-F3wr7NRWXgS0pZ3NsigHlcrQGNV8nkUSFQfc&skey=989d87b0113009a2&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/xJLokI-F3wr7NRWXgS0pZ50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/xJLokI-F3wr7NRWXgS0pZ4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/xJLokI-F3wr7NRWXgS0pZ44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow SemiBold Italic\'",
						"\'Barlow-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/QXrib7OSXyb9OeBbtKNCA2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QXrib7OSXyb9OeBbtKNCA3NsigHlcrQGNV8nkUSFQfc&skey=b6fa275773d7d91f&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/QXrib7OSXyb9OeBbtKNCA50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/QXrib7OSXyb9OeBbtKNCA4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/QXrib7OSXyb9OeBbtKNCA44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Bold Italic\'",
						"\'Barlow-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/hw7DQwyFvE7wFOFzpow4xmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hw7DQwyFvE7wFOFzpow4xnNsigHlcrQGNV8nkUSFQfc&skey=25c93348b6ec64d8&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/hw7DQwyFvE7wFOFzpow4xp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/hw7DQwyFvE7wFOFzpow4xobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/hw7DQwyFvE7wFOFzpow4xo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow ExtraBold Italic\'",
						"\'Barlow-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/E0VWElKRhtvexNqV8unt0GfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=E0VWElKRhtvexNqV8unt0HNsigHlcrQGNV8nkUSFQfc&skey=4f8c1421606143df&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/E0VWElKRhtvexNqV8unt0J0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/E0VWElKRhtvexNqV8unt0IbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/E0VWElKRhtvexNqV8unt0I4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Black Italic\'",
						"\'Barlow-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/ujkXWEueSzI-q_4nCa9IlWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ujkXWEueSzI-q_4nCa9IlXNsigHlcrQGNV8nkUSFQfc&skey=a17eda9aca9f836a&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/ujkXWEueSzI-q_4nCa9IlZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/ujkXWEueSzI-q_4nCa9IlYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/ujkXWEueSzI-q_4nCa9IlY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Barlow Thin\'",
						"\'Barlow-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/s-NT1SiI1hngpt27LbO3mPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DYMnKuO3I7F5aXqGtVsrR_esZW2xOQ-xsNqO47m55DA&skey=ea7542df22f6a953&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/slHfg1Ki0aIzBLjPOcQ6E_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/Pfl5Z7fOwXv4QgMbvgufDvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/AEBRafzElgxx4Y5XdxtUP_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow ExtraLight\'",
						"\'Barlow-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/CskYcOKxzCwVNr7ydVL5PvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CskYcOKxzCwVNr7ydVL5Ppbd9NUM7myrQQz30yPaGQ4&skey=e8c74abecf94633e&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/CskYcOKxzCwVNr7ydVL5PqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/CskYcOKxzCwVNr7ydVL5Pj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/CskYcOKxzCwVNr7ydVL5PltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Light\'",
						"\'Barlow-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/t09mUKQAC1MQLTmQ7W-bpfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=t09mUKQAC1MQLTmQ7W-bpZbd9NUM7myrQQz30yPaGQ4&skey=5c2bca46e72f5b37&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/t09mUKQAC1MQLTmQ7W-bpaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/t09mUKQAC1MQLTmQ7W-bpT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/t09mUKQAC1MQLTmQ7W-bpVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Regular\'",
						"\'Barlow-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/rpSjJQVrTWkDMaisWlQ2DQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=e_RJw0AX5pgx-jQyFa3aNA&skey=32d7acf8757dbad0&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/_DbvQBosOLodVM9Q3wHFDw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/JFNqGlAC2GvblNwH7ztGoQ.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/m4mkzFgzyAU93qx0-DUx_Q.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Medium\'",
						"\'Barlow-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/kIIp0WfvDOeW2tTGAi2QqfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kIIp0WfvDOeW2tTGAi2QqZbd9NUM7myrQQz30yPaGQ4&skey=4c8d0d0b13516148&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/kIIp0WfvDOeW2tTGAi2QqaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/kIIp0WfvDOeW2tTGAi2QqT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/kIIp0WfvDOeW2tTGAi2QqVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow SemiBold\'",
						"\'Barlow-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/STGn7jeR41qcJTicY9WE5fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=STGn7jeR41qcJTicY9WE5Zbd9NUM7myrQQz30yPaGQ4&skey=a9a2225c15335812&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/STGn7jeR41qcJTicY9WE5aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/STGn7jeR41qcJTicY9WE5T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/STGn7jeR41qcJTicY9WE5VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Bold\'",
						"\'Barlow-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/8hNuYABG6RcCB7awZe-wJ_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8hNuYABG6RcCB7awZe-wJ5bd9NUM7myrQQz30yPaGQ4&skey=f60e73b1bbf362f3&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/8hNuYABG6RcCB7awZe-wJ6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/8hNuYABG6RcCB7awZe-wJz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/8hNuYABG6RcCB7awZe-wJ1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow ExtraBold\'",
						"\'Barlow-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/CaHLjSyIeCIbt753gvinv_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CaHLjSyIeCIbt753gvinv5bd9NUM7myrQQz30yPaGQ4&skey=c0113ae012ad56b&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/CaHLjSyIeCIbt753gvinv6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/CaHLjSyIeCIbt753gvinvz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/CaHLjSyIeCIbt753gvinv1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Black\'",
						"\'Barlow-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlow/v1/8xTtwcTHLrNmXC4s80ier_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8xTtwcTHLrNmXC4s80ier5bd9NUM7myrQQz30yPaGQ4&skey=ed2d519ec0625a7a&v=v1#Barlow",
						"ttf": "http://fonts.gstatic.com/s/barlow/v1/8xTtwcTHLrNmXC4s80ier6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/barlow/v1/8xTtwcTHLrNmXC4s80ierz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlow/v1/8xTtwcTHLrNmXC4s80ier1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v1"
	},
	"Barlow Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Barlow Condensed Thin Italic\'",
						"\'BarlowCondensed-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/ZKexgmMD5LIQJOU_ocZR1MhOL0RjE6ZUtf7L2Y7h5rE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZKexgmMD5LIQJOU_ocZR1BIF-IfO1scARrlCaYOGohU&skey=8d73ad013bada681&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/ZKexgmMD5LIQJOU_ocZR1MqAyPSM0qV570IzKKcWPLg.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/ZKexgmMD5LIQJOU_ocZR1IOYYXCW2dGYuRKKcHFZbDQ.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/ZKexgmMD5LIQJOU_ocZR1Ihns1kZotZjUa04DRgpDkA.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow Condensed ExtraLight Italic\'",
						"\'BarlowCondensed-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MqtBPfM39N_CI54eIqPtk-U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2Mt4XkgpmvcE389qOlaROPNA&skey=88c5913569c7dd02&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MmVJNoLSSIlXtMFonvGDYS0.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MsQX78oaPbY95Y12fF0tl6E.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MokMGQb24XbcF4q13tFKXmc.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Condensed Light Italic\'",
						"\'BarlowCondensed-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MkgLa83GLIFqS5fNKyK1-MQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2MiF-5VAYi9bGHtDg7TVhDY4&skey=16bfc0e84234c4ef&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MsgYS_4b_j8XZWrBSrn8QbY.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mu6J62hFWZVScRuaNBOo_rA.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MhN-SY3RXjKuKZR1RHIa0nw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Condensed Italic\'",
						"\'BarlowCondensed-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE2VMz6u1mZhSCOxOw1L508I.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AFyvjQed-FUXvXfnhoosE0gSycwWYVmqVKeH20EnyKI&skey=9206bac87467ba29&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE9Nyc1nIn01s4QPT2l20KA4.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE_HZ7IfZvqUgXLEMrfwTXOk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE9bvlX87CS9_IgWvysdluIM.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Condensed Medium Italic\'",
						"\'BarlowCondensed-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MsGtELvB134Y55tYpNwfQHI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2Mp65lESnmBPHs5_tEbIa538&skey=81321c91bc66785f&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mqp8pJeEcEU44jbAhhlmzJs.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MpNNuaB0lsnBXQWf7Zn87vk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MndQmeKJJux6_wfLHqdBLyY.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow Condensed SemiBold Italic\'",
						"\'BarlowCondensed-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mo_9bhN4GeZZ2H5d-Ck9-lM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2MrqygXJAoUiNrSiIUqcGuYo&skey=5a43bdf9ffd0ff14&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MmmAP98i6L7vkdbb3BjwFdk.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MpdlkKi76OzQn7UT4aefzdM.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mr67n55kLr55TwQ9GgmUdis.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Condensed Bold Italic\'",
						"\'BarlowCondensed-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mt6vkPPln-l9D31-51M-Ebk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2MpGPlzrbXT8NQc8KoI_FRnE&skey=3702e1387e0d12b7&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Movse0WFWMXD6DWBLcV41iQ.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mgm1Bdh5PCvFKhAPu2iWX-U.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mjn8OlxV1N2WpeXfK2HtpfA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow Condensed ExtraBold Italic\'",
						"\'BarlowCondensed-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MhmjZ_gS4TqiAfw_9mcRmBs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2Mt979PJIOfBlJKZKwqVhKOc&skey=72304bf7a4fc3cef&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mp52gzxvwE9Hoztzn8rjFOA.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MpXY42symEEEL7JRpZDcfwQ.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MkVOAJjV9aZFMOut6EmjQd4.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Condensed Black Italic\'",
						"\'BarlowCondensed-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MjctEkf6-S_xHgG29w9ad9c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=52CJF6vdk9OPHVYGv6-2Mkq9Zjz-c5DjTgqljyUdMAA&skey=a81f4de5bc905e66&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MsYPj0rNKO1vnJQVlgZLEJc.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2MuQoWgWbhSwctCJ6R1rFsxE.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/52CJF6vdk9OPHVYGv6-2Mm1YboatVveQXlwZIL5tcUg.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Barlow Condensed Thin\'",
						"\'BarlowCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE88e94IoMTMoV-CsVH83feE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AFyvjQed-FUXvXfnhoosE-GK4vg9xH-p4V71T9tOZpE&skey=cac624d97381808b&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE4dzlrj_E1fsPEiB97ws-Lw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE5JI0aV_zrL8N57IfjGN9cI.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/AFyvjQed-FUXvXfnhoosE8LglpogfC9b07NyDXMSojU.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow Condensed ExtraLight\'",
						"\'BarlowCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8Pcdg6TYjbIy5NSMcLu_z0c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8BySj93ThVqphTIoulmUYeM&skey=9bee7c0ab3fa0506&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8JEBnQ_ADnpJqnVlE1I8ooU.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8FJ5R-e6C684rkCAGwHhzRE.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8H0UO8ynKaxE0-gXyPRap78.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Condensed Light\'",
						"\'BarlowCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8CrW_eugtb5_efFKynOEdiw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8JQFxe5aI6lpFR3J4hsGg-E&skey=81960f8e0103fa88&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8L3QFSXBldIn45k5A7iXhnc.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8NeiznanRB67rGZDYkMvKPc.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8BBQ_Gf4FfI8J4SYljBAylk.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Condensed Regular\'",
						"\'BarlowCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/cKj4a3uS3MxclVhpADml2W8ITcfo9NwJpvZiO7_FxEg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cKj4a3uS3MxclVhpADml2c9XqQMESZbwKrSTBefVM6U&skey=a14102e17a4027e&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/cKj4a3uS3MxclVhpADml2TR-eWpsHSw83BRsAQElGgc.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/cKj4a3uS3MxclVhpADml2VzqCfRpIA3W6ypxnPISCPA.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/cKj4a3uS3MxclVhpADml2TAdhzWOYhqHvOZMRGaEyPo.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Condensed Medium\'",
						"\'BarlowCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8N5X1Fb3Dfy8-sjm-ow24KA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8AtmJapB7sBO_OR2jNvaP7g&skey=54c77835287a87aa&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8IESbNoyHF0a9Krezjv66Wk.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8CJBTAZ0hhiCLcTpbcFO4CI.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8HJNtwrSiZq9cH7YTVccHbs.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow Condensed SemiBold\'",
						"\'BarlowCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8DQGbMDr_jo1lsdA4JXHWvs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8A0JQDu80z5qi-aherFGCZM&skey=4be49ee59cd714e&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8LPzKdVkDHIkLtLZuofKwMw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8KGm0AHs_WkFSzFUK1yst9Q.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8ETRam3eT5xW9s2HUgvCLj0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Condensed Bold\'",
						"\'BarlowCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8JTpJ4fOLLwmHp8vl0kIMg4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8CoXBrVdHOqjiqqtUHVRFjE&skey=f7328bd78d9d4b7c&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8Dokq8qT6AIiNJ07Vf_NrVA.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8CSLrGe-fkSRw2DeVgOoWcQ.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8Hm2hrkyco9jQ3NKMXpgOBg.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow Condensed ExtraBold\'",
						"\'BarlowCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8M9KA_i6DpCeSzG2P3CBplU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8PsM0bSXSV0xxYlsjJR0C2E&skey=1e5e3992d4d63cf5&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8OoPezSXGHz38iIuWPiRuj4.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8LVzTZvxsw2ROHBl4Hy_ysc.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8J7AdUwOFEJv2EEotoTqNSg.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Condensed Black\'",
						"\'BarlowCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8EQAw25_wCnenEyobMZSw8U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrFbL_C7uluSl6tRywbI8BWQjfriaLwkciQ1fgxOPxg&skey=1b59bd40794d392f&v=v1#BarlowCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8GpeNwTdD9bvUr9a1SeVO-I.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8NqMv6E8GwYaAC8T2X7tGUk.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowcondensed/v1/OrFbL_C7uluSl6tRywbI8MUcIsZND7kyOQMbuiKg4tk.woff2"
					}
				}
			}
		},
		"version": "v1"
	},
	"Barlow Semi Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Barlow Semi Condensed Thin Italic\'",
						"\'BarlowSemiCondensed-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/pyyssUoTx0daao5w56i4axVOuvW2uf2uavU4cNZky_32Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pyyssUoTx0daao5w56i4axVOuvW2uf2uavU4cNZky_2W3fTVDO5sq0EM99Mj2hkO&skey=c35f49f0aec212&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/pyyssUoTx0daao5w56i4axVOuvW2uf2uavU4cNZky_2glnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/pyyssUoTx0daao5w56i4axVOuvW2uf2uavU4cNZky_0_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/pyyssUoTx0daao5w56i4axVOuvW2uf2uavU4cNZky_1bV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow Semi Condensed ExtraLight Italic\'",
						"\'BarlowSemiCondensed-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v2-mikYe-RvUgZwWRHco3JZUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47v2-mikYe-RvUgZwWRHco3JallG6E2_o0trcgjkDLZve4&skey=928ed1b429b3a486&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v2-mikYe-RvUgZwWRHco3JYt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v2-mikYe-RvUgZwWRHco3JYbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v2-mikYe-RvUgZwWRHco3Jb5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Semi Condensed Light Italic\'",
						"\'BarlowSemiCondensed-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v0-z8PROTg0D3cTVFl0anKtUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47v0-z8PROTg0D3cTVFl0anKullG6E2_o0trcgjkDLZve4&skey=c4b9842859d2b7c&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v0-z8PROTg0D3cTVFl0anKst1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v0-z8PROTg0D3cTVFl0anKsbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v0-z8PROTg0D3cTVFl0anKv5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Semi Condensed Italic\'",
						"\'BarlowSemiCondensed-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlbnMS75zwiD7qi52iFvzLRU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rObwC0zkSDuhDJaXoDJAldBNz15dbSuXhaIMIIyCYWk&skey=92cce03f4a52369&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlTXIO6_cS0TtT2mSS4sSoIQ.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAleOVX7rLuUJnd2d-NJB4xsU.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlVttN7NAm-UbZA3d6BJ7elc.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Semi Condensed Medium Italic\'",
						"\'BarlowSemiCondensed-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwUzv7L6-_RShaBuFpXptgRUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47vwUzv7L6-_RShaBuFpXptgSllG6E2_o0trcgjkDLZve4&skey=497b1fb78056c42c&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwUzv7L6-_RShaBuFpXptgQt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwUzv7L6-_RShaBuFpXptgQbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwUzv7L6-_RShaBuFpXptgT5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow Semi Condensed SemiBold Italic\'",
						"\'BarlowSemiCondensed-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwYaAug5zhUOLYwcurD6SzhUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47vwYaAug5zhUOLYwcurD6SzillG6E2_o0trcgjkDLZve4&skey=e33e83752eeadd54&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwYaAug5zhUOLYwcurD6Szgt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwYaAug5zhUOLYwcurD6SzgbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vwYaAug5zhUOLYwcurD6Szj5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Semi Condensed Bold Italic\'",
						"\'BarlowSemiCondensed-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v3nh8G9YVVb3xFzbTaI8ThJUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47v3nh8G9YVVb3xFzbTaI8ThKllG6E2_o0trcgjkDLZve4&skey=e2c2090b36dc074f&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v3nh8G9YVVb3xFzbTaI8ThIt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v3nh8G9YVVb3xFzbTaI8ThIbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v3nh8G9YVVb3xFzbTaI8ThL5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow Semi Condensed ExtraBold Italic\'",
						"\'BarlowSemiCondensed-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vxDUaDSv1S-TpBQ05PDlP3hUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47vxDUaDSv1S-TpBQ05PDlP3illG6E2_o0trcgjkDLZve4&skey=f6026191a779cdd8&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vxDUaDSv1S-TpBQ05PDlP3gt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vxDUaDSv1S-TpBQ05PDlP3gbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47vxDUaDSv1S-TpBQ05PDlP3j5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Semi Condensed Black Italic\'",
						"\'BarlowSemiCondensed-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v-gCkUyoKv_4NRiGfWDq7RRUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6QUBKs5dwYC2YezSXw47v-gCkUyoKv_4NRiGfWDq7RSllG6E2_o0trcgjkDLZve4&skey=b07d88c9fc4117ca&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v-gCkUyoKv_4NRiGfWDq7RQt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v-gCkUyoKv_4NRiGfWDq7RQbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/6QUBKs5dwYC2YezSXw47v-gCkUyoKv_4NRiGfWDq7RT5P7wK4alSGdJ7_atPdITf.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Barlow Semi Condensed Thin\'",
						"\'BarlowSemiCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlRmahUNotGdjm2Ol6aGySJE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rObwC0zkSDuhDJaXoDJAlcd3lQ0Zq4-ZnW8t9T3tPJY&skey=ace48cddecf20c8b&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlSxJ_JTb5el0Ppjrm-0hjMM.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAldDiZyNu74_BoKVTfzyYybc.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/rObwC0zkSDuhDJaXoDJAlRT_xdTPGhRFczcoKJqBt8I.woff2"
					}
				},
				"200": {
					"local": [
						"\'Barlow Semi Condensed ExtraLight\'",
						"\'BarlowSemiCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf_Q9lS_o7346kD7FAlvzI-v3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFfy9VKmmDb8Mp9RXDsBxOPPr3rGVtsTkPsbDajuO5ueQw&skey=3e30e3aa509ebc80&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf8duEGWNBNN-S2AbSZgeVrz3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf4ygVcJV2QBnGh8qOAwW5rn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfxW0W024EwMHRxmZfuY_nuL3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Barlow Semi Condensed Light\'",
						"\'BarlowSemiCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf2Wd9KR2C2cM8bQReFAw28D3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFf3AmPhGsY_Gl95qWI4smm873rGVtsTkPsbDajuO5ueQw&skey=bd33d44138e732d0&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf5CfZPfJpky_qGeFHM0zNWD3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfwPZRBeRMLwcSTzP_Mut-K73rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfwCx1EMbW1eFZOmb3pc2tbz3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Barlow Semi Condensed Regular\'",
						"\'BarlowSemiCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/Ok4yyskPwFvZPrXlQ7v903W5TFetRsmCWPgQ_1fJg50.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ok4yyskPwFvZPrXlQ7v90zzqHVLJvlsJOGCkOB4yeJo&skey=4fd3d18a82e3c26c&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/Ok4yyskPwFvZPrXlQ7v908wpCuwZUXUamS0_9Spumd4.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/Ok4yyskPwFvZPrXlQ7v900GJFlOJkO8mymA9tc33RXw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/Ok4yyskPwFvZPrXlQ7v908BvcTyoFVl2hWxSOgahpEY.woff2"
					}
				},
				"500": {
					"local": [
						"\'Barlow Semi Condensed Medium\'",
						"\'BarlowSemiCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf49fgX4Ac45MKpp6UbA8Lmb3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFfzKD9EjupQxr0_poxZA0YMD3rGVtsTkPsbDajuO5ueQw&skey=c94d986671e2b453&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf0QE11Ev1PY72twt0hy6pR73rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf3nKrYhZhwOSDoAJuZTxzPn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfxOR75kcDjfuuNgpyTcfx6P3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Barlow Semi Condensed SemiBold\'",
						"\'BarlowSemiCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf2BW24ZT7ws6ZjQLRyrHeFv3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFf0bzbRZiAP3f9BulJyPpAR_3rGVtsTkPsbDajuO5ueQw&skey=bacd0496a141e69c&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf11OHkx2X8doGCVPaei_JVf3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf0G6pymjL8bnnlcp-tN1f6r3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf7pQX8I2DyXG4uHm2BpGsSH3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Barlow Semi Condensed Bold\'",
						"\'BarlowSemiCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf_6CeLVY9wfEa4jvG67ma333rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFf8ePmP6A7DDVKcDskgRv23L3rGVtsTkPsbDajuO5ueQw&skey=2a71824e75b48834&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf2OHHJ7PHJ8i9QwwkhlT2jn3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfwP6At_oeljG2S-gQitEVPn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf_HD1jZSi8KUxQcwKVvxv1r3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Barlow Semi Condensed ExtraBold\'",
						"\'BarlowSemiCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf77wdVqcU-KDfXrziuNQqNz3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFf-CEzJKvl-ANxqMjbvTDdAL3rGVtsTkPsbDajuO5ueQw&skey=d87a0f7143698570&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf_XXftz7r481EfQC0ekJ8kr3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf7Pbm5I-tNZh8XdYKOc0ifL3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf8SZbXHNn1xNkePBld0xfIj3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Barlow Semi Condensed Black\'",
						"\'BarlowSemiCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfxuDkrGkiHMpHa_tk8jod-j3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZyxfuHr9OuBXRZHPDKRFf_tE2ziDo4Kg1ROTje6EKT33rGVtsTkPsbDajuO5ueQw&skey=64a0306e6faf6cdb&v=v1#BarlowSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFfwiBv0ofxCW9Ty785M0ocQr3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf2VykXXYmWLPJNFn4yYxeer3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/barlowsemicondensed/v1/ZyxfuHr9OuBXRZHPDKRFf4kF27DlXp6dWb0At9fH-RL3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				}
			}
		},
		"version": "v1"
	},
	"Barrio": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Barrio Regular\'",
						"\'Barrio-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/barrio/v2/k_6ic2-AcTfEemFiBZZywg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CWuFixqQDOSglQBCro1ohg&skey=ceb2e476735f1d8d&v=v2#Barrio",
						"ttf": "http://fonts.gstatic.com/s/barrio/v2/X4ToXSqxPxJGFSUk7teNRQ.ttf",
						"woff": "http://fonts.gstatic.com/s/barrio/v2/m2BCSbe7HXDbRhsu5roC8A.woff",
						"woff2": "http://fonts.gstatic.com/s/barrio/v2/qC9DkIiXyrH5oRNKaVpE0g.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Basic": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Basic Regular\'",
						"\'Basic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/basic/v7/J3xW8uf15MJfc3Wob1nx4w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=31czpOAei0AX0VKdw4lOEA&skey=9adfd48837ec6db7&v=v7#Basic",
						"ttf": "http://fonts.gstatic.com/s/basic/v7/o6rNQ4O3mMTvz3bHPzdNOw.ttf",
						"woff": "http://fonts.gstatic.com/s/basic/v7/Pqd6s-RedeRT8zQTRwM-ug.woff",
						"woff2": "http://fonts.gstatic.com/s/basic/v7/erYvY1QzK27EW53V1rJJeQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Battambang": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Battambang Regular\'",
						"\'Battambang-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/battambang/v11/ewJewYT_VoMtZm7d37qA4PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NusernixYRsrjlEV3msyl_esZW2xOQ-xsNqO47m55DA&skey=d567eed92f92816&v=v11#Battambang",
						"ttf": "http://fonts.gstatic.com/s/battambang/v11/MzrUfQLefYum5vVGM3EZVPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/battambang/v11/zMvvdaOrw1_VlpAAfy75uPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/battambang/v11/-boLAZju-VE7tbjGfNIvhCEAvth_LlrfE80CYdSH47w.woff2"
					}
				},
				"700": {
					"local": [
						"\'Battambang Bold\'",
						"\'Battambang-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/battambang/v11/dezbRtMzfzAA99DmrCYRMkiWpBgZM8QoQHJWqVarx_U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dezbRtMzfzAA99DmrCYRMoybYkat73PeprbWmx7wbqI&skey=fb8acf0440c31ce9&v=v11#Battambang",
						"ttf": "http://fonts.gstatic.com/s/battambang/v11/dezbRtMzfzAA99DmrCYRMgJKKGfqHaYFsRG-T3ceEVo.ttf",
						"woff": "http://fonts.gstatic.com/s/battambang/v11/dezbRtMzfzAA99DmrCYRMoSoAJ3FdnHwSRdilZRLja4.woff",
						"woff2": "http://fonts.gstatic.com/s/battambang/v11/dezbRtMzfzAA99DmrCYRMvWnocysYZ45olvT1UfrqLw.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Baumans": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Baumans Regular\'",
						"\'Baumans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/baumans/v7/M1Pz6VDL_fvakGH-ox_0mQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dzBoLh2cwd3hMJRMLw--iQ&skey=34ab2ddaf19de28&v=v7#Baumans",
						"ttf": "http://fonts.gstatic.com/s/baumans/v7/BiCYinjVo5CiJRvPKlJf5g.ttf",
						"woff": "http://fonts.gstatic.com/s/baumans/v7/3DEdKAl82M5rDSLBVcU5jA.woff",
						"woff2": "http://fonts.gstatic.com/s/baumans/v7/wUCl3MlBd3lTlYyjq93hYg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Bayon": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bayon Regular\'",
						"\'Bayon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bayon/v10/Hpp6sFkhhwAzZyrWoSL-LA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=e2ICEdh1lGWD1wwriYWZPQ&skey=1e586815f6dfd9b4&v=v10#Bayon",
						"ttf": "http://fonts.gstatic.com/s/bayon/v10/yTubusjTnpNRZwA4_50iVw.ttf",
						"woff": "http://fonts.gstatic.com/s/bayon/v10/2XSDpqJXgN0iy7Sn1OJW7A.woff",
						"woff2": "http://fonts.gstatic.com/s/bayon/v10/Thks0B0qKB-2l3O0RoUSlQ.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Belgrano": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Belgrano Regular\'",
						"\'Belgrano-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/belgrano/v8/v067ImGsrSB4gBJaxClasvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=F6CL3m7pQNlJuzbcbX1zC_esZW2xOQ-xsNqO47m55DA&skey=f8342c8dd44d2a61&v=v8#Belgrano",
						"ttf": "http://fonts.gstatic.com/s/belgrano/v8/t4vQ3pjZPqeEBIlcI552R_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/belgrano/v8/9nICvxZmkDv7_ninPVYjofesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/belgrano/v8/GRNc1JaQ0xFKocBu6SI7lvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Bellefair": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"hebrew",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bellefair Regular\'",
						"\'Bellefair-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bellefair/v3/UZvXKFPdIOj0v2HvByNGSfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UZvXKFPdIOj0v2HvByNGSZbd9NUM7myrQQz30yPaGQ4&skey=5e2608507b793d9a&v=v3#Bellefair",
						"ttf": "http://fonts.gstatic.com/s/bellefair/v3/UZvXKFPdIOj0v2HvByNGSaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/bellefair/v3/UZvXKFPdIOj0v2HvByNGST8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/bellefair/v3/UZvXKFPdIOj0v2HvByNGSVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Belleza": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Belleza Regular\'",
						"\'Belleza-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/belleza/v6/6vro92rxXIoeIhMkLHqPOg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oSuXS040tqW2W1yFdspWXw&skey=5d3d5d4aa7c98655&v=v6#Belleza",
						"ttf": "http://fonts.gstatic.com/s/belleza/v6/0PM4qwfASmAB2sOtSkd0vQ.ttf",
						"woff": "http://fonts.gstatic.com/s/belleza/v6/hrFuBwXjCvf5Qp3q0X6-3Q.woff",
						"woff2": "http://fonts.gstatic.com/s/belleza/v6/I8LNHlDzrs_tdd1DZmKgcQ.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"BenchNine": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'BenchNine Light\'",
						"\'BenchNine-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/benchnine/v6/ah9xtUy9wLQ3qnWa2p-piXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ah9xtUy9wLQ3qnWa2p-piVlIn5tFQcqMuf-jhyJP0ps&skey=aa9e2137948a9eff&v=v6#BenchNine",
						"ttf": "http://fonts.gstatic.com/s/benchnine/v6/ah9xtUy9wLQ3qnWa2p-piYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/benchnine/v6/ah9xtUy9wLQ3qnWa2p-piXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/benchnine/v6/ah9xtUy9wLQ3qnWa2p-piegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'BenchNine Regular\'",
						"\'BenchNine-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/benchnine/v6/xmB9oJNpSFKa3qTF2JABPvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xmB9oJNpSFKa3qTF2JABPpbd9NUM7myrQQz30yPaGQ4&skey=f6d31822b7395c1d&v=v6#BenchNine",
						"ttf": "http://fonts.gstatic.com/s/benchnine/v6/xmB9oJNpSFKa3qTF2JABPqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/benchnine/v6/xmB9oJNpSFKa3qTF2JABPj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/benchnine/v6/xmB9oJNpSFKa3qTF2JABPltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'BenchNine Bold\'",
						"\'BenchNine-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/benchnine/v6/qZpi6ZVZg3L2RL_xoBLxWXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qZpi6ZVZg3L2RL_xoBLxWVlIn5tFQcqMuf-jhyJP0ps&skey=2988da53b00b93d9&v=v6#BenchNine",
						"ttf": "http://fonts.gstatic.com/s/benchnine/v6/qZpi6ZVZg3L2RL_xoBLxWYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/benchnine/v6/qZpi6ZVZg3L2RL_xoBLxWXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/benchnine/v6/qZpi6ZVZg3L2RL_xoBLxWegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bentham": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bentham Regular\'",
						"\'Bentham-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bentham/v8/WwY2xS8FrH2ze7cCeFvj0Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WK6YRgLjdcKzid3PckZF6g&skey=65ea27bccb65e6d3&v=v8#Bentham",
						"ttf": "http://fonts.gstatic.com/s/bentham/v8/bNMs0W99XSO_uhoBJof6Tg.ttf",
						"woff": "http://fonts.gstatic.com/s/bentham/v8/dqPr9SsyZ_l7ze5xtGNhEA.woff",
						"woff2": "http://fonts.gstatic.com/s/bentham/v8/SVc3EWThHQ2hzWZPpEYHFw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Berkshire Swash": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Berkshire Swash Regular\'",
						"\'BerkshireSwash-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/berkshireswash/v6/4RZJjVRPjYnC2939hKCAiqOBehv9MKDC-WdEauEvkas.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4RZJjVRPjYnC2939hKCAiqrdrgbzBBOb84dUB3SFzTA&skey=6b24d6a69858ae6f&v=v6#BerkshireSwash",
						"ttf": "http://fonts.gstatic.com/s/berkshireswash/v6/4RZJjVRPjYnC2939hKCAitJftMAoj96Wrc4hVDPiTSk.ttf",
						"woff": "http://fonts.gstatic.com/s/berkshireswash/v6/4RZJjVRPjYnC2939hKCAio7PDNlca4RILyZXFX2_UPk.woff",
						"woff2": "http://fonts.gstatic.com/s/berkshireswash/v6/4RZJjVRPjYnC2939hKCAiiJH4brlqpr7zMNWu0xQjN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bevan": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bevan Regular\'",
						"\'Bevan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bevan/v9/ZRUOnkoGzgM5n00L6uhVOg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=m619AKwEDmn_WiI-vs6t0g&skey=7503fb07de04c1e8&v=v9#Bevan",
						"ttf": "http://fonts.gstatic.com/s/bevan/v9/tUrrMQoBrJbKyZFfX9xzeQ.ttf",
						"woff": "http://fonts.gstatic.com/s/bevan/v9/kZxOvEFDTL6rhtQAWC2LTw.woff",
						"woff2": "http://fonts.gstatic.com/s/bevan/v9/xVgMFoVwWQJuO7wo0FBeTQ.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Bigelow Rules": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bigelow Rules Regular\'",
						"\'BigelowRules-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bigelowrules/v6/FEJCPLwo07FS-6SK6Al50bSL3g004LNKkgHM9a6X73A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FEJCPLwo07FS-6SK6Al50TjR3xVPJpEcWH1UXm1-s8c&skey=69b430202a6d5e56&v=v6#BigelowRules",
						"ttf": "http://fonts.gstatic.com/s/bigelowrules/v6/FEJCPLwo07FS-6SK6Al50YB9a16epZVaac-gfobfbfA.ttf",
						"woff": "http://fonts.gstatic.com/s/bigelowrules/v6/FEJCPLwo07FS-6SK6Al50dUFqmyT-Ih543PWa_C0ig4.woff",
						"woff2": "http://fonts.gstatic.com/s/bigelowrules/v6/FEJCPLwo07FS-6SK6Al50cmBRJoLbs7X6hY7yFEc97Q.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bigshot One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bigshot One Regular\'",
						"\'BigshotOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bigshotone/v8/bWykSiy19zUrP0LR0jRzqmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bWykSiy19zUrP0LR0jRzqnNsigHlcrQGNV8nkUSFQfc&skey=4a9efbaa7702e0cd&v=v8#BigshotOne",
						"ttf": "http://fonts.gstatic.com/s/bigshotone/v8/bWykSiy19zUrP0LR0jRzqp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/bigshotone/v8/bWykSiy19zUrP0LR0jRzqobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/bigshotone/v8/bWykSiy19zUrP0LR0jRzqo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Bilbo": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bilbo Regular\'",
						"\'Bilbo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bilbo/v7/nTFC6WgKVR0WRJPiYKUePQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tfUKmsVEk8VGKjy5f4votQ&skey=e7e54f852a89dcca&v=v7#Bilbo",
						"ttf": "http://fonts.gstatic.com/s/bilbo/v7/JqdbkZoDKENg_4351JtArw.ttf",
						"woff": "http://fonts.gstatic.com/s/bilbo/v7/xwLgRJ9fZWeUWclu8zW0Jw.woff",
						"woff2": "http://fonts.gstatic.com/s/bilbo/v7/5aGpX5nQulSNzcm0el3EFg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Bilbo Swash Caps": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bilbo Swash Caps Regular\'",
						"\'BilboSwashCaps-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bilboswashcaps/v9/UB_-crLvhx-PwGKW1oosDojgZ9peH1h5QMCNTsgEYXY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UB_-crLvhx-PwGKW1oosDjf0pPzpG0bOLDeScyGvyOo&skey=4b5cb4349bc795ce&v=v9#BilboSwashCaps",
						"ttf": "http://fonts.gstatic.com/s/bilboswashcaps/v9/UB_-crLvhx-PwGKW1oosDr696hY-neTbCTvwDUFvtCU.ttf",
						"woff": "http://fonts.gstatic.com/s/bilboswashcaps/v9/UB_-crLvhx-PwGKW1oosDpbko4ywDBcg2f1uYutDOWY.woff",
						"woff2": "http://fonts.gstatic.com/s/bilboswashcaps/v9/UB_-crLvhx-PwGKW1oosDhj-AqoPRuAbf1eZyhj8Aik.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"BioRhyme": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'BioRhyme ExtraLight\'",
						"\'BioRhyme-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhyme/v2/8PENM1xlKxCwj8zwn-dubGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8PENM1xlKxCwj8zwn-dubHNsigHlcrQGNV8nkUSFQfc&skey=b770df1c76efb37a&v=v2#BioRhyme",
						"ttf": "http://fonts.gstatic.com/s/biorhyme/v2/8PENM1xlKxCwj8zwn-dubJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhyme/v2/8PENM1xlKxCwj8zwn-dubIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhyme/v2/8PENM1xlKxCwj8zwn-dubI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"300": {
					"local": [
						"\'BioRhyme Light\'",
						"\'BioRhyme-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhyme/v2/Bt4eodSGwKvNcy5x_hFyG2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Bt4eodSGwKvNcy5x_hFyG3NsigHlcrQGNV8nkUSFQfc&skey=b22aaff48d1f5527&v=v2#BioRhyme",
						"ttf": "http://fonts.gstatic.com/s/biorhyme/v2/Bt4eodSGwKvNcy5x_hFyG50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhyme/v2/Bt4eodSGwKvNcy5x_hFyG4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhyme/v2/Bt4eodSGwKvNcy5x_hFyG44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'BioRhyme\'",
						"\'BioRhyme-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhyme/v2/fpZJKesDNf9-CruqfdPfIfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CQRHI9CYOySbxAvFB41C6fesZW2xOQ-xsNqO47m55DA&skey=5c2e0a2fcee9a1a&v=v2#BioRhyme",
						"ttf": "http://fonts.gstatic.com/s/biorhyme/v2/TOLJ1VhAVywbbukzLZqGVvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhyme/v2/L41PikHsTGYLPrd7ye--KPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhyme/v2/o8HZwUo94r0h4FpPcSJnyPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'BioRhyme Bold\'",
						"\'BioRhyme-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhyme/v2/o-NqezqhXmCZNt8g452HVGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o-NqezqhXmCZNt8g452HVHNsigHlcrQGNV8nkUSFQfc&skey=469c34d0ca09d4cf&v=v2#BioRhyme",
						"ttf": "http://fonts.gstatic.com/s/biorhyme/v2/o-NqezqhXmCZNt8g452HVJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhyme/v2/o-NqezqhXmCZNt8g452HVIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhyme/v2/o-NqezqhXmCZNt8g452HVI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"800": {
					"local": [
						"\'BioRhyme ExtraBold\'",
						"\'BioRhyme-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhyme/v2/WJLgCRiLj42QC0qEUB5V7mfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WJLgCRiLj42QC0qEUB5V7nNsigHlcrQGNV8nkUSFQfc&skey=f09fd4818fd3b385&v=v2#BioRhyme",
						"ttf": "http://fonts.gstatic.com/s/biorhyme/v2/WJLgCRiLj42QC0qEUB5V7p0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhyme/v2/WJLgCRiLj42QC0qEUB5V7obN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhyme/v2/WJLgCRiLj42QC0qEUB5V7o4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"BioRhyme Expanded": {
		"category": "serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'BioRhyme Expanded ExtraLight\'",
						"\'BioRhymeExpanded-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sPlmLCBPoKXV9svxlyPMCn0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FKL4Vyxmq2vsiDrSOzz2sLEU0FOgG-7qeyBGFA3jXsM&skey=2ee2f92b51b2cab0&v=v3#BioRhymeExpanded",
						"ttf": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sMFZc4im5vwa_N_X-96IJko.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sGObUXoQpmp3V6hoyr9A47o.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sCqitJ4H7gG-nHBbLyZKSgA.woff2"
					}
				},
				"300": {
					"local": [
						"\'BioRhyme Expanded Light\'",
						"\'BioRhymeExpanded-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sGxX4Hs50sljm02KQWUs89M.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FKL4Vyxmq2vsiDrSOzz2sO-qJRT-JqRiOlMnALh-ALw&skey=82d719d5376a72cd&v=v3#BioRhymeExpanded",
						"ttf": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sIVSQDndEp5eT_xjnDNlO_I.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sKgBlojHHURJZsFi4Wg6DJI.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sAIdNe45QOtwBFrGFQaYX5o.woff2"
					}
				},
				"400": {
					"local": [
						"\'BioRhyme Expanded\'",
						"\'BioRhymeExpanded-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/hgBNpgjTRZzGmZxqN5OuVk50bRxqigKf9fWU0o0-_JE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hgBNpgjTRZzGmZxqN5OuVlaDQ0MHoOXk1lTusVDHkiQ&skey=68cf7f02649a6f07&v=v3#BioRhymeExpanded",
						"ttf": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/hgBNpgjTRZzGmZxqN5OuVtGEjQp4JD0DAUG6pL_kaJk.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/hgBNpgjTRZzGmZxqN5OuVoNsCvf5hp9NftZYsPE9WCE.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/hgBNpgjTRZzGmZxqN5OuVrbU4A41vuumJT94tvlmfnc.woff2"
					}
				},
				"700": {
					"local": [
						"\'BioRhyme Expanded Bold\'",
						"\'BioRhymeExpanded-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sKTS4lt7Y77y-iD28s_XdQY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FKL4Vyxmq2vsiDrSOzz2sE2p2Fcuu8hzAQ5PurDseXY&skey=65889839f6d4c40c&v=v3#BioRhymeExpanded",
						"ttf": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sNXrNOWhdfthpov6Vh7I3do.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sA7C4Ux8BZBTcJXAikuybOo.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sL34UOxZgNmwP6eJZEVpadU.woff2"
					}
				},
				"800": {
					"local": [
						"\'BioRhyme Expanded ExtraBold\'",
						"\'BioRhymeExpanded-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sHeTyDrv5ipIuRHjrwOHU2E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FKL4Vyxmq2vsiDrSOzz2sHOzhR0JTyuYio4NyPkO8cw&skey=86188f2ec7a88ec9&v=v3#BioRhymeExpanded",
						"ttf": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sBOvTW2pkahurR_f7VyDUCI.ttf",
						"woff": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sHHbPQOK2CK57o-mGZW320g.woff",
						"woff2": "http://fonts.gstatic.com/s/biorhymeexpanded/v3/FKL4Vyxmq2vsiDrSOzz2sGaHwRqQQctg74DJJhpeVd4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Biryani": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Biryani ExtraLight\'",
						"\'Biryani-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/oxYoIFfNqFpH9IpwOV5fkVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oxYoIFfNqFpH9IpwOV5fkaWUboTb-jS2tyCOQMtm97g&skey=d42b7163daf22ee9&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/oxYoIFfNqFpH9IpwOV5fkS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/oxYoIFfNqFpH9IpwOV5fkRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/oxYoIFfNqFpH9IpwOV5fkfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Biryani Light\'",
						"\'Biryani-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/e2qWBhmcwG_j1k44Tm68dVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=e2qWBhmcwG_j1k44Tm68daWUboTb-jS2tyCOQMtm97g&skey=e54893269db4ddbe&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/e2qWBhmcwG_j1k44Tm68dS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/e2qWBhmcwG_j1k44Tm68dRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/e2qWBhmcwG_j1k44Tm68dfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Biryani Regular\'",
						"\'Biryani-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/s5-4Y19u4czgvzEDlTkWpw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jqnK_baMSzsFVN5iUGR7Eg&skey=2357f49981935149&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/E2eZ6gDqHsQctcgNMH1j7w.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/Nb7L-GDR6HkW6vZ2T1Wxlw.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/N-IFae6zoZ0D538ycERbVQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Biryani SemiBold\'",
						"\'Biryani-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/sudO3ui8h0hKk9hm4TaoQ1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sudO3ui8h0hKk9hm4TaoQ6WUboTb-jS2tyCOQMtm97g&skey=ee13aa13f636c74f&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/sudO3ui8h0hKk9hm4TaoQy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/sudO3ui8h0hKk9hm4TaoQxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/sudO3ui8h0hKk9hm4TaoQ_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Biryani Bold\'",
						"\'Biryani-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/ZqfQVaAaPmtKNSJN4ziqslQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZqfQVaAaPmtKNSJN4ziqsqWUboTb-jS2tyCOQMtm97g&skey=5fc70b714608548d&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/ZqfQVaAaPmtKNSJN4ziqsi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/ZqfQVaAaPmtKNSJN4ziqshsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/ZqfQVaAaPmtKNSJN4ziqsvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"800": {
					"local": [
						"\'Biryani ExtraBold\'",
						"\'Biryani-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/cJ4Ij9Z_fMLiglmcqwLkf1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cJ4Ij9Z_fMLiglmcqwLkf6WUboTb-jS2tyCOQMtm97g&skey=1ca99bb6f7b098ac&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/cJ4Ij9Z_fMLiglmcqwLkfy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/cJ4Ij9Z_fMLiglmcqwLkfxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/cJ4Ij9Z_fMLiglmcqwLkf_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"900": {
					"local": [
						"\'Biryani Black\'",
						"\'Biryani-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/biryani/v3/zesSxRLKV_fx-Z23Oa-YN1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zesSxRLKV_fx-Z23Oa-YN6WUboTb-jS2tyCOQMtm97g&skey=87a891a314ca2a5c&v=v3#Biryani",
						"ttf": "http://fonts.gstatic.com/s/biryani/v3/zesSxRLKV_fx-Z23Oa-YNy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/biryani/v3/zesSxRLKV_fx-Z23Oa-YNxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/biryani/v3/zesSxRLKV_fx-Z23Oa-YN_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Bitter": {
		"category": "serif",
		"lastModified": "2017-10-11",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Bitter Italic\'",
						"\'Bitter-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bitter/v12/_5gUH5fHSDnpRupSlBdtgfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ORW2p5cHVPQkt0uy5woGCPesZW2xOQ-xsNqO47m55DA&skey=7ce735f7301da1b7&v=v12#Bitter",
						"ttf": "http://fonts.gstatic.com/s/bitter/v12/E44LYN4bXPiBT-TMwacNsvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/bitter/v12/eMS0tViDqryBl0EG1pqFZfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/bitter/v12/-t3SK6sofTjAH0MNf_tLaPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Bitter Regular\'",
						"\'Bitter-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bitter/v12/XexqN1a_o27MhVVdJFKAcA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GczfTD6N3Eo3_EcQuBd3Kg&skey=c92268a3e57ee309&v=v12#Bitter",
						"ttf": "http://fonts.gstatic.com/s/bitter/v12/2hig-tnMw8lXZsjwuh-9ow.ttf",
						"woff": "http://fonts.gstatic.com/s/bitter/v12/SHIcXhdd5RknatSgOzyEkA.woff",
						"woff2": "http://fonts.gstatic.com/s/bitter/v12/zfs6I-5mjWQ3nxqccMoL2A.woff2"
					}
				},
				"700": {
					"local": [
						"\'Bitter Bold\'",
						"\'Bitter-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bitter/v12/evC1haE-MsorTl_A7_uSGfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=evC1haE-MsorTl_A7_uSGZbd9NUM7myrQQz30yPaGQ4&skey=e4df9b9066e26755&v=v12#Bitter",
						"ttf": "http://fonts.gstatic.com/s/bitter/v12/evC1haE-MsorTl_A7_uSGaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/bitter/v12/evC1haE-MsorTl_A7_uSGT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/bitter/v12/evC1haE-MsorTl_A7_uSGVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Black Ops One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Black Ops One Regular\'",
						"\'BlackOpsOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/blackopsone/v9/2XW-DmDsGbDLE372KrMW1cOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2XW-DmDsGbDLE372KrMW1TyKAGS2js9R2mTcvyyc0eU&skey=66ec0066d463fba3&v=v9#BlackOpsOne",
						"ttf": "http://fonts.gstatic.com/s/blackopsone/v9/2XW-DmDsGbDLE372KrMW1SbsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/blackopsone/v9/2XW-DmDsGbDLE372KrMW1fn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/blackopsone/v9/2XW-DmDsGbDLE372KrMW1TxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Bokor": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bokor Regular\'",
						"\'Bokor-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bokor/v10/yQ6LCAxoPXyKjlSdetER7Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=c6JDkGRA3cLUdHGptO2fvw&skey=f01afff5b5de54ac&v=v10#Bokor",
						"ttf": "http://fonts.gstatic.com/s/bokor/v10/uAKdo0A85WW23Gs6mcbw7A.ttf",
						"woff": "http://fonts.gstatic.com/s/bokor/v10/ZhwJwSeQ7AuVIZsaOMoAJw.woff",
						"woff2": "http://fonts.gstatic.com/s/bokor/v10/yzjpsRYoViYRhVzrLlT9Kg.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Bonbon": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bonbon Regular\'",
						"\'Bonbon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bonbon/v9/ZVCFzPWp3BI0WP7tXpQhkA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l3on1p-hrJ1940uqIOfD5g&skey=794577c46d82d6ca&v=v9#Bonbon",
						"ttf": "http://fonts.gstatic.com/s/bonbon/v9/9qzVs2zQIGc_kQRGJHxpuA.ttf",
						"woff": "http://fonts.gstatic.com/s/bonbon/v9/hOqJBDKovmA8TS8zD7XUXA.woff",
						"woff2": "http://fonts.gstatic.com/s/bonbon/v9/9Y-vWjaZMFbrz3brizYoHQ.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Boogaloo": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Boogaloo Regular\'",
						"\'Boogaloo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/boogaloo/v8/T5vB8h5AY7XmkrpRXqdjXvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uqVN5_3IdSyi71ddWH-mRPesZW2xOQ-xsNqO47m55DA&skey=1670c69be039349f&v=v8#Boogaloo",
						"ttf": "http://fonts.gstatic.com/s/boogaloo/v8/roBhx8S2P1QWF7rF8SGCRvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/boogaloo/v8/1x_XysQB9ZwoSzu9a0nb7PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/boogaloo/v8/selWIQWiQA98uHaoODndYvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Bowlby One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bowlby One Regular\'",
						"\'BowlbyOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bowlbyone/v9/xBO3ZdzVBqGO6i8GOIrhUFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xBO3ZdzVBqGO6i8GOIrhUKWUboTb-jS2tyCOQMtm97g&skey=1fef044be6189a97&v=v9#BowlbyOne",
						"ttf": "http://fonts.gstatic.com/s/bowlbyone/v9/xBO3ZdzVBqGO6i8GOIrhUC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/bowlbyone/v9/xBO3ZdzVBqGO6i8GOIrhUBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/bowlbyone/v9/xBO3ZdzVBqGO6i8GOIrhUPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Bowlby One SC": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bowlby One SC Regular\'",
						"\'BowlbyOneSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bowlbyonesc/v9/8ZkeXftTuzKBtmxOYXoReXEHD5li9PMijZ6B4YsDdZw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8ZkeXftTuzKBtmxOYXoReYqXK8-HOb25u2kT6LC2gU8&skey=434092f596a4d5b0&v=v9#BowlbyOneSC",
						"ttf": "http://fonts.gstatic.com/s/bowlbyonesc/v9/8ZkeXftTuzKBtmxOYXoReWwgCUWMlcoGHIqZ0R9q_Yo.ttf",
						"woff": "http://fonts.gstatic.com/s/bowlbyonesc/v9/8ZkeXftTuzKBtmxOYXoReXSZ6Kd_eOJbDsY1hLBynIs.woff",
						"woff2": "http://fonts.gstatic.com/s/bowlbyonesc/v9/8ZkeXftTuzKBtmxOYXoReUcyF0ms21OVlsdkK-jCtv8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Brawler": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Brawler Regular\'",
						"\'Brawler-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/brawler/v8/M83j5vhv5Lz3L9d1vBNPPA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2GmlQFkDu4oP7s6nuS7EtQ&skey=d6959d3271c8006d&v=v8#Brawler",
						"ttf": "http://fonts.gstatic.com/s/brawler/v8/dUNrB5J6luCtowhEI_D1yw.ttf",
						"woff": "http://fonts.gstatic.com/s/brawler/v8/RuR7cMLAfNlP0yo6tYRcjw.woff",
						"woff2": "http://fonts.gstatic.com/s/brawler/v8/eRM1_WMBWa9Dh9ANISFGxA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Bree Serif": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bree Serif Regular\'",
						"\'BreeSerif-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/breeserif/v7/LQ7WLTaITDg4OSRuOZCps1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LQ7WLTaITDg4OSRuOZCps6WUboTb-jS2tyCOQMtm97g&skey=31c3ad25dd3d74b0&v=v7#BreeSerif",
						"ttf": "http://fonts.gstatic.com/s/breeserif/v7/LQ7WLTaITDg4OSRuOZCpsy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/breeserif/v7/LQ7WLTaITDg4OSRuOZCpsxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/breeserif/v7/LQ7WLTaITDg4OSRuOZCps_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Bubblegum Sans": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bubblegum Sans Regular\'",
						"\'BubblegumSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bubblegumsans/v6/Y9iTUUNz6lbl6TrvV4iws7o0qD8dyKtPpeulUES2XU8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Y9iTUUNz6lbl6TrvV4iws4C12HMloxVRD5dJDpo9SiM&skey=907fcf96211c8e7e&v=v6#BubblegumSans",
						"ttf": "http://fonts.gstatic.com/s/bubblegumsans/v6/Y9iTUUNz6lbl6TrvV4iws8XM2d2VFbe-fvcRchVhQTM.ttf",
						"woff": "http://fonts.gstatic.com/s/bubblegumsans/v6/Y9iTUUNz6lbl6TrvV4iws3XDLzkeTJI1q7uv6LMmp4I.woff",
						"woff2": "http://fonts.gstatic.com/s/bubblegumsans/v6/Y9iTUUNz6lbl6TrvV4iwsy93Cb99RdxE7CvnuFJW9ZQ.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Bubbler One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bubbler One Regular\'",
						"\'BubblerOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bubblerone/v6/tiAxK_A8SViEcY0M590QMGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tiAxK_A8SViEcY0M590QMHNsigHlcrQGNV8nkUSFQfc&skey=5d82c961a83b9bd&v=v6#BubblerOne",
						"ttf": "http://fonts.gstatic.com/s/bubblerone/v6/tiAxK_A8SViEcY0M590QMJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/bubblerone/v6/tiAxK_A8SViEcY0M590QMIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/bubblerone/v6/tiAxK_A8SViEcY0M590QMI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Buda": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Buda Light\'",
						"\'Buda-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/buda/v8/xpKVHc19vcKaqMGd7JtK-A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qaD7BvHFyPvJ40OuWoVUkw&skey=b7e64cadd1bf937&v=v8#Buda",
						"ttf": "http://fonts.gstatic.com/s/buda/v8/In5nPPB6p1Mco64syFRrYQ.ttf",
						"woff": "http://fonts.gstatic.com/s/buda/v8/3N6IHhwL9GuAVU1WX0Z9CA.woff",
						"woff2": "http://fonts.gstatic.com/s/buda/v8/AN-BVxpb4laJkzck9W-0oA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Buenard": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Buenard Regular\'",
						"\'Buenard-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/buenard/v9/OC-Cu6cSYC8dXQNMsxgghQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o2Bzn1LAWE3O5Vc-F2hCBg&skey=9765affe45fa9583&v=v9#Buenard",
						"ttf": "http://fonts.gstatic.com/s/buenard/v9/UUYHasP8umGDjV-yeZf27Q.ttf",
						"woff": "http://fonts.gstatic.com/s/buenard/v9/duJQeQ_GjW4qq4zzf0vRKw.woff",
						"woff2": "http://fonts.gstatic.com/s/buenard/v9/pL67HhOcrNoD2s7WUgFytw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Buenard Bold\'",
						"\'Buenard-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/buenard/v9/8T0adwz_RAtKrxbccQmEFFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8T0adwz_RAtKrxbccQmEFKWUboTb-jS2tyCOQMtm97g&skey=f0ec52c5a48bc809&v=v9#Buenard",
						"ttf": "http://fonts.gstatic.com/s/buenard/v9/8T0adwz_RAtKrxbccQmEFC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/buenard/v9/8T0adwz_RAtKrxbccQmEFBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/buenard/v9/8T0adwz_RAtKrxbccQmEFPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Bungee": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bungee\'",
						"\'Bungee-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bungee/v3/BcKBM0mj2kaPJP86MB2syA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=F8tXYvLjQD9TLFWFMmacIw&skey=2e93db42ee6e0e28&v=v3#Bungee",
						"ttf": "http://fonts.gstatic.com/s/bungee/v3/jD305lv5cIyN5QGZ-yb5kA.ttf",
						"woff": "http://fonts.gstatic.com/s/bungee/v3/iPjVYMEYLrDbySIAkaV-6Q.woff",
						"woff2": "http://fonts.gstatic.com/s/bungee/v3/86NbnFpNqZ2MU9Gl0ca2YQ.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Bungee Hairline": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bungee Hairline\'",
						"\'BungeeHairline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bungeehairline/v3/8Li3dr3whdkxuk7pmLaZae2BvNrjPmV21HOOxpMuwLY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8Li3dr3whdkxuk7pmLaZaeERsTPaSC8-zM_v3rR707U&skey=f83e9a70b2ed1d60&v=v3#BungeeHairline",
						"ttf": "http://fonts.gstatic.com/s/bungeehairline/v3/8Li3dr3whdkxuk7pmLaZaTZ6Y9WhilnvSkF-e4PL1VU.ttf",
						"woff": "http://fonts.gstatic.com/s/bungeehairline/v3/8Li3dr3whdkxuk7pmLaZaRbCU4MDjf4zU_LEnYVwYKM.woff",
						"woff2": "http://fonts.gstatic.com/s/bungeehairline/v3/8Li3dr3whdkxuk7pmLaZaSEu6yHhoRsIyg4oT7lcpIU.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Bungee Inline": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bungee Inline\'",
						"\'BungeeInline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bungeeinline/v3/Tb-1914q4rFpjT-F66PLCcOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Tb-1914q4rFpjT-F66PLCTyKAGS2js9R2mTcvyyc0eU&skey=ff5b0f9d1988133a&v=v3#BungeeInline",
						"ttf": "http://fonts.gstatic.com/s/bungeeinline/v3/Tb-1914q4rFpjT-F66PLCSbsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/bungeeinline/v3/Tb-1914q4rFpjT-F66PLCfn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/bungeeinline/v3/Tb-1914q4rFpjT-F66PLCTxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Bungee Outline": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bungee Outline\'",
						"\'BungeeOutline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bungeeoutline/v3/PcidvzXIcqS2Qwxm_iG6bIkC0q2UIPzTXmpGZwqdhC4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PcidvzXIcqS2Qwxm_iG6bPiFMTO6HOLVf1dlsvjpc4M&skey=29f00acf17ba0cd1&v=v3#BungeeOutline",
						"ttf": "http://fonts.gstatic.com/s/bungeeoutline/v3/PcidvzXIcqS2Qwxm_iG6bLNaArye8TuzckrIYf518s0.ttf",
						"woff": "http://fonts.gstatic.com/s/bungeeoutline/v3/PcidvzXIcqS2Qwxm_iG6bFBxJKh6yxKNX9gPkQCEJy8.woff",
						"woff2": "http://fonts.gstatic.com/s/bungeeoutline/v3/PcidvzXIcqS2Qwxm_iG6bA3XTT7BThT0FYsE7P8VY8A.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Bungee Shade": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Bungee Shade\'",
						"\'BungeeShade-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/bungeeshade/v3/HSW7pxPYXBWkq7OSnuXoeHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HSW7pxPYXBWkq7OSnuXoeFlIn5tFQcqMuf-jhyJP0ps&skey=fbfaf26ed37f085b&v=v3#BungeeShade",
						"ttf": "http://fonts.gstatic.com/s/bungeeshade/v3/HSW7pxPYXBWkq7OSnuXoeInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/bungeeshade/v3/HSW7pxPYXBWkq7OSnuXoeHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/bungeeshade/v3/HSW7pxPYXBWkq7OSnuXoeOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Butcherman": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Butcherman Regular\'",
						"\'Butcherman-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/butcherman/v9/8FC9zd4HohxQSKgha-UqjlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8FC9zd4HohxQSKgha-UqjqWUboTb-jS2tyCOQMtm97g&skey=a81c66da830bfcb3&v=v9#Butcherman",
						"ttf": "http://fonts.gstatic.com/s/butcherman/v9/8FC9zd4HohxQSKgha-Uqji3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/butcherman/v9/8FC9zd4HohxQSKgha-UqjhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/butcherman/v9/8FC9zd4HohxQSKgha-Uqjvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Butterfly Kids": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Butterfly Kids Regular\'",
						"\'ButterflyKids-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/butterflykids/v6/J4NTF5M25htqeTffYImtlYpOAJdO9nkagmUSEM7gDrc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=J4NTF5M25htqeTffYImtlXs52E2uP2M47QIDnR9gdR8&skey=95db184ef744e9e3&v=v6#ButterflyKids",
						"ttf": "http://fonts.gstatic.com/s/butterflykids/v6/J4NTF5M25htqeTffYImtlVo6F99OH7rnGX5nAcy-AHg.ttf",
						"woff": "http://fonts.gstatic.com/s/butterflykids/v6/J4NTF5M25htqeTffYImtlaVF-6wXXIN314UpPArUKH4.woff",
						"woff2": "http://fonts.gstatic.com/s/butterflykids/v6/J4NTF5M25htqeTffYImtlbVk06n3quXtKPBYL-zeZ0w.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Cabin": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cabin Italic\'",
						"\'Cabin-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/mOLawYJy7-OC1-rKIVMBSQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BHS7p0gcrQK6fgLWORZ4Cg&skey=72a025bcae5df692&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/Et-v_QIck3adV65yIaqlhg.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/jZSwn9gMgsQpyndNljYDIw.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/00o5zQ7GoPVPMQsCfDCAnw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cabin Medium Italic\'",
						"\'Cabin-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/l3VlC5SZU-ZceiU15Vs2gFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l3VlC5SZU-ZceiU15Vs2gKWUboTb-jS2tyCOQMtm97g&skey=9f6d89d3a095f515&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/l3VlC5SZU-ZceiU15Vs2gC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/l3VlC5SZU-ZceiU15Vs2gBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/l3VlC5SZU-ZceiU15Vs2gPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cabin SemiBold Italic\'",
						"\'Cabin-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/Sn-0zpaF2c3wYt9xdgoYFVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Sn-0zpaF2c3wYt9xdgoYFaWUboTb-jS2tyCOQMtm97g&skey=5564bd08dc7fbe67&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/Sn-0zpaF2c3wYt9xdgoYFS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/Sn-0zpaF2c3wYt9xdgoYFRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/Sn-0zpaF2c3wYt9xdgoYFfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cabin Bold Italic\'",
						"\'Cabin-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/Ww23LQNlhn4dAm9uegPaX1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ww23LQNlhn4dAm9uegPaX6WUboTb-jS2tyCOQMtm97g&skey=ebc162262801060b&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/Ww23LQNlhn4dAm9uegPaXy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/Ww23LQNlhn4dAm9uegPaXxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/Ww23LQNlhn4dAm9uegPaX_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cabin\'",
						"\'Cabin-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/ClwGbaMfQ5c9QfM1bHNo1g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=reMsvhLtR_NipjCwZGPJyg&skey=d53a2c61c6b52b74&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/K6ngFdK5haaaRGBV8waDwA.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/JEgmtEDzc-IH8jBshQXrYA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/yQOMOX5hR0-6LTD879t-PQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cabin Medium\'",
						"\'Cabin-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/z3_LOr6ZZJ2VLNF3Csp42fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Jpa0St5xIM81Wt9aw1myvvesZW2xOQ-xsNqO47m55DA&skey=f79bd67cc4cfa68b&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/187TYb8ysVvxar86IcDsZ_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/km2iCywk7CnC11BE8pBNVPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/XHvvZj_uvRvYentxl9M1VvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cabin SemiBold\'",
						"\'Cabin-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/LFrn8lNsj_p1XCA7V0gJlfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LNlk3w_b81a4tP7z49bcr_esZW2xOQ-xsNqO47m55DA&skey=7553d1dffc73cbfc&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/TNtGAwzXtCEY_5hzRlIJNPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/bSicyj3YibVhVPhGZyWVI_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/pOvYyCQeTTtw6RxdlpulSvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cabin Bold\'",
						"\'Cabin-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabin/v12/0rwIbxvBLLkZ3TvRndzblvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mJjUNQHbVFvcEpZzGlJ9HfesZW2xOQ-xsNqO47m55DA&skey=bde0232fb97f4a72&v=v12#Cabin",
						"ttf": "http://fonts.gstatic.com/s/cabin/v12/nHiQo1BypvYzt95zlPq1TvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cabin/v12/haOjnueK8Or1ztuuRtr8dvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabin/v12/82B-3YlzWJm8zbCrVEmc_vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Cabin Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cabin Condensed\'",
						"\'CabinCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabincondensed/v11/B0txb0blf2N29WdYPJjMSiTVIg84CdvwY38Z-WYkVjc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=B0txb0blf2N29WdYPJjMSjtVxPYSbTYljQKlacBDHZ4&skey=17b81add35c8280b&v=v11#CabinCondensed",
						"ttf": "http://fonts.gstatic.com/s/cabincondensed/v11/B0txb0blf2N29WdYPJjMSlpNuLN9P2dR6eOCPYblbcM.ttf",
						"woff": "http://fonts.gstatic.com/s/cabincondensed/v11/B0txb0blf2N29WdYPJjMShZ1gqmQBTb4Nwa_fF0DajA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabincondensed/v11/B0txb0blf2N29WdYPJjMStWMqZ82NGJlZbN8XLKSRYo.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cabin Condensed Medium\'",
						"\'CabinCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEO0yR5t_EHTphebinvwfibU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ez4zJbsGr2BgXcNUWBVgEFGo11JAbv57Am-UvEXZX0Y&skey=c24e1e943f65c064&v=v11#CabinCondensed",
						"ttf": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEHBc6c7GJRyI5TJeLr8zflk.ttf",
						"woff": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgECyW0kDznfHZ5pM_3J5q0b8.woff",
						"woff2": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEC2V0Dcx-GzP0u75aFRGU4E.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cabin Condensed SemiBold\'",
						"\'CabinCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEDtNlfWXs3LXasIgqqxeZFo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ez4zJbsGr2BgXcNUWBVgEPIggWBtb0bEVNHSEuczDnY&skey=73e2998c2216d30c&v=v11#CabinCondensed",
						"ttf": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEPf4jeoVDNLU0gIpvaTJHt4.ttf",
						"woff": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEJwdxg8gzQNM6zG8Kbi0OAw.woff",
						"woff2": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEEbBiZVUr6I3CXzgk1sO27Y.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cabin Condensed Bold\'",
						"\'CabinCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEOuNSblOyuwHJ2bf__1M4cI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ez4zJbsGr2BgXcNUWBVgEGmmHJdze0NE-4rPBeWNdPU&skey=3035336f1cb2d188&v=v11#CabinCondensed",
						"ttf": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEMYsb_UBatsJhtlz83pruSg.ttf",
						"woff": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEFxo_3fQgeDvKMambfIp_uA.woff",
						"woff2": "http://fonts.gstatic.com/s/cabincondensed/v11/Ez4zJbsGr2BgXcNUWBVgEBZQ88-B6efqEZdRzbHKsrc.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Cabin Sketch": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cabin Sketch Regular\'",
						"\'CabinSketch-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabinsketch/v11/d9fijO34zQajqQvl3YHRCXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=d9fijO34zQajqQvl3YHRCVlIn5tFQcqMuf-jhyJP0ps&skey=64590cfdee656fb9&v=v11#CabinSketch",
						"ttf": "http://fonts.gstatic.com/s/cabinsketch/v11/d9fijO34zQajqQvl3YHRCYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cabinsketch/v11/d9fijO34zQajqQvl3YHRCXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cabinsketch/v11/d9fijO34zQajqQvl3YHRCegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cabin Sketch Bold\'",
						"\'CabinSketch-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cabinsketch/v11/ki3SSN5HMOO0-IOLOj069GmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ki3SSN5HMOO0-IOLOj069Aay50PuN8loMJ9QAXsTs7U&skey=ed1957a6296b121e&v=v11#CabinSketch",
						"ttf": "http://fonts.gstatic.com/s/cabinsketch/v11/ki3SSN5HMOO0-IOLOj069H06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/cabinsketch/v11/ki3SSN5HMOO0-IOLOj069Hl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/cabinsketch/v11/ki3SSN5HMOO0-IOLOj069HNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Caesar Dressing": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Caesar Dressing\'",
						"\'CaesarDressing-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caesardressing/v6/2T_WzBgE2Xz3FsyJMq34Tz5kyUzsZ7ZFppLqL8i1f2Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2T_WzBgE2Xz3FsyJMq34T3Pn-TfujOB-k60qXcd1z8I&skey=fe79435cc7dd5de9&v=v6#CaesarDressing",
						"ttf": "http://fonts.gstatic.com/s/caesardressing/v6/2T_WzBgE2Xz3FsyJMq34TxHNoyojkaAgRTeU3UpCWsY.ttf",
						"woff": "http://fonts.gstatic.com/s/caesardressing/v6/2T_WzBgE2Xz3FsyJMq34T2P6V2CHcxaChb7jOf5qsHM.woff",
						"woff2": "http://fonts.gstatic.com/s/caesardressing/v6/2T_WzBgE2Xz3FsyJMq34T9xnpefXQJWUEk6q-GhSFKY.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Cagliostro": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cagliostro Regular\'",
						"\'Cagliostro-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cagliostro/v6/9YPDJs4jy8n6yJ7GYUYhuVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9YPDJs4jy8n6yJ7GYUYhuaWUboTb-jS2tyCOQMtm97g&skey=f8581841a65f7b32&v=v6#Cagliostro",
						"ttf": "http://fonts.gstatic.com/s/cagliostro/v6/9YPDJs4jy8n6yJ7GYUYhuS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/cagliostro/v6/9YPDJs4jy8n6yJ7GYUYhuRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/cagliostro/v6/9YPDJs4jy8n6yJ7GYUYhufk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Cairo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Cairo ExtraLight\'",
						"\'Cairo-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/HuolOvxDMnYYkX5Rzfbo5fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iWkf-xk0M29ywcMC7TImWvesZW2xOQ-xsNqO47m55DA&skey=fcc35fc9b193d704&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/VMZSK5d3KvP-Ba-0do-QqPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/ZZNU1ZNCD-ctnqdxzBgwZfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/m_6Y_1Nb823vSGJGfT_5vPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Cairo Light\'",
						"\'Cairo-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/s2mssIx-Pb9MPWgEGn5br_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EgkyGs7qRWOcLKIRb3iSefesZW2xOQ-xsNqO47m55DA&skey=9125b8b962935364&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/xMagyNHeA_UbiOnoebmLX_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/kjh52RWXSUbTPMXEhLHVFPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/NwJ8eIvZGAJEQL7ALJDfVfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cairo\'",
						"\'Cairo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/re0gHb6FJjHHVMjDwvXeIg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NHWwqy16Bfwffsi_HqxK2g&skey=ee6e3b9105e1a754&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/uOhP6W00Hd6dR_axcPy22Q.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/zGHW--BYpblqncT3SLvtYw.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/gtxIPk0-ZE5IZ2RrdsRLuQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cairo SemiBold\'",
						"\'Cairo-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/4L3XL4iaJJ4WZXMZZVg_UPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vEUfN6tcCWInfVTePO4fXPesZW2xOQ-xsNqO47m55DA&skey=2cbc68d40dd42eff&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/my4jcVT79Rf8EDfxFJ6gUvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/p5VgymXnTXVD8HTIm9gL1_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/nDAflKnJsVnfdGOoytL7mPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cairo Bold\'",
						"\'Cairo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/CPcX1QHHHatnDXlP70KAiPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qJqdht0x3-aa5oky_sXFXfesZW2xOQ-xsNqO47m55DA&skey=63dc25841419bb82&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/s0c2ggXeq19QFKb1fP7qofesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/8Z55L-qO9fAo_YnD4cAGWvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/IGeshMgNVhb2XU2TGWkITvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Cairo Black\'",
						"\'Cairo-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cairo/v2/ztT6DNN-p1WjEXbBwVnpMfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AK-s5CtoVDnFS_rAbyXjbvesZW2xOQ-xsNqO47m55DA&skey=a12bc2e34741a2fa&v=v2#Cairo",
						"ttf": "http://fonts.gstatic.com/s/cairo/v2/7yDa7MkmUiJR2nvF_tTJBvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cairo/v2/s0Yy0gkopEOaan2LtIeQxPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cairo/v2/417l3JBKBK04DZkInIQz6vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Calligraffitti": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Calligraffitti Regular\'",
						"\'Calligraffitti-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/calligraffitti/v9/vLVN2Y-z65rVu1R7lWdvyE6pj5Y04j-CU6E4hBEpzG0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vLVN2Y-z65rVu1R7lWdvyPD--OnmP7qiFuSsqVzPMr0&skey=ab0616a69254148c&v=v9#Calligraffitti",
						"ttf": "http://fonts.gstatic.com/s/calligraffitti/v9/vLVN2Y-z65rVu1R7lWdvyF9q9cSakIY5dTu4rft1WBw.ttf",
						"woff": "http://fonts.gstatic.com/s/calligraffitti/v9/vLVN2Y-z65rVu1R7lWdvyKIZAuDcNtpCWuPSaIR0Ie8.woff",
						"woff2": "http://fonts.gstatic.com/s/calligraffitti/v9/vLVN2Y-z65rVu1R7lWdvyKMATE9hNx1o-nwq2GP8bHQ.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Cambay": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cambay Italic\'",
						"\'Cambay-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cambay/v3/OWaJhtm5hOEHCTXVqxhNXvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cAtXFqbQwiZlu5Nh58HOgPesZW2xOQ-xsNqO47m55DA&skey=e5bd29ad3697f3e&v=v3#Cambay",
						"ttf": "http://fonts.gstatic.com/s/cambay/v3/uLwIPPojiubLZnKQ-GYjr_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cambay/v3/CJDmp2LpAN7jOzA0TMzgT_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cambay/v3/NAQkuCU8JhzE5IvXqwp8gfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cambay Bold Italic\'",
						"\'Cambay-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cambay/v3/QXC__RY14mB1q5vhyakjrGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QXC__RY14mB1q5vhyakjrHNsigHlcrQGNV8nkUSFQfc&skey=9075a27258cb299f&v=v3#Cambay",
						"ttf": "http://fonts.gstatic.com/s/cambay/v3/QXC__RY14mB1q5vhyakjrJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cambay/v3/QXC__RY14mB1q5vhyakjrIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cambay/v3/QXC__RY14mB1q5vhyakjrI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cambay Regular\'",
						"\'Cambay-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cambay/v3/4GnlB76V3O2-qubswYdCQQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PNT_y7K40eWjIWrmbu3yEQ&skey=65e6fec681751af2&v=v3#Cambay",
						"ttf": "http://fonts.gstatic.com/s/cambay/v3/k54az7SupxvJk3Q2bWkYlA.ttf",
						"woff": "http://fonts.gstatic.com/s/cambay/v3/Y7Los8d3JHe0h4YXWXuqwg.woff",
						"woff2": "http://fonts.gstatic.com/s/cambay/v3/uXfMy7n4egUqCpK5wbBmsw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cambay Bold\'",
						"\'Cambay-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cambay/v3/9M3kjQTQkUz1UH-8XJ4q-PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9M3kjQTQkUz1UH-8XJ4q-Jbd9NUM7myrQQz30yPaGQ4&skey=9ce85acf2b162d00&v=v3#Cambay",
						"ttf": "http://fonts.gstatic.com/s/cambay/v3/9M3kjQTQkUz1UH-8XJ4q-KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cambay/v3/9M3kjQTQkUz1UH-8XJ4q-D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cambay/v3/9M3kjQTQkUz1UH-8XJ4q-FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Cambo": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cambo\'",
						"\'Cambo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cambo/v6/8lOVs-dt1wHIecjeA9ChRQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=W2C4xiiRUU86tBAjg9WcXA&skey=fdee44efd5e5393b&v=v6#Cambo",
						"ttf": "http://fonts.gstatic.com/s/cambo/v6/euSQOlxAUmD9bux1xIJgHg.ttf",
						"woff": "http://fonts.gstatic.com/s/cambo/v6/Hpv6vCTojizn0Qwl_Bb2SQ.woff",
						"woff2": "http://fonts.gstatic.com/s/cambo/v6/IPN1EprZzZutKNt9iYVMRQ.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Candal": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Candal\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/candal/v7/iYHAaEjIhPRS1B3h-X2T7w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=54IOgzpVIPafRRWbQRpUiQ&skey=bed53528c4492bda&v=v7#Candal",
						"ttf": "http://fonts.gstatic.com/s/candal/v7/9lf13JfVkaPvqypoC0K2XQ.ttf",
						"woff": "http://fonts.gstatic.com/s/candal/v7/c4OCAZZ9bgJkVvcf-E79mQ.woff",
						"woff2": "http://fonts.gstatic.com/s/candal/v7/BvBVFtas5Po0mh_yjtch_A.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Cantarell": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cantarell Oblique\'",
						"\'Cantarell-Oblique\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantarell/v7/Qd6zZq_wf1596L3V_8MIs2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Qd6zZq_wf1596L3V_8MIs3NsigHlcrQGNV8nkUSFQfc&skey=5f16ed9b6a8a2f0d&v=v7#Cantarell",
						"ttf": "http://fonts.gstatic.com/s/cantarell/v7/Qd6zZq_wf1596L3V_8MIs50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cantarell/v7/Qd6zZq_wf1596L3V_8MIs4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cantarell/v7/Qd6zZq_wf1596L3V_8MIs44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cantarell Bold Oblique\'",
						"\'Cantarell-BoldOblique\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantarell/v7/weehrwMeZBXb0QyrWnRwFbFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=weehrwMeZBXb0QyrWnRwFXtNmQEE9wZ6UZlmiISB1pg&skey=6a4e6d776759d980&v=v7#Cantarell",
						"ttf": "http://fonts.gstatic.com/s/cantarell/v7/weehrwMeZBXb0QyrWnRwFZ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/cantarell/v7/weehrwMeZBXb0QyrWnRwFTqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/cantarell/v7/weehrwMeZBXb0QyrWnRwFYlIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cantarell Regular\'",
						"\'Cantarell-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantarell/v7/V86VyqXbc09Sss3BPsMj1_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=V86VyqXbc09Sss3BPsMj15bd9NUM7myrQQz30yPaGQ4&skey=4fa1583b73a857db&v=v7#Cantarell",
						"ttf": "http://fonts.gstatic.com/s/cantarell/v7/V86VyqXbc09Sss3BPsMj16CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cantarell/v7/V86VyqXbc09Sss3BPsMj1z8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cantarell/v7/V86VyqXbc09Sss3BPsMj11tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cantarell Bold\'",
						"\'Cantarell-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantarell/v7/Yir4ZDsCn4g1kWopdg-ehHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Yir4ZDsCn4g1kWopdg-ehFlIn5tFQcqMuf-jhyJP0ps&skey=4ce757239eccd614&v=v7#Cantarell",
						"ttf": "http://fonts.gstatic.com/s/cantarell/v7/Yir4ZDsCn4g1kWopdg-ehInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cantarell/v7/Yir4ZDsCn4g1kWopdg-ehHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cantarell/v7/Yir4ZDsCn4g1kWopdg-ehOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Cantata One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cantata One\'",
						"\'CantataOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantataone/v7/Ur66QXTDfN1RjqAm41DRZWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ur66QXTDfN1RjqAm41DRZXNsigHlcrQGNV8nkUSFQfc&skey=9f9fbf085fb5338c&v=v7#CantataOne",
						"ttf": "http://fonts.gstatic.com/s/cantataone/v7/Ur66QXTDfN1RjqAm41DRZZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cantataone/v7/Ur66QXTDfN1RjqAm41DRZYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cantataone/v7/Ur66QXTDfN1RjqAm41DRZY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Cantora One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cantora One\'",
						"\'CantoraOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cantoraone/v7/2Tarv7Qs4oCEU-xItQ7PXWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2Tarv7Qs4oCEU-xItQ7PXXNsigHlcrQGNV8nkUSFQfc&skey=e3630653699ec3bd&v=v7#CantoraOne",
						"ttf": "http://fonts.gstatic.com/s/cantoraone/v7/2Tarv7Qs4oCEU-xItQ7PXZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cantoraone/v7/2Tarv7Qs4oCEU-xItQ7PXYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cantoraone/v7/2Tarv7Qs4oCEU-xItQ7PXY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Capriola": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Capriola Regular\'",
						"\'Capriola-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/capriola/v5/WfxisXfizGY6YbdIskpQtvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lbvigfqXJrZbzD60lVyxEvesZW2xOQ-xsNqO47m55DA&skey=83aefc9bb99aedde&v=v5#Capriola",
						"ttf": "http://fonts.gstatic.com/s/capriola/v5/pYZraWNYRjc_hHo5LnobfPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/capriola/v5/uuDFYyWaIr7gMYVZu_PK5fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/capriola/v5/1uu0rRDB9aBBIKvbF1Q_1PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cardo": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"greek",
			"greek-ext",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cardo Italic\'",
						"\'Cardo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cardo/v9/RxE5bFgPTBlMPY4Uzh64YQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XI1j6UEaGnfkBOdFUUjoUg&skey=26bb5df469a255da&v=v9#Cardo",
						"ttf": "http://fonts.gstatic.com/s/cardo/v9/GRTkKQvSwrQKMUJtWZsm7w.ttf",
						"woff": "http://fonts.gstatic.com/s/cardo/v9/0_g5QMQebQZw5ilITPZHDA.woff",
						"woff2": "http://fonts.gstatic.com/s/cardo/v9/y7hsfzVRyvnGGoGOmHdTeA.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cardo\'",
						"\'Cardo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cardo/v9/WLga5RBcBwOgQwbtYXsULg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tJfhmb6XM6Nefrs-MUPqRA&skey=6e473b3c3fa37289&v=v9#Cardo",
						"ttf": "http://fonts.gstatic.com/s/cardo/v9/vjI-nu0OQ4awNWMtISxB9w.ttf",
						"woff": "http://fonts.gstatic.com/s/cardo/v9/zpisC4kGu76S5N9VhpMnEg.woff",
						"woff2": "http://fonts.gstatic.com/stats/Cardo/normal/400"
					}
				},
				"700": {
					"local": [
						"\'Cardo Bold\'",
						"\'Cardo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cardo/v9/0nnlDTzzEQXukObx6f9ifPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=f8uFIJ6wVLbxDxi8rLJmtvesZW2xOQ-xsNqO47m55DA&skey=90e31575a38858c1&v=v9#Cardo",
						"ttf": "http://fonts.gstatic.com/s/cardo/v9/V5fEf2Hmfq3L3OwPiowl-vesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cardo/v9/gHC1KgRPdVNdvvVcxLMCY_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cardo/v9/X-1BEHTKpRYzad3JEXy9-vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Carme": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Carme Regular\'",
						"\'Carme\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/carme/v8/9h4xmfGW_PISFG7w2SRqPg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CaZvdtwXD3jcSHT136_qpQ&skey=67078b6e1e53721e&v=v8#Carme",
						"ttf": "http://fonts.gstatic.com/s/carme/v8/IGQFaxr6QFntFZmYFeQEew.ttf",
						"woff": "http://fonts.gstatic.com/s/carme/v8/Upg28fsDDYxCiFrWVodtfA.woff",
						"woff2": "http://fonts.gstatic.com/stats/Carme/normal/400"
					}
				}
			}
		},
		"version": "v8"
	},
	"Carrois Gothic": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Carrois Gothic Regular\'",
						"\'CarroisGothic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/carroisgothic/v7/GCgb7bssGpwp7V5ynxmWy30BPhY9Ss5I3ArVuEoPm0E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GCgb7bssGpwp7V5ynxmWy5wT5_IMVu1nLQ4FT5X8G9A&skey=9e26ceadcb501f24&v=v7#CarroisGothic",
						"ttf": "http://fonts.gstatic.com/s/carroisgothic/v7/GCgb7bssGpwp7V5ynxmWy-YDkGZU0bw2OXG1Ku08t6E.ttf",
						"woff": "http://fonts.gstatic.com/s/carroisgothic/v7/GCgb7bssGpwp7V5ynxmWy2IHn70NeZKJ0uStDo7Dza8.woff",
						"woff2": "http://fonts.gstatic.com/s/carroisgothic/v7/GCgb7bssGpwp7V5ynxmWy-RYAdd4IhfhHjBEc43Trp8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Carrois Gothic SC": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Carrois Gothic SC Regular\'",
						"\'CarroisGothicSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/carroisgothicsc/v7/bVp4nhwFIXU-r3LqUR8DSKnP_Zd-FQoRXNCZ8KL8FyQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bVp4nhwFIXU-r3LqUR8DSKjT81ykp1XJP8JYmemBjHU&skey=3ab05a1977f1f867&v=v7#CarroisGothicSC",
						"ttf": "http://fonts.gstatic.com/s/carroisgothicsc/v7/bVp4nhwFIXU-r3LqUR8DSEXZfvqDQow1E55U9qI_yj0.ttf",
						"woff": "http://fonts.gstatic.com/s/carroisgothicsc/v7/bVp4nhwFIXU-r3LqUR8DSNce8QJcbznVYyCETTx3XZM.woff",
						"woff2": "http://fonts.gstatic.com/s/carroisgothicsc/v7/bVp4nhwFIXU-r3LqUR8DSMAaO3DZECqhKACHp1QZu34.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Carter One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Carter One\'",
						"\'CarterOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/carterone/v9/VjW2qt1pkqVtO22ObxgEBVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VjW2qt1pkqVtO22ObxgEBaWUboTb-jS2tyCOQMtm97g&skey=31ef17c3e3d00ad1&v=v9#CarterOne",
						"ttf": "http://fonts.gstatic.com/s/carterone/v9/VjW2qt1pkqVtO22ObxgEBS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/carterone/v9/VjW2qt1pkqVtO22ObxgEBRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/carterone/v9/VjW2qt1pkqVtO22ObxgEBfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Catamaran": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"tamil",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Catamaran Thin\'",
						"\'Catamaran-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/AsJXcel0VOprDS7k9OVAc2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AsJXcel0VOprDS7k9OVAc3NsigHlcrQGNV8nkUSFQfc&skey=a9b56938d2f1cef2&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/AsJXcel0VOprDS7k9OVAc50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/AsJXcel0VOprDS7k9OVAc4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/AsJXcel0VOprDS7k9OVAc44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"200": {
					"local": [
						"\'Catamaran ExtraLight\'",
						"\'Catamaran-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/hFc-HKSsGk6M-psujei1MHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hFc-HKSsGk6M-psujei1MFlIn5tFQcqMuf-jhyJP0ps&skey=94ef7a70ab64c3a3&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/hFc-HKSsGk6M-psujei1MInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/hFc-HKSsGk6M-psujei1MHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/hFc-HKSsGk6M-psujei1MOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"300": {
					"local": [
						"\'Catamaran Light\'",
						"\'Catamaran-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/Aaag4ccR7Oh_4eai-jbrYHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Aaag4ccR7Oh_4eai-jbrYFlIn5tFQcqMuf-jhyJP0ps&skey=4b5f965596e3b29f&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/Aaag4ccR7Oh_4eai-jbrYInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/Aaag4ccR7Oh_4eai-jbrYHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/Aaag4ccR7Oh_4eai-jbrYOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Catamaran Regular\'",
						"\'Catamaran-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/iVYgK2bOLvZcSxr0ITOecvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iVYgK2bOLvZcSxr0ITOecpbd9NUM7myrQQz30yPaGQ4&skey=309d941a05fc0762&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/iVYgK2bOLvZcSxr0ITOecqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/iVYgK2bOLvZcSxr0ITOecj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/iVYgK2bOLvZcSxr0ITOecltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Catamaran Medium\'",
						"\'Catamaran-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/83WSX3F86qsvj1Z4EI0tQnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=83WSX3F86qsvj1Z4EI0tQllIn5tFQcqMuf-jhyJP0ps&skey=1f7c0bfcad7e7889&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/83WSX3F86qsvj1Z4EI0tQonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/83WSX3F86qsvj1Z4EI0tQnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/83WSX3F86qsvj1Z4EI0tQugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Catamaran SemiBold\'",
						"\'Catamaran-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/a9PlHHnuBWiGGk0TwuFKTnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=a9PlHHnuBWiGGk0TwuFKTllIn5tFQcqMuf-jhyJP0ps&skey=6135f1cc0c1b3810&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/a9PlHHnuBWiGGk0TwuFKTonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/a9PlHHnuBWiGGk0TwuFKTnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/a9PlHHnuBWiGGk0TwuFKTugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Catamaran Bold\'",
						"\'Catamaran-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/PpgVtUHUdnBZYNpnzGbSc3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PpgVtUHUdnBZYNpnzGbSc1lIn5tFQcqMuf-jhyJP0ps&skey=57b3a2830111dbc0&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/PpgVtUHUdnBZYNpnzGbSc4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/PpgVtUHUdnBZYNpnzGbSc3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/PpgVtUHUdnBZYNpnzGbSc-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"800": {
					"local": [
						"\'Catamaran ExtraBold\'",
						"\'Catamaran-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/6VjB_uSfn3DZ93IQv58CmHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6VjB_uSfn3DZ93IQv58CmFlIn5tFQcqMuf-jhyJP0ps&skey=474b56ec2b042111&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/6VjB_uSfn3DZ93IQv58CmInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/6VjB_uSfn3DZ93IQv58CmHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/6VjB_uSfn3DZ93IQv58CmOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"900": {
					"local": [
						"\'Catamaran Black\'",
						"\'Catamaran-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/catamaran/v4/5ys9TqpQc9Q6gHqbSox6p3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5ys9TqpQc9Q6gHqbSox6p1lIn5tFQcqMuf-jhyJP0ps&skey=9770b7dd9fa233f5&v=v4#Catamaran",
						"ttf": "http://fonts.gstatic.com/s/catamaran/v4/5ys9TqpQc9Q6gHqbSox6p4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/catamaran/v4/5ys9TqpQc9Q6gHqbSox6p3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/catamaran/v4/5ys9TqpQc9Q6gHqbSox6p-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Caudex": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"greek",
			"greek-ext",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Caudex Italic\'",
						"\'Caudex-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caudex/v7/4pAh5SElL-Dw6uk36aGf2PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=O1Dsbp0AxN1vyodo9wWwJ_esZW2xOQ-xsNqO47m55DA&skey=1f54382299ea82c0&v=v7#Caudex",
						"ttf": "http://fonts.gstatic.com/s/caudex/v7/K5QBFHw80aDkL3kZuzhkSfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/caudex/v7/4xlKHQzeciRH2984o6GTDPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/caudex/v7/uM8y5ZLGG_J_RjYQZCaBdPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Caudex Bold Italic\'",
						"\'Caudex-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caudex/v7/_KqFrbEZy5WPWJPByz6OJGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_KqFrbEZy5WPWJPByz6OJHNsigHlcrQGNV8nkUSFQfc&skey=e75cb4af8e8842e6&v=v7#Caudex",
						"ttf": "http://fonts.gstatic.com/s/caudex/v7/_KqFrbEZy5WPWJPByz6OJJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/caudex/v7/_KqFrbEZy5WPWJPByz6OJIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/caudex/v7/_KqFrbEZy5WPWJPByz6OJI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Caudex\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caudex/v7/P_FZg1ohzaqClb0qWCNQpg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vov8GAGl7NHMaIXkDDKCew&skey=89ad97180e9c147c&v=v7#Caudex",
						"ttf": "http://fonts.gstatic.com/s/caudex/v7/03NMplHkN8ROgyklztlsOQ.ttf",
						"woff": "http://fonts.gstatic.com/s/caudex/v7/C-hZH3TxxgxqDzJuctPSSw.woff",
						"woff2": "http://fonts.gstatic.com/s/caudex/v7/tEyJJhH5jnB2yxr-0TBTSg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Caudex Bold\'",
						"\'Caudex-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caudex/v7/7-zMWCNNzmNM428U56wMq_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7-zMWCNNzmNM428U56wMq5bd9NUM7myrQQz30yPaGQ4&skey=ef9bb145f0aa72ff&v=v7#Caudex",
						"ttf": "http://fonts.gstatic.com/s/caudex/v7/7-zMWCNNzmNM428U56wMq6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/caudex/v7/7-zMWCNNzmNM428U56wMqz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/caudex/v7/7-zMWCNNzmNM428U56wMq1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Caveat": {
		"category": "handwriting",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Caveat Regular\'",
						"\'Caveat-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caveat/v4/w5mmLL-lNGiWLw0VO0YOuA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z8HpnLhuCbhXV4MLHPYNjQ&skey=7833cd5b856b60c9&v=v4#Caveat",
						"ttf": "http://fonts.gstatic.com/s/caveat/v4/rm030mEGKaFzXfk9djcu2w.ttf",
						"woff": "http://fonts.gstatic.com/s/caveat/v4/C53-ZILZYZe5XK8m_nmMJw.woff",
						"woff2": "http://fonts.gstatic.com/s/caveat/v4/gfhw4jqISntrgd0CyL3qNQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Caveat Bold\'",
						"\'Caveat-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caveat/v4/x6VSYBqZaI7QnEcE_qETMPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=x6VSYBqZaI7QnEcE_qETMJbd9NUM7myrQQz30yPaGQ4&skey=23f4c72b4f49a52d&v=v4#Caveat",
						"ttf": "http://fonts.gstatic.com/s/caveat/v4/x6VSYBqZaI7QnEcE_qETMKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/caveat/v4/x6VSYBqZaI7QnEcE_qETMD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/caveat/v4/x6VSYBqZaI7QnEcE_qETMFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Caveat Brush": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Caveat Brush\'",
						"\'CaveatBrush-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/caveatbrush/v3/_d7bgsk3hfC4DXnUEeYKs3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_d7bgsk3hfC4DXnUEeYKs1lIn5tFQcqMuf-jhyJP0ps&skey=fac58a4d598f3b27&v=v3#CaveatBrush",
						"ttf": "http://fonts.gstatic.com/s/caveatbrush/v3/_d7bgsk3hfC4DXnUEeYKs4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/caveatbrush/v3/_d7bgsk3hfC4DXnUEeYKs3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/caveatbrush/v3/_d7bgsk3hfC4DXnUEeYKs-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Cedarville Cursive": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cedarville Cursive\'",
						"\'Cedarville-Cursive\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cedarvillecursive/v8/cuCe6HrkcqrWTWTUE7dw-6FFq7koUBiQ86b1QH4Zdok.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cuCe6HrkcqrWTWTUE7dw-4vaWx2o7UP3L7cyM9MGbik&skey=8222d497abe502f8&v=v8#CedarvilleCursive",
						"ttf": "http://fonts.gstatic.com/s/cedarvillecursive/v8/cuCe6HrkcqrWTWTUE7dw-2aRxgVDvEsTMYtRjPTct-E.ttf",
						"woff": "http://fonts.gstatic.com/s/cedarvillecursive/v8/cuCe6HrkcqrWTWTUE7dw-5zpMnghKP_wiJrQSyqob5U.woff",
						"woff2": "http://fonts.gstatic.com/s/cedarvillecursive/v8/cuCe6HrkcqrWTWTUE7dw-9c3lOkTc1IrfN1zKaob-SQ.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Ceviche One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Ceviche One\'",
						"\'CevicheOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cevicheone/v8/BQRygZwg3wyGCQXvKfUbSWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BQRygZwg3wyGCQXvKfUbSXNsigHlcrQGNV8nkUSFQfc&skey=c523f0ea346a3458&v=v8#CevicheOne",
						"ttf": "http://fonts.gstatic.com/s/cevicheone/v8/BQRygZwg3wyGCQXvKfUbSZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cevicheone/v8/BQRygZwg3wyGCQXvKfUbSYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cevicheone/v8/BQRygZwg3wyGCQXvKfUbSY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Changa": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Changa ExtraLight\'",
						"\'Changa-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/qpMkbt3gzwByHNhGd_6trfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qpMkbt3gzwByHNhGd_6trZbd9NUM7myrQQz30yPaGQ4&skey=72099b09bcadb266&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/qpMkbt3gzwByHNhGd_6traCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/qpMkbt3gzwByHNhGd_6trT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/qpMkbt3gzwByHNhGd_6trVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Changa Light\'",
						"\'Changa-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/g574OV_kPJGAg5xgvJqovPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=g574OV_kPJGAg5xgvJqovJbd9NUM7myrQQz30yPaGQ4&skey=73a3abe86fa49d0c&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/g574OV_kPJGAg5xgvJqovKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/g574OV_kPJGAg5xgvJqovD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/g574OV_kPJGAg5xgvJqovFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Changa\'",
						"\'Changa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/A8HINg3_mY3IoFhYfO1wGw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CtuaENsYuZQuYlg1-B0yqA&skey=11532a8d9d187679&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/DlXgaLSjPTgWYoR8C1__fg.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/9HvORavVk9AFql2e_cI0LA.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/NiSJImda5f9NyXfUYMGTgQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Changa Medium\'",
						"\'Changa-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/cqTBxI89lHncqXVAMiL6VPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cqTBxI89lHncqXVAMiL6VJbd9NUM7myrQQz30yPaGQ4&skey=2a46e3e3e89d87c6&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/cqTBxI89lHncqXVAMiL6VKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/cqTBxI89lHncqXVAMiL6VD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/cqTBxI89lHncqXVAMiL6VFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Changa SemiBold\'",
						"\'Changa-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/aXdbZDB08TCIBRKa7Qgu_PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=aXdbZDB08TCIBRKa7Qgu_Jbd9NUM7myrQQz30yPaGQ4&skey=b68898117d1a953c&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/aXdbZDB08TCIBRKa7Qgu_KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/aXdbZDB08TCIBRKa7Qgu_D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/aXdbZDB08TCIBRKa7Qgu_FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Changa Bold\'",
						"\'Changa-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/ZLtEtZF8z-OEmYAGzkqHkvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZLtEtZF8z-OEmYAGzkqHkpbd9NUM7myrQQz30yPaGQ4&skey=f3b4f6769c8c125a&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/ZLtEtZF8z-OEmYAGzkqHkqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/ZLtEtZF8z-OEmYAGzkqHkj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/ZLtEtZF8z-OEmYAGzkqHkltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Changa ExtraBold\'",
						"\'Changa-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changa/v3/FOgd7m08h-FSLq5lCOdHAvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FOgd7m08h-FSLq5lCOdHApbd9NUM7myrQQz30yPaGQ4&skey=3a6f5db765bdb074&v=v3#Changa",
						"ttf": "http://fonts.gstatic.com/s/changa/v3/FOgd7m08h-FSLq5lCOdHAqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/changa/v3/FOgd7m08h-FSLq5lCOdHAj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/changa/v3/FOgd7m08h-FSLq5lCOdHAltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Changa One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Changa One Italic\'",
						"\'ChangaOne-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changaone/v10/wJVQlUs1lAZel-WdTo2U93Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wJVQlUs1lAZel-WdTo2U91lIn5tFQcqMuf-jhyJP0ps&skey=7e2c0b69e2b8585&v=v10#ChangaOne",
						"ttf": "http://fonts.gstatic.com/s/changaone/v10/wJVQlUs1lAZel-WdTo2U94nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/changaone/v10/wJVQlUs1lAZel-WdTo2U93hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/changaone/v10/wJVQlUs1lAZel-WdTo2U9-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Changa One\'",
						"\'ChangaOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/changaone/v10/QmTOgNNWM9ly3K3B2X29HFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QmTOgNNWM9ly3K3B2X29HKWUboTb-jS2tyCOQMtm97g&skey=b778b7c8d55425c&v=v10#ChangaOne",
						"ttf": "http://fonts.gstatic.com/s/changaone/v10/QmTOgNNWM9ly3K3B2X29HC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/changaone/v10/QmTOgNNWM9ly3K3B2X29HBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/changaone/v10/QmTOgNNWM9ly3K3B2X29HPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Chango": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chango Regular\'",
						"\'Chango-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chango/v6/qEZmUaZoSyqe5pINL7Md8Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ow5enMbpMC-dVGz8SafRLA&skey=cdfcf13d542afb9&v=v6#Chango",
						"ttf": "http://fonts.gstatic.com/s/chango/v6/tZuFZQQSznzm1NJDMY53Gg.ttf",
						"woff": "http://fonts.gstatic.com/s/chango/v6/nbaquFP0ZZ_smqykJINU8Q.woff",
						"woff2": "http://fonts.gstatic.com/s/chango/v6/oCUWw7_3AskZ8lwr1x8o0Q.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Chathura": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Chathura Thin\'",
						"\'Chathura-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chathura/v3/lPwkkyhRbAaGXswMKuIr6FQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lPwkkyhRbAaGXswMKuIr6KWUboTb-jS2tyCOQMtm97g&skey=766e61739e22aaba&v=v3#Chathura",
						"ttf": "http://fonts.gstatic.com/s/chathura/v3/lPwkkyhRbAaGXswMKuIr6C3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/chathura/v3/lPwkkyhRbAaGXswMKuIr6BsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/chathura/v3/lPwkkyhRbAaGXswMKuIr6Pk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Chathura Light\'",
						"\'Chathura-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chathura/v3/Z94VvGXw-T3QkrXMRlQJB2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z94VvGXw-T3QkrXMRlQJB3NsigHlcrQGNV8nkUSFQfc&skey=a461c7cc6a7ac66&v=v3#Chathura",
						"ttf": "http://fonts.gstatic.com/s/chathura/v3/Z94VvGXw-T3QkrXMRlQJB50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/chathura/v3/Z94VvGXw-T3QkrXMRlQJB4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/chathura/v3/Z94VvGXw-T3QkrXMRlQJB44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Chathura Regular\'",
						"\'Chathura-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chathura/v3/iCqaxTd0W1HeQdVrnfFCK_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Yt4ppgjhNTg81n4LxAt-0PesZW2xOQ-xsNqO47m55DA&skey=37a79c74def3fd18&v=v3#Chathura",
						"ttf": "http://fonts.gstatic.com/s/chathura/v3/icX0UFHcQR9vJeuHYf_vLvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/chathura/v3/uDPPbmlE87IJl0szgE3VLPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/chathura/v3/ilSFyCd6nKwpP_Kx3e-3NvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Chathura Bold\'",
						"\'Chathura-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chathura/v3/d7JBr4OSAfPKesRygJ7sTWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=d7JBr4OSAfPKesRygJ7sTXNsigHlcrQGNV8nkUSFQfc&skey=7435dace61c83230&v=v3#Chathura",
						"ttf": "http://fonts.gstatic.com/s/chathura/v3/d7JBr4OSAfPKesRygJ7sTZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/chathura/v3/d7JBr4OSAfPKesRygJ7sTYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/chathura/v3/d7JBr4OSAfPKesRygJ7sTY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Chathura ExtraBold\'",
						"\'Chathura-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chathura/v3/tIisksgqRBdJ3yz8VFSS52fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tIisksgqRBdJ3yz8VFSS53NsigHlcrQGNV8nkUSFQfc&skey=8012a56d8595ebc7&v=v3#Chathura",
						"ttf": "http://fonts.gstatic.com/s/chathura/v3/tIisksgqRBdJ3yz8VFSS550EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/chathura/v3/tIisksgqRBdJ3yz8VFSS54bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/chathura/v3/tIisksgqRBdJ3yz8VFSS544P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Chau Philomene One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Chau Philomene One Italic\'",
						"\'ChauPhilomeneOne-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chauphilomeneone/v7/eJj1PY_iN4KiIuyOvtMHJB1P2uv6_OZoy8HZNrq6aXw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eJj1PY_iN4KiIuyOvtMHJGYg1YLvQA9lEG81wbRoddU&skey=81aa108e7cdf69f&v=v7#ChauPhilomeneOne",
						"ttf": "http://fonts.gstatic.com/s/chauphilomeneone/v7/eJj1PY_iN4KiIuyOvtMHJEzPzfot2BCbRpA7cLs8IUE.ttf",
						"woff": "http://fonts.gstatic.com/s/chauphilomeneone/v7/eJj1PY_iN4KiIuyOvtMHJIBb7n-QTpJC331hCHxHynU.woff",
						"woff2": "http://fonts.gstatic.com/s/chauphilomeneone/v7/eJj1PY_iN4KiIuyOvtMHJBVB5ZFkUM2PzQWbFGFRNEM.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Chau Philomene One Regular\'",
						"\'ChauPhilomeneOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chauphilomeneone/v7/KKc5egCL-a2fFVoOA2x6tP46-gPlLo5Bz62zaL-6AJc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KKc5egCL-a2fFVoOA2x6tCvEbVMKU89ibdaTblVLH4k&skey=4c1fda6540b94a11&v=v7#ChauPhilomeneOne",
						"ttf": "http://fonts.gstatic.com/s/chauphilomeneone/v7/KKc5egCL-a2fFVoOA2x6tBPVu1ub58ywURJPjZUSx6o.ttf",
						"woff": "http://fonts.gstatic.com/s/chauphilomeneone/v7/KKc5egCL-a2fFVoOA2x6tLCP4LGfprDLBfU97ANpU-o.woff",
						"woff2": "http://fonts.gstatic.com/s/chauphilomeneone/v7/KKc5egCL-a2fFVoOA2x6tFNFh3iwDlv8vzbIh0AIG5c.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Chela One": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chela One\'",
						"\'ChelaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chelaone/v6/DHUBEAsCcSRMyWTJ6sisfvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DHUBEAsCcSRMyWTJ6sisfpbd9NUM7myrQQz30yPaGQ4&skey=84d64f7eb14135f7&v=v6#ChelaOne",
						"ttf": "http://fonts.gstatic.com/s/chelaone/v6/DHUBEAsCcSRMyWTJ6sisfqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/chelaone/v6/DHUBEAsCcSRMyWTJ6sisfj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/chelaone/v6/DHUBEAsCcSRMyWTJ6sisfltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Chelsea Market": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chelsea Market\'",
						"\'ChelseaMarket-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chelseamarket/v5/qSdzwh2A4BbNemy78sJLfPbNgy1s2r-AQSwPHWGpA0I.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qSdzwh2A4BbNemy78sJLfM5_UplKUcmH8azFejCj7TI&skey=bc7514ae069c6e6d&v=v5#ChelseaMarket",
						"ttf": "http://fonts.gstatic.com/s/chelseamarket/v5/qSdzwh2A4BbNemy78sJLfOSB4-q0KehLImxSVNaiVBQ.ttf",
						"woff": "http://fonts.gstatic.com/s/chelseamarket/v5/qSdzwh2A4BbNemy78sJLfFg5923bhI0e2gp7DBvMMjU.woff",
						"woff2": "http://fonts.gstatic.com/s/chelseamarket/v5/qSdzwh2A4BbNemy78sJLfBRWMfMQaj_KSrIuqJtfm2o.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Chenla": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chenla\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chenla/v10/_-Nf9t6-NE3_1hQRE7L6vA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=h-cX-4QWfEKdVcpLkDzHgQ&skey=2085178ea565e72e&v=v10#Chenla",
						"ttf": "http://fonts.gstatic.com/s/chenla/v10/aLNpdAUDq2MZbWz2U1a16g.ttf",
						"woff": "http://fonts.gstatic.com/s/chenla/v10/Baa05THQ39gC7TSZbgzZyA.woff",
						"woff2": "http://fonts.gstatic.com/s/chenla/v10/XLWjCzh7w1Q3XylRRuSHzPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Cherry Cream Soda": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cherry Cream Soda Regular\'",
						"\'CherryCreamSoda-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cherrycreamsoda/v8/OrD-AUnFcZeeKa6F_c0_W_Lztw6LbsX-Zfq5T68sg5A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OrD-AUnFcZeeKa6F_c0_Wzo7jjzEAVtpQByD644h6l0&skey=f8bc88374f2520b0&v=v8#CherryCreamSoda",
						"ttf": "http://fonts.gstatic.com/s/cherrycreamsoda/v8/OrD-AUnFcZeeKa6F_c0_W7qBN36jQhVLTmQ9NDizP_4.ttf",
						"woff": "http://fonts.gstatic.com/s/cherrycreamsoda/v8/OrD-AUnFcZeeKa6F_c0_WxqwWSV7TiEqKBI7h3gm4xc.woff",
						"woff2": "http://fonts.gstatic.com/s/cherrycreamsoda/v8/OrD-AUnFcZeeKa6F_c0_W5ZOzb_eonFnJBi_71Lymv4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Cherry Swash": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cherry Swash\'",
						"\'CherrySwash-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cherryswash/v5/HqOk7C7J1TZ5i3L-ejF0vnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HqOk7C7J1TZ5i3L-ejF0vllIn5tFQcqMuf-jhyJP0ps&skey=c62d02307a44c176&v=v5#CherrySwash",
						"ttf": "http://fonts.gstatic.com/s/cherryswash/v5/HqOk7C7J1TZ5i3L-ejF0vonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cherryswash/v5/HqOk7C7J1TZ5i3L-ejF0vnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cherryswash/v5/HqOk7C7J1TZ5i3L-ejF0vugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cherry Swash Bold\'",
						"\'CherrySwash-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cherryswash/v5/-CfyMyQqfucZPQNB0nvYyGmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-CfyMyQqfucZPQNB0nvYyAay50PuN8loMJ9QAXsTs7U&skey=aa797e97ac712f5f&v=v5#CherrySwash",
						"ttf": "http://fonts.gstatic.com/s/cherryswash/v5/-CfyMyQqfucZPQNB0nvYyH06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/cherryswash/v5/-CfyMyQqfucZPQNB0nvYyHl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/cherryswash/v5/-CfyMyQqfucZPQNB0nvYyHNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Chewy": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chewy Regular\'",
						"\'Chewy-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chewy/v9/DMbSC7GKZZvySnH_OcA3ow.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=25D7X4M93YAGKjqR10DELA&skey=7ed5ab3a634ee0b0&v=v9#Chewy",
						"ttf": "http://fonts.gstatic.com/s/chewy/v9/9pHJyFOcO5WaMZJw9XnkAw.ttf",
						"woff": "http://fonts.gstatic.com/s/chewy/v9/nB-Yp57-ChbdqJ4CkQVXAQ.woff",
						"woff2": "http://fonts.gstatic.com/s/chewy/v9/rb3O4cUMVLYzfgbaJOdJHw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Chicle": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chicle Regular\'",
						"\'Chicle-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chicle/v6/F59HDhwbTG9b_MQJrzS4iw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IKA2fzEefWqPLrEbiF9M-w&skey=446ff37347f80fd9&v=v6#Chicle",
						"ttf": "http://fonts.gstatic.com/s/chicle/v6/RdGCgT3HKkTPvPqre3bbJQ.ttf",
						"woff": "http://fonts.gstatic.com/s/chicle/v6/Z4NY1QdtFCL2zVVtN28VGA.woff",
						"woff2": "http://fonts.gstatic.com/s/chicle/v6/jxnrJ0nf89KjeG3bG0d0yw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Chivo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Chivo Light Italic\'",
						"\'Chivo-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/x3v9v-9cJ14HRz_BghKZcFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=x3v9v-9cJ14HRz_BghKZcKWUboTb-jS2tyCOQMtm97g&skey=6c239fb87b87b201&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/x3v9v-9cJ14HRz_BghKZcC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/x3v9v-9cJ14HRz_BghKZcBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/x3v9v-9cJ14HRz_BghKZcPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Chivo Italic\'",
						"\'Chivo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/69OTTWV4msxwy5ZAGj5Jeg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LQdtf_4INhMwFcBcjR1GUw&skey=e12ecfa8f00983c9&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/j2gOj6SKkH1Abglzy2otug.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/qKyfSXgB_3owVhI0N_hEAQ.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/Sj1QqLyoKuAyWOdnG3PRjw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Chivo Bold Italic\'",
						"\'Chivo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/IGWMbe1ihP5a5pTS8kIuNlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IGWMbe1ihP5a5pTS8kIuNqWUboTb-jS2tyCOQMtm97g&skey=25362707696bcc64&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/IGWMbe1ihP5a5pTS8kIuNi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/IGWMbe1ihP5a5pTS8kIuNhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/IGWMbe1ihP5a5pTS8kIuNvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"900": {
					"local": [
						"\'Chivo Black Italic\'",
						"\'Chivo-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/3h0vPLmvTdhk0D5czP5dhVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3h0vPLmvTdhk0D5czP5dhaWUboTb-jS2tyCOQMtm97g&skey=b35cb96dc682c776&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/3h0vPLmvTdhk0D5czP5dhS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/3h0vPLmvTdhk0D5czP5dhRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/3h0vPLmvTdhk0D5czP5dhfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Chivo Light\'",
						"\'Chivo-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/nV1nT34o0ENQLjgIm4vnQvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RqsixJTj2rD4LYrA5LNA4fesZW2xOQ-xsNqO47m55DA&skey=37766c5054acdb20&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/acK5hyoAfhYAan7-K1unEPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/vY9mGJNefDvsneiHl1w-FPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/I2jQCpaDExpTmf6d-sdY1fesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Chivo Regular\'",
						"\'Chivo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/kGTnr977hmchOE1JfUzNKQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=D7tgA0xyCbITiFsK1DPfXA&skey=c7ef26a9bd28e2ff&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/GCfZZhEBktKQec0okJ7kUw.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/2vOGounxqJdQZmH7ou5HpA.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/UZPPER-oWTCIdBggEtZvZA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Chivo Bold\'",
						"\'Chivo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/6bNn5pDphUX8F4elWmWa2_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=i4yYxT10Oqh0ZF6RNswcNfesZW2xOQ-xsNqO47m55DA&skey=868d630bb558df4c&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/G9PMGV6I9cqfwHQDuszvBvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/FYXSzGAOs0rJv7VOWc-Q-vesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/UcOD_UcesIGp9URGRPMOZvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Chivo Black\'",
						"\'Chivo-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chivo/v9/Fmds4ZGIc99pcGeFqawJOPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TqcQ1ufkH_NH12HYcmZrw_esZW2xOQ-xsNqO47m55DA&skey=17a168c729e0babd&v=v9#Chivo",
						"ttf": "http://fonts.gstatic.com/s/chivo/v9/YWbtYk2MoHeFgZxEOX7DnvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/chivo/v9/uOXSiKkEygwkvR4cgUzOz_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/chivo/v9/TX_hNweQrqAZr-ujaKg9pvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Chonburi": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Chonburi\'",
						"\'Chonburi-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/chonburi/v2/Dk_vbkKToZSLnInF_XmMSfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eerh6pc8ZkD6FDSaVZNAXPesZW2xOQ-xsNqO47m55DA&skey=c7df2cb94921e7b4&v=v2#Chonburi",
						"ttf": "http://fonts.gstatic.com/s/chonburi/v2/A1-rA12Lub2f0TV66DbwbvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/chonburi/v2/-hBBYxejJjEUNy7ayclUzPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/chonburi/v2/OZiQDxcLRCqMlAAKyGzjPPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Cinzel": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cinzel Regular\'",
						"\'Cinzel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzel/v7/AJV8Cpuc3TnmQZiYfRqP9Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eDhPXP9v8KvQomWB84nKuQ&skey=f319ae43d1034808&v=v7#Cinzel",
						"ttf": "http://fonts.gstatic.com/s/cinzel/v7/Hm1qjDlZpOdVXoa-QGE7_w.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzel/v7/mLL0ZqnXRx3m16FnBy9gcg.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzel/v7/zOdksD_UUTk1LJF9z4tURA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cinzel Bold\'",
						"\'Cinzel-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzel/v7/L74890HNVnUypqWjqGUt1fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=L74890HNVnUypqWjqGUt1Zbd9NUM7myrQQz30yPaGQ4&skey=d0bd7ac4911fce5f&v=v7#Cinzel",
						"ttf": "http://fonts.gstatic.com/s/cinzel/v7/L74890HNVnUypqWjqGUt1aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzel/v7/L74890HNVnUypqWjqGUt1T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzel/v7/L74890HNVnUypqWjqGUt1VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Cinzel Black\'",
						"\'Cinzel-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzel/v7/u8CPqNcpTcF_eDy_SWp9tfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=u8CPqNcpTcF_eDy_SWp9tZbd9NUM7myrQQz30yPaGQ4&skey=be449759839bebc9&v=v7#Cinzel",
						"ttf": "http://fonts.gstatic.com/s/cinzel/v7/u8CPqNcpTcF_eDy_SWp9taCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzel/v7/u8CPqNcpTcF_eDy_SWp9tT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzel/v7/u8CPqNcpTcF_eDy_SWp9tVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Cinzel Decorative": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cinzel Decorative Regular\'",
						"\'CinzelDecorative-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzeldecorative/v6/fmgK7oaJJIXAkhd9798yQs01_b696jtrov-k684hyds.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fmgK7oaJJIXAkhd9798yQmoCFxpbyFILJUsnYXwIs9Y&skey=27bc48db1b57037b&v=v6#CinzelDecorative",
						"ttf": "http://fonts.gstatic.com/s/cinzeldecorative/v6/fmgK7oaJJIXAkhd9798yQiIQXpsbKR_wBTo1n6IkW90.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzeldecorative/v6/fmgK7oaJJIXAkhd9798yQt0Zu-Kfjb9GTaHd117aS3o.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzeldecorative/v6/fmgK7oaJJIXAkhd9798yQl4jZHmtnl4mfN0ClpLnj0E.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cinzel Decorative Bold\'",
						"\'CinzelDecorative-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F92xbktjoc3Q-VQCFKsQPDxs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pXhIVnhFtL_B9Vb1wq2F90uj3Z8c18EHk92yoRs-7EU&skey=c0652cef950f775a&v=v6#CinzelDecorative",
						"ttf": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F9wIh9oxuYcmvOvyh_107lQs.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F91woV3Ase8nl0bf_DDHc7Tg.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F9_FsHroRjx8_CLiuG6fjUuY.woff2"
					}
				},
				"900": {
					"local": [
						"\'Cinzel Decorative Black\'",
						"\'CinzelDecorative-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F9zf0jTszt3DNl8XciODflmc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pXhIVnhFtL_B9Vb1wq2F92n7EbsA--MUB4gVJVKPJ0w&skey=d6b04507a3b5a102&v=v6#CinzelDecorative",
						"ttf": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F9zCUrkmwPfdnoTjOU_kXqBI.ttf",
						"woff": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F90KlpkgZQ3HHzCyqRJ1zOco.woff",
						"woff2": "http://fonts.gstatic.com/s/cinzeldecorative/v6/pXhIVnhFtL_B9Vb1wq2F943Di0peu2X9KS2KY2ET-u0.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Clicker Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Clicker Script\'",
						"\'ClickerScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/clickerscript/v5/Zupmk8XwADjufGxWB9KThGrfpCc_r9-5ZnZPBmoO4Sk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Zupmk8XwADjufGxWB9KThGNb_15wyZifjqRY11zN25A&skey=a8a0c13ec25a7971&v=v5#ClickerScript",
						"ttf": "http://fonts.gstatic.com/s/clickerscript/v5/Zupmk8XwADjufGxWB9KThC5FJMZltoAAwO2fP7iHu2o.ttf",
						"woff": "http://fonts.gstatic.com/s/clickerscript/v5/Zupmk8XwADjufGxWB9KThFhlQWQpSCpzb2Peu3I-Q34.woff",
						"woff2": "http://fonts.gstatic.com/s/clickerscript/v5/Zupmk8XwADjufGxWB9KThEd0sm1ffa_JvZxsF_BEwQk.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Coda": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Coda Regular\'",
						"\'Coda-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coda/v13/mG3vnf_-L6iZJRUt2i1SMg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Xq-ASfBjmIGeQgeI8G9aMg&skey=85bb675133fabe3&v=v13#Coda",
						"ttf": "http://fonts.gstatic.com/s/coda/v13/KzHY9N-PIagGI86CpWfnZA.ttf",
						"woff": "http://fonts.gstatic.com/s/coda/v13/A7A0IS2-4Ga-ZdxhMlAPjg.woff",
						"woff2": "http://fonts.gstatic.com/s/coda/v13/_xmjOXyFZCVnKmbBxb_PUA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Coda ExtraBold\'",
						"\'Coda-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coda/v13/1zFoqmwCa-wFntYZbAnFqQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mCUXlNFWsxf0v4ndKPLlZg&skey=4835f90a6ea1d5e3&v=v13#Coda",
						"ttf": "http://fonts.gstatic.com/s/coda/v13/XMn0_sSpx9PqyzpvTBBkaA.ttf",
						"woff": "http://fonts.gstatic.com/s/coda/v13/NSKszig3lQPRMZg0f0ghaw.woff",
						"woff2": "http://fonts.gstatic.com/s/coda/v13/HfZzsBW2eqpsWXkIkeLL_Q.woff2"
					}
				}
			}
		},
		"version": "v13"
	},
	"Coda Caption": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"800": {
					"local": [
						"\'Coda Caption ExtraBold\'",
						"\'CodaCaption-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/codacaption/v11/YDl6urZh-DUFhiMBTgAnz9Kd--5SjvBBPdO8SYNBozY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YDl6urZh-DUFhiMBTgAnzzkD3gkdjFTgxsLXLStRJKw&skey=c11ca7c94b3d7330&v=v11#CodaCaption",
						"ttf": "http://fonts.gstatic.com/s/codacaption/v11/YDl6urZh-DUFhiMBTgAnz7i9CBoQ1U4Q5PEtIDscMvI.ttf",
						"woff": "http://fonts.gstatic.com/s/codacaption/v11/YDl6urZh-DUFhiMBTgAnz2pVmE9oLybi4D_AN-2K110.woff",
						"woff2": "http://fonts.gstatic.com/s/codacaption/v11/YDl6urZh-DUFhiMBTgAnzxqoE9FO9sRveXk8Nnop4Zo.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Codystar": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Codystar Light\'",
						"\'Codystar-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/codystar/v5/BM8u7YRmG0S-vNUxWAiLF2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BM8u7YRmG0S-vNUxWAiLF3NsigHlcrQGNV8nkUSFQfc&skey=6c4a048055cc7f7b&v=v5#Codystar",
						"ttf": "http://fonts.gstatic.com/s/codystar/v5/BM8u7YRmG0S-vNUxWAiLF50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/codystar/v5/BM8u7YRmG0S-vNUxWAiLF4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/codystar/v5/BM8u7YRmG0S-vNUxWAiLF44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Codystar\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/codystar/v5/5WcK3NDF8iJsBWtG32ehUPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Pgkf7DetZV0hVGhBUzQDmPesZW2xOQ-xsNqO47m55DA&skey=5d796f9025f59d2&v=v5#Codystar",
						"ttf": "http://fonts.gstatic.com/s/codystar/v5/cAr9iPh4eRYEbqShfXOxP_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/codystar/v5/BraFEMRumMsVbWgqTQIWRPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/codystar/v5/vO78uQGcYk_rDbnNA1ruZPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Coiny": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"tamil",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Coiny Regular\'",
						"\'Coiny-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coiny/v3/30Hh71TgN4RDwsjKPxH0Sg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oNIbkYzAUeAiT8qc1pJvrA&skey=f65afa53b66c5694&v=v3#Coiny",
						"ttf": "http://fonts.gstatic.com/s/coiny/v3/vOkn-9hFeAqb9PTBsd6N-w.ttf",
						"woff": "http://fonts.gstatic.com/s/coiny/v3/sYufyXEo3ZFpOXqWJHnb6A.woff",
						"woff2": "http://fonts.gstatic.com/s/coiny/v3/yLjI2gVbVWWmvUcD--_G4Q.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Combo": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Combo\'",
						"\'Combo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/combo/v6/a5up4AFoQJBA-UVE-MYg8A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kaBgjE8o3tti7jiAW3YfvA&skey=5d39bfc218062a9c&v=v6#Combo",
						"ttf": "http://fonts.gstatic.com/s/combo/v6/LOqTJcEG3Q87INQ6SedZFQ.ttf",
						"woff": "http://fonts.gstatic.com/s/combo/v6/5jOPUBmk8riTNBycnGGj9g.woff",
						"woff2": "http://fonts.gstatic.com/s/combo/v6/LH-LWUfi0tpbljcTzTPAkA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Comfortaa": {
		"category": "display",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Comfortaa Light\'",
						"\'Comfortaa-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/comfortaa/v12/r_tUZNl0G8xCoOmp_JkSCnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r_tUZNl0G8xCoOmp_JkSCllIn5tFQcqMuf-jhyJP0ps&skey=1d2f7639d4b7d7b0&v=v12#Comfortaa",
						"ttf": "http://fonts.gstatic.com/s/comfortaa/v12/r_tUZNl0G8xCoOmp_JkSConF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/comfortaa/v12/r_tUZNl0G8xCoOmp_JkSCnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/comfortaa/v12/r_tUZNl0G8xCoOmp_JkSCugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Comfortaa Regular\'",
						"\'Comfortaa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/comfortaa/v12/qLBu5CQmSMt1H43OiWJ77fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qLBu5CQmSMt1H43OiWJ77Zbd9NUM7myrQQz30yPaGQ4&skey=45c59603efbe20e8&v=v12#Comfortaa",
						"ttf": "http://fonts.gstatic.com/s/comfortaa/v12/qLBu5CQmSMt1H43OiWJ77aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/comfortaa/v12/qLBu5CQmSMt1H43OiWJ77T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/comfortaa/v12/qLBu5CQmSMt1H43OiWJ77VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Comfortaa Bold\'",
						"\'Comfortaa-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/comfortaa/v12/fND5XPYKrF2tQDwwfWZJI3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fND5XPYKrF2tQDwwfWZJI1lIn5tFQcqMuf-jhyJP0ps&skey=ab289941219ecbc3&v=v12#Comfortaa",
						"ttf": "http://fonts.gstatic.com/s/comfortaa/v12/fND5XPYKrF2tQDwwfWZJI4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/comfortaa/v12/fND5XPYKrF2tQDwwfWZJI3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/comfortaa/v12/fND5XPYKrF2tQDwwfWZJI-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Coming Soon": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Coming Soon Regular\'",
						"\'ComingSoon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/comingsoon/v8/myblyOycMnPMGjfPG-DzP2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=myblyOycMnPMGjfPG-DzP3NsigHlcrQGNV8nkUSFQfc&skey=70030657e174526a&v=v8#ComingSoon",
						"ttf": "http://fonts.gstatic.com/s/comingsoon/v8/myblyOycMnPMGjfPG-DzP50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/comingsoon/v8/myblyOycMnPMGjfPG-DzP4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/comingsoon/v8/myblyOycMnPMGjfPG-DzP44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Concert One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Concert One\'",
						"\'ConcertOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/concertone/v8/eNLG875uBc3mU2X9z56PW2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eNLG875uBc3mU2X9z56PW3NsigHlcrQGNV8nkUSFQfc&skey=1285a0576bf2d826&v=v8#ConcertOne",
						"ttf": "http://fonts.gstatic.com/s/concertone/v8/eNLG875uBc3mU2X9z56PW50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/concertone/v8/eNLG875uBc3mU2X9z56PW4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/concertone/v8/eNLG875uBc3mU2X9z56PW44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Condiment": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Condiment\'",
						"\'Condiment-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/condiment/v5/H3zUdSYh9r5ccxclUWaH7vY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H3zUdSYh9r5ccxclUWaH7pbd9NUM7myrQQz30yPaGQ4&skey=1c5ef97a58cd7226&v=v5#Condiment",
						"ttf": "http://fonts.gstatic.com/s/condiment/v5/H3zUdSYh9r5ccxclUWaH7qCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/condiment/v5/H3zUdSYh9r5ccxclUWaH7j8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/condiment/v5/H3zUdSYh9r5ccxclUWaH7ltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Content": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Content\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/content/v9/PZX2MCxwdsSQpbDrWABE1Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Tnza_7ZdWJGNOzgNsEijBQ&skey=df16c0bda2ebb594&v=v9#Content",
						"ttf": "http://fonts.gstatic.com/s/content/v9/l8qaLjygvOkDEU2G6-cjfQ.ttf",
						"woff": "http://fonts.gstatic.com/s/content/v9/M0O9oWDDl4w8bnIpEx-Btg.woff",
						"woff2": "http://fonts.gstatic.com/s/content/v9/NqGGtwtsM97PsXgEIdi-RvY6323mHUZFJMgTvxaG2iE.woff2"
					}
				},
				"700": {
					"local": [
						"\'Content Bold\'",
						"\'Content-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/content/v9/cP6jSiiQsi3vjTPLwnV4H_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vjstDQlGI4t_zt9SDTRVW_esZW2xOQ-xsNqO47m55DA&skey=2cb501a81b30e788&v=v9#Content",
						"ttf": "http://fonts.gstatic.com/s/content/v9/7PivP8Zvs2qn6F6aNbSQe_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/content/v9/VMvOugUbEy4AmlBDRm5tlvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/content/v9/zP5-VodsrjYmknQVKQnCyCEAvth_LlrfE80CYdSH47w.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Contrail One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Contrail One\'",
						"\'ContrailOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/contrailone/v7/b41KxjgiyqX-hkggANDU6HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=b41KxjgiyqX-hkggANDU6FlIn5tFQcqMuf-jhyJP0ps&skey=7f950c167c59f33&v=v7#ContrailOne",
						"ttf": "http://fonts.gstatic.com/s/contrailone/v7/b41KxjgiyqX-hkggANDU6InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/contrailone/v7/b41KxjgiyqX-hkggANDU6HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/contrailone/v7/b41KxjgiyqX-hkggANDU6Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Convergence": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Convergence-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/convergence/v6/INPSrw23F_B9ixE5wON7E2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=INPSrw23F_B9ixE5wON7E3NsigHlcrQGNV8nkUSFQfc&skey=435fd5b5d6c5be3a&v=v6#Convergence",
						"ttf": "http://fonts.gstatic.com/s/convergence/v6/INPSrw23F_B9ixE5wON7E50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/convergence/v6/INPSrw23F_B9ixE5wON7E4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/convergence/v6/INPSrw23F_B9ixE5wON7E44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Cookie": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cookie-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cookie/v8/AvlbhNBtDFTvYLPYKo-Lmg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rlu5FEepl9muxv12LnwLGQ&skey=94aef82ff911a990&v=v8#Cookie",
						"ttf": "http://fonts.gstatic.com/s/cookie/v8/pKcurCxn_Ato3MXK6jF2CA.ttf",
						"woff": "http://fonts.gstatic.com/s/cookie/v8/Tvkve1y-JrkMx2S9u2OW1g.woff",
						"woff2": "http://fonts.gstatic.com/s/cookie/v8/crMuSvy3krjox1JAKfe7Ew.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Copse": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Copse\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/copse/v7/SaRjqGjsYPXH0JOASW20XA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=onwR-2wcZGKFflael3oXJQ&skey=7baf73252a4811d6&v=v7#Copse",
						"ttf": "http://fonts.gstatic.com/s/copse/v7/edYpk-Td-Lz5tVC6CefvWQ.ttf",
						"woff": "http://fonts.gstatic.com/s/copse/v7/wpqdPiqIhpZbF5z3WfvSXg.woff",
						"woff2": "http://fonts.gstatic.com/s/copse/v7/EvzY7BX2lKL9aFIS3lS1Mw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Corben": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Corben Regular\'",
						"\'Corben-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/corben/v11/oPh_f4hFy1UEN5VkrZ4FJw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DwGjY7pic_9BgGYmegARuw&skey=795061005e976bd6&v=v11#Corben",
						"ttf": "http://fonts.gstatic.com/s/corben/v11/aAJbkLknKhfXxsbVwcGZiA.ttf",
						"woff": "http://fonts.gstatic.com/s/corben/v11/aTjzBnce-6l9sMpae8_abg.woff",
						"woff2": "http://fonts.gstatic.com/s/corben/v11/EvCyyDNpF00ipP8gU9sM8g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Corben\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/corben/v11/ljkAb4w-83fUltRn9aENdfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ljkAb4w-83fUltRn9aENdZbd9NUM7myrQQz30yPaGQ4&skey=f18040a69657653b&v=v11#Corben",
						"ttf": "http://fonts.gstatic.com/s/corben/v11/ljkAb4w-83fUltRn9aENdaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/corben/v11/ljkAb4w-83fUltRn9aENdT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/corben/v11/ljkAb4w-83fUltRn9aENdVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Cormorant": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Cormorant Light Italic\'",
						"\'Cormorant-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ7XcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UydD9tmk-DfLnEFRr_bBZz4dnM32POWavC8T_whbZeI&skey=880a42c6c2a7e48&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ7fB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZx_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ0o2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Italic\'",
						"\'Cormorant-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/X0EhxUCrSK0o-Ai-a9zFbmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=X0EhxUCrSK0o-Ai-a9zFbnNsigHlcrQGNV8nkUSFQfc&skey=f23e1ca4fc70b108&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/X0EhxUCrSK0o-Ai-a9zFbp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/X0EhxUCrSK0o-Ai-a9zFbobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/X0EhxUCrSK0o-Ai-a9zFbo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Medium Italic\'",
						"\'Cormorant-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZyGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UydD9tmk-DfLnEFRr_bBZ6057wUl25f8_0IloMUHk98&skey=f8ba0d7482015c2a&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ_Mi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZyqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ7BojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant SemiBold Italic\'",
						"\'Cormorant-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ48mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UydD9tmk-DfLnEFRr_bBZ-VmfClkf66xvxL1SWm4y8M&skey=549a685ba96a6462&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZy8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ35HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ12umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Bold Italic\'",
						"\'Cormorant-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ7Ft29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UydD9tmk-DfLnEFRr_bBZ3tNmQEE9wZ6UZlmiISB1pg&skey=9900c6152b34197e&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ5_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZzqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/UydD9tmk-DfLnEFRr_bBZ4lIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Cormorant Light\'",
						"\'Cormorant-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/diggKPcUerIA8GQWRVxsVXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=diggKPcUerIA8GQWRVxsVVlIn5tFQcqMuf-jhyJP0ps&skey=c3b9f7b75bda2dcc&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/diggKPcUerIA8GQWRVxsVYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/diggKPcUerIA8GQWRVxsVXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/diggKPcUerIA8GQWRVxsVegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Regular\'",
						"\'Cormorant-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/a3k4tdhPAhIrqJlC0EH98vY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=a3k4tdhPAhIrqJlC0EH98pbd9NUM7myrQQz30yPaGQ4&skey=c05230f4b79293a6&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/a3k4tdhPAhIrqJlC0EH98qCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/a3k4tdhPAhIrqJlC0EH98j8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/a3k4tdhPAhIrqJlC0EH98ltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Medium\'",
						"\'Cormorant-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/lwoiMb1lzDf49h802vpRU3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lwoiMb1lzDf49h802vpRU1lIn5tFQcqMuf-jhyJP0ps&skey=833754039073fdc&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/lwoiMb1lzDf49h802vpRU4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/lwoiMb1lzDf49h802vpRU3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/lwoiMb1lzDf49h802vpRU-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant SemiBold\'",
						"\'Cormorant-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/LKEtp8XimHLN0gSYqnV9q3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LKEtp8XimHLN0gSYqnV9q1lIn5tFQcqMuf-jhyJP0ps&skey=c7d791cddd8b143c&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/LKEtp8XimHLN0gSYqnV9q4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/LKEtp8XimHLN0gSYqnV9q3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/LKEtp8XimHLN0gSYqnV9q-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Bold\'",
						"\'Cormorant-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorant/v6/vOi7JV5F3JmPzXDgUqUwgXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vOi7JV5F3JmPzXDgUqUwgVlIn5tFQcqMuf-jhyJP0ps&skey=b5890d6cd81a661b&v=v6#Cormorant",
						"ttf": "http://fonts.gstatic.com/s/cormorant/v6/vOi7JV5F3JmPzXDgUqUwgYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorant/v6/vOi7JV5F3JmPzXDgUqUwgXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorant/v6/vOi7JV5F3JmPzXDgUqUwgegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Cormorant Garamond": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Cormorant Garamond Light Italic\'",
						"\'CormorantGaramond-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAsIonp6ci5sIIF8I0CYUPHM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zuqx3k1yUEl3Eavo-ZPEAnjESNuVfmS59bIr2OZNmYk&skey=5a7e0a432eb14fbf&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAsNCjhL5_UAcr6Fg15s7jRs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAqyrRV_tIifNkmsmT8g7olw.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAk1a5chL7g1_Dzbpl9Y2HS4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Garamond Italic\'",
						"\'CormorantGaramond-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/eGTlzchVxDKKvK6d7drzlv3Eu8_68mSlrpbe9octpU8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eGTlzchVxDKKvK6d7drzlgVx7dPQKYK221VpyP9wyu4&skey=e666f2218a05acfc&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/eGTlzchVxDKKvK6d7drzls5ux_fkf2WtJNEJ_Ye5UcI.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/eGTlzchVxDKKvK6d7drzlhlILEOOqbUhwO090YxLAIg.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/eGTlzchVxDKKvK6d7drzlvi-tDgJCth50KiWWhEUOb0.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Garamond Medium Italic\'",
						"\'CormorantGaramond-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAvXGhwtBxpb0eJGvUa-ek7I.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zuqx3k1yUEl3Eavo-ZPEAoREhBWAc1mo-hP_GZSkk8I&skey=a646f7df62b0db07&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEApJumYBmio9YKbn4NORNjEc.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAuIuWuUVGs6DBgKnXWjrzq8.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAkAn4njGiYbajs3ik7RUrHA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Garamond SemiBold Italic\'",
						"\'CormorantGaramond-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAs9J62uuWEX63OuAuRDWwUA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zuqx3k1yUEl3Eavo-ZPEAvR5Xnz5XYxDveevkuu08Wo&skey=d056cd8e7bb95ad3&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAsUCiVZTo-JXJa6XqsPCVHg.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAiFOsv39XUIL1JdtCj5yE6A.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAvuBmOAjgXjTgmI0gOXy3PQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Garamond Bold Italic\'",
						"\'CormorantGaramond-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAtoGHHA9uTnR0LAxJqWVx2U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zuqx3k1yUEl3Eavo-ZPEAlPqxt12q7OI7Kq1oaqy4Eg&skey=f5baa31c9854d669&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAt8S1j5v-CP0qmZBFVt-now.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEApDJE9n0KeI0HkpYHJ2LJNY.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/zuqx3k1yUEl3Eavo-ZPEAjU8ONjE7togmghLbfzbi70.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Cormorant Garamond Light\'",
						"\'CormorantGaramond-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVcK_Saxcyma4a0Bodz6By8E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iEjm9hVxcattz37Y8gZwVVJ6I2x41GYRGb4SA9cHNZk&skey=4f9ed6f80d6d2fa0&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVSQdpKdeLmun5SMGMgzYaNU.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVXaXk_mX7l4uWyLGS2OE0mg.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVbq2HNNMYxbOC04F0CNdzo8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Garamond Regular\'",
						"\'CormorantGaramond-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/EI2hhCO6kSfLAy-Dpd8fd7A7rPYlTFFb1dWI3HxNjko.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EI2hhCO6kSfLAy-Dpd8fd18nY0ODyfEW4CEBwIje-vE&skey=a863d1376a24bd7a&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/EI2hhCO6kSfLAy-Dpd8fd4kMrRif0q9E9OjhWn94a1w.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/EI2hhCO6kSfLAy-Dpd8fd1sHIhYSIhHw3A-puTCbotg.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/EI2hhCO6kSfLAy-Dpd8fdz_Dq57Lo4snLFwBvsf35Hk.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Garamond Medium\'",
						"\'CormorantGaramond-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVUnoksshKNug3KcSGA0jCeI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iEjm9hVxcattz37Y8gZwVZ80hmK63bxuGvyS7iDDnVU&skey=4b255bdbddcd870c&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVTjghypltJZSOvk0SFLkcps.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVbdD_IlHZhs2xl0ydswEjhg.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVUyux-RXTyQM084ahe4LYXE.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Garamond SemiBold\'",
						"\'CormorantGaramond-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVYLVN3mU72bF7r917pgRegw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iEjm9hVxcattz37Y8gZwVQHrTSfT0OEsLnb5JS1a6Vk&skey=e242efc8b3e67934&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVX71SRp7iEcZunvsEDXrMGM.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVd8W8Y8iIas0OzpbVv9k_mE.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVSDaxQnMxYi0rwij4J-0vzQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Garamond Bold\'",
						"\'CormorantGaramond-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVbCYi3_PUJJqGUzMdP59Ij4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iEjm9hVxcattz37Y8gZwVecOoGLnMCc6qVb8DnlTdjM&skey=3181ffd829cb74e8&v=v5#CormorantGaramond",
						"ttf": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVSfTVYHkE7Q6l_m6H82D6QI.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVcxEvrGxMmMLD21UBWfRwis.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantgaramond/v5/iEjm9hVxcattz37Y8gZwVX9I6T0daTnoiQ8pbdYJRgI.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cormorant Infant": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Cormorant Infant Light Italic\'",
						"\'CormorantInfant-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZk1l6r80beOvFFuHgDe_HKo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PK34LKusK6SSQFR2m5-LZn64s3HN9Fh47nG4V0ZNSeQ&skey=5a222cc4df1e5ad3&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZrLPLGapjQTrSKmzWE_DOks.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZsJTKEZNd3Wl_va5cPmIuJY.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZsDfyThnvKzRNbP862VynNA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Infant Italic\'",
						"\'CormorantInfant-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/U6OamtMgLoVs0zd53Z1pNiGqy0fNFHBJukydEyJ-MFU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=U6OamtMgLoVs0zd53Z1pNknjcG4AVZrEfaWWYHmdl0I&skey=2e9662bb641ae17d&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/U6OamtMgLoVs0zd53Z1pNrsRZCUli5OgvB5zNuM1-Jg.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/U6OamtMgLoVs0zd53Z1pNlLwo_ckafZeYvYWsH5-Yg0.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/U6OamtMgLoVs0zd53Z1pNhtLmK_1LtVM-jDKGWQi5qM.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Infant Medium Italic\'",
						"\'CormorantInfant-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZgSyDh0AjQ9K-VBoGMr5G7Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PK34LKusK6SSQFR2m5-LZgrEER2xrjdk6b8NBFLazhc&skey=3a86116fb43424ce&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZu5ZKDWf9tcewwfqbyLqbac.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZow__mb_6FJpoLDjWdnxSeQ.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZhvpF_oROILdTmjWA-fYvgY.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Infant SemiBold Italic\'",
						"\'CormorantInfant-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZoqJF9yibF-aTN-r1FF8O8w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PK34LKusK6SSQFR2m5-LZiBh8DWFobNa4_9PGV7ksfo&skey=57e45992617c5d88&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZoC9nxr4SFwKNDyWIiyIMnQ.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZkjMclkysorNA9pQpnZZQlg.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZgcRuwDh0lrqFjSrJcomUhs.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Infant Bold Italic\'",
						"\'CormorantInfant-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZpKimqfvsP4_CKZCN7uoEag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PK34LKusK6SSQFR2m5-LZoUyy00nVufCKFVA8CyUQlQ&skey=b08a1c81931048ec&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZi7OZ9nzuSbhlQEVxbd6Olg.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZtyGdhjEaFMDqTQH0JWlrzo.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/PK34LKusK6SSQFR2m5-LZuIS24wLkkFXta2XoW_c_J0.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Cormorant Infant Light\'",
						"\'CormorantInfant-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWAylfM5mBpRPa8poVdDk2C9o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MYRpw6pQIf0XStsiZXQWA1KvSngRfd4PcWtoGF-XsFE&skey=5f109f4d358767e3&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA0zFmC7ldwKqPA7Xd2axruo.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWAxXOWgUuhDhHi_TZYJn8w1U.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWAxWnszh93dz1rYjU-7UqxBo.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Infant Regular\'",
						"\'CormorantInfant-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/q5F0I_a42y_qtMoOtqdjauwobfhHQBg3nYQC92I6HZg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=q5F0I_a42y_qtMoOtqdjaosF1_unMR-QG8w534oROwo&skey=191b710ab676f949&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/q5F0I_a42y_qtMoOtqdjap_kMFPQScnT1KLK5AAB4Vk.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/q5F0I_a42y_qtMoOtqdjaibaIONxpuMbZxSQxXNr52U.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/q5F0I_a42y_qtMoOtqdjaqUHlN5pzpFqzCHbBIoLoe0.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Infant Medium\'",
						"\'CormorantInfant-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA0q6PFWEalTxyjX8YHC-6Pc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MYRpw6pQIf0XStsiZXQWA6wjLTecxrZDJIkPtOcnUHE&skey=9c07b366853033e1&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA4W3JxRFe6-bFBfRSUPqvtY.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWAy3JTczdWSCNAoCnVfxCLAE.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA06EZsElmslnjjrChLRrr-k.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Infant SemiBold\'",
						"\'CormorantInfant-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA2o8GHOjeBctzkleE4BBfu4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MYRpw6pQIf0XStsiZXQWA6iTp50ug9sTwv84tXwXzg4&skey=4daaa67c23ef9ea3&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA7bkYF-e_ojcSCxHAdyWaMQ.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA9PGcz3TVZjLR05J6rDQALw.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA77_nnXCXQSo_-8CQRfqA7c.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Infant Bold\'",
						"\'CormorantInfant-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA8-RreHDJ1ZzN-wkJ7Nw5kM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MYRpw6pQIf0XStsiZXQWA9Tpzqp6BN3ypSSmUgr7Qos&skey=b80b86fd334527b0&v=v5#CormorantInfant",
						"ttf": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA_v-P1LUU_ts_zgtFeQnXSo.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA4H5wH23sY8eP-3-EddFGCs.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantinfant/v5/MYRpw6pQIf0XStsiZXQWA9RD16anxOmL9aQNUdy835c.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cormorant SC": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Cormorant SC Light\'",
						"\'CormorantSC-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em4ySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CCo4fI9EYzhUJcvojQ9Em7Jg1hA63dzswhy4NvEPrPM&skey=739b51737c4e164&v=v5#CormorantSC",
						"ttf": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9EmwV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em2Fp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em04GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant SC Regular\'",
						"\'CormorantSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantsc/v5/o2HxNCgvhmwJdltu-68tzHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o2HxNCgvhmwJdltu-68tzFlIn5tFQcqMuf-jhyJP0ps&skey=82bbbf476a8d515d&v=v5#CormorantSC",
						"ttf": "http://fonts.gstatic.com/s/cormorantsc/v5/o2HxNCgvhmwJdltu-68tzInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantsc/v5/o2HxNCgvhmwJdltu-68tzHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantsc/v5/o2HxNCgvhmwJdltu-68tzOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant SC Medium\'",
						"\'CormorantSC-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9EmzHhXAPWOXQc-mHRKx4oalk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CCo4fI9EYzhUJcvojQ9Em5XlX4y0PMY0_OO7hHc9JEY&skey=8f4513ca99abc97a&v=v5#CormorantSC",
						"ttf": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9EmyfxicYksyVqdB8nkjIZw2U.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9EmxF47VQSRrvbVYTKIrepY7I.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em81Lch-SD8r0CsJ60meulZ8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant SC SemiBold\'",
						"\'CormorantSC-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9EmzBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CCo4fI9EYzhUJcvojQ9EmwmE8htD-SDrf7umQTfloJ8&skey=1809bdbff8003e75&v=v5#CormorantSC",
						"ttf": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em1FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em9Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant SC Bold\'",
						"\'CormorantSC-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em2msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CCo4fI9EYzhUJcvojQ9Emway50PuN8loMJ9QAXsTs7U&skey=70405b16820408e1&v=v5#CormorantSC",
						"ttf": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em3l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantsc/v5/CCo4fI9EYzhUJcvojQ9Em3NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cormorant Unicase": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Cormorant Unicase Light\'",
						"\'CormorantUnicase-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78baFYWcDhWThYiU_vxXZ-Ic.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-0mwRHhjEGfrz-UDHJ_78c_8yZRSjnE_tx8VWhvitRw&skey=18d98ec96ab6d046&v=v5#CormorantUnicase",
						"ttf": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78a0mvxAi2j_H3-jANOJ2OrM.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78QyenP_6tcDutaIcWOMBVxs.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78QLYLyumkWDy1IB1yMHhsy0.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Unicase Regular\'",
						"\'CormorantUnicase-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantunicase/v5/THO7JMNV6qRoZlg7dU5RU7J579XPyf5w_e4dpcN0w5c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=THO7JMNV6qRoZlg7dU5RU5YNmi4m9UCJ13Ly0qAmAqM&skey=bf63b41c202e7150&v=v5#CormorantUnicase",
						"ttf": "http://fonts.gstatic.com/s/cormorantunicase/v5/THO7JMNV6qRoZlg7dU5RU3xb6Ri5MrI9qko7kWN_Zqg.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantunicase/v5/THO7JMNV6qRoZlg7dU5RU5XiJPBBMcWu5WZdBWAC5O4.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantunicase/v5/THO7JMNV6qRoZlg7dU5RU_cdzvvv5MYKD6utEEPcVNs.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Unicase Medium\'",
						"\'CormorantUnicase-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78eQt_2wR8mlzv0hW0zF2X2Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-0mwRHhjEGfrz-UDHJ_78agqb4rUZWDheLmsjsiekIk&skey=ec1f95dcc37c8c7c&v=v5#CormorantUnicase",
						"ttf": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78fM3b32M8G6VHdlvMuSXXWc.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78WuwWS30Qk05PFSwKwQwLQQ.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78fYmRk4Dl7PhGwKVQvbYer4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Unicase SemiBold\'",
						"\'CormorantUnicase-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78do2gW15UXBtFVlzDy-6yA8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-0mwRHhjEGfrz-UDHJ_78W2JfZ82EaVgm5NXdYVr8KU&skey=11970fa560cef00d&v=v5#CormorantUnicase",
						"ttf": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78R2xZ6Gy16PRYn5b4ctr2YE.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78bEVh8b2eW_IxnykwfCszUE.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78TfIgdKhq_lM1hXrFAB3o4E.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Unicase Bold\'",
						"\'CormorantUnicase-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78WXYhdKIITmqzD-i-MR8sgA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-0mwRHhjEGfrz-UDHJ_78W0bNhPAJBEmhR9nYxAIbLM&skey=a156c753a4db3d87&v=v5#CormorantUnicase",
						"ttf": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78f5MiiEEpSRYm7fubQBNHMQ.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78bFVqfl0HcTxDmY60us5UPc.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantunicase/v5/-0mwRHhjEGfrz-UDHJ_78WUTMAaQ67hLOyIi30GwwkY.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cormorant Upright": {
		"category": "serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Cormorant Upright Light\'",
						"\'CormorantUpright-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhqN0StmtEvanoRFxXGV2WKI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PwJT_lCdbLUyVq-tARIPhszGlXPhHxB_-0qjWPBpCb8&skey=444efa8ce6de5368&v=v4#CormorantUpright",
						"ttf": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhmSwOeXzphgTfTN_ZHkPbqo.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhn5bBInF14bnWk55xDvx4bo.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhkqZwijb5u7E_vLfI3Egrkg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Cormorant Upright Regular\'",
						"\'CormorantUpright-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantupright/v4/0n68kajKjTOJn9EPQkf1a_UQuUHXIFS8M6YSOWwCW5Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0n68kajKjTOJn9EPQkf1a-JArmX-di4nWXTZRxKXfro&skey=337674b8a2620d4c&v=v4#CormorantUpright",
						"ttf": "http://fonts.gstatic.com/s/cormorantupright/v4/0n68kajKjTOJn9EPQkf1a5OaXSpdknEt7iHrNREE1MM.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantupright/v4/0n68kajKjTOJn9EPQkf1a2cB5_PywX5dwxDqbBrm1FM.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantupright/v4/0n68kajKjTOJn9EPQkf1a2KGeloe5agWzlv_cnXIcU8.woff2"
					}
				},
				"500": {
					"local": [
						"\'Cormorant Upright Medium\'",
						"\'CormorantUpright-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhpIzOOoP9NxrTLmHoIkBwYU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PwJT_lCdbLUyVq-tARIPhtMdm2xi2WrJiZIPVa_jVyg&skey=ffe466e75f51040c&v=v4#CormorantUpright",
						"ttf": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhvxAifkduG_szRin_CEAqRc.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhrPJZVd1C5kQ1yJAwTxPe-E.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhkAdyfjNmtktGTvOL2ZHcM8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Cormorant Upright SemiBold\'",
						"\'CormorantUpright-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhkA_5W4gMOJw9sz9a7tj8JU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PwJT_lCdbLUyVq-tARIPhhET6cqVV5fOLdiskoDnPu8&skey=a9628e630da51a5c&v=v4#CormorantUpright",
						"ttf": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhtrQSFc8eE7ZMY-tyfVKqI8.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhh1wmlESxvBaEgOdRSouGn4.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhpufg5sqW1wMrg2nQaBJhD8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cormorant Upright Bold\'",
						"\'CormorantUpright-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhiUeBLZYHA4rTgjz-1fxYPw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PwJT_lCdbLUyVq-tARIPhqqkySAXAgt6r5HluS6W9fc&skey=d2e4c124fe569662&v=v4#CormorantUpright",
						"ttf": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhtI_D1BbroCaYCTT5zSQe2Q.ttf",
						"woff": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhlyslxDQSg6Tp6plIwOp9Ig.woff",
						"woff2": "http://fonts.gstatic.com/s/cormorantupright/v4/PwJT_lCdbLUyVq-tARIPhjryNLZLENh0Qj0dfVCMpMs.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Courgette": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Courgette Regular\'",
						"\'Courgette-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/courgette/v5/BHG8ZtTfO0yYnp02--QxqvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BHG8ZtTfO0yYnp02--Qxqpbd9NUM7myrQQz30yPaGQ4&skey=427bdd45dca77eaa&v=v5#Courgette",
						"ttf": "http://fonts.gstatic.com/s/courgette/v5/BHG8ZtTfO0yYnp02--QxqqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/courgette/v5/BHG8ZtTfO0yYnp02--Qxqj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/courgette/v5/BHG8ZtTfO0yYnp02--QxqltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Cousine": {
		"category": "monospace",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"hebrew",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cousine Italic\'",
						"\'Cousine-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cousine/v12/0VdvlOBfHobA4eW-NVYk-fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0VdvlOBfHobA4eW-NVYk-Zbd9NUM7myrQQz30yPaGQ4&skey=411d53aa792d7323&v=v12#Cousine",
						"ttf": "http://fonts.gstatic.com/s/cousine/v12/0VdvlOBfHobA4eW-NVYk-aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cousine/v12/0VdvlOBfHobA4eW-NVYk-T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cousine/v12/0VdvlOBfHobA4eW-NVYk-VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cousine Bold Italic\'",
						"\'Cousine-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cousine/v12/y_AZ5Sz-FwL1lux2xLSTZXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y_AZ5Sz-FwL1lux2xLSTZVlIn5tFQcqMuf-jhyJP0ps&skey=98288f72a06d874e&v=v12#Cousine",
						"ttf": "http://fonts.gstatic.com/s/cousine/v12/y_AZ5Sz-FwL1lux2xLSTZYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/cousine/v12/y_AZ5Sz-FwL1lux2xLSTZXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/cousine/v12/y_AZ5Sz-FwL1lux2xLSTZegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cousine Regular\'",
						"\'Cousine-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cousine/v12/Iz7pvencvJaRY0n_qrj9QQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0X1FJFCMbkrDMPxpGv_13A&skey=76eb36959adb8e1f&v=v12#Cousine",
						"ttf": "http://fonts.gstatic.com/s/cousine/v12/DwTQUBZUm7p0EqFjmSeK4w.ttf",
						"woff": "http://fonts.gstatic.com/s/cousine/v12/CJJ-BXzwL4jWItOg5qolAA.woff",
						"woff2": "http://fonts.gstatic.com/s/cousine/v12/0IpceuvDvCegpU9Mz8MQ_g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cousine Bold\'",
						"\'Cousine-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cousine/v12/XkYjaL8YjqL9qW8o0T14uVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XkYjaL8YjqL9qW8o0T14uaWUboTb-jS2tyCOQMtm97g&skey=d102cd33d1abdbf6&v=v12#Cousine",
						"ttf": "http://fonts.gstatic.com/s/cousine/v12/XkYjaL8YjqL9qW8o0T14uS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/cousine/v12/XkYjaL8YjqL9qW8o0T14uRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/cousine/v12/XkYjaL8YjqL9qW8o0T14ufk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Coustard": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Coustard Regular\'",
						"\'Coustard-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coustard/v8/tHBu-R-Hi9cgTu8jYR-JrPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TqUBwv8DtvsfPWLKeKXUC_esZW2xOQ-xsNqO47m55DA&skey=c590e3818c6baa04&v=v8#Coustard",
						"ttf": "http://fonts.gstatic.com/s/coustard/v8/A3DqZ8KQbto2lGg0IL8SIvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/coustard/v8/7Z1TmjHUqIGEzERrLfAhXPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/coustard/v8/CiiNyGc8YnqCRxLykGN1ofesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Coustard Black\'",
						"\'Coustard-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coustard/v8/zZrOBKsm_2zXTCex2CMWjWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zZrOBKsm_2zXTCex2CMWjXNsigHlcrQGNV8nkUSFQfc&skey=8cbd71770ec740f2&v=v8#Coustard",
						"ttf": "http://fonts.gstatic.com/s/coustard/v8/zZrOBKsm_2zXTCex2CMWjZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/coustard/v8/zZrOBKsm_2zXTCex2CMWjYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/coustard/v8/zZrOBKsm_2zXTCex2CMWjY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Covered By Your Grace": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Covered By Your Grace\'",
						"\'CoveredByYourGrace\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/coveredbyyourgrace/v7/6ozZp4BPlrbDRWPe3EBGA58c6rNJqxkMhP41jWBjFFA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6ozZp4BPlrbDRWPe3EBGAzIMlaJ2Rtxh6xtdPLZiq0Q&skey=5b102ce185343299&v=v7#CoveredByYourGrace",
						"ttf": "http://fonts.gstatic.com/s/coveredbyyourgrace/v7/6ozZp4BPlrbDRWPe3EBGA8Swx7O1nRJXGXrmuE0DD7s.ttf",
						"woff": "http://fonts.gstatic.com/s/coveredbyyourgrace/v7/6ozZp4BPlrbDRWPe3EBGAzcaOoGrwtJRci4wjFnSRpA.woff",
						"woff2": "http://fonts.gstatic.com/s/coveredbyyourgrace/v7/6ozZp4BPlrbDRWPe3EBGAxIQb9tn0GTKNjAuszxKf4A.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Crafty Girls": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Crafty Girls Regular\'",
						"\'CraftyGirls-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/craftygirls/v7/0Sv8UWFFdhQmesHL32H8o3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0Sv8UWFFdhQmesHL32H8o1lIn5tFQcqMuf-jhyJP0ps&skey=91eaf80902c91de4&v=v7#CraftyGirls",
						"ttf": "http://fonts.gstatic.com/s/craftygirls/v7/0Sv8UWFFdhQmesHL32H8o4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/craftygirls/v7/0Sv8UWFFdhQmesHL32H8o3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/craftygirls/v7/0Sv8UWFFdhQmesHL32H8o-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Creepster": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Creepster\'",
						"\'Creepster-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/creepster/v6/un014as1qOcrVg1hrkn_UfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=un014as1qOcrVg1hrkn_UZbd9NUM7myrQQz30yPaGQ4&skey=de4b92872e661f36&v=v6#Creepster",
						"ttf": "http://fonts.gstatic.com/s/creepster/v6/un014as1qOcrVg1hrkn_UaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/creepster/v6/un014as1qOcrVg1hrkn_UT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/creepster/v6/un014as1qOcrVg1hrkn_UVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Crete Round": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Crete Round Italic\'",
						"\'CreteRound-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/creteround/v6/5xAt7XK2vkUdjhGtt98unaSxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5xAt7XK2vkUdjhGtt98unTGefNBPGWcFPRAoUX_lgLU&skey=8176e819c3fe9b&v=v6#CreteRound",
						"ttf": "http://fonts.gstatic.com/s/creteround/v6/5xAt7XK2vkUdjhGtt98uneLrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/creteround/v6/5xAt7XK2vkUdjhGtt98undkZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/creteround/v6/5xAt7XK2vkUdjhGtt98uncu2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Crete Round\'",
						"\'CreteRound-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/creteround/v6/ZCcPJiCGOzh84o2siPk48WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZCcPJiCGOzh84o2siPk48XNsigHlcrQGNV8nkUSFQfc&skey=d604d2367fd68cff&v=v6#CreteRound",
						"ttf": "http://fonts.gstatic.com/s/creteround/v6/ZCcPJiCGOzh84o2siPk48Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/creteround/v6/ZCcPJiCGOzh84o2siPk48YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/creteround/v6/ZCcPJiCGOzh84o2siPk48Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Crimson Text": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Crimson Text Italic\'",
						"\'CrimsonText-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/a5QZnvmn5amyNI-t2BMkWDoGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=a5QZnvmn5amyNI-t2BMkWH2UFnxWCzsMUZbVj2XRF5M&skey=e557500e250d718b&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/a5QZnvmn5amyNI-t2BMkWCtfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/a5QZnvmn5amyNI-t2BMkWHpumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/a5QZnvmn5amyNI-t2BMkWBMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Crimson Text SemiBold Italic\'",
						"\'CrimsonText-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDBHNzmFb2hSkh0OZsv7eSbE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4j4TR-EfnvCt43InYpUNDJxbAKLHh33tiENh7myeekA&skey=297741408878cce6&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDDolfeppZzFSKvLyJNPKLMk.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDKxza3rXaV_G32gF04a66fI.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDErrE62zycmuf6NB1JeYrwM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Crimson Text Bold Italic\'",
						"\'CrimsonText-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDCy7jlJQNiTiB3-MejPw_5E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4j4TR-EfnvCt43InYpUNDOiOBN1C42tFdXFKJTGlCXo&skey=278c8c85e53f0d85&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDCxQL91WRy8t8mPvAX_dIgA.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDL0qgHI2SEqiJszC-CVc3gY.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/4j4TR-EfnvCt43InYpUNDEcqRxak6Wc5LUVz-l064SE.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Crimson Text Regular\'",
						"\'CrimsonText-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/3IFMwfRa07i-auYR-B-zNXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3IFMwfRa07i-auYR-B-zNVlIn5tFQcqMuf-jhyJP0ps&skey=28fc2c78007b71a9&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/3IFMwfRa07i-auYR-B-zNYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/3IFMwfRa07i-auYR-B-zNXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/3IFMwfRa07i-auYR-B-zNegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Crimson Text SemiBold\'",
						"\'CrimsonText-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3IzBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rEy5tGc5HdXy56Xvd4f3IwmE8htD-SDrf7umQTfloJ8&skey=8d0e5c65248ec1b9&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I1FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I9Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Crimson Text Bold\'",
						"\'CrimsonText-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I2msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rEy5tGc5HdXy56Xvd4f3Iway50PuN8loMJ9QAXsTs7U&skey=ac5d7eee4a23d97&v=v8#CrimsonText",
						"ttf": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I3l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/crimsontext/v8/rEy5tGc5HdXy56Xvd4f3I3NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Croissant One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Croissant One\'",
						"\'CroissantOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/croissantone/v5/mPjsOObnC77fp1cvZlOfIcOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mPjsOObnC77fp1cvZlOfITyKAGS2js9R2mTcvyyc0eU&skey=ce9dfb7622c55a85&v=v5#CroissantOne",
						"ttf": "http://fonts.gstatic.com/s/croissantone/v5/mPjsOObnC77fp1cvZlOfISbsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/croissantone/v5/mPjsOObnC77fp1cvZlOfIfn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/croissantone/v5/mPjsOObnC77fp1cvZlOfITxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Crushed": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Crushed Regular\'",
						"\'Crushed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/crushed/v8/Kb1pznMbNju83ecfjGBryQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ye5OITBNKbpcLgV325ly-Q&skey=984f724488e53bfa&v=v8#Crushed",
						"ttf": "http://fonts.gstatic.com/s/crushed/v8/YIdTMeWIkibBbaflhmOxCQ.ttf",
						"woff": "http://fonts.gstatic.com/s/crushed/v8/vJMMhmuCfoluXaHh_7G6Og.woff",
						"woff2": "http://fonts.gstatic.com/s/crushed/v8/v7vtb87rXXPD_dUy3UIUrw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Cuprum": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Cuprum Italic\'",
						"\'Cuprum-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cuprum/v9/j1ineI03kVVOJFqE7ocuIfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=APb3vVfvsZNHW1EiNn7t5vesZW2xOQ-xsNqO47m55DA&skey=e4f5190924c87a50&v=v9#Cuprum",
						"ttf": "http://fonts.gstatic.com/s/cuprum/v9/l3yrRVaqvH5GB04fhOvAifesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/cuprum/v9/ZqGKlaN5npewtoCRUIPIrvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/cuprum/v9/7Tr22pFIqlbT5cnmIKi5P_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cuprum Bold Italic\'",
						"\'Cuprum-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cuprum/v9/qoCTdBYim27O_DVk90C7-WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qoCTdBYim27O_DVk90C7-XNsigHlcrQGNV8nkUSFQfc&skey=5ed0713c7afd3827&v=v9#Cuprum",
						"ttf": "http://fonts.gstatic.com/s/cuprum/v9/qoCTdBYim27O_DVk90C7-Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cuprum/v9/qoCTdBYim27O_DVk90C7-YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cuprum/v9/qoCTdBYim27O_DVk90C7-Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Cuprum Regular\'",
						"\'Cuprum-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cuprum/v9/-iGmidt4SirRkI4DjBoTLA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6wwhMqhIwKdXuLa4UEiOsQ&skey=89fd952ea8dac949&v=v9#Cuprum",
						"ttf": "http://fonts.gstatic.com/s/cuprum/v9/PKBzyL4HSyakLt5dMEVc8A.ttf",
						"woff": "http://fonts.gstatic.com/s/cuprum/v9/sp1_LTSOMWWV0K5VTuZzvQ.woff",
						"woff2": "http://fonts.gstatic.com/s/cuprum/v9/rZj40-VH1f1Wt0yg6Fkbcw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Cuprum Bold\'",
						"\'Cuprum-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cuprum/v9/SfDyn5tWOk7I1we45jpLK_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SfDyn5tWOk7I1we45jpLK5bd9NUM7myrQQz30yPaGQ4&skey=7b6263ce29ee5ae7&v=v9#Cuprum",
						"ttf": "http://fonts.gstatic.com/s/cuprum/v9/SfDyn5tWOk7I1we45jpLK6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/cuprum/v9/SfDyn5tWOk7I1we45jpLKz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/cuprum/v9/SfDyn5tWOk7I1we45jpLK1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Cutive": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cutive\'",
						"\'Cutive-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cutive/v9/LbPUck5fxYAMFWtgSLnJLw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7vdadBPSnoaRC044a9yzXw&skey=2312c8de064fc8e4&v=v9#Cutive",
						"ttf": "http://fonts.gstatic.com/s/cutive/v9/6dUc_M1PDZZCBfdFvQn4lQ.ttf",
						"woff": "http://fonts.gstatic.com/s/cutive/v9/7pMILQtbblPmQbuabt3G-g.woff",
						"woff2": "http://fonts.gstatic.com/s/cutive/v9/BHU-qucEWl3Sj8ChiFuLDA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Cutive Mono": {
		"category": "monospace",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Cutive Mono Regular\'",
						"\'CutiveMono-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/cutivemono/v6/N5odNRruTwjvCM8y77PhQWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=N5odNRruTwjvCM8y77PhQXNsigHlcrQGNV8nkUSFQfc&skey=41a3d1bf4e17a723&v=v6#CutiveMono",
						"ttf": "http://fonts.gstatic.com/s/cutivemono/v6/N5odNRruTwjvCM8y77PhQZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/cutivemono/v6/N5odNRruTwjvCM8y77PhQYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/cutivemono/v6/N5odNRruTwjvCM8y77PhQY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Damion": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Damion\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/damion/v7/bXcvEiCQ_q7eKaDwIcgSIg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=znZB7juxF20-t_2Gy-QW4g&skey=cab2b817d665dc28&v=v7#Damion",
						"ttf": "http://fonts.gstatic.com/s/damion/v7/dGdglhCE3HXjR5yo_XK_2g.ttf",
						"woff": "http://fonts.gstatic.com/s/damion/v7/qyDz-al48wZmmi6RcQn1Mg.woff",
						"woff2": "http://fonts.gstatic.com/s/damion/v7/DwAj7ratfj53tabaOiOW3g.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Dancing Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dancing Script Regular\'",
						"\'DancingScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dancingscript/v9/DK0eTGXiZjN6yA8zAEyM2WrfpCc_r9-5ZnZPBmoO4Sk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DK0eTGXiZjN6yA8zAEyM2WNb_15wyZifjqRY11zN25A&skey=c89f400061e5d0a8&v=v9#DancingScript",
						"ttf": "http://fonts.gstatic.com/s/dancingscript/v9/DK0eTGXiZjN6yA8zAEyM2S5FJMZltoAAwO2fP7iHu2o.ttf",
						"woff": "http://fonts.gstatic.com/s/dancingscript/v9/DK0eTGXiZjN6yA8zAEyM2VhlQWQpSCpzb2Peu3I-Q34.woff",
						"woff2": "http://fonts.gstatic.com/s/dancingscript/v9/DK0eTGXiZjN6yA8zAEyM2Ud0sm1ffa_JvZxsF_BEwQk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Dancing Script Bold\'",
						"\'DancingScript-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dancingscript/v9/KGBfwabt0ZRLA5W1ywjoweUZr5SaR2Q2Y08giTcxFsw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KGBfwabt0ZRLA5W1ywjowetrk9OkeHJKmhbkTjrel6s&skey=4fd71febfd48d6c&v=v9#DancingScript",
						"ttf": "http://fonts.gstatic.com/s/dancingscript/v9/KGBfwabt0ZRLA5W1ywjowQGh4C6WC-OkTmtn1VvY3nc.ttf",
						"woff": "http://fonts.gstatic.com/s/dancingscript/v9/KGBfwabt0ZRLA5W1ywjowfVc48Rxw3pIW-IHeDZiIVI.woff",
						"woff2": "http://fonts.gstatic.com/s/dancingscript/v9/KGBfwabt0ZRLA5W1ywjowUHdOuSHeh0r6jGTOGdAKHA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Dangrek": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dangrek\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dangrek/v9/nJiUOM-fiSRSzSvEDCFSZA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nUoU9St-F-XYIxT8qGSNnw&skey=8288af14c49c5c05&v=v9#Dangrek",
						"ttf": "http://fonts.gstatic.com/s/dangrek/v9/LOaFhBT-EHNxZjV8DAW_ew.ttf",
						"woff": "http://fonts.gstatic.com/s/dangrek/v9/Jboa16uSjso_uwOnw9t-Rw.woff",
						"woff2": "http://fonts.gstatic.com/s/dangrek/v9/Wm83ZaEqIOtRdkkRHf4JIfY6323mHUZFJMgTvxaG2iE.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"David Libre": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"hebrew",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'David Libre\'",
						"\'DavidLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/davidlibre/v2/Vz9vXoACjmVAoW3IxuaHLWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vz9vXoACjmVAoW3IxuaHLXNsigHlcrQGNV8nkUSFQfc&skey=3edeced652c7f867&v=v2#DavidLibre",
						"ttf": "http://fonts.gstatic.com/s/davidlibre/v2/Vz9vXoACjmVAoW3IxuaHLZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/davidlibre/v2/Vz9vXoACjmVAoW3IxuaHLYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/davidlibre/v2/Vz9vXoACjmVAoW3IxuaHLY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'David Libre Medium\'",
						"\'DavidLibre-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyiGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ea-623K8OFNeGhfSzdpmyq057wUl25f8_0IloMUHk98&skey=68ec32da19b248d3&v=v2#DavidLibre",
						"ttf": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyvMi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyiqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyrBojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"700": {
					"local": [
						"\'David Libre Bold\'",
						"\'DavidLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyrFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ea-623K8OFNeGhfSzdpmyntNmQEE9wZ6UZlmiISB1pg&skey=d1ee03efca576c07&v=v2#DavidLibre",
						"ttf": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyp_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyjqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/davidlibre/v2/ea-623K8OFNeGhfSzdpmyolIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Dawning of a New Day": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dawning of a New Day\'",
						"\'DawningofaNewDay\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dawningofanewday/v8/JiDsRhiKZt8uz3NJ5xA06nzcOenFf0-sB6D8rRO5sYQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JiDsRhiKZt8uz3NJ5xA06ur3Vk2wZ8_GyOph1LmrqAY&skey=84d09e3bb23e13f9&v=v8#DawningofaNewDay",
						"ttf": "http://fonts.gstatic.com/s/dawningofanewday/v8/JiDsRhiKZt8uz3NJ5xA06m7WZG3oz88cABkPJxHcz44.ttf",
						"woff": "http://fonts.gstatic.com/s/dawningofanewday/v8/JiDsRhiKZt8uz3NJ5xA06sI8uESXD0Pyby-WfK8NSPc.woff",
						"woff2": "http://fonts.gstatic.com/s/dawningofanewday/v8/JiDsRhiKZt8uz3NJ5xA06sXt6O2RzdGnaiPim4oAiF0.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Days One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Days One\'",
						"\'DaysOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/daysone/v7/Zn-oKb-yUG9f44TBmxvd9PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pJfCpPCG1LiGu52atxGru_esZW2xOQ-xsNqO47m55DA&skey=1aa007742d6eba3&v=v7#DaysOne",
						"ttf": "http://fonts.gstatic.com/s/daysone/v7/mM2FsD73BN33S6yWJhnlqfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/daysone/v7/yfpXiXt9Xp5H97keqlB0t_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/daysone/v7/levHiAHcPaqxEf5sqeyx1_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Dekko": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dekko\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dekko/v4/crNzrA5tW7MdHXctWFEWJQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jZ-A2r5Caevhp2FSBcrF8Q&skey=87b460a581e29e9a&v=v4#Dekko",
						"ttf": "http://fonts.gstatic.com/s/dekko/v4/hE1sOL8B5t8LTV86nJLADw.ttf",
						"woff": "http://fonts.gstatic.com/s/dekko/v4/JYLqilSZZuatC0VK5HreMg.woff",
						"woff2": "http://fonts.gstatic.com/s/dekko/v4/65sfRS5PD_z7ZcEP48_P-g.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Delius": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Delius-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/delius/v7/GcylbFGorIOzySnagfjeWw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=D8iGitiwlKzfYHOy_vpcug&skey=f36ed9ae8917239c&v=v7#Delius",
						"ttf": "http://fonts.gstatic.com/s/delius/v7/geRI9Tt6_9xDj8YKwTdHyA.ttf",
						"woff": "http://fonts.gstatic.com/s/delius/v7/7WQiMJKp1Jo3CiUw302zGA.woff",
						"woff2": "http://fonts.gstatic.com/s/delius/v7/ARghnDOAKVWf_iK5QVd4Yw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Delius Swash Caps": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Delius Swash Caps\'",
						"\'DeliusSwashCaps-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/deliusswashcaps/v9/uXyrEUnoWApxIOICunRq76axu7kD7rM--8EJSCR-Yn0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uXyrEUnoWApxIOICunRq7_822Ff2nVRWmQvAJ8Mi1fo&skey=2fbdc5319af197e&v=v9#DeliusSwashCaps",
						"ttf": "http://fonts.gstatic.com/s/deliusswashcaps/v9/uXyrEUnoWApxIOICunRq78NWT6CuowAotx_Dv3iC2Y0.ttf",
						"woff": "http://fonts.gstatic.com/s/deliusswashcaps/v9/uXyrEUnoWApxIOICunRq7-HbywbERJ_YcOpO6Co4fHY.woff",
						"woff2": "http://fonts.gstatic.com/s/deliusswashcaps/v9/uXyrEUnoWApxIOICunRq78THvgDn7cBCkr9GfjQQw0c.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Delius Unicase": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Delius Unicase\'",
						"\'DeliusUnicase-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/deliusunicase/v10/b2sKujV3Q48RV2PQ0k1vqmBn559uc2_n9F2EwttCKtA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=b2sKujV3Q48RV2PQ0k1vqjzDOWITvAevw9Y_fw5XUqA&skey=e1760ce20139c64e&v=v10#DeliusUnicase",
						"ttf": "http://fonts.gstatic.com/s/deliusunicase/v10/b2sKujV3Q48RV2PQ0k1vqvcMLt8J94hnsPLv6MMkBMk.ttf",
						"woff": "http://fonts.gstatic.com/s/deliusunicase/v10/b2sKujV3Q48RV2PQ0k1vqiiT6GQZqXe56UwGtNcbg_g.woff",
						"woff2": "http://fonts.gstatic.com/s/deliusunicase/v10/b2sKujV3Q48RV2PQ0k1vqlu1ALExAK9iCZzq2UkgWBo.woff2"
					}
				},
				"700": {
					"local": [
						"\'Delius Unicase Bold\'",
						"\'DeliusUnicase-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/deliusunicase/v10/7FTMTITcb4dxUp99FAdTqHvFD13BhrGO0aOlV3e17D0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7FTMTITcb4dxUp99FAdTqC7v9mfowx5zVVHxsqqUwp4&skey=79df78cc6fe9b196&v=v10#DeliusUnicase",
						"ttf": "http://fonts.gstatic.com/s/deliusunicase/v10/7FTMTITcb4dxUp99FAdTqKIOS-PpdoJg5doYHjupaGk.ttf",
						"woff": "http://fonts.gstatic.com/s/deliusunicase/v10/7FTMTITcb4dxUp99FAdTqLrq9kGEa_BMz9YVDYs3nGY.woff",
						"woff2": "http://fonts.gstatic.com/s/deliusunicase/v10/7FTMTITcb4dxUp99FAdTqD6fGwEpGpc2nLX_3jOqUv0.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Della Respira": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Della Respira\'",
						"\'DellaRespira-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dellarespira/v5/F4E6Lo_IZ6L9AJCcbqtDVRaMMUiNNY1IQbIV7e8ODnc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=F4E6Lo_IZ6L9AJCcbqtDVWMPOzKCRqgB4bBx3b-1aoc&skey=44c96c00cff030aa&v=v5#DellaRespira",
						"ttf": "http://fonts.gstatic.com/s/dellarespira/v5/F4E6Lo_IZ6L9AJCcbqtDVWbSELdkQ3Les1sVIQZgz9g.ttf",
						"woff": "http://fonts.gstatic.com/s/dellarespira/v5/F4E6Lo_IZ6L9AJCcbqtDVayztDLpUjNAkGAPlCwy4fk.woff",
						"woff2": "http://fonts.gstatic.com/s/dellarespira/v5/F4E6Lo_IZ6L9AJCcbqtDVcI79x-VWsl9ZLFyGx7L0Fo.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Denk One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Denk One\'",
						"\'DenkOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/denkone/v5/uhUQGfsmHVSaSTqY9fjokfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AMcabIFfD1eVFeR-Vx9Mq_esZW2xOQ-xsNqO47m55DA&skey=b0bbfe9b5a3111c6&v=v5#DenkOne",
						"ttf": "http://fonts.gstatic.com/s/denkone/v5/P7SaTFqoedlv-XRxXxfE2PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/denkone/v5/ahLepySZXU_KFQaVZ6XDvPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/denkone/v5/CkjtBkW4UXW3-ecY_gluSfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Devonshire": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Devonshire-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/devonshire/v6/aaQyvbEWf33gEr0fgtqsrVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=aaQyvbEWf33gEr0fgtqsraWUboTb-jS2tyCOQMtm97g&skey=35e45d512ea5a377&v=v6#Devonshire",
						"ttf": "http://fonts.gstatic.com/s/devonshire/v6/aaQyvbEWf33gEr0fgtqsrS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/devonshire/v6/aaQyvbEWf33gEr0fgtqsrRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/devonshire/v6/aaQyvbEWf33gEr0fgtqsrfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Dhurjati": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dhurjati\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dhurjati/v5/ryHWr3VrluPzLD9aB-t0mvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YSaTPT0v-LLeEZGLuucaU_esZW2xOQ-xsNqO47m55DA&skey=4848e17bf4d9fa9e&v=v5#Dhurjati",
						"ttf": "http://fonts.gstatic.com/s/dhurjati/v5/1cR3pnpU03iNZcPSIKuXXfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dhurjati/v5/SKcd7fku1Smp52K16fXiwfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dhurjati/v5/oNBvJ5uskqMI4TvSqC1kCvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Didact Gothic": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Didact Gothic Regular\'",
						"\'DidactGothic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/didactgothic/v11/v8_72sD3DYMKyM0dn3LtWqXmlaNvdBp66gw-0Z-GNT0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=v8_72sD3DYMKyM0dn3LtWsL4T2BsURrqI6i72jKYpWA&skey=21ea6a7f9674c318&v=v11#DidactGothic",
						"ttf": "http://fonts.gstatic.com/s/didactgothic/v11/v8_72sD3DYMKyM0dn3LtWm4ooKQJV7rZJEeBgiz-w_g.ttf",
						"woff": "http://fonts.gstatic.com/s/didactgothic/v11/v8_72sD3DYMKyM0dn3LtWp_RtrTXGeaL_Dia6_H9gNs.woff",
						"woff2": "http://fonts.gstatic.com/s/didactgothic/v11/v8_72sD3DYMKyM0dn3LtWmYKogTrBb-Yb2DFwx30qLM.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Diplomata": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Diplomata\'",
						"\'Diplomata-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/diplomata/v9/8UgOK_RUxkBbV-q561I6kPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8UgOK_RUxkBbV-q561I6kJbd9NUM7myrQQz30yPaGQ4&skey=226c83f2711f8678&v=v9#Diplomata",
						"ttf": "http://fonts.gstatic.com/s/diplomata/v9/8UgOK_RUxkBbV-q561I6kKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/diplomata/v9/8UgOK_RUxkBbV-q561I6kD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/diplomata/v9/8UgOK_RUxkBbV-q561I6kFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Diplomata SC": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Diplomata SC\'",
						"\'DiplomataSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/diplomatasc/v6/JdVwAwfE1a_pahXjk5qpNnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JdVwAwfE1a_pahXjk5qpNllIn5tFQcqMuf-jhyJP0ps&skey=7a04fcf7cbd5fc4b&v=v6#DiplomataSC",
						"ttf": "http://fonts.gstatic.com/s/diplomatasc/v6/JdVwAwfE1a_pahXjk5qpNonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/diplomatasc/v6/JdVwAwfE1a_pahXjk5qpNnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/diplomatasc/v6/JdVwAwfE1a_pahXjk5qpNugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Domine": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Domine\'",
						"\'Domine-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/domine/v5/sN2sKaGwq7PCKFIuaq_EPA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xyYnvwsPBwio9tpWjY8eBw&skey=ea73fc1e1d1dfd9a&v=v5#Domine",
						"ttf": "http://fonts.gstatic.com/s/domine/v5/4wfhKe93QxmsFlDQSCQ5wg.ttf",
						"woff": "http://fonts.gstatic.com/s/domine/v5/1KlmlHXZHUehH22N_q86AA.woff",
						"woff2": "http://fonts.gstatic.com/s/domine/v5/GQE2Oayn983RymkQwpLq5A.woff2"
					}
				},
				"700": {
					"local": [
						"\'Domine Bold\'",
						"\'Domine-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/domine/v5/BmiPqZorq0QiT-p6kf1pafY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BmiPqZorq0QiT-p6kf1paZbd9NUM7myrQQz30yPaGQ4&skey=cfd1743a5d8839c4&v=v5#Domine",
						"ttf": "http://fonts.gstatic.com/s/domine/v5/BmiPqZorq0QiT-p6kf1paaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/domine/v5/BmiPqZorq0QiT-p6kf1paT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/domine/v5/BmiPqZorq0QiT-p6kf1paVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Donegal One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Donegal One\'",
						"\'DonegalOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/donegalone/v5/LIom94sU9XlcGbVvjBz0oGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LIom94sU9XlcGbVvjBz0oHNsigHlcrQGNV8nkUSFQfc&skey=30881e7cfe9fede3&v=v5#DonegalOne",
						"ttf": "http://fonts.gstatic.com/s/donegalone/v5/LIom94sU9XlcGbVvjBz0oJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/donegalone/v5/LIom94sU9XlcGbVvjBz0oIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/donegalone/v5/LIom94sU9XlcGbVvjBz0oI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Doppio One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Doppio One Regular\'",
						"\'DoppioOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/doppioone/v5/DGr_HuCg-_zePcleoqvEX1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DGr_HuCg-_zePcleoqvEX6WUboTb-jS2tyCOQMtm97g&skey=a75d92ab7a6e70f5&v=v5#DoppioOne",
						"ttf": "http://fonts.gstatic.com/s/doppioone/v5/DGr_HuCg-_zePcleoqvEXy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/doppioone/v5/DGr_HuCg-_zePcleoqvEXxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/doppioone/v5/DGr_HuCg-_zePcleoqvEX_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Dorsa": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dorsa\'",
						"\'Dorsa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dorsa/v8/N1PW8hWnp1jV_kxtNgOHaw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=u6z7VTnrEeIhoEaFUi7ZXg&skey=38ccaf677c5e0a71&v=v8#Dorsa",
						"ttf": "http://fonts.gstatic.com/s/dorsa/v8/LBdTsX3DkF6aI98qL3C3nA.ttf",
						"woff": "http://fonts.gstatic.com/s/dorsa/v8/2nGoyekyJwdQo01pNwjk8w.woff",
						"woff2": "http://fonts.gstatic.com/s/dorsa/v8/8S74kYoETfI7QLnQozQe4A.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Dosis": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Dosis ExtraLight\'",
						"\'Dosis-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/ObbIOKT7x5q3tD-LZ0O70fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7Rno8JpHMLQx69KPHKIkEPesZW2xOQ-xsNqO47m55DA&skey=cf9d3151c95294b6&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/05xr33FHwecUTIADg28rEfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/zuuDDmIlQfJeEM3Uf6kkpvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/RPKDmaFi75RJkvjWaDDb0vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Dosis Light\'",
						"\'Dosis-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/piAeziXdjUmpEWux15l7q_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jQfTTSBIYSWz13x51VUsmPesZW2xOQ-xsNqO47m55DA&skey=a88ea9d907460694&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/0b3R8ORT0i9mlMGM3BxXF_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/GpmMKE0dnXylect5ObzLR_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/7aJzV14HzAOiwNTiPgucGfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Dosis Regular\'",
						"\'Dosis-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/RHp5spKuj-AQOgQKPITXrQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sDejRsJZPVX8xZ7-AA6xQQ&skey=91e90d677384bade&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/guC5lwT5Dw7anV_xfpCGqw.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/xIAtSaglM8LZOYdGmG1JqQ.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/4hYyXH_8WmbBLamf6WjLwg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Dosis Medium\'",
						"\'Dosis-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/ELvCmRUbtOdCk3jbD-FqUPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9LvcqeAjXVRmMNl7TMkmlPesZW2xOQ-xsNqO47m55DA&skey=21884fc543bb1165&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/obisuY-MenYRAFwd-r2NhfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/A4RWZsncmJ25G8iqn2EHN_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/mAcLJWdPWDNiDJwJvcWKc_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Dosis SemiBold\'",
						"\'Dosis-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/cP5EXqzXauRrjnP79eZ-MPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MVVQR3msXeurfQzmlgrXtfesZW2xOQ-xsNqO47m55DA&skey=95721c9dadac3c6d&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/URSgP3aplSko3CQAzdXHwPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/f8qltGyj2S-SS_tsOHsjgfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/O6SOu9hYsPHTU43R17NS5fesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Dosis Bold\'",
						"\'Dosis-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/tyj4dcX-j2M0ERUlmIDlrvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ov7kLVYVc5Zy2sgT6AjgN_esZW2xOQ-xsNqO47m55DA&skey=4116a45de4c0238a&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/Luunk03-uSz9LnB7oNEUuvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/x-7NZTw0n-ypOAaIE8uSrvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/22aDRG5X9l7obljtz7tihvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Dosis ExtraBold\'",
						"\'Dosis-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dosis/v7/mPoGKQuC65tedUakfBsfBfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DTV-Hxaiy_XSeKEBththpvesZW2xOQ-xsNqO47m55DA&skey=19b54ae6e098bf9f&v=v7#Dosis",
						"ttf": "http://fonts.gstatic.com/s/dosis/v7/T4JvHtpMHbjlr73o1YLMo_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/dosis/v7/k9xA3bmr7wstksq4xsFJafesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/dosis/v7/nq3OPeKr7RUSF_YDJ1woxvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Dr Sugiyama": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dr Sugiyama Regular\'",
						"\'DrSugiyama-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/drsugiyama/v6/rq_8251Ifx6dE1Mq7bUM6WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rq_8251Ifx6dE1Mq7bUM6XNsigHlcrQGNV8nkUSFQfc&skey=a252917f5c79a4bd&v=v6#DrSugiyama",
						"ttf": "http://fonts.gstatic.com/s/drsugiyama/v6/rq_8251Ifx6dE1Mq7bUM6Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/drsugiyama/v6/rq_8251Ifx6dE1Mq7bUM6YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/drsugiyama/v6/rq_8251Ifx6dE1Mq7bUM6Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Duru Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Duru Sans\'",
						"\'DuruSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/durusans/v10/xn7iYH8xwmSyTvEV_HOBSP3d.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xn7iYH8xwmSyTvEV_HOBSP3e&skey=f2c24e33dd79a23&v=v10#DuruSans",
						"ttf": "http://fonts.gstatic.com/s/durusans/v10/xn7iYH8xwmSyTvEV_HOBSP3c.ttf",
						"woff": "http://fonts.gstatic.com/s/durusans/v10/xn7iYH8xwmSyTvEV_HOBSP3f.woff",
						"woff2": "http://fonts.gstatic.com/s/durusans/v10/xn7iYH8xwmSyTvEV_HOBSP3Z.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Dynalight": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Dynalight\'",
						"\'Dynalight-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/dynalight/v6/H8N28OeR1G4cL0Fdzv8eVPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H8N28OeR1G4cL0Fdzv8eVJbd9NUM7myrQQz30yPaGQ4&skey=97fd8018c14a4dc1&v=v6#Dynalight",
						"ttf": "http://fonts.gstatic.com/s/dynalight/v6/H8N28OeR1G4cL0Fdzv8eVKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/dynalight/v6/H8N28OeR1G4cL0Fdzv8eVD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/dynalight/v6/H8N28OeR1G4cL0Fdzv8eVFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"EB Garamond": {
		"category": "serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'EB Garamond Italic\'",
						"\'EBGaramond-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/a7ivpTe3zZzednsAv-J8JaSxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=a7ivpTe3zZzednsAv-J8JTGefNBPGWcFPRAoUX_lgLU&skey=b76c0cb3db3b0fac&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/a7ivpTe3zZzednsAv-J8JeLrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/a7ivpTe3zZzednsAv-J8JdkZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/a7ivpTe3zZzednsAv-J8Jcu2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				},
				"500": {
					"local": [
						"\'EB Garamond Medium Italic\'",
						"\'EBGaramond-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyfKmQu4cG5QnmuCFCsciK9o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FBuKd0n5KoiDwUwHEzWyybHPwKxjim0WhwsoE4U6r7E&skey=359828743c54a049&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyX4elNPSrJo8K1X7hvJW37A.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyXsOjp2j4oPInuz1P52HMwA.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyQ28na7a-F9KZNLutV0Cpw0.woff2"
					}
				},
				"600": {
					"local": [
						"\'EB Garamond SemiBold Italic\'",
						"\'EBGaramond-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyfPI9BiXwFYUKjuot8euIms.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FBuKd0n5KoiDwUwHEzWyySMYYjyf7BdeRihbm-LMKmA&skey=8afcc9ea2f3b27&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyZUE4RykkcXbTQ2F2bbMaTY.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyYz4EF7XhASU9eO7C9WHZ84.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyU6W9MvHLdhFU0Rd_4veb8w.woff2"
					}
				},
				"700": {
					"local": [
						"\'EB Garamond Bold Italic\'",
						"\'EBGaramond-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyydmkQI_kos-lIOeNt19QAas.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FBuKd0n5KoiDwUwHEzWyyfXRuyUpAA8tGJEYgFPFMx8&skey=1d8f4e3493b15b68&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyWsGzsqhEorxQDpu60nfWEc.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyQRV2F9RPTaqyJ4QibDfkzM.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyY9ObOXPY1wUIXqKtDjSdsY.woff2"
					}
				},
				"800": {
					"local": [
						"\'EB Garamond ExtraBold Italic\'",
						"\'EBGaramond-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyycLz2C-02ajj1TbReB0cKr0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FBuKd0n5KoiDwUwHEzWyyZqHivf8szR_Pq9IwLuXxfc&skey=4c324481c0d7a586&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyeUiclUiImanXywmY6zS6xU.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyRubm17CrcCGdbJfM9gq12Y.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/FBuKd0n5KoiDwUwHEzWyyUC6sznG7zHQDncEf6U2ato.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'EB Garamond Regular\'",
						"\'EBGaramond-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/kYZt1bJ8UsGAPRGnkXPeFWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kYZt1bJ8UsGAPRGnkXPeFXNsigHlcrQGNV8nkUSFQfc&skey=fde9b303600e495b&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/kYZt1bJ8UsGAPRGnkXPeFZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/kYZt1bJ8UsGAPRGnkXPeFYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/kYZt1bJ8UsGAPRGnkXPeFY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'EB Garamond Medium\'",
						"\'EBGaramond-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_yGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=op4fHM8PJYvTt3cOgGzs_6057wUl25f8_0IloMUHk98&skey=d817e0fc529480f8&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs__Mi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_yqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_7BojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'EB Garamond SemiBold\'",
						"\'EBGaramond-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_48mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=op4fHM8PJYvTt3cOgGzs_-VmfClkf66xvxL1SWm4y8M&skey=1456ed3d39d4bdc7&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_y8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_35HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_12umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'EB Garamond Bold\'",
						"\'EBGaramond-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_7Ft29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=op4fHM8PJYvTt3cOgGzs_3tNmQEE9wZ6UZlmiISB1pg&skey=cab16d7dfc1081cd&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_5_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_zqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_4lIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'EB Garamond ExtraBold\'",
						"\'EBGaramond-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_5hT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=op4fHM8PJYvTt3cOgGzs_0WkFefV8YEa5Z9BVNHdJ6k&skey=b6942a6d44576469&v=v9#EBGaramond",
						"ttf": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_1DMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_0CDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/ebgaramond/v9/op4fHM8PJYvTt3cOgGzs_3ibbpXgLHK_uTT48UMyjSM.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Eagle Lake": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Eagle Lake\'",
						"\'EagleLake-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eaglelake/v5/7iuL6oiKGY2Q5j9N_W6QtVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7iuL6oiKGY2Q5j9N_W6QtaWUboTb-jS2tyCOQMtm97g&skey=63718d6a75d9c744&v=v5#EagleLake",
						"ttf": "http://fonts.gstatic.com/s/eaglelake/v5/7iuL6oiKGY2Q5j9N_W6QtS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/eaglelake/v5/7iuL6oiKGY2Q5j9N_W6QtRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/eaglelake/v5/7iuL6oiKGY2Q5j9N_W6Qtfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Eater": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Eater\'",
						"\'Eater-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eater/v6/lpUXk4YFOhx56HJxKk-r2A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Xy4yKDzldpHQiJS-SjLk_A&skey=540b4f9359cd7531&v=v6#Eater",
						"ttf": "http://fonts.gstatic.com/s/eater/v6/Sl9zTjyRG7qTs9YeDvrwkg.ttf",
						"woff": "http://fonts.gstatic.com/s/eater/v6/9-lswE9dlkJOKjTTLVZ4tQ.woff",
						"woff2": "http://fonts.gstatic.com/s/eater/v6/3d7OrhhDTayeJ3vSN8V5NA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Economica": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Economica Italic\'",
						"\'Economica-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/economica/v5/bzOVz_30ksVskVYQI1-p8mfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bzOVz_30ksVskVYQI1-p8nNsigHlcrQGNV8nkUSFQfc&skey=b1d41ffb59574c9f&v=v5#Economica",
						"ttf": "http://fonts.gstatic.com/s/economica/v5/bzOVz_30ksVskVYQI1-p8p0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/economica/v5/bzOVz_30ksVskVYQI1-p8obN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/economica/v5/bzOVz_30ksVskVYQI1-p8o4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Economica Bold Italic\'",
						"\'Economica-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/economica/v5/ac5dlUsedQ03RqGOeay-3bFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ac5dlUsedQ03RqGOeay-3XtNmQEE9wZ6UZlmiISB1pg&skey=9f803a65f8e309cb&v=v5#Economica",
						"ttf": "http://fonts.gstatic.com/s/economica/v5/ac5dlUsedQ03RqGOeay-3Z_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/economica/v5/ac5dlUsedQ03RqGOeay-3TqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/economica/v5/ac5dlUsedQ03RqGOeay-3YlIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Economica\'",
						"\'Economica-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/economica/v5/jObgDQiPUtmACAaaK3pMG_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jObgDQiPUtmACAaaK3pMG5bd9NUM7myrQQz30yPaGQ4&skey=787fcf9775092ba7&v=v5#Economica",
						"ttf": "http://fonts.gstatic.com/s/economica/v5/jObgDQiPUtmACAaaK3pMG6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/economica/v5/jObgDQiPUtmACAaaK3pMGz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/economica/v5/jObgDQiPUtmACAaaK3pMG1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Economica Bold\'",
						"\'Economica-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/economica/v5/UK4l2VEpwjv3gdcwbwXE9HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UK4l2VEpwjv3gdcwbwXE9FlIn5tFQcqMuf-jhyJP0ps&skey=c307f37a667ae92d&v=v5#Economica",
						"ttf": "http://fonts.gstatic.com/s/economica/v5/UK4l2VEpwjv3gdcwbwXE9InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/economica/v5/UK4l2VEpwjv3gdcwbwXE9HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/economica/v5/UK4l2VEpwjv3gdcwbwXE9Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Eczar": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Eczar Regular\'",
						"\'Eczar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eczar/v6/ICTeJ4L3v9cMkiXl8jBI7w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=G81XkRUL30oJzEw-_FmXsw&skey=e662b8acd8ea58a8&v=v6#Eczar",
						"ttf": "http://fonts.gstatic.com/s/eczar/v6/dLgrYcC21VVPiU9PrxrOlA.ttf",
						"woff": "http://fonts.gstatic.com/s/eczar/v6/qSkndQqNgdMOOCBAo7pnmA.woff",
						"woff2": "http://fonts.gstatic.com/s/eczar/v6/hyMVYt18PG_P8SE878ktjA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Eczar Medium\'",
						"\'Eczar-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eczar/v6/xxqJQvgI81RpAY3X_UGX4_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BVqQEGbmk0_VC7fOueVahvesZW2xOQ-xsNqO47m55DA&skey=356dc694caaa910b&v=v6#Eczar",
						"ttf": "http://fonts.gstatic.com/s/eczar/v6/zcn3YJt8JN2KBTXsoS5PRfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/eczar/v6/otSo5TglLQQryP7xfe8NOPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/eczar/v6/iDLow1WVRNO7gtBTtqe94vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Eczar SemiBold\'",
						"\'Eczar-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eczar/v6/9M1LwFDw4jBTyob6D8CtdvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NoBzLUSg1MN4jwJlioOF9vesZW2xOQ-xsNqO47m55DA&skey=128fcbeca8646941&v=v6#Eczar",
						"ttf": "http://fonts.gstatic.com/s/eczar/v6/T0qRTVJuIoBHnXEUGksKI_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/eczar/v6/yx073MZxFh7pVYGB8Y7oMPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/eczar/v6/h-_hRQTHwOzhzdaLhA66n_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Eczar Bold\'",
						"\'Eczar-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eczar/v6/hVM2AjOVw-Iodg5grNOrifesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EnuBUTGtoZLDIqi3vJi0bvesZW2xOQ-xsNqO47m55DA&skey=7a68eb23c6f33dd7&v=v6#Eczar",
						"ttf": "http://fonts.gstatic.com/s/eczar/v6/uKkwaG-hOaYYy1abMy-byPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/eczar/v6/7V3ChSI3teWVuW3TyL-sYvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/eczar/v6/pHvet5QyTYemmN1tt53cAfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Eczar ExtraBold\'",
						"\'Eczar-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/eczar/v6/Yn29hfrmgle-AtLE4uo8l_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RsMuHPVnUPgryitUs5BftvesZW2xOQ-xsNqO47m55DA&skey=6d5ff4184da608fc&v=v6#Eczar",
						"ttf": "http://fonts.gstatic.com/s/eczar/v6/u27pht1U05Ce9ot8sLNgG_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/eczar/v6/rka-gclQoGZ3Z0s5qQgYufesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/eczar/v6/oAtiCGMO5j7KaN4pf-QdZPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"El Messiri": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"cyrillic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'El Messiri\'",
						"\'ElMessiri-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elmessiri/v2/yMBX9m9fUtMpa4yx2RG7HVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yMBX9m9fUtMpa4yx2RG7HaWUboTb-jS2tyCOQMtm97g&skey=25ae73c7898b7d9b&v=v2#ElMessiri",
						"ttf": "http://fonts.gstatic.com/s/elmessiri/v2/yMBX9m9fUtMpa4yx2RG7HS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/elmessiri/v2/yMBX9m9fUtMpa4yx2RG7HRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/elmessiri/v2/yMBX9m9fUtMpa4yx2RG7Hfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"500": {
					"local": [
						"\'El Messiri Medium\'",
						"\'ElMessiri-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elmessiri/v2/kQW9PA2krAOzditagrX75oJh5taHiwXv-DjBEZUuYXM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kQW9PA2krAOzditagrX75g0_qyNcOHZM04svgoBwoTA&skey=b06bc5a3906ec150&v=v2#ElMessiri",
						"ttf": "http://fonts.gstatic.com/s/elmessiri/v2/kQW9PA2krAOzditagrX75tIZ6OFpBzzPr7LueGMiD8k.ttf",
						"woff": "http://fonts.gstatic.com/s/elmessiri/v2/kQW9PA2krAOzditagrX75u46x7QEqGuF-FJIFiH1W2g.woff",
						"woff2": "http://fonts.gstatic.com/s/elmessiri/v2/kQW9PA2krAOzditagrX75jOo-lJoxoMO4vrg2XwIHQk.woff2"
					}
				},
				"600": {
					"local": [
						"\'El Messiri SemiBold\'",
						"\'ElMessiri-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elmessiri/v2/HYl7TNqFfA1utGLZRWwzLMG3e9iX24ta7lLMfbqPFME.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HYl7TNqFfA1utGLZRWwzLHXS6izMuFYFwSUB_9Omnz0&skey=a4ca1922da8b820d&v=v2#ElMessiri",
						"ttf": "http://fonts.gstatic.com/s/elmessiri/v2/HYl7TNqFfA1utGLZRWwzLLh9hBNNhK4RjzVManoH7kY.ttf",
						"woff": "http://fonts.gstatic.com/s/elmessiri/v2/HYl7TNqFfA1utGLZRWwzLG4H_cQCpNmkmj7HsMzmiiM.woff",
						"woff2": "http://fonts.gstatic.com/s/elmessiri/v2/HYl7TNqFfA1utGLZRWwzLKVlZKEoJGujTpfWnQT9bUY.woff2"
					}
				},
				"700": {
					"local": [
						"\'El Messiri Bold\'",
						"\'ElMessiri-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elmessiri/v2/ji73glXFIetaSqMU3cz7rGzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ji73glXFIetaSqMU3cz7rD9QLNJZUvW8xv4RpDkyVDQ&skey=8fb573dc631d7809&v=v2#ElMessiri",
						"ttf": "http://fonts.gstatic.com/s/elmessiri/v2/ji73glXFIetaSqMU3cz7rPEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/elmessiri/v2/ji73glXFIetaSqMU3cz7rAFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/elmessiri/v2/ji73glXFIetaSqMU3cz7rIWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Electrolize": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Electrolize\'",
						"\'Electrolize-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/electrolize/v6/DDy9sgU2U7S4xAwH5thnJ2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DDy9sgU2U7S4xAwH5thnJ3NsigHlcrQGNV8nkUSFQfc&skey=530b3bebd29b1b4d&v=v6#Electrolize",
						"ttf": "http://fonts.gstatic.com/s/electrolize/v6/DDy9sgU2U7S4xAwH5thnJ50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/electrolize/v6/DDy9sgU2U7S4xAwH5thnJ4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/electrolize/v6/DDy9sgU2U7S4xAwH5thnJ44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Elsie": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Elsie Regular\'",
						"\'Elsie-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elsie/v7/qb8G5wUEDRqxinRe3hDldg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AjXSbw0pByKBdpy2DofoaQ&skey=f3b82328fc9a0e44&v=v7#Elsie",
						"ttf": "http://fonts.gstatic.com/s/elsie/v7/87ewMAZ1JgSlk7vkYLePzw.ttf",
						"woff": "http://fonts.gstatic.com/s/elsie/v7/GwrPfukf41qtIWgG_HoiUA.woff",
						"woff2": "http://fonts.gstatic.com/s/elsie/v7/souA4TqWZ48rz6XuhP2gVA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Elsie Black\'",
						"\'Elsie-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elsie/v7/KNck_1tFuSjqeRXflasSQPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0-OndwUw8Xs4wfADjjxBtfesZW2xOQ-xsNqO47m55DA&skey=c81378f431f562b8&v=v7#Elsie",
						"ttf": "http://fonts.gstatic.com/s/elsie/v7/SciscYAqMen9e5rN7OrNGvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/elsie/v7/3e1NWyfE2dItrmow-Woe3_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/elsie/v7/6_GnkUY-xz6a1OjL-pBrEvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Elsie Swash Caps": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Elsie Swash Caps Regular\'",
						"\'ElsieSwashCaps-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elsieswashcaps/v6/9L3hIJMPCf6sxCltnxd6X4jgZ9peH1h5QMCNTsgEYXY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9L3hIJMPCf6sxCltnxd6Xzf0pPzpG0bOLDeScyGvyOo&skey=628a9c934fe0954e&v=v6#ElsieSwashCaps",
						"ttf": "http://fonts.gstatic.com/s/elsieswashcaps/v6/9L3hIJMPCf6sxCltnxd6X7696hY-neTbCTvwDUFvtCU.ttf",
						"woff": "http://fonts.gstatic.com/s/elsieswashcaps/v6/9L3hIJMPCf6sxCltnxd6X5bko4ywDBcg2f1uYutDOWY.woff",
						"woff2": "http://fonts.gstatic.com/s/elsieswashcaps/v6/9L3hIJMPCf6sxCltnxd6Xxj-AqoPRuAbf1eZyhj8Aik.woff2"
					}
				},
				"900": {
					"local": [
						"\'Elsie Swash Caps Black\'",
						"\'ElsieSwashCaps-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/elsieswashcaps/v6/iZnus9qif0tR5pGaDv5zdATZZ5qKm61QyraXnw66clQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iZnus9qif0tR5pGaDv5zdHDF1qV6euBERPiuaQiefiw&skey=674768f5b901a42b&v=v6#ElsieSwashCaps",
						"ttf": "http://fonts.gstatic.com/s/elsieswashcaps/v6/iZnus9qif0tR5pGaDv5zdL8JGdB9bM6rwd06X0MS8fY.ttf",
						"woff": "http://fonts.gstatic.com/s/elsieswashcaps/v6/iZnus9qif0tR5pGaDv5zdEd2CPfIv3tbBh_qUxvoikM.woff",
						"woff2": "http://fonts.gstatic.com/s/elsieswashcaps/v6/iZnus9qif0tR5pGaDv5zdJ9qcsSipTy0lP7NBhiMItA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Emblema One": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Emblema One\'",
						"\'EmblemaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/emblemaone/v6/DP45btqoXRGq3Q7LXbPYRmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DP45btqoXRGq3Q7LXbPYRnNsigHlcrQGNV8nkUSFQfc&skey=3ab2041ef8263932&v=v6#EmblemaOne",
						"ttf": "http://fonts.gstatic.com/s/emblemaone/v6/DP45btqoXRGq3Q7LXbPYRp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/emblemaone/v6/DP45btqoXRGq3Q7LXbPYRobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/emblemaone/v6/DP45btqoXRGq3Q7LXbPYRo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Emilys Candy": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Emilys Candy\'",
						"\'EmilysCandy-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/emilyscandy/v5/PofLVm6v1SwZGOzC8s-I3XZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PofLVm6v1SwZGOzC8s-I3VlIn5tFQcqMuf-jhyJP0ps&skey=d5187bca1158b982&v=v5#EmilysCandy",
						"ttf": "http://fonts.gstatic.com/s/emilyscandy/v5/PofLVm6v1SwZGOzC8s-I3YnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/emilyscandy/v5/PofLVm6v1SwZGOzC8s-I3XhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/emilyscandy/v5/PofLVm6v1SwZGOzC8s-I3egdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Encode Sans": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Encode Sans Thin\'",
						"\'EncodeSans-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/TvUFkOGoNYwmv-XugrRC17eskzFlZTkzN_FGynPZJZk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TvUFkOGoNYwmv-XugrRC193oSpqWURvZ6I3ad-WfbBU&skey=4897862124b5804f&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/TvUFkOGoNYwmv-XugrRC134UHu-c0cTZKOwO_f6u1Os.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/TvUFkOGoNYwmv-XugrRC1yeJLMOzE6CCkidNEpZOseY.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/TvUFkOGoNYwmv-XugrRC19FPPhm6yPYYGACxOp9LMJ4.woff2"
					}
				},
				"200": {
					"local": [
						"\'Encode Sans ExtraLight\'",
						"\'EncodeSans-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vFT7wzIiOHIChIARuHOnLzM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vBZBgPlnpWaoq0SaX6doyAk&skey=a94bc255fe60e002&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vIk9RAFW3K6S6MTuxUiRJAk.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vNj3jEPHYvfoh7wL9kai_ws.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vP-yvr_zg92NT13uHB6uFCI.woff2"
					}
				},
				"300": {
					"local": [
						"\'Encode Sans Light\'",
						"\'EncodeSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vLXcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vD4dnM32POWavC8T_whbZeI&skey=d134ae2d6cb06133&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vLfB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vB_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vEo2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Encode Sans Regular\'",
						"\'EncodeSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/2zldBfvKXWNf1KMFLP1FrWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2zldBfvKXWNf1KMFLP1FrXNsigHlcrQGNV8nkUSFQfc&skey=e89c161dda2ef39d&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/2zldBfvKXWNf1KMFLP1FrZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/2zldBfvKXWNf1KMFLP1FrYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/2zldBfvKXWNf1KMFLP1FrY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Encode Sans Medium\'",
						"\'EncodeSans-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vCGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vK057wUl25f8_0IloMUHk98&skey=241fde597644f863&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vPMi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vCqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vLBojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Encode Sans SemiBold\'",
						"\'EncodeSans-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vI8mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vOVmfClkf66xvxL1SWm4y8M&skey=7604cc58fa3da2f5&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vC8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vH5HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vF2umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Encode Sans Bold\'",
						"\'EncodeSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vLFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vHtNmQEE9wZ6UZlmiISB1pg&skey=7578a3c5006b77c5&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vJ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vDqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vIlIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Encode Sans ExtraBold\'",
						"\'EncodeSans-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vJhT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vEWkFefV8YEa5Z9BVNHdJ6k&skey=73b8969bdd83d4e5&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vFDMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vECDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vHibbpXgLHK_uTT48UMyjSM.woff2"
					}
				},
				"900": {
					"local": [
						"\'Encode Sans Black\'",
						"\'EncodeSans-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vK8knJ7dcSpE9bYpElP8kOU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IaOhmWC4W3-qZLH1UUd4vMTCo6WkuhWceGynHdPeLtc&skey=3b790319ee4e3d43&v=v2#EncodeSans",
						"ttf": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vBG4wFYO9UG-PxKqsSvMNyg.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vEExzZ44ka2Lr5i-x5aWr0E.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesans/v2/IaOhmWC4W3-qZLH1UUd4vMpPZoEQdaDZ3o3Np19rzJk.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Encode Sans Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Encode Sans Condensed Thin\'",
						"\'EncodeSansCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/6LOoEWi9It096ZzMNw6yehmahUNotGdjm2Ol6aGySJE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6LOoEWi9It096ZzMNw6yesd3lQ0Zq4-ZnW8t9T3tPJY&skey=6bd7071599711e31&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/6LOoEWi9It096ZzMNw6yeixJ_JTb5el0Ppjrm-0hjMM.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/6LOoEWi9It096ZzMNw6yetDiZyNu74_BoKVTfzyYybc.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/6LOoEWi9It096ZzMNw6yehT_xdTPGhRFczcoKJqBt8I.woff2"
					}
				},
				"200": {
					"local": [
						"\'Encode Sans Condensed ExtraLight\'",
						"\'EncodeSansCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY_Q9lS_o7346kD7FAlvzI-v3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxYy9VKmmDb8Mp9RXDsBxOPPr3rGVtsTkPsbDajuO5ueQw&skey=6225f69673f4f9ab&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY8duEGWNBNN-S2AbSZgeVrz3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY4ygVcJV2QBnGh8qOAwW5rn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYxW0W024EwMHRxmZfuY_nuL3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Encode Sans Condensed Light\'",
						"\'EncodeSansCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY2Wd9KR2C2cM8bQReFAw28D3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxY3AmPhGsY_Gl95qWI4smm873rGVtsTkPsbDajuO5ueQw&skey=67e30dda2c94233e&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY5CfZPfJpky_qGeFHM0zNWD3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYwPZRBeRMLwcSTzP_Mut-K73rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYwCx1EMbW1eFZOmb3pc2tbz3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Encode Sans Condensed Regular\'",
						"\'EncodeSansCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/CbFzpyBSY4j-AYSd59uzHHW5TFetRsmCWPgQ_1fJg50.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CbFzpyBSY4j-AYSd59uzHDzqHVLJvlsJOGCkOB4yeJo&skey=eddce5a30b6642c7&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/CbFzpyBSY4j-AYSd59uzHMwpCuwZUXUamS0_9Spumd4.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/CbFzpyBSY4j-AYSd59uzHEGJFlOJkO8mymA9tc33RXw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/CbFzpyBSY4j-AYSd59uzHMBvcTyoFVl2hWxSOgahpEY.woff2"
					}
				},
				"500": {
					"local": [
						"\'Encode Sans Condensed Medium\'",
						"\'EncodeSansCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY49fgX4Ac45MKpp6UbA8Lmb3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxYzKD9EjupQxr0_poxZA0YMD3rGVtsTkPsbDajuO5ueQw&skey=9b2a2a6aba91b9bf&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY0QE11Ev1PY72twt0hy6pR73rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY3nKrYhZhwOSDoAJuZTxzPn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYxOR75kcDjfuuNgpyTcfx6P3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Encode Sans Condensed SemiBold\'",
						"\'EncodeSansCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY2BW24ZT7ws6ZjQLRyrHeFv3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxY0bzbRZiAP3f9BulJyPpAR_3rGVtsTkPsbDajuO5ueQw&skey=7e2153ab5c66d6cc&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY11OHkx2X8doGCVPaei_JVf3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY0G6pymjL8bnnlcp-tN1f6r3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY7pQX8I2DyXG4uHm2BpGsSH3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Encode Sans Condensed Bold\'",
						"\'EncodeSansCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY_6CeLVY9wfEa4jvG67ma333rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxY8ePmP6A7DDVKcDskgRv23L3rGVtsTkPsbDajuO5ueQw&skey=54642619dbc0a610&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY2OHHJ7PHJ8i9QwwkhlT2jn3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYwP6At_oeljG2S-gQitEVPn3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY_HD1jZSi8KUxQcwKVvxv1r3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Encode Sans Condensed ExtraBold\'",
						"\'EncodeSansCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY77wdVqcU-KDfXrziuNQqNz3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxY-CEzJKvl-ANxqMjbvTDdAL3rGVtsTkPsbDajuO5ueQw&skey=447a6921aa21ef0d&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY_XXftz7r481EfQC0ekJ8kr3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY7Pbm5I-tNZh8XdYKOc0ifL3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY8SZbXHNn1xNkePBld0xfIj3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Encode Sans Condensed Black\'",
						"\'EncodeSansCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYxuDkrGkiHMpHa_tk8jod-j3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UP_H-DzI6prLPN-PMUyxY_tE2ziDo4Kg1ROTje6EKT33rGVtsTkPsbDajuO5ueQw&skey=c09a0077c3682dab&v=v2#EncodeSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxYwiBv0ofxCW9Ty785M0ocQr3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY2VykXXYmWLPJNFn4yYxeer3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanscondensed/v2/UP_H-DzI6prLPN-PMUyxY4kF27DlXp6dWb0At9fH-RL3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Encode Sans Expanded": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Encode Sans Expanded Thin\'",
						"\'EncodeSansExpanded-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/SxJCe-5XtgTwkLeuB6DsDFq0emfjKI4aSm2d63DR2FI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SxJCe-5XtgTwkLeuB6DsDEBTI20EUwqQdTibiu8oBeA&skey=f2397b998d80d86f&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/SxJCe-5XtgTwkLeuB6DsDOeUob_jCk_967Laj5RFKjs.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/SxJCe-5XtgTwkLeuB6DsDKisu3XRADWgexWeSfZruSI.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/SxJCe-5XtgTwkLeuB6DsDIndZv-TPJGq6zIptN1F7As.woff2"
					}
				},
				"200": {
					"local": [
						"\'Encode Sans Expanded ExtraLight\'",
						"\'EncodeSansExpanded-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtKtBld3eyMH11DDqbULX4rY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtNinch_q5HxmlQ3xl_RMTeE&skey=1dc2e694c92340ec&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtGG6F-aqbnjytW74hiCXAK8.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtL6DOzugQvmuNTRfu1gJxGQ.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtBagXNZ1HRa0Nu6I2ePWsZ4.woff2"
					}
				},
				"300": {
					"local": [
						"\'Encode Sans Expanded Light\'",
						"\'EncodeSansExpanded-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtL3-wUlheM-nYQnbw1LtNts.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtHlI2NCV8wUvlwJPp3UZK4w&skey=bc2e342d33b0726f&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtP7CD_FflrV_70Y9fcKGrb8.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtOsCZaMyqYRYSXZcpM0fzxs.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtA7k1yIHNBSzt0u7VHHl2Eg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Encode Sans Expanded Regular\'",
						"\'EncodeSansExpanded-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/OdOWbHhxwo9XAUoeS5o4DimoEHdlZX6UoPDjq1Qszf4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OdOWbHhxwo9XAUoeS5o4Dh7vv-TxbE7gTBwV6gQAx7c&skey=268644c845c7c420&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/OdOWbHhxwo9XAUoeS5o4Dm0BHiMun-z7OGO_nw4Vd5c.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/OdOWbHhxwo9XAUoeS5o4DjcHt7R-NPdhrDLjTJhdxn0.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/OdOWbHhxwo9XAUoeS5o4DsWcjCVoh_fAlZ40Kea0JZ4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Encode Sans Expanded Medium\'",
						"\'EncodeSansExpanded-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtDfpoEbEN9DCa3ZurJcCgRs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtDVkq0LuCD3O4H10lmUHm9A&skey=307b8a85c9990850&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtJwxZTXgYT_hPd_HKrccSn8.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtNC0O9US-_FOiRPIGP4C--4.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtOhe4KPCmfD4fLA7vThxfW0.woff2"
					}
				},
				"600": {
					"local": [
						"\'Encode Sans Expanded SemiBold\'",
						"\'EncodeSansExpanded-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtBasfv5QwbsN2WyXUhdyybg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtJuCCMBPxwlnYgmg2yjGpZQ&skey=20abd694f3cb9946&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtOE8mX6WYOUk67OmLIMJlGg.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtEd3L6mnsnFOSbbqAGs-aHQ.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtGj3y78ZJSLbVH-eEK8WIR4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Encode Sans Expanded Bold\'",
						"\'EncodeSansExpanded-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtDkMQxAfWs2s3cckadhSTlo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtLiyPnB56SjilrlhacdfKBs&skey=39725db681433b77&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtOO-y6a3T5SFqb5NLA8NThA.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtFdvZqC0o4gFZfBDSFGT-nQ.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtP-61TioeZkgUFgbKYTK2o4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Encode Sans Expanded ExtraBold\'",
						"\'EncodeSansExpanded-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtPYvGaIyiLdy9WnV6IhaI6c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtAbCHE4RWAGNo8kmTKNDhjU&skey=cd002979eca68c8c&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtLLnz20OAlKgl1Dt-E-C8nA.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtOKwje4V7aQruq2jcLadGDg.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtKPmLd8KBqgXB1gBAZkIpPk.woff2"
					}
				},
				"900": {
					"local": [
						"\'Encode Sans Expanded Black\'",
						"\'EncodeSansExpanded-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtI6AOWpRbUj8KvBsq4EGYeg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NZFW_aAjtWMwFwRPQHyMtOX1t3LLe0SRvGUtnfulH7g&skey=e223aeb8ad7c4ad&v=v2#EncodeSansExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtBNimv_xkOvd4MBA-vpncqc.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtJL52WLWGrRkI8kFeDqOyNs.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesansexpanded/v2/NZFW_aAjtWMwFwRPQHyMtGttNaSEq_LvELfEONa5FOI.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Encode Sans Semi Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Encode Sans Semi Condensed Thin\'",
						"\'EncodeSansSemiCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/E6kA5T3mzxUj69IdQg70PS1QEJchpDhTUwbwiSjEPbh2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=E6kA5T3mzxUj69IdQg70PS1QEJchpDhTUwbwiSjEPbhZSJ-bRUHKjLn_o4ciT9Kb&skey=48f779c088e0093a&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/E6kA5T3mzxUj69IdQg70PS1QEJchpDhTUwbwiSjEPbiJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/E6kA5T3mzxUj69IdQg70PS1QEJchpDhTUwbwiSjEPbh4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/E6kA5T3mzxUj69IdQg70PS1QEJchpDhTUwbwiSjEPbjoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"200": {
					"local": [
						"\'Encode Sans Semi Condensed ExtraLight\'",
						"\'EncodeSansSemiCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHVxi1xYyRqMxS_FPu-moW0luiLswMI3yOT22-o6H0qs5.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHVxi1xYyRqMxS_FPu-moW0mBzldjikcIsptAi1lEqFxb&skey=f063d28ffc879fba&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHVxi1xYyRqMxS_FPu-moW0ltifckERxwYZZkJlwuVOaJ.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHVxi1xYyRqMxS_FPu-moW0kaeIr0xXDKAybTxKgHvYZj.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHVxi1xYyRqMxS_FPu-moW0mhFl6pxkn8J0A92A5aa7G9.woff2"
					}
				},
				"300": {
					"local": [
						"\'Encode Sans Semi Condensed Light\'",
						"\'EncodeSansSemiCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHSLQwj9Lduqb1W3tq4fXf92ksUrwtZSLCv7p2Qx1qkwY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHSLQwj9Lduqb1W3tq4fXf90xnnzQTxlnBT0QKFF_5YC1&skey=939bd216a771659c&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHSLQwj9Lduqb1W3tq4fXf93i6wuA7uHv8n0yfDpetMZN.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHSLQwj9Lduqb1W3tq4fXf93ZGV1uLGHOAY7gCBXNUlyC.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHSLQwj9Lduqb1W3tq4fXf93LtkNDkvinkwFo4JEvOZg4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Encode Sans Semi Condensed Regular\'",
						"\'EncodeSansSemiCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/70xnFP2R6L67b4lbb0LqFTzfwKCQBHzwea1B63HGn7FUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=70xnFP2R6L67b4lbb0LqFTzfwKCQBHzwea1B63HGn7GllG6E2_o0trcgjkDLZve4&skey=2b1b27daf31ae9c5&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/70xnFP2R6L67b4lbb0LqFTzfwKCQBHzwea1B63HGn7Et1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/70xnFP2R6L67b4lbb0LqFTzfwKCQBHzwea1B63HGn7EbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/70xnFP2R6L67b4lbb0LqFTzfwKCQBHzwea1B63HGn7H5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"500": {
					"local": [
						"\'Encode Sans Semi Condensed Medium\'",
						"\'EncodeSansSemiCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHWPzD9HBxt0HXJBsJbnj8TaCYebWh4sF7_g4wRGVLmFz.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHWPzD9HBxt0HXJBsJbnj8TYNP6sjXDh2TNOLL4KAcKEw&skey=7700dca8d10f7e09&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHWPzD9HBxt0HXJBsJbnj8TbSGejhaQc8z6-y7nhjIg_J.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHWPzD9HBxt0HXJBsJbnj8TbuOse0BKhrhfhSSBYh9Vto.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHWPzD9HBxt0HXJBsJbnj8TYzqPpSaMaDDuL64Nl8CB0J.woff2"
					}
				},
				"600": {
					"local": [
						"\'Encode Sans Semi Condensed SemiBold\'",
						"\'EncodeSansSemiCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHZTIxrxLvLMtU-yhyAf1TK_Bt3vYl9uLWu5SzH26jxTB.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHZTIxrxLvLMtU-yhyAf1TK910uoszLhWBcElAf_Tpp89&skey=bb6358811996afda&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHZTIxrxLvLMtU-yhyAf1TK-4fYQTTYSuEY81TGp6B-5G.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHZTIxrxLvLMtU-yhyAf1TK9uB_3EAqTZpJo-x7DM5ooj.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHZTIxrxLvLMtU-yhyAf1TK-lZWShKCRro06X1p0E_W1G.woff2"
					}
				},
				"700": {
					"local": [
						"\'Encode Sans Semi Condensed Bold\'",
						"\'EncodeSansSemiCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHanrccv-0xgQwXIoROQBHDls5JZOjCW4YOwZgT-Ngowk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHanrccv-0xgQwXIoROQBHDk_UCzSWVL1vMb-EaQ5MlQ0&skey=2f952156221539be&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHanrccv-0xgQwXIoROQBHDnxK-h5ukTEtL9XbV7Boq-I.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHanrccv-0xgQwXIoROQBHDkBYWkb9qRoE-Sn9AJ9LODD.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHanrccv-0xgQwXIoROQBHDmFojDGe8S3e_dlC6RhOFv2.woff2"
					}
				},
				"800": {
					"local": [
						"\'Encode Sans Semi Condensed ExtraBold\'",
						"\'EncodeSansSemiCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHaUGwPLApwd9av9Pcjv04cMfAB4RH41CY6LhVbbSYyaK.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHaUGwPLApwd9av9Pcjv04cNaxQm74SMtmWgBDSjPlYLA&skey=c52bae765be7749&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHaUGwPLApwd9av9Pcjv04cON0pkx_BL7PFfdAmMFtyS5.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHaUGwPLApwd9av9Pcjv04cMkvtJMP7kSzfSRM9drqlUU.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHaUGwPLApwd9av9Pcjv04cMK8toytWNKDcqBdcS398zE.woff2"
					}
				},
				"900": {
					"local": [
						"\'Encode Sans Semi Condensed Black\'",
						"\'EncodeSansSemiCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHf3LPq0EY0JuN61BrMSCA9vFsGhpH9uT_s2TqzAU86SX.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z-mVMDpNLBzCo6eVg95vHf3LPq0EY0JuN61BrMSCA9sG4LlbEQGmJ9kOMZfqp3_g&skey=197647da026441c1&v=v2#EncodeSansSemiCondensed",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHf3LPq0EY0JuN61BrMSCA9temA2x99e-RdXrPmZe5jqV.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHf3LPq0EY0JuN61BrMSCA9uDwJJftKwpF-BeMyDu5WFh.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemicondensed/v2/z-mVMDpNLBzCo6eVg95vHf3LPq0EY0JuN61BrMSCA9vI7G-zqtKPrqlBVu2ILuaz.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Encode Sans Semi Expanded": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Encode Sans Semi Expanded Thin\'",
						"\'EncodeSansSemiExpanded-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/Dt9vBR-jlFaGi37WwOwD_0Zsp-QGpWwaN-eHwGE0gm5n0HCrrUF3CK0X8keY3Y2P.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Dt9vBR-jlFaGi37WwOwD_0Zsp-QGpWwaN-eHwGE0gm5zbIoB5XK0BjVfJ5FEhUH3&skey=dc0a4068b5ecf50a&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/Dt9vBR-jlFaGi37WwOwD_0Zsp-QGpWwaN-eHwGE0gm6dBAFcbdBtG4hJ7aeN0Leh.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/Dt9vBR-jlFaGi37WwOwD_0Zsp-QGpWwaN-eHwGE0gm6GzelA8h1gZettGviEX7gZ.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/Dt9vBR-jlFaGi37WwOwD_0Zsp-QGpWwaN-eHwGE0gm6OD-SAqMfCqtyy1DTMpRju.woff2"
					}
				},
				"200": {
					"local": [
						"\'Encode Sans Semi Expanded ExtraLight\'",
						"\'EncodeSansSemiExpanded-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4iyuBgySKCdxv6GjzoxXXEd2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4iyuBgySKCdxv6GjzoxXXEdZSJ-bRUHKjLn_o4ciT9Kb&skey=bbb9731d46a038ad&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4iyuBgySKCdxv6GjzoxXXEeJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4iyuBgySKCdxv6GjzoxXXEd4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4iyuBgySKCdxv6GjzoxXXEfoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"300": {
					"local": [
						"\'Encode Sans Semi Expanded Light\'",
						"\'EncodeSansSemiExpanded-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4mA0loIJ_cqzG2SO7pmT2v92djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4mA0loIJ_cqzG2SO7pmT2v9ZSJ-bRUHKjLn_o4ciT9Kb&skey=fe4df3368e732156&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4mA0loIJ_cqzG2SO7pmT2v-JxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4mA0loIJ_cqzG2SO7pmT2v94QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4mA0loIJ_cqzG2SO7pmT2v_oHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Encode Sans Semi Expanded Regular\'",
						"\'EncodeSansSemiExpanded-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/L50h_XWfeGcmQgSaLLv8qHCOR7sJ59J2b2OBhCAIRtr2Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=L50h_XWfeGcmQgSaLLv8qHCOR7sJ59J2b2OBhCAIRtqW3fTVDO5sq0EM99Mj2hkO&skey=4f229740d3e0a176&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/L50h_XWfeGcmQgSaLLv8qHCOR7sJ59J2b2OBhCAIRtqglnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/L50h_XWfeGcmQgSaLLv8qHCOR7sJ59J2b2OBhCAIRto_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/L50h_XWfeGcmQgSaLLv8qHCOR7sJ59J2b2OBhCAIRtpbV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				},
				"500": {
					"local": [
						"\'Encode Sans Semi Expanded Medium\'",
						"\'EncodeSansSemiExpanded-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4m9ZGOr7ke8-zfCGnYaqVkx2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4m9ZGOr7ke8-zfCGnYaqVkxZSJ-bRUHKjLn_o4ciT9Kb&skey=4c7bf071c9069b97&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4m9ZGOr7ke8-zfCGnYaqVkyJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4m9ZGOr7ke8-zfCGnYaqVkx4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4m9ZGOr7ke8-zfCGnYaqVkzoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Encode Sans Semi Expanded SemiBold\'",
						"\'EncodeSansSemiExpanded-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4jZr6ABenySL2MEoV49ZPIF2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4jZr6ABenySL2MEoV49ZPIFZSJ-bRUHKjLn_o4ciT9Kb&skey=a215417dfb1dacc&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4jZr6ABenySL2MEoV49ZPIGJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4jZr6ABenySL2MEoV49ZPIF4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4jZr6ABenySL2MEoV49ZPIHoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Encode Sans Semi Expanded Bold\'",
						"\'EncodeSansSemiExpanded-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4vb58e8syHA9EvUqaFcpH8l2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4vb58e8syHA9EvUqaFcpH8lZSJ-bRUHKjLn_o4ciT9Kb&skey=a522d23b7cd26a0d&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4vb58e8syHA9EvUqaFcpH8mJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4vb58e8syHA9EvUqaFcpH8l4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4vb58e8syHA9EvUqaFcpH8noHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Encode Sans Semi Expanded ExtraBold\'",
						"\'EncodeSansSemiExpanded-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4v1ujhhC8jANxa3d-BaQZ3t2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4v1ujhhC8jANxa3d-BaQZ3tZSJ-bRUHKjLn_o4ciT9Kb&skey=4d5246cdaa83674a&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4v1ujhhC8jANxa3d-BaQZ3uJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4v1ujhhC8jANxa3d-BaQZ3t4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4v1ujhhC8jANxa3d-BaQZ3voHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"900": {
					"local": [
						"\'Encode Sans Semi Expanded Black\'",
						"\'EncodeSansSemiExpanded-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4sIOIZ6BsfRi1i9aEyUWch52djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CzlMbAciMXgtU6UUaNDI4sIOIZ6BsfRi1i9aEyUWch5ZSJ-bRUHKjLn_o4ciT9Kb&skey=2462d6bf6de02c23&v=v2#EncodeSansSemiExpanded",
						"ttf": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4sIOIZ6BsfRi1i9aEyUWch6JxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4sIOIZ6BsfRi1i9aEyUWch54QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/encodesanssemiexpanded/v2/CzlMbAciMXgtU6UUaNDI4sIOIZ6BsfRi1i9aEyUWch7oHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Engagement": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Engagement\'",
						"\'Engagement-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/engagement/v6/IYnYh0uOiuydvYrbHKIjwVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IYnYh0uOiuydvYrbHKIjwaWUboTb-jS2tyCOQMtm97g&skey=8c27fbacec5a2e3c&v=v6#Engagement",
						"ttf": "http://fonts.gstatic.com/s/engagement/v6/IYnYh0uOiuydvYrbHKIjwS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/engagement/v6/IYnYh0uOiuydvYrbHKIjwRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/engagement/v6/IYnYh0uOiuydvYrbHKIjwfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Englebert": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Englebert\'",
						"\'Englebert-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/englebert/v5/5vhE18ztcHRcsYmBaZ6CaPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5vhE18ztcHRcsYmBaZ6CaJbd9NUM7myrQQz30yPaGQ4&skey=3dd5ddabce9dea4&v=v5#Englebert",
						"ttf": "http://fonts.gstatic.com/s/englebert/v5/5vhE18ztcHRcsYmBaZ6CaKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/englebert/v5/5vhE18ztcHRcsYmBaZ6CaD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/englebert/v5/5vhE18ztcHRcsYmBaZ6CaFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Enriqueta": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Enriqueta-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/enriqueta/v6/-KTKVm0Mx9ZCRXL9CXVIbfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-KTKVm0Mx9ZCRXL9CXVIbZbd9NUM7myrQQz30yPaGQ4&skey=dab50c048a056710&v=v6#Enriqueta",
						"ttf": "http://fonts.gstatic.com/s/enriqueta/v6/-KTKVm0Mx9ZCRXL9CXVIbaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/enriqueta/v6/-KTKVm0Mx9ZCRXL9CXVIbT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/enriqueta/v6/-KTKVm0Mx9ZCRXL9CXVIbVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Enriqueta-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/enriqueta/v6/I27Pb-wEGH2ajLYP0QrtSHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=I27Pb-wEGH2ajLYP0QrtSFlIn5tFQcqMuf-jhyJP0ps&skey=fc1c760d7345b8dc&v=v6#Enriqueta",
						"ttf": "http://fonts.gstatic.com/s/enriqueta/v6/I27Pb-wEGH2ajLYP0QrtSInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/enriqueta/v6/I27Pb-wEGH2ajLYP0QrtSHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/enriqueta/v6/I27Pb-wEGH2ajLYP0QrtSOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Erica One": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Erica One\'",
						"\'EricaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ericaone/v8/7ct8ELB1awBkUBGJHiNcePY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ct8ELB1awBkUBGJHiNceJbd9NUM7myrQQz30yPaGQ4&skey=411c9a24a37316a6&v=v8#EricaOne",
						"ttf": "http://fonts.gstatic.com/s/ericaone/v8/7ct8ELB1awBkUBGJHiNceKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/ericaone/v8/7ct8ELB1awBkUBGJHiNceD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/ericaone/v8/7ct8ELB1awBkUBGJHiNceFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Esteban": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Esteban\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/esteban/v5/ycDscAGhbtNR-WQ77Hfspw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BYus9Wha19OD1BR1SwBG2A&skey=e121f18102369471&v=v5#Esteban",
						"ttf": "http://fonts.gstatic.com/s/esteban/v5/Rzqzctdq0qFARqC4mKfvvg.ttf",
						"woff": "http://fonts.gstatic.com/s/esteban/v5/EKgJCyB1J9KPP5TdWd2GGw.woff",
						"woff2": "http://fonts.gstatic.com/s/esteban/v5/dji77CVfzgKS5mvjxEcvnw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Euphoria Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Euphoria Script\'",
						"\'EuphoriaScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/euphoriascript/v5/c4XB4Iijj_NvSsCF4I0O2MRAjcwhH4MEdRofTbA0Ghw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=c4XB4Iijj_NvSsCF4I0O2DOOHwNldbZYpbzbEl7ku10&skey=43c0de58807de10a&v=v5#EuphoriaScript",
						"ttf": "http://fonts.gstatic.com/s/euphoriascript/v5/c4XB4Iijj_NvSsCF4I0O2OCCe9ONX3soS2UUkIHWRRQ.ttf",
						"woff": "http://fonts.gstatic.com/s/euphoriascript/v5/c4XB4Iijj_NvSsCF4I0O2DVi_4UGEKHjyEZCTqR5Ysg.woff",
						"woff2": "http://fonts.gstatic.com/s/euphoriascript/v5/c4XB4Iijj_NvSsCF4I0O2J6NrsdC0qWyfM-y9kwQ5jk.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Ewert": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Ewert\'",
						"\'Ewert-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ewert/v5/xAXnRP_7UC8dQuMhdQd_mQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oetGUZeLFheAIRK64aCwjg&skey=4a41e75919f258a0&v=v5#Ewert",
						"ttf": "http://fonts.gstatic.com/s/ewert/v5/W4C7VvtUKCo_Vk4GCKysLA.ttf",
						"woff": "http://fonts.gstatic.com/s/ewert/v5/7TssRTXcaLr8beqDiv5lkQ.woff",
						"woff2": "http://fonts.gstatic.com/s/ewert/v5/KeD9EFnD-WQgcNxuWDsFFw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Exo": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Exo Thin Italic\'",
						"\'Exo-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/ogJI9GcDrrdUNfxuCUzX2A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TrlXfQd1QcyRg_HCCXv_WA&skey=3a0a54bdb7dec61e&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/4_gM-2xprP9aijXPNKBsdw.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/-KJ68G4vOQ0iT-Z_CUBd8g.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/0FowQzHsbSUXYXQSNXDxZQ.woff2"
					}
				},
				"200": {
					"local": [
						"\'Exo ExtraLight Italic\'",
						"\'Exo-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/bPaOoFN460bwbLDC1739p_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZS4g5weXE5xx8I3SUy5a2vesZW2xOQ-xsNqO47m55DA&skey=bb8551abc124e341&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/KZkPTFM02P3uTVfiDk6i2_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/nNEH4yXWO5IRvRnrB8N0o_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/ksgOZSvBz0KxrfGBw7dPafesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Exo Light Italic\'",
						"\'Exo-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/9Eh3TQAsmD4fal8OOPuTa_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5htIOIG6yi1A-jDKqXwfb_esZW2xOQ-xsNqO47m55DA&skey=c913fe6886eb11a6&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/FO--mEKyXT4ugIkHKUxgOvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/MvuC31KewP-QFsxbMzfMJfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/03NQSoZ7CsKvmGnpKsEEM_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Exo Italic\'",
						"\'Exo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/j5-A0SDRUMMsVNSIuqr_tg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=w2BntWMuc0Fmk5BM15fQmg&skey=2161cc604861ac4f&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/ouqjB58-qIbIc6tNtOafrA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/SrRPhC0khZfK-pbowUGBAw.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/OYgAYULBTKMJJUVQZpJ1ug.woff2"
					}
				},
				"500": {
					"local": [
						"\'Exo Medium Italic\'",
						"\'Exo-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/iV35VkJ8WH4-QDb34ffvQPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NJYki527kG7jl0ctdQ8j9fesZW2xOQ-xsNqO47m55DA&skey=53fc48e2860c5a9b&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/EirSuhHc5LPsqOkwuKdd8PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/1LnzhM6dYPICwfoM9MfuCvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/gt2C348WKP6Tg5YiMi0znPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Exo SemiBold Italic\'",
						"\'Exo-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/MoN1T7I1tnJv0ZaLPHngrPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EtJyIugLkIFZCX5jf1pIG_esZW2xOQ-xsNqO47m55DA&skey=471edf49a1304d68&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/Ek_R6ngmT59El5kpkoxOePesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/cS7UYuQb9nyqGPgy45MPV_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/cvUEH30wvJ41QjMDDF8gS_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Exo Bold Italic\'",
						"\'Exo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/w1T345y6R264yP2x7dODNfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oUSh_mPyt1UTq5MsK7LcmfesZW2xOQ-xsNqO47m55DA&skey=8a55f10e7b609870&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/SCJ8lcLktXFnX90KWp_oHPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/ENjw15vOU74UM6LyiOhPTvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/RUd6U3c1BMbwtyTv2U6XJfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Exo ExtraBold Italic\'",
						"\'Exo-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/iB-Gkexg6ZMds7bgbjLbGvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sz26T5cwQICVvUeISfqLD_esZW2xOQ-xsNqO47m55DA&skey=7e2ab59806b31a20&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/mdnzu29W-cFZeYROHmmUVfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/OxHvdhxScdJBgJvW3f2di_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/VOUNauBNZHRPXwo-B101VvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Exo Black Italic\'",
						"\'Exo-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/R_-He4veb-vmLJRHMeMXKfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pe-_l207gGXlFf0J9PjL0PesZW2xOQ-xsNqO47m55DA&skey=fe9831c0ffbd860f&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/i-d6hMaRtGJeX1Ae4vloR_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/3cavH_EZOAWIiny3PJAOYfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/Js4AswrKxFUW89UW03LfJvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Exo Thin\'",
						"\'Exo-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/VOjseMs0W_ksoG9OL6sjpQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=f4pHyNkoi9ECgBVkeShzug&skey=150f29d0dd342204&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/Zr0MbJYTAN-HcZ_bTgvIlw.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/qyfp0OSqk7TET2opvcMBmw.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/bSEuBfAK9i16rKak_EdKNA.woff2"
					}
				},
				"200": {
					"local": [
						"\'Exo ExtraLight\'",
						"\'Exo-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/6qQWt5DRe819A_OLSfea_g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TtvTjj7-3Dy7gGqp7SBstA&skey=2558ecaabf36cab6&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/CMKhhPu7qcBoVeO_FVLYTg.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/z1hPnoJcXaXYata_d2utlw.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/lA-XzkxvFbAS7qSN5Rm7dw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Exo Light\'",
						"\'Exo-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/f7h3uM6Fc-o-wzyP4yY8ew.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8QOm49pxpxDNKkquzuhabA&skey=6eae7d942f52dbe4&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/dmD6gKcs59jrq1uKvTTMxQ.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/q_s1igR8FunFvLlUJksouQ.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/941bfrYtYbqlIetUPXD4ww.woff2"
					}
				},
				"400": {
					"local": [
						"\'Exo Regular\'",
						"\'Exo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/dyHAhrKQv_y08D_BHFQ0zA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cvTBUZIA6fkfZ-kQoUuiKg&skey=863005d54d49b6b0&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/m5W5Curk5POZ4iQOoRn-Ug.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/wocyXRLWPo2Av-yUTmmbTA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/kA_pX0U45Eb7PbHijV1x2w.woff2"
					}
				},
				"500": {
					"local": [
						"\'Exo Medium\'",
						"\'Exo-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/8rLK3CifJ3ocszySMSwoLA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nNXZdQktuiUx14gwTwBdnQ&skey=2072b70fe7bb0135&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/9GQrDsQoLNPSbu4a8XkaZw.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/yLVQVmQgTSUkafMu4HoVJA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/cfsS7mtf7BxCwNsl8jG12A.woff2"
					}
				},
				"600": {
					"local": [
						"\'Exo SemiBold\'",
						"\'Exo-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/U0OOWpwWYfUE8Sb7dldpuQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zWsh8dtxPylcq0O0P4sPzw&skey=77e591a6753a9a2a&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/BfPy-oLZyJitfovLhnoy1A.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/yQnHD5L8a9aDb09o13m_pg.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/7elr158u735yPgzh9pDCKA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Exo Bold\'",
						"\'Exo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/OqFmJmsFlYjHnwejpSKkeA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vwb9N8hmeDsYZStIPHxi2g&skey=6759387ed4e2b00a&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/Pb-Tqi3xXEdTJ3ZTpmCsBw.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/RokIQ-knd7LT9uhmuUjL2g.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/brV063mXxrmTeVdLP9P6Kw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Exo ExtraBold\'",
						"\'Exo-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/_0lZ4rpzKoEeSwD2vr3bzw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3XXMoq23EHjy-eUgMlTIHA&skey=c99d7166b365909a&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/q6KmdSsfN6LEK-raIRJ77Q.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/JZqdj-HRS4iJsSlrSwRCxA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/bxee2kBKNXMDa_dqwEq7Bg.woff2"
					}
				},
				"900": {
					"local": [
						"\'Exo Black\'",
						"\'Exo-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo/v6/Z_9mpTFG4gyBbpuwvgPjcA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1sappH6fyqUr7jS55g5ipg&skey=a6a95706168b5491&v=v6#Exo",
						"ttf": "http://fonts.gstatic.com/s/exo/v6/1eQ4lxSu6Wlzo5DJtsj51w.ttf",
						"woff": "http://fonts.gstatic.com/s/exo/v6/vUUX2FySly3npcleKTbosw.woff",
						"woff2": "http://fonts.gstatic.com/s/exo/v6/zss5QirmJkYz6dW5juecsA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Exo 2": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Exo 2 Thin Italic\'",
						"\'Exo2-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/BcTwYQH4QHiI46xew8Vt5PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BcTwYQH4QHiI46xew8Vt5Jbd9NUM7myrQQz30yPaGQ4&skey=52bea75ffc259864&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/BcTwYQH4QHiI46xew8Vt5KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/BcTwYQH4QHiI46xew8Vt5D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/BcTwYQH4QHiI46xew8Vt5FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"200": {
					"local": [
						"\'Exo 2 Extra Light Italic\'",
						"\'Exo2-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/FoL3DQ5h24Mp-VKZ-NjJxFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FoL3DQ5h24Mp-VKZ-NjJxKWUboTb-jS2tyCOQMtm97g&skey=c27fb4069c750f73&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/FoL3DQ5h24Mp-VKZ-NjJxC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/FoL3DQ5h24Mp-VKZ-NjJxBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/FoL3DQ5h24Mp-VKZ-NjJxPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Exo 2 Light Italic\'",
						"\'Exo2-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/nWbHq5XdqJFjIrJyBvpVo1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nWbHq5XdqJFjIrJyBvpVo6WUboTb-jS2tyCOQMtm97g&skey=9d2d7f158082f68b&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/nWbHq5XdqJFjIrJyBvpVoy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/nWbHq5XdqJFjIrJyBvpVoxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/nWbHq5XdqJFjIrJyBvpVo_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Exo 2 Italic\'",
						"\'Exo2-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/ieeiH_XppA5A-SYzmthJBQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uQsX0yEM4Xc04vqO5M_rXQ&skey=5ebaaa86d2ddd87&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/7fsA7NyuUlF3GmSznP4iUA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/G075hziEYGpfdK2KgVmqBQ.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/LMIL7_Tt4ZR7oImp-8ghHw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Exo 2 Medium Italic\'",
						"\'Exo2-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/1_2um3wNMzErQK93dC9HelQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_2um3wNMzErQK93dC9HeqWUboTb-jS2tyCOQMtm97g&skey=836cae0cc8180a9&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/1_2um3wNMzErQK93dC9Hei3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/1_2um3wNMzErQK93dC9HehsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/1_2um3wNMzErQK93dC9Hevk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Exo 2 Semi Bold Italic\'",
						"\'Exo2-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/1cBqBVaZ3i9Efab2hdPpzFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1cBqBVaZ3i9Efab2hdPpzKWUboTb-jS2tyCOQMtm97g&skey=80c2d9ae0dd344cc&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/1cBqBVaZ3i9Efab2hdPpzC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/1cBqBVaZ3i9Efab2hdPpzBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/1cBqBVaZ3i9Efab2hdPpzPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Exo 2 Bold Italic\'",
						"\'Exo2-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/Rpc1bsIIcqFfucX8mi4y5lQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Rpc1bsIIcqFfucX8mi4y5qWUboTb-jS2tyCOQMtm97g&skey=3785555033a6839e&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/Rpc1bsIIcqFfucX8mi4y5i3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/Rpc1bsIIcqFfucX8mi4y5hsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/Rpc1bsIIcqFfucX8mi4y5vk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"800": {
					"local": [
						"\'Exo 2 Extra Bold Italic\'",
						"\'Exo2-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/Gj10EN9jO3BquHnP2Z4qNlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Gj10EN9jO3BquHnP2Z4qNqWUboTb-jS2tyCOQMtm97g&skey=aac2f3221350d23a&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/Gj10EN9jO3BquHnP2Z4qNi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/Gj10EN9jO3BquHnP2Z4qNhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/Gj10EN9jO3BquHnP2Z4qNvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"900": {
					"local": [
						"\'Exo 2 Black Italic\'",
						"\'Exo2-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/4W580FLpNwVHxorEVMZVGVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4W580FLpNwVHxorEVMZVGaWUboTb-jS2tyCOQMtm97g&skey=7219eb71082c03cb&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/4W580FLpNwVHxorEVMZVGS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/4W580FLpNwVHxorEVMZVGRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/4W580FLpNwVHxorEVMZVGfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Exo 2 Thin\'",
						"\'Exo2-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/AZO3nx1TUXtpgUJlEnUipA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ogV240kkGAqaNGfz3nKEPw&skey=85d177efa5c4888f&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/jmbn8mddLWoVoG0kG4RB3g.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/H184PiVPwxcA4lae41SXXA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/ADiRusfMayFwcntf9MXsGQ.woff2"
					}
				},
				"200": {
					"local": [
						"\'Exo 2 Extra Light\'",
						"\'Exo2-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/YSV8PjI9HmscsTCu-J96BfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4-tbHg9brRu-z-HO0ZXJjvesZW2xOQ-xsNqO47m55DA&skey=5f4a17bb39d9ab81&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/IX6dkwi1dH8PF3iuoKi9rvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/RFCNDwJa8dM0kzqVeuqPjPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/4VH1sjauXOSoJIJOdxuAC_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Exo 2 Light\'",
						"\'Exo2-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/2duESAtMv5vo0-oNb1BLCPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OpY9ZCloyHFqk_SeBuz-CPesZW2xOQ-xsNqO47m55DA&skey=7bf673c8cb49eaf1&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/ngiFXK5ukde3w4E-Lmb_OvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/JWvvdsUbb528VH-BDTzpW_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/TZlHHgxEfHXA7uKM1eaCjfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Exo 2\'",
						"\'Exo2-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/1f-JR30cwCpEua5F7Wpkjg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UaJJNujq9sDPVrjoyxn8ng&skey=1b9a3dc5c6de9cce&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/N9KSa305HxlY5zk6XisHxw.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/8C2PVL2WIMUnPF90ukjrZQ.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/-A4eIjQkAwKL411pgtQ4VA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Exo 2 Medium\'",
						"\'Exo2-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/2YCVyscJ-jpJ5gxy1fi8ufesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KFU8iDggpBSOJpynA2ou0PesZW2xOQ-xsNqO47m55DA&skey=adb63786cb87541c&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/Aj85fDXQrYnqAVDyNP57H_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/SJSKlaAoPzG8E6EMHXZfevesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/6b9HPGUYUr8qZeNu0Z7o-PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Exo 2 Semi Bold\'",
						"\'Exo2-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/jHsN8GtMqoNkw6LdgMMDsfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SDl7TyCiLNiGrjCAzCGjLPesZW2xOQ-xsNqO47m55DA&skey=80fcc2c639fbd240&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/hFqlepBer-IXtJK7U5poifesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/L7cKReMyy06lvTzTWfUEtfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/0BGKjb5TxeNM_vPrpoWDWPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Exo 2 Bold\'",
						"\'Exo2-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/1hc6b3MWJWPMwBflRiHGbfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EPC8CFTsqwb6BMKOYJrHe_esZW2xOQ-xsNqO47m55DA&skey=82f369e367a555a6&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/F-JaJbplW75-CW3MZ1qMbvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/RZBBdEhQV3g9mUXUAU9PpvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/AbMslUVu4Wq5jvNwOBLwLvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Exo 2 Extra Bold\'",
						"\'Exo2-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/EXzwnUbMXMMICZjIZcT2jvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BNKWZ_pnzjze1469_AgEvfesZW2xOQ-xsNqO47m55DA&skey=5d0eafc8238747c6&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/xB6kRicEILL8IHLLClUt2PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/WevIkQJBpGU3SVYl4lPELfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/CJVzeXcVfU8kDtg9_l0We_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Exo 2 Black\'",
						"\'Exo2-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/exo2/v4/T68xszPQRAmzQ9lzqJyk7PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WOoZhXguqVU5gFT23HvNtPesZW2xOQ-xsNqO47m55DA&skey=b3bd9138e41a9fec&v=v4#Exo2",
						"ttf": "http://fonts.gstatic.com/s/exo2/v4/RkvyadJpQFfhiOnziUIWgPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/exo2/v4/QmjksWUTc2xgGTIqG4SUjfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/exo2/v4/GJUUsjMsQG_gk-UGzcMXofesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Expletus Sans": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Expletus Sans Italic\'",
						"\'ExpletusSans-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/Y-erXmY0b6DU_i2Qu0hTJkaA4UDuhMXS88OyPKPJRdI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Y-erXmY0b6DU_i2Qu0hTJgaO9A8rbHcrtCtU7E2MJ98&skey=d5ae864298e8569a&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/Y-erXmY0b6DU_i2Qu0hTJsTRVpfLYDaJu02tGY_cDUU.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/Y-erXmY0b6DU_i2Qu0hTJs_0Gg_psQEhwRxPwkVXUB8.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/Y-erXmY0b6DU_i2Qu0hTJvOSZGZVnZh1qFL4FBVulds.woff2"
					}
				},
				"500": {
					"local": [
						"\'Expletus Sans Medium Italic\'",
						"\'ExpletusSans-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmWwCONBFOVFsx-hK7IjrCMMY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sRBNtc46w65uJE451UYmWwRv__1KFBPX3lGrv8-gLKQ&skey=9ad64cdf57f1f1c5&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW8u5A6Q16drCslwRrweSiJM.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmWzz7UTTuXWmzX65m1n9Ltf4.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW9_IqBrMQJeb3btf4G2wJuM.woff2"
					}
				},
				"600": {
					"local": [
						"\'Expletus Sans SemiBold Italic\'",
						"\'ExpletusSans-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmWwarojiwqtN6naMlAo7prAg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sRBNtc46w65uJE451UYmW-0HFGVqWr1802I_yAAnDFo&skey=a77bcd933cd47c0c&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW-xz75Rqy_44-crC8dxHOKA.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW2n3oAnaE1USNETzPHCw6uk.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW2idcAJ7RAwQsTzw4C-IkUg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Expletus Sans Bold Italic\'",
						"\'ExpletusSans-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW4N9v1E9s2s8jv6Rx3KRXFM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sRBNtc46w65uJE451UYmWzDUNo_fDsprKQliNc120xk&skey=9087fec68755ac7b&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW0XZMkInVmE5F43bEXap4GE.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW_Qp_31g0rjXKZ8Gm9SMcKk.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/sRBNtc46w65uJE451UYmW8YBCjQycNOg465W8lWeYjs.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Expletus Sans\'",
						"\'ExpletusSans\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/gegTSDBDs5le3g6uxU1ZsbSL3g004LNKkgHM9a6X73A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gegTSDBDs5le3g6uxU1ZsTjR3xVPJpEcWH1UXm1-s8c&skey=543c118cee2614c3&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/gegTSDBDs5le3g6uxU1ZsYB9a16epZVaac-gfobfbfA.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/gegTSDBDs5le3g6uxU1ZsdUFqmyT-Ih543PWa_C0ig4.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/gegTSDBDs5le3g6uxU1ZscmBRJoLbs7X6hY7yFEc97Q.woff2"
					}
				},
				"500": {
					"local": [
						"\'Expletus Sans Medium\'",
						"\'ExpletusSans-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwKvtqssTGFxKBYDOY35-ctA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cl6rhMY77Ilk8lB_uYRRwIAtZcN_2HNZOarCoCsaTns&skey=f593aff44da560da&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwIbHQgMiPeC0S_y2k9np4ck.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwOu_tG0Yx7qqITjSOZkMZIk.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwFZp3tKiB9YnYzAIdkxupX8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Expletus Sans SemiBold\'",
						"\'ExpletusSans-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwMxWCZ0UFUYTJaef0bNFaBI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cl6rhMY77Ilk8lB_uYRRwGV_L9uNyyYRUJ1aET0SJmQ&skey=d5a36fc4a374b26b&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwEfx0vKOZkWeDiTF2TNmgfI.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwJd89XOto2BddXvdZwlDVbA.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwDtVJLiAAMWuKGnPu81oRJ8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Expletus Sans Bold\'",
						"\'ExpletusSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwDaqlI4Zbww6vO_YCdhgxeo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cl6rhMY77Ilk8lB_uYRRwDMNmawHWsxtE2x84tjAX1I&skey=b82fb81e32c901d9&v=v10#ExpletusSans",
						"ttf": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwH726VmFjkD_1knHNL407_k.ttf",
						"woff": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwO1ouKFe7zgu3OIJnKP8_aw.woff",
						"woff2": "http://fonts.gstatic.com/s/expletussans/v10/cl6rhMY77Ilk8lB_uYRRwMrysgx4XYXiGyd0rEkyLBs.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Fanwood Text": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Fanwood Text Italic\'",
						"\'FanwoodText-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fanwoodtext/v7/0J3SBbkMZqBV-3iGxs5E9zoGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0J3SBbkMZqBV-3iGxs5E932UFnxWCzsMUZbVj2XRF5M&skey=9b74f31013f1b5bc&v=v7#FanwoodText",
						"ttf": "http://fonts.gstatic.com/s/fanwoodtext/v7/0J3SBbkMZqBV-3iGxs5E9ytfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/fanwoodtext/v7/0J3SBbkMZqBV-3iGxs5E93pumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/fanwoodtext/v7/0J3SBbkMZqBV-3iGxs5E9xMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Fanwood Text\'",
						"\'FanwoodText-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fanwoodtext/v7/hDNDHUlsSb8bgnEmDp4T_nZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hDNDHUlsSb8bgnEmDp4T_llIn5tFQcqMuf-jhyJP0ps&skey=8cc868de15dabfdc&v=v7#FanwoodText",
						"ttf": "http://fonts.gstatic.com/s/fanwoodtext/v7/hDNDHUlsSb8bgnEmDp4T_onF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/fanwoodtext/v7/hDNDHUlsSb8bgnEmDp4T_nhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/fanwoodtext/v7/hDNDHUlsSb8bgnEmDp4T_ugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Farsan": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"gujarati",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Farsan Regular\'",
						"\'Farsan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/farsan/v3/B9SpPHUYki_ZpV7pXsUEYw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0Mof6TaSEyXz_RvToiVNrQ&skey=e4c5cdf64e1df983&v=v3#Farsan",
						"ttf": "http://fonts.gstatic.com/s/farsan/v3/fu3QjxSrWeLlXuPOsWIyJw.ttf",
						"woff": "http://fonts.gstatic.com/s/farsan/v3/-wRyp6lN3kzZXShkSYEMHw.woff",
						"woff2": "http://fonts.gstatic.com/s/farsan/v3/Tot0ublF44t59uKahgfa6g.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Fascinate": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fascinate\'",
						"\'Fascinate-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fascinate/v6/NnlsYos1mCtA9prs2JfnBfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NnlsYos1mCtA9prs2JfnBZbd9NUM7myrQQz30yPaGQ4&skey=7162e4816d2dd13a&v=v6#Fascinate",
						"ttf": "http://fonts.gstatic.com/s/fascinate/v6/NnlsYos1mCtA9prs2JfnBaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/fascinate/v6/NnlsYos1mCtA9prs2JfnBT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/fascinate/v6/NnlsYos1mCtA9prs2JfnBVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Fascinate Inline": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fascinate Inline\'",
						"\'FascinateInline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fascinateinline/v7/lRguYfMfWArflkm5aOQ5QMwgXoeKbFEsHXKZLH4_qvs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lRguYfMfWArflkm5aOQ5QKcFFcMam07fCGeuAp8QWaw&skey=6bb8a5acb4159e5d&v=v7#FascinateInline",
						"ttf": "http://fonts.gstatic.com/s/fascinateinline/v7/lRguYfMfWArflkm5aOQ5QK3zAIRJwSgnq8SMHmx0gDM.ttf",
						"woff": "http://fonts.gstatic.com/s/fascinateinline/v7/lRguYfMfWArflkm5aOQ5QIbjUz88PNg0W9hW3hMAdPY.woff",
						"woff2": "http://fonts.gstatic.com/s/fascinateinline/v7/lRguYfMfWArflkm5aOQ5QBCZXg0m4hDSRdK3Azz9xfo.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Faster One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Faster One\'",
						"\'FasterOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fasterone/v8/H4ciBXCHmdfClFb-vWhf-LyYgw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H4ciBXCHmdfClFb-vWhf-LyYgA&skey=300222cd2477c9fd&v=v8#FasterOne",
						"ttf": "http://fonts.gstatic.com/s/fasterone/v8/H4ciBXCHmdfClFb-vWhf-LyYgg.ttf",
						"woff": "http://fonts.gstatic.com/s/fasterone/v8/H4ciBXCHmdfClFb-vWhf-LyYgQ.woff",
						"woff2": "http://fonts.gstatic.com/s/fasterone/v8/H4ciBXCHmdfClFb-vWhf-LyYhw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Fasthand": {
		"category": "serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fasthand\'",
						"\'Fasthand-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fasthand/v8/6wCG-MDj5Zrd8jE_E-FbCw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ItXfyHMPmYhA-b3BCArbLA&skey=bdf7efe897af6382&v=v8#Fasthand",
						"ttf": "http://fonts.gstatic.com/s/fasthand/v8/6XAagHH_KmpZL67wTvsETQ.ttf",
						"woff": "http://fonts.gstatic.com/s/fasthand/v8/ipYAPdjQa3-cIZeQKceRJA.woff",
						"woff2": "http://fonts.gstatic.com/s/fasthand/v8/goKeiU7kbyYw5J6o0bY3qhTbgVql8nDJpwnrE27mub0.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Fauna One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fauna One\'",
						"\'FaunaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faunaone/v5/cSd7NBXNFQWK4oX1706dY_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cSd7NBXNFQWK4oX1706dY5bd9NUM7myrQQz30yPaGQ4&skey=3137b8e8ee7f1c9e&v=v5#FaunaOne",
						"ttf": "http://fonts.gstatic.com/s/faunaone/v5/cSd7NBXNFQWK4oX1706dY6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/faunaone/v5/cSd7NBXNFQWK4oX1706dYz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/faunaone/v5/cSd7NBXNFQWK4oX1706dY1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Faustina": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Faustina Italic\'",
						"\'Faustina-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/IXl9POTFfEG5OKNsPkBwIlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IXl9POTFfEG5OKNsPkBwIqWUboTb-jS2tyCOQMtm97g&skey=daecb02da3783719&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/IXl9POTFfEG5OKNsPkBwIi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/IXl9POTFfEG5OKNsPkBwIhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/IXl9POTFfEG5OKNsPkBwIvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"500": {
					"local": [
						"\'Faustina Medium Italic\'",
						"\'Faustina-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/P6ASjT1goNMRHifKhq6WRYJh5taHiwXv-DjBEZUuYXM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=P6ASjT1goNMRHifKhq6WRQ0_qyNcOHZM04svgoBwoTA&skey=f3902a61369ac305&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/P6ASjT1goNMRHifKhq6WRdIZ6OFpBzzPr7LueGMiD8k.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/P6ASjT1goNMRHifKhq6WRe46x7QEqGuF-FJIFiH1W2g.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/P6ASjT1goNMRHifKhq6WRTOo-lJoxoMO4vrg2XwIHQk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Faustina SemiBold Italic\'",
						"\'Faustina-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/OJMzHMQmadDP2rMiZVbZd8G3e9iX24ta7lLMfbqPFME.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OJMzHMQmadDP2rMiZVbZd3XS6izMuFYFwSUB_9Omnz0&skey=335a86b9ce26e656&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/OJMzHMQmadDP2rMiZVbZd7h9hBNNhK4RjzVManoH7kY.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/OJMzHMQmadDP2rMiZVbZd24H_cQCpNmkmj7HsMzmiiM.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/OJMzHMQmadDP2rMiZVbZd6VlZKEoJGujTpfWnQT9bUY.woff2"
					}
				},
				"700": {
					"local": [
						"\'Faustina Bold Italic\'",
						"\'Faustina-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/XGqbj0LfEd8UkIzdKBNugmzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XGqbj0LfEd8UkIzdKBNugj9QLNJZUvW8xv4RpDkyVDQ&skey=f8f6f0851233e777&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/XGqbj0LfEd8UkIzdKBNugvEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/XGqbj0LfEd8UkIzdKBNuggFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/XGqbj0LfEd8UkIzdKBNugoWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Faustina Regular\'",
						"\'Faustina-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/_YEOs4FsljViSaserqFl3PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wM8CyI7tQprbN4QOJOZiD_esZW2xOQ-xsNqO47m55DA&skey=e32c128add4269f7&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/ip6Uoitxz_Wg60l0rqic6_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/SRoYfXZmozyDOfX8_VOl6PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/BEL0cXsTgiEuOwugqgXMR_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Faustina Medium\'",
						"\'Faustina-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/DWobEfBFrLJqy1nQazTj_mfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DWobEfBFrLJqy1nQazTj_nNsigHlcrQGNV8nkUSFQfc&skey=53166b05596dfec&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/DWobEfBFrLJqy1nQazTj_p0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/DWobEfBFrLJqy1nQazTj_obN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/DWobEfBFrLJqy1nQazTj_o4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Faustina SemiBold\'",
						"\'Faustina-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/n9JiAJV8H-qYAVyy_GF0AmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=n9JiAJV8H-qYAVyy_GF0AnNsigHlcrQGNV8nkUSFQfc&skey=27c0ca3484bdd993&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/n9JiAJV8H-qYAVyy_GF0Ap0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/n9JiAJV8H-qYAVyy_GF0AobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/n9JiAJV8H-qYAVyy_GF0Ao4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Faustina Bold\'",
						"\'Faustina-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/faustina/v2/_Y84a0gyC8nIOgqJT8Z35mfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_Y84a0gyC8nIOgqJT8Z35nNsigHlcrQGNV8nkUSFQfc&skey=e246869b17108526&v=v2#Faustina",
						"ttf": "http://fonts.gstatic.com/s/faustina/v2/_Y84a0gyC8nIOgqJT8Z35p0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/faustina/v2/_Y84a0gyC8nIOgqJT8Z35obN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/faustina/v2/_Y84a0gyC8nIOgqJT8Z35o4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Federant": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Federant\'",
						"\'Federant-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/federant/v9/w8C9nKQvJ07_8C2P7-WazfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6-MtxPVFScVS6lZMAX83pvesZW2xOQ-xsNqO47m55DA&skey=863c14e56a981dc9&v=v9#Federant",
						"ttf": "http://fonts.gstatic.com/s/federant/v9/Tfrjvw7If6C2rMCF58AATPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/federant/v9/C109bUmZeyhh-vIXq9lNfvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/federant/v9/3UZxWoZanYkKkn3pE8qtMfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Federo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Federo\'",
						"\'Federo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/federo/v9/tJyotfIhh_z7SP0XT_AhVQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PGwsmQIjYVZsf27Xur0Qug&skey=47fc219fa617d18a&v=v9#Federo",
						"ttf": "http://fonts.gstatic.com/s/federo/v9/lyIIJ-Qmb89iSKTPVm5SGw.ttf",
						"woff": "http://fonts.gstatic.com/s/federo/v9/FnU7BHlDZgmlIL4FzGh7QA.woff",
						"woff2": "http://fonts.gstatic.com/s/federo/v9/4U6MlhO4EXR36XAHof-Qyw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Felipa": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Felipa\'",
						"\'Felipa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/felipa/v5/SYVmNW1EQj6qnGoKzxdE8g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=T4PsglkgG0wypYsxyBvNMg&skey=b63251ce51fb2b06&v=v5#Felipa",
						"ttf": "http://fonts.gstatic.com/s/felipa/v5/hM5bgqqTw1m1RPvoMcssTw.ttf",
						"woff": "http://fonts.gstatic.com/s/felipa/v5/ru5l4Hi0qDnGRWzqs7FL0g.woff",
						"woff2": "http://fonts.gstatic.com/s/felipa/v5/nKYNf-hMYFtb5lxIEOn_yg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Fenix": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fenix\'",
						"\'Fenix-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fenix/v5/TrGfTOnHUq_ewLeyGtoyhw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AYci31rzWw6W6-Vk4_nSOg&skey=f66d8ae9cfca8a8a&v=v5#Fenix",
						"ttf": "http://fonts.gstatic.com/s/fenix/v5/bcplnphK3jNGowiu9YNSfA.ttf",
						"woff": "http://fonts.gstatic.com/s/fenix/v5/c6Y-VhDabeO1oBJ8dG5vpA.woff",
						"woff2": "http://fonts.gstatic.com/s/fenix/v5/kGOpsn7ilqkwQsHyf14dHg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Finger Paint": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Finger Paint Regular\'",
						"\'FingerPaint-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fingerpaint/v7/m_ZRbiY-aPb13R3DWPBGX3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=m_ZRbiY-aPb13R3DWPBGX1lIn5tFQcqMuf-jhyJP0ps&skey=43e614e9c5adbe1d&v=v7#FingerPaint",
						"ttf": "http://fonts.gstatic.com/s/fingerpaint/v7/m_ZRbiY-aPb13R3DWPBGX4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/fingerpaint/v7/m_ZRbiY-aPb13R3DWPBGX3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/fingerpaint/v7/m_ZRbiY-aPb13R3DWPBGX-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Fira Mono": {
		"category": "monospace",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fira Mono Regular\'",
						"\'FiraMono-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firamono/v6/SlRWfq1zeqXiYWAN-lnG-vY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SlRWfq1zeqXiYWAN-lnG-pbd9NUM7myrQQz30yPaGQ4&skey=bb26c8d476ab3f05&v=v6#FiraMono",
						"ttf": "http://fonts.gstatic.com/s/firamono/v6/SlRWfq1zeqXiYWAN-lnG-qCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/firamono/v6/SlRWfq1zeqXiYWAN-lnG-j8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/firamono/v6/SlRWfq1zeqXiYWAN-lnG-ltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Mono Medium\'",
						"\'FiraMono-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firamono/v6/PJ4zAY1ucu5ib6LzyvHMkXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PJ4zAY1ucu5ib6LzyvHMkVlIn5tFQcqMuf-jhyJP0ps&skey=9ab5808f9463dfb5&v=v6#FiraMono",
						"ttf": "http://fonts.gstatic.com/s/firamono/v6/PJ4zAY1ucu5ib6LzyvHMkYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firamono/v6/PJ4zAY1ucu5ib6LzyvHMkXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firamono/v6/PJ4zAY1ucu5ib6LzyvHMkegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Mono Bold\'",
						"\'FiraMono-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firamono/v6/l24Wph3FsyKAbJ8dfExTZ3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l24Wph3FsyKAbJ8dfExTZ1lIn5tFQcqMuf-jhyJP0ps&skey=3313aa7e4518a10&v=v6#FiraMono",
						"ttf": "http://fonts.gstatic.com/s/firamono/v6/l24Wph3FsyKAbJ8dfExTZ4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firamono/v6/l24Wph3FsyKAbJ8dfExTZ3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firamono/v6/l24Wph3FsyKAbJ8dfExTZ-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Fira Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Fira Sans Thin Italic\'",
						"\'FiraSans-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/fmobwZujc_UI4huzQvESm7eskzFlZTkzN_FGynPZJZk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fmobwZujc_UI4huzQvESm93oSpqWURvZ6I3ad-WfbBU&skey=341ad589036af5f9&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/fmobwZujc_UI4huzQvESm34UHu-c0cTZKOwO_f6u1Os.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/fmobwZujc_UI4huzQvESmyeJLMOzE6CCkidNEpZOseY.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/fmobwZujc_UI4huzQvESm9FPPhm6yPYYGACxOp9LMJ4.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans ExtraLight Italic\'",
						"\'FiraSans-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTVT7wzIiOHIChIARuHOnLzM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTRZBgPlnpWaoq0SaX6doyAk&skey=18decd3d6b316ef7&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTYk9RAFW3K6S6MTuxUiRJAk.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTdj3jEPHYvfoh7wL9kai_ws.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTf-yvr_zg92NT13uHB6uFCI.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Light Italic\'",
						"\'FiraSans-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTbXcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTT4dnM32POWavC8T_whbZeI&skey=981613b1f1c19899&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTbfB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTR_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTUo2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Italic\'",
						"\'FiraSans-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/QURAmFz4b80g324-oF-Uj2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QURAmFz4b80g324-oF-Uj3NsigHlcrQGNV8nkUSFQfc&skey=5fe19ef9a49b95be&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/QURAmFz4b80g324-oF-Uj50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/QURAmFz4b80g324-oF-Uj4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/QURAmFz4b80g324-oF-Uj44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Medium Italic\'",
						"\'FiraSans-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTSGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTa057wUl25f8_0IloMUHk98&skey=53b79611ec149004&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTfMi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTSqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTbBojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans SemiBold Italic\'",
						"\'FiraSans-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTY8mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTeVmfClkf66xvxL1SWm4y8M&skey=70a0891bcc69a0b2&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTS8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTX5HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTV2umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Bold Italic\'",
						"\'FiraSans-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTbFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTXtNmQEE9wZ6UZlmiISB1pg&skey=78bc75c716a0540e&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTZ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTTqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTYlIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans ExtraBold Italic\'",
						"\'FiraSans-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTZhT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTUWkFefV8YEa5Z9BVNHdJ6k&skey=67b7134ea35f6a8b&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTVDMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTUCDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTXibbpXgLHK_uTT48UMyjSM.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Black Italic\'",
						"\'FiraSans-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTa8knJ7dcSpE9bYpElP8kOU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6s0YCA9oCTF6hM60YM-qTcTCo6WkuhWceGynHdPeLtc&skey=20d173b712e1016&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTRG4wFYO9UG-PxKqsSvMNyg.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTUExzZ44ka2Lr5i-x5aWr0E.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/6s0YCA9oCTF6hM60YM-qTcpPZoEQdaDZ3o3Np19rzJk.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Fira Sans Thin\'",
						"\'FiraSans-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/Ynpq02VHJlzawsZhjoqF02fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ynpq02VHJlzawsZhjoqF03NsigHlcrQGNV8nkUSFQfc&skey=64c40d824566239e&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/Ynpq02VHJlzawsZhjoqF050EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/Ynpq02VHJlzawsZhjoqF04bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/Ynpq02VHJlzawsZhjoqF044P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans ExtraLight\'",
						"\'FiraSans-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/H2QtVYRshA1CFy63P7ykZ3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H2QtVYRshA1CFy63P7ykZ1lIn5tFQcqMuf-jhyJP0ps&skey=7cab1449b43e5b9&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/H2QtVYRshA1CFy63P7ykZ4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/H2QtVYRshA1CFy63P7ykZ3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/H2QtVYRshA1CFy63P7ykZ-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Light\'",
						"\'FiraSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/VTBnrK42EiOBncVyQXZ7j3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VTBnrK42EiOBncVyQXZ7j1lIn5tFQcqMuf-jhyJP0ps&skey=29796a61fd9662f4&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/VTBnrK42EiOBncVyQXZ7j4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/VTBnrK42EiOBncVyQXZ7j3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/VTBnrK42EiOBncVyQXZ7j-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Regular\'",
						"\'FiraSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/EjsrzDkQUQCDwsBtLpcVQfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EjsrzDkQUQCDwsBtLpcVQZbd9NUM7myrQQz30yPaGQ4&skey=6bde03e5f15b0572&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/EjsrzDkQUQCDwsBtLpcVQaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/EjsrzDkQUQCDwsBtLpcVQT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/EjsrzDkQUQCDwsBtLpcVQVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Medium\'",
						"\'FiraSans-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/zM2u8V3CuPVwAAXFQcDi4HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zM2u8V3CuPVwAAXFQcDi4FlIn5tFQcqMuf-jhyJP0ps&skey=456b47052756ee1b&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/zM2u8V3CuPVwAAXFQcDi4InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/zM2u8V3CuPVwAAXFQcDi4HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/zM2u8V3CuPVwAAXFQcDi4Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans SemiBold\'",
						"\'FiraSans-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/TPhEsJuyxIEzWtby22btfnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TPhEsJuyxIEzWtby22btfllIn5tFQcqMuf-jhyJP0ps&skey=8920e733a3b00083&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/TPhEsJuyxIEzWtby22btfonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/TPhEsJuyxIEzWtby22btfnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/TPhEsJuyxIEzWtby22btfugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Bold\'",
						"\'FiraSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/DugPdSljmOTocZOR2CItOnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DugPdSljmOTocZOR2CItOllIn5tFQcqMuf-jhyJP0ps&skey=dba2db2fadc4e190&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/DugPdSljmOTocZOR2CItOonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/DugPdSljmOTocZOR2CItOnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/DugPdSljmOTocZOR2CItOugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans ExtraBold\'",
						"\'FiraSans-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/htOw9f-chtELyJuFCkCrFnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=htOw9f-chtELyJuFCkCrFllIn5tFQcqMuf-jhyJP0ps&skey=f87360e58d18c0db&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/htOw9f-chtELyJuFCkCrFonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/htOw9f-chtELyJuFCkCrFnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/htOw9f-chtELyJuFCkCrFugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Black\'",
						"\'FiraSans-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasans/v8/rowJfijyp23uW9P2J-sluHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rowJfijyp23uW9P2J-sluFlIn5tFQcqMuf-jhyJP0ps&skey=d8950a00edf19f79&v=v8#FiraSans",
						"ttf": "http://fonts.gstatic.com/s/firasans/v8/rowJfijyp23uW9P2J-sluInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasans/v8/rowJfijyp23uW9P2J-sluHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasans/v8/rowJfijyp23uW9P2J-sluOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Fira Sans Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Fira Sans Condensed Thin Italic\'",
						"\'FiraSansCondensed-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Nqqv1KfmeTlTML-ky7aaREpQVdyI354tRoOL1ZbFKDI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Nqqv1KfmeTlTML-ky7aaRNuJtahFZH-cDSstG3H-BiE&skey=3ad413d8dfb7bd19&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Nqqv1KfmeTlTML-ky7aaRLUyKrxV_me7qq_LPb3oG1w.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Nqqv1KfmeTlTML-ky7aaRDMjHS-mONrMg_N_MJymeLY.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Nqqv1KfmeTlTML-ky7aaRD83t6X-yXyP0CFyiplv3KU.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans Condensed ExtraLight Italic\'",
						"\'FiraSansCondensed-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDzWYiMUuTCt7VBEcRre5cgv3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD5vwfeVfWl8iVi30yF0vyWX3rGVtsTkPsbDajuO5ueQw&skey=5a1635463629eab0&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD-5zn2io3TFh3F9eHIFeaWL3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD2brX9aHidFNXrV0TMDdVbb3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDwI8bQ2LInr_hpUxGaF1keH3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Condensed Light Italic\'",
						"\'FiraSansCondensed-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD_mEZO9oFUxRsIusPr8huSn3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD3kkM9H8oAIzQd0p0uSqt8j3rGVtsTkPsbDajuO5ueQw&skey=99ec36cc427f65e9&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD6-Pg0ixc20mZJdRQiuQhCr3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD6XnXbwdDC8wAz6IIzmCDUP3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDyqWG1TIildrkra2taUxHyT3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Condensed Italic\'",
						"\'FiraSansCondensed-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99LvtvjP7piqfuf-5eQ5WteKAxI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-hkH0zXsjNm-yd0g99LvtgBTXIwlJtTq4TEmRgRLrSU&skey=3a5e8471b6814bd2&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99Lvtp6XEhYGyLNXhd1cwnYARbc.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99LvtmoZfyEciwAFAfPYs7IaHX0.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99Lvtma7JNZ_U4BOvHrsfjgI5HE.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Condensed Medium Italic\'",
						"\'FiraSansCondensed-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD_03XiIBfBP4j82pBIEoe1j3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD60NAs7J7ctAZdDi_5BAheD3rGVtsTkPsbDajuO5ueQw&skey=b9c0abfde49d715f&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD_UTtHp3jeo_79MO46rlDiD3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD6u4oVdpsfUdGsLIVtphjvL3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD-88seZ_a57qN2zp29oIdz33rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans Condensed SemiBold Italic\'",
						"\'FiraSansCondensed-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD7ZQBN7Fw-1CanrJrHOK8qX3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD6kn_Ja0R-tg2po83VTv9t_3rGVtsTkPsbDajuO5ueQw&skey=a58e8555e5202816&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDwSxrn7pKpnXQWIiwoljU2z3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD1-neqG8vFotYomnUFwZDJT3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD8D50Y0tcRZLJOQDyy4U45D3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Condensed Bold Italic\'",
						"\'FiraSansCondensed-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDxozMfk_pn-y8sDkRLxfMQj3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD23dwRDbkhMt7xAGfAvyvpr3rGVtsTkPsbDajuO5ueQw&skey=b35d9619d462c5a2&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD5irmbUBSdU5Bh6qB0yDQ833rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD1k-aGrXOm2RmtKescMYQ2D3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDxonZ4JUPj1cM9Awmw66V2T3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans Condensed ExtraBold Italic\'",
						"\'FiraSansCondensed-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD33wut2I_4gw9hcSS2UMkgz3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjDyElQ07EmGQxSqE9b2SwW5T3rGVtsTkPsbDajuO5ueQw&skey=d974ee9ad8d47bc5&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDxHAwf_Zvf5HmjWmtuvSwCf3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD5r9tpJAwUH-9RxK8cmGQ673rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD5dhWTq8T5EHStIx2owSnX33rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Condensed Black Italic\'",
						"\'FiraSansCondensed-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD7HTqPj1yTKl-ZpnglrADaf3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z87ZCYzj43dcQd7C-kCjD-UwSQ_DrDFFLGfsVQfUCwz3rGVtsTkPsbDajuO5ueQw&skey=3f44f783eaea6dbd&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDzkDG4RrzXuhBx3HGTdTidv3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjD9qW-XngFe1umfa0SYhW-dj3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/Z87ZCYzj43dcQd7C-kCjDyb6uMyQnU_1T3n4meEBtWH3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Fira Sans Condensed Thin\'",
						"\'FiraSansCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99Lvtqzu1paGFOHzXvoGlvL_dbo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-hkH0zXsjNm-yd0g99Lvtqwe0UurrO13lw01c_hRovE&skey=757e24dd2d13b88c&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99LvtjUe_xbzV2jSoKsJ-3B6P_I.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99LvtoHyaa2SpwDAh2J5CKcRQ10.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/-hkH0zXsjNm-yd0g99LvtiBOZQ7m4JucuvlvD_IgbDs.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans Condensed ExtraLight\'",
						"\'FiraSansCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993MBbFBV_KAPucelmtAoJAyY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993NwqqHLso2T6WQAKTF-x1b8&skey=e73a15dca6ef37b9&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993EEXPgak8P8an7Xnfl-R4bc.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993OX2uYM6yD8OGPtuxiE7CfY.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993OdSs1uNNNgO8NnQSpFahZ0.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Condensed Light\'",
						"\'FiraSansCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993OnoCx_jK1JUF_-5xuexfsU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993HWv8Nzt8mDniOqXwxRfZic&skey=a014e8090d14b783&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993D1GzwQ5qF9DNzkQQVRhJ4g.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993F1YPouZEKgzpqZW9wN-3Ek.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993BEur64QvLD-0IbiAdTUNXE.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Condensed Regular\'",
						"\'FiraSansCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/HQGj1o4-qj8agzakWWMQw1CVIJ7mTErJPnZ9-XljUEA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HQGj1o4-qj8agzakWWMQw4vve3NcST3RVr2cXZcnkRQ&skey=96eb1234fcb38aea&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/HQGj1o4-qj8agzakWWMQw-7XHbm9bNXYe2idoFddR1c.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/HQGj1o4-qj8agzakWWMQwz-GTvntjrDzHCVWP3JLxew.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/HQGj1o4-qj8agzakWWMQw3beBvOnr03nAdLtAYthXTk.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Condensed Medium\'",
						"\'FiraSansCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993PGr8ZCn2Z8qo7OSdjmtVOY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993AkZHBY7nvdO70XWejpyRzY&skey=d6a657503c629186&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993EoVfhMAYdcYiBn0NG_o6UY.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993GtQbJMUHno6E__xnSC8Luc.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993Aqucz1E_8CNctQpbMaP2yE.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans Condensed SemiBold\'",
						"\'FiraSansCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993OOohYwqYTpdAmii7IORcaY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993J2E0XrHmyTqi6-_HlhxiIE&skey=cc45b6dceab562dd&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993Mm2BRE4Gzgzkl5izKQC0fY.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993AEUrRGhzY7RLMSypJqAM18.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993J7sOVs_bSQrxKT1d0L_85g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Condensed Bold\'",
						"\'FiraSansCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993K1G_hHhJSbmG3TYw9dbn0A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993F_KRdOo7MPcl77ahlJwp_0&skey=4e18c89becbd4d36&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993JhsE6jcpsD2oq89kgohWx0.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993ONSK5BxN3NFS4EJkViHIqo.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993IF8zhZCJ7x9Pr62cRgaVUA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans Condensed ExtraBold\'",
						"\'FiraSansCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993Kp17zt2XWIOAX7jqjss1Lw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993HRj83HRrgWJ3MrpQWG7vW8&skey=103b7d6491a1d7d9&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993OZ7jK2t_dxSYltK0hL87Cs.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993BWzwR0XAwqgPPaorD8ZEKo.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993KYfU3KCQgHLJHpZ57PKdXE.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Condensed Black\'",
						"\'FiraSansCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993GpCPKeleEHXkUafDuPEMFo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1srRZ14gKpu4XGd0R993K41ybpqidA5jjWiKib0KA0&skey=db544b239e097f6&v=v2#FiraSansCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993F--VuffzeRjI8MROFbP53U.ttf",
						"woff": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993Iq6y4cNHMYZZ9RI-aN7MEA.woff",
						"woff2": "http://fonts.gstatic.com/s/firasanscondensed/v2/k1srRZ14gKpu4XGd0R993BklYdX73m7bOqxQv0tXTAE.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Fira Sans Extra Condensed": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Fira Sans Extra Condensed Thin Italic\'",
						"\'FiraSansExtraCondensed-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPC3rJMxZWU5MzfxRspz2SWZ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPDd6EqallEb2eiN2nfln2wV&skey=b600ee3c3a5ab78a&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPB-FB7vnNHE2SjsDv3-rtTr.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPAniSzDsxOggpInTRKWTrHm.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/G8VKhLxlTd0YOlG3i1R8CfHXjqTqiXVW6z8kDssMYPDRTz4Zusj2GBgAsTqfSzCe.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans Extra Condensed ExtraLight Italic\'",
						"\'FiraSansExtraCondensed-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBU-8MyIjhyAoSAEbhzpy8z.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAWQYD5Z6VmqKtEml-naMgJ&skey=f11887328d3d6338&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCJPUQBVtyukujE7sVIkSQJ.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDY94xDx2L36Ie8C_ZGov8L.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPD_sr6_84PdjU9d7hwerhQi.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Extra Condensed Light Italic\'",
						"\'FiraSansExtraCondensed-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPC13I8xGsdi30AJSvA3TM4Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPA-HZzN9jzlmrwvE_8IW2Xi&skey=31b4690f8d187725&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPC3wd9csTsz_nM23-gACgla.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAf8R6mIAFfQZf2UG2FMZ0F.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBKNpUzHlgP5JiMlq5DQsD3.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Extra Condensed Italic\'",
						"\'FiraSansExtraCondensed-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArrxVbq2GavmgSqiduTepI-tn0HCrrUF3CK0X8keY3Y2P.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_dPmaUiuUAWmL0ibePdArrxVbq2GavmgSqiduTepI-tzbIoB5XK0BjVfJ5FEhUH3&skey=a86d53b4d7cf33d6&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArrxVbq2GavmgSqiduTepI-udBAFcbdBtG4hJ7aeN0Leh.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArrxVbq2GavmgSqiduTepI-uGzelA8h1gZettGviEX7gZ.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArrxVbq2GavmgSqiduTepI-uOD-SAqMfCqtyy1DTMpRju.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Extra Condensed Medium Italic\'",
						"\'FiraSansExtraCondensed-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAhrtijkk2sCPHfcwr0ocpY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCtOe8FJduX_P9CJaDFB5Pf&skey=880a21d996770c67&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDzIt-PnbCSmiLS2uU0S_Xl.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAqhxF9qvvqNrKNeKSBJdPM.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCwaIxPSeVJ6TLb-Td838cJ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans Extra Condensed SemiBold Italic\'",
						"\'FiraSansExtraCondensed-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCPJpAImKRcsKhtkb6cwZ01.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDlZnwpZH-usb8S9UlpuMvD&skey=ccc36f2310a71468&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPAvHKix-DBIkhNETnFPqhzg.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPB-R8RgXAb4nAqU6erKR3za.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBdrpjskVOz4EYr_A13ICY5.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Extra Condensed Bold Italic\'",
						"\'FiraSansExtraCondensed-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCxbdvWghyk-6LQ1vZetgGo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPB7TZkBBPcGelGZZoiEgdaY&skey=f720b631b95e2109&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCf05L6MJSDrW0e3j4BTqRe.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPA6kf95Mff4SV228lPEuiDd.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCJSGbvhw6ZgyGTIoJrK6HO.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans Extra Condensed ExtraBold Italic\'",
						"\'FiraSansExtraCondensed-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCYU9q5CxRTFS8pn4H5llbS.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBFpBXn1fGBGuWfQVTR3Sep&skey=fba7a247d7ced35b&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBQzKwGLaDorKqjA1vTPzKn.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBAg3uuxhIAb_x58rx033Xs.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPB4m26V4Cxyv7k0-PFDMo0j.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Extra Condensed Black Italic\'",
						"\'FiraSansExtraCondensed-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPCvJJye3XEqRPW2KRJT_JDl.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDEwqOlpLoVnHhspx3T3i7X&skey=e4d21b4f0f312277&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPARuMBWDvVBvj8SqrErzDco.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPBBMc2eOJGti6-YvseWlq9B.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/iGnuurQ1EqiOs_hlr82MCvHXjqTqiXVW6z8kDssMYPDKT2aBEHWg2d6Nzadfa8yZ.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Fira Sans Extra Condensed Thin\'",
						"\'FiraSansExtraCondensed-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArs00uUrJU9SHzrEEGlBJXURn0HCrrUF3CK0X8keY3Y2P.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_dPmaUiuUAWmL0ibePdArs00uUrJU9SHzrEEGlBJXURzbIoB5XK0BjVfJ5FEhUH3&skey=88bb89c7d5a6820c&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArs00uUrJU9SHzrEEGlBJXUSdBAFcbdBtG4hJ7aeN0Leh.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArs00uUrJU9SHzrEEGlBJXUSGzelA8h1gZettGviEX7gZ.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/_dPmaUiuUAWmL0ibePdArs00uUrJU9SHzrEEGlBJXUSOD-SAqMfCqtyy1DTMpRju.woff2"
					}
				},
				"200": {
					"local": [
						"\'Fira Sans Extra Condensed ExtraLight\'",
						"\'FiraSansExtraCondensed-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4Sh2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4ShZSJ-bRUHKjLn_o4ciT9Kb&skey=289141b858c3eb9a&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4SiJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4Sh4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW_7IC3ILXfeIVwvfWGu4SjoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"300": {
					"local": [
						"\'Fira Sans Extra Condensed Light\'",
						"\'FiraSansExtraCondensed-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV12djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV1ZSJ-bRUHKjLn_o4ciT9Kb&skey=74324d7ef249034e&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV2JxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV14QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW7O05EUNkkL_mPtCuekiV3oHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Fira Sans Extra Condensed Regular\'",
						"\'FiraSansExtraCondensed-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/wg_5XrW_o1_ZfuCbAkBfGVRjX9Jlut_-eN40c1mQErz2Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wg_5XrW_o1_ZfuCbAkBfGVRjX9Jlut_-eN40c1mQEryW3fTVDO5sq0EM99Mj2hkO&skey=6da40aeae3bd26bf&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/wg_5XrW_o1_ZfuCbAkBfGVRjX9Jlut_-eN40c1mQEryglnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/wg_5XrW_o1_ZfuCbAkBfGVRjX9Jlut_-eN40c1mQErw_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/wg_5XrW_o1_ZfuCbAkBfGVRjX9Jlut_-eN40c1mQErxbV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				},
				"500": {
					"local": [
						"\'Fira Sans Extra Condensed Medium\'",
						"\'FiraSansExtraCondensed-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuN2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuNZSJ-bRUHKjLn_o4ciT9Kb&skey=38a937873f6a4e&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuOJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuN4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7Owdd0GPYAHEVh0EvoffkRAuPoHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Fira Sans Extra Condensed SemiBold\'",
						"\'FiraSansExtraCondensed-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDp2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDpZSJ-bRUHKjLn_o4ciT9Kb&skey=99b43188211a089c&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDqJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDp4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwW8v1dGG_WArVpDmblm5TDroHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Fira Sans Extra Condensed Bold\'",
						"\'FiraSansExtraCondensed-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6d2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6dZSJ-bRUHKjLn_o4ciT9Kb&skey=a6c20dde08358c83&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6eJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6d4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwdEjTMY3GGLBv_AxlS3Ww6foHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Fira Sans Extra Condensed ExtraBold\'",
						"\'FiraSansExtraCondensed-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiR2djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiRZSJ-bRUHKjLn_o4ciT9Kb&skey=f99658a8aab1e251&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiSJxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiR4QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwZZWqFq9WyGGQ2ef9bXDKiToHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				},
				"900": {
					"local": [
						"\'Fira Sans Extra Condensed Black\'",
						"\'FiraSansExtraCondensed-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ92djACgHNseEdbjknnoHOV.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ9ZSJ-bRUHKjLn_o4ciT9Kb&skey=60d29d87f9b54084&v=v2#FiraSansExtraCondensed",
						"ttf": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ-JxebhXQ7bTC75lriXYYYL.ttf",
						"woff": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ94QlDhs-72BoevNJRofrlz.woff",
						"woff2": "http://fonts.gstatic.com/s/firasansextracondensed/v2/34whiWDL4CxC1laOcj7OwRPaRBEe7-4iQsBL_zD1FQ_oHZtC2XY6q-fqGsl0jnn4.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Fjalla One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fjalla One\'",
						"\'FjallaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fjallaone/v5/rxxXUYj4oZ6Q5oDJFtEd6lQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rxxXUYj4oZ6Q5oDJFtEd6qWUboTb-jS2tyCOQMtm97g&skey=81738d23c31d6227&v=v5#FjallaOne",
						"ttf": "http://fonts.gstatic.com/s/fjallaone/v5/rxxXUYj4oZ6Q5oDJFtEd6i3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/fjallaone/v5/rxxXUYj4oZ6Q5oDJFtEd6hsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/fjallaone/v5/rxxXUYj4oZ6Q5oDJFtEd6vk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Fjord One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fjord One\'",
						"\'Fjord-One\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fjordone/v6/k1xuy2AQ8wbv_amiU4s58_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=k1xuy2AQ8wbv_amiU4s585bd9NUM7myrQQz30yPaGQ4&skey=224c2a5a687d4c50&v=v6#FjordOne",
						"ttf": "http://fonts.gstatic.com/s/fjordone/v6/k1xuy2AQ8wbv_amiU4s586CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/fjordone/v6/k1xuy2AQ8wbv_amiU4s58z8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/fjordone/v6/k1xuy2AQ8wbv_amiU4s581tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Flamenco": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Flamenco Light\'",
						"\'Flamenco-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/flamenco/v8/g1FaNDzBWfWXCtcQ8FcMbGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=g1FaNDzBWfWXCtcQ8FcMbHNsigHlcrQGNV8nkUSFQfc&skey=982e722eb7bf7dcb&v=v8#Flamenco",
						"ttf": "http://fonts.gstatic.com/s/flamenco/v8/g1FaNDzBWfWXCtcQ8FcMbJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/flamenco/v8/g1FaNDzBWfWXCtcQ8FcMbIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/flamenco/v8/g1FaNDzBWfWXCtcQ8FcMbI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Flamenco Regular\'",
						"\'Flamenco-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/flamenco/v8/3eSteYWUjd1pnCoI0_KaSPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZpVJNabCMBugHKvTPQFGSvesZW2xOQ-xsNqO47m55DA&skey=f68e375417019cab&v=v8#Flamenco",
						"ttf": "http://fonts.gstatic.com/s/flamenco/v8/eFddhPhjkE2ivntTZU35C_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/flamenco/v8/Ih-SipknQN9xiiZItSGWE_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/flamenco/v8/eY_UZqPceqmE3GUQnY4AhfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Flavors": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Flavors\'",
						"\'Flavors-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/flavors/v6/7jQxMchdQr3kwqhPzQKgDw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_gcfdb42DCqk1qvdkTmQjg&skey=21678b8931efff73&v=v6#Flavors",
						"ttf": "http://fonts.gstatic.com/s/flavors/v6/Sfnl6OrJsW3KTMtCN8dxaQ.ttf",
						"woff": "http://fonts.gstatic.com/s/flavors/v6/7ed-D3MQicPNqc0ZKJ1T1Q.woff",
						"woff2": "http://fonts.gstatic.com/s/flavors/v6/iDm5ckQPf6fDGAlKQS5R9Q.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Fondamento": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Fondamento-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fondamento/v7/y6TmwhSbZ8rYq7OTFyo7OXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y6TmwhSbZ8rYq7OTFyo7OVlIn5tFQcqMuf-jhyJP0ps&skey=456138419774c965&v=v7#Fondamento",
						"ttf": "http://fonts.gstatic.com/s/fondamento/v7/y6TmwhSbZ8rYq7OTFyo7OYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/fondamento/v7/y6TmwhSbZ8rYq7OTFyo7OXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/fondamento/v7/y6TmwhSbZ8rYq7OTFyo7Oegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Fondamento Regular\'",
						"\'Fondamento-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fondamento/v7/bHQyc5zrMLI5-R-me5j-elQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bHQyc5zrMLI5-R-me5j-eqWUboTb-jS2tyCOQMtm97g&skey=33bcda47da77a40b&v=v7#Fondamento",
						"ttf": "http://fonts.gstatic.com/s/fondamento/v7/bHQyc5zrMLI5-R-me5j-ei3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/fondamento/v7/bHQyc5zrMLI5-R-me5j-ehsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/fondamento/v7/bHQyc5zrMLI5-R-me5j-evk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Fontdiner Swanky": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fontdiner Swanky Regular\'",
						"\'FontdinerSwanky-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fontdinerswanky/v8/8_GxIO5ixMtn5P6COsF3Tj6MLWZjvmgAr5KueuEi7gg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8_GxIO5ixMtn5P6COsF3TvLXNo3e77Tb9QVER099fwY&skey=eb2f25a9e68f5546&v=v8#FontdinerSwanky",
						"ttf": "http://fonts.gstatic.com/s/fontdinerswanky/v8/8_GxIO5ixMtn5P6COsF3TpflEzs6CqquNOseSoBzzaY.ttf",
						"woff": "http://fonts.gstatic.com/s/fontdinerswanky/v8/8_GxIO5ixMtn5P6COsF3TsjICbAXuUS7AO0pfTwi7Ho.woff",
						"woff2": "http://fonts.gstatic.com/s/fontdinerswanky/v8/8_GxIO5ixMtn5P6COsF3Tsy4Bvmor6GKUp1XJvzweTE.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Forum": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Forum\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/forum/v8/ZqpICanVEXplF5Afx-0HCw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EcU6d6zcKBYRekLFVrOQSw&skey=85e1828a547f7984&v=v8#Forum",
						"ttf": "http://fonts.gstatic.com/s/forum/v8/WIqlIn7uo_Vma4QAUqf-Mw.ttf",
						"woff": "http://fonts.gstatic.com/s/forum/v8/KsJrhVlKA7udJPNqNdl2fA.woff",
						"woff2": "http://fonts.gstatic.com/stats/Forum/normal/400"
					}
				}
			}
		},
		"version": "v8"
	},
	"Francois One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Francois One Regular\'",
						"\'FrancoisOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/francoisone/v11/bYbkq2nU2TSx4SwFbz5sCHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bYbkq2nU2TSx4SwFbz5sCFlIn5tFQcqMuf-jhyJP0ps&skey=37e55f964c88f579&v=v11#FrancoisOne",
						"ttf": "http://fonts.gstatic.com/s/francoisone/v11/bYbkq2nU2TSx4SwFbz5sCInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/francoisone/v11/bYbkq2nU2TSx4SwFbz5sCHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/francoisone/v11/bYbkq2nU2TSx4SwFbz5sCOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Frank Ruhl Libre": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"hebrew",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Frank Ruhl Libre Light\'",
						"\'FrankRuhlLibre-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPLU5dXIx52O-U4d43CVL35c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y8NWif61iD8Hg8bGAmxFPFq8TcccdwR-oWjrutwUuJ4&skey=35ed760dc028c407&v=v3#FrankRuhlLibre",
						"ttf": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPO5LQ2WNWFWLvKBtSO9dmxo.ttf",
						"woff": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPHVvRAk2Q46s42E7i7AVDWw.woff",
						"woff2": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPH5BWikTRfs3yLHp5ek91vk.woff2"
					}
				},
				"400": {
					"local": [
						"\'Frank Ruhl Libre Regular\'",
						"\'FrankRuhlLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frankruhllibre/v3/yDLloNqBpFmakCImLv4OJvkM9pyc0JelaKnehqCvl9k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yDLloNqBpFmakCImLv4OJr5cmG68yVcfEpjlq38id2E&skey=f32d6e63ec16a834&v=v3#FrankRuhlLibre",
						"ttf": "http://fonts.gstatic.com/s/frankruhllibre/v3/yDLloNqBpFmakCImLv4OJgl9RWWBmyuUQVUtb9Clhtk.ttf",
						"woff": "http://fonts.gstatic.com/s/frankruhllibre/v3/yDLloNqBpFmakCImLv4OJrdwje-2aRmMsDzIsfkn3Is.woff",
						"woff2": "http://fonts.gstatic.com/s/frankruhllibre/v3/yDLloNqBpFmakCImLv4OJgDcEzbAYeRgPE7Iy7GOQsw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Frank Ruhl Libre Medium\'",
						"\'FrankRuhlLibre-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPFfoLQzdKJRodL6ufoOon70.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y8NWif61iD8Hg8bGAmxFPGxDzjCA-jz6e1CpYkx6FT4&skey=d47a1255e88b4349&v=v3#FrankRuhlLibre",
						"ttf": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPF2hiOI2zNpN-Dw7riu8M0k.ttf",
						"woff": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPKV8mQCTZb1P0o7eR4tPK9g.woff",
						"woff2": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPK2AS8ciI0R-ozDFgI3lEg0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Frank Ruhl Libre Bold\'",
						"\'FrankRuhlLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPL7c-kFEwEzsY7jxYZls8s8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y8NWif61iD8Hg8bGAmxFPHZvKNKg4zvGFQtsKRhubXs&skey=ffd72a2cb2718862&v=v3#FrankRuhlLibre",
						"ttf": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPGn0SYiS2pLoKQnrwQci16k.ttf",
						"woff": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPN7bwj9Rok6WRoS9mlxFwUc.woff",
						"woff2": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPDBvEPFk-lQkaC6YMQ_QSvw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Frank Ruhl Libre Black\'",
						"\'FrankRuhlLibre-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPNsbE_Ddhifn38abvBPPG7c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=y8NWif61iD8Hg8bGAmxFPLbrD4l7zMvC-XdxD6KFOMg&skey=b6e95c684b24b8c4&v=v3#FrankRuhlLibre",
						"ttf": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPHYAUdPslAYll2p9BU73jic.ttf",
						"woff": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPJI6L0QiATuVenM0hYgAx6k.woff",
						"woff2": "http://fonts.gstatic.com/s/frankruhllibre/v3/y8NWif61iD8Hg8bGAmxFPLaNGg0baThznQmagYgxIWM.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Freckle Face": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Freckle Face\'",
						"\'FreckleFace-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/freckleface/v5/7-B8j9BPJgazdHIGqPNv83Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7-B8j9BPJgazdHIGqPNv81lIn5tFQcqMuf-jhyJP0ps&skey=6847a6b1de75e60f&v=v5#FreckleFace",
						"ttf": "http://fonts.gstatic.com/s/freckleface/v5/7-B8j9BPJgazdHIGqPNv84nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/freckleface/v5/7-B8j9BPJgazdHIGqPNv83hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/freckleface/v5/7-B8j9BPJgazdHIGqPNv8-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Fredericka the Great": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fredericka the Great\'",
						"\'FrederickatheGreat\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frederickathegreat/v6/7Es8Lxoku-e5eOZWpxw18kLzRiPHQLkuFZv2gk0ljvI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7Es8Lxoku-e5eOZWpxw18rcJGWqSLpeSpZOiOfNRws0&skey=e76684586970fdda&v=v6#FrederickatheGreat",
						"ttf": "http://fonts.gstatic.com/s/frederickathegreat/v6/7Es8Lxoku-e5eOZWpxw18oRQ8DD0aAk7ES4QQYHqQcw.ttf",
						"woff": "http://fonts.gstatic.com/s/frederickathegreat/v6/7Es8Lxoku-e5eOZWpxw18vc3vBAn7YvtW9hNjxWZBR0.woff",
						"woff2": "http://fonts.gstatic.com/s/frederickathegreat/v6/7Es8Lxoku-e5eOZWpxw18hsRj2C0BvLNQqKHRdEu66Y.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Fredoka One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fredoka One\'",
						"\'FredokaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fredokaone/v5/SL0aFUFfkFMMdariYQ3_YWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SL0aFUFfkFMMdariYQ3_YXNsigHlcrQGNV8nkUSFQfc&skey=fac42792a60c2aba&v=v5#FredokaOne",
						"ttf": "http://fonts.gstatic.com/s/fredokaone/v5/SL0aFUFfkFMMdariYQ3_YZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/fredokaone/v5/SL0aFUFfkFMMdariYQ3_YYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/fredokaone/v5/SL0aFUFfkFMMdariYQ3_YY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Freehand": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Freehand\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/freehand/v9/-EXJcImXZ-_9euj3Oy0vkQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BXZoOXLfSeLyE-Rx0oCtoQ&skey=6e5cd9e236ba872c&v=v9#Freehand",
						"ttf": "http://fonts.gstatic.com/s/freehand/v9/uEBQxvA0lnn_BrD6krlxMw.ttf",
						"woff": "http://fonts.gstatic.com/s/freehand/v9/3ENloTh4jcPLGQAoeaWRoQ.woff",
						"woff2": "http://fonts.gstatic.com/s/freehand/v9/nh8yG8bYlMo73Y8vh55GmhTbgVql8nDJpwnrE27mub0.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Fresca": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fresca-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fresca/v6/na76Gj0v46oaHBLZ39ReGw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SUpwpfOsa8kAm3uz-_KfPQ&skey=3ce39b8c0a3206e0&v=v6#Fresca",
						"ttf": "http://fonts.gstatic.com/s/fresca/v6/d1iL81LLcMQNnb74Q4SUHw.ttf",
						"woff": "http://fonts.gstatic.com/s/fresca/v6/d-W4qajtBODIvW9mWhVTMw.woff",
						"woff2": "http://fonts.gstatic.com/s/fresca/v6/L9MHVkA5YfCLS-4K6Lxf9w.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Frijole": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Frijole\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/frijole/v6/1pd2zRlIKLbKmIbe9W4Odg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3YcIFpNj3XLc1VT6rDgEBQ&skey=e994fa4cc1f77143&v=v6#Frijole",
						"ttf": "http://fonts.gstatic.com/s/frijole/v6/KY1jGfdOyy7wGqIgHMe1-A.ttf",
						"woff": "http://fonts.gstatic.com/s/frijole/v6/JMJmIdqpEk7-RyNfk_4Nrw.woff",
						"woff2": "http://fonts.gstatic.com/s/frijole/v6/J98nbmyAJUbYHCciqpEIsg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Fruktur": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fruktur\'",
						"\'Fruktur-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fruktur/v10/OQ63_pW64ihXF_04WhWZ_w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dNGrdkHRRs41sZgqekVlsA&skey=2938d85b2577c941&v=v10#Fruktur",
						"ttf": "http://fonts.gstatic.com/s/fruktur/v10/7DvQjQT1eyMMabJQtbOTYw.ttf",
						"woff": "http://fonts.gstatic.com/s/fruktur/v10/wW9QEJ2KEYS75opRHz2YTg.woff",
						"woff2": "http://fonts.gstatic.com/s/fruktur/v10/GzfYV5tEJQgnhy9LNDFueg.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Fugaz One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Fugaz One\'",
						"\'FugazOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/fugazone/v7/foh--NswBHNPbRHy7yEyyPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=foh--NswBHNPbRHy7yEyyJbd9NUM7myrQQz30yPaGQ4&skey=aa70ca3dfc3ffe29&v=v7#FugazOne",
						"ttf": "http://fonts.gstatic.com/s/fugazone/v7/foh--NswBHNPbRHy7yEyyKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/fugazone/v7/foh--NswBHNPbRHy7yEyyD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/fugazone/v7/foh--NswBHNPbRHy7yEyyFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"GFS Didot": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"greek"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'GFS Didot Regular\'",
						"\'GFSDidot-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gfsdidot/v7/HXkyr8qr_RWLBw2wqbe40A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kgB1tTolMAtObthCjddbcQ&skey=e557a45a8e5b3a1b&v=v7#GFSDidot",
						"ttf": "http://fonts.gstatic.com/s/gfsdidot/v7/jQKxZy2RU-h9tkPZcRVluA.ttf",
						"woff": "http://fonts.gstatic.com/s/gfsdidot/v7/JBubNrFihEk1sFMZEvXXHQ.woff",
						"woff2": "http://fonts.gstatic.com/s/gfsdidot/v7/JGMMXLSKnta8tgBslucoDBJtnKITppOI_IvcXXDNrsc.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"GFS Neohellenic": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"greek"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'GFS Neohellenic Italic\'",
						"\'GFSNeohellenic-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gfsneohellenic/v8/KnaWrO4awITAqigQIIYXKgyL_1fciT3O9peg8vjJQ8g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KnaWrO4awITAqigQIIYXKvRbWNZXH5zCkdPbEdJVEq0&skey=f2ba620c81c38934&v=v8#GFSNeohellenic",
						"ttf": "http://fonts.gstatic.com/s/gfsneohellenic/v8/KnaWrO4awITAqigQIIYXKkCTdomiyJpIzPbEbIES3rU.ttf",
						"woff": "http://fonts.gstatic.com/s/gfsneohellenic/v8/KnaWrO4awITAqigQIIYXKgQ7A6N5eu3f-t9LeySiaPw.woff",
						"woff2": "http://fonts.gstatic.com/s/gfsneohellenic/v8/KnaWrO4awITAqigQIIYXKnokPx945tHga_8nZ481G-0.woff2"
					}
				},
				"700": {
					"local": [
						"\'GFS Neohellenic Bold Italic\'",
						"\'GFSNeohellenic-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gfsneohellenic/v8/FwWjoX6XqT-szJFyqsu_GbFyFOPMNfg--ZiwYXygZ3s.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FwWjoX6XqT-szJFyqsu_GQYJZpB3qifmBMLmIeTWaa8&skey=862dcd242c044705&v=v8#GFSNeohellenic",
						"ttf": "http://fonts.gstatic.com/s/gfsneohellenic/v8/FwWjoX6XqT-szJFyqsu_GYFF0fM4h-krcpQk7emtCpE.ttf",
						"woff": "http://fonts.gstatic.com/s/gfsneohellenic/v8/FwWjoX6XqT-szJFyqsu_GS4ZuhbQL0jq09m1zhiZstI.woff",
						"woff2": "http://fonts.gstatic.com/s/gfsneohellenic/v8/FwWjoX6XqT-szJFyqsu_GUvFI-I0v8iv56rTAaN9MPc.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'GFS Neohellenic Regular\'",
						"\'GFSNeohellenic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gfsneohellenic/v8/B4xRqbn-tANVqVgamMsSDp0BeMOIV1roD_7YONSCHbg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=B4xRqbn-tANVqVgamMsSDoHxMRPSvKekqaMdffMPNoo&skey=23c7e23ffcc49e32&v=v8#GFSNeohellenic",
						"ttf": "http://fonts.gstatic.com/s/gfsneohellenic/v8/B4xRqbn-tANVqVgamMsSDiayCZa0z7CpFzlkqoCHztc.ttf",
						"woff": "http://fonts.gstatic.com/s/gfsneohellenic/v8/B4xRqbn-tANVqVgamMsSDgBb2G5jwR1gaB5zdMT6AAg.woff",
						"woff2": "http://fonts.gstatic.com/s/gfsneohellenic/v8/B4xRqbn-tANVqVgamMsSDnA0ar_G1g7ao76N0sFdT7k.woff2"
					}
				},
				"700": {
					"local": [
						"\'GFS Neohellenic Bold\'",
						"\'GFSNeohellenic-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gfsneohellenic/v8/7HwjPQa7qNiOsnUce2h447wqvl1Ml4lmXGLGJhL8tXQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7HwjPQa7qNiOsnUce2h4495pNdQU0A7tUuXn8C66srU&skey=5d1eabadf3ca5996&v=v8#GFSNeohellenic",
						"ttf": "http://fonts.gstatic.com/s/gfsneohellenic/v8/7HwjPQa7qNiOsnUce2h4448_BwCLZY3eDSV6kppAwI8.ttf",
						"woff": "http://fonts.gstatic.com/s/gfsneohellenic/v8/7HwjPQa7qNiOsnUce2h44ygxRJ6-tqV9CYUdeguvkrg.woff",
						"woff2": "http://fonts.gstatic.com/s/gfsneohellenic/v8/7HwjPQa7qNiOsnUce2h441HunvrA8Rw42M-jhN_zIE0.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Gabriela": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gabriela Regular\'",
						"\'Gabriela-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gabriela/v6/OuWUazjZ1wjVhCOZBzjdyvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qHpMCbU5GYb55LZoYcAcWvesZW2xOQ-xsNqO47m55DA&skey=146d0218141ab9a9&v=v6#Gabriela",
						"ttf": "http://fonts.gstatic.com/s/gabriela/v6/m8JJYqAhymuJ2Zb4xZ3F8fesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/gabriela/v6/fLaucCvjCt_Hmc9smyo_rPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/gabriela/v6/CO6bIpNvGrJRZDx3xfggGvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Gafata": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gafata\'",
						"\'Gafata-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gafata/v6/qT8TVNsi7Co3SDx2CiokXQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Y18ISLC4VPD2GfqWyh5Z1w&skey=ac32f67a7703448a&v=v6#Gafata",
						"ttf": "http://fonts.gstatic.com/s/gafata/v6/o-DwOh1jynFSAy8preUMxw.ttf",
						"woff": "http://fonts.gstatic.com/s/gafata/v6/1_IZAK3uvysA0G_ed1qSXA.woff",
						"woff2": "http://fonts.gstatic.com/s/gafata/v6/huW5kFr5H0qwNOVvefTUkw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Galada": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin",
			"bengali"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Galada Regular\'",
						"\'Galada-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/galada/v3/TiBcM1tinA0We-7gOoSylw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_GiejnEuBYZqwzBjVTkwZg&skey=de71fa94111f3d7d&v=v3#Galada",
						"ttf": "http://fonts.gstatic.com/s/galada/v3/3uw-1N1JhkMZXaGpkFHKBQ.ttf",
						"woff": "http://fonts.gstatic.com/s/galada/v3/eNCyzdR-y692ml-p3NuKSg.woff",
						"woff2": "http://fonts.gstatic.com/s/galada/v3/Ji1CD7PUU4vLwHmFNG9qCg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Galdeano": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Galdeano Regular\'",
						"\'Galdeano-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/galdeano/v7/7jX5YT8ca7yDu9GzRW5rL_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sKMRNlVba3eKybWZXyias_esZW2xOQ-xsNqO47m55DA&skey=f35e3b95f31e91f5&v=v7#Galdeano",
						"ttf": "http://fonts.gstatic.com/s/galdeano/v7/xWfNF53zMVtUUmsSpUl10vesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/galdeano/v7/XWkZhyfrNgo9X-giTt_ZffesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/galdeano/v7/sNNdoZxHJuJuQ4ASrbgR4PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Galindo": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Galindo\'",
						"\'Galindo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/galindo/v5/_lfSjmbJgT-pha_OgtUTtQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JIH01u7_e_rTrU6xvO88Gw&skey=62f7a52c71aba32&v=v5#Galindo",
						"ttf": "http://fonts.gstatic.com/s/galindo/v5/qNMYhSz5osLRf8fCTjnAPA.ttf",
						"woff": "http://fonts.gstatic.com/s/galindo/v5/vJR6Sv3rfpB_ufQ5UMFyRQ.woff",
						"woff2": "http://fonts.gstatic.com/s/galindo/v5/ZzYghoQM3JxcNvqVrHQqdg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Gentium Basic": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Gentium Basic Italic\'",
						"\'GentiumBasic-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbasic/v9/qoFz4NSMaYC2UmsMAG3lyQUkgARuUXZIxt5rXLb3n8k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qoFz4NSMaYC2UmsMAG3lyYrfwRyl8asFBLqWlOTHA-0&skey=470b462549031946&v=v9#GentiumBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbasic/v9/qoFz4NSMaYC2UmsMAG3lye726At3X82y5AWtoPEElVw.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbasic/v9/qoFz4NSMaYC2UmsMAG3lySC-qRU_6_vWulQf4LzJBHg.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbasic/v9/qoFz4NSMaYC2UmsMAG3lyW5FRUnxr1M4kZrq7L_6ApE.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gentium Basic Bold Italic\'",
						"\'GentiumBasic-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbasic/v9/8N9-c_aQDJ8LbI1NGVMrwn8mMOEyOizEHwdGXLujBng.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8N9-c_aQDJ8LbI1NGVMrwnwn4DUc0JWwPxIQPzI65-8&skey=ed279e75f2d6c22f&v=v9#GentiumBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbasic/v9/8N9-c_aQDJ8LbI1NGVMrwhQm-60Czvb2KgPFxgTgjKQ.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbasic/v9/8N9-c_aQDJ8LbI1NGVMrwsTP7Eq1kpYYfQx9LsCg3bo.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbasic/v9/8N9-c_aQDJ8LbI1NGVMrwk295JWl-nT9BH3skCTuCqU.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Gentium Basic\'",
						"\'GentiumBasic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbasic/v9/KCktj43blvLkhOTolFn-MaXmlaNvdBp66gw-0Z-GNT0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KCktj43blvLkhOTolFn-McL4T2BsURrqI6i72jKYpWA&skey=b5c43dfa07efda99&v=v9#GentiumBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbasic/v9/KCktj43blvLkhOTolFn-MW4ooKQJV7rZJEeBgiz-w_g.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbasic/v9/KCktj43blvLkhOTolFn-MZ_RtrTXGeaL_Dia6_H9gNs.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbasic/v9/KCktj43blvLkhOTolFn-MWYKogTrBb-Yb2DFwx30qLM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gentium Basic Bold\'",
						"\'GentiumBasic-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbasic/v9/2qL6yulgGf0wwgOp-UqGyGW9WjpZoGzJxe9AP8RyDXQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2qL6yulgGf0wwgOp-UqGyNyX-rODVVvYEe8zZl135q0&skey=2883f05f34134ff6&v=v9#GentiumBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbasic/v9/2qL6yulgGf0wwgOp-UqGyNDm-5ieiTvJbrToT6-clWs.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbasic/v9/2qL6yulgGf0wwgOp-UqGyE2Y6eZT-eLKqoGYfiv5isg.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbasic/v9/2qL6yulgGf0wwgOp-UqGyKD_k3lO0YJEjlKxWOdVRBo.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Gentium Book Basic": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Gentium Book Basic Italic\'",
						"\'GentiumBookBasic-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/qHqW2lwKO8-uTfIkh8FsUbE2jCMhcGIrntA3yqCfyps.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qHqW2lwKO8-uTfIkh8FsUTXIzSFdE77gJuX9QwVPm1w&skey=7d0db4a8f90df4cf&v=v8#GentiumBookBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/qHqW2lwKO8-uTfIkh8FsUYJj0KCKfahGjG_5jxibq9k.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/qHqW2lwKO8-uTfIkh8FsUfrqj88NXfAsM1m2qetzTrY.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/qHqW2lwKO8-uTfIkh8FsUXUql-1tEtvjER-FQGS8CNg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gentium Book Basic Bold Italic\'",
						"\'GentiumBookBasic-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/632u7TMIoFDWQYUaHFUp5H4vm4rKlCFg9VeLEmqo5c0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=632u7TMIoFDWQYUaHFUp5CDaac2UD1yf7Yejrqdpy6M&skey=fcece854bedf6784&v=v8#GentiumBookBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/632u7TMIoFDWQYUaHFUp5I4ZH3inhBwbJdjuXzTJN8k.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/632u7TMIoFDWQYUaHFUp5HLdHZVRci2HdkkDqhT5urM.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/632u7TMIoFDWQYUaHFUp5ANP697_9vdFBSYQK024I8k.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Gentium Book Basic\'",
						"\'GentiumBookBasic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/IRFxB2matTxrjZt6a3FUnm48Ne3jUcc02Ly6R-R1_N4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IRFxB2matTxrjZt6a3FUnoIkmWj7K_zGT5sTuJkrFwY&skey=e59bbbdff9bf19ed&v=v8#GentiumBookBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/IRFxB2matTxrjZt6a3FUnsQ6HWhO-urg7Zd40mHsFaI.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/IRFxB2matTxrjZt6a3FUnsiUQA3_wO-qQTJfqhvSKS0.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/IRFxB2matTxrjZt6a3FUntZP4GUu-EsApAyJMU_dJ9I.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gentium Book Basic Bold\'",
						"\'GentiumBookBasic-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/T2vUYmWzlqUtgLYdlemGnVbzycWkWRvQ9AZnGBfoNVY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=T2vUYmWzlqUtgLYdlemGnUzKUNb2GkgNlGM6dpLbZW8&skey=a88f8dc92f935def&v=v8#GentiumBookBasic",
						"ttf": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/T2vUYmWzlqUtgLYdlemGnbdiNC2EW_LVDR83j5uZVEA.ttf",
						"woff": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/T2vUYmWzlqUtgLYdlemGnVIi2N2FDuziJMXLp6dUo54.woff",
						"woff2": "http://fonts.gstatic.com/s/gentiumbookbasic/v8/T2vUYmWzlqUtgLYdlemGnYRjMofpY2QVEIrKQ01iDTw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Geo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Geo Oblique\'",
						"\'Geo-Oblique\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/geo/v9/zpPTN1U1v52ji0PWx2gkOA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tjPWQqr9IGX4dpgb2ykN8w&skey=d62ed86780b06e0&v=v9#Geo",
						"ttf": "http://fonts.gstatic.com/s/geo/v9/5QHORsd1hXcWGLZPYKOYQw.ttf",
						"woff": "http://fonts.gstatic.com/s/geo/v9/KmkHe66ZDSvX4bFo0LMz1w.woff",
						"woff2": "http://fonts.gstatic.com/s/geo/v9/hEEdCFP5tR4ssC_OaeRXDw.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Geo\'",
						"\'Geo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/geo/v9/nLMymXBqt5h9sN8YW1r2ng.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=G0L4dXdM2nFLJwiNAe35LA&skey=417aad24c5ef650a&v=v9#Geo",
						"ttf": "http://fonts.gstatic.com/s/geo/v9/PZuLMEHg-ApVzHRFEvyOKg.ttf",
						"woff": "http://fonts.gstatic.com/s/geo/v9/av0TkpgOwGmqABT09bQMSA.woff",
						"woff2": "http://fonts.gstatic.com/s/geo/v9/lutaIpfXBU1nwBiNdnFGUw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Geostar": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Geostar\'",
						"\'Geostar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/geostar/v7/IcataThX2txXS5f602ccTA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HonnEKW3oD4Ym_3f4Ov96A&skey=909e800316655e1b&v=v7#Geostar",
						"ttf": "http://fonts.gstatic.com/s/geostar/v7/jGGPjdvGJ-BoCd8m39MBHg.ttf",
						"woff": "http://fonts.gstatic.com/s/geostar/v7/s650-K2b6lcOlZCirqE9PA.woff",
						"woff2": "http://fonts.gstatic.com/s/geostar/v7/nzPy9OeCUlrvasr5B00qNQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Geostar Fill": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Geostar Fill\'",
						"\'GeostarFill-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/geostarfill/v7/Y5ovXPPOHYTfQzK2aM-hunZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Y5ovXPPOHYTfQzK2aM-hullIn5tFQcqMuf-jhyJP0ps&skey=828f2e60a91919b&v=v7#GeostarFill",
						"ttf": "http://fonts.gstatic.com/s/geostarfill/v7/Y5ovXPPOHYTfQzK2aM-huonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/geostarfill/v7/Y5ovXPPOHYTfQzK2aM-hunhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/geostarfill/v7/Y5ovXPPOHYTfQzK2aM-huugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Germania One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Germania One\'",
						"\'GermaniaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/germaniaone/v5/3_6AyUql_-FbDi1e68jHdHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3_6AyUql_-FbDi1e68jHdFlIn5tFQcqMuf-jhyJP0ps&skey=e0b4110be5196afe&v=v5#GermaniaOne",
						"ttf": "http://fonts.gstatic.com/s/germaniaone/v5/3_6AyUql_-FbDi1e68jHdInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/germaniaone/v5/3_6AyUql_-FbDi1e68jHdHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/germaniaone/v5/3_6AyUql_-FbDi1e68jHdOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Gidugu": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gidugu\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gidugu/v4/Osc_2PHec0tluUe5A9KYow.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1LO4xXUMdFyDXZUXhWB0_g&skey=52d850c02c4a43e2&v=v4#Gidugu",
						"ttf": "http://fonts.gstatic.com/s/gidugu/v4/pxEnPZn4n0SOAR3CFnTsHQ.ttf",
						"woff": "http://fonts.gstatic.com/s/gidugu/v4/KSoD7KeQRbpODWmkeoufbw.woff",
						"woff2": "http://fonts.gstatic.com/s/gidugu/v4/dTPIfC6KnK6GPhfbfmNAXw.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Gilda Display": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gilda Display\'",
						"\'GildaDisplay-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gildadisplay/v5/8yAVUZLLZ3wb7dSsjix0CBZIeTymVizouGp24XaykfY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8yAVUZLLZ3wb7dSsjix0CKt6BGvXf9OoEVzBIUMbShY&skey=a96c8e607690656f&v=v5#GildaDisplay",
						"ttf": "http://fonts.gstatic.com/s/gildadisplay/v5/8yAVUZLLZ3wb7dSsjix0CP1Ie94GXVQ4L73iNy0KJ5Y.ttf",
						"woff": "http://fonts.gstatic.com/s/gildadisplay/v5/8yAVUZLLZ3wb7dSsjix0CLL95gww2ifOu31tFZtEfvs.woff",
						"woff2": "http://fonts.gstatic.com/s/gildadisplay/v5/8yAVUZLLZ3wb7dSsjix0CDhcrYRUcSdWF4dICtV_C1I.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Give You Glory": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Give You Glory\'",
						"\'GiveYouGlory\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/giveyouglory/v7/DFEWZFgGmfseyIdGRJAxuFaS1Fa-Vujq_y5saWiQnic.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DFEWZFgGmfseyIdGRJAxuJPi_Se27LwpPX3xikCqDDw&skey=147545eeeab1069c&v=v7#GiveYouGlory",
						"ttf": "http://fonts.gstatic.com/s/giveyouglory/v7/DFEWZFgGmfseyIdGRJAxuLaZ_k0KT24F4IS70nmMDYY.ttf",
						"woff": "http://fonts.gstatic.com/s/giveyouglory/v7/DFEWZFgGmfseyIdGRJAxuJre1ArFO0nxyUXZnjCjpOg.woff",
						"woff2": "http://fonts.gstatic.com/s/giveyouglory/v7/DFEWZFgGmfseyIdGRJAxuBcAUOYGvnPYlcaEKgTjjG0.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Glass Antiqua": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Glass Antiqua\'",
						"\'GlassAntiqua-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/glassantiqua/v5/0yLrXKplgdUDIMz5TnCHNBaMMUiNNY1IQbIV7e8ODnc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0yLrXKplgdUDIMz5TnCHNGMPOzKCRqgB4bBx3b-1aoc&skey=546960b56752cfa5&v=v5#GlassAntiqua",
						"ttf": "http://fonts.gstatic.com/s/glassantiqua/v5/0yLrXKplgdUDIMz5TnCHNGbSELdkQ3Les1sVIQZgz9g.ttf",
						"woff": "http://fonts.gstatic.com/s/glassantiqua/v5/0yLrXKplgdUDIMz5TnCHNKyztDLpUjNAkGAPlCwy4fk.woff",
						"woff2": "http://fonts.gstatic.com/s/glassantiqua/v5/0yLrXKplgdUDIMz5TnCHNMI79x-VWsl9ZLFyGx7L0Fo.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Glegoo": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Glegoo\'",
						"\'Glegoo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/glegoo/v6/-980wJDu-PBMkMpRUlWH-w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2EToqKQjHFKD35kHt3yrdQ&skey=6551fc07d4130f4e&v=v6#Glegoo",
						"ttf": "http://fonts.gstatic.com/s/glegoo/v6/rRnY1PEvm8fHngJkZm5BIA.ttf",
						"woff": "http://fonts.gstatic.com/s/glegoo/v6/8x8S7gQMbbduiGv8gbUJ0Q.woff",
						"woff2": "http://fonts.gstatic.com/s/glegoo/v6/4v2EawaFC4uubOp5x2Jowg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Glegoo Bold\'",
						"\'Glegoo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/glegoo/v6/yG77c-qahUY-abN0x5R7EfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yG77c-qahUY-abN0x5R7EZbd9NUM7myrQQz30yPaGQ4&skey=2a299c59145b3847&v=v6#Glegoo",
						"ttf": "http://fonts.gstatic.com/s/glegoo/v6/yG77c-qahUY-abN0x5R7EaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/glegoo/v6/yG77c-qahUY-abN0x5R7ET8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/glegoo/v6/yG77c-qahUY-abN0x5R7EVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Gloria Hallelujah": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gloria Hallelujah\'",
						"\'GloriaHallelujah\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gloriahallelujah/v9/CA1k7SlXcY5kvI81M_R28RWp_va1cOkgzoB8dfDAF9k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CA1k7SlXcY5kvI81M_R28WgD74H2H0wMiak15WL6pKw&skey=6624637ba47a20&v=v9#GloriaHallelujah",
						"ttf": "http://fonts.gstatic.com/s/gloriahallelujah/v9/CA1k7SlXcY5kvI81M_R28Y7PgI6IeGWgqdOlp0TQlJM.ttf",
						"woff": "http://fonts.gstatic.com/s/gloriahallelujah/v9/CA1k7SlXcY5kvI81M_R28Y5mSNQmgKshuii2YddNQzE.woff",
						"woff2": "http://fonts.gstatic.com/s/gloriahallelujah/v9/CA1k7SlXcY5kvI81M_R28cNDay8z-hHR7F16xrcXsJw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Goblin One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Goblin One\'",
						"\'GoblinOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/goblinone/v7/oMm__6Fu4fp1Uf80vOEkgFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oMm__6Fu4fp1Uf80vOEkgKWUboTb-jS2tyCOQMtm97g&skey=42b648ad0b68aa48&v=v7#GoblinOne",
						"ttf": "http://fonts.gstatic.com/s/goblinone/v7/oMm__6Fu4fp1Uf80vOEkgC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/goblinone/v7/oMm__6Fu4fp1Uf80vOEkgBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/goblinone/v7/oMm__6Fu4fp1Uf80vOEkgPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Gochi Hand": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gochi Hand\'",
						"\'GochiHand-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gochihand/v8/ZZzTGmufF-Wq8IS3fkpBu1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZZzTGmufF-Wq8IS3fkpBu6WUboTb-jS2tyCOQMtm97g&skey=2623c44f4d0c9cf8&v=v8#GochiHand",
						"ttf": "http://fonts.gstatic.com/s/gochihand/v8/ZZzTGmufF-Wq8IS3fkpBuy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/gochihand/v8/ZZzTGmufF-Wq8IS3fkpBuxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/gochihand/v8/ZZzTGmufF-Wq8IS3fkpBu_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Gorditas": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gorditas\'",
						"\'Gorditas-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gorditas/v5/GWDY7vfy_ae6RTRFca57gfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7AZwLL3OI_GVX9Qnstkg8fesZW2xOQ-xsNqO47m55DA&skey=cfd1ab6bcac7e384&v=v5#Gorditas",
						"ttf": "http://fonts.gstatic.com/s/gorditas/v5/NsybWrDmYPJ7698T5Q-uCfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/gorditas/v5/OofBftZK2azuDs_dfHbULPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/gorditas/v5/QeJf8GX6ZxfT30zEmdYGd_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gorditas Bold\'",
						"\'Gorditas-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gorditas/v5/D8TQWS0-4bIuA-leQiV23GfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=D8TQWS0-4bIuA-leQiV23HNsigHlcrQGNV8nkUSFQfc&skey=3e81262dd817bf6f&v=v5#Gorditas",
						"ttf": "http://fonts.gstatic.com/s/gorditas/v5/D8TQWS0-4bIuA-leQiV23J0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/gorditas/v5/D8TQWS0-4bIuA-leQiV23IbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/gorditas/v5/D8TQWS0-4bIuA-leQiV23I4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Goudy Bookletter 1911": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Goudy Bookletter 1911\'",
						"\'GoudyBookletter1911\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/goudybookletter1911/v7/l5lwlGTN3pEY5Bf-rQEuIHkY3soKkPv_thL__S829Cw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l5lwlGTN3pEY5Bf-rQEuIGPS7iBAsUqbQLkQKPfd2ho&skey=c69e3ee382ddc4a0&v=v7#GoudyBookletter1911",
						"ttf": "http://fonts.gstatic.com/s/goudybookletter1911/v7/l5lwlGTN3pEY5Bf-rQEuILmKcuvUA98TddnVPjOJl_w.ttf",
						"woff": "http://fonts.gstatic.com/s/goudybookletter1911/v7/l5lwlGTN3pEY5Bf-rQEuIMvsW7MYFVYsuLRj6jSUyb0.woff",
						"woff2": "http://fonts.gstatic.com/s/goudybookletter1911/v7/l5lwlGTN3pEY5Bf-rQEuIAQibyVIKv8boZ0oFv0g-Lo.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Graduate": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Graduate\'",
						"\'Graduate-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/graduate/v5/q8OxxNQkE5ER9A55c9FE4_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Gxmjv69P0Q5Ma1YONre6VvesZW2xOQ-xsNqO47m55DA&skey=cdf54e0ba4eafcd1&v=v5#Graduate",
						"ttf": "http://fonts.gstatic.com/s/graduate/v5/ltWK80Pi-ig0sR5X-RaI7vesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/graduate/v5/3igPYHysOQSqw-Nqzu4SMvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/graduate/v5/xBquLOzic3rRbJsTs3BiEPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Grand Hotel": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Grand Hotel\'",
						"\'GrandHotel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/grandhotel/v5/NrGQkrs9rbHm5EYx0Eil0mfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NrGQkrs9rbHm5EYx0Eil0nNsigHlcrQGNV8nkUSFQfc&skey=3d5373e9fc70eefe&v=v5#GrandHotel",
						"ttf": "http://fonts.gstatic.com/s/grandhotel/v5/NrGQkrs9rbHm5EYx0Eil0p0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/grandhotel/v5/NrGQkrs9rbHm5EYx0Eil0obN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/grandhotel/v5/NrGQkrs9rbHm5EYx0Eil0o4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Gravitas One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gravitas One\'",
						"\'GravitasOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gravitasone/v7/nBHdBv6zVNU8MtP6w9FwTXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nBHdBv6zVNU8MtP6w9FwTVlIn5tFQcqMuf-jhyJP0ps&skey=64e506eb4eda273f&v=v7#GravitasOne",
						"ttf": "http://fonts.gstatic.com/s/gravitasone/v7/nBHdBv6zVNU8MtP6w9FwTYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/gravitasone/v7/nBHdBv6zVNU8MtP6w9FwTXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/gravitasone/v7/nBHdBv6zVNU8MtP6w9FwTegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Great Vibes": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Great Vibes\'",
						"\'GreatVibes-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/greatvibes/v5/6q1c0ofG6NKsEhAc2eh-3WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6q1c0ofG6NKsEhAc2eh-3XNsigHlcrQGNV8nkUSFQfc&skey=1a66edef5eadc723&v=v5#GreatVibes",
						"ttf": "http://fonts.gstatic.com/s/greatvibes/v5/6q1c0ofG6NKsEhAc2eh-3Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/greatvibes/v5/6q1c0ofG6NKsEhAc2eh-3YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/greatvibes/v5/6q1c0ofG6NKsEhAc2eh-3Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Griffy": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Griffy\'",
						"\'Griffy-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/griffy/v5/7jS6ZxXcvqCSUnKxxhpMSw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8UJnjmUmPg2N_cDnriTJzA&skey=8bca262f73db85e4&v=v5#Griffy",
						"ttf": "http://fonts.gstatic.com/s/griffy/v5/WCXiaDAoYfh97N6VMIZqyA.ttf",
						"woff": "http://fonts.gstatic.com/s/griffy/v5/f4FUXlL5FPqftKJ2T0mqXg.woff",
						"woff2": "http://fonts.gstatic.com/s/griffy/v5/SLKKBOr0CwxpHb7Tsjel8A.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Gruppo": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gruppo\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gruppo/v8/FUSz2lYOZ1vMxvu1xRl__g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0aOM2_vFQFmoA5k1x_7yow&skey=d88a2af79ed438fb&v=v8#Gruppo",
						"ttf": "http://fonts.gstatic.com/s/gruppo/v8/uU5IFiQZ8WKPhrRfLBLURw.ttf",
						"woff": "http://fonts.gstatic.com/s/gruppo/v8/e0FiPF1Eqfiz4B_8q5X76g.woff",
						"woff2": "http://fonts.gstatic.com/s/gruppo/v8/EoL765IZSvUoJyAsw4h7ow.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Gudea": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Gudea Italic\'",
						"\'Gudea-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gudea/v5/Z_lb9gBqiC1MSM7251z7_Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SY76NhUME8gD3bQNrp2bwQ&skey=dba7fb2bf51a5d81&v=v5#Gudea",
						"ttf": "http://fonts.gstatic.com/s/gudea/v5/YETrVqJHJHw2eRWYIh0BAg.ttf",
						"woff": "http://fonts.gstatic.com/s/gudea/v5/7K8okIOV072GIwnptze9lg.woff",
						"woff2": "http://fonts.gstatic.com/s/gudea/v5/kvCX_I6neb4EN5z031M87g.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Gudea\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gudea/v5/xnIrmcqnMQ-7ZqWOJs7CoA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qOix1NOFJQySqUkTkymDMg&skey=cabc1f7b4ae0fcd9&v=v5#Gudea",
						"ttf": "http://fonts.gstatic.com/s/gudea/v5/TJBgbd7QSbnZkQrnM77kmw.ttf",
						"woff": "http://fonts.gstatic.com/s/gudea/v5/Z6xYy_2MlN1cUISkeodEPA.woff",
						"woff2": "http://fonts.gstatic.com/s/gudea/v5/WTDyO8MdshuMhAnoLO0WMw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Gudea Bold\'",
						"\'Gudea-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gudea/v5/WHDzltq9N_SYEyWp7wyx7_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QZo8OTMUCp-n8Nr5KRDJUPesZW2xOQ-xsNqO47m55DA&skey=61f6a66f0762939&v=v5#Gudea",
						"ttf": "http://fonts.gstatic.com/s/gudea/v5/5_80veqYtMg_mX_C_gEF_PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/gudea/v5/6M2RKly85u67vSsXH0-zqvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/gudea/v5/jayXbUsof2FdMCHG3BRDEPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Gurajada": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Gurajada\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/gurajada/v5/s6ExxOexCpffkV34lOnKCfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HOKZKc3MJ-CX_uDmPymtP_esZW2xOQ-xsNqO47m55DA&skey=6cdaef1bf910cd15&v=v5#Gurajada",
						"ttf": "http://fonts.gstatic.com/s/gurajada/v5/RHqbBruUNmmNqMG_WzR9KfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/gurajada/v5/QD-RjywmI0f9ymMdvrP4IPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/gurajada/v5/d9B_fbWK8Ie4Ibg97m2m4fesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Habibi": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Habibi\'",
						"\'Habibi-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/habibi/v6/4JRg4uZ0l00FxEnORDOrpg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wD7Em3aciPHuUaj5SuKIzw&skey=5a046df8998f6a05&v=v6#Habibi",
						"ttf": "http://fonts.gstatic.com/s/habibi/v6/PIjQG9HFLS2LoHW_oRrGfg.ttf",
						"woff": "http://fonts.gstatic.com/s/habibi/v6/o2aOr30JmDicxkyiXzSY5w.woff",
						"woff2": "http://fonts.gstatic.com/s/habibi/v6/zOBf9KNrgksxGtN6tunzLA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Halant": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Halant Light\'",
						"\'Halant-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/halant/v4/Xu5LrOMBL0Zr10_6KDVgIPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Xu5LrOMBL0Zr10_6KDVgIJbd9NUM7myrQQz30yPaGQ4&skey=9ff3b9b305c6e001&v=v4#Halant",
						"ttf": "http://fonts.gstatic.com/s/halant/v4/Xu5LrOMBL0Zr10_6KDVgIKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/halant/v4/Xu5LrOMBL0Zr10_6KDVgID8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/halant/v4/Xu5LrOMBL0Zr10_6KDVgIFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Halant Regular\'",
						"\'Halant-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/halant/v4/lef5IdJBekl81Yhy__nvSg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=S0N6gIjgCNGaNrVadJaa3A&skey=1d23a673749ae7ff&v=v4#Halant",
						"ttf": "http://fonts.gstatic.com/s/halant/v4/REL4w4q-XuAvWqX0RAigww.ttf",
						"woff": "http://fonts.gstatic.com/s/halant/v4/P6pxk_n48aDtuDfBYiiC_w.woff",
						"woff2": "http://fonts.gstatic.com/s/halant/v4/L29psINGWRFKjBfnyh-nVw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Halant Medium\'",
						"\'Halant-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/halant/v4/lTgFaoG1PTDBTdlZRHrMq_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lTgFaoG1PTDBTdlZRHrMq5bd9NUM7myrQQz30yPaGQ4&skey=156a3c14db18c3e0&v=v4#Halant",
						"ttf": "http://fonts.gstatic.com/s/halant/v4/lTgFaoG1PTDBTdlZRHrMq6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/halant/v4/lTgFaoG1PTDBTdlZRHrMqz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/halant/v4/lTgFaoG1PTDBTdlZRHrMq1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Halant SemiBold\'",
						"\'Halant-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/halant/v4/1Bn2ieBRu5B49v4PrWNaifY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1Bn2ieBRu5B49v4PrWNaiZbd9NUM7myrQQz30yPaGQ4&skey=398f3452b33c6ab0&v=v4#Halant",
						"ttf": "http://fonts.gstatic.com/s/halant/v4/1Bn2ieBRu5B49v4PrWNaiaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/halant/v4/1Bn2ieBRu5B49v4PrWNaiT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/halant/v4/1Bn2ieBRu5B49v4PrWNaiVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Halant Bold\'",
						"\'Halant-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/halant/v4/x5gFr9GI9mLCAodAYf25Q_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=x5gFr9GI9mLCAodAYf25Q5bd9NUM7myrQQz30yPaGQ4&skey=c35b97d69a3e339d&v=v4#Halant",
						"ttf": "http://fonts.gstatic.com/s/halant/v4/x5gFr9GI9mLCAodAYf25Q6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/halant/v4/x5gFr9GI9mLCAodAYf25Qz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/halant/v4/x5gFr9GI9mLCAodAYf25Q1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Hammersmith One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Hammersmith One\'",
						"\'HammersmithOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hammersmithone/v8/FWNn6ITYqL6or7ZTmBxRhluTgT7He_T1DF6rp02aEO4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FWNn6ITYqL6or7ZTmBxRhuUK-EeIygXe5LAOHXDZOMs&skey=5f94f25a102337d5&v=v8#HammersmithOne",
						"ttf": "http://fonts.gstatic.com/s/hammersmithone/v8/FWNn6ITYqL6or7ZTmBxRhu921tOcMok2fHawGmtxikA.ttf",
						"woff": "http://fonts.gstatic.com/s/hammersmithone/v8/FWNn6ITYqL6or7ZTmBxRhq3fkYX5z1QtDUdIWoaaD_k.woff",
						"woff2": "http://fonts.gstatic.com/s/hammersmithone/v8/FWNn6ITYqL6or7ZTmBxRhiJccsb45t3MJKcv5BJtrIs.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Hanalei": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Hanalei\'",
						"\'Hanalei-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hanalei/v7/HQe9LGN3S4Xcve-XPhw70A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=o6Q8Zyjc1xLXbOkoXw_uaw&skey=24a8e4e26fbe4a1&v=v7#Hanalei",
						"ttf": "http://fonts.gstatic.com/s/hanalei/v7/P8Wofsp326v1socjZy6tSA.ttf",
						"woff": "http://fonts.gstatic.com/s/hanalei/v7/rTYF4iXEZUleQTEg0qtBHw.woff",
						"woff2": "http://fonts.gstatic.com/s/hanalei/v7/LP-nXHq8BZd13Zex3Vj2GQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Hanalei Fill": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Hanalei Fill\'",
						"\'HanaleiFill-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hanaleifill/v6/5uPeWLnaDdtm4UBG26Ds6HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5uPeWLnaDdtm4UBG26Ds6FlIn5tFQcqMuf-jhyJP0ps&skey=acc33bda7cb3835&v=v6#HanaleiFill",
						"ttf": "http://fonts.gstatic.com/s/hanaleifill/v6/5uPeWLnaDdtm4UBG26Ds6InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/hanaleifill/v6/5uPeWLnaDdtm4UBG26Ds6HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/hanaleifill/v6/5uPeWLnaDdtm4UBG26Ds6Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Handlee": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Handlee Regular\'",
						"\'Handlee-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/handlee/v6/SiKsZysys1kmeOHeev7VZA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=khiFs5x8Wr2Gsm1YBdVS9g&skey=38994f38d36fa1cb&v=v6#Handlee",
						"ttf": "http://fonts.gstatic.com/s/handlee/v6/cNycqCSU8dNAVKEAWPvbqw.ttf",
						"woff": "http://fonts.gstatic.com/s/handlee/v6/6AfIXNH5pZ1Jj_pfExPOWQ.woff",
						"woff2": "http://fonts.gstatic.com/s/handlee/v6/hN5OFJA7DLALxZ1osZb59Q.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Hanuman": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Hanuman Regular\'",
						"\'Hanuman-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hanuman/v11/UyICQNnhSNmPnEbH57sf1Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1Wo8PPbq_VQmFVasyUAeYg&skey=2fa0dfada2f365&v=v11#Hanuman",
						"ttf": "http://fonts.gstatic.com/s/hanuman/v11/hRhwOGGmElJSl6KSPvEnOQ.ttf",
						"woff": "http://fonts.gstatic.com/s/hanuman/v11/YE3SaZyNHZda4wWQ3s_XcQ.woff",
						"woff2": "http://fonts.gstatic.com/s/hanuman/v11/-onbhHy8dhpgqoJKxpu0Y_Y6323mHUZFJMgTvxaG2iE.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hanuman Bold\'",
						"\'Hanuman-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hanuman/v11/CWwr90lpltVE5TgmOIP1fPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ubWjugFMJIWoSbtCfKNqZvesZW2xOQ-xsNqO47m55DA&skey=afb56254639a08e4&v=v11#Hanuman",
						"ttf": "http://fonts.gstatic.com/s/hanuman/v11/lzzXZ2l84x88giDrbfq76vesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/hanuman/v11/CCgm7mfnrcjtbW-3hdGtF_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/hanuman/v11/gZe86KV7Z6ZD7e6v8AGDICEAvth_LlrfE80CYdSH47w.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Happy Monkey": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Happy Monkey\'",
						"\'HappyMonkey-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/happymonkey/v6/c2o0ps8nkBmaOYctqBq1rXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=c2o0ps8nkBmaOYctqBq1rVlIn5tFQcqMuf-jhyJP0ps&skey=17aeed53e5d1fc82&v=v6#HappyMonkey",
						"ttf": "http://fonts.gstatic.com/s/happymonkey/v6/c2o0ps8nkBmaOYctqBq1rYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/happymonkey/v6/c2o0ps8nkBmaOYctqBq1rXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/happymonkey/v6/c2o0ps8nkBmaOYctqBq1regdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Harmattan": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Harmattan\'",
						"\'Harmattan-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/harmattan/v2/Ssr8ACs4q9xAhZDBBV14x_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ssr8ACs4q9xAhZDBBV14x5bd9NUM7myrQQz30yPaGQ4&skey=455aa37d69b7e881&v=v2#Harmattan",
						"ttf": "http://fonts.gstatic.com/s/harmattan/v2/Ssr8ACs4q9xAhZDBBV14x6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/harmattan/v2/Ssr8ACs4q9xAhZDBBV14xz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/harmattan/v2/Ssr8ACs4q9xAhZDBBV14x1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Headland One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Headland One\'",
						"\'HeadlandOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/headlandone/v5/iGmBeOvQGfq9DSbjJ8jDV3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iGmBeOvQGfq9DSbjJ8jDV1lIn5tFQcqMuf-jhyJP0ps&skey=8cb712da05e7381c&v=v5#HeadlandOne",
						"ttf": "http://fonts.gstatic.com/s/headlandone/v5/iGmBeOvQGfq9DSbjJ8jDV4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/headlandone/v5/iGmBeOvQGfq9DSbjJ8jDV3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/headlandone/v5/iGmBeOvQGfq9DSbjJ8jDV-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Heebo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"hebrew",
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Heebo Thin\'",
						"\'Heebo-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/em3RtACvL8Jp9InRrzKr1w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uWniHz9Itj7e0w9zsCHn2g&skey=2a3337a4eff65963&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/YsxuafYigrasCnL-IH2hTA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/8uGTBl8ZXx9oKwZU2WFTeg.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/XBx2YeCNY_T16SzDasyK2w.woff2"
					}
				},
				"300": {
					"local": [
						"\'Heebo Light\'",
						"\'Heebo-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/PLk4GTv4pu4-OKmK8Cadc_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8ARX9C6yLkKuVjZ1XMByhPesZW2xOQ-xsNqO47m55DA&skey=a9ec82a05cdd6331&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/2UwOQifNF2KTsNzpMcqPivesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/-hV7AwOZ4t2MiSpqgC-XnfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/PBgOuZgb7GIoq5WdJf9cYPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Heebo\'",
						"\'Heebo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/Vn-4CFxHXnukVg8Rn9quGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RY6F0MRYa-nerEEGoiRGfg&skey=878db4aed11f133b&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/sBFeYxLt34ef9YmEVh8bCA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/nG4_PcIBvo3dTbWpBEGNCQ.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/Q66imbW5v9YuQMRLd0RXOA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Heebo Medium\'",
						"\'Heebo-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/wL9BAFSfeuq_fJzVKKZhrfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lenq86gWvBW7u8fiCzjmoPesZW2xOQ-xsNqO47m55DA&skey=2730111f06045c3b&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/bIsWmLhvGEL_3EujPeviHvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/WJ6acq-h6CBJ8p9EfJWNGPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/vd_gpifGyUkVAMtANh8LkvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Heebo Bold\'",
						"\'Heebo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/01FfwlqdYnRiKsu8rgxGQ_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lcVHvlFIHlQsRo6nnOjt4_esZW2xOQ-xsNqO47m55DA&skey=7f010c5479b9601f&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/yuNAD0UsWaXMWTsfpMyzB_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/vTMFaUgCCf1lTAPb2BL5W_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/ci1Z5c9lWkHY3RNZSMtWUfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Heebo ExtraBold\'",
						"\'Heebo-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/3B7MEjFGyLMv_dRfH68-1PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eg_Pr68H6jv_5MWzLuEv2_esZW2xOQ-xsNqO47m55DA&skey=576fa1b780f4a518&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/ylH4LredqKH3Br6NOvVb4_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/Hn4wT1W-_5nhBjwNHTw2O_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/QseUf-R9zN9lBDeGzxuOw_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Heebo Black\'",
						"\'Heebo-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/heebo/v3/QDQn9YAsonKargm9Ph9_wfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=aBvCq5sJ3Kb4JArD6GpzFvesZW2xOQ-xsNqO47m55DA&skey=a6398762cd0cf1cf&v=v3#Heebo",
						"ttf": "http://fonts.gstatic.com/s/heebo/v3/nuSRsBJVDr7Xwn5TXsSn4vesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/heebo/v3/68I0BQEi72oESKtZsJcjzvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/heebo/v3/Wo3XWRqb0fVWSLeYvWdkjPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Henny Penny": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Henny Penny\'",
						"\'HennyPenny-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hennypenny/v5/5KmZ_gfx8tPgQLMk4S-PvmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5KmZ_gfx8tPgQLMk4S-PvnNsigHlcrQGNV8nkUSFQfc&skey=337b39e4b7ae6f1&v=v5#HennyPenny",
						"ttf": "http://fonts.gstatic.com/s/hennypenny/v5/5KmZ_gfx8tPgQLMk4S-Pvp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/hennypenny/v5/5KmZ_gfx8tPgQLMk4S-PvobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/hennypenny/v5/5KmZ_gfx8tPgQLMk4S-Pvo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Herr Von Muellerhoff": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Herr Von Muellerhoff Regular\'",
						"\'HerrVonMuellerhoff-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/herrvonmuellerhoff/v7/mmy24EUmk4tjm4gAEjUd7KAYko7CGPKDMkr7YxF4ckE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mmy24EUmk4tjm4gAEjUd7NkxZeOSpznAIwUij_pOtTc&skey=6136c26fe1786204&v=v7#HerrVonMuellerhoff",
						"ttf": "http://fonts.gstatic.com/s/herrvonmuellerhoff/v7/mmy24EUmk4tjm4gAEjUd7MCMrkQR43VXwglUYgY3f7Q.ttf",
						"woff": "http://fonts.gstatic.com/s/herrvonmuellerhoff/v7/mmy24EUmk4tjm4gAEjUd7LdqIO0vRN7OFh44Vbf9XGo.woff",
						"woff2": "http://fonts.gstatic.com/s/herrvonmuellerhoff/v7/mmy24EUmk4tjm4gAEjUd7HxL8FEHCDOLWH19wmK6Xew.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Hind": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Hind Light\'",
						"\'Hind-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hind/v8/0MChGzeidNoUW73HGw5PzQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HouvnnfhUAVKasrmjRdkuA&skey=67a5c17d8888694b&v=v8#Hind",
						"ttf": "http://fonts.gstatic.com/s/hind/v8/ovjfFuI0qshJ4pjW8a52hA.ttf",
						"woff": "http://fonts.gstatic.com/s/hind/v8/R5nyNcvoz7n0iBHxjY_LyQ.woff",
						"woff2": "http://fonts.gstatic.com/s/hind/v8/0IXD51eZ8qgi73bhvRidlQ.woff2"
					}
				},
				"400": {
					"local": [
						"\'Hind Regular\'",
						"\'Hind-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hind/v8/1LM4Wjs-6TF3Sw-KGDsIOw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=njVfKzL3Td4Udo0nhiHxLQ&skey=88b46a73a32439b3&v=v8#Hind",
						"ttf": "http://fonts.gstatic.com/s/hind/v8/nz5dxQAyXAGLFHmmJlZXFg.ttf",
						"woff": "http://fonts.gstatic.com/s/hind/v8/mjitrc9VnL7D7tS-i3g3XQ.woff",
						"woff2": "http://fonts.gstatic.com/s/hind/v8/xLdg5JI0N_C2fvyu9XVzXg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Hind Medium\'",
						"\'Hind-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hind/v8/pCDvW-M5L0XFt22GiXzWxw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=InRlHT6zPtn7ZobD1yN-Vw&skey=240cc253f5a86f17&v=v8#Hind",
						"ttf": "http://fonts.gstatic.com/s/hind/v8/GSrOz960_Sk2fwhd1d3CUw.ttf",
						"woff": "http://fonts.gstatic.com/s/hind/v8/yATwQM0pIZXIFPrEDZyOHg.woff",
						"woff2": "http://fonts.gstatic.com/s/hind/v8/_JiDQLq4JWzs7prWhNNmuA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Hind SemiBold\'",
						"\'Hind-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hind/v8/Uy23CXeLYj5ORbaUwp4G2Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JkBbsKNRJCsICkxgZDWHUQ&skey=da2b34d6f21b4cf5&v=v8#Hind",
						"ttf": "http://fonts.gstatic.com/s/hind/v8/A-DXAAbcCXVlYOVdE3bANQ.ttf",
						"woff": "http://fonts.gstatic.com/s/hind/v8/2dBELi3ZbivnVPt1KR2lhQ.woff",
						"woff2": "http://fonts.gstatic.com/s/hind/v8/A2xpLU2z2kq5byuh5bkohg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hind Bold\'",
						"\'Hind-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hind/v8/8cnITayai1nO3K593GnDYg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vyLJJxdNNiiSPw8GXvW0Sw&skey=9c157a14144029ee&v=v8#Hind",
						"ttf": "http://fonts.gstatic.com/s/hind/v8/akA3ImRNyYfKy4MBs09Paw.ttf",
						"woff": "http://fonts.gstatic.com/s/hind/v8/lyIZFqDTaXXyAxN6-svvJg.woff",
						"woff2": "http://fonts.gstatic.com/s/hind/v8/PQuIEfcr_wdF_zOSNjqWKQ.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Hind Guntur": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Hind Guntur Light\'",
						"\'HindGuntur-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNArXcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Szg33M7ab5MTWe-PWAcNAj4dnM32POWavC8T_whbZeI&skey=39532f1fae07e152&v=v3#HindGuntur",
						"ttf": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNArfB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAh_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAko2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Hind Guntur Regular\'",
						"\'HindGuntur-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindguntur/v3/hgezDJFxKiIzlzQUXNjfNGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hgezDJFxKiIzlzQUXNjfNHNsigHlcrQGNV8nkUSFQfc&skey=7eb443da3396aeab&v=v3#HindGuntur",
						"ttf": "http://fonts.gstatic.com/s/hindguntur/v3/hgezDJFxKiIzlzQUXNjfNJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/hindguntur/v3/hgezDJFxKiIzlzQUXNjfNIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/hindguntur/v3/hgezDJFxKiIzlzQUXNjfNI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Hind Guntur Medium\'",
						"\'HindGuntur-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAiGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Szg33M7ab5MTWe-PWAcNAq057wUl25f8_0IloMUHk98&skey=822998f36eafe74f&v=v3#HindGuntur",
						"ttf": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAvMi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAiqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNArBojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Hind Guntur SemiBold\'",
						"\'HindGuntur-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAo8mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Szg33M7ab5MTWe-PWAcNAuVmfClkf66xvxL1SWm4y8M&skey=6449b70ef09387bd&v=v3#HindGuntur",
						"ttf": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAi8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAn5HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAl2umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hind Guntur Bold\'",
						"\'HindGuntur-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNArFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Szg33M7ab5MTWe-PWAcNAntNmQEE9wZ6UZlmiISB1pg&skey=9b8e1c0fe44ad182&v=v3#HindGuntur",
						"ttf": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAp_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAjqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/hindguntur/v3/Szg33M7ab5MTWe-PWAcNAolIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Hind Madurai": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"tamil",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Hind Madurai Light\'",
						"\'HindMadurai-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S64ySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sdSJTZLdRXJhVTP92m2S67Jg1hA63dzswhy4NvEPrPM&skey=e10e27078fbda7fa&v=v3#HindMadurai",
						"ttf": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6wV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S62Fp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S604GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Hind Madurai Regular\'",
						"\'HindMadurai-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindmadurai/v3/pJpl47LatORZNWf8rgdiyXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pJpl47LatORZNWf8rgdiyVlIn5tFQcqMuf-jhyJP0ps&skey=2f195a7cb0b99eb0&v=v3#HindMadurai",
						"ttf": "http://fonts.gstatic.com/s/hindmadurai/v3/pJpl47LatORZNWf8rgdiyYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/hindmadurai/v3/pJpl47LatORZNWf8rgdiyXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/hindmadurai/v3/pJpl47LatORZNWf8rgdiyegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Hind Madurai Medium\'",
						"\'HindMadurai-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6zHhXAPWOXQc-mHRKx4oalk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sdSJTZLdRXJhVTP92m2S65XlX4y0PMY0_OO7hHc9JEY&skey=56afda129ae517c5&v=v3#HindMadurai",
						"ttf": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6yfxicYksyVqdB8nkjIZw2U.ttf",
						"woff": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6xF47VQSRrvbVYTKIrepY7I.woff",
						"woff2": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S681Lch-SD8r0CsJ60meulZ8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Hind Madurai SemiBold\'",
						"\'HindMadurai-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6zBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sdSJTZLdRXJhVTP92m2S6wmE8htD-SDrf7umQTfloJ8&skey=9556beb0868db4be&v=v3#HindMadurai",
						"ttf": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S61FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S69Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hind Madurai Bold\'",
						"\'HindMadurai-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S62msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sdSJTZLdRXJhVTP92m2S6way50PuN8loMJ9QAXsTs7U&skey=d7fd4659050e217c&v=v3#HindMadurai",
						"ttf": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S6306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S63l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/hindmadurai/v3/sdSJTZLdRXJhVTP92m2S63NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Hind Siliguri": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin",
			"bengali"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Hind Siliguri Light\'",
						"\'HindSiliguri-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn37FnRhObSQVCVUoSGiza-A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fBpmjMpv5Rh6S25yVfWJn1TseKZqar24O-knw2J63k4&skey=285dedcdf7848409&v=v4#HindSiliguri",
						"ttf": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn5ciFM2dQqR1ip9I-Bp8E7Q.ttf",
						"woff": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn6TRWX0g_-XoZCgdgBAVi88.woff",
						"woff2": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn6SQyxDdyh5J6kYir5a9n-w.woff2"
					}
				},
				"400": {
					"local": [
						"\'Hind Siliguri Regular\'",
						"\'HindSiliguri-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindsiliguri/v4/f2eEi2pbIa8eBfNwpUl0AhjDPkejxwcpW9OWpajGJHw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=f2eEi2pbIa8eBfNwpUl0AoQpKbf4CYfIi0uw1R3YMwI&skey=5aed9b95d255b37c&v=v4#HindSiliguri",
						"ttf": "http://fonts.gstatic.com/s/hindsiliguri/v4/f2eEi2pbIa8eBfNwpUl0AkPlcwLEEFMaFVaeSfNKhMM.ttf",
						"woff": "http://fonts.gstatic.com/s/hindsiliguri/v4/f2eEi2pbIa8eBfNwpUl0Aj4XNJenyR3sjrxR52gViYU.woff",
						"woff2": "http://fonts.gstatic.com/s/hindsiliguri/v4/f2eEi2pbIa8eBfNwpUl0AhBCek7ZypUE9OFPg18vTTM.woff2"
					}
				},
				"500": {
					"local": [
						"\'Hind Siliguri Medium\'",
						"\'HindSiliguri-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn-Zlad--gq09YzS-6t5G4AM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fBpmjMpv5Rh6S25yVfWJn07BHkil331PUTa7WSnH9HM&skey=ce4ad4f45fe03f15&v=v4#HindSiliguri",
						"ttf": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJnwpRBgtkoBXOZ68qjHPpU4g.ttf",
						"woff": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn72P_Uux-iHs2EwONVF7tE0.woff",
						"woff2": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJnzeO7UKWTXK_MKhPYQqFnq0.woff2"
					}
				},
				"600": {
					"local": [
						"\'Hind Siliguri SemiBold\'",
						"\'HindSiliguri-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJnz8-ABZsNeUzipO0sogVoxw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fBpmjMpv5Rh6S25yVfWJnzfoV9mdY6tU1z6d7HVni9w&skey=66f00c40586bb1f9&v=v4#HindSiliguri",
						"ttf": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn3itLvUAwFWb83bwOsAdQ6M.ttf",
						"woff": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJnyZU2skVWYyUQFLTY3qwAVE.woff",
						"woff2": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJnzJsR1j-Smzxy52UCYO8Tv4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hind Siliguri Bold\'",
						"\'HindSiliguri-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn3kG2xuzrZX6jefzCp6lpMs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fBpmjMpv5Rh6S25yVfWJn2We_ISb6-g34WzcfIFiYzc&skey=abb4efea7259d7b0&v=v4#HindSiliguri",
						"ttf": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn7A7MWNoqbMutNN7VW-98RM.ttf",
						"woff": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn8ToxEMdItuzMyiS1f6iduE.woff",
						"woff2": "http://fonts.gstatic.com/s/hindsiliguri/v4/fBpmjMpv5Rh6S25yVfWJn1a9Mi0HhaXJ2SLZ7weUeE8.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Hind Vadodara": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"gujarati",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Hind Vadodara Light\'",
						"\'HindVadodara-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTVs2x0LlO3r4hK64bhDTrDQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KrZ6f_YevRawHvh0qDBkTS6ZvRg9MN0LYsMFjm649E8&skey=fceee913b7efab1c&v=v4#HindVadodara",
						"ttf": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTf6bxG2LUlowN7CAjjoY1oM.ttf",
						"woff": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTY3hH1d5pFsscUjcrX7M1jU.woff",
						"woff2": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTTNTwKlZaTDqBdSBniKmKtQ.woff2"
					}
				},
				"400": {
					"local": [
						"\'Hind Vadodara Regular\'",
						"\'HindVadodara-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindvadodara/v4/9c6KKeibr6NtFqknnNxZBxaMMUiNNY1IQbIV7e8ODnc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9c6KKeibr6NtFqknnNxZB2MPOzKCRqgB4bBx3b-1aoc&skey=7e52df96d00ee4&v=v4#HindVadodara",
						"ttf": "http://fonts.gstatic.com/s/hindvadodara/v4/9c6KKeibr6NtFqknnNxZB2bSELdkQ3Les1sVIQZgz9g.ttf",
						"woff": "http://fonts.gstatic.com/s/hindvadodara/v4/9c6KKeibr6NtFqknnNxZB6yztDLpUjNAkGAPlCwy4fk.woff",
						"woff2": "http://fonts.gstatic.com/s/hindvadodara/v4/9c6KKeibr6NtFqknnNxZB8I79x-VWsl9ZLFyGx7L0Fo.woff2"
					}
				},
				"500": {
					"local": [
						"\'Hind Vadodara Medium\'",
						"\'HindVadodara-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTRKoOUGuqLTn511TCD3EyX8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KrZ6f_YevRawHvh0qDBkTT7qgLuIqWDo4qTSl3YE85Q&skey=9afaf6cb9e368750&v=v4#HindVadodara",
						"ttf": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTQR-JG7r4QuNi_X1YlF4dk0.ttf",
						"woff": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTa824QdG9m0Eh7X_PPWs6-o.woff",
						"woff2": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTeQ59q_mNX23NRW2koua-bw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Hind Vadodara SemiBold\'",
						"\'HindVadodara-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTWHyySO4bfj3rF-okQ3oTqM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KrZ6f_YevRawHvh0qDBkTSFc4nWGX8hzAvIn_S4djBo&skey=902906c536b6d48b&v=v4#HindVadodara",
						"ttf": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTX9sW1RTDiOfQCekscxdRWU.ttf",
						"woff": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTVWzcmO8C-p0p_pihYkMhl4.woff",
						"woff2": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTWSHKJ1opCet6Rx30umU_Lk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Hind Vadodara Bold\'",
						"\'HindVadodara-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTecP85s_J5qYVYxxRW2NSUg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KrZ6f_YevRawHvh0qDBkTd01epMBIXL49hXWSTNTzm0&skey=933f5f6b4298e22c&v=v4#HindVadodara",
						"ttf": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTbqFMHQ1TJtJn1ocYRmKMFU.ttf",
						"woff": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTXrGxGypa6lWyCOdlu1btY0.woff",
						"woff2": "http://fonts.gstatic.com/s/hindvadodara/v4/KrZ6f_YevRawHvh0qDBkTT_eokH_3GQxqJwQLllXLTM.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Holtwood One SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Holtwood One SC\'",
						"\'HoltwoodOneSC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/holtwoodonesc/v8/sToOq3cIxbfnhbEkgYNuBV0bIxRdnSwIBayFzay3TZY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sToOq3cIxbfnhbEkgYNuBUEpCl_LTlbNmxwaPMVsAp0&skey=a792affb0acbc8db&v=v8#HoltwoodOneSC",
						"ttf": "http://fonts.gstatic.com/s/holtwoodonesc/v8/sToOq3cIxbfnhbEkgYNuBbFxFljtrsr2f1jsZCF5R04.ttf",
						"woff": "http://fonts.gstatic.com/s/holtwoodonesc/v8/sToOq3cIxbfnhbEkgYNuBfyANVbuiJM3Q3GKGSGeYMA.woff",
						"woff2": "http://fonts.gstatic.com/s/holtwoodonesc/v8/sToOq3cIxbfnhbEkgYNuBZi4I2Fwo6sqyzVodtQ85Ik.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Homemade Apple": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Homemade Apple Regular\'",
						"\'HomemadeApple-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/homemadeapple/v8/yg3UMEsefgZ8IHz_ryz86MARVQxeLHl8P-K3Tov154U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yg3UMEsefgZ8IHz_ryz86AOseY4jAx8ygiIo_6y5pCk&skey=d63826866de4a1b6&v=v8#HomemadeApple",
						"ttf": "http://fonts.gstatic.com/s/homemadeapple/v8/yg3UMEsefgZ8IHz_ryz86J9Wgegw1HyrDAZq28nXLYY.ttf",
						"woff": "http://fonts.gstatic.com/s/homemadeapple/v8/yg3UMEsefgZ8IHz_ryz86Kmk7U3V72hKgu0Yds_deA8.woff",
						"woff2": "http://fonts.gstatic.com/s/homemadeapple/v8/yg3UMEsefgZ8IHz_ryz86IpVThvdH1ZERIrfWb3R7t4.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Homenaje": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Homenaje Regular\'",
						"\'Homenaje-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/homenaje/v7/IdnATYWjXRgzjtRq6MvrGfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=L-eQkaKCZCMbWRYMT9fUzPesZW2xOQ-xsNqO47m55DA&skey=9b887fa224ab3cec&v=v7#Homenaje",
						"ttf": "http://fonts.gstatic.com/s/homenaje/v7/74rNkO0_718VQPTEmPNsIvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/homenaje/v7/jYyetuCOSxcVAexXms8sf_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/homenaje/v7/4S5MkF9F4U5BChzwjsyu0vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell DW Pica": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'IM FELL DW Pica Italic\'",
						"\'IM_FELL_DW_Pica_Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldwpica/v7/alQJ8SK5aSOZVaelYoyT4GTe48BDWQ4b8lPNvD4Ht5k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=alQJ8SK5aSOZVaelYoyT4E8KPLrg_Wdgj8bNdfOPrAw&skey=c4934a67e6f2a36b&v=v7#IMFellDWPica",
						"ttf": "http://fonts.gstatic.com/s/imfelldwpica/v7/alQJ8SK5aSOZVaelYoyT4L_iYmMszVmcR7hUdnaGh8I.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldwpica/v7/alQJ8SK5aSOZVaelYoyT4PQV9SD565Vh4CeEot-NU_g.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldwpica/v7/alQJ8SK5aSOZVaelYoyT4IS5YXW7F7YVj1YipatOEh8.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'IM FELL DW Pica Roman\'",
						"\'IM_FELL_DW_Pica_Roman\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldwpica/v7/W81bfaWiUicLSPbJhW-ATvzSy9b6OTAbtDOSPp_LoBA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=W81bfaWiUicLSPbJhW-ATqyv4CGGZwkhH9im_hVVLpM&skey=22ed7eafcced41ff&v=v7#IMFellDWPica",
						"ttf": "http://fonts.gstatic.com/s/imfelldwpica/v7/W81bfaWiUicLSPbJhW-AToJ9FRurQkHWDDTe2Dq6d_c.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldwpica/v7/W81bfaWiUicLSPbJhW-ATno1aYbFHkK-jWDrR3dOoIA.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldwpica/v7/W81bfaWiUicLSPbJhW-ATkUjQBM6Jl3k7SYs5pBZT1I.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell DW Pica SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'IM FELL DW Pica SC\'",
						"\'IM_FELL_DW_Pica_SC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldwpicasc/v7/xBKKJV4z2KsrtQnmjGO17JJr2ursheLy75drwh42QOk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xBKKJV4z2KsrtQnmjGO17LYUxfvJ1ywjf087Oylz8nM&skey=2798f34675f18639&v=v7#IMFellDWPicaSC",
						"ttf": "http://fonts.gstatic.com/s/imfelldwpicasc/v7/xBKKJV4z2KsrtQnmjGO17LeUO9IxxQYQQ1zfC494I8M.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldwpicasc/v7/xBKKJV4z2KsrtQnmjGO17ORrWueMUZPacwWUa4j7Ahg.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldwpicasc/v7/xBKKJV4z2KsrtQnmjGO17GJzbBxSUd-DQo7G7b3PSsQ.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell Double Pica": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'IM FELL Double Pica Italic\'",
						"\'IM_FELL_Double_Pica_Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldoublepica/v7/64odUh2hAw8D9dkFKTlWYv-Y5FKdJEBDzUAlv1E6JUY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=64odUh2hAw8D9dkFKTlWYtTgeZ5FLLzmAOlzr8xdfuw&skey=9e6796700040035c&v=v7#IMFellDoublePica",
						"ttf": "http://fonts.gstatic.com/s/imfelldoublepica/v7/64odUh2hAw8D9dkFKTlWYrFrn-MbtLE0OZKVtdhT56o.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldoublepica/v7/64odUh2hAw8D9dkFKTlWYjEKhKehgnLOh1lSiVdD78o.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldoublepica/v7/64odUh2hAw8D9dkFKTlWYoZew9IscTY2f2gOWZH7Ft0.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'IM FELL Double Pica Roman \'",
						"\'IM_FELL_Double_Pica_Roman\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldoublepica/v7/yN1wY_01BkQnO0LYAhXdUmXq7UDmeGAfNlws3VwYFrE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yN1wY_01BkQnO0LYAhXdUqHVCLE0KWTf37ZdayGKujs&skey=2b2356c40435355e&v=v7#IMFellDoublePica",
						"ttf": "http://fonts.gstatic.com/s/imfelldoublepica/v7/yN1wY_01BkQnO0LYAhXdUhA2jF5cpFQC0-e9l2_bLak.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldoublepica/v7/yN1wY_01BkQnO0LYAhXdUvyawXrEOuSoZ3hjwDkRdc8.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldoublepica/v7/yN1wY_01BkQnO0LYAhXdUpPVtvXJHLEDVFcdPHS8c5s.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell Double Pica SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'IM FELL Double Pica SC\'",
						"\'IM_FELL_Double_Pica_SC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfelldoublepicasc/v7/jkrUtrLFpMw4ZazhfkKsG8KFI-xWFjMHQzSKPrXbp5Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jkrUtrLFpMw4ZazhfkKsG6mVW3Gs7P5dCI8tMQZUzSQ&skey=bfe6616aa60db6b9&v=v7#IMFellDoublePicaSC",
						"ttf": "http://fonts.gstatic.com/s/imfelldoublepicasc/v7/jkrUtrLFpMw4ZazhfkKsG90vIvIF8L_BWCF3ZHhpTbk.ttf",
						"woff": "http://fonts.gstatic.com/s/imfelldoublepicasc/v7/jkrUtrLFpMw4ZazhfkKsG5wUTFrHmtqydIC8O5vVrTo.woff",
						"woff2": "http://fonts.gstatic.com/s/imfelldoublepicasc/v7/jkrUtrLFpMw4ZazhfkKsG-Z4Ah3U_oX5ylex9uXi26s.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell English": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'IM FELL English Italic\'",
						"\'IM_FELL_English_Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellenglish/v7/Z3cnIAI_L3XTRfz4JuZKbuhAx3KKj4FNbQmSL-0gzbg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z3cnIAI_L3XTRfz4JuZKbseRa9xPMSfTDs2LPCKvkpU&skey=ab4ad6d91b1d279a&v=v7#IMFellEnglish",
						"ttf": "http://fonts.gstatic.com/s/imfellenglish/v7/Z3cnIAI_L3XTRfz4JuZKbh6gonR1dbHzi1tY1B_-m1g.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellenglish/v7/Z3cnIAI_L3XTRfz4JuZKblpL75J7D6p_Wd7CWKLWFR0.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellenglish/v7/Z3cnIAI_L3XTRfz4JuZKbmwF2xAZ8zQZAh2gFEDZc7E.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'IM FELL English Roman\'",
						"\'IM_FELL_English_Roman\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellenglish/v7/xwIisCqGFi8pff-oa9uSVMWU0wPBDo3yC94zuYASqF4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xwIisCqGFi8pff-oa9uSVGGTFsUG5QsPiyRD-Yung7c&skey=afb75104e969187e&v=v7#IMFellEnglish",
						"ttf": "http://fonts.gstatic.com/s/imfellenglish/v7/xwIisCqGFi8pff-oa9uSVEGbiRUdT7ySew84y3CmKhM.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellenglish/v7/xwIisCqGFi8pff-oa9uSVMyhYfqH3mbn79-t0w0Xep4.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellenglish/v7/xwIisCqGFi8pff-oa9uSVAkYLEKE0CJQa8tfZYc_plY.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell English SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'IM FELL English SC\'",
						"\'IM_FELL_English_SC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellenglishsc/v7/h3Tn6yWfw4b5qaLD1RWvz1SOO0milnKqjr2136-xNDk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=h3Tn6yWfw4b5qaLD1RWvzyzd5uYN1HyQ6XK1g5bKvjA&skey=44cc57b48745e8ce&v=v7#IMFellEnglishSC",
						"ttf": "http://fonts.gstatic.com/s/imfellenglishsc/v7/h3Tn6yWfw4b5qaLD1RWvz9gX5f6-V0DImePmAcKHNfQ.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellenglishsc/v7/h3Tn6yWfw4b5qaLD1RWvz2YU_NAY3j90c9z94KlCU1M.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellenglishsc/v7/h3Tn6yWfw4b5qaLD1RWvz4x48W_1RDVIUojTbGX9Iuk.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell French Canon": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'IM FELL French Canon Italic\'",
						"\'IM_FELL_French_Canon_Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/owCuNQkLLFW7TBBPJbMnhSMUnaGKFilA--QMIwEHaWA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=owCuNQkLLFW7TBBPJbMnhXYmZQ385KTlx1k4MG0QqSo&skey=2a36a76ac685a10c&v=v7#IMFellFrenchCanon",
						"ttf": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/owCuNQkLLFW7TBBPJbMnhdKJYa1hyZsLz5lQ3rWz1aM.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/owCuNQkLLFW7TBBPJbMnhYt8sjKkzfuoD5ea_dlAUSQ.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/owCuNQkLLFW7TBBPJbMnhRZap5XCWJPp-I1JveJ-kLM.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'IM FELL French Canon Roman\'",
						"\'IM_FELL_French_Canon_Roman\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/iKB0WL1BagSpNPz3NLMdsHTXjjiVm2FXOMlrUCTejMM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iKB0WL1BagSpNPz3NLMdsLB_q8BtC4qcDWwryDhdXsY&skey=e84a686a36c32686&v=v7#IMFellFrenchCanon",
						"ttf": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/iKB0WL1BagSpNPz3NLMdsKiovWQmSXO7IT6rGBIdh9c.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/iKB0WL1BagSpNPz3NLMdsIv9fdI3y3eabv7dpXnXct0.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellfrenchcanon/v7/iKB0WL1BagSpNPz3NLMdsD7ZrzzLXYUmiRzHqUU8H80.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell French Canon SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'IM FELL French Canon SC\'",
						"\'IM_FELL_French_Canon_SC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellfrenchcanonsc/v7/kA3bS19-tQbeT_iG32EZmR5xj4AEO0JYl5bD7FUWV0c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kA3bS19-tQbeT_iG32EZme6jw4dvx3NBunegw27fCtg&skey=7645169d46c73af7&v=v7#IMFellFrenchCanonSC",
						"ttf": "http://fonts.gstatic.com/s/imfellfrenchcanonsc/v7/kA3bS19-tQbeT_iG32EZmV0ZFjejJzjeAUCIZDsyU_I.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellfrenchcanonsc/v7/kA3bS19-tQbeT_iG32EZmXOvcjuWQiQaZKj_YGxmsS8.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellfrenchcanonsc/v7/kA3bS19-tQbeT_iG32EZmQpWNGsYtRSRH8wBJyqNRkg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell Great Primer": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'IM FELL Great Primer Italic\'",
						"\'IM_FELL_Great_Primer_Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/1a-artkXMVg682r7TTxVY3hy3WEnf9aMaIFzysbY6iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1a-artkXMVg682r7TTxVYxa5K7vp_uwCgvEi4HQ1nAg&skey=3f9cf92ebbb0969b&v=v7#IMFellGreatPrimer",
						"ttf": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/1a-artkXMVg682r7TTxVY0kD5NDFBl9UY7HWnTDocLw.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/1a-artkXMVg682r7TTxVY8tboISpX1JaDPo-FEWxGn0.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/1a-artkXMVg682r7TTxVYyujdKQmw1z458xbg1FCoHI.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'IM FELL Great Primer Roman\'",
						"\'IM_FELL_Great_Primer_Roman\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/AL8ALGNthei20f9Cu3e93jO26wxdhOyEvQIRe_F5afs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AL8ALGNthei20f9Cu3e93pcm4arNJ4qhO4QuIi7DPRM&skey=906399d54c97c2e3&v=v7#IMFellGreatPrimer",
						"ttf": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/AL8ALGNthei20f9Cu3e93qZXHtZ0Z62-HtyJa8iUgDI.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/AL8ALGNthei20f9Cu3e93idd7_gwp8h5wh09JM2vKqs.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellgreatprimer/v7/AL8ALGNthei20f9Cu3e93lkxQeIsd7r3-yGilmZ2XlU.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"IM Fell Great Primer SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'IM FELL Great Primer SC\'",
						"\'IM_FELL_Great_Primer_SC\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imfellgreatprimersc/v7/A313vRj97hMMGFjt6rgSJpEJdq0lHZCa_AkNkn664X4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=A313vRj97hMMGFjt6rgSJpu0eESuSwP4BJlnarILG0A&skey=f7c6c7aed0978160&v=v7#IMFellGreatPrimerSC",
						"ttf": "http://fonts.gstatic.com/s/imfellgreatprimersc/v7/A313vRj97hMMGFjt6rgSJvWeZ2THBYj8Kkq4igLlJAI.ttf",
						"woff": "http://fonts.gstatic.com/s/imfellgreatprimersc/v7/A313vRj97hMMGFjt6rgSJgLbk6iVZLS-EhwS4yjOduQ.woff",
						"woff2": "http://fonts.gstatic.com/s/imfellgreatprimersc/v7/A313vRj97hMMGFjt6rgSJoSzkuUy0hmPpz77JilbHPA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Iceberg": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Iceberg\'",
						"\'Iceberg-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/iceberg/v5/n4CCsHAkYTQJpVcR9-XIXg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LmuNL4WHoIfmJS2EOXvCsQ&skey=2d1d29e185cf8c9f&v=v5#Iceberg",
						"ttf": "http://fonts.gstatic.com/s/iceberg/v5/_2udMY55UgG1CemDNNVasA.ttf",
						"woff": "http://fonts.gstatic.com/s/iceberg/v5/JBRQufCnbwmG3NEDsB4pyg.woff",
						"woff2": "http://fonts.gstatic.com/s/iceberg/v5/E4KdVKLAReJazSqpq1EAKg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Iceland": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Iceland\'",
						"\'Iceland-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/iceland/v6/bXn2pdRWjYiySaO4rweM1w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6RFaVINTbhiWDHkQgtQSYQ&skey=4b5c1e4c28ff6c1d&v=v6#Iceland",
						"ttf": "http://fonts.gstatic.com/s/iceland/v6/xpBG9REU4FIb5KOe0_j5Rw.ttf",
						"woff": "http://fonts.gstatic.com/s/iceland/v6/F6LYTZLHrG9BNYXRjU7RSw.woff",
						"woff2": "http://fonts.gstatic.com/s/iceland/v6/0t3IIKOg5Y3bymbv3QH8mA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Imprima": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Imprima\'",
						"\'Imprima-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/imprima/v5/s1UxvUynnNEuqrsbbLQhkQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=9BZZnfydqHefT-T0DXwEUA&skey=29732b71f07bec76&v=v5#Imprima",
						"ttf": "http://fonts.gstatic.com/s/imprima/v5/KRnv43hkJUp5pK0ZVHHvlw.ttf",
						"woff": "http://fonts.gstatic.com/s/imprima/v5/Lw4J4XiH21tNmX0DzARuSA.woff",
						"woff2": "http://fonts.gstatic.com/s/imprima/v5/tkNzYFRCxmx7lNs3nUuZfw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Inconsolata": {
		"category": "monospace",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Inconsolata Regular\'",
						"\'Inconsolata-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inconsolata/v16/BjAYBlHtW3CJxDcjzrnZCGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BjAYBlHtW3CJxDcjzrnZCHNsigHlcrQGNV8nkUSFQfc&skey=20fa6569a31c71ee&v=v16#Inconsolata",
						"ttf": "http://fonts.gstatic.com/s/inconsolata/v16/BjAYBlHtW3CJxDcjzrnZCJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/inconsolata/v16/BjAYBlHtW3CJxDcjzrnZCIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/inconsolata/v16/BjAYBlHtW3CJxDcjzrnZCI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Inconsolata Bold\'",
						"\'Inconsolata-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inconsolata/v16/AIed271kqQlcIRSOnQH0ybFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AIed271kqQlcIRSOnQH0yXtNmQEE9wZ6UZlmiISB1pg&skey=92483760c58cd80&v=v16#Inconsolata",
						"ttf": "http://fonts.gstatic.com/s/inconsolata/v16/AIed271kqQlcIRSOnQH0yZ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/inconsolata/v16/AIed271kqQlcIRSOnQH0yTqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/inconsolata/v16/AIed271kqQlcIRSOnQH0yYlIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			}
		},
		"version": "v16"
	},
	"Inder": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Inder\'",
						"\'Inder-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inder/v6/eh8fzUkz8PkNSRy0YJjgNQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WjWLJh8NRMPqdVqyvXueyg&skey=a9971eee5483ecfe&v=v6#Inder",
						"ttf": "http://fonts.gstatic.com/s/inder/v6/6mCONNZOTgHbH8ICSdD_KA.ttf",
						"woff": "http://fonts.gstatic.com/s/inder/v6/LN9QVFa7kDa1_2Kui_Befw.woff",
						"woff2": "http://fonts.gstatic.com/s/inder/v6/FHGTq7lMPAUUQDHSR8P-gg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Indie Flower": {
		"category": "handwriting",
		"lastModified": "2017-10-11",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Indie Flower\'",
						"\'IndieFlower\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/indieflower/v9/10JVD_humAd5zP2yrFqw6nZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=10JVD_humAd5zP2yrFqw6llIn5tFQcqMuf-jhyJP0ps&skey=cdda66716f19c532&v=v9#IndieFlower",
						"ttf": "http://fonts.gstatic.com/s/indieflower/v9/10JVD_humAd5zP2yrFqw6onF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/indieflower/v9/10JVD_humAd5zP2yrFqw6nhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/indieflower/v9/10JVD_humAd5zP2yrFqw6ugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Inika": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Inika\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inika/v5/1Q2V6YSe6pehGOK27SYW0A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8ngLsLltOfZnxKtJ_lY8eQ&skey=4a5fa8e3d9422bfa&v=v5#Inika",
						"ttf": "http://fonts.gstatic.com/s/inika/v5/w2xGXhyHYlnSkd1wv6gDnQ.ttf",
						"woff": "http://fonts.gstatic.com/s/inika/v5/BKu7l_qT90IBrcPZgEIfVQ.woff",
						"woff2": "http://fonts.gstatic.com/s/inika/v5/r3Z5gCAKW2R-pq9oz6gfZg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Inika Bold\'",
						"\'Inika-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inika/v5/49CA1W7DAwcTaNNT_0jpofesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=n99-8LMZyaX9D2Ub7_uFMPesZW2xOQ-xsNqO47m55DA&skey=cb57b1b3fdfec5ca&v=v5#Inika",
						"ttf": "http://fonts.gstatic.com/s/inika/v5/1lqGtw7XJX2UQbkbJN5WrPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/inika/v5/yVCO3macxFLQ-WV7uEKF1vesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/inika/v5/VFlwIOjw1jSIKtDKfuLgPvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Inknut Antiqua": {
		"category": "serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Inknut Antiqua Light\'",
						"\'InknutAntiqua-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIjwZbZ8WYKx8oJxOLhifbXU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVItbNQqvlTGn0Wx3SHIqMdGI&skey=46d0e07a86defd0f&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIpuCiI2W22H7KRtEr7rgUR8.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIsHWQ_uINETY3bkccOsuX-A.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIosL0Eb9muEZSbw-fv1v-1M.woff2"
					}
				},
				"400": {
					"local": [
						"\'Inknut Antiqua Regular\'",
						"\'InknutAntiqua-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/VlmmTfOrxr3HfcnhMueX9WvrFbXmx4AnslJ378vpcxE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VlmmTfOrxr3HfcnhMueX9W1-fRzicI3_VDBMobVgu-g&skey=a8d718863b929f45&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/VlmmTfOrxr3HfcnhMueX9QKZaxxWfFldPDbIGRdOGHU.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/VlmmTfOrxr3HfcnhMueX9dK4x0DJI-T8q5ozNuxBQHo.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/VlmmTfOrxr3HfcnhMueX9egUwfPtwj-Vn2gQvo3pfoE.woff2"
					}
				},
				"500": {
					"local": [
						"\'Inknut Antiqua Medium\'",
						"\'InknutAntiqua-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIoobULvOAfz7OTWYB8D63q4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVIhM4JKDVWnK9txqqozXZoek&skey=1e36365059af3854&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIu0gYji7HiRxzTpcRsad8yY.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIt_ua7XZ0xkEWTJ7Dw5dn-U.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIt9fA6Ur6dF-90GGwOlOqGM.woff2"
					}
				},
				"600": {
					"local": [
						"\'Inknut Antiqua SemiBold\'",
						"\'InknutAntiqua-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIvKrDLPKnfzMCVptIHPLD_4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVIlCtdlltnqsJeRZb1hrLYLM&skey=dd0df3c8b9ee2475&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVInJ1G8EUNiOlz5_ED62crxQ.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIvHkKMuIWrKOrP4mpp4lNIM.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIpO_Nk_IOItNy0oaYLBRQP0.woff2"
					}
				},
				"700": {
					"local": [
						"\'Inknut Antiqua Bold\'",
						"\'InknutAntiqua-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIuizJbXuvuRJlE-jvlc5Ulg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVIjBcOTI7lIhu5PZzwUwst0s&skey=aa11e3ecfa335951&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIuNxZRWVX6Y2-xtNgpo3Yvs.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIqMrCbf3tq3gcJOOqA_vtFE.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIjcQQtLGwjSRyP06pKNhHn8.woff2"
					}
				},
				"800": {
					"local": [
						"\'Inknut Antiqua ExtraBold\'",
						"\'InknutAntiqua-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIieluQbpb1HTxtRZzoIbyrk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVIobj_t0qXKNt5U4FrisyaX0&skey=731697920b7c6ec9&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIh05LXdTwjABf11KMPjUQDM.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIhGR1V_Bmk_Q7p-mCdXkVKA.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIl5UpoMW2gytPi5MhnPVphk.woff2"
					}
				},
				"900": {
					"local": [
						"\'Inknut Antiqua Black\'",
						"\'InknutAntiqua-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIidyv0dlxZpFdwSOM6LgRlw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CagoW52rBcslcXzHh6tVIllO2YaMSo4CmEHVuSBxXnU&skey=7b83b759aae0f97&v=v3#InknutAntiqua",
						"ttf": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIgONx_Q6irAs9BvQH2eyiUI.ttf",
						"woff": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIj42XnTU7NHzps_fvhBLOGw.woff",
						"woff2": "http://fonts.gstatic.com/s/inknutantiqua/v3/CagoW52rBcslcXzHh6tVIobnF6ObkCWqFb6o2Bxm9jc.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Irish Grover": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Irish Grover Regular\'",
						"\'IrishGrover-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/irishgrover/v8/kUp7uUPooL-KsLGzeVJbBHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kUp7uUPooL-KsLGzeVJbBFlIn5tFQcqMuf-jhyJP0ps&skey=b6f4e06b096475f7&v=v8#IrishGrover",
						"ttf": "http://fonts.gstatic.com/s/irishgrover/v8/kUp7uUPooL-KsLGzeVJbBInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/irishgrover/v8/kUp7uUPooL-KsLGzeVJbBHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/irishgrover/v8/kUp7uUPooL-KsLGzeVJbBOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Istok Web": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Istok Web Italic\'",
						"\'IstokWeb-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/istokweb/v11/8-xqDtEk6sZ61magDpsV8WfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8-xqDtEk6sZ61magDpsV8XNsigHlcrQGNV8nkUSFQfc&skey=8811c9fe870c01bf&v=v11#IstokWeb",
						"ttf": "http://fonts.gstatic.com/s/istokweb/v11/8-xqDtEk6sZ61magDpsV8Z0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/istokweb/v11/8-xqDtEk6sZ61magDpsV8YbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/istokweb/v11/8-xqDtEk6sZ61magDpsV8Y4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Istok Web Bold Italic\'",
						"\'IstokWeb-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/istokweb/v11/ycQ3g52ELrh3o_HYCNNUw7Ft29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ycQ3g52ELrh3o_HYCNNUw3tNmQEE9wZ6UZlmiISB1pg&skey=cacea6fe46cb51d6&v=v11#IstokWeb",
						"ttf": "http://fonts.gstatic.com/s/istokweb/v11/ycQ3g52ELrh3o_HYCNNUw5_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/istokweb/v11/ycQ3g52ELrh3o_HYCNNUwzqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/istokweb/v11/ycQ3g52ELrh3o_HYCNNUw4lIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Istok Web Regular\'",
						"\'IstokWeb-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/istokweb/v11/EvPKapBawcLZ3hbihjhqAfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EvPKapBawcLZ3hbihjhqAZbd9NUM7myrQQz30yPaGQ4&skey=79160bf8eb8143d8&v=v11#IstokWeb",
						"ttf": "http://fonts.gstatic.com/s/istokweb/v11/EvPKapBawcLZ3hbihjhqAaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/istokweb/v11/EvPKapBawcLZ3hbihjhqAT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/istokweb/v11/EvPKapBawcLZ3hbihjhqAVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Istok Web Bold\'",
						"\'IstokWeb-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/istokweb/v11/2koEo4AKFSvK4B52O_MwanZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2koEo4AKFSvK4B52O_MwallIn5tFQcqMuf-jhyJP0ps&skey=b825e864c348b299&v=v11#IstokWeb",
						"ttf": "http://fonts.gstatic.com/s/istokweb/v11/2koEo4AKFSvK4B52O_MwaonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/istokweb/v11/2koEo4AKFSvK4B52O_MwanhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/istokweb/v11/2koEo4AKFSvK4B52O_Mwaugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Italiana": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Italiana\'",
						"\'Italiana-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/italiana/v6/jxABrUtcgFVEZvznz3r8R_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WwVspM-cJUt4D4iL07IqkfesZW2xOQ-xsNqO47m55DA&skey=89d51c815117a263&v=v6#Italiana",
						"ttf": "http://fonts.gstatic.com/s/italiana/v6/cyoET12_n3_FXMnTJZssYvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/italiana/v6/H6204F0mjGtjVYNr2mjFcPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/italiana/v6/LfYaHQ4Rk7tkyzfelQ0U6_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Italianno": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Italianno\'",
						"\'Italianno-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/italianno/v7/RzzA8gdr3WCK_nxdg53KGvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RzzA8gdr3WCK_nxdg53KGpbd9NUM7myrQQz30yPaGQ4&skey=d30716c90203f6f0&v=v7#Italianno",
						"ttf": "http://fonts.gstatic.com/s/italianno/v7/RzzA8gdr3WCK_nxdg53KGqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/italianno/v7/RzzA8gdr3WCK_nxdg53KGj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/italianno/v7/RzzA8gdr3WCK_nxdg53KGltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Itim": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Itim\'",
						"\'Itim-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/itim/v2/QyHPaHXyrjO1wnO33kjOMw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=cwnVOdyKaxeYF1NsAnlgog&skey=5906924f6c9ed948&v=v2#Itim",
						"ttf": "http://fonts.gstatic.com/s/itim/v2/ZVWlXdoBE70CciTWc1Gqcw.ttf",
						"woff": "http://fonts.gstatic.com/s/itim/v2/Mbu2Uqi4ViN0GFSOhRSHtg.woff",
						"woff2": "http://fonts.gstatic.com/s/itim/v2/5IelbqBx4_S0xbIFnyjCdg.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Jacques Francois": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jacques Francois\'",
						"\'JacquesFrancois-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jacquesfrancois/v5/_-0XWPQIW6tOzTHg4KaJ_F1RMfKEjZlJidOKqQm1HDI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_-0XWPQIW6tOzTHg4KaJ_HaBafEXEI5Mu9et17PbQ-E&skey=f331cd55df0362a4&v=v5#JacquesFrancois",
						"ttf": "http://fonts.gstatic.com/s/jacquesfrancois/v5/_-0XWPQIW6tOzTHg4KaJ_MR42GDen2yMHmykTFI-eTY.ttf",
						"woff": "http://fonts.gstatic.com/s/jacquesfrancois/v5/_-0XWPQIW6tOzTHg4KaJ_JI2N7O7hhWpTtijDoir9L0.woff",
						"woff2": "http://fonts.gstatic.com/s/jacquesfrancois/v5/_-0XWPQIW6tOzTHg4KaJ_G0r6TzgmNhwP1bMwOoxl6o.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Jacques Francois Shadow": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jacques Francois Shadow\'",
						"\'JacquesFrancoisShadow-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jacquesfrancoisshadow/v5/V14y0H3vq56fY9SV4OL_FD81NPGsPS4490tO3GKIC6Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=V14y0H3vq56fY9SV4OL_FMp7ZUYnp7seSlIntYiDuEU&skey=c190ce8cbdc7a345&v=v5#JacquesFrancoisShadow",
						"ttf": "http://fonts.gstatic.com/s/jacquesfrancoisshadow/v5/V14y0H3vq56fY9SV4OL_FNVq-CiInSeJXsKPlSPkAy8.ttf",
						"woff": "http://fonts.gstatic.com/s/jacquesfrancoisshadow/v5/V14y0H3vq56fY9SV4OL_FM_jayyzA3TaKmOW7WWNSn0.woff",
						"woff2": "http://fonts.gstatic.com/s/jacquesfrancoisshadow/v5/V14y0H3vq56fY9SV4OL_FNT2D60XWwE3525OOYN4RY8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Jaldi": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jaldi\'",
						"\'Jaldi-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jaldi/v3/C1gE9HQCenugiqvr88vRWg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=--0ChcPt7FHj9Mzu2FC3OA&skey=ed4f59c0ba71a113&v=v3#Jaldi",
						"ttf": "http://fonts.gstatic.com/s/jaldi/v3/xcNgnouLURBjp4DGKhb8Lw.ttf",
						"woff": "http://fonts.gstatic.com/s/jaldi/v3/Qqw6A-RblWZUJQaW4vGALw.woff",
						"woff2": "http://fonts.gstatic.com/s/jaldi/v3/rHG4LRTTXyqBtS72qs_SYg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Jaldi Bold\'",
						"\'Jaldi-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jaldi/v3/F5mTPFX-1KIsXzeLCHge2_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LKbJNH-scBmOwR7zQpBwdfesZW2xOQ-xsNqO47m55DA&skey=b6fe25580230f49d&v=v3#Jaldi",
						"ttf": "http://fonts.gstatic.com/s/jaldi/v3/D9s7Up0Qff-lIGwSwjzAPPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/jaldi/v3/EcDgp7mYhyiEmZeQczWLqvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/jaldi/v3/9VAmYXgJ2oPpALctGF3-QvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Jim Nightshade": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jim Nightshade\'",
						"\'JimNightshade-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jimnightshade/v5/_n43lYHXVWNgXegdYRIK9O17BfhslzP7rugoHtVpt6Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_n43lYHXVWNgXegdYRIK9EWbDKJjJQ4AvIkQ1UxFPfs&skey=a1cdb4741ac7b833&v=v5#JimNightshade",
						"ttf": "http://fonts.gstatic.com/s/jimnightshade/v5/_n43lYHXVWNgXegdYRIK9FqsysoMtwWGAW-5XDfLptI.ttf",
						"woff": "http://fonts.gstatic.com/s/jimnightshade/v5/_n43lYHXVWNgXegdYRIK9GeI2efzuxEXXKel_Sw2G4E.woff",
						"woff2": "http://fonts.gstatic.com/s/jimnightshade/v5/_n43lYHXVWNgXegdYRIK9NJmD_dqQ94bUc_vtZFnud0.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Jockey One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jockey One\'",
						"\'JockeyOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jockeyone/v7/8Hj8G_JpSADPYrRpzMno2lQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8Hj8G_JpSADPYrRpzMno2qWUboTb-jS2tyCOQMtm97g&skey=c5851443324208ee&v=v7#JockeyOne",
						"ttf": "http://fonts.gstatic.com/s/jockeyone/v7/8Hj8G_JpSADPYrRpzMno2i3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/jockeyone/v7/8Hj8G_JpSADPYrRpzMno2hsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/jockeyone/v7/8Hj8G_JpSADPYrRpzMno2vk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Jolly Lodger": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jolly Lodger\'",
						"\'JollyLodger\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jollylodger/v5/RX8HnkBgaEKQSHQyP9itiXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RX8HnkBgaEKQSHQyP9itiVlIn5tFQcqMuf-jhyJP0ps&skey=b0b0912bfe16f2c4&v=v5#JollyLodger",
						"ttf": "http://fonts.gstatic.com/s/jollylodger/v5/RX8HnkBgaEKQSHQyP9itiYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/jollylodger/v5/RX8HnkBgaEKQSHQyP9itiXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/jollylodger/v5/RX8HnkBgaEKQSHQyP9itiegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Jomhuria": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Jomhuria\'",
						"\'Jomhuria-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jomhuria/v3/q89iKiFJQaLPk8ug8Wl6hPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=P945Dn5fJuwD2qsrkomlH_esZW2xOQ-xsNqO47m55DA&skey=e8318179d6e93cfb&v=v3#Jomhuria",
						"ttf": "http://fonts.gstatic.com/s/jomhuria/v3/IVsq85QXhiDBfDfjal21HvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/jomhuria/v3/AjyPFjARQrgruaBMaquHoPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/jomhuria/v3/cbCXn_5bSfdo5tv8HGAYx_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Josefin Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Josefin Sans Thin Italic\'",
						"\'JosefinSans-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/s7-P1gqRNRNn-YWdOYnAOa4TT5J8ULaPC23bJYiVmx8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=s7-P1gqRNRNn-YWdOYnAOTjsE7ZsbzlznLFkNzySkM8&skey=3ce5d7024a8b3428&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/s7-P1gqRNRNn-YWdOYnAORNDIA8twkEsorcr_fdT1vI.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/s7-P1gqRNRNn-YWdOYnAOaEyK9Hr0SO5vc2-ZCW-Yes.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/s7-P1gqRNRNn-YWdOYnAObE63cHX5PwrPrCPBczlasc.woff2"
					}
				},
				"300": {
					"local": [
						"\'Josefin Sans Light Italic\'",
						"\'JosefinSans-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33GyH_XWDaITL6s384ufbsW_o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ppse0J9fKSaoxCIIJb33G9v65-B3V1C1aB1PFKVs0gQ&skey=a5a2b82d31ad9b51&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G33uxQAI1Bvm-GxtFNy4yl0.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G20Xvi9kvVpeKmlONF1xhUs.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G3M1hBkL4m68a-ReB_y0NYc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Josefin Sans Italic\'",
						"\'JosefinSans-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3dzoGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=q9w3H4aeBxj0hZ8Osfi3d32UFnxWCzsMUZbVj2XRF5M&skey=63d8bfdaaa359390&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3dytfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3d3pumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3dxMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Josefin Sans SemiBold Italic\'",
						"\'JosefinSans-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33GxHNzmFb2hSkh0OZsv7eSbE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ppse0J9fKSaoxCIIJb33G5xbAKLHh33tiENh7myeekA&skey=425960e7f7382d36&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33GzolfeppZzFSKvLyJNPKLMk.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G6xza3rXaV_G32gF04a66fI.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G0rrE62zycmuf6NB1JeYrwM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Josefin Sans Bold Italic\'",
						"\'JosefinSans-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33Gyy7jlJQNiTiB3-MejPw_5E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ppse0J9fKSaoxCIIJb33G-iOBN1C42tFdXFKJTGlCXo&skey=60ba74087198d0c1&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33GyxQL91WRy8t8mPvAX_dIgA.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G70qgHI2SEqiJszC-CVc3gY.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/ppse0J9fKSaoxCIIJb33G0cqRxak6Wc5LUVz-l064SE.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Josefin Sans Thin\'",
						"\'JosefinSans-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3d9P2OS6Bzu7BENq0TH5sayk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=q9w3H4aeBxj0hZ8Osfi3d0_rrxwVtVRydRAQEfd8qLU&skey=6099e053def6fdc6&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3d2-gXUWvikdRm39El-Kldqo.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3dy1dfeF-hbOdKKuBDEXxqhQ.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/q9w3H4aeBxj0hZ8Osfi3d1dBB84BqlWy1BjOnCrU9PY.woff2"
					}
				},
				"300": {
					"local": [
						"\'Josefin Sans Light\'",
						"\'JosefinSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z4ySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=C6HYlRF50SGJq1XyXj04z7Jg1hA63dzswhy4NvEPrPM&skey=690bc9c33e34a134&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04zwV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z2Fp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z04GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Josefin Sans Regular\'",
						"\'JosefinSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/xgzbb53t8j-Mo-vYa23n5nZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xgzbb53t8j-Mo-vYa23n5llIn5tFQcqMuf-jhyJP0ps&skey=22ddf758bcf1d5cd&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/xgzbb53t8j-Mo-vYa23n5onF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/xgzbb53t8j-Mo-vYa23n5nhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/xgzbb53t8j-Mo-vYa23n5ugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Josefin Sans SemiBold\'",
						"\'JosefinSans-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04zzBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=C6HYlRF50SGJq1XyXj04zwmE8htD-SDrf7umQTfloJ8&skey=3f719168dac5287a&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z1FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z9Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Josefin Sans Bold\'",
						"\'JosefinSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z2msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=C6HYlRF50SGJq1XyXj04zway50PuN8loMJ9QAXsTs7U&skey=1d89f7462100a06a&v=v12#JosefinSans",
						"ttf": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z3l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinsans/v12/C6HYlRF50SGJq1XyXj04z3NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Josefin Slab": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Josefin Slab Thin Italic\'",
						"\'JosefinSlab-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/8BjDChqLgBF3RJKfwHIYh64TT5J8ULaPC23bJYiVmx8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8BjDChqLgBF3RJKfwHIYhzjsE7ZsbzlznLFkNzySkM8&skey=c0dba48e8b1ffed2&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/8BjDChqLgBF3RJKfwHIYhxNDIA8twkEsorcr_fdT1vI.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/8BjDChqLgBF3RJKfwHIYh6EyK9Hr0SO5vc2-ZCW-Yes.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/8BjDChqLgBF3RJKfwHIYh7E63cHX5PwrPrCPBczlasc.woff2"
					}
				},
				"300": {
					"local": [
						"\'Josefin Slab Light Italic\'",
						"\'JosefinSlab-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJulyyH_XWDaITL6s384ufbsW_o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=af9sBoKGPbGO0r21xJuly9v65-B3V1C1aB1PFKVs0gQ&skey=e478fe952f135176&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly33uxQAI1Bvm-GxtFNy4yl0.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly20Xvi9kvVpeKmlONF1xhUs.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly3M1hBkL4m68a-ReB_y0NYc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Josefin Slab Italic\'",
						"\'JosefinSlab-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUjoGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=etsUjZYO8lTLU85lDhZwUn2UFnxWCzsMUZbVj2XRF5M&skey=a35ae65c04c96c3f&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUitfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUnpumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUhMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Josefin Slab SemiBold Italic\'",
						"\'JosefinSlab-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJulyxHNzmFb2hSkh0OZsv7eSbE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=af9sBoKGPbGO0r21xJuly5xbAKLHh33tiENh7myeekA&skey=dd96638cd4ec72b8&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJulyzolfeppZzFSKvLyJNPKLMk.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly6xza3rXaV_G32gF04a66fI.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly0rrE62zycmuf6NB1JeYrwM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Josefin Slab Bold Italic\'",
						"\'JosefinSlab-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJulyyy7jlJQNiTiB3-MejPw_5E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=af9sBoKGPbGO0r21xJuly-iOBN1C42tFdXFKJTGlCXo&skey=6dcc8336c5e5f361&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJulyyxQL91WRy8t8mPvAX_dIgA.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly70qgHI2SEqiJszC-CVc3gY.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/af9sBoKGPbGO0r21xJuly0cqRxak6Wc5LUVz-l064SE.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Josefin Slab Thin\'",
						"\'JosefinSlab-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUtP2OS6Bzu7BENq0TH5sayk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=etsUjZYO8lTLU85lDhZwUk_rrxwVtVRydRAQEfd8qLU&skey=448977901b9fea74&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUm-gXUWvikdRm39El-Kldqo.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUi1dfeF-hbOdKKuBDEXxqhQ.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/etsUjZYO8lTLU85lDhZwUldBB84BqlWy1BjOnCrU9PY.woff2"
					}
				},
				"300": {
					"local": [
						"\'Josefin Slab Light\'",
						"\'JosefinSlab-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2IySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NbE6ykYuM2IyEwxQxOIi2LJg1hA63dzswhy4NvEPrPM&skey=d649455df9e86d45&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2AV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2GFp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2E4GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Josefin Slab Regular\'",
						"\'JosefinSlab-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/46aYWdgz-1oFX11flmyEfXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=46aYWdgz-1oFX11flmyEfVlIn5tFQcqMuf-jhyJP0ps&skey=691565cf3ae1dcfe&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/46aYWdgz-1oFX11flmyEfYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/46aYWdgz-1oFX11flmyEfXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/46aYWdgz-1oFX11flmyEfegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Josefin Slab SemiBold\'",
						"\'JosefinSlab-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2DBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NbE6ykYuM2IyEwxQxOIi2AmE8htD-SDrf7umQTfloJ8&skey=5878910710dc2472&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2FFZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2NOd4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2PBf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Josefin Slab Bold\'",
						"\'JosefinSlab-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2GmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NbE6ykYuM2IyEwxQxOIi2Aay50PuN8loMJ9QAXsTs7U&skey=ffbc5283fb6828f7&v=v8#JosefinSlab",
						"ttf": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2H06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2Hl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/josefinslab/v8/NbE6ykYuM2IyEwxQxOIi2HNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Joti One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Joti One\'",
						"\'JotiOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jotione/v5/J736WI1_N1-YqEUp-cGVlPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dl9DAEGjGXqhFVmjsqzFZ_esZW2xOQ-xsNqO47m55DA&skey=62c1bf261cc3b314&v=v5#JotiOne",
						"ttf": "http://fonts.gstatic.com/s/jotione/v5/XiXBM8y3L5iol1funD8Z8fesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/jotione/v5/LVl1n76aEips1R1baeB3RPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/jotione/v5/lDR1UauNQEtw6f1FzUuUHvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Judson": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Judson Italic\'",
						"\'Judson-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/judson/v10/UwZ1H2y8IXczhQT_IZ8vtPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TJqZA9oH6oVQmwmJn0gu_PesZW2xOQ-xsNqO47m55DA&skey=d937ef2f415e3371&v=v10#Judson",
						"ttf": "http://fonts.gstatic.com/s/judson/v10/1wysWVm45GiT89N1hEr5L_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/judson/v10/XQHCNbxVZWwmUlYTvdZosvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/judson/v10/FXgeXiXHxY0soRDyVlwBp_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Judson Regular\'",
						"\'Judson-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/judson/v10/Xw7h93NDKnnXJyoVxVzCyw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2yF1ZSxI9K-MzjLQxPyEkA&skey=5e4bbbcb41f6cd25&v=v10#Judson",
						"ttf": "http://fonts.gstatic.com/s/judson/v10/XQ5JzVrW2GD-d998r4wF5A.ttf",
						"woff": "http://fonts.gstatic.com/s/judson/v10/COhjM6jTUDio6sq5Q3mvBg.woff",
						"woff2": "http://fonts.gstatic.com/s/judson/v10/jiiuvwAM_nnn69GerKv2JA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Judson Bold\'",
						"\'Judson-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/judson/v10/NDPzIEaQdOK7zQKVTnPkIfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NDPzIEaQdOK7zQKVTnPkIZbd9NUM7myrQQz30yPaGQ4&skey=2a4e7d9700bda035&v=v10#Judson",
						"ttf": "http://fonts.gstatic.com/s/judson/v10/NDPzIEaQdOK7zQKVTnPkIaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/judson/v10/NDPzIEaQdOK7zQKVTnPkIT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/judson/v10/NDPzIEaQdOK7zQKVTnPkIVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Julee": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Julee-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/julee/v7/TreE_0QdwLNqtu1C4LjMsA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l8K9GtHtbsx4mSrU04k_Nw&skey=47541d5d0acb64ae&v=v7#Julee",
						"ttf": "http://fonts.gstatic.com/s/julee/v7/BPprKpUOjGsnv-V0GoDRdg.ttf",
						"woff": "http://fonts.gstatic.com/s/julee/v7/rsTTzTiYEy37PYpNUTX4Uw.woff",
						"woff2": "http://fonts.gstatic.com/s/julee/v7/8v12OmDsrehnrPxyjQD3xw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Julius Sans One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Julius Sans One\'",
						"\'JuliusSansOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/juliussansone/v6/iU65JP9acQHPDLkdalCF7luTgT7He_T1DF6rp02aEO4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iU65JP9acQHPDLkdalCF7uUK-EeIygXe5LAOHXDZOMs&skey=11a1a6d9a3450da&v=v6#JuliusSansOne",
						"ttf": "http://fonts.gstatic.com/s/juliussansone/v6/iU65JP9acQHPDLkdalCF7u921tOcMok2fHawGmtxikA.ttf",
						"woff": "http://fonts.gstatic.com/s/juliussansone/v6/iU65JP9acQHPDLkdalCF7q3fkYX5z1QtDUdIWoaaD_k.woff",
						"woff2": "http://fonts.gstatic.com/s/juliussansone/v6/iU65JP9acQHPDLkdalCF7iJccsb45t3MJKcv5BJtrIs.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Junge": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Junge\'",
						"\'Junge-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/junge/v5/II3D2bja2YRqC3-RFg6u8g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eJ0el_reAnoo5EyOSa_2QA&skey=3e6552312d33b055&v=v5#Junge",
						"ttf": "http://fonts.gstatic.com/s/junge/v5/wh2PLWhxorCuNQKW1uOhrw.ttf",
						"woff": "http://fonts.gstatic.com/s/junge/v5/RnsXGP-x9XVrbOSTyRg-sQ.woff",
						"woff2": "http://fonts.gstatic.com/s/junge/v5/ntVA5yJIl9BJbMwc-Iz9DQ.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Jura": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"greek",
			"greek-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Jura Light\'",
						"\'Jura-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jura/v9/iw0yOLQHqaAEIiFOU_im5Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pk7bdLBDQN8Cx0qSq_fB7A&skey=c1194001c2a3361c&v=v9#Jura",
						"ttf": "http://fonts.gstatic.com/s/jura/v9/oL0FwdEAnOsXjuRkZKgehQ.ttf",
						"woff": "http://fonts.gstatic.com/s/jura/v9/8KSd63wo4FZWKnyHikOaeQ.woff",
						"woff2": "http://fonts.gstatic.com/s/jura/v9/28HbrUmh3t8JKl-BC6QYmg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Jura Regular\'",
						"\'Jura-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jura/v9/HLWpg3t15wRDuvsgQ19Q4A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vo4iGkq-zBzbTijFLXbvow&skey=b9937b3ab2bb15f1&v=v9#Jura",
						"ttf": "http://fonts.gstatic.com/s/jura/v9/BaRU3GSISDJW2nIqbysbmg.ttf",
						"woff": "http://fonts.gstatic.com/s/jura/v9/pqMzP52_r6zHbOILcX8h-A.woff",
						"woff2": "http://fonts.gstatic.com/s/jura/v9/2Jw1GPtuhy2Mk02G7ZXodQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Jura Medium\'",
						"\'Jura-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jura/v9/I7-rXIRFt6a5o8YIDXGlow.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yuRsK9Ua9iEe2Q7c4sx6rg&skey=ec1bb796d001ff30&v=v9#Jura",
						"ttf": "http://fonts.gstatic.com/s/jura/v9/VOlGr-7vzd-sWMFFGDufuw.ttf",
						"woff": "http://fonts.gstatic.com/s/jura/v9/jFw8tqoPabDVmpPiiemw_A.woff",
						"woff2": "http://fonts.gstatic.com/s/jura/v9/-VwEkp6Nsd3JaBmxD3TjAg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Jura SemiBold\'",
						"\'Jura-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jura/v9/g6jHnP8IIXbab_rVuLV_SQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HG2J4sXliPUsiUeRT9hp7g&skey=282e270ca1cdaf0f&v=v9#Jura",
						"ttf": "http://fonts.gstatic.com/s/jura/v9/-RHotMovjaVpxVlqUkBy4w.ttf",
						"woff": "http://fonts.gstatic.com/s/jura/v9/BHJNeCKqnHf7vEZJqPHjnQ.woff",
						"woff2": "http://fonts.gstatic.com/s/jura/v9/sGgK78qWBznL37N2OdMZiA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Jura Bold\'",
						"\'Jura-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/jura/v9/7sVCd-y86SyNHaS_Z3fMnQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Aovfmty6wC08e6mDicsJoQ&skey=374a1000d66c7d71&v=v9#Jura",
						"ttf": "http://fonts.gstatic.com/s/jura/v9/o2psAiS0CzfoAGjxRcZqKA.ttf",
						"woff": "http://fonts.gstatic.com/s/jura/v9/Pr08kEOBfU86C1sRnDz-nA.woff",
						"woff2": "http://fonts.gstatic.com/s/jura/v9/rjYXrqsqAlKenmAdHHYptw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Just Another Hand": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Just Another Hand Regular\'",
						"\'JustAnotherHand-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/justanotherhand/v9/fKV8XYuRNNagXr38eqbRf3DXBSVkOIql0tVmXRRIBOA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fKV8XYuRNNagXr38eqbRf4nKTPKMKzmsI8m6FOoA0VA&skey=519b30e18c44eda6&v=v9#JustAnotherHand",
						"ttf": "http://fonts.gstatic.com/s/justanotherhand/v9/fKV8XYuRNNagXr38eqbRf1IfqgZqv9KXZDd4_em_FKQ.ttf",
						"woff": "http://fonts.gstatic.com/s/justanotherhand/v9/fKV8XYuRNNagXr38eqbRf8DbBFScDQWNirGEA9Q9Yto.woff",
						"woff2": "http://fonts.gstatic.com/s/justanotherhand/v9/fKV8XYuRNNagXr38eqbRfzpTO3zq7FUe5pJUVhf_ntc.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Just Me Again Down Here": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Just Me Again Down Here\'",
						"\'JustMeAgainDownHere\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/justmeagaindownhere/v9/sN06iTc9ITubLTgXoG-kc-nF-hESigXoByd1o8v_Mtg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sN06iTc9ITubLTgXoG-kc2KSXtfd7NAh9yzKsvTY1IY&skey=85faf6a9cd49f669&v=v9#JustMeAgainDownHere",
						"ttf": "http://fonts.gstatic.com/s/justmeagaindownhere/v9/sN06iTc9ITubLTgXoG-kc1kSerjmKQx4_8bS0O3fSGc.ttf",
						"woff": "http://fonts.gstatic.com/s/justmeagaindownhere/v9/sN06iTc9ITubLTgXoG-kc4M0m1RcppnZ3Z3GZDDNlQw.woff",
						"woff2": "http://fonts.gstatic.com/s/justmeagaindownhere/v9/sN06iTc9ITubLTgXoG-kc5JZLfXKI9GK3WgI66__RrA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Kadwa": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kadwa\'",
						"\'Kadwa-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kadwa/v2/8wJI-qLS0S05z9nUKsFr0Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=K2J8lmE7Bzm82ria2-J-Kw&skey=8e11c8fa888bb656&v=v2#Kadwa",
						"ttf": "http://fonts.gstatic.com/s/kadwa/v2/jOr-orQd5YVjsjxLH4Y6Ng.ttf",
						"woff": "http://fonts.gstatic.com/s/kadwa/v2/KCYdjI3ePgUlE_sTfsHYCA.woff",
						"woff2": "http://fonts.gstatic.com/s/kadwa/v2/ZFyQCWOZzeblplymy5CQTQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kadwa Bold\'",
						"\'Kadwa-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kadwa/v2/kYMYqCvCxvKMJ-UKaGY8x_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CKuZ38IRbHw-UjQDD-i5cfesZW2xOQ-xsNqO47m55DA&skey=a9b36cfe309e5f71&v=v2#Kadwa",
						"ttf": "http://fonts.gstatic.com/s/kadwa/v2/n4f3XsMRtKbLN4vpFsJ--_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kadwa/v2/oCx1pO9n32JIcmSNOfhyvPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kadwa/v2/yFDxzkVQ1cFjQwz1qjuPMPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Kalam": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Kalam Light\'",
						"\'Kalam-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kalam/v8/wUg7Jkkt8VKT-zE4fSonbvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=24l_W5LKYOEXpOB0Ob-UcfesZW2xOQ-xsNqO47m55DA&skey=160ea477ddf906aa&v=v8#Kalam",
						"ttf": "http://fonts.gstatic.com/s/kalam/v8/teGW0yrAg8h77Md0xfLTpPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kalam/v8/QylgPSjDydA7-sWvyWlYKfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kalam/v8/hTIz1EhZk15xkDsCgpOJLvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Kalam\'",
						"\'Kalam-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kalam/v8/FJCCBIzAwkYx_x_MyRlfMw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Chszu3U2zXnS78zvYSQyzQ&skey=ac3d8b21325789a6&v=v8#Kalam",
						"ttf": "http://fonts.gstatic.com/s/kalam/v8/TR5-UVog3MeV57nRQJPcOA.ttf",
						"woff": "http://fonts.gstatic.com/s/kalam/v8/90dVhmNmR8HPTvtUmM5aQg.woff",
						"woff2": "http://fonts.gstatic.com/s/kalam/v8/IOem-i1iklYvPM2B8plGmg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kalam Bold\'",
						"\'Kalam-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kalam/v8/6Zs-IslOKyjsbXpNUgUOr_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JyBj9t77LVkOULdCESQkNvesZW2xOQ-xsNqO47m55DA&skey=31f303804b29bb6c&v=v8#Kalam",
						"ttf": "http://fonts.gstatic.com/s/kalam/v8/OqCg_C_HUuXZpATnmyRj__esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kalam/v8/Qn-5-6XRdB09P8vdnMkOE_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kalam/v8/V6yS6HmuVV3o39pJxMtJC_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Kameron": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kameron\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kameron/v8/2vn8dge_HpadRinw6s8mUw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KQrRs0djf04jCaHt1LM1rA&skey=320070e7b0fe699d&v=v8#Kameron",
						"ttf": "http://fonts.gstatic.com/s/kameron/v8/95GnvnfbRizW_jyuT2zJug.ttf",
						"woff": "http://fonts.gstatic.com/s/kameron/v8/2MA5UxhNXWrBge11rsgwSg.woff",
						"woff2": "http://fonts.gstatic.com/s/kameron/v8/_GHDZfFYphTmB3ibRDN_ZA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kameron Bold\'",
						"\'Kameron-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kameron/v8/0Mk_Cjlc84dzSw97PDic4FQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0Mk_Cjlc84dzSw97PDic4KWUboTb-jS2tyCOQMtm97g&skey=36c6c85829f8e05c&v=v8#Kameron",
						"ttf": "http://fonts.gstatic.com/s/kameron/v8/0Mk_Cjlc84dzSw97PDic4C3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kameron/v8/0Mk_Cjlc84dzSw97PDic4BsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kameron/v8/0Mk_Cjlc84dzSw97PDic4Pk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Kanit": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Kanit Thin Italic\'",
						"\'Kanit-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/-zkpKr1CqKVn_t92HtMzdvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-zkpKr1CqKVn_t92HtMzdpbd9NUM7myrQQz30yPaGQ4&skey=af6ebcb691038333&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/-zkpKr1CqKVn_t92HtMzdqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/-zkpKr1CqKVn_t92HtMzdj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/-zkpKr1CqKVn_t92HtMzdltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"200": {
					"local": [
						"\'Kanit ExtraLight Italic\'",
						"\'Kanit-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/ciEbSB1rTWU7huOQDd2xf1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ciEbSB1rTWU7huOQDd2xf6WUboTb-jS2tyCOQMtm97g&skey=5be4818c7c5589cd&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/ciEbSB1rTWU7huOQDd2xfy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/ciEbSB1rTWU7huOQDd2xfxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/ciEbSB1rTWU7huOQDd2xf_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Kanit Light Italic\'",
						"\'Kanit-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/eGJKVNdFKopZqaExEyxLZ1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eGJKVNdFKopZqaExEyxLZ6WUboTb-jS2tyCOQMtm97g&skey=26ce3b98d24c6e21&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/eGJKVNdFKopZqaExEyxLZy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/eGJKVNdFKopZqaExEyxLZxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/eGJKVNdFKopZqaExEyxLZ_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Kanit Italic\'",
						"\'Kanit-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/OvUHRs8HIN00AZHW-maw7w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bPgdfyM5C9sv1t4Q2wzsEg&skey=336f203e2505743&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/e-WQiy6MBi5HWcrnEtbm3w.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/1eWwtw8TAQtQQpaimP6tkQ.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/-HSkZA4t5sxUrAMDGkrO1A.woff2"
					}
				},
				"500": {
					"local": [
						"\'Kanit Medium Italic\'",
						"\'Kanit-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/r638aJy265qenEsEzAGL1lQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r638aJy265qenEsEzAGL1qWUboTb-jS2tyCOQMtm97g&skey=dfeb335f5dc0c656&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/r638aJy265qenEsEzAGL1i3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/r638aJy265qenEsEzAGL1hsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/r638aJy265qenEsEzAGL1vk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Kanit SemiBold Italic\'",
						"\'Kanit-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/A8L3Xqc6PqLCrXEDciIvIVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=A8L3Xqc6PqLCrXEDciIvIaWUboTb-jS2tyCOQMtm97g&skey=c9bb313d836b6604&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/A8L3Xqc6PqLCrXEDciIvIS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/A8L3Xqc6PqLCrXEDciIvIRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/A8L3Xqc6PqLCrXEDciIvIfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kanit Bold Italic\'",
						"\'Kanit-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/gX3yGGDjFXypfrBE-Lx8SVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gX3yGGDjFXypfrBE-Lx8SaWUboTb-jS2tyCOQMtm97g&skey=639445fe76360cd9&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/gX3yGGDjFXypfrBE-Lx8SS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/gX3yGGDjFXypfrBE-Lx8SRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/gX3yGGDjFXypfrBE-Lx8Sfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"800": {
					"local": [
						"\'Kanit ExtraBold Italic\'",
						"\'Kanit-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/0vrlIznC5nH1q_DfHrYWIFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0vrlIznC5nH1q_DfHrYWIKWUboTb-jS2tyCOQMtm97g&skey=54e5861002b7cf3e&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/0vrlIznC5nH1q_DfHrYWIC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/0vrlIznC5nH1q_DfHrYWIBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/0vrlIznC5nH1q_DfHrYWIPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"900": {
					"local": [
						"\'Kanit Black Italic\'",
						"\'Kanit-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/1XzmRoVArHzlJC_HcHwb0FQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1XzmRoVArHzlJC_HcHwb0KWUboTb-jS2tyCOQMtm97g&skey=7947e1141cd9170&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/1XzmRoVArHzlJC_HcHwb0C3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/1XzmRoVArHzlJC_HcHwb0BsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/1XzmRoVArHzlJC_HcHwb0Pk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Kanit Thin\'",
						"\'Kanit-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/Tvr_p8QvikK_T3p3Oe5fFw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zV3CqKaKUMZmu4tB7rhZ6g&skey=1fafa5416853f7e5&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/4RMGqD4_2sDfNMUBMOeaOg.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/CRGUAF1mVBaeSyBI8V6jdA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/9mc1eFBC6whiP297Oi1KKA.woff2"
					}
				},
				"200": {
					"local": [
						"\'Kanit ExtraLight\'",
						"\'Kanit-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/zT1fS00SmTdQScwBj2oNzfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vu4Id-exYDSIy0Eqc-IaSPesZW2xOQ-xsNqO47m55DA&skey=4f9bb3526a17f8a6&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/78A_MuksWFObUwG_MEQ07PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/OyZKKcht3KrMYcCn6Icyb_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/ILRJxvacvDA7qSNYAE2Em_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Kanit Light\'",
						"\'Kanit-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/6S9GSpR7vToCgO-dJr_7HPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=jSQmvy4LnXxt-ssHasdJFfesZW2xOQ-xsNqO47m55DA&skey=14ca640360d8623e&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/j-foJ3Hr0M7CNxChyJlvxvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/F5CHTvwXXoTHSmei9N3sL_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/cxHEBsWwed1A7aDhJATlyPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Kanit Regular\'",
						"\'Kanit-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/oCIc-9ZH6OHLemLC7yu7ug.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6NqFl3gqdI1XQsZzY0N5Lw&skey=f700248af71fb487&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/kkq0USULIwHHdoKxKBuLog.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/JVz_oKf_FwFUD9iaz4pcLA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/5NAKUBdE3Nb95aTaJlZOXQ.woff2"
					}
				},
				"500": {
					"local": [
						"\'Kanit Medium\'",
						"\'Kanit-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/T96mqH7V-VdXoIPVVY-RwPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5SiCC3tabkJf82uUyQKb4_esZW2xOQ-xsNqO47m55DA&skey=6cd9965664507be9&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/AcJ_ZLqwDmA83KMgq71QK_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/Q0E62izzPnEuOB9NUkL1gPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/RHqh14DjcvgZGJknoCzKXvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Kanit SemiBold\'",
						"\'Kanit-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/S-GblmAdRlJXC23XvvvLL_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=l74zm-vM-08vzv6bdbhzbfesZW2xOQ-xsNqO47m55DA&skey=37a1924777d7d1eb&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/n1T9oMeJTeY179qpSDAhafesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/92wMIXXMcx9pAL8PI7QsGfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/ZqFcRUNlfbpcawIUlPQLC_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kanit Bold\'",
						"\'Kanit-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/oRAoY-ZPXFosMTWUkS74WPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ErlsYgudODsVRo_kFKXLWvesZW2xOQ-xsNqO47m55DA&skey=5c0b966606f30209&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/8RyrrV_zjRvqislh0WkjjPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/80N5qy6eWS6rAwuoTuuAlvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/mEn4jJ-yZGnuuUYbIaJjw_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Kanit ExtraBold\'",
						"\'Kanit-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/m0XNdsOQXYHO8-nofwveCPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IGpHfJ2jmgAKIg79WQEUYvesZW2xOQ-xsNqO47m55DA&skey=33753599227b342&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/ejD9BdYo4VLGCi7OuF04OPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/3M1y2fPVerGfvJl9-LfJ3PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/-pN35p94GGARWHK7lHn_7PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Kanit Black\'",
						"\'Kanit-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kanit/v3/FjIUkqmtCLFURsI5XMHbSPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ECJxNldcXD_dLuF56-LtJfesZW2xOQ-xsNqO47m55DA&skey=d7003f9a8964e1d2&v=v3#Kanit",
						"ttf": "http://fonts.gstatic.com/s/kanit/v3/hI5anSXkFywu--PSyNnyd_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kanit/v3/vSneB21fBRsnRvCav0Zi2fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kanit/v3/Si9-GTyWVP2DNn3VdLOJt_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Kantumruy": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Kantumruy Light\'",
						"\'KantumruyLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kantumruy/v4/ERRwQE0WG5uanaZWmOFXNlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ERRwQE0WG5uanaZWmOFXNqWUboTb-jS2tyCOQMtm97g&skey=73fcf74205535bdf&v=v4#Kantumruy",
						"ttf": "http://fonts.gstatic.com/s/kantumruy/v4/ERRwQE0WG5uanaZWmOFXNi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kantumruy/v4/ERRwQE0WG5uanaZWmOFXNhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kantumruy/v4/ERRwQE0WG5uanaZWmOFXNkCwP2P_e7NmraeyralSmg8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Kantumruy\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kantumruy/v4/K6o6u4K6jqCkZuq7v8OTTg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hPjK4_hR1_Jg6QJRqOHVMA&skey=7ba9c7022949819a&v=v4#Kantumruy",
						"ttf": "http://fonts.gstatic.com/s/kantumruy/v4/kQfXNYElQxr5dS8FyjD39Q.ttf",
						"woff": "http://fonts.gstatic.com/s/kantumruy/v4/hj6cvi933i4J9vBcMlQp7Q.woff",
						"woff2": "http://fonts.gstatic.com/s/kantumruy/v4/5nlZbFmZDrm1qEwBx76CBBJtnKITppOI_IvcXXDNrsc.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kantumruy Bold\'",
						"\'Kantumruy-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kantumruy/v4/gie_zErpGf_rNzs920C2JlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gie_zErpGf_rNzs920C2JqWUboTb-jS2tyCOQMtm97g&skey=b69682074e8cb65d&v=v4#Kantumruy",
						"ttf": "http://fonts.gstatic.com/s/kantumruy/v4/gie_zErpGf_rNzs920C2Ji3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kantumruy/v4/gie_zErpGf_rNzs920C2JhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kantumruy/v4/gie_zErpGf_rNzs920C2JkCwP2P_e7NmraeyralSmg8.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Karla": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Karla Italic\'",
						"\'Karla-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karla/v6/q1iut0qldmpQ41lMrYSYhg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6pXUn46VwH2M91oEwyLCrg&skey=1da949773a71f90f&v=v6#Karla",
						"ttf": "http://fonts.gstatic.com/s/karla/v6/T7MBC_6JTkW2ZBbjf0rXXw.ttf",
						"woff": "http://fonts.gstatic.com/s/karla/v6/oU7KPLtl1UkRu830svIOXw.woff",
						"woff2": "http://fonts.gstatic.com/s/karla/v6/LCDsRHICy9vmW7BLwm8u7g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Karla Bold Italic\'",
						"\'Karla-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karla/v6/VZ08RdiotRdV1D0ewK-mxFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VZ08RdiotRdV1D0ewK-mxKWUboTb-jS2tyCOQMtm97g&skey=8c6082f21a1add1e&v=v6#Karla",
						"ttf": "http://fonts.gstatic.com/s/karla/v6/VZ08RdiotRdV1D0ewK-mxC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/karla/v6/VZ08RdiotRdV1D0ewK-mxBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/karla/v6/VZ08RdiotRdV1D0ewK-mxPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Karla\'",
						"\'Karla-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karla/v6/8gO-GQO6h3meAtqRrd890A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6bdss521B8nvJZry4rxG6g&skey=139a38ebe1800a84&v=v6#Karla",
						"ttf": "http://fonts.gstatic.com/s/karla/v6/Vu9Dx8oyiuqEkuIyR3OPDQ.ttf",
						"woff": "http://fonts.gstatic.com/s/karla/v6/azR40LUJrT4HaWK28zHmVA.woff",
						"woff2": "http://fonts.gstatic.com/s/karla/v6/Zi_e6rBgGqv33BWF8WTq8g.woff2"
					}
				},
				"700": {
					"local": [
						"\'Karla Bold\'",
						"\'Karla-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karla/v6/s-O-g1eMGKQFvcIY8dKM9fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1U0hBTowQV4a8grjksAMdPesZW2xOQ-xsNqO47m55DA&skey=5004906a717967a3&v=v6#Karla",
						"ttf": "http://fonts.gstatic.com/s/karla/v6/6rYv84POalfstX0SkMI-EvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/karla/v6/3nZS3BKzlvhkwl4yjCQcjPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/karla/v6/suoMYBGv5sGCUIrF9mVTffesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Karma": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Karma Light\'",
						"\'Karma-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karma/v7/DZbMA_oI-hriGqQEsqZ6gfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Z1cRoJLE-zj23Hs4u6uIZ_esZW2xOQ-xsNqO47m55DA&skey=301d02d70f3f6693&v=v7#Karma",
						"ttf": "http://fonts.gstatic.com/s/karma/v7/6h6-4_7TmEVOHy2VRDaoHvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/karma/v7/LbsI-iVkYe8MYUm9lUSYh_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/karma/v7/V97bNN9dRrPuQdX3vbehBPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Karma Regular\'",
						"\'Karma-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karma/v7/EntiP_gvNuJch5JrUjXieg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Qz2AQ68rT57gRpsdQHDwig&skey=96e02c8687f4e117&v=v7#Karma",
						"ttf": "http://fonts.gstatic.com/s/karma/v7/81ZUp_CygnLTWW3dz6skGA.ttf",
						"woff": "http://fonts.gstatic.com/s/karma/v7/E4YVLCG37sfvbHtA5q6EAQ.woff",
						"woff2": "http://fonts.gstatic.com/s/karma/v7/95VWYH-NPm7H5skmtgtlFg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Karma Medium\'",
						"\'Karma-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karma/v7/BVJs-97i8JVaINPsfuTrkPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LuHgzMyxy0cltSTP2oddTPesZW2xOQ-xsNqO47m55DA&skey=6d66610cba92ba2d&v=v7#Karma",
						"ttf": "http://fonts.gstatic.com/s/karma/v7/W5fYW6lKMAwWOI9SzuVo7_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/karma/v7/-pjjo2a9sWKoqL983ALj3PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/karma/v7/IwpMwprxRfr2H27NbsPtSfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Karma SemiBold\'",
						"\'Karma-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karma/v7/QPNorU5QKjjojW-198lHEfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3Cg_WINsN_Z9Yv4ITWhhrvesZW2xOQ-xsNqO47m55DA&skey=7f473d7381c31a0&v=v7#Karma",
						"ttf": "http://fonts.gstatic.com/s/karma/v7/3ICKetxAfeeWchj2l-9fzfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/karma/v7/ptUFmyYFCgViUfhjLkMC9_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/karma/v7/8K1eQH91UCRTFmw4X5EozfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Karma Bold\'",
						"\'Karma-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/karma/v7/fz2laFxeGixS9OnmLkOln_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qqwLyxkuhhNpl0CM6Mch5PesZW2xOQ-xsNqO47m55DA&skey=3ea0640c64504210&v=v7#Karma",
						"ttf": "http://fonts.gstatic.com/s/karma/v7/cWiu-yKGGpOHDxEPdleKrfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/karma/v7/gjALpX3Bp5l7Vc3J156EmfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/karma/v7/dN1f5CgFaWeMKPvRU0AyAfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Katibeh": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Katibeh-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/katibeh/v3/CzwUSO2nfFblG-kXKPGscw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BS9cMEFDk7TDtzYyO68VFQ&skey=5f417d48499acf32&v=v3#Katibeh",
						"ttf": "http://fonts.gstatic.com/s/katibeh/v3/NaCRvGDK43DY-1pCbZWHiA.ttf",
						"woff": "http://fonts.gstatic.com/s/katibeh/v3/qXRO7DyA5UqV9BOxBO_AIw.woff",
						"woff2": "http://fonts.gstatic.com/s/katibeh/v3/bnd6cVSZD_i2LRX_s0dDYg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Kaushan Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kaushan Script\'",
						"\'KaushanScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kaushanscript/v6/qx1LSqts-NtiKcLw4N03IGrfpCc_r9-5ZnZPBmoO4Sk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qx1LSqts-NtiKcLw4N03IGNb_15wyZifjqRY11zN25A&skey=31e8905c8b129a4e&v=v6#KaushanScript",
						"ttf": "http://fonts.gstatic.com/s/kaushanscript/v6/qx1LSqts-NtiKcLw4N03IC5FJMZltoAAwO2fP7iHu2o.ttf",
						"woff": "http://fonts.gstatic.com/s/kaushanscript/v6/qx1LSqts-NtiKcLw4N03IFhlQWQpSCpzb2Peu3I-Q34.woff",
						"woff2": "http://fonts.gstatic.com/s/kaushanscript/v6/qx1LSqts-NtiKcLw4N03IEd0sm1ffa_JvZxsF_BEwQk.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Kavivanar": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"tamil",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kavivanar Regular\'",
						"\'Kavivanar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kavivanar/v3/2kCSSouspKWbUNlo-Sn8GfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2kCSSouspKWbUNlo-Sn8GZbd9NUM7myrQQz30yPaGQ4&skey=171e1659f41f9002&v=v3#Kavivanar",
						"ttf": "http://fonts.gstatic.com/s/kavivanar/v3/2kCSSouspKWbUNlo-Sn8GaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/kavivanar/v3/2kCSSouspKWbUNlo-Sn8GT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/kavivanar/v3/2kCSSouspKWbUNlo-Sn8GVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Kavoon": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kavoon\'",
						"\'Kavoon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kavoon/v6/lk6q1-fY9gR9RCI_NBJrgA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SpUk79ADCI_ujWP87lHx9w&skey=466d574b2f49f7d7&v=v6#Kavoon",
						"ttf": "http://fonts.gstatic.com/s/kavoon/v6/PMzOnY7AcdtckHTJS0S3dQ.ttf",
						"woff": "http://fonts.gstatic.com/s/kavoon/v6/ussWlV5djHtZoUnSGGeN3g.woff",
						"woff2": "http://fonts.gstatic.com/s/kavoon/v6/OKJIqNlCjDLJ2zxSz-ZOtA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Kdam Thmor": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kdam Thmor\'",
						"\'KdamThmor\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kdamthmor/v4/BcKP9gFsja97gWGPr4lRoPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CWjeXZo0ocp_h-2rv9ViJfesZW2xOQ-xsNqO47m55DA&skey=8e94de1cdc3d3cc4&v=v4#KdamThmor",
						"ttf": "http://fonts.gstatic.com/s/kdamthmor/v4/otCdP6UU-VBIrBfVDWBQJ_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kdamthmor/v4/WSYw2JdcLLked9rGkcr3kPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kdamthmor/v4/3bsfLJURbEPHrTjqMd5XXSEAvth_LlrfE80CYdSH47w.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Keania One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Keania One\'",
						"\'KeaniaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/keaniaone/v5/Xs0xx5kHUREmTXw6nnDuClQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Xs0xx5kHUREmTXw6nnDuCqWUboTb-jS2tyCOQMtm97g&skey=dbf3f94cd2851bcd&v=v5#KeaniaOne",
						"ttf": "http://fonts.gstatic.com/s/keaniaone/v5/Xs0xx5kHUREmTXw6nnDuCi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/keaniaone/v5/Xs0xx5kHUREmTXw6nnDuChsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/keaniaone/v5/Xs0xx5kHUREmTXw6nnDuCvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Kelly Slab": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kelly Slab\'",
						"\'KellySlab-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kellyslab/v7/4A8U9DtmhklTRFOO_fzgaFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4A8U9DtmhklTRFOO_fzgaKWUboTb-jS2tyCOQMtm97g&skey=8021e4f176fe967&v=v7#KellySlab",
						"ttf": "http://fonts.gstatic.com/s/kellyslab/v7/4A8U9DtmhklTRFOO_fzgaC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/kellyslab/v7/4A8U9DtmhklTRFOO_fzgaBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/kellyslab/v7/4A8U9DtmhklTRFOO_fzgaPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Kenia": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kenia\'",
						"\'Kenia-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kenia/v9/kkpF44DYFj6Wu9oAk9Isig.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-2tDSmiyPJwQtDQMeW6NCQ&skey=4963fd4437f2b5f&v=v9#Kenia",
						"ttf": "http://fonts.gstatic.com/s/kenia/v9/NwPyt70wqjGGres4mDkBpQ.ttf",
						"woff": "http://fonts.gstatic.com/s/kenia/v9/ltnzLF6AWKYotNHCCB2I2w.woff",
						"woff2": "http://fonts.gstatic.com/s/kenia/v9/l7HH9XOmofKzdS5whsF3EA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Khand": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Khand Light\'",
						"\'Khand-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khand/v6/3zeqnycdh_2VSwR3lJqd5fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8D6xnRF4Vtp-FMBLoOfe2PesZW2xOQ-xsNqO47m55DA&skey=72fb1c68c23ea06b&v=v6#Khand",
						"ttf": "http://fonts.gstatic.com/s/khand/v6/rP6hqWWf6Plcg-nm4Yi6j_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khand/v6/2tkhmNHQl9Guii_8bq_z0fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khand/v6/hAn00zErRHzyfxin8CabhvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Khand Regular\'",
						"\'Khand-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khand/v6/ysp8L5pyuRVvpacU_W8t0w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=n0eVFD6NdKV1Z9mJN9un9w&skey=d40ed1e34341551d&v=v6#Khand",
						"ttf": "http://fonts.gstatic.com/s/khand/v6/i_h-R38R1oCmG56RuB-yBA.ttf",
						"woff": "http://fonts.gstatic.com/s/khand/v6/jsILb4fM_35vyFrBxO_5_g.woff",
						"woff2": "http://fonts.gstatic.com/s/khand/v6/jE6debCT41WQse1Htsii-w.woff2"
					}
				},
				"500": {
					"local": [
						"\'Khand Medium\'",
						"\'Khand-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khand/v6/sCB_36haYfR0UQXBgI9JmvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Cd3tzgAH2cZujzKRlLH5KPesZW2xOQ-xsNqO47m55DA&skey=c34e898398887a9&v=v6#Khand",
						"ttf": "http://fonts.gstatic.com/s/khand/v6/mdaVYmn1KX1pHtEVadh7C_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khand/v6/kVItwNahOlgGrTA1re3XffesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khand/v6/-41om1scqz7QbwGBKAfl3vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Khand SemiBold\'",
						"\'Khand-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khand/v6/5xEYRT56-yMOf5pINElDN_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4mcau1Nsamw_IyIhE2Y3qvesZW2xOQ-xsNqO47m55DA&skey=ff7c71d785460685&v=v6#Khand",
						"ttf": "http://fonts.gstatic.com/s/khand/v6/4fKMP5iEcrUqUTh4FTOMgvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khand/v6/L9dcSoymAJ6FYIOl4chBD_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khand/v6/vr6ZNJpXN-WXcTknMA_7TPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Khand Bold\'",
						"\'Khand-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khand/v6/yAi_rsq-ETDJPip6kciGu_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H72ROn2rOSl96oeD9w6Y__esZW2xOQ-xsNqO47m55DA&skey=e8521d244a3a634b&v=v6#Khand",
						"ttf": "http://fonts.gstatic.com/s/khand/v6/WSdrMJ1MdKALgePnsswoYfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khand/v6/n2TBxueQZKCCbjuzrn3B-fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khand/v6/h5_U1wxbH_4TxOn23I6bKvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Khmer": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Khmer\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khmer/v10/GmRyBkPAzI_bSPxV3u5U8Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UVZNV8_8ib_A183Mj4C5zQ&skey=6527b71fcb030ef0&v=v10#Khmer",
						"ttf": "http://fonts.gstatic.com/s/khmer/v10/vWaBJIbaQuBNz02ALIKJ3A.ttf",
						"woff": "http://fonts.gstatic.com/s/khmer/v10/A3z476we3fB41ihDM70kTQ.woff",
						"woff2": "http://fonts.gstatic.com/s/khmer/v10/EBPGAEwYbo6W1UGhSDiTYg.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Khula": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Khula Light\'",
						"\'Khula-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khula/v3/J6JbXFNNQZSzYuXT1KPjdfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FPgwNtzPNus_ZZIwVFBT9PesZW2xOQ-xsNqO47m55DA&skey=867f0bdfdae10454&v=v3#Khula",
						"ttf": "http://fonts.gstatic.com/s/khula/v3/FhXP1Hhk8kr8E_LtRIjRyvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khula/v3/YU-5r2j_Lxw4Zb67PY4WpvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khula/v3/-xx0uPo3wDx608yKBDdcBfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Khula Regular\'",
						"\'Khula-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khula/v3/XbS2zg0KH1Jjr20oiU_rOQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=c78MwM038IAvMAossASXBA&skey=6d8fe26ae47fbcf9&v=v3#Khula",
						"ttf": "http://fonts.gstatic.com/s/khula/v3/G16s96mQ_gAXTGkBs2CnqQ.ttf",
						"woff": "http://fonts.gstatic.com/s/khula/v3/koFFJH8bUcQUPYhfLQgfIQ.woff",
						"woff2": "http://fonts.gstatic.com/s/khula/v3/SYvd5I-BTu9JPZJQxkiU_w.woff2"
					}
				},
				"600": {
					"local": [
						"\'Khula SemiBold\'",
						"\'Khula-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khula/v3/rNao_zBwJ5Wga97y6bi6K_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lt8sMxowUrZfK_h9J5DdNvesZW2xOQ-xsNqO47m55DA&skey=e97ce45195518f62&v=v3#Khula",
						"ttf": "http://fonts.gstatic.com/s/khula/v3/9app2QYAJx0FeMr3lk-_n_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khula/v3/_WfpTYarRdthXgX-YsMevPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khula/v3/F0tebCSmtCPkQ0twFXDsMPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Khula Bold\'",
						"\'Khula-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khula/v3/rN8F8xGFzHgonqwljOTUS_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fEzhjM9_Og4hWsjcr3ya7PesZW2xOQ-xsNqO47m55DA&skey=e97780ab2e2e718e&v=v3#Khula",
						"ttf": "http://fonts.gstatic.com/s/khula/v3/FUgY2paTlSxHuWr7H1UZh_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khula/v3/ch1ppcS3y6OLv-fvzZdVh_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khula/v3/X7lqfHGcWpWlhqJUbgWL3PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Khula ExtraBold\'",
						"\'Khula-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/khula/v3/TRR20SmHuM8W2Q3x-oVAe_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dbseakv8btTvr8sfGnMCzfesZW2xOQ-xsNqO47m55DA&skey=524ff37f6d9d9177&v=v3#Khula",
						"ttf": "http://fonts.gstatic.com/s/khula/v3/VjuOGhdzNyaANqSWS1X8OPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/khula/v3/GiaWIegUeS7TprWWl2ICvfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/khula/v3/DOFaxGvik8IE7I3DeET_H_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Kite One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kite One\'",
						"\'KiteOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kiteone/v5/h76NCMnlzVKSlObCi4FcOPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=I57DahE8LUgMkk5YGIAnDfesZW2xOQ-xsNqO47m55DA&skey=cef6ce79b95626d1&v=v5#KiteOne",
						"ttf": "http://fonts.gstatic.com/s/kiteone/v5/hBvjgJD9kW8S58mIkeaeS_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kiteone/v5/VNHoD96LpZ9rGZTwjozAOvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kiteone/v5/EsOdvuRhp6mCNgnbcmDDcPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Knewave": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Knewave\'",
						"\'Knewave-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/knewave/v6/gYKRXFn0lrJSQUmzl_K8Cg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lvNyKLUXftoY1QVYgsc94w&skey=7af90525075eab3c&v=v6#Knewave",
						"ttf": "http://fonts.gstatic.com/s/knewave/v6/ts8Wb6WNyHI2d5wvAAWSUA.ttf",
						"woff": "http://fonts.gstatic.com/s/knewave/v6/KH_g_5CSXu1tH8Qrr0aAAQ.woff",
						"woff2": "http://fonts.gstatic.com/s/knewave/v6/LsImHZ47519yUF9Q3zN9ww.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Kotta One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kotta One\'",
						"\'KottaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kottaone/v5/T11KR5KX3fgZhBmu7MWXKvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=T11KR5KX3fgZhBmu7MWXKpbd9NUM7myrQQz30yPaGQ4&skey=4bd1f31c7ad64301&v=v5#KottaOne",
						"ttf": "http://fonts.gstatic.com/s/kottaone/v5/T11KR5KX3fgZhBmu7MWXKqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/kottaone/v5/T11KR5KX3fgZhBmu7MWXKj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/kottaone/v5/T11KR5KX3fgZhBmu7MWXKltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Koulen": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Koulen\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/koulen/v11/Lq3MzF-6yBcLsKtZdbMkfg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vVGqgzk1D0V93oF-WcGdEA&skey=9a9bd154e35cf32c&v=v11#Koulen",
						"ttf": "http://fonts.gstatic.com/s/koulen/v11/AAYOK8RSRO7FTskTzFuzNw.ttf",
						"woff": "http://fonts.gstatic.com/s/koulen/v11/iosTAKcGaYNIixR_In-qtg.woff",
						"woff2": "http://fonts.gstatic.com/s/koulen/v11/OsJq3XXEstC4hg7bZdSZyfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Kranky": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kranky Regular\'",
						"\'Kranky-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kranky/v8/T1-6tr4k5cIumj5vyNsQ9g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=m2UdAij16kiRsLUYbTl1Pw&skey=b33cbe2891488b43&v=v8#Kranky",
						"ttf": "http://fonts.gstatic.com/s/kranky/v8/9MhcqozOOK22yTdfTb9Abg.ttf",
						"woff": "http://fonts.gstatic.com/s/kranky/v8/sqMccMQdypdK4nBmxJC3-A.woff",
						"woff2": "http://fonts.gstatic.com/s/kranky/v8/9tWRGlxaK7Ti3v3jGnQTyw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Kreon": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Kreon Light\'",
						"\'Kreon-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kreon/v11/nl7zhyJwVeYc1UjfSbOti_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VhK19eqtbiwrgY5bDCsDP_esZW2xOQ-xsNqO47m55DA&skey=cff96b37373c5262&v=v11#Kreon",
						"ttf": "http://fonts.gstatic.com/s/kreon/v11/a1jgjBwEF1FcIjUj3bw8cfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kreon/v11/foDwQzChAOJL0-zU6ynhJ_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kreon/v11/76aS1J5Mmu41iLp2Z15uBfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Kreon Regular\'",
						"\'Kreon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kreon/v11/LrBECYI-FdhCRNe1z37o6A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UxABlHVcGBeQmV015kt0SQ&skey=929a764e5c00299e&v=v11#Kreon",
						"ttf": "http://fonts.gstatic.com/s/kreon/v11/XreLooTt3EU7pik51LvgPw.ttf",
						"woff": "http://fonts.gstatic.com/s/kreon/v11/a5r0-iMPk2rygJI75EuckA.woff",
						"woff2": "http://fonts.gstatic.com/s/kreon/v11/gK2DcrR6Rzx5Ga9PpDfp3A.woff2"
					}
				},
				"700": {
					"local": [
						"\'Kreon Bold\'",
						"\'Kreon-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kreon/v11/VD9XZ7_D7tX_o-DScHErN_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=JICeD8nvd14h2Duyfv0Yr_esZW2xOQ-xsNqO47m55DA&skey=8427948aaf7fa66f&v=v11#Kreon",
						"ttf": "http://fonts.gstatic.com/s/kreon/v11/PlQgohaxOFuFqM4bdqkiH_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/kreon/v11/lG8WSXDYq5VbwwKU5QHgb_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/kreon/v11/xjKCXsEUnBvIKKUiQZ3MtfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Kristi": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kristi Regular\'",
						"\'Kristi-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kristi/v9/0okCeA6URe0lFH7F8M3okQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3M22PQlUTRTP1CCr65TWhg&skey=102b657bda2b64be&v=v9#Kristi",
						"ttf": "http://fonts.gstatic.com/s/kristi/v9/EBOxo6OoarykMRxohIxAtw.ttf",
						"woff": "http://fonts.gstatic.com/s/kristi/v9/jFvtq4kMuHvNyfEwUrsUxw.woff",
						"woff2": "http://fonts.gstatic.com/s/kristi/v9/xbewG8OIQ1-9CYdW4rDqlA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Krona One": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Krona One\'",
						"\'KronaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kronaone/v5/ix3TbrGcGYAHLWi4hTTy1PY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ix3TbrGcGYAHLWi4hTTy1Jbd9NUM7myrQQz30yPaGQ4&skey=f76bf6a024f8fca&v=v5#KronaOne",
						"ttf": "http://fonts.gstatic.com/s/kronaone/v5/ix3TbrGcGYAHLWi4hTTy1KCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/kronaone/v5/ix3TbrGcGYAHLWi4hTTy1D8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/kronaone/v5/ix3TbrGcGYAHLWi4hTTy1FtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Kumar One": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"gujarati",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kumar One\'",
						"\'KumarOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kumarone/v2/XFPK9d0MeXRqUzVfNWK8DPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XFPK9d0MeXRqUzVfNWK8DJbd9NUM7myrQQz30yPaGQ4&skey=eb34840884e61733&v=v2#KumarOne",
						"ttf": "http://fonts.gstatic.com/s/kumarone/v2/XFPK9d0MeXRqUzVfNWK8DKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/kumarone/v2/XFPK9d0MeXRqUzVfNWK8DD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/kumarone/v2/XFPK9d0MeXRqUzVfNWK8DFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Kumar One Outline": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"gujarati",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kumar One Outline\'",
						"\'KumarOneOutline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kumaroneoutline/v2/hnQF47H-55qiLAGgq7C3QygHXkmsH9jUtBXJFolz5ZE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hnQF47H-55qiLAGgq7C3Q6IVKuktP6cWF_Gl1B_50o8&skey=2ecb457e319c5c85&v=v2#KumarOneOutline",
						"ttf": "http://fonts.gstatic.com/s/kumaroneoutline/v2/hnQF47H-55qiLAGgq7C3Q2ipBnxXOe2_c2bt4cOy_QA.ttf",
						"woff": "http://fonts.gstatic.com/s/kumaroneoutline/v2/hnQF47H-55qiLAGgq7C3Q6UjU_M2N0fdM8OXLUHZLws.woff",
						"woff2": "http://fonts.gstatic.com/s/kumaroneoutline/v2/hnQF47H-55qiLAGgq7C3Q7jkHrDUwztK6iX3ZDFVjQI.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Kurale": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Kurale Regular\'",
						"\'Kurale-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/kurale/v3/mVmfM2itmnui4n9EKcFh9A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3A9haVGMNMF4RWDftvRARA&skey=fa62c6eb7f6052b&v=v3#Kurale",
						"ttf": "http://fonts.gstatic.com/s/kurale/v3/bbXhGYEu1Ye2w843OLlRyQ.ttf",
						"woff": "http://fonts.gstatic.com/s/kurale/v3/QNEFK5GOV2UayhZKVUBEqQ.woff",
						"woff2": "http://fonts.gstatic.com/s/kurale/v3/qUcQKP0WQHGvJJtuLvvwEg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"La Belle Aurore": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'La Belle Aurore\'",
						"\'LaBelleAurore\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/labelleaurore/v8/Irdbc4ASuUoWDjd_Wc3md6PSPlH96YjF6-Kb122sMck.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Irdbc4ASuUoWDjd_Wc3md5TyNLFBqyOhh6OtMblCA_w&skey=598489a1dbeafc2e&v=v8#LaBelleAurore",
						"ttf": "http://fonts.gstatic.com/s/labelleaurore/v8/Irdbc4ASuUoWDjd_Wc3md4QPT89-YKiadGCMzljt_pA.ttf",
						"woff": "http://fonts.gstatic.com/s/labelleaurore/v8/Irdbc4ASuUoWDjd_Wc3mdyPuxW3DwjEqq93dVR72jP4.woff",
						"woff2": "http://fonts.gstatic.com/s/labelleaurore/v8/Irdbc4ASuUoWDjd_Wc3md8dxVGbf3qyhvoXHfU-LjZg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Laila": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Laila Light\'",
						"\'Laila-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/laila/v4/n1gqkt1dBxaWkxPa1f-5tvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=90bKIs_yifIhZ8V3GFJnRfesZW2xOQ-xsNqO47m55DA&skey=a7caa4e5e1964b98&v=v4#Laila",
						"ttf": "http://fonts.gstatic.com/s/laila/v4/p7SuNk8XVCLyjhY5Ty9PSPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/laila/v4/EJVNEBuMAuWhHTmBsECgIvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/laila/v4/mMzHhxkVPA4WbXqyIn9Wn_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Laila Regular\'",
						"\'Laila-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/laila/v4/WY_8FptpKCB5NI9A77shLg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uZhSPoNUAOvKnyJY8Dmh2Q&skey=1dcd754bec11ed63&v=v4#Laila",
						"ttf": "http://fonts.gstatic.com/s/laila/v4/U1mcJ5nD5aGNUwKhGxWJSw.ttf",
						"woff": "http://fonts.gstatic.com/s/laila/v4/2ZX6NcOeir9qyPOO1aWUrQ.woff",
						"woff2": "http://fonts.gstatic.com/s/laila/v4/xCgA2JPHkH2DRQfvA_6FPw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Laila Medium\'",
						"\'Laila-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/laila/v4/YHPUF63aOzjGONaAGAcMtvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WaJ6-CmNa5OzDTiE06-hZvesZW2xOQ-xsNqO47m55DA&skey=7be6b5ab3ef2670b&v=v4#Laila",
						"ttf": "http://fonts.gstatic.com/s/laila/v4/gzpZ3PhYIsQRC0xo2R4eqvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/laila/v4/rp1y4cHss-EOi8zv40YZXPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/laila/v4/YTJaTdXPQK4foIUrFrk5u_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Laila SemiBold\'",
						"\'Laila-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/laila/v4/_QZAb4bAV916RFwCZRSL0fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gr4PjWhBQFaFg32FVv4LlvesZW2xOQ-xsNqO47m55DA&skey=3b8bd068fc8634e8&v=v4#Laila",
						"ttf": "http://fonts.gstatic.com/s/laila/v4/jNAufSc2746ercQLjrvy-PesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/laila/v4/cVEK-gDyMH8WRcdJLALLA_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/laila/v4/6I7phK2Ij9f2MBu4MdhdR_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Laila Bold\'",
						"\'Laila-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/laila/v4/lu67N104kFLPBuf2Ffkxq_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lH6YfHphALWNk0XVqu4EBfesZW2xOQ-xsNqO47m55DA&skey=62e2c4c922e5a90&v=v4#Laila",
						"ttf": "http://fonts.gstatic.com/s/laila/v4/o6feOHCJlU_R1BPCyUBJ6fesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/laila/v4/iIhxfDbX0IvlC-_DkdPfuPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/laila/v4/WMO1aqJQxiWotBsrfpdeA_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Lakki Reddy": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lakki Reddy\'",
						"\'LakkiReddy\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lakkireddy/v4/rbI79lEFsIu8-QPtske7f2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rbI79lEFsIu8-QPtske7f3NsigHlcrQGNV8nkUSFQfc&skey=6d3860caa41babe7&v=v4#LakkiReddy",
						"ttf": "http://fonts.gstatic.com/s/lakkireddy/v4/rbI79lEFsIu8-QPtske7f50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lakkireddy/v4/rbI79lEFsIu8-QPtske7f4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lakkireddy/v4/rbI79lEFsIu8-QPtske7f44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Lalezar": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lalezar\'",
						"\'Lalezar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lalezar/v2/9W4t9wLTzgazyYZpPfHlmA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=utFgCkaDr1Z6LP3Dqqsk5g&skey=98b64abaf403d4dc&v=v2#Lalezar",
						"ttf": "http://fonts.gstatic.com/s/lalezar/v2/B2wScL8eVv0otk7TS9tkfw.ttf",
						"woff": "http://fonts.gstatic.com/s/lalezar/v2/c-0nXilUugMWH-EFkdK71w.woff",
						"woff2": "http://fonts.gstatic.com/s/lalezar/v2/1DAOO6BooPMSJrLlr2uLug.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Lancelot": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lancelot\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lancelot/v7/49ttdVGiEGEHQ_-_mRtI_fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vzGwWUo_ruats8jzHZ551_esZW2xOQ-xsNqO47m55DA&skey=882f6476e66c1188&v=v7#Lancelot",
						"ttf": "http://fonts.gstatic.com/s/lancelot/v7/5LBg2di2GBv3TBWpNV0NGvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/lancelot/v7/zBMgaTsX4fwqo2jJWGS35vesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/lancelot/v7/gZYRnEKnl9YYo3PI6fF7bfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Lateef": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lateef\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lateef/v11/3DtzHwJGDPx0xnQ8wlHcsg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=E16mDpuEKr_4gb1Va4izrw&skey=c6edfa7a4a5da33&v=v11#Lateef",
						"ttf": "http://fonts.gstatic.com/s/lateef/v11/QjtI5TzE12U_azkbFRuf3w.ttf",
						"woff": "http://fonts.gstatic.com/s/lateef/v11/2MK8KLjbkzuJOC8hOS-Taw.woff",
						"woff2": "http://fonts.gstatic.com/s/lateef/v11/Ujbb_aqcpJSANBY7B8AwXw.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Lato": {
		"category": "sans-serif",
		"lastModified": "2017-10-11",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Lato Hairline Italic\'",
						"\'Lato-HairlineItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/81DMwqUqq96weubmVpbDyvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Hu89JyBnFisiVNJ1Re4R8PesZW2xOQ-xsNqO47m55DA&skey=3404b88e33a27f67&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/gc5ZVKiLNkRdGlU3GaSVBfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/CggrdU0t5c42NcNxN-VM3_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/9TBVFLzQ3GUZLG8FZ4yrEfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Lato Light Italic\'",
						"\'Lato-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/2HG_tEPiQ4Z6795cGfdivPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2HG_tEPiQ4Z6795cGfdivJbd9NUM7myrQQz30yPaGQ4&skey=8107d606b7e3d38e&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/2HG_tEPiQ4Z6795cGfdivKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/2HG_tEPiQ4Z6795cGfdivD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/2HG_tEPiQ4Z6795cGfdivFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Lato Italic\'",
						"\'Lato-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/bjaQ6jyWa8A2XFrSKceJyA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sbmVKhXgM5wMsElf_vy3Iw&skey=51512958f8cff7a8&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/LqowQDslGv4DmUBAfWa2Vw.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/oUan5VrEkpzIazlUe5ieaA.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/PLygLKRVCQnA5fhu3qk5fQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lato Bold Italic\'",
						"\'Lato-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/HkF_qI1x_noxlxhrhMQYEPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HkF_qI1x_noxlxhrhMQYEJbd9NUM7myrQQz30yPaGQ4&skey=5334e9c0b67702e2&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/HkF_qI1x_noxlxhrhMQYEKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/HkF_qI1x_noxlxhrhMQYED8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/HkF_qI1x_noxlxhrhMQYEFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Lato Black Italic\'",
						"\'Lato-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/VNUH7ZAcagYBWsAiBBCEY_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VNUH7ZAcagYBWsAiBBCEY5bd9NUM7myrQQz30yPaGQ4&skey=4066143815f8bfc2&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/VNUH7ZAcagYBWsAiBBCEY6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/VNUH7ZAcagYBWsAiBBCEYz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/VNUH7ZAcagYBWsAiBBCEY1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Lato Hairline\'",
						"\'Lato-Hairline\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/KlmP_Vc2zOZBldw8AfXD5g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1zdx8ZyEBSORSnTlZpEGKA&skey=cfa1ba7b04a1ba34&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/zJY4gsxBiSo5L7tNutxFNg.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/boeCNmOCCh-EWFLSfVffDg.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/GtRkRNTnri0g82CjKnEB0Q.woff2"
					}
				},
				"300": {
					"local": [
						"\'Lato Light\'",
						"\'Lato-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/zLhfkPOm_5ykmdm-wXaiuw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7yKIrlBXX_AXuUv3Ts9_8g&skey=91f32e07d083dd3a&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/nj47mAZe0mYUIySgfn0wpQ.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/KT3KS9Aol4WfR6Vas8kNcg.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/EsvMC5un3kjyUhB9ZEPPwg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Lato Regular\'",
						"\'Lato-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/nQhiC-wSiJx0pvEuJl8d8A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hLECvlEj3pKlnS4NFs8NQw&skey=2d58b92a99e1c086&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/v0SdcGFAl2aezM9Vq_aFTQ.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/9k-RPmcnxYEPm8CNFsH2gg.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/1YwB1sO8YE1Lyjf12WNiUA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lato Bold\'",
						"\'Lato-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/sBtfDPlEIwvKKU53nAG7AQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H4oiIt_Ug9TU5ast0nUT-w&skey=3480a19627739c0d&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/DvlFBScY1r-FMtZSYIYoYw.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/wkfQbvfT_02e2IWO3yYueQ.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/H2DMvhDLycM56KNuAtbJYA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Lato Black\'",
						"\'Lato-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lato/v14/BjDVcwQGWPX2RAidnkd0Bw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=UxBsysUD4pfKXRb0IKmcRQ&skey=d01acf708cb3b73b&v=v14#Lato",
						"ttf": "http://fonts.gstatic.com/s/lato/v14/4cKlrioa77J2iqTqBgkRWg.ttf",
						"woff": "http://fonts.gstatic.com/s/lato/v14/BVtM30trf7q_jfqYeHfjtA.woff",
						"woff2": "http://fonts.gstatic.com/s/lato/v14/tI4j516nok_GrVf4dhunkg.woff2"
					}
				}
			}
		},
		"version": "v14"
	},
	"League Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'League Script\'",
						"\'LeagueScript\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/leaguescript/v8/wnRFLvfabWK_DauqppD6vZUd5_bBx-I7ejm58jUcS4c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wnRFLvfabWK_DauqppD6vWfBnQSYs5k9tEZwrmi4ago&skey=84dc0ed8164e7f66&v=v8#LeagueScript",
						"ttf": "http://fonts.gstatic.com/s/leaguescript/v8/wnRFLvfabWK_DauqppD6vTmuEnbvkdF7vjbeHX60E38.ttf",
						"woff": "http://fonts.gstatic.com/s/leaguescript/v8/wnRFLvfabWK_DauqppD6vREVhAA1gnTRu3Am0EzDRlM.woff",
						"woff2": "http://fonts.gstatic.com/s/leaguescript/v8/wnRFLvfabWK_DauqppD6vVgaG90emUMHR_woZ36JLVg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Leckerli One": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Leckerli One\'",
						"\'LeckerliOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/leckerlione/v8/S2Y_iLrItTu8kIJTkS7DrHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=S2Y_iLrItTu8kIJTkS7DrFlIn5tFQcqMuf-jhyJP0ps&skey=6384c587add2bb80&v=v8#LeckerliOne",
						"ttf": "http://fonts.gstatic.com/s/leckerlione/v8/S2Y_iLrItTu8kIJTkS7DrInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/leckerlione/v8/S2Y_iLrItTu8kIJTkS7DrHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/leckerlione/v8/S2Y_iLrItTu8kIJTkS7DrOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Ledger": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Ledger\'",
						"\'Ledger-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/ledger/v5/DbNL-nwKThH--AhX9TjzBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gyfRgFRmZEL4qeLsiu9EOg&skey=6e1b03f801dd56e8&v=v5#Ledger",
						"ttf": "http://fonts.gstatic.com/s/ledger/v5/nESxPLkUJBbOEvteDc1rMw.ttf",
						"woff": "http://fonts.gstatic.com/s/ledger/v5/igkC_7G-owzFb7N92hJNEg.woff",
						"woff2": "http://fonts.gstatic.com/s/ledger/v5/v0qdczIUceuXPp6Ljb0NRA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Lekton": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Lekton-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lekton/v8/h04WtpXz1qKOTVkzZ5L3VfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uFMwn3N7mufmSvD30jlnD_esZW2xOQ-xsNqO47m55DA&skey=f90240a45c2af78&v=v8#Lekton",
						"ttf": "http://fonts.gstatic.com/s/lekton/v8/jsCNkPMIaS8e2pn_s70LGPesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/lekton/v8/EtzfH_BL45nRIPQJcfvgu_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/lekton/v8/O218szq9vSZmH5dB2prhm_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Lekton\'",
						"\'Lekton-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lekton/v8/lotPpREcKffQzibJJTvIjw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_Oo1CMf-LB3Iq77fGcpwHg&skey=ea1e370f252c6f8d&v=v8#Lekton",
						"ttf": "http://fonts.gstatic.com/s/lekton/v8/YyER7tmu7BJxyzR0twzSmw.ttf",
						"woff": "http://fonts.gstatic.com/s/lekton/v8/Gv78TXgMRvGbTrqT_eA_TQ.woff",
						"woff2": "http://fonts.gstatic.com/s/lekton/v8/GY6PlTlcpI9OWorXeq8Mhg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lekton-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lekton/v8/sElR8eSezhQZgOuqD3W75fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sElR8eSezhQZgOuqD3W75Zbd9NUM7myrQQz30yPaGQ4&skey=bda8e77f1d703414&v=v8#Lekton",
						"ttf": "http://fonts.gstatic.com/s/lekton/v8/sElR8eSezhQZgOuqD3W75aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/lekton/v8/sElR8eSezhQZgOuqD3W75T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/lekton/v8/sElR8eSezhQZgOuqD3W75VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Lemon": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lemon Regular\'",
						"\'Lemon-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lemon/v6/3lT9BdSpc0z_a2IUlMRliA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zdC2_VHcSGfzbx6eF6AMNg&skey=5c2dd175e2a15bb6&v=v6#Lemon",
						"ttf": "http://fonts.gstatic.com/s/lemon/v6/WRZq1AYYveIOSocZAeAyAw.ttf",
						"woff": "http://fonts.gstatic.com/s/lemon/v6/XGWCPn4vpJIX2zAFeIvA_Q.woff",
						"woff2": "http://fonts.gstatic.com/s/lemon/v6/XcaCAkElV2QjTU53kZeOYQ.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Lemonada": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"300": {
					"local": [
						"\'Lemonada Light\'",
						"\'Lemonada-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lemonada/v3/Adh4K8oFD_U6yqRQjHmau2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Adh4K8oFD_U6yqRQjHmau3NsigHlcrQGNV8nkUSFQfc&skey=c71c75bee5ac72d9&v=v3#Lemonada",
						"ttf": "http://fonts.gstatic.com/s/lemonada/v3/Adh4K8oFD_U6yqRQjHmau50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lemonada/v3/Adh4K8oFD_U6yqRQjHmau4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lemonada/v3/Adh4K8oFD_U6yqRQjHmau44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"400": {
					"local": [
						"\'Lemonada\'",
						"\'Lemonada-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lemonada/v3/p5VcsmJlJRAZC40bRZcJxPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=900kk2NaYb9oBWO9BYFgFPesZW2xOQ-xsNqO47m55DA&skey=fb52792da5c33628&v=v3#Lemonada",
						"ttf": "http://fonts.gstatic.com/s/lemonada/v3/FxlRYvwDdtqCHx4T_2aLzvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/lemonada/v3/LFvqPDsgSeKneEfVub8m8_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/lemonada/v3/zAj2aFAUh05bGotD4xxRVvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Lemonada SemiBold\'",
						"\'Lemonada-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lemonada/v3/SsxRyqeihDy7AxlHTMIrIWfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SsxRyqeihDy7AxlHTMIrIXNsigHlcrQGNV8nkUSFQfc&skey=a377f1dd7223caeb&v=v3#Lemonada",
						"ttf": "http://fonts.gstatic.com/s/lemonada/v3/SsxRyqeihDy7AxlHTMIrIZ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lemonada/v3/SsxRyqeihDy7AxlHTMIrIYbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lemonada/v3/SsxRyqeihDy7AxlHTMIrIY4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lemonada Bold\'",
						"\'Lemonada-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lemonada/v3/X7JkUVPUOfEp8VUXkHzkFmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=X7JkUVPUOfEp8VUXkHzkFnNsigHlcrQGNV8nkUSFQfc&skey=578ab3ed93e69969&v=v3#Lemonada",
						"ttf": "http://fonts.gstatic.com/s/lemonada/v3/X7JkUVPUOfEp8VUXkHzkFp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lemonada/v3/X7JkUVPUOfEp8VUXkHzkFobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lemonada/v3/X7JkUVPUOfEp8VUXkHzkFo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Libre Barcode 128": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 128 Regular\'",
						"\'LibreBarcode128-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode128/v5/mJ_rGOyyL62_i4eysdBvxLYR-_ZoKq17evgZX6d5Opc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mJ_rGOyyL62_i4eysdBvxC4CnEiaFaoxMdoP5JYCuoo&skey=b4e8c1d4fad3a49&v=v5#LibreBarcode128",
						"ttf": "http://fonts.gstatic.com/s/librebarcode128/v5/mJ_rGOyyL62_i4eysdBvxPDyRCAlSAmliknZgt5tlaQ.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode128/v5/mJ_rGOyyL62_i4eysdBvxH0dEt-Ts16fJ-eW9jd9vx8.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode128/v5/mJ_rGOyyL62_i4eysdBvxO1xeuGHyM7UnjkZNOUC490.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Libre Barcode 128 Text": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 128 Text Regular\'",
						"\'LibreBarcode128Text-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode128text/v5/T1o66XlW_PeuHiRa8wDOJC38ui_JfD9kEvyiIUVaZhg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=T1o66XlW_PeuHiRa8wDOJKYp5-DQHF8LdOgs0ZbSGW0&skey=d0b4a7e3a2472aa4&v=v5#LibreBarcode128Text",
						"ttf": "http://fonts.gstatic.com/s/librebarcode128text/v5/T1o66XlW_PeuHiRa8wDOJFxZtoVb0mZxA3_2FeZ1M9g.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode128text/v5/T1o66XlW_PeuHiRa8wDOJIKaO1ZxHjEatAze7bYlO_Q.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode128text/v5/T1o66XlW_PeuHiRa8wDOJALohQwHnEZA2rfi-H4ePTo.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Libre Barcode 39": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 39 Regular\'",
						"\'LibreBarcode39-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode39/v5/tsmYkcVN_FjeCmyWhRNQuJLBVJc8zT9QGp0acgOOlzE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tsmYkcVN_FjeCmyWhRNQuEWABdnjdai-T9L85AiB694&skey=669a7227d05d7508&v=v5#LibreBarcode39",
						"ttf": "http://fonts.gstatic.com/s/librebarcode39/v5/tsmYkcVN_FjeCmyWhRNQuCu4YcIE_RArnD6ddAC6bhU.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode39/v5/tsmYkcVN_FjeCmyWhRNQuAqC1-XZyyUDQWUBodjV-ls.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode39/v5/tsmYkcVN_FjeCmyWhRNQuJm_oOtUjC5ylz94bgAcf30.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Libre Barcode 39 Extended": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 39 Extended\'",
						"\'LibreBarcode39Extended-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode39extended/v4/fb2-vuy0PLrmtXyLBPV4KBKFBrrVBJfdahtI7awDPVP2Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fb2-vuy0PLrmtXyLBPV4KBKFBrrVBJfdahtI7awDPVOW3fTVDO5sq0EM99Mj2hkO&skey=30c2ccc8c0bb6de6&v=v4#LibreBarcode39Extended",
						"ttf": "http://fonts.gstatic.com/s/librebarcode39extended/v4/fb2-vuy0PLrmtXyLBPV4KBKFBrrVBJfdahtI7awDPVOglnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode39extended/v4/fb2-vuy0PLrmtXyLBPV4KBKFBrrVBJfdahtI7awDPVM_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode39extended/v4/fb2-vuy0PLrmtXyLBPV4KBKFBrrVBJfdahtI7awDPVNbV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Libre Barcode 39 Extended Text": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 39 Extended Text\'",
						"\'LibreBarcode39ExtendedText-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode39extendedtext/v4/wJsqK3E245PKDhdHYS7MabGP_8dGDh0UJYBW4DYg-cvf9ZPL1N6MzPLgN4qe0aB_.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wJsqK3E245PKDhdHYS7MabGP_8dGDh0UJYBW4DYg-cvQ4MSJd2wdyM9e2QTBYW1a&skey=3240354573fd446e&v=v4#LibreBarcode39ExtendedText",
						"ttf": "http://fonts.gstatic.com/s/librebarcode39extendedtext/v4/wJsqK3E245PKDhdHYS7MabGP_8dGDh0UJYBW4DYg-cuxSxSOytwIAWM41ikuc6g0.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode39extendedtext/v4/wJsqK3E245PKDhdHYS7MabGP_8dGDh0UJYBW4DYg-cvXJ36_St4Jk-5FK2PyqG5c.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode39extendedtext/v4/wJsqK3E245PKDhdHYS7MabGP_8dGDh0UJYBW4DYg-cvRhOZc7W1LgJkNINyVr49O.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Libre Barcode 39 Text": {
		"category": "display",
		"lastModified": "2017-10-23",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Libre Barcode 39 Text Regular\'",
						"\'LibreBarcode39Text-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebarcode39text/v5/O4inMvtTcDsw_GI-nhT1noYuwsxJuqxsRAWQgj1c1-M.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=O4inMvtTcDsw_GI-nhT1nukrzcB4OqzY5weyPGnV_rw&skey=a91ebaf074a37bd0&v=v5#LibreBarcode39Text",
						"ttf": "http://fonts.gstatic.com/s/librebarcode39text/v5/O4inMvtTcDsw_GI-nhT1nulTB9vD0CsoDp3n2q5acOQ.ttf",
						"woff": "http://fonts.gstatic.com/s/librebarcode39text/v5/O4inMvtTcDsw_GI-nhT1nqjy5h77AeGiASQWBq_Mt68.woff",
						"woff2": "http://fonts.gstatic.com/s/librebarcode39text/v5/O4inMvtTcDsw_GI-nhT1ngA9s1DpUaeSeqfKrIEfYns.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Libre Baskerville": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Libre Baskerville Italic\'",
						"\'LibreBaskerville-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebaskerville/v5/QHIOz1iKF3bIEzRdDFaf5ZBQH13TilI9-e620I2pL1I.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=QHIOz1iKF3bIEzRdDFaf5f8arhTf3IhpJG-4h56ptSk&skey=44cd15477bf5bb2d&v=v5#LibreBaskerville",
						"ttf": "http://fonts.gstatic.com/s/librebaskerville/v5/QHIOz1iKF3bIEzRdDFaf5ZEdosCNS0EvOwDBzJZsz8o.ttf",
						"woff": "http://fonts.gstatic.com/s/librebaskerville/v5/QHIOz1iKF3bIEzRdDFaf5dgliI79_bmRXH6crmREtCo.woff",
						"woff2": "http://fonts.gstatic.com/s/librebaskerville/v5/QHIOz1iKF3bIEzRdDFaf5eUHi-3yDrzgLLsrfaKVF9k.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Libre Baskerville\'",
						"\'LibreBaskerville-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebaskerville/v5/pR0sBQVcY0JZc_ciXjFsK2F7WC2UG4aaA4SZk0HPHJg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pR0sBQVcY0JZc_ciXjFsK0a0MgkfBR95Z0kZUwmzdX4&skey=1ccff9706b4dcbb3&v=v5#LibreBaskerville",
						"ttf": "http://fonts.gstatic.com/s/librebaskerville/v5/pR0sBQVcY0JZc_ciXjFsKwAUTJOA6-irsSazDq377BE.ttf",
						"woff": "http://fonts.gstatic.com/s/librebaskerville/v5/pR0sBQVcY0JZc_ciXjFsK5Rby8KfwQsaipLBqMCVNtM.woff",
						"woff2": "http://fonts.gstatic.com/s/librebaskerville/v5/pR0sBQVcY0JZc_ciXjFsK6Ucnt8gjcHpqyffjHeZWDA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Libre Baskerville Bold\'",
						"\'LibreBaskerville-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librebaskerville/v5/kH7K4InNTm7mmOXXjrA5v_fr9m1k3tZymdin9USByuQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kH7K4InNTm7mmOXXjrA5v-eGOgETBQKeJZeg6Dxg_Xg&skey=c168ba7fe84b1774&v=v5#LibreBaskerville",
						"ttf": "http://fonts.gstatic.com/s/librebaskerville/v5/kH7K4InNTm7mmOXXjrA5v_gg4qM5Rpmu0ASAribBgqE.ttf",
						"woff": "http://fonts.gstatic.com/s/librebaskerville/v5/kH7K4InNTm7mmOXXjrA5vz8SLKRGgamuUl1hIefMyNI.woff",
						"woff2": "http://fonts.gstatic.com/s/librebaskerville/v5/kH7K4InNTm7mmOXXjrA5v6y7YSlLHrWsjpD3RcrnyFM.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Libre Franklin": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Libre Franklin Thin Italic\'",
						"\'LibreFranklin-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/LHzsuUmxr4UY-IoiG8pRKywyTYJul01uZWVi6XfgHqA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LHzsuUmxr4UY-IoiG8pRKwYB1wTr7fyuO4SK6HCSQKM&skey=85cbbd2a127a037b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/LHzsuUmxr4UY-IoiG8pRK2j6L0UJadU_D_a45Ef-rT4.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/LHzsuUmxr4UY-IoiG8pRK6ZmPopI6ZnO-q3nFTmhO8E.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/LHzsuUmxr4UY-IoiG8pRK0g7HWoC1BoTAtlmwqf7C_o.woff2"
					}
				},
				"200": {
					"local": [
						"\'Libre Franklin ExtraLight Italic\'",
						"\'LibreFranklin-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho398sgnU-tjB6sqIhoc6Uhg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqhox8m_ZHoy39I6JMjM86UUdQ&skey=6c65792cc3381596&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhozXfpEIjLEf9l5wPaqCvqpw.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho-hDjR9t64h1mqu9xOHrfF4.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhoyXVRK0cb2RbRwUcRHKTEX8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Libre Franklin Light Italic\'",
						"\'LibreFranklin-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho8RvFQPTkE8JQlwf3b8JEis.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqho4aJ3Mx6f-PERxla-8LsN7k&skey=65af2f6c14fcda41&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho9nnMzu0H6LE-iO630Gsjk4.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho92YSwxmth3fZ3P-QEPmEeE.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho9GcObP4dA9nkvhh8IuXRuc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Libre Franklin Italic\'",
						"\'LibreFranklin-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsRkgraphNZq6Y6k73xEvQug.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zrsyK9EytLQ07oRM9IZIsbY0M9YduptCod0KwLNF0Z4&skey=b88eddb8c4de9fa0&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsVV-4wgQlWBoEL_F3s9DX9g.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIseUtfrpt7cPHpZOhuUCOpsU.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsUGWZPQhhQLxjq7ViWViJIs.woff2"
					}
				},
				"500": {
					"local": [
						"\'Libre Franklin Medium Italic\'",
						"\'LibreFranklin-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho08SevSXnxvsz2oJVHDaRFU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqho8rxSrg-OcRSZAPsDKf-ggg&skey=d324207deacd8def&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho1xBIR0GcKrIA2BHsExAujU.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhozyLnxusO8kpekvcdbw8PeM.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho8Jn1h25bJDNB8hjSCgoZjs.woff2"
					}
				},
				"600": {
					"local": [
						"\'Libre Franklin SemiBold Italic\'",
						"\'LibreFranklin-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho1Ji5mXXIXEE5OJLjW66e8w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqho3D7xwlWfVC8HrWgebnPPU0&skey=cd33bfada7e51a9b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho5DZ83g9KlVvrus95XDlrPs.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho-1atm4oO7KTNKY2nLdkEl0.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho8KMQUUhKH0FUneUpIw5ujQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Libre Franklin Bold Italic\'",
						"\'LibreFranklin-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhozAbHm0NC5Zvtui7Tb4ZAzQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqho5cPbheDi6dGhUQeqmVRj8c&skey=167dbda82443ca38&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho9nZqK_OWP2ndIAnR5-yRDQ.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho3jCYRCcWBOGT-LD_jvL5aE.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho3mPvD0htbP4h5ASGh4WfqE.woff2"
					}
				},
				"800": {
					"local": [
						"\'Libre Franklin ExtraBold Italic\'",
						"\'LibreFranklin-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhowydhWnuijaOMnlZbJeYo4A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqhoyWbtKnLz1xPKAycKpZwxEI&skey=6cf67816f4c7f2d6&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho2uj1fbIwVpZoYMEOBOa_Oc.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho4j0fOFN-Un4DorBGIrpa4E.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho4z_E5A8o3B2o6vecmEmkpE.woff2"
					}
				},
				"900": {
					"local": [
						"\'Libre Franklin Black Italic\'",
						"\'LibreFranklin-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho2aB0O17yOh3dk0lLs2Ky3E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7_V210XP3LBEtEwiCTqho3W5qb1HWPnhzbBd8VA2QJk&skey=1baefed97a36429b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho8ToX_e0_PtbGmSy1djo7pA.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqhoywvgpseusd2GiEvVBAbDdM.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/7_V210XP3LBEtEwiCTqho4_pQLLiHFmIqD54Kc_oXis.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Libre Franklin Thin\'",
						"\'LibreFranklin-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsYwy0U2rtIcMJUPaHdq6d0Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zrsyK9EytLQ07oRM9IZIsY8bHnI0xNxukziSR9Z-uIo&skey=e4d6750d540b853b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsRYrxALXC74fO5XyEV-zY70.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsZouRNOF_ZvB_4odnJo8jEA.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/zrsyK9EytLQ07oRM9IZIsVoa2N78zXrbM86Q9XaF1fQ.woff2"
					}
				},
				"200": {
					"local": [
						"\'Libre Franklin ExtraLight\'",
						"\'LibreFranklin-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yEhGYSajs8gl_eKKoZQTfvY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yIHvGCIr5JyEYOQgbFC4NQE&skey=28b7a260cf22df9d&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yEvmN9OUbhF11KmtYg61ibM.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yC8nwqnDC-f-V4NjBjYLCO8.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yH19-I9Zwgc2dhIzxtYkveA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Libre Franklin Light\'",
						"\'LibreFranklin-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yLxl7xkJBFKEd970r6HuSiQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yGORdoAf86p2eJTXGe9-iQY&skey=bf97ce5df7e65102&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yNga15RJ_Jvq5Ez6sL0RHQ8.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yIxrGY9qwygaxVs5NHnQzYM.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yFPHBuiM1VZKzVTAMxr4LJk.woff2"
					}
				},
				"400": {
					"local": [
						"\'Libre Franklin\'",
						"\'LibreFranklin-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/PFwjf3aDdAQPvNKUrT3U71Jy1eVRs_VXlylmmZFnFsc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PFwjf3aDdAQPvNKUrT3U702WT16B87GuwkooLwwJCMw&skey=c27c9a4f66e66f55&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/PFwjf3aDdAQPvNKUrT3U7zi6aZXXSmqDXSFqcYJu3PE.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/PFwjf3aDdAQPvNKUrT3U7-OqISmHYRiRLVtru_XOHyc.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/PFwjf3aDdAQPvNKUrT3U70L2euXwouSmDRNACsKL_Ek.woff2"
					}
				},
				"500": {
					"local": [
						"\'Libre Franklin Medium\'",
						"\'LibreFranklin-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yK3Kq1DkuZSglbl8EbNpBJg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yP2apSCyEufVqBT1JjjxxsA&skey=cc26076985c33aee&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yDIg7xg1NL0FMLS-tJoj3pU.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yPw7TQDCBctew9_9TpjYiMA.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yMihnyZSyinFaWZLru2AMSQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Libre Franklin SemiBold\'",
						"\'LibreFranklin-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yCJphnCCyTC3Z8nx1KyKg0k.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yG6ayeT_i1oMJ2xBUn8DIM8&skey=89c99f7af1b739b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yPvMzze78vouR4hFc2GghdI.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yOWbxtbdQfcNZ3rffhl709w.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yE-2_ylO1pyzqUJ-APdKjTM.woff2"
					}
				},
				"700": {
					"local": [
						"\'Libre Franklin Bold\'",
						"\'LibreFranklin-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yHAS60jIfKEcJBJvBAOxEho.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yEKSE9StGTkEh1ELrNwd6RM&skey=881913c6bce4bd4b&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yExLJP5IPipIf8iSS4Sq_yc.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yHX5j9uek_RvWZQkna4souI.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yFWV-FyrfMyO4CdzG9bhoAY.woff2"
					}
				},
				"800": {
					"local": [
						"\'Libre Franklin ExtraBold\'",
						"\'LibreFranklin-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yOVoq-ST8cATJwmShyFQDjo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yLjb2iRrI-VD-QqfeTkWOHw&skey=47dda1cd5df6f629&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yKEFtkyrvR1UMEHfgnzW3WQ.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yKTvMkf4lcNvRhTnsxZ8v9E.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yPO3AS568wZbcU3YuRyddXA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Libre Franklin Black\'",
						"\'LibreFranklin-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yNoroWxxZbfvNG6XBs3XRxg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1_DGDtljMiPWFs5rl_p0yJ6szYERt0IirLYaSXIjI0A&skey=440f3b95c0ab0cf3&v=v2#LibreFranklin",
						"ttf": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yNy8ufYeyoX1ueqBTUV9qAI.ttf",
						"woff": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yNxDKZWgU6F7qAStbcX3MmU.woff",
						"woff2": "http://fonts.gstatic.com/s/librefranklin/v2/1_DGDtljMiPWFs5rl_p0yPeZiZnoom4izD3QQchq0TQ.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Life Savers": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Life Savers\'",
						"\'LifeSavers-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lifesavers/v7/_yRJoxB8KMO25_gswqItc2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_yRJoxB8KMO25_gswqItc3NsigHlcrQGNV8nkUSFQfc&skey=7b619362a46bbd09&v=v7#LifeSavers",
						"ttf": "http://fonts.gstatic.com/s/lifesavers/v7/_yRJoxB8KMO25_gswqItc50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lifesavers/v7/_yRJoxB8KMO25_gswqItc4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lifesavers/v7/_yRJoxB8KMO25_gswqItc44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Life Savers Bold\'",
						"\'LifeSavers-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lifesavers/v7/THQKqChyYUm97rNPVFdGGbFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=THQKqChyYUm97rNPVFdGGXtNmQEE9wZ6UZlmiISB1pg&skey=5d3096418c414e64&v=v7#LifeSavers",
						"ttf": "http://fonts.gstatic.com/s/lifesavers/v7/THQKqChyYUm97rNPVFdGGZ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/lifesavers/v7/THQKqChyYUm97rNPVFdGGTqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/lifesavers/v7/THQKqChyYUm97rNPVFdGGYlIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Lilita One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lilita One\'",
						"\'LilitaOne\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lilitaone/v5/4FUUC-PxqHfbmE-DcA6LXFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=4FUUC-PxqHfbmE-DcA6LXKWUboTb-jS2tyCOQMtm97g&skey=436433a343b15cb9&v=v5#LilitaOne",
						"ttf": "http://fonts.gstatic.com/s/lilitaone/v5/4FUUC-PxqHfbmE-DcA6LXC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/lilitaone/v5/4FUUC-PxqHfbmE-DcA6LXBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/lilitaone/v5/4FUUC-PxqHfbmE-DcA6LXPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Lily Script One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lily Script One\'",
						"\'LilyScriptOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lilyscriptone/v5/uPWsLVW8uiXqIBnE8ZwGPFuTgT7He_T1DF6rp02aEO4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uPWsLVW8uiXqIBnE8ZwGPOUK-EeIygXe5LAOHXDZOMs&skey=2f55726c24b3b131&v=v5#LilyScriptOne",
						"ttf": "http://fonts.gstatic.com/s/lilyscriptone/v5/uPWsLVW8uiXqIBnE8ZwGPO921tOcMok2fHawGmtxikA.ttf",
						"woff": "http://fonts.gstatic.com/s/lilyscriptone/v5/uPWsLVW8uiXqIBnE8ZwGPK3fkYX5z1QtDUdIWoaaD_k.woff",
						"woff2": "http://fonts.gstatic.com/s/lilyscriptone/v5/uPWsLVW8uiXqIBnE8ZwGPCJccsb45t3MJKcv5BJtrIs.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Limelight": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Limelight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/limelight/v8/kD_2YDkzv1rorNqQ2oFK5vY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kD_2YDkzv1rorNqQ2oFK5pbd9NUM7myrQQz30yPaGQ4&skey=5080ff57360a6ef&v=v8#Limelight",
						"ttf": "http://fonts.gstatic.com/s/limelight/v8/kD_2YDkzv1rorNqQ2oFK5qCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/limelight/v8/kD_2YDkzv1rorNqQ2oFK5j8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/limelight/v8/kD_2YDkzv1rorNqQ2oFK5ltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Linden Hill": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Linden Hill Italic\'",
						"\'LindenHill-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lindenhill/v7/OcS3bZcu8vJvIDH8Zic83qSxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=OcS3bZcu8vJvIDH8Zic83jGefNBPGWcFPRAoUX_lgLU&skey=72e8438e963e7135&v=v7#LindenHill",
						"ttf": "http://fonts.gstatic.com/s/lindenhill/v7/OcS3bZcu8vJvIDH8Zic83uLrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/lindenhill/v7/OcS3bZcu8vJvIDH8Zic83tkZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/lindenhill/v7/OcS3bZcu8vJvIDH8Zic83su2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Linden Hill Regular\'",
						"\'LindenHill-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lindenhill/v7/U7EN5b80-1Cl4i2bLpCYkmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=U7EN5b80-1Cl4i2bLpCYknNsigHlcrQGNV8nkUSFQfc&skey=404db9f030a19d7d&v=v7#LindenHill",
						"ttf": "http://fonts.gstatic.com/s/lindenhill/v7/U7EN5b80-1Cl4i2bLpCYkp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lindenhill/v7/U7EN5b80-1Cl4i2bLpCYkobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lindenhill/v7/U7EN5b80-1Cl4i2bLpCYko4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Lobster": {
		"category": "display",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lobster Regular\'",
						"\'Lobster-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lobster/v20/RbZDm27knEncUX6lPsjRBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=j6oWj_2FuMvwWoXYXnyDeA&skey=7ed805a363b4659c&v=v20#Lobster",
						"ttf": "http://fonts.gstatic.com/s/lobster/v20/TSDaXhyJuDJ-NBU0popSWA.ttf",
						"woff": "http://fonts.gstatic.com/s/lobster/v20/MWVf-Rwh4GLQVBEwbyI61Q.woff",
						"woff2": "http://fonts.gstatic.com/s/lobster/v20/cycBf3mfbGkh66G5NhszPQ.woff2"
					}
				}
			}
		},
		"version": "v20"
	},
	"Lobster Two": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Lobster Two Italic\'",
						"\'LobsterTwo-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lobstertwo/v10/Ul_16MSbfayQv1I4QhLEoKSxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ul_16MSbfayQv1I4QhLEoDGefNBPGWcFPRAoUX_lgLU&skey=12d377d29068b9b1&v=v10#LobsterTwo",
						"ttf": "http://fonts.gstatic.com/s/lobstertwo/v10/Ul_16MSbfayQv1I4QhLEoOLrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/lobstertwo/v10/Ul_16MSbfayQv1I4QhLEoNkZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/lobstertwo/v10/Ul_16MSbfayQv1I4QhLEoMu2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lobster Two Bold Italic\'",
						"\'LobsterTwo-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lobstertwo/v10/LEkN2_no_6kFvRfiBZ8xpNmkQI_kos-lIOeNt19QAas.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LEkN2_no_6kFvRfiBZ8xpPXRuyUpAA8tGJEYgFPFMx8&skey=eef0fabb91ce4c60&v=v10#LobsterTwo",
						"ttf": "http://fonts.gstatic.com/s/lobstertwo/v10/LEkN2_no_6kFvRfiBZ8xpGsGzsqhEorxQDpu60nfWEc.ttf",
						"woff": "http://fonts.gstatic.com/s/lobstertwo/v10/LEkN2_no_6kFvRfiBZ8xpARV2F9RPTaqyJ4QibDfkzM.woff",
						"woff2": "http://fonts.gstatic.com/s/lobstertwo/v10/LEkN2_no_6kFvRfiBZ8xpI9ObOXPY1wUIXqKtDjSdsY.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Lobster Two\'",
						"\'LobsterTwo\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lobstertwo/v10/Law3VVulBOoxyKPkrNsAaGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Law3VVulBOoxyKPkrNsAaHNsigHlcrQGNV8nkUSFQfc&skey=9608b5afa19726d9&v=v10#LobsterTwo",
						"ttf": "http://fonts.gstatic.com/s/lobstertwo/v10/Law3VVulBOoxyKPkrNsAaJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lobstertwo/v10/Law3VVulBOoxyKPkrNsAaIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lobstertwo/v10/Law3VVulBOoxyKPkrNsAaI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lobster Two Bold\'",
						"\'LobsterTwo-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lobstertwo/v10/bmdxOflBqMqjEC0-kGsIiLFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bmdxOflBqMqjEC0-kGsIiHtNmQEE9wZ6UZlmiISB1pg&skey=2e1deeaaffb8f661&v=v10#LobsterTwo",
						"ttf": "http://fonts.gstatic.com/s/lobstertwo/v10/bmdxOflBqMqjEC0-kGsIiJ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/lobstertwo/v10/bmdxOflBqMqjEC0-kGsIiDqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/lobstertwo/v10/bmdxOflBqMqjEC0-kGsIiIlIZu-HDpmDIZMigmsroc4.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Londrina Outline": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Londrina Outline Regular\'",
						"\'LondrinaOutline-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinaoutline/v8/lls08GOa1eT74p072l1AWMwgXoeKbFEsHXKZLH4_qvs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lls08GOa1eT74p072l1AWKcFFcMam07fCGeuAp8QWaw&skey=38835ee470879933&v=v8#LondrinaOutline",
						"ttf": "http://fonts.gstatic.com/s/londrinaoutline/v8/lls08GOa1eT74p072l1AWK3zAIRJwSgnq8SMHmx0gDM.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinaoutline/v8/lls08GOa1eT74p072l1AWIbjUz88PNg0W9hW3hMAdPY.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinaoutline/v8/lls08GOa1eT74p072l1AWBCZXg0m4hDSRdK3Azz9xfo.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Londrina Shadow": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Londrina Shadow Regular\'",
						"\'LondrinaShadow-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinashadow/v6/dNYuzPS_7eYgXFJBzMoKdX4tKFgeIk23R_7gdu3xg3s.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dNYuzPS_7eYgXFJBzMoKdROEdKRfNDtLCrOQQ5oV0TQ&skey=4723605030a4e1cf&v=v6#LondrinaShadow",
						"ttf": "http://fonts.gstatic.com/s/londrinashadow/v6/dNYuzPS_7eYgXFJBzMoKdaOkbOmksxIvkTpnFpf9ZWE.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinashadow/v6/dNYuzPS_7eYgXFJBzMoKdf8mOSX00gsdbtRvMGBBXNY.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinashadow/v6/dNYuzPS_7eYgXFJBzMoKdUnV9jeMfjBdSIFJtVn-Kw8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Londrina Sketch": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Londrina Sketch Regular\'",
						"\'LondrinaSketch-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinasketch/v6/p7Ai06aT1Ycp_D2fyE3z60zLAvf3YIaTvHAjRrVaC80.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=p7Ai06aT1Ycp_D2fyE3z6_2ydBdfVPbTG2gtgByCKpc&skey=78e4e140da7b30f1&v=v6#LondrinaSketch",
						"ttf": "http://fonts.gstatic.com/s/londrinasketch/v6/p7Ai06aT1Ycp_D2fyE3z63eO7EMSL5l8Ppwuor2Ykkw.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinasketch/v6/p7Ai06aT1Ycp_D2fyE3z672lvfcOKwm3BZAZrcvcPTU.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinasketch/v6/p7Ai06aT1Ycp_D2fyE3z6y5aYq5uGjl-6DG0JxtWio4.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Londrina Solid": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"100": {
					"local": [
						"\'Londrina Solid Thin\'",
						"\'LondrinaSolid-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinasolid/v6/GNw2ckl4GiWuueFb9dMt4om0J-DLXEjoQ8t4RPXP4z8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GNw2ckl4GiWuueFb9dMt4hLCr67gRoj7Sgq4fCS0kXo&skey=91d88a75af341b60&v=v6#LondrinaSolid",
						"ttf": "http://fonts.gstatic.com/s/londrinasolid/v6/GNw2ckl4GiWuueFb9dMt4iFm01FecEEVN1OHTa7Xqmo.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinasolid/v6/GNw2ckl4GiWuueFb9dMt4tf0akbIwdJXrUr7MPR6jr4.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinasolid/v6/GNw2ckl4GiWuueFb9dMt4iJCVr1jXqF8RWrNTZe2LAQ.woff2"
					}
				},
				"300": {
					"local": [
						"\'Londrina Solid Light\'",
						"\'LondrinaSolid-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1TvC9LDVPWAcvK9wnIMNcbg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BDKo9ty0kfh66weuamkY1eOlQXhXVu0gX0grEFkw1uA&skey=88df0a883ee1eca7&v=v6#LondrinaSolid",
						"ttf": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1Xgr5v5Ox56qM-vQm6zg-eE.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1QWcivtuebaWtDTunBfpWVE.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1W2Qi_mlfihYGiiEYNsH1MI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Londrina Solid Regular\'",
						"\'LondrinaSolid-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinasolid/v6/yysorIEiYSBb0ylZjg791MTHJmA_LQ0BdIKqaOcwozg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=yysorIEiYSBb0ylZjg791HLVq4sAu1P4dcodMfsMe9c&skey=326ae8157bfb39d5&v=v6#LondrinaSolid",
						"ttf": "http://fonts.gstatic.com/s/londrinasolid/v6/yysorIEiYSBb0ylZjg791KtNCIApMuPbUOMNCDUzMbE.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinasolid/v6/yysorIEiYSBb0ylZjg791Or7NmWjaFpdDH7zur_b4wE.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinasolid/v6/yysorIEiYSBb0ylZjg791Ivhzy55JoPCEdD4PtayP2Y.woff2"
					}
				},
				"900": {
					"local": [
						"\'Londrina Solid Black\'",
						"\'LondrinaSolid-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1VuL55NzlYo78YvRxv6to_U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BDKo9ty0kfh66weuamkY1UfdDxzqDpQ01EdULeJhSXc&skey=bd32d771db6c96a5&v=v6#LondrinaSolid",
						"ttf": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1Qq_IYeN4gaOBZBvo6pE7GU.ttf",
						"woff": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1SUcwCQrJCSCliGcU4rDT6o.woff",
						"woff2": "http://fonts.gstatic.com/s/londrinasolid/v6/BDKo9ty0kfh66weuamkY1bqCKdi2-f3QVPMT7_3_9eI.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Lora": {
		"category": "serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Lora Italic\'",
						"\'Lora-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lora/v12/EJ2E0VlN4DLy-wT0t9nagw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Hm0XuTrgQw0KWgYD2kG1hw&skey=92aaeeb853a906d8&v=v12#Lora",
						"ttf": "http://fonts.gstatic.com/s/lora/v12/DeoOq1kX9ExfArSHppos_g.ttf",
						"woff": "http://fonts.gstatic.com/s/lora/v12/wXeMvRh7Gui36p_I04Ex6g.woff",
						"woff2": "http://fonts.gstatic.com/stats/Lora/italic/400"
					}
				},
				"700": {
					"local": [
						"\'Lora Bold Italic\'",
						"\'Lora-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lora/v12/_IxjUs2lbQSu0MyFEAfa7fY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_IxjUs2lbQSu0MyFEAfa7Zbd9NUM7myrQQz30yPaGQ4&skey=71d8bf5f591a2952&v=v12#Lora",
						"ttf": "http://fonts.gstatic.com/s/lora/v12/_IxjUs2lbQSu0MyFEAfa7aCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/lora/v12/_IxjUs2lbQSu0MyFEAfa7T8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/lora/v12/_IxjUs2lbQSu0MyFEAfa7VtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Lora Regular\'",
						"\'Lora-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lora/v12/rMDaOpSw-8ss9B8Y3bLqyA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=b9Q3-ov7xEcW76ymki76Ag&skey=1d294b6d956fb8e&v=v12#Lora",
						"ttf": "http://fonts.gstatic.com/s/lora/v12/4A-myfZX6oDr9CtSTkTGig.ttf",
						"woff": "http://fonts.gstatic.com/s/lora/v12/5-AYViExptypIdFoLKAxTA.woff",
						"woff2": "http://fonts.gstatic.com/s/lora/v12/4vqKRIwnQQGUQQh-PnvdMA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lora Bold\'",
						"\'Lora-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lora/v12/1HJZfNlOezBHPPwzRKlEcQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zqoBbCqeaofBZQ-8-sdxfQ&skey=6a30ff590836b94c&v=v12#Lora",
						"ttf": "http://fonts.gstatic.com/s/lora/v12/rapsGf8n-DpRu9kcmAAciA.ttf",
						"woff": "http://fonts.gstatic.com/s/lora/v12/XpaepWHcooQHSRnzoohUng.woff",
						"woff2": "http://fonts.gstatic.com/s/lora/v12/P18Nsu9EiYldSvHIj_0e5w.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Love Ya Like A Sister": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Love Ya Like A Sister Regular\'",
						"\'LoveYaLikeASister-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/loveyalikeasister/v8/LzkxWS-af0Br2Sk_YgSJY-XW2V78Vc328_Q6mNTiXpA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LzkxWS-af0Br2Sk_YgSJYwOzpiiji6StTjgpFYrv9g0&skey=e817d1706a6a9534&v=v8#LoveYaLikeASister",
						"ttf": "http://fonts.gstatic.com/s/loveyalikeasister/v8/LzkxWS-af0Br2Sk_YgSJY6XrD0ew9-Ooe_pdZm-U6E0.ttf",
						"woff": "http://fonts.gstatic.com/s/loveyalikeasister/v8/LzkxWS-af0Br2Sk_YgSJY5HSI-O7NEBdNbD5SV3GSEY.woff",
						"woff2": "http://fonts.gstatic.com/s/loveyalikeasister/v8/LzkxWS-af0Br2Sk_YgSJY9N6oT7VVZB_kATuDWj1CMI.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Loved by the King": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Loved by the King\'",
						"\'LovedbytheKing\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lovedbytheking/v7/wg03xD4cWigj4YDufLBSryLa3ihe9LR-DKneXrhUwXo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wg03xD4cWigj4YDufLBSr9rgKgyDsumZahddTx9pNhY&skey=1a4fc96377c36468&v=v7#LovedbytheKing",
						"ttf": "http://fonts.gstatic.com/s/lovedbytheking/v7/wg03xD4cWigj4YDufLBSrx3JsGi6SJNEbUJOQz-M1ZI.ttf",
						"woff": "http://fonts.gstatic.com/s/lovedbytheking/v7/wg03xD4cWigj4YDufLBSr8SuHxUvEE05hEBp-kiqXZE.woff",
						"woff2": "http://fonts.gstatic.com/s/lovedbytheking/v7/wg03xD4cWigj4YDufLBSr9woFbLbuLEdRex7vj8Wo-A.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Lovers Quarrel": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lovers Quarrel\'",
						"\'LoversQuarrel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/loversquarrel/v5/gipdZ8b7pKb89MzQLAtJHM3qGx3rAnZTdOzbwjeHLpo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=gipdZ8b7pKb89MzQLAtJHNM8oEu9aSYISkCdgMn7_vE&skey=cdda454064e235c&v=v5#LoversQuarrel",
						"ttf": "http://fonts.gstatic.com/s/loversquarrel/v5/gipdZ8b7pKb89MzQLAtJHFt2Ly3LHbCkhKMo5S7tnV8.ttf",
						"woff": "http://fonts.gstatic.com/s/loversquarrel/v5/gipdZ8b7pKb89MzQLAtJHGjFZxIsbLQU7tGBbP55JRc.woff",
						"woff2": "http://fonts.gstatic.com/s/loversquarrel/v5/gipdZ8b7pKb89MzQLAtJHLF0-phgDkzC9vTS9eJ1NkI.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Luckiest Guy": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Luckiest Guy Regular\'",
						"\'LuckiestGuy-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/luckiestguy/v8/5718gH8nDy3hFVihOpkY5HZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5718gH8nDy3hFVihOpkY5FlIn5tFQcqMuf-jhyJP0ps&skey=d0ebdb8b75d1ec15&v=v8#LuckiestGuy",
						"ttf": "http://fonts.gstatic.com/s/luckiestguy/v8/5718gH8nDy3hFVihOpkY5InF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/luckiestguy/v8/5718gH8nDy3hFVihOpkY5HhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/luckiestguy/v8/5718gH8nDy3hFVihOpkY5Ogdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Lusitana": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lusitana\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lusitana/v5/SB01Ui_upw3zZgl_0AW_0PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_jNN0LejTugN-1KB5Yj7gvesZW2xOQ-xsNqO47m55DA&skey=e5d445850c40840d&v=v5#Lusitana",
						"ttf": "http://fonts.gstatic.com/s/lusitana/v5/Q7EtAWlDLyjrIIFdmxKqN_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/lusitana/v5/tAIvAkRzqMJf8Y4fM1R7PfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/lusitana/v5/h_1ZjHXv2tOhJGwbefP69vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Lusitana Bold\'",
						"\'Lusitana-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lusitana/v5/oCjlVB3OWc0D00Ervq8JG2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oCjlVB3OWc0D00Ervq8JG3NsigHlcrQGNV8nkUSFQfc&skey=b4d27e82eab80c53&v=v5#Lusitana",
						"ttf": "http://fonts.gstatic.com/s/lusitana/v5/oCjlVB3OWc0D00Ervq8JG50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/lusitana/v5/oCjlVB3OWc0D00Ervq8JG4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/lusitana/v5/oCjlVB3OWc0D00Ervq8JG44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Lustria": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Lustria\'",
						"\'Lustria-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/lustria/v5/BDKp-6-mb1rnrgQPeiA55A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=G_MvTVFTh7iH9sbh-hW4aw&skey=96618de0c5a22579&v=v5#Lustria",
						"ttf": "http://fonts.gstatic.com/s/lustria/v5/QyVNcCmUrUslU5SaKum0hA.ttf",
						"woff": "http://fonts.gstatic.com/s/lustria/v5/jxv7sa1tHLjuAOuAPVunGw.woff",
						"woff2": "http://fonts.gstatic.com/s/lustria/v5/P1zvvbOqCVCJzgypDg3MKw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Macondo": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Macondo\'",
						"\'Macondo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/macondo/v6/wtK5eVyILkuaG2TyFFjsfg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zgQjvoPdQalfF861rPTvHA&skey=bce4653b1a95478b&v=v6#Macondo",
						"ttf": "http://fonts.gstatic.com/s/macondo/v6/wijdXSTMZhcyWspsnqogsw.ttf",
						"woff": "http://fonts.gstatic.com/s/macondo/v6/HjS8WhNDYHV6n3FW4jBIww.woff",
						"woff2": "http://fonts.gstatic.com/s/macondo/v6/fX2_Pkxo2kh5MjAeOVmsxg.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Macondo Swash Caps": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Macondo Swash Caps\'",
						"\'MacondoSwashCaps-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/macondoswashcaps/v5/SsSR706z-MlvEH7_LS6JAPjegRLahknHdvZHGLYrslk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SsSR706z-MlvEH7_LS6JAFBUL1R_8HikRPxCcG29f4Q&skey=e481c3cce08b10c0&v=v5#MacondoSwashCaps",
						"ttf": "http://fonts.gstatic.com/s/macondoswashcaps/v5/SsSR706z-MlvEH7_LS6JANDIXjupM9NDeWnIi0O_hZs.ttf",
						"woff": "http://fonts.gstatic.com/s/macondoswashcaps/v5/SsSR706z-MlvEH7_LS6JAOSDC2jTrcFnxhGet2QLr3g.woff",
						"woff2": "http://fonts.gstatic.com/s/macondoswashcaps/v5/SsSR706z-MlvEH7_LS6JAPL0dWkwMqAinnMVaAgLtdw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Mada": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"arabic",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Mada ExtraLight\'",
						"\'Mada-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/leEVHxplppz8ZeDILUX9pw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RgWDF9lBV5XjKlE5F5nwpQ&skey=c5595ee0db1eebd2&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/A4mEKl6qQ5I9XFWahRQCeQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/6lZ6TA069IB1v2j2unzZNA.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/5uaGltgFDAflV-yBZLfJTQ.woff2"
					}
				},
				"300": {
					"local": [
						"\'Mada Light\'",
						"\'Mada-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/1v20DeCoRxKcZ_thPX4dyw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=qYfv2Lm232zTUgZJaKnBFQ&skey=f8e2afa6af414101&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/hGQI4s6nbiJXW--VK6C1UA.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/ORNGpU7k-513g-ZmyYNUMw.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/Ua7EYjkkqzoa7XCK4W9n9g.woff2"
					}
				},
				"400": {
					"local": [
						"\'Mada Regular\'",
						"\'Mada-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/5WqPfCXMmda88L7-hIJr-g.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bi7VGNNKDPu2JyMgkOuxLw&skey=5d0f924e6baf8e8f&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/GWWDviP3jDHi2JloLuNfKg.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/LRtAg3ziP_U-2_zWcXC2Eg.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/4hbeUwgP_ZLmtOpiH4DXRA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mada Medium\'",
						"\'Mada-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/y4Rk7gd1o-0KtSvd_dQZOA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=D3jaCPnpaVwHLEBYvUC_og&skey=379f582382d03f4f&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/YYmJZ2kdAlIzEb0sDRYavQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/Wjr9P1vRPGow7zxf4rH3Mg.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/J5D5ndN1qc0Sc1nZImAttw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Mada SemiBold\'",
						"\'Mada-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/mAQckKbMBzkTJvnXJcG1wg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zKyv_hTwCEXsbtigJxjZeA&skey=35eb060b2de51ad7&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/Epmm_23zaklfPj87RDBvoQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/K-SpZLxTNrR4YWZphJo8UQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/WKFcXXnV6JetFCfRogMJlQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mada Bold\'",
						"\'Mada-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/NNdxL4CYExPdE9cNtoBcIw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=40RQBiIWMtz4tXWqym1wyA&skey=86ddfef69a043960&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/Ci3PqQqyx-P3jPqwqHKF-w.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/Syw4OnlIzpwmnKjTIIHmkQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/fzL3EWBgdv9cBdADnmY2iA.woff2"
					}
				},
				"900": {
					"local": [
						"\'Mada Black\'",
						"\'Mada-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mada/v4/oeFaFz8vqSobEDPIAKz_jw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LtI9faOlZcmtAeMv2fJmQA&skey=13b9c8de71716e3d&v=v4#Mada",
						"ttf": "http://fonts.gstatic.com/s/mada/v4/ubzO7AoYlG_IgtXM7iblmw.ttf",
						"woff": "http://fonts.gstatic.com/s/mada/v4/J5IkhneA7qWKcFPtCChDSA.woff",
						"woff2": "http://fonts.gstatic.com/s/mada/v4/AI32djEW634klqLBD6QN2A.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Magra": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Magra\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/magra/v5/_6WnlO2G4O4gonXmgTBqhg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1ecNXIl0RMBZU0VHBJ3_jg&skey=9abba3c66818028c&v=v5#Magra",
						"ttf": "http://fonts.gstatic.com/s/magra/v5/9Un71ABfeNOHeQITcqWzew.ttf",
						"woff": "http://fonts.gstatic.com/s/magra/v5/1uj9cdpjAK0H5tD02KSgRw.woff",
						"woff2": "http://fonts.gstatic.com/s/magra/v5/-wPj8-vsLD6WTxJ-_B2-uQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Magra Bold\'",
						"\'Magra-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/magra/v5/POtvnTtw-SQJbZx0VI4qHfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=g0m-m06N6cQEH8vnuy23IPesZW2xOQ-xsNqO47m55DA&skey=26cb1ea4207d004&v=v5#Magra",
						"ttf": "http://fonts.gstatic.com/s/magra/v5/6OzDW13XFRPJCe6trC1im_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/magra/v5/YlhLowBXAVg7FJcSC0CClfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/magra/v5/8BaUuFn7WfG0gojLcHvWofesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Maiden Orange": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Maiden Orange Regular\'",
						"\'MaidenOrange-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maidenorange/v8/ZhKIA2SPisEwdhW7g0RUWsOV-75E7mII8OPOWd5roDg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZhKIA2SPisEwdhW7g0RUWjyKAGS2js9R2mTcvyyc0eU&skey=bc673e1da07006c9&v=v8#MaidenOrange",
						"ttf": "http://fonts.gstatic.com/s/maidenorange/v8/ZhKIA2SPisEwdhW7g0RUWibsRidxnYrfzLNRqJkHfFo.ttf",
						"woff": "http://fonts.gstatic.com/s/maidenorange/v8/ZhKIA2SPisEwdhW7g0RUWvn8qdNnd5eCmWXua5W-n7c.woff",
						"woff2": "http://fonts.gstatic.com/s/maidenorange/v8/ZhKIA2SPisEwdhW7g0RUWjxObtw73-qQgbr7Be51v5c.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Maitree": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Maitree ExtraLight\'",
						"\'Maitree-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/EZukaZJ9yoSZwWbv6qFtQlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EZukaZJ9yoSZwWbv6qFtQqWUboTb-jS2tyCOQMtm97g&skey=3038b1c661a551ae&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/EZukaZJ9yoSZwWbv6qFtQi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/EZukaZJ9yoSZwWbv6qFtQhsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/EZukaZJ9yoSZwWbv6qFtQvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"300": {
					"local": [
						"\'Maitree Light\'",
						"\'Maitree-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/nt0QQg7INN46DXmZQi8RT1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nt0QQg7INN46DXmZQi8RT6WUboTb-jS2tyCOQMtm97g&skey=734bb18926fba8dc&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/nt0QQg7INN46DXmZQi8RTy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/nt0QQg7INN46DXmZQi8RTxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/nt0QQg7INN46DXmZQi8RT_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"400": {
					"local": [
						"\'Maitree\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/87o9uMzlPJDKJka6o06D0w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=26oOMkkuQUoZLKpjGeB2nQ&skey=762eb1b170e72cb3&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/OXg9cntzzduR1s4TEF-vbQ.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/tpX2ck9AGzVgYj9iY3FIzg.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/7hi-mk3vpYTVambUZZETVA.woff2"
					}
				},
				"500": {
					"local": [
						"\'Maitree Medium\'",
						"\'Maitree-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/AF3k8yUfHeOOEh1yPP7MWVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AF3k8yUfHeOOEh1yPP7MWaWUboTb-jS2tyCOQMtm97g&skey=33968a24a966ef28&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/AF3k8yUfHeOOEh1yPP7MWS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/AF3k8yUfHeOOEh1yPP7MWRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/AF3k8yUfHeOOEh1yPP7MWfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Maitree SemiBold\'",
						"\'Maitree-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/T7qE-uSm4hLkKORwR0t5S1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=T7qE-uSm4hLkKORwR0t5S6WUboTb-jS2tyCOQMtm97g&skey=7218daf92f402559&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/T7qE-uSm4hLkKORwR0t5Sy3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/T7qE-uSm4hLkKORwR0t5SxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/T7qE-uSm4hLkKORwR0t5S_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Maitree Bold\'",
						"\'Maitree-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/maitree/v2/P-HydeqfqSxrhj88sjkSFFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=P-HydeqfqSxrhj88sjkSFKWUboTb-jS2tyCOQMtm97g&skey=8ce5182ec735cec5&v=v2#Maitree",
						"ttf": "http://fonts.gstatic.com/s/maitree/v2/P-HydeqfqSxrhj88sjkSFC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/maitree/v2/P-HydeqfqSxrhj88sjkSFBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/maitree/v2/P-HydeqfqSxrhj88sjkSFPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Mako": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mako\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mako/v8/W8CZWCFkiKwpX83UJ2y78A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=KzIiAQDEhXOWkvZW5gxdIw&skey=c52d723c8275c271&v=v8#Mako",
						"ttf": "http://fonts.gstatic.com/s/mako/v8/cEqoveWhAOsq4j2QPMUWZA.ttf",
						"woff": "http://fonts.gstatic.com/s/mako/v8/o_a1a_7ly-bxb26LESxgxQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mako/v8/lNRcc4Y-G2HYpxCG1IrXlA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Mallanna": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mallanna\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mallanna/v5/b6jyh5J3f-Nfy9DND_Pf6_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_sG_DKRm4MQIoiCjlPgECvesZW2xOQ-xsNqO47m55DA&skey=1cbb48e2a8964ae5&v=v5#Mallanna",
						"ttf": "http://fonts.gstatic.com/s/mallanna/v5/JB3kmVLpnvCQMguM1t5KufesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mallanna/v5/W0DzuyYu1grdplSti4gE3_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mallanna/v5/T4Bhcih2Q8J3I7nEvpWq1_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Mandali": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin",
			"telugu"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mandali\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mandali/v5/WSVRw5LAOOvZOBhdX4kNGQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=S26P0MsFmnV4jlV94hpSsA&skey=9c05afd86886abb8&v=v5#Mandali",
						"ttf": "http://fonts.gstatic.com/s/mandali/v5/AtMlpxuYD1mBMyRr4zGx8g.ttf",
						"woff": "http://fonts.gstatic.com/s/mandali/v5/9NVsTTa0lunWvHOjr6FdNQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mandali/v5/SC2nNkpbQk83rMQ8SlqC8A.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Manuale": {
		"category": "serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Manuale Italic\'",
						"\'Manuale-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/xZ9C1Yri1LjAbXXQlZqtsvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xZ9C1Yri1LjAbXXQlZqtspbd9NUM7myrQQz30yPaGQ4&skey=d23698bab7e8d4c&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/xZ9C1Yri1LjAbXXQlZqtsqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/xZ9C1Yri1LjAbXXQlZqtsj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/xZ9C1Yri1LjAbXXQlZqtsltXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Manuale Medium Italic\'",
						"\'Manuale-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/r4TYrL7JhyPxpmVA-JAN0XZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=r4TYrL7JhyPxpmVA-JAN0VlIn5tFQcqMuf-jhyJP0ps&skey=22b9c51a91e32cfa&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/r4TYrL7JhyPxpmVA-JAN0YnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/r4TYrL7JhyPxpmVA-JAN0XhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/r4TYrL7JhyPxpmVA-JAN0egdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"600": {
					"local": [
						"\'Manuale SemiBold Italic\'",
						"\'Manuale-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/n25GBfdDLxRFJ-OYtzyorXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=n25GBfdDLxRFJ-OYtzyorVlIn5tFQcqMuf-jhyJP0ps&skey=bc2f11adbaa17a37&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/n25GBfdDLxRFJ-OYtzyorYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/n25GBfdDLxRFJ-OYtzyorXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/n25GBfdDLxRFJ-OYtzyoregdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Manuale Bold Italic\'",
						"\'Manuale-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/Lrka5WC7aKfhIA6uk-QS63Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Lrka5WC7aKfhIA6uk-QS61lIn5tFQcqMuf-jhyJP0ps&skey=77508a5ae73bee14&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/Lrka5WC7aKfhIA6uk-QS64nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/Lrka5WC7aKfhIA6uk-QS63hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/Lrka5WC7aKfhIA6uk-QS6-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Manuale Regular\'",
						"\'Manuale-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/Q-efJhWFeB3-0NoDv1qdGw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TSM3DV1gIno1PSAJAUhTpg&skey=ea5c2e1eec98b791&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/IuS6iXekC8R_Gf-u-sfUVw.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/j41XyTaJF5obdbPsy_BeCg.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/KtEOzloOGazY5P4LpaA9Gg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Manuale Medium\'",
						"\'Manuale-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/GZn6alYH9yBnVdjHf580clQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GZn6alYH9yBnVdjHf580cqWUboTb-jS2tyCOQMtm97g&skey=3a0e7306ace6ed8a&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/GZn6alYH9yBnVdjHf580ci3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/GZn6alYH9yBnVdjHf580chsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/GZn6alYH9yBnVdjHf580cvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Manuale SemiBold\'",
						"\'Manuale-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/-1zNbtzePZeDhwEh9NB0wlQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-1zNbtzePZeDhwEh9NB0wqWUboTb-jS2tyCOQMtm97g&skey=11ad0706793aa48f&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/-1zNbtzePZeDhwEh9NB0wi3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/-1zNbtzePZeDhwEh9NB0whsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/-1zNbtzePZeDhwEh9NB0wvk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"700": {
					"local": [
						"\'Manuale Bold\'",
						"\'Manuale-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/manuale/v2/Pkv6Rg7otirtHMSxkQZxk1QlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Pkv6Rg7otirtHMSxkQZxk6WUboTb-jS2tyCOQMtm97g&skey=24493e4a5aade7d7&v=v2#Manuale",
						"ttf": "http://fonts.gstatic.com/s/manuale/v2/Pkv6Rg7otirtHMSxkQZxky3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/manuale/v2/Pkv6Rg7otirtHMSxkQZxkxsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/manuale/v2/Pkv6Rg7otirtHMSxkQZxk_k_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Marcellus": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Marcellus\'",
						"\'Marcellus-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marcellus/v5/FJNab1jzp1t7ctjNl8ugHPY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FJNab1jzp1t7ctjNl8ugHJbd9NUM7myrQQz30yPaGQ4&skey=568fa7803239da82&v=v5#Marcellus",
						"ttf": "http://fonts.gstatic.com/s/marcellus/v5/FJNab1jzp1t7ctjNl8ugHKCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/marcellus/v5/FJNab1jzp1t7ctjNl8ugHD8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/marcellus/v5/FJNab1jzp1t7ctjNl8ugHFtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Marcellus SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Marcellus SC\'",
						"\'MarcellusSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marcellussc/v5/_jugwxhkkynrvsfrxVx8gXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_jugwxhkkynrvsfrxVx8gVlIn5tFQcqMuf-jhyJP0ps&skey=19614411fccd2107&v=v5#MarcellusSC",
						"ttf": "http://fonts.gstatic.com/s/marcellussc/v5/_jugwxhkkynrvsfrxVx8gYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/marcellussc/v5/_jugwxhkkynrvsfrxVx8gXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/marcellussc/v5/_jugwxhkkynrvsfrxVx8gegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Marck Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Marck Script\'",
						"\'MarckScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marckscript/v8/O_D1NAZVOFOobLbVtW3bcnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=O_D1NAZVOFOobLbVtW3bcllIn5tFQcqMuf-jhyJP0ps&skey=5f8a9188ebf1b8e9&v=v8#MarckScript",
						"ttf": "http://fonts.gstatic.com/s/marckscript/v8/O_D1NAZVOFOobLbVtW3bconF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/marckscript/v8/O_D1NAZVOFOobLbVtW3bcnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/marckscript/v8/O_D1NAZVOFOobLbVtW3bcugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Margarine": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Margarine\'",
						"\'Margarine-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/margarine/v6/CmR2XZ3h63SwGzHu2hppFvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CmR2XZ3h63SwGzHu2hppFpbd9NUM7myrQQz30yPaGQ4&skey=8251c55bcd200727&v=v6#Margarine",
						"ttf": "http://fonts.gstatic.com/s/margarine/v6/CmR2XZ3h63SwGzHu2hppFqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/margarine/v6/CmR2XZ3h63SwGzHu2hppFj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/margarine/v6/CmR2XZ3h63SwGzHu2hppFltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Marko One": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Marko One\'",
						"\'MarkoOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/markoone/v7/H7XdNJTQdOeYNWDBnYKBH_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H7XdNJTQdOeYNWDBnYKBH5bd9NUM7myrQQz30yPaGQ4&skey=e278f874a6f63967&v=v7#MarkoOne",
						"ttf": "http://fonts.gstatic.com/s/markoone/v7/H7XdNJTQdOeYNWDBnYKBH6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/markoone/v7/H7XdNJTQdOeYNWDBnYKBHz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/markoone/v7/H7XdNJTQdOeYNWDBnYKBH1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Marmelad": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"cyrillic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Marmelad\'",
						"\'Marmelad-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marmelad/v7/RlA5R_y-sSITiQ6IRxyy2PesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=tusD8mqksbdtSdlsy4NSJ_esZW2xOQ-xsNqO47m55DA&skey=91be53246a2a25ed&v=v7#Marmelad",
						"ttf": "http://fonts.gstatic.com/s/marmelad/v7/kkvG0zg1nqKzOChG5DPiZfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/marmelad/v7/HM9p0JaHv5-HhbhN_csF8vesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/marmelad/v7/Tbti-8riliiBFfmL7Wrc8vesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Martel": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Martel UltraLight\'",
						"\'Martel-UltraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/AF3kHuTj62FVPhlgS6GHlfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AF3kHuTj62FVPhlgS6GHlZbd9NUM7myrQQz30yPaGQ4&skey=865a7af3f62c4b29&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/AF3kHuTj62FVPhlgS6GHlaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/AF3kHuTj62FVPhlgS6GHlT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/AF3kHuTj62FVPhlgS6GHlVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Martel Light\'",
						"\'Martel-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/ZUx51dRN9_HiNbAkioJkq_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZUx51dRN9_HiNbAkioJkq5bd9NUM7myrQQz30yPaGQ4&skey=3005143b04f7a910&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/ZUx51dRN9_HiNbAkioJkq6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/ZUx51dRN9_HiNbAkioJkqz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/ZUx51dRN9_HiNbAkioJkq1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Martel\'",
						"\'Martel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/V0ClSWavHP3NRkXsYvz8JQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Vpzo1gFi5R6KtlANy48Elw&skey=59fb7792dca42154&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/WrkUDaqKdjckleIAj4kA0A.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/4PPCE9EwwoOQIJsOaMVA6g.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/UqHF0_T0x2A12j9bgYu4DQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Martel DemiBold\'",
						"\'Martel-DemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/J84uzPhBG7tCNKZ2RNh2XfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=J84uzPhBG7tCNKZ2RNh2XZbd9NUM7myrQQz30yPaGQ4&skey=8f6259619cbf6f4f&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/J84uzPhBG7tCNKZ2RNh2XaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/J84uzPhBG7tCNKZ2RNh2XT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/J84uzPhBG7tCNKZ2RNh2XVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Martel Bold\'",
						"\'Martel-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/M6dENUXta91OJwGwgjQHf_Y6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=M6dENUXta91OJwGwgjQHf5bd9NUM7myrQQz30yPaGQ4&skey=ce0c9c4932e263d0&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/M6dENUXta91OJwGwgjQHf6CWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/M6dENUXta91OJwGwgjQHfz8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/M6dENUXta91OJwGwgjQHf1tXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Martel ExtraBold\'",
						"\'Martel-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/XqIfMD5bytoMz5eyG9a1BfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XqIfMD5bytoMz5eyG9a1BZbd9NUM7myrQQz30yPaGQ4&skey=54db9712fcce8986&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/XqIfMD5bytoMz5eyG9a1BaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/XqIfMD5bytoMz5eyG9a1BT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/XqIfMD5bytoMz5eyG9a1BVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Martel Heavy\'",
						"\'Martel-Heavy\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martel/v2/6qlcTvSyKvyk4OhhaCbMtvY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6qlcTvSyKvyk4OhhaCbMtpbd9NUM7myrQQz30yPaGQ4&skey=b49d7587e0fc5d49&v=v2#Martel",
						"ttf": "http://fonts.gstatic.com/s/martel/v2/6qlcTvSyKvyk4OhhaCbMtqCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/martel/v2/6qlcTvSyKvyk4OhhaCbMtj8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/martel/v2/6qlcTvSyKvyk4OhhaCbMtltXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Martel Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Martel Sans ExtraLight\'",
						"\'MartelSans-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQFT7wzIiOHIChIARuHOnLzM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQBZBgPlnpWaoq0SaX6doyAk&skey=d0af9b71547c102c&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQIk9RAFW3K6S6MTuxUiRJAk.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQNj3jEPHYvfoh7wL9kai_ws.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQP-yvr_zg92NT13uHB6uFCI.woff2"
					}
				},
				"300": {
					"local": [
						"\'Martel Sans Light\'",
						"\'MartelSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQLXcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQD4dnM32POWavC8T_whbZeI&skey=3e60cf58de23364a&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQLfB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQB_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQEo2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Martel Sans Regular\'",
						"\'MartelSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/0JYI5EzcfImaQg7kk9hBq2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0JYI5EzcfImaQg7kk9hBq3NsigHlcrQGNV8nkUSFQfc&skey=bc24a799253841ed&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/0JYI5EzcfImaQg7kk9hBq50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/0JYI5EzcfImaQg7kk9hBq4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/0JYI5EzcfImaQg7kk9hBq44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"600": {
					"local": [
						"\'Martel Sans SemiBold\'",
						"\'MartelSans-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQI8mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQOVmfClkf66xvxL1SWm4y8M&skey=896de8cd3fa71e6b&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQC8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQH5HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQF2umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Martel Sans Bold\'",
						"\'MartelSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQLFt29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQHtNmQEE9wZ6UZlmiISB1pg&skey=63578146eda7037f&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQJ_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQDqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQIlIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Martel Sans ExtraBold\'",
						"\'MartelSans-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQJhT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQEWkFefV8YEa5Z9BVNHdJ6k&skey=7172473d159f7ff5&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQFDMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQECDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQHibbpXgLHK_uTT48UMyjSM.woff2"
					}
				},
				"900": {
					"local": [
						"\'Martel Sans Black\'",
						"\'MartelSans-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQK8knJ7dcSpE9bYpElP8kOU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7ajme85aKKx_SCWF59ImQMTCo6WkuhWceGynHdPeLtc&skey=f36c0deceb3c5f20&v=v4#MartelSans",
						"ttf": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQBG4wFYO9UG-PxKqsSvMNyg.ttf",
						"woff": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQEExzZ44ka2Lr5i-x5aWr0E.woff",
						"woff2": "http://fonts.gstatic.com/s/martelsans/v4/7ajme85aKKx_SCWF59ImQMpPZoEQdaDZ3o3Np19rzJk.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Marvel": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Marvel Italic\'",
						"\'Marvel-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marvel/v7/MDGenUU7SkPokO3dMOMYxfesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0fctpxuZoYnX1ggKfaMYuPesZW2xOQ-xsNqO47m55DA&skey=2a8e91ba4420dbf4&v=v7#Marvel",
						"ttf": "http://fonts.gstatic.com/s/marvel/v7/ZVjbVGxgxZHqkWmob__FzvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/marvel/v7/J0cq0OkYfaWW0DXonfLChvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/marvel/v7/VBV-2FFdWZ4G6nEDL5-6o_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Marvel Bold Italic\'",
						"\'Marvel-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marvel/v7/ZpxYuSK5Q2HHLP6KTdxKxmfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZpxYuSK5Q2HHLP6KTdxKxnNsigHlcrQGNV8nkUSFQfc&skey=5857b1551737f8b5&v=v7#Marvel",
						"ttf": "http://fonts.gstatic.com/s/marvel/v7/ZpxYuSK5Q2HHLP6KTdxKxp0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/marvel/v7/ZpxYuSK5Q2HHLP6KTdxKxobN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/marvel/v7/ZpxYuSK5Q2HHLP6KTdxKxo4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Marvel\'",
						"\'Marvel-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marvel/v7/rQKzmESGGi6gyMeVaFWl9Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=TeoIDzR64HpNI8ZdZMWCBA&skey=52bf62c6b0bbc269&v=v7#Marvel",
						"ttf": "http://fonts.gstatic.com/s/marvel/v7/qaDmg_CNIuBGdKmH4z3spA.ttf",
						"woff": "http://fonts.gstatic.com/s/marvel/v7/L2PPfTze83vDMefumW3xvw.woff",
						"woff2": "http://fonts.gstatic.com/s/marvel/v7/789UQI4gZlFVSw9fHCriRQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Marvel Bold\'",
						"\'Marvel-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/marvel/v7/fdSK0BiCsJzg1JgCoZQLEfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fdSK0BiCsJzg1JgCoZQLEZbd9NUM7myrQQz30yPaGQ4&skey=552ff73ffe8c31bc&v=v7#Marvel",
						"ttf": "http://fonts.gstatic.com/s/marvel/v7/fdSK0BiCsJzg1JgCoZQLEaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/marvel/v7/fdSK0BiCsJzg1JgCoZQLET8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/marvel/v7/fdSK0BiCsJzg1JgCoZQLEVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Mate": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Mate Italic\'",
						"\'Mate-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mate/v6/ugE_3A2WMSg1F3GYxWa0Ew.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=iWBcbhVVMCBr7imXIjwjCg&skey=2841edb4ac82bfc&v=v6#Mate",
						"ttf": "http://fonts.gstatic.com/s/mate/v6/K2DQ3u-TNrTwP7mZLgVIuQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mate/v6/PTJ7JUcI70SaH4ySt1dAmQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mate/v6/4FR-xC8ypeqyJIcs63wpyg.woff2"
					}
				}
			},
			"normal": {
				"400": {
					"local": [
						"\'Mate-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mate/v6/iY1awm9qr9bSMTd39JAN2w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AMolwm-NbQz6pfK_1IJNug&skey=3809b241213e7468&v=v6#Mate",
						"ttf": "http://fonts.gstatic.com/s/mate/v6/O3zV_88y5R58JOkt-IGJYQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mate/v6/S8SUYNiDpYuON3fsSU0RXA.woff",
						"woff2": "http://fonts.gstatic.com/s/mate/v6/pEOeHflp-523HvK9p7__yw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Mate SC": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mate SC Regular\'",
						"\'MateSC-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/matesc/v6/HpoOirewdipiHM1ex0fdQQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Kx5S3Vk1S9hNRWv3KzOCuw&skey=9d865f50b2871cd&v=v6#MateSC",
						"ttf": "http://fonts.gstatic.com/s/matesc/v6/I5XqnZRc6OFZZn87UIu4Rg.ttf",
						"woff": "http://fonts.gstatic.com/s/matesc/v6/grxTPGLZGD5FSza5-lmr7A.woff",
						"woff2": "http://fonts.gstatic.com/s/matesc/v6/hIIBlsrjcPqew75YPwo73w.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Maven Pro": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Maven Pro Regular\'",
						"\'MavenPro-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mavenpro/v11/MG9KbUZFchDs94Tbv9U-pfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MG9KbUZFchDs94Tbv9U-pZbd9NUM7myrQQz30yPaGQ4&skey=f795ffecfc1ee92e&v=v11#MavenPro",
						"ttf": "http://fonts.gstatic.com/s/mavenpro/v11/MG9KbUZFchDs94Tbv9U-paCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/mavenpro/v11/MG9KbUZFchDs94Tbv9U-pT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/mavenpro/v11/MG9KbUZFchDs94Tbv9U-pVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Maven Pro Medium\'",
						"\'MavenPro-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mavenpro/v11/SQVfzoJBbj9t3aVcmbspRnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=SQVfzoJBbj9t3aVcmbspRllIn5tFQcqMuf-jhyJP0ps&skey=3342e25ad2760db8&v=v11#MavenPro",
						"ttf": "http://fonts.gstatic.com/s/mavenpro/v11/SQVfzoJBbj9t3aVcmbspRonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/mavenpro/v11/SQVfzoJBbj9t3aVcmbspRnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/mavenpro/v11/SQVfzoJBbj9t3aVcmbspRugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Maven Pro Bold\'",
						"\'MavenPro-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mavenpro/v11/uDssvmXgp7Nj3i336k_dSnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uDssvmXgp7Nj3i336k_dSllIn5tFQcqMuf-jhyJP0ps&skey=cdea2724661b597d&v=v11#MavenPro",
						"ttf": "http://fonts.gstatic.com/s/mavenpro/v11/uDssvmXgp7Nj3i336k_dSonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/mavenpro/v11/uDssvmXgp7Nj3i336k_dSnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/mavenpro/v11/uDssvmXgp7Nj3i336k_dSugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"900": {
					"local": [
						"\'Maven Pro Black\'",
						"\'MavenPro-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mavenpro/v11/-91TwiFzqeL1F7Kh91APwXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-91TwiFzqeL1F7Kh91APwVlIn5tFQcqMuf-jhyJP0ps&skey=b2a4a68bb927b7b5&v=v11#MavenPro",
						"ttf": "http://fonts.gstatic.com/s/mavenpro/v11/-91TwiFzqeL1F7Kh91APwYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/mavenpro/v11/-91TwiFzqeL1F7Kh91APwXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/mavenpro/v11/-91TwiFzqeL1F7Kh91APwegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"McLaren": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'McLaren\'",
						"\'McLaren-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mclaren/v5/Bj5pof3Jaj0IRP0x_hAG7w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6j7A30mwc2-0TbqnBKNLpw&skey=7a52c350b8e180c0&v=v5#McLaren",
						"ttf": "http://fonts.gstatic.com/s/mclaren/v5/-P7NsxRFppnupVr6yhftQA.ttf",
						"woff": "http://fonts.gstatic.com/s/mclaren/v5/h-YmANpv0wVrTiywvwSdPg.woff",
						"woff2": "http://fonts.gstatic.com/s/mclaren/v5/kwCEtQyC8wAaIWU-tJRZ8w.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Meddon": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Meddon\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/meddon/v10/qqCayBh8VHD7oPSTa-hZCA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EsxJU3ydWEKFGe93oz92RA&skey=2e2bd3444edaf0dd&v=v10#Meddon",
						"ttf": "http://fonts.gstatic.com/s/meddon/v10/LBtF6u951HyCRvXimAqAbw.ttf",
						"woff": "http://fonts.gstatic.com/s/meddon/v10/dunLpE034rp-ugV97zpysQ.woff",
						"woff2": "http://fonts.gstatic.com/s/meddon/v10/jzY3vCZbiWT7kUlTdSSOaA.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"MedievalSharp": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'MedievalSharp\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/medievalsharp/v9/85X_PjV6tftJ0-rX7KYQkKhNXs_iBQjHPvGFFSVAEvo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=85X_PjV6tftJ0-rX7KYQkC_PTTZvT4qH4onCmu_IFu8&skey=1b167fec88e922f7&v=v9#MedievalSharp",
						"ttf": "http://fonts.gstatic.com/s/medievalsharp/v9/85X_PjV6tftJ0-rX7KYQkJIzTUwDeLjw6S9zIItvw4s.ttf",
						"woff": "http://fonts.gstatic.com/s/medievalsharp/v9/85X_PjV6tftJ0-rX7KYQkDeVYMoRQZQCFxxC3Gmetqw.woff",
						"woff2": "http://fonts.gstatic.com/s/medievalsharp/v9/85X_PjV6tftJ0-rX7KYQkDFDcN0xdsQK-F33XL-X7ko.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Medula One": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Medula One\'",
						"\'MedulaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/medulaone/v7/LoO8LDXpiOs8e6qJRLl2SVQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=LoO8LDXpiOs8e6qJRLl2SaWUboTb-jS2tyCOQMtm97g&skey=c097e94c5d7312b3&v=v7#MedulaOne",
						"ttf": "http://fonts.gstatic.com/s/medulaone/v7/LoO8LDXpiOs8e6qJRLl2SS3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/medulaone/v7/LoO8LDXpiOs8e6qJRLl2SRsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/medulaone/v7/LoO8LDXpiOs8e6qJRLl2Sfk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Meera Inimai": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"tamil",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Meera Inimai\'",
						"\'MeeraInimai-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/meerainimai/v2/fWbdJc2ZVZnWCi06NRCxD3Z2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fWbdJc2ZVZnWCi06NRCxD1lIn5tFQcqMuf-jhyJP0ps&skey=117d94e55359b521&v=v2#MeeraInimai",
						"ttf": "http://fonts.gstatic.com/s/meerainimai/v2/fWbdJc2ZVZnWCi06NRCxD4nF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/meerainimai/v2/fWbdJc2ZVZnWCi06NRCxD3hCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/meerainimai/v2/fWbdJc2ZVZnWCi06NRCxD-gdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Megrim": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Megrim\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/megrim/v8/1f5HoozKyYXswla7UhCq0A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-6J_vSaWI0ygNudra7ynng&skey=4589d61c1b6a14ca&v=v8#Megrim",
						"ttf": "http://fonts.gstatic.com/s/megrim/v8/JlLhrDdxVzh0R_XzRbjFhw.ttf",
						"woff": "http://fonts.gstatic.com/s/megrim/v8/wEAANqPdhC-qap-OX73FcA.woff",
						"woff2": "http://fonts.gstatic.com/s/megrim/v8/3QlnWQVA-dQyEeamqiHm2g.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Meie Script": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Meie Script\'",
						"\'MeieScript-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/meiescript/v5/lwxuZ_zJQzRwnOocgbPAFGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lwxuZ_zJQzRwnOocgbPAFHNsigHlcrQGNV8nkUSFQfc&skey=297719404a9b8887&v=v5#MeieScript",
						"ttf": "http://fonts.gstatic.com/s/meiescript/v5/lwxuZ_zJQzRwnOocgbPAFJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/meiescript/v5/lwxuZ_zJQzRwnOocgbPAFIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/meiescript/v5/lwxuZ_zJQzRwnOocgbPAFI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Merienda": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Merienda\'",
						"\'Merienda-Regular_0_wt\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merienda/v5/hLQGWY9xE9LLwIMg4tjgovesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=5SHccNCivGCq9QzTJgPo1vesZW2xOQ-xsNqO47m55DA&skey=410a1b360191e647&v=v5#Merienda",
						"ttf": "http://fonts.gstatic.com/s/merienda/v5/l_rcquZtIOJLfdlcJgi63fesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/merienda/v5/4NYVQDcgs3Fbi_xdFMC7lPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/merienda/v5/jzdtQ30m6V77-C5vjVpEXPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Merienda Bold\'",
						"\'Merienda-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merienda/v5/mbcww3uvDIvQ0VClREeMdGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=mbcww3uvDIvQ0VClREeMdHNsigHlcrQGNV8nkUSFQfc&skey=a49e06106180d9ee&v=v5#Merienda",
						"ttf": "http://fonts.gstatic.com/s/merienda/v5/mbcww3uvDIvQ0VClREeMdJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/merienda/v5/mbcww3uvDIvQ0VClREeMdIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/merienda/v5/mbcww3uvDIvQ0VClREeMdI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Merienda One": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Merienda One\'",
						"\'MeriendaOne-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/meriendaone/v8/bCA-uDdUx6nTO8SjzCLXvXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=bCA-uDdUx6nTO8SjzCLXvVlIn5tFQcqMuf-jhyJP0ps&skey=f1843075bb93f595&v=v8#MeriendaOne",
						"ttf": "http://fonts.gstatic.com/s/meriendaone/v8/bCA-uDdUx6nTO8SjzCLXvYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/meriendaone/v8/bCA-uDdUx6nTO8SjzCLXvXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/meriendaone/v8/bCA-uDdUx6nTO8SjzCLXvegdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Merriweather": {
		"category": "serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Merriweather Light Italic\'",
						"\'Merriweather-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwICH_XWDaITL6s384ufbsW_o.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EYh7Vl4ywhowqULgRdYwINv65-B3V1C1aB1PFKVs0gQ&skey=2127cbbec4112664&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIH3uxQAI1Bvm-GxtFNy4yl0.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIG0Xvi9kvVpeKmlONF1xhUs.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIHM1hBkL4m68a-ReB_y0NYc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Merriweather Italic\'",
						"\'Merriweather-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/So5lHxHT37p2SS4-t60SlDoGYR7Z3iWH66EXnaJoKgg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=So5lHxHT37p2SS4-t60SlH2UFnxWCzsMUZbVj2XRF5M&skey=899922b35e8afa66&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/So5lHxHT37p2SS4-t60SlCtfYakCkPqOMDce0h_3gD8.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/So5lHxHT37p2SS4-t60SlHpumDtkw9GHrrDfd7ZnWpU.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/So5lHxHT37p2SS4-t60SlBMBlNeli-0RcAdOFWWLdxQ.woff2"
					}
				},
				"700": {
					"local": [
						"\'Merriweather Bold Italic\'",
						"\'Merriweather-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwICy7jlJQNiTiB3-MejPw_5E.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EYh7Vl4ywhowqULgRdYwIOiOBN1C42tFdXFKJTGlCXo&skey=a01d7ebb04b59d3d&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwICxQL91WRy8t8mPvAX_dIgA.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIL0qgHI2SEqiJszC-CVc3gY.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIEcqRxak6Wc5LUVz-l064SE.woff2"
					}
				},
				"900": {
					"local": [
						"\'Merriweather Black Italic\'",
						"\'Merriweather-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIEtscAbO_UWeQlriesjXHjg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EYh7Vl4ywhowqULgRdYwIBYUabI77EJlL2OICNHIsFc&skey=6fbe01ac2b2dd35b&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIMEHn4duKYHaQWBe899DiqE.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIFrTzzUNIOd7dbe75kBQ0MM.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/EYh7Vl4ywhowqULgRdYwIN4rWrnaUG5GaGDO0TOZR8c.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Merriweather Light\'",
						"\'Merriweather-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6noySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZvcMqxEwPfh2qDWBPxn6nrJg1hA63dzswhy4NvEPrPM&skey=c2b76fd8ebf2629b&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6ngV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nmFp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nk4GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Merriweather Regular\'",
						"\'Merriweather-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/RFda8w1V0eDZheqfcyQ4EHZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=RFda8w1V0eDZheqfcyQ4EFlIn5tFQcqMuf-jhyJP0ps&skey=379c1eccf863c625&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/RFda8w1V0eDZheqfcyQ4EInF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/RFda8w1V0eDZheqfcyQ4EHhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/RFda8w1V0eDZheqfcyQ4EOgdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Merriweather Bold\'",
						"\'Merriweather-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nmmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZvcMqxEwPfh2qDWBPxn6ngay50PuN8loMJ9QAXsTs7U&skey=76f88370d7055e09&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nn06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nnl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nnNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				},
				"900": {
					"local": [
						"\'Merriweather Black\'",
						"\'Merriweather-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nl9iNfvTt1gMvrhy159_6ck.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ZvcMqxEwPfh2qDWBPxn6nnvlAbBC1RrJpyn549iFTvo&skey=879600b205c1760&v=v19#Merriweather",
						"ttf": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6nvzeo8SCrGyBsNQUDsw2Qr8.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6ngi3Hume1-TKjJz2lX0jYjo.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweather/v19/ZvcMqxEwPfh2qDWBPxn6ntDLwwZd-mS_8JqJ_KGXwxs.woff2"
					}
				}
			}
		},
		"version": "v19"
	},
	"Merriweather Sans": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"300": {
					"local": [
						"\'Merriweather Sans Light Italic\'",
						"\'MerriweatherSans-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVUj5MoXaAlgVrZoSSZbYcLk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nAqt4hiqwq3tzCecpgPmVfLkhS8sGo5YCj40BkrWvWg&skey=9b01c8cd69965e3e&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVZK-EqCRAgJ4DGsxXn5jo_s.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVX9UU5BmOJGkLxUCVv5VXdc.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVVyxQjJdVDgrQF1Nc7eshrI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Merriweather Sans Italic\'",
						"\'MerriweatherSans-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/3Mz4hOHzs2npRMG3B1ascT73cJzAx8H21t3siz5PJJM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3Mz4hOHzs2npRMG3B1ascWLjQhJN2InzDCEXlWgBuF0&skey=72a671c1f23a2f55&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/3Mz4hOHzs2npRMG3B1ascbearE5_VzBcjtDoaNr3b3c.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/3Mz4hOHzs2npRMG3B1ascf0KIgDhPIHb_R-SWdtqte8.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/3Mz4hOHzs2npRMG3B1ascefU2ka509O1odprhyXBUMU.woff2"
					}
				},
				"700": {
					"local": [
						"\'Merriweather Sans Bold Italic\'",
						"\'MerriweatherSans-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVQHKcHgsjoggO6IrKqD_mBM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nAqt4hiqwq3tzCecpgPmVc_JO2nlopTfM618HGSBb2M&skey=7feceef78736c4e8&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVQqfFxSJsGWORebWzQ_6S3g.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVYM8pfYvjMoOxygpzLVILAs.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVafo0sDQ75c9ExQ-26lwTdA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Merriweather Sans ExtraBold Italic\'",
						"\'MerriweatherSans-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVcH0I4tMsnbbth0OMeUPnb0.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nAqt4hiqwq3tzCecpgPmVdZSK4Zota1GH2Wh0i7eFOw&skey=c46cf4e59b4d7e5e&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVcn79XP5f7_gPslCYOZ5R-k.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVW2xy75WLVt7UI7Cycabsy8.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/nAqt4hiqwq3tzCecpgPmVfrUSW10CwTuVx9PepRx9ls.woff2"
					}
				}
			},
			"normal": {
				"300": {
					"local": [
						"\'Merriweather Sans Light\'",
						"\'MerriweatherSans-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowdYASHgfgyB7g8BNe7pvKXk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6LmGj5dOJopQKEkt88Gowf7gLAdE0g3W2xR_7qCivyo&skey=f2526645647a84ff&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowQNd2zpumJ3ZXdYPaAdqT7w.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowY_zIojJi0m4a5Z6tRh6itY.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowQaqY1RzDqUCoj4OhtiyHDU.woff2"
					}
				},
				"400": {
					"local": [
						"\'Merriweather Sans\'",
						"\'MerriweatherSans-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/AKu1CjQ4qnV8MUltkAX3sE2k4ogKuXZ6cvJ9G6hiscg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AKu1CjQ4qnV8MUltkAX3sBSsawf2cF_d9q9gtt4yBuk&skey=d5dbcab03e19f051&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/AKu1CjQ4qnV8MUltkAX3sFBI1aZvkJLeFEwcwXkBYq0.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/AKu1CjQ4qnV8MUltkAX3sL2aU247V0zTzydO4RoO9Ok.woff",
						"woff2": "http://fonts.gstatic.com/stats/Merriweather+Sans/normal/400"
					}
				},
				"700": {
					"local": [
						"\'Merriweather Sans Bold\'",
						"\'MerriweatherSans-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowaD2fnm4z6Nq0x6aGUXpBdU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6LmGj5dOJopQKEkt88GowWP5VslNTEcDcw1F0gKB_1Y&skey=d85cd7b3d911b492&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowfqJSHIsY8pKqTgTouATXAk.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowQfd-b-I5PxxcmB4_-MNcqw.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowbvMLSVzqOGkoxdgTSsKqWM.woff2"
					}
				},
				"800": {
					"local": [
						"\'Merriweather Sans ExtraBold\'",
						"\'MerriweatherSans-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowQcrWKLI4rh04OfjsZvU_LE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=6LmGj5dOJopQKEkt88Gowb2ZxDYkwCIpygfYvTDBZm8&skey=c5fa14f5cb573efb&v=v9#MerriweatherSans",
						"ttf": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowfIJfOcmuekKI9HFvv_Ow38.ttf",
						"woff": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowWT7sFQ1Iz1BbpcuCPlgc9Q.woff",
						"woff2": "http://fonts.gstatic.com/s/merriweathersans/v9/6LmGj5dOJopQKEkt88GowSdYkh4h72QvAQSOPbRA0ug.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Metal": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Metal\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/metal/v10/hcGoUXofHmCVCuH8gZybIg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=HPM7rfwSPOFkOt9VXZAr0g&skey=d087e808e3072835&v=v10#Metal",
						"ttf": "http://fonts.gstatic.com/s/metal/v10/zA3UOP13ooQcxjv04BZX5g.ttf",
						"woff": "http://fonts.gstatic.com/s/metal/v10/m45SfRFR3ORQOdeR5-T-Hw.woff",
						"woff2": "http://fonts.gstatic.com/s/metal/v10/aYpo5D2My3iYpuRPDRWo0A.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Metal Mania": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Metal Mania\'",
						"\'MetalMania-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/metalmania/v7/_MPduYXiaptg6GQ2M6AHtGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=_MPduYXiaptg6GQ2M6AHtHNsigHlcrQGNV8nkUSFQfc&skey=d8d4125af87e0443&v=v7#MetalMania",
						"ttf": "http://fonts.gstatic.com/s/metalmania/v7/_MPduYXiaptg6GQ2M6AHtJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/metalmania/v7/_MPduYXiaptg6GQ2M6AHtIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/metalmania/v7/_MPduYXiaptg6GQ2M6AHtI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Metamorphous": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Metamorphous\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/metamorphous/v7/wGqUKXRinIYggz-BTRU9enZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wGqUKXRinIYggz-BTRU9ellIn5tFQcqMuf-jhyJP0ps&skey=fea3c68933c79077&v=v7#Metamorphous",
						"ttf": "http://fonts.gstatic.com/s/metamorphous/v7/wGqUKXRinIYggz-BTRU9eonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/metamorphous/v7/wGqUKXRinIYggz-BTRU9enhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/metamorphous/v7/wGqUKXRinIYggz-BTRU9eugdm0LZdjqr5-oayXSOefg.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Metrophobic": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Metrophobic Regular\'",
						"\'Metrophobic-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/metrophobic/v10/0IZPA9DbzKXnGZABsAivT2fQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0IZPA9DbzKXnGZABsAivT3NsigHlcrQGNV8nkUSFQfc&skey=b2c727d4404ede06&v=v10#Metrophobic",
						"ttf": "http://fonts.gstatic.com/s/metrophobic/v10/0IZPA9DbzKXnGZABsAivT50EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/metrophobic/v10/0IZPA9DbzKXnGZABsAivT4bN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/metrophobic/v10/0IZPA9DbzKXnGZABsAivT44P5ICox8Kq3LLUNMylGO4.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Michroma": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Michroma\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/michroma/v8/KsKepW29FtuKesvGoDRhGPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=xAIhBa0TaAJoD3XFkDTE7vesZW2xOQ-xsNqO47m55DA&skey=967406fa199edd66&v=v8#Michroma",
						"ttf": "http://fonts.gstatic.com/s/michroma/v8/-1qPjVU14dEdanR8MQuQPfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/michroma/v8/FZQqjemuMkmQGwk1YxMXlfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/michroma/v8/-4P7knfa8IRSEOi-sKrsivesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Milonga": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Milonga\'",
						"\'Milonga-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/milonga/v5/2E33HBBfmzfNlOsDi5PV0Q.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rCjkHiiEtjG-niLlvSLvLw&skey=db6287e2596efbcb&v=v5#Milonga",
						"ttf": "http://fonts.gstatic.com/s/milonga/v5/YzfcLalbvpuD9Of73by9cw.ttf",
						"woff": "http://fonts.gstatic.com/s/milonga/v5/rnOmc7YYi93YSJQfCDGrzw.woff",
						"woff2": "http://fonts.gstatic.com/s/milonga/v5/hwluam44b9JfoHvBi4IlqA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Miltonian": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Miltonian\'",
						"\'Miltonian-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/miltonian/v11/DVUl6K_XDo9HSLlx2JoxNfY6323mHUZFJMgTvxaG2iE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DVUl6K_XDo9HSLlx2JoxNZbd9NUM7myrQQz30yPaGQ4&skey=a486d1edd2958599&v=v11#Miltonian",
						"ttf": "http://fonts.gstatic.com/s/miltonian/v11/DVUl6K_XDo9HSLlx2JoxNaCWcynf_cDxXwCLxiixG1c.ttf",
						"woff": "http://fonts.gstatic.com/s/miltonian/v11/DVUl6K_XDo9HSLlx2JoxNT8E0i7KZn-EPnyo3HZu7kw.woff",
						"woff2": "http://fonts.gstatic.com/s/miltonian/v11/DVUl6K_XDo9HSLlx2JoxNVtXRa8TVwTICgirnJhmVJw.woff2"
					}
				}
			}
		},
		"version": "v11"
	},
	"Miltonian Tattoo": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Miltonian Tattoo\'",
						"\'MiltonianTattoo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/miltoniantattoo/v12/1oU_8OGYwW46eh02YHydn8xCFIZnz1STW3kBU0Gboz8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1oU_8OGYwW46eh02YHydn-dqFtCAHCD6t19IXtPVRyY&skey=693480709c2dd2f3&v=v12#MiltonianTattoo",
						"ttf": "http://fonts.gstatic.com/s/miltoniantattoo/v12/1oU_8OGYwW46eh02YHydn3yDsJ6czMRm9Ofn-z2oR7A.ttf",
						"woff": "http://fonts.gstatic.com/s/miltoniantattoo/v12/1oU_8OGYwW46eh02YHydnzhIoxOGKXnDP3ByRnzCG7U.woff",
						"woff2": "http://fonts.gstatic.com/s/miltoniantattoo/v12/1oU_8OGYwW46eh02YHydn1emna6HHulEnMafIssNNqk.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Miniver": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Miniver\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/miniver/v6/166NDPc1SVNsUJBACH89Gg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7SRNJFskHoLl-ooik4ScBw&skey=8ca927a16135f7af&v=v6#Miniver",
						"ttf": "http://fonts.gstatic.com/s/miniver/v6/zM8nIeM_8LaPANJa1czFbg.ttf",
						"woff": "http://fonts.gstatic.com/s/miniver/v6/bkOWpAf9z_OvZFh5_5iAfA.woff",
						"woff2": "http://fonts.gstatic.com/s/miniver/v6/xVWpIMuWQxqM1V1jCWfINw.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Miriam Libre": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"hebrew",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Miriam Libre Regular\'",
						"\'MiriamLibre-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/miriamlibre/v3/Ljtpu8zR5iJWmlN3Faba5XZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ljtpu8zR5iJWmlN3Faba5VlIn5tFQcqMuf-jhyJP0ps&skey=136d3f8b2b10bd59&v=v3#MiriamLibre",
						"ttf": "http://fonts.gstatic.com/s/miriamlibre/v3/Ljtpu8zR5iJWmlN3Faba5YnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/miriamlibre/v3/Ljtpu8zR5iJWmlN3Faba5XhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/miriamlibre/v3/Ljtpu8zR5iJWmlN3Faba5egdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Miriam Libre Bold\'",
						"\'MiriamLibre-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/miriamlibre/v3/FLc0J-Gdn8ynDWUkeeesAGmsoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=FLc0J-Gdn8ynDWUkeeesAAay50PuN8loMJ9QAXsTs7U&skey=9a42f8a998b69846&v=v3#MiriamLibre",
						"ttf": "http://fonts.gstatic.com/s/miriamlibre/v3/FLc0J-Gdn8ynDWUkeeesAH06qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/miriamlibre/v3/FLc0J-Gdn8ynDWUkeeesAHl4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/miriamlibre/v3/FLc0J-Gdn8ynDWUkeeesAHNuWYKPzoeKl5tYj8yhly0.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Mirza": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"arabic",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mirza Regular\'",
						"\'Mirza-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mirza/v3/9nMt_VP27nqaa_sJ-gLWhg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=0Nblcp9lk4Y3d4MKgKBMxw&skey=c087d899b55de9f0&v=v3#Mirza",
						"ttf": "http://fonts.gstatic.com/s/mirza/v3/cTJkH4nDeM7kYpUVwcjYOw.ttf",
						"woff": "http://fonts.gstatic.com/s/mirza/v3/okFtoHRFKOSWO49CpI7GAg.woff",
						"woff2": "http://fonts.gstatic.com/s/mirza/v3/P_ndtBg6oeTgKE-y6I6a_w.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mirza Medium\'",
						"\'Mirza-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mirza/v3/GwYwsYBqZ41686fzL35gNvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=lxKfyiI3xiZMuk4jBHSfn_esZW2xOQ-xsNqO47m55DA&skey=324b00f62d363988&v=v3#Mirza",
						"ttf": "http://fonts.gstatic.com/s/mirza/v3/XUyhOqqtdSvbQpiTUI4gw_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mirza/v3/ADMI8fb18TGhfCzXq8xVcPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mirza/v3/JXMXM5JdDaviaLw5twG1V_esZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Mirza SemiBold\'",
						"\'Mirza-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mirza/v3/ArsCrdvHptiIcSyx-cK8VPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NhChmgCGgSeDn194pXFHxvesZW2xOQ-xsNqO47m55DA&skey=ce10965f006be061&v=v3#Mirza",
						"ttf": "http://fonts.gstatic.com/s/mirza/v3/05ZAL0gDT7Nw3ApzpaNxQ_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mirza/v3/3z5r8vZ7sUE9NMwkobREgfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mirza/v3/xo4t9FMKAFLMOYvyZhfXovesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mirza Bold\'",
						"\'Mirza-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mirza/v3/JCsC30NZf9hrdXtr_yb9zvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=uR0V5y-BYKzePmCrpedar_esZW2xOQ-xsNqO47m55DA&skey=2a5b706a5c111009&v=v3#Mirza",
						"ttf": "http://fonts.gstatic.com/s/mirza/v3/12p7ZJIw3PNjiOn2ff_hEfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mirza/v3/zEiupX3_w1IXuQlEOV8CZvesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mirza/v3/GcJ4H9csChZAH4KxI86e7PesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Miss Fajardose": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Miss Fajardose Regular\'",
						"\'MissFajardose-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/missfajardose/v7/WcXjlQPKn6nBfr8LY3ktNmBn559uc2_n9F2EwttCKtA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=WcXjlQPKn6nBfr8LY3ktNjzDOWITvAevw9Y_fw5XUqA&skey=60c559edbe368a95&v=v7#MissFajardose",
						"ttf": "http://fonts.gstatic.com/s/missfajardose/v7/WcXjlQPKn6nBfr8LY3ktNvcMLt8J94hnsPLv6MMkBMk.ttf",
						"woff": "http://fonts.gstatic.com/s/missfajardose/v7/WcXjlQPKn6nBfr8LY3ktNiiT6GQZqXe56UwGtNcbg_g.woff",
						"woff2": "http://fonts.gstatic.com/s/missfajardose/v7/WcXjlQPKn6nBfr8LY3ktNlu1ALExAK9iCZzq2UkgWBo.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Mitr": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"thai",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Mitr ExtraLight\'",
						"\'Mitr-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/e9FwGDKRrRtnp25WF9Pqgw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XnBgJL4knmhfCk6EewHN4A&skey=8b1e120e0c5cab67&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/WMIOn5PBtfigr5f98Bm1Sg.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/N-t6LXocEEwDIIKRxLBJew.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/aizD_NkZlgb48d-JGQf-7w.woff2"
					}
				},
				"300": {
					"local": [
						"\'Mitr Light\'",
						"\'Mitr-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/AEYErfyI0xLm4n1b4WhgmA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=MeZoH4XOciFLnvghfY9YmA&skey=6b814b7e1d9784a5&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/SWKbr7hcsBje9yyCdjbJoA.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/5guec7TSE4rnvb4fSlw_mw.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/goyqdljBBe_4a-iRDiXdzA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Mitr Regular\'",
						"\'Mitr-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/Q48PYMwim8uoBv8iqNqg1A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NM4BzFYU--kPT2u6cq6BJQ&skey=d9d553d0e1ce1028&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/lvCrHixhUqkkQGHRfTpXUQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/5H2U8wtZJxgEeVAt7LyBFw.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/1xIF_P8Md2XEGHDVpTt0Mg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mitr Medium\'",
						"\'Mitr-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/5n1W2Oc1U0Jzz9JH1gX8BQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=VGlQWrhfQFUzaBXY2fij4A&skey=2decc630fed765c1&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/mH_eHF56j_6jKlEmCL84wA.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/bV9PCFluLiR-MJTTzZkqnQ.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/ZK5yQGD8a3NRlAhmEYaGZQ.woff2"
					}
				},
				"600": {
					"local": [
						"\'Mitr SemiBold\'",
						"\'Mitr-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/xToU2ppdExE-iNBx2Wy3wA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ieXbBJJBBYx34CE5OkGxNA&skey=fff00b7b84b6ca5a&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/uHMn-x-UHuApy_rxZ9Tmiw.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/yQdUAPBynWuGzLxM6AMDOA.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/XIiXBZQINm6lCfAFlUamPg.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mitr Bold\'",
						"\'Mitr-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mitr/v3/fPStkgMp2T808BefZ3nONA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2uN8o5L1mwwLtjGeSzfiDA&skey=96da9a487f210d6e&v=v3#Mitr",
						"ttf": "http://fonts.gstatic.com/s/mitr/v3/JLeRqLUJVMDeV029YQpRMw.ttf",
						"woff": "http://fonts.gstatic.com/s/mitr/v3/eNV9QRx_VaiAq8m5KXSrFw.woff",
						"woff2": "http://fonts.gstatic.com/s/mitr/v3/d1WLW1SgHsK0FFMw3bcrzg.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Modak": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Modak\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/modak/v3/DOJcnj9nvXArqohqQYADYA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PDNfgZVRutP4xLXBDxLO1Q&skey=50290ccd34ddc6b5&v=v3#Modak",
						"ttf": "http://fonts.gstatic.com/s/modak/v3/OWyLSw61WDW78-oYbMpt4w.ttf",
						"woff": "http://fonts.gstatic.com/s/modak/v3/tL0bbhK09kwDzmZ8Kn9ZVA.woff",
						"woff2": "http://fonts.gstatic.com/s/modak/v3/KQVyQ1K9OWS9_JeuojBuzQ.woff2"
					}
				}
			}
		},
		"version": "v3"
	},
	"Modern Antiqua": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Modern Antiqua Regular\'",
						"\'ModernAntiqua-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/modernantiqua/v7/8qX_tr6Xzy4t9fvZDXPkh2vrFbXmx4AnslJ378vpcxE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=8qX_tr6Xzy4t9fvZDXPkh21-fRzicI3_VDBMobVgu-g&skey=eda495732f0669cf&v=v7#ModernAntiqua",
						"ttf": "http://fonts.gstatic.com/s/modernantiqua/v7/8qX_tr6Xzy4t9fvZDXPkhwKZaxxWfFldPDbIGRdOGHU.ttf",
						"woff": "http://fonts.gstatic.com/s/modernantiqua/v7/8qX_tr6Xzy4t9fvZDXPkh9K4x0DJI-T8q5ozNuxBQHo.woff",
						"woff2": "http://fonts.gstatic.com/s/modernantiqua/v7/8qX_tr6Xzy4t9fvZDXPkh-gUwfPtwj-Vn2gQvo3pfoE.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Mogra": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"gujarati",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mogra Regular\'",
						"\'Mogra-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mogra/v4/YZy72C0WBUiN0aJXG40itQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=t3e1CWpaT_Zn8ByTAG_tqg&skey=b7f0e945d2c7fa06&v=v4#Mogra",
						"ttf": "http://fonts.gstatic.com/s/mogra/v4/AhgMdRb9kOIBYgKp7pe5BQ.ttf",
						"woff": "http://fonts.gstatic.com/s/mogra/v4/H1mRN0_FVBaYKlSXnBmbvA.woff",
						"woff2": "http://fonts.gstatic.com/s/mogra/v4/iNadxienda3-9Z6rMIyYGg.woff2"
					}
				}
			}
		},
		"version": "v4"
	},
	"Molengo": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Molengo\'",
						"\'Molengo-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/molengo/v8/XZYp-PUFGE9TPFhkkTwoVA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=pIHypSN1UpXo5oXp7hZWFw&skey=45e667e0ddeec6d3&v=v8#Molengo",
						"ttf": "http://fonts.gstatic.com/s/molengo/v8/95sXIHqogzr_KwuabLimZA.ttf",
						"woff": "http://fonts.gstatic.com/s/molengo/v8/z1JWuCBrQt_Ta83eqIo6Dg.woff",
						"woff2": "http://fonts.gstatic.com/s/molengo/v8/pqkjY4KeO1LHeSjFqV3Zsg.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Molle": {
		"category": "handwriting",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"400": {
					"local": [
						"\'Molle\'",
						"\'Molle-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/molle/v6/Vbiv97I614vBuziG0t5oPA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NGI6OQx-Ik9xkB6zvzyEyA&skey=f55d6ddb7bd7ec17&v=v6#Molle",
						"ttf": "http://fonts.gstatic.com/s/molle/v6/xWXSZ4FH7U589ZPuKa4exw.ttf",
						"woff": "http://fonts.gstatic.com/s/molle/v6/ey6cYcURGheLq6YmcPrxEw.woff",
						"woff2": "http://fonts.gstatic.com/s/molle/v6/b_QO7x0ET5ys-sMrkWEiJA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Monda": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Monda Regular\'",
						"\'Monda-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/monda/v7/jTmvG8tSl8y7Cw0ieRkwGA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hS4WgjF7sN4G5PQqIZb3qA&skey=12b74b97e719c11d&v=v7#Monda",
						"ttf": "http://fonts.gstatic.com/s/monda/v7/WhvNfO27lzODDhoAPcYEXQ.ttf",
						"woff": "http://fonts.gstatic.com/s/monda/v7/sk05J8GA1NvUxDnk43EgAQ.woff",
						"woff2": "http://fonts.gstatic.com/s/monda/v7/9IGqbwlMn4Zg3as8alsdNA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Monda Bold\'",
						"\'Monda-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/monda/v7/6w6lP1hqgFwd_DvLqHKSFPesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AEc8W_osIl6BRIqyEC7LUPesZW2xOQ-xsNqO47m55DA&skey=4703d5044a52a024&v=v7#Monda",
						"ttf": "http://fonts.gstatic.com/s/monda/v7/h8Lv3ZYKAXAcwBhdctJLvvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/monda/v7/uCFS-jQepl-zVlhjycME2fesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/monda/v7/44jqK75nnE1DvJU0RnbUMPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Monofett": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Monofett\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/monofett/v7/zgcqY-au-yAst5CiOkK_e_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=ddm6TKsHJgp9nd5wPOpYu_esZW2xOQ-xsNqO47m55DA&skey=a8882b235f7fa04f&v=v7#Monofett",
						"ttf": "http://fonts.gstatic.com/s/monofett/v7/BezoWS-9nng_g31KmAteQ_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/monofett/v7/94n9d8-lEEaOz-Sn4plHGPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/monofett/v7/B5kbLBv_e4xu3btOMFc8LfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Monoton": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Monoton\'",
						"\'Monoton-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/monoton/v7/NyzVhrzTK8yWUz1286Kyzw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Fmn5PI0YEB_TqikG18Yh7Q&skey=6851b793dcae5a6c&v=v7#Monoton",
						"ttf": "http://fonts.gstatic.com/s/monoton/v7/ceRJlaOl8VqdbfWAlFaxNQ.ttf",
						"woff": "http://fonts.gstatic.com/s/monoton/v7/AKI-lyzyNHXByGHeOcds_w.woff",
						"woff2": "http://fonts.gstatic.com/s/monoton/v7/y6oxFxU60dYw9khW6q8jGw.woff2"
					}
				}
			}
		},
		"version": "v7"
	},
	"Monsieur La Doulaise": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Monsieur La Doulaise Regular\'",
						"\'MonsieurLaDoulaise-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/monsieurladoulaise/v6/IMAdMj6Eq9jZ46CPctFtMNIUQ_Sk1rWoBTGTc9y0020.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IMAdMj6Eq9jZ46CPctFtMHkLt35lSKIHbZidRgDxDLg&skey=f0bf0703ab573473&v=v6#MonsieurLaDoulaise",
						"ttf": "http://fonts.gstatic.com/s/monsieurladoulaise/v6/IMAdMj6Eq9jZ46CPctFtMNz2T9EvN8iEaGRoPsKIUss.ttf",
						"woff": "http://fonts.gstatic.com/s/monsieurladoulaise/v6/IMAdMj6Eq9jZ46CPctFtMPjdTEvzZxYsJD0LQT_XM7E.woff",
						"woff2": "http://fonts.gstatic.com/s/monsieurladoulaise/v6/IMAdMj6Eq9jZ46CPctFtMGbf8AroiH6JhvSUUeQzW1U.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Montaga": {
		"category": "serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Montaga\'",
						"\'Montaga-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montaga/v5/JJ40nbVCpis_KK8lJcfStQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=XklqgOAbL49bdU1YGWqGVA&skey=5a46396085681233&v=v5#Montaga",
						"ttf": "http://fonts.gstatic.com/s/montaga/v5/o4ztqO3seprHCpv6sTf-nA.ttf",
						"woff": "http://fonts.gstatic.com/s/montaga/v5/N3LqKUtkqb3XuC6YhLuVSg.woff",
						"woff2": "http://fonts.gstatic.com/s/montaga/v5/DlQ9Ikv09mwGQdyRKUBTtg.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Montez": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Montez Regular\'",
						"\'Montez-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montez/v8/GHoaXqTDx3rXCTHgKgpW1A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=Ry9dZU_Rz2dX5VBU0BNYaw&skey=f103622e34a5cc95&v=v8#Montez",
						"ttf": "http://fonts.gstatic.com/s/montez/v8/Nm1E5Q3geRBGHpTPsOzfHg.ttf",
						"woff": "http://fonts.gstatic.com/s/montez/v8/Zfcl-OLECD6-4EcdWMp-Tw.woff",
						"woff2": "http://fonts.gstatic.com/s/montez/v8/aq8el3-0osHIcFK6bXAPkw.woff2"
					}
				}
			}
		},
		"version": "v8"
	},
	"Montserrat": {
		"category": "sans-serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Montserrat Thin Italic\'",
						"\'Montserrat-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/1809Y0aW9bpFOPXsQTFwf9P2OS6Bzu7BENq0TH5sayk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1809Y0aW9bpFOPXsQTFwf0_rrxwVtVRydRAQEfd8qLU&skey=665c6c6c4d7782ba&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/1809Y0aW9bpFOPXsQTFwf2-gXUWvikdRm39El-Kldqo.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/1809Y0aW9bpFOPXsQTFwfy1dfeF-hbOdKKuBDEXxqhQ.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/1809Y0aW9bpFOPXsQTFwf1dBB84BqlWy1BjOnCrU9PY.woff2"
					}
				},
				"200": {
					"local": [
						"\'Montserrat ExtraLight Italic\'",
						"\'Montserrat-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft2hUd5_HpjpfImmlNZG9RF4.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9Ft8eRBKIWzL64VppwaClBUmc&skey=786130032acd4521&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft9A6ADgdVTL7gjIrG5k4wa0.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft_7J9eW2S58LCMPoFblzf2g.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft5dxImagpP7sHxM18iKeP-M.woff2"
					}
				},
				"300": {
					"local": [
						"\'Montserrat Light Italic\'",
						"\'Montserrat-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft4ySLpARcVRs9uFJp0LRZgE.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9Ft7Jg1hA63dzswhy4NvEPrPM&skey=a59d6e62b542782e&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtwV_pQ1T3xN3K1c3sB361us.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft2Fp2sMiApZm5Dx7NpSTOZk.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft04GofcKVZz6wtzX_QUIqsI.woff2"
					}
				},
				"400": {
					"local": [
						"\'Montserrat Italic\'",
						"\'Montserrat-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/-iqwlckIhsmvkx0N6rwPmnZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=-iqwlckIhsmvkx0N6rwPmllIn5tFQcqMuf-jhyJP0ps&skey=2d3c1187d5eede0f&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/-iqwlckIhsmvkx0N6rwPmonF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/-iqwlckIhsmvkx0N6rwPmnhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/-iqwlckIhsmvkx0N6rwPmugdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"500": {
					"local": [
						"\'Montserrat Medium Italic\'",
						"\'Montserrat-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtzHhXAPWOXQc-mHRKx4oalk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9Ft5XlX4y0PMY0_OO7hHc9JEY&skey=45c7d4e882761ae6&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtyfxicYksyVqdB8nkjIZw2U.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtxF47VQSRrvbVYTKIrepY7I.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft81Lch-SD8r0CsJ60meulZ8.woff2"
					}
				},
				"600": {
					"local": [
						"\'Montserrat SemiBold Italic\'",
						"\'Montserrat-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtzBIQ40lcwWW3vj9tFMKvqw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9FtwmE8htD-SDrf7umQTfloJ8&skey=726d69663f96e79a&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft1FZMcfX2SbzQ69I7OWmkGo.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft9Od4RnLmtUrdSQkDmC5b8k.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft_Bf3Xtc57ojmY2ox2Xv8Go.woff2"
					}
				},
				"700": {
					"local": [
						"\'Montserrat Bold Italic\'",
						"\'Montserrat-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft2msoyWrDyoltQVIP7q_RGg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9Ftway50PuN8loMJ9QAXsTs7U&skey=9e2c16f671d1af79&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft306qf9KHRHwsVx7iw5MXmY.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft3l4twXkwp3_u9ZoePkT564.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft3NuWYKPzoeKl5tYj8yhly0.woff2"
					}
				},
				"800": {
					"local": [
						"\'Montserrat ExtraBold Italic\'",
						"\'Montserrat-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft9Kd--5SjvBBPdO8SYNBozY.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9FtzkD3gkdjFTgxsLXLStRJKw&skey=856704370ed36c4e&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft7i9CBoQ1U4Q5PEtIDscMvI.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft2pVmE9oLybi4D_AN-2K110.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9FtxqoE9FO9sRveXk8Nnop4Zo.woff2"
					}
				},
				"900": {
					"local": [
						"\'Montserrat Black Italic\'",
						"\'Montserrat-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft19iNfvTt1gMvrhy159_6ck.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhwB3-BAdyKDf0geWr9Ft3vlAbBC1RrJpyn549iFTvo&skey=810b009effdbda34&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft_zeo8SCrGyBsNQUDsw2Qr8.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ftwi3Hume1-TKjJz2lX0jYjo.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhwB3-BAdyKDf0geWr9Ft9DLwwZd-mS_8JqJ_KGXwxs.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Montserrat Thin\'",
						"\'Montserrat-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/CdKWaRAal2Bxq9mORLKRRXZ2MAKAc2x4R1uOSeegc5U.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=CdKWaRAal2Bxq9mORLKRRVlIn5tFQcqMuf-jhyJP0ps&skey=7eae9536f271f41a&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/CdKWaRAal2Bxq9mORLKRRYnF5uFdDttMLvmWuJdhhgs.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/CdKWaRAal2Bxq9mORLKRRXhCUOGz7vYGh680lGh-uXM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/CdKWaRAal2Bxq9mORLKRRegdm0LZdjqr5-oayXSOefg.woff2"
					}
				},
				"200": {
					"local": [
						"\'Montserrat ExtraLight\'",
						"\'Montserrat-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/eWRmKHdPNWGn_iFyeEYja26IuzAwjfI5Pbb6jofSqzk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=eWRmKHdPNWGn_iFyeEYja4HOV2OKRwiym0CLWUSoXFs&skey=7f026987368eef64&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/eWRmKHdPNWGn_iFyeEYja22J9yQRHHBhlmQmXC5U5ok.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/eWRmKHdPNWGn_iFyeEYjaxp4ivTFcMoDJtPEqAe9hmM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/eWRmKHdPNWGn_iFyeEYja6EWXqnGSfwnQD3YDlprsb0.woff2"
					}
				},
				"300": {
					"local": [
						"\'Montserrat Light\'",
						"\'Montserrat-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/IVeH6A3MiFyaSEiudUMXE6SxSvC1lIsK_unZDHWqTBg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IVeH6A3MiFyaSEiudUMXEzGefNBPGWcFPRAoUX_lgLU&skey=1ce67628c9aa416a&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/IVeH6A3MiFyaSEiudUMXE-LrC4Du4e_yfTJ8Ol60xk0.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/IVeH6A3MiFyaSEiudUMXE9kZXW4sYc4BjuAIFc1SXII.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/IVeH6A3MiFyaSEiudUMXE8u2Q0OS-KeTAWjgkS85mDg.woff2"
					}
				},
				"400": {
					"local": [
						"\'Montserrat Regular\'",
						"\'Montserrat-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/zhcz-_WihjSQC0oHJ9TCYFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=zhcz-_WihjSQC0oHJ9TCYKWUboTb-jS2tyCOQMtm97g&skey=7bc19f711c0de8f&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/zhcz-_WihjSQC0oHJ9TCYC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/zhcz-_WihjSQC0oHJ9TCYBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/zhcz-_WihjSQC0oHJ9TCYPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				},
				"500": {
					"local": [
						"\'Montserrat Medium\'",
						"\'Montserrat-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/BYPM-GE291ZjIXBWrtCweoJh5taHiwXv-DjBEZUuYXM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=BYPM-GE291ZjIXBWrtCweg0_qyNcOHZM04svgoBwoTA&skey=7675f1290281829e&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/BYPM-GE291ZjIXBWrtCwetIZ6OFpBzzPr7LueGMiD8k.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/BYPM-GE291ZjIXBWrtCweu46x7QEqGuF-FJIFiH1W2g.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/BYPM-GE291ZjIXBWrtCwejOo-lJoxoMO4vrg2XwIHQk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Montserrat SemiBold\'",
						"\'Montserrat-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/q2OIMsAtXEkOulLQVdSl08G3e9iX24ta7lLMfbqPFME.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=q2OIMsAtXEkOulLQVdSl03XS6izMuFYFwSUB_9Omnz0&skey=72ae044fab0d9adc&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/q2OIMsAtXEkOulLQVdSl07h9hBNNhK4RjzVManoH7kY.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/q2OIMsAtXEkOulLQVdSl024H_cQCpNmkmj7HsMzmiiM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/q2OIMsAtXEkOulLQVdSl06VlZKEoJGujTpfWnQT9bUY.woff2"
					}
				},
				"700": {
					"local": [
						"\'Montserrat Bold\'",
						"\'Montserrat-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/IQHow_FEYlDC4Gzy_m8fcmzklk6MJbhg7BmBP42CjCQ.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=IQHow_FEYlDC4Gzy_m8fcj9QLNJZUvW8xv4RpDkyVDQ&skey=11a939c399e8c9fe&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/IQHow_FEYlDC4Gzy_m8fcvEr6Hm6RMS0v1dtXsGir4g.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/IQHow_FEYlDC4Gzy_m8fcgFhaRv2pGgT5Kf0An0s4MM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/IQHow_FEYlDC4Gzy_m8fcoWiMMZ7xLd792ULpGE4W_Y.woff2"
					}
				},
				"800": {
					"local": [
						"\'Montserrat ExtraBold\'",
						"\'Montserrat-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/H8_7oktkjVeeX06kbAvc0B8AHhEfjUJjouFVttJjJoo.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H8_7oktkjVeeX06kbAvc0FrFCbvhIy2ZaAENKM-VgsA&skey=8405922d7a25fc4c&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/H8_7oktkjVeeX06kbAvc0I3SmTH8Evs8V90CYwW3JLk.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/H8_7oktkjVeeX06kbAvc0CS-0kw_uRLN9JEz12uqVRQ.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/H8_7oktkjVeeX06kbAvc0Ary2jK1Y0oNyoF1xLf3zMQ.woff2"
					}
				},
				"900": {
					"local": [
						"\'Montserrat Black\'",
						"\'Montserrat-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserrat/v12/aEu-9ATAroJ1iN4zmQ55BsWwaGkf25P-zZOrMBTzpJc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=aEu-9ATAroJ1iN4zmQ55BgbguVsRAaYn2Q4xl-qnf-A&skey=2dd8299a3c2aa157&v=v12#Montserrat",
						"ttf": "http://fonts.gstatic.com/s/montserrat/v12/aEu-9ATAroJ1iN4zmQ55Bl6YDbH3175F1es-Zl7mOpU.ttf",
						"woff": "http://fonts.gstatic.com/s/montserrat/v12/aEu-9ATAroJ1iN4zmQ55BoPAkl-0rCkX4F4zIO7lYWE.woff",
						"woff2": "http://fonts.gstatic.com/s/montserrat/v12/aEu-9ATAroJ1iN4zmQ55Bsjsb7Oq0o-uqUFW7Ygu5rM.woff2"
					}
				}
			}
		},
		"version": "v12"
	},
	"Montserrat Alternates": {
		"category": "sans-serif",
		"lastModified": "2017-11-07",
		"subsets": [
			"cyrillic-ext",
			"cyrillic",
			"vietnamese",
			"latin-ext",
			"latin"
		],
		"variants": {
			"italic": {
				"100": {
					"local": [
						"\'Montserrat Alternates Thin Italic\'",
						"\'MontserratAlternates-ThinItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/3-rFIqHz_U7TAmWg7RcpL2v-mtmrUJcLJPjbkYLXo6L2Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=3-rFIqHz_U7TAmWg7RcpL2v-mtmrUJcLJPjbkYLXo6KW3fTVDO5sq0EM99Mj2hkO&skey=16b0e372b52e3b7d&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/3-rFIqHz_U7TAmWg7RcpL2v-mtmrUJcLJPjbkYLXo6KglnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/3-rFIqHz_U7TAmWg7RcpL2v-mtmrUJcLJPjbkYLXo6I_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/3-rFIqHz_U7TAmWg7RcpL2v-mtmrUJcLJPjbkYLXo6JbV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				},
				"200": {
					"local": [
						"\'Montserrat Alternates ExtraLight Italic\'",
						"\'MontserratAlternates-ExtraLightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYZH5TI33Y-TFr2N2iQ8G7ZUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAYZH5TI33Y-TFr2N2iQ8G7allG6E2_o0trcgjkDLZve4&skey=24638e31b9f8a205&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYZH5TI33Y-TFr2N2iQ8G7Yt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYZH5TI33Y-TFr2N2iQ8G7YbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYZH5TI33Y-TFr2N2iQ8G7b5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"300": {
					"local": [
						"\'Montserrat Alternates Light Italic\'",
						"\'MontserratAlternates-LightItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAXxbxjlGGtjHCw1sviBHvtBUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAXxbxjlGGtjHCw1sviBHvtCllG6E2_o0trcgjkDLZve4&skey=50f24bc9379e4ab&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAXxbxjlGGtjHCw1sviBHvtAt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAXxbxjlGGtjHCw1sviBHvtAbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAXxbxjlGGtjHCw1sviBHvtD5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"400": {
					"local": [
						"\'Montserrat Alternates Italic\'",
						"\'MontserratAlternates-Italic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwpll3bSCkpgRPnqwQfhgdCeIk.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oqQkJ7FUCF9bJw9oNhwpllqgOgMCMOeAGmBl70_te2o&skey=765911c1b42b717d&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwplrDoM-ePwRkgYUTCK3lCbWU.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwplimGSe-KRym3mJLj0cOBp18.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwpluyk5JhFZ1XPw5fT_zWu02Y.woff2"
					}
				},
				"500": {
					"local": [
						"\'Montserrat Alternates Medium Italic\'",
						"\'MontserratAlternates-MediumItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAQGeOFmuWY2trjADWyy4xtZUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAQGeOFmuWY2trjADWyy4xtallG6E2_o0trcgjkDLZve4&skey=2c17a87eb06b97c3&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAQGeOFmuWY2trjADWyy4xtYt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAQGeOFmuWY2trjADWyy4xtYbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAQGeOFmuWY2trjADWyy4xtb5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"600": {
					"local": [
						"\'Montserrat Alternates SemiBold Italic\'",
						"\'MontserratAlternates-SemiBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAVpHt0VRud2VFCElZXwxzudUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAVpHt0VRud2VFCElZXwxzuellG6E2_o0trcgjkDLZve4&skey=db8cef6195dc318&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAVpHt0VRud2VFCElZXwxzuct1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAVpHt0VRud2VFCElZXwxzucbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAVpHt0VRud2VFCElZXwxzuf5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"700": {
					"local": [
						"\'Montserrat Alternates Bold Italic\'",
						"\'MontserratAlternates-BoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAet8yGZvygMi6nHwhm1N8T9UJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAet8yGZvygMi6nHwhm1N8T-llG6E2_o0trcgjkDLZve4&skey=a0f796d221047734&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAet8yGZvygMi6nHwhm1N8T8t1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAet8yGZvygMi6nHwhm1N8T8bMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAet8yGZvygMi6nHwhm1N8T_5P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"800": {
					"local": [
						"\'Montserrat Alternates ExtraBold Italic\'",
						"\'MontserratAlternates-ExtraBoldItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAR2j5gbe9Hr6wWK8YFlJSB1UJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAR2j5gbe9Hr6wWK8YFlJSB2llG6E2_o0trcgjkDLZve4&skey=10eb3ac76ccf170&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAR2j5gbe9Hr6wWK8YFlJSB0t1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAR2j5gbe9Hr6wWK8YFlJSB0bMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAR2j5gbe9Hr6wWK8YFlJSB35P7wK4alSGdJ7_atPdITf.woff2"
					}
				},
				"900": {
					"local": [
						"\'Montserrat Alternates Black Italic\'",
						"\'MontserratAlternates-BlackItalic\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYotXBxWqVSDqRjBmr0ynOhUJWBG7Hs_XGYyrDTIyzsD.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=AXzeb8s80Wvg1Wkw1cVlAYotXBxWqVSDqRjBmr0ynOillG6E2_o0trcgjkDLZve4&skey=e94e0c0f004287de&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYotXBxWqVSDqRjBmr0ynOgt1EgZ0r6ZKKUGlEftq-4l.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYotXBxWqVSDqRjBmr0ynOgbMRGMDOxYHsmkoFO9XCxt.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/AXzeb8s80Wvg1Wkw1cVlAYotXBxWqVSDqRjBmr0ynOj5P7wK4alSGdJ7_atPdITf.woff2"
					}
				}
			},
			"normal": {
				"100": {
					"local": [
						"\'Montserrat Alternates Thin\'",
						"\'MontserratAlternates-Thin\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwplkCnOl_BYovph3jvBuwIisc.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=oqQkJ7FUCF9bJw9oNhwplhIyuC9u9vbfxa5OJBvr7J4&skey=fbe0b3f11541e83a&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwplvHOvy73Qrhtw577sk6vliA.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwpltNHnzKhaIopQseLz9Wiv3M.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/oqQkJ7FUCF9bJw9oNhwpllIlZjt7V25qflwCdq3ul_A.woff2"
					}
				},
				"200": {
					"local": [
						"\'Montserrat Alternates ExtraLight\'",
						"\'MontserratAlternates-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZrgH_YrrkUuYjjGXhITzZVn3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZk0zWiJn_xk7RB1BAAT-l_z3rGVtsTkPsbDajuO5ueQw&skey=86039d8434be6c64&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZnc1TZvsjvKFD1tTe8kdYj33rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZpX-3grC4MTlUACdqCT-1ID3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZsS99E_i-PHEfC998pGCc9j3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"300": {
					"local": [
						"\'Montserrat Alternates Light\'",
						"\'MontserratAlternates-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZkyFbZBLGSJCsf3ZRuff7Mf3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZmDgMtsPtVvOduW_5fdmDxb3rGVtsTkPsbDajuO5ueQw&skey=20a925b65fd40440&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZuC7DWfJm_kB8dnCScVtmdX3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZnSGklrxl9HU-v-1KasV9yX3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZgPf5UelftEYW8VnBYozE5r3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"400": {
					"local": [
						"\'Montserrat Alternates Regular\'",
						"\'MontserratAlternates-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/z2n1Sjxk9souK3HCtdHukrTq0OG2hoyujbZCay2YE-c.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=z2n1Sjxk9souK3HCtdHukklc3LJmiMnKjSUrTTcmPEM&skey=1c28268e06f190cd&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/z2n1Sjxk9souK3HCtdHukgnkfjG14KscmNg0xC38TkM.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/z2n1Sjxk9souK3HCtdHukiVz4wwEV01Tv2kxNh88JXM.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/z2n1Sjxk9souK3HCtdHukpy2IC1KoJIC5P3EDKbgI_s.woff2"
					}
				},
				"500": {
					"local": [
						"\'Montserrat Alternates Medium\'",
						"\'MontserratAlternates-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZphvtXyYn0LDqRTxnQrwp_v3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZgYvQdLifNiT3QzlLUU2kwf3rGVtsTkPsbDajuO5ueQw&skey=2be5c5c66afe9b0&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZrZFjZZ57jWBLwI6uQ3poDz3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZl1t5kbysncuZb179ynGs073rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZp7jbOmvYQnuQIP7VLOrgJ_3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"600": {
					"local": [
						"\'Montserrat Alternates SemiBold\'",
						"\'MontserratAlternates-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZuD6C2R_djSLoVo8_9dU9jD3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZvrZAnelceZP_MZeNtwEimD3rGVtsTkPsbDajuO5ueQw&skey=996d78ac3ec9e465&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZqaSnPfj3mtdIEzoms0JAVP3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZq3pkHGXTLFi39SWY-hhzP_3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZmiyvZyAx6G8LkMARSqsb0b3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"700": {
					"local": [
						"\'Montserrat Alternates Bold\'",
						"\'MontserratAlternates-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZq5GKZ-fL5I3Lzm7580puyD3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZsCzWoMtuq0b-km6eP55Cy_3rGVtsTkPsbDajuO5ueQw&skey=c279dc6d80686c39&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZhqxxyO8TqgHUo835u8oy0_3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZgHIHA8NZDzxmj0AXZzWWdj3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZmksDjUaR4oq4rjDTNt60Dr3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"800": {
					"local": [
						"\'Montserrat Alternates ExtraBold\'",
						"\'MontserratAlternates-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZj3l1H0Q04YuWLMEjQrL4sz3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZklzCIDWEVzx7--QcgdUbwX3rGVtsTkPsbDajuO5ueQw&skey=93e5c94513c29dff&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZjxueTPWFh5vrbNJtstf5P33rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZjnt8RHGwmazfJUhqlanpJ73rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZj2z-qxic7nBU-by-PWntG33rGVtsTkPsbDajuO5ueQw.woff2"
					}
				},
				"900": {
					"local": [
						"\'Montserrat Alternates Black\'",
						"\'MontserratAlternates-Black\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZhI_iF5fP2v6EcaPbsYbfwH3rGVtsTkPsbDajuO5ueQw.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=YENqOGAVzwIHjYNjmKuAZgI4__0nDefkGETvRBxjeaf3rGVtsTkPsbDajuO5ueQw&skey=ad89306878dfa76e&v=v9#MontserratAlternates",
						"ttf": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZrSotdpT-vxIIGHgVtFhlgX3rGVtsTkPsbDajuO5ueQw.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZhVgqQYDywgGQPZ4wrVWuFL3rGVtsTkPsbDajuO5ueQw.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratalternates/v9/YENqOGAVzwIHjYNjmKuAZnA2ZY9of6ew-xCNNr-RkLz3rGVtsTkPsbDajuO5ueQw.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Montserrat Subrayada": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'MontserratSubrayada-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratsubrayada/v5/nzoCWCz0e9c7Mr2Gl8bbgpTuh4eXtBIb45PV6TZjR-Y.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nzoCWCz0e9c7Mr2Gl8bbgqmt_9R6nQaWM-jlOtIlyxE&skey=b9d78a68a81ccefa&v=v5#MontserratSubrayada",
						"ttf": "http://fonts.gstatic.com/s/montserratsubrayada/v5/nzoCWCz0e9c7Mr2Gl8bbgmKug4NwxLoXRUZJcef-dI0.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratsubrayada/v5/nzoCWCz0e9c7Mr2Gl8bbgkk91NeiEk8oQQPCeZ5CN8w.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratsubrayada/v5/nzoCWCz0e9c7Mr2Gl8bbgi4QO8UGDVVdK02gJrCWRzU.woff2"
					}
				},
				"700": {
					"local": [
						"\'MontserratSubrayada-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/montserratsubrayada/v5/wf-IKpsHcfm0C9uaz9IeGNgLEYdwsT2UhZ1vz8JGI7A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=wf-IKpsHcfm0C9uaz9IeGNbucikrbXwuu7hZrYtUSXc&skey=cf0011ee8bfb5b92&v=v5#MontserratSubrayada",
						"ttf": "http://fonts.gstatic.com/s/montserratsubrayada/v5/wf-IKpsHcfm0C9uaz9IeGAei4QJWNC4PgOO-IsX5D3Y.ttf",
						"woff": "http://fonts.gstatic.com/s/montserratsubrayada/v5/wf-IKpsHcfm0C9uaz9IeGKlknUw7DcFY8X2UkbwMLDg.woff",
						"woff2": "http://fonts.gstatic.com/s/montserratsubrayada/v5/wf-IKpsHcfm0C9uaz9IeGEeLBF2zoGUgzrb4kl1-uvk.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Moul": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Moul\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/moul/v9/V_7l3F6Op0Co4hesRYIc-w.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=nzMEQZeDpjmP9HUv0PFmEQ&skey=eae70e3253c63b0&v=v9#Moul",
						"ttf": "http://fonts.gstatic.com/s/moul/v9/Kb0ALQnfyXawP1a_P_gpTQ.ttf",
						"woff": "http://fonts.gstatic.com/s/moul/v9/gArM8Fle6IjnhGtL9K4XbQ.woff",
						"woff2": "http://fonts.gstatic.com/s/moul/v9/RKD1EVIln4NHt2RKYAXSnA.woff2"
					}
				}
			}
		},
		"version": "v9"
	},
	"Moulpali": {
		"category": "display",
		"lastModified": "2017-10-09",
		"subsets": [
			"khmer"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Moul Pali\'",
						"\'MoulPali\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/moulpali/v10/wSa8OfEPWpg5eLtIxOATQg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kDWfcK0dIht7Y_uhmE2ESA&skey=2e841174f65feca6&v=v10#Moulpali",
						"ttf": "http://fonts.gstatic.com/s/moulpali/v10/diD74BprGhmVkJoerKmrKA.ttf",
						"woff": "http://fonts.gstatic.com/s/moulpali/v10/ff3k7apy0QPDPaye-fVrig.woff",
						"woff2": "http://fonts.gstatic.com/s/moulpali/v10/1DcP4Q5ykgdNWp8apDz93hTbgVql8nDJpwnrE27mub0.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Mountains of Christmas": {
		"category": "display",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mountains of Christmas Regular\'",
						"\'MountainsofChristmas-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/dVGBFPwd6G44IWDbQtPew2gG999Kq_FGO1pXQjsIoLI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=dVGBFPwd6G44IWDbQtPew4dYk-5rv9BZioeDdLk-maA&skey=d3b4d63b5003aa4a&v=v10#MountainsofChristmas",
						"ttf": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/dVGBFPwd6G44IWDbQtPew1bt-oIll-RyBOVQqGBP3Ww.ttf",
						"woff": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/dVGBFPwd6G44IWDbQtPew7eVM6rOCXWGKlZnjUSHN4M.woff",
						"woff2": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/dVGBFPwd6G44IWDbQtPewze0PfZQnrxvUtG3BXt8d7I.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mountains of Christmas Bold\'",
						"\'MountainsofChristmas-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/PymufKtHszoLrY0uiAYKNNMJQ1kXdW7gxNBCG4zxl772Ot9t5h1GRSTIE78Whtoh.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=PymufKtHszoLrY0uiAYKNNMJQ1kXdW7gxNBCG4zxl76W3fTVDO5sq0EM99Mj2hkO&skey=cc188c4b1060ab5c&v=v10#MountainsofChristmas",
						"ttf": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/PymufKtHszoLrY0uiAYKNNMJQ1kXdW7gxNBCG4zxl76glnMp3_3A8V8Ai8YosRtX.ttf",
						"woff": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/PymufKtHszoLrY0uiAYKNNMJQ1kXdW7gxNBCG4zxl74_BNIuymZ_hD58qNx2bu5M.woff",
						"woff2": "http://fonts.gstatic.com/s/mountainsofchristmas/v10/PymufKtHszoLrY0uiAYKNNMJQ1kXdW7gxNBCG4zxl75bV0WvE1cEyAoIq5yYZlSc.woff2"
					}
				}
			}
		},
		"version": "v10"
	},
	"Mouse Memoirs": {
		"category": "sans-serif",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mouse Memoirs\'",
						"\'MouseMemoirs-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mousememoirs/v5/NBFaaJFux_j0AQbAsW3QeLSL3g004LNKkgHM9a6X73A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=NBFaaJFux_j0AQbAsW3QeDjR3xVPJpEcWH1UXm1-s8c&skey=b6fdd9ea61fd55f3&v=v5#MouseMemoirs",
						"ttf": "http://fonts.gstatic.com/s/mousememoirs/v5/NBFaaJFux_j0AQbAsW3QeIB9a16epZVaac-gfobfbfA.ttf",
						"woff": "http://fonts.gstatic.com/s/mousememoirs/v5/NBFaaJFux_j0AQbAsW3QeNUFqmyT-Ih543PWa_C0ig4.woff",
						"woff2": "http://fonts.gstatic.com/s/mousememoirs/v5/NBFaaJFux_j0AQbAsW3QeMmBRJoLbs7X6hY7yFEc97Q.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Mr Bedfort": {
		"category": "handwriting",
		"lastModified": "2017-10-09",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mr Bedfort\'",
						"\'MrBedfort-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mrbedfort/v6/H0TolBttBLTEH8l2I5ZOUFQlYEbsez9cZjKsNMjLOwM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=H0TolBttBLTEH8l2I5ZOUKWUboTb-jS2tyCOQMtm97g&skey=6eb5e3ba826b3845&v=v6#MrBedfort",
						"ttf": "http://fonts.gstatic.com/s/mrbedfort/v6/H0TolBttBLTEH8l2I5ZOUC3USBnSvpkopQaUR-2r7iU.ttf",
						"woff": "http://fonts.gstatic.com/s/mrbedfort/v6/H0TolBttBLTEH8l2I5ZOUBsxEYwM7FgeyaSgU71cLG0.woff",
						"woff2": "http://fonts.gstatic.com/s/mrbedfort/v6/H0TolBttBLTEH8l2I5ZOUPk_vArhqVIZ0nv9q090hN8.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Mr Dafoe": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mr Dafoe Regular\'",
						"\'MrDafoe-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mrdafoe/v6/UkQlBGqTw9Gua1epFzTiV_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hC2e0GrB6VyzLwB63tKIk_esZW2xOQ-xsNqO47m55DA&skey=1ffc9a6af684f026&v=v6#MrDafoe",
						"ttf": "http://fonts.gstatic.com/s/mrdafoe/v6/wSkiQ2gN5InLCFmPMqkhgvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mrdafoe/v6/F1AgEicuA-Vh7KAhE4UhjfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mrdafoe/v6/uZ97Ol8ozFq27olhOMuMCPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Mr De Haviland": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mr De Haviland Regular\'",
						"\'MrDeHaviland-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mrdehaviland/v6/fD8y4L6PJ4vqDk7z8Y8e2zlGn4ZcnG6VvomW7FUfLCs.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fD8y4L6PJ4vqDk7z8Y8e29ZaPu8x4XFU9PkTEK5V0EE&skey=4c1b286187a2a4c2&v=v6#MrDeHaviland",
						"ttf": "http://fonts.gstatic.com/s/mrdehaviland/v6/fD8y4L6PJ4vqDk7z8Y8e215z3qu3EfKOn3awoXToAA8.ttf",
						"woff": "http://fonts.gstatic.com/s/mrdehaviland/v6/fD8y4L6PJ4vqDk7z8Y8e24lF6A_zyQcEfQALPrK4qOA.woff",
						"woff2": "http://fonts.gstatic.com/s/mrdehaviland/v6/fD8y4L6PJ4vqDk7z8Y8e2xKslWWn1MxsLfxBDz9WLj0.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Mrs Saint Delafield": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mrs Saint Delafield\'",
						"\'MrsSaintDelafield-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mrssaintdelafield/v5/vuWagfFT7bj9lFtZOFBwmkcxZKZQbZtFjsn8wWLNpic.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=vuWagfFT7bj9lFtZOFBwmuiqSaLuiaEUZsUPJQ3fvS4&skey=9589386d66acad9b&v=v5#MrsSaintDelafield",
						"ttf": "http://fonts.gstatic.com/s/mrssaintdelafield/v5/vuWagfFT7bj9lFtZOFBwmolsVjaOcuFirUsjMOsh6jg.ttf",
						"woff": "http://fonts.gstatic.com/s/mrssaintdelafield/v5/vuWagfFT7bj9lFtZOFBwmkQ9lQTg7ma6s-K-LsDIgkk.woff",
						"woff2": "http://fonts.gstatic.com/s/mrssaintdelafield/v5/vuWagfFT7bj9lFtZOFBwmqVv2QOGh8jhSQR6gwu0tb4.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Mrs Sheppards": {
		"category": "handwriting",
		"lastModified": "2017-10-10",
		"subsets": [
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"400": {
					"local": [
						"\'Mrs Sheppards Regular\'",
						"\'MrsSheppards-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mrssheppards/v6/2WFsWMV3VUeCz6UVH7UjCrSL3g004LNKkgHM9a6X73A.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=2WFsWMV3VUeCz6UVH7UjCjjR3xVPJpEcWH1UXm1-s8c&skey=e03a0d98536a56e9&v=v6#MrsSheppards",
						"ttf": "http://fonts.gstatic.com/s/mrssheppards/v6/2WFsWMV3VUeCz6UVH7UjCoB9a16epZVaac-gfobfbfA.ttf",
						"woff": "http://fonts.gstatic.com/s/mrssheppards/v6/2WFsWMV3VUeCz6UVH7UjCtUFqmyT-Ih543PWa_C0ig4.woff",
						"woff2": "http://fonts.gstatic.com/s/mrssheppards/v6/2WFsWMV3VUeCz6UVH7UjCsmBRJoLbs7X6hY7yFEc97Q.woff2"
					}
				}
			}
		},
		"version": "v6"
	},
	"Mukta": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"latin-ext",
			"devanagari",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Mukta ExtraLight\'",
						"\'Mukta-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/MCL5uTfsvbCH8dyqNO68i_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=hc9XTy4g3ub_RVisYpFiIPesZW2xOQ-xsNqO47m55DA&skey=b0f5e948f14f09ea&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/G-ZD50ldT9qtWeKgbtBmxfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/Ai4NzBGFovsdCzuQaHCj6PesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/NPl00Nj6H7g0sIA5yGLdHfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"300": {
					"local": [
						"\'Mukta Light\'",
						"\'Mukta-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/PulqHWOF_drKpy3EmXP-pvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=GQldfYfWbZ4S_OfSSoCMH_esZW2xOQ-xsNqO47m55DA&skey=28d7cadd0fd3def&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/rTn2E64ZyDtrO6MV_Bz-r_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/FzL2QHRfLVW-asZys4mqq_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/P54vSllC0ADvieGtZWMwefesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"400": {
					"local": [
						"\'Mukta Regular\'",
						"\'Mukta-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/Dr8TccU6DxKi3C2U5GD1IA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=7iHhLSaVOoDcM08uoetnDw&skey=1924b0eeab402e18&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/2Yrso7_VqXPqZ2IjTmAzew.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/NIE5Byrl4cSj3ASSo4RYIg.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/q-tytnvlzg1nj8JgRZDYrw.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mukta Medium\'",
						"\'Mukta-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/6yNtF_AypGsBQPYCAU7Q-fesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=90rAX-lCACQZDlKGBaYzUPesZW2xOQ-xsNqO47m55DA&skey=7e02db405fcfde6f&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/6DIewf-IbfZE5rzgLKNhhfesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/3C6Rm9HTtUD1hlzna0CjGPesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/PnEbX1qY5FqLc0nUv7iwVfesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"600": {
					"local": [
						"\'Mukta SemiBold\'",
						"\'Mukta-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/7rbZIhwdZmqktZKPeHAJO_esZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=EWrWtzAz1J-TxrBWz1mH8vesZW2xOQ-xsNqO47m55DA&skey=b6217d1b1487e999&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/HF9c36l5NgvCxzHtsB1lkvesZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/4IVk6pzVuR76w4fa1yRslfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/2n9Enn_VdCubjZJfdQUe5fesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mukta Bold\'",
						"\'Mukta-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/Z53GmpFNj1EL0PhbJkN5svesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=fQOgPtXQ6tw8oGqBsjEj3fesZW2xOQ-xsNqO47m55DA&skey=2dd8ff0c402d2647&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/b_koBha4OOWfk3MVQGjaX_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/zGLw9POzrTPdj3W85R1ZbfesZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/fT3IGEJzqWyj-25eZDPwIvesZW2xOQ-xsNqO47m55DA.woff2"
					}
				},
				"800": {
					"local": [
						"\'Mukta ExtraBold\'",
						"\'Mukta-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/mukta/v5/4l6wjkgoXHhBEmhUoqJYEvesZW2xOQ-xsNqO47m55DA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=sYT79X39XP0HnEZCDTIljPesZW2xOQ-xsNqO47m55DA&skey=800c584f86d8cf55&v=v5#Mukta",
						"ttf": "http://fonts.gstatic.com/s/mukta/v5/hVR_bSaAT-Vn7L7zS9QSd_esZW2xOQ-xsNqO47m55DA.ttf",
						"woff": "http://fonts.gstatic.com/s/mukta/v5/8asY71PHfvScm4erzCmA0_esZW2xOQ-xsNqO47m55DA.woff",
						"woff2": "http://fonts.gstatic.com/s/mukta/v5/HaHktLLTwlre-a6ddQtCrPesZW2xOQ-xsNqO47m55DA.woff2"
					}
				}
			}
		},
		"version": "v5"
	},
	"Mukta Mahee": {
		"category": "sans-serif",
		"lastModified": "2017-10-09",
		"subsets": [
			"gurmukhi",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Mukta Mahee ExtraLight\'",
						"\'MuktaMahee-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p1T7wzIiOHIChIARuHOnLzM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4pxZBgPlnpWaoq0SaX6doyAk&skey=7a5444129384d98f&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p4k9RAFW3K6S6MTuxUiRJAk.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p9j3jEPHYvfoh7wL9kai_ws.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p_-yvr_zg92NT13uHB6uFCI.woff2"
					}
				},
				"300": {
					"local": [
						"\'Mukta Mahee Light\'",
						"\'MuktaMahee-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p7XcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4pz4dnM32POWavC8T_whbZeI&skey=ffce7cc203bb344a&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p7fB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4px_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p0o2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Mukta Mahee Regular\'",
						"\'MuktaMahee-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/rQe5YBXiZxYQvPKT6qxfDGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=rQe5YBXiZxYQvPKT6qxfDHNsigHlcrQGNV8nkUSFQfc&skey=855bb793d38aa635&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/rQe5YBXiZxYQvPKT6qxfDJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/rQe5YBXiZxYQvPKT6qxfDIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/rQe5YBXiZxYQvPKT6qxfDI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mukta Mahee Medium\'",
						"\'MuktaMahee-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4pyGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4p6057wUl25f8_0IloMUHk98&skey=4ae6321ea858b53e&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p_Mi34-dsJKaItLa5TRL9eU.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4pyqHEX2q--o2so14pIEl08w.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p7BojE9J5UnpMtv5N3zfxwk.woff2"
					}
				},
				"600": {
					"local": [
						"\'Mukta Mahee SemiBold\'",
						"\'MuktaMahee-SemiBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p48mkAiYpFywqG2RvpzBnTU.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4p-VmfClkf66xvxL1SWm4y8M&skey=6c05d8bd28d2205d&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4py8cqLH4MEiSE0ROcU-qHOA.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p35HxGBcBvicCpTp6spHfNo.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p12umOyRU7PgRiv8DXcgJjk.woff2"
					}
				},
				"700": {
					"local": [
						"\'Mukta Mahee Bold\'",
						"\'MuktaMahee-Bold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p7Ft29aCHKT7otDW9l62Aag.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4p3tNmQEE9wZ6UZlmiISB1pg&skey=f27e05420a7299f0&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p5_TkvowlIOtbR7ePgFOpF4.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4pzqR_3kx9_hJXbbyU8S6IN0.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p4lIZu-HDpmDIZMigmsroc4.woff2"
					}
				},
				"800": {
					"local": [
						"\'Mukta Mahee ExtraBold\'",
						"\'MuktaMahee-ExtraBold\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p5hT2rkLFFMVLymfgfmWVtI.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=kolKnxd29wydc4yTvsM4p0WkFefV8YEa5Z9BVNHdJ6k&skey=f19409c4dd733942&v=v2#MuktaMahee",
						"ttf": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p1DMrAYtoOisqqMDW9M_Mqc.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p0CDe67GEgBv_HnyvHTfdew.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamahee/v2/kolKnxd29wydc4yTvsM4p3ibbpXgLHK_uTT48UMyjSM.woff2"
					}
				}
			}
		},
		"version": "v2"
	},
	"Mukta Malar": {
		"category": "sans-serif",
		"lastModified": "2017-11-21",
		"subsets": [
			"tamil",
			"latin-ext",
			"latin"
		],
		"variants": {
			"normal": {
				"200": {
					"local": [
						"\'Mukta Malar ExtraLight\'",
						"\'MuktaMalar-ExtraLight\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18eVT7wzIiOHIChIARuHOnLzM.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1-N_tlWLJvzngraerf18eRZBgPlnpWaoq0SaX6doyAk&skey=f80a084a3939e22c&v=v3#MuktaMalar",
						"ttf": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18eYk9RAFW3K6S6MTuxUiRJAk.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18edj3jEPHYvfoh7wL9kai_ws.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18ef-yvr_zg92NT13uHB6uFCI.woff2"
					}
				},
				"300": {
					"local": [
						"\'Mukta Malar Light\'",
						"\'MuktaMalar-Light\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18ebXcjzEax2LfQAlK8DdMzhA.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1-N_tlWLJvzngraerf18eT4dnM32POWavC8T_whbZeI&skey=d07f0f6650e06769&v=v3#MuktaMalar",
						"ttf": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18ebfB31yxOzP-czbf6AAKCVo.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18eR_xHqYgAV9Bl_ZQbYUxnQU.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18eUo2lTMeWA_kmIyWrkNCwPc.woff2"
					}
				},
				"400": {
					"local": [
						"\'Mukta Malar Regular\'",
						"\'MuktaMalar-Regular\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamalar/v3/DEffTEevITAjbZYNN31ElGfQcKutQXcIrRfyR5jdjY8.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=DEffTEevITAjbZYNN31ElHNsigHlcrQGNV8nkUSFQfc&skey=5a0beac37005fbce&v=v3#MuktaMalar",
						"ttf": "http://fonts.gstatic.com/s/muktamalar/v3/DEffTEevITAjbZYNN31ElJ0EAVxt0G0biEntp43Qt6E.ttf",
						"woff": "http://fonts.gstatic.com/s/muktamalar/v3/DEffTEevITAjbZYNN31ElIbN6UDyHWBl620a-IRfuBk.woff",
						"woff2": "http://fonts.gstatic.com/s/muktamalar/v3/DEffTEevITAjbZYNN31ElI4P5ICox8Kq3LLUNMylGO4.woff2"
					}
				},
				"500": {
					"local": [
						"\'Mukta Malar Medium\'",
						"\'MuktaMalar-Medium\'"
					],
					"url": {
						"eot": "http://fonts.gstatic.com/s/muktamalar/v3/1-N_tlWLJvzngraerf18eSGu2KOSTawI8d9zCvShylg.eot",
						"svg": "http://fonts.gstatic.com/l/font?kit=1-N_tlWLJvzngraerf18ea057wUl25f8_0IloMUHk98&skey=81ac3aa