<?php
/*
Template Name: Contact
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

 global $post;
	$map 			= get_post_meta( $post->ID, '_kad_contact_map', true );
	$form_math 		= get_post_meta( $post->ID, '_kad_contact_form_math', true );
	$form 			= get_post_meta( $post->ID, '_kad_contact_form', true );
	$name_required 	= get_post_meta( $post->ID, '_kad_contact_name_required', true );
	$consent 		= get_post_meta( $post->ID, '_kad_contact_consent', true );
	
	if ($form == 'yes') { ?>
		<script type="text/javascript">
			jQuery(document).ready(function($) {$.extend($.validator.messages, {required: "<?php echo __('This field is required.', 'virtue'); ?>", email: "<?php echo __('Please enter a valid email address.', 'virtue'); ?>",});$("#contactForm").validate();});
		</script>
		<script type="text/javascript" src="<?php echo esc_url(get_template_directory_uri().'/assets/js/jquery.validate-ck.js');?>"></script>
	<?php } 
	if ($map == 'yes') { ?>
		    <?php global $post, $virtue_premium; 
		    	$address 	= get_post_meta( $post->ID, '_kad_contact_address', true ); 
			    $maptype 	= get_post_meta( $post->ID, '_kad_contact_maptype', true ); 
			    $height 	= get_post_meta( $post->ID, '_kad_contact_mapheight', true );
			    $address2 	= get_post_meta( $post->ID, '_kad_contact_address2', true );
			    $address3 	= get_post_meta( $post->ID, '_kad_contact_address3', true );
			    $address4 	= get_post_meta( $post->ID, '_kad_contact_address4', true );
			    $mapcenter 	= get_post_meta( $post->ID, '_kad_contact_map_center', true );
			    $mapzoom 	= get_post_meta( $post->ID, '_kad_contact_zoom', true );
			    if(isset($virtue_premium['google_map_api']) && !empty($virtue_premium['google_map_api'])) {
			    	$gmap_api = $virtue_premium['google_map_api'];
			    } else {
			    	$gmap_api = '';
			    }
			    if(!empty($height)) {
			    	$mapheight = $height;
			    } else {
			    	$mapheight = 300;
			    } 
			    if(!empty($mapzoom)) { 
			    	$zoom = $mapzoom;
			    } else {
			    	$zoom = 15; 
			    }
			    if(empty($mapcenter)) {
			    	$center = $address;
			    } else {
			    	$center = $mapcenter;
			    }		    

		    ?>
		    <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=<?php echo esc_attr($gmap_api);?>"></script>
		    <script type="text/javascript">
					jQuery(window).load(function() {
					var isDraggable = jQuery(document).width() > 480 ? true : false;
					jQuery('#map_address')
						.gmap3({
				    	map: {
						address:"<?php echo esc_js($center);?>",
						options: {
								zoom:<?php echo esc_js($zoom);?>,
							draggable: isDraggable,
							mapTypeControl: true,
							mapTypeId: google.maps.MapTypeId.<?php echo esc_js($maptype);?>,
							scrollwheel: false,
							panControl: true,
							rotateControl: false,
							scaleControl: true,
							streetViewControl: true,
							zoomControl: true
						}
						},
						marker:{
						values:[
							 {address: "<?php echo esc_js($address);?>",
							    data:"<div class='mapinfo'>'<?php echo esc_js($address);?>'</div>",
							},
							<?php if(!empty($address2)) {?> { address: "<?php echo esc_js($address2);?>",
						 	    	data:"<div class='mapinfo'> <?php echo esc_js($address2);?></div>",
						 	},
						 	<?php } ?>
						 	<?php if(!empty($address3)) {?> { address: "<?php echo esc_js($address3);?>",
						 	    	data:"<div class='mapinfo'> <?php echo esc_js($address3);?></div>",
						 	},
						 	<?php } ?>
						 	<?php if(!empty($address4)) {?> { address: "<?php echo esc_js($address4);?>",
						 	    	data:"<div class='mapinfo'><?php echo esc_js($address4);?></div>",
						 	},
						 	<?php } ?>
						],
						options:{
						draggable: false,
						},
						events:{
						click: function(marker, event, context){
						var map = jQuery(this).gmap3("get"),
						  infowindow = jQuery(this).gmap3({get:{name:"infowindow"}});
						if (infowindow){
						  infowindow.open(map, marker);
						  infowindow.setContent(context.data);
						} else {
						  jQuery(this).gmap3({
						    infowindow:{
						      anchor:marker, 
						      options:{content: context.data}
						    }
						  });
						}
						},
						closeclick: function(){
						var infowindow = jQuery(this).gmap3({get:{name:"infowindow"}});
						if (infowindow){
						  infowindow.close();
						}
						}
						}
						}
						});
						
		        
					    });
			</script>
		    <?php echo '<style type="text/css" media="screen">#map_address {height:'.esc_attr($mapheight).'px; margin-bottom:20px;}</style>'; ?>
    <?php } ?>
<?php global $virtue_premium, $post;
if(isset($_POST['submitted'])) {

	$spam_hook = apply_filters( 'kadence-contact-spam-check', true, $_POST );

	if( ! $spam_hook ) {
		$hasError = true;
		$spamError = __('Your post appears to be spam, if this is incorrect please contact the site admnistator.', 'virtue');
	}
	if(isset($form_math) && $form_math == 'yes') {
		$math_answer = trim($_POST['kad_captcha']);
		if(md5($math_answer) != $_POST['hval']) {
			$kad_captchaError = __('Check your math.', 'virtue');
			$hasError = true;
		}
	}
	if ( isset( $consent ) && 'true' == $consent ) {
		$gdpr_consent = sanitize_text_field( $_POST['gdpr-consent'] );
		if( 'on' != $gdpr_consent ) {
			$kad_consentError = __('Please check the box.', 'virtue');
			$hasError = true;
		}
	}
	if ( 'false' ==  $name_required ) {
		$name = sanitize_text_field( trim( $_POST['contactName'] ) );
	} else {
		if(trim($_POST['contactName']) === '') {
			$nameError = __('Please enter your name.', 'virtue');
			$hasError = true;
		} else {
			$name = sanitize_text_field( trim( $_POST['contactName'] ) );
		}
	}

	if(trim($_POST['email']) === '')  {
		$emailError = __('Please enter your email address.', 'virtue');
		$hasError = true;
	} else if (!is_email(trim($_POST['email']))) {
		$emailError = __('You entered an invalid email address.', 'virtue');
		$hasError = true;
	} else {
		$email = sanitize_text_field( trim($_POST['email']) );
	}

	if(trim($_POST['comments']) === '') {
		$commentError = __('Please enter a message.', 'virtue');
		$hasError = true;
	} else {
		if(function_exists('stripslashes')) {
			$comments = stripslashes( trim( $_POST['comments'] ) );
		} else {
			$comments = wp_kses_post( trim( $_POST['comments'] ) );
		}
	}

	if ( ! isset( $hasError ) ) {
		$name = wp_filter_kses( $name );
		$email = wp_filter_kses( $email );
		$comments = wp_filter_kses( $comments );

		if (isset($virtue_premium['contact_email'])) {
			$emailTo = $virtue_premium['contact_email'];
		} else {
			$emailTo = get_option('admin_email');
		}
		$sitename = get_bloginfo('name');
		$subject = '['.$sitename . '  '. __("Contact", "virtue").'] '. __("From ", "virtue"). $name;
		$body = __('Name', 'virtue').": $name \n\nEmail: $email \n\nComments: $comments";
		$headers = 'Reply-To: ' . $email;

		wp_mail($emailTo, $subject, $body, $headers);
		$emailSent = true;
	}

}    
	/**
    * @hooked virtue_page_title - 20
    */
     do_action('kadence_page_title_container');
    ?>
<?php if ($map == 'yes') { ?>
            <div id="mapheader" class="titleclass">
            	<div class="container">
		            <div id="map_address">
		            </div>
	            </div><!--container-->
            </div><!--titleclass-->
  <?php } ?>

	<div id="content" class="container <?php echo esc_attr( virtue_container_class() ); ?>">
   		<div class="row">
   		<?php if ($form == 'yes') { ?>
	  		<div id="main" class="col-md-6" role="main"> 
	  	<?php } else { ?>
      		<div id="main" class="col-md-12" role="main">
      	<?php } ?>
      	<?php 
                do_action('kadence_page_before_content'); ?>
      			<div class="entry-content" itemprop="mainContentOfPage">
					<?php get_template_part('templates/content', 'page'); ?>
				</div>
    		</div>
    <?php if ($form == 'yes') { ?>
      		<div class="contactformcase col-md-6">
      			<?php $contactformtitle = get_post_meta( $post->ID, '_kad_contact_form_title', true ); 
      			if (!empty($contactformtitle)) { 
      				echo '<h3>'. __($contactformtitle) .'</h3>';
      			} ?>
				<?php if(isset($emailSent) && $emailSent == true) { 
					do_action('kt_contact_email_sent');
					?>
							<div class="thanks">
								<p><?php _e('Thanks, your email was sent successfully.', 'virtue');?></p>
							</div>
				<?php } else { ?>
							<?php if(isset($hasError)) { ?>
								<p class="error"><?php _e('Sorry, an error occured.', 'virtue');?><p>
							<?php } ?>

						<form action="<?php the_permalink(); ?>" id="contactForm" method="post">
							<div class="contactform">
							<p>
								<?php if ( 'false' ==  $name_required ) { ?>
									<label for="contactName"><b><?php _e('Name:', 'virtue');?></b></label>
									<input type="text" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])){ echo esc_attr($_POST['contactName']);}?>" class="full" />
								<?php } else { ?>
									<label for="contactName"><b><?php _e('Name:', 'virtue');?></b><span class="contact-required">*</span></label>
									<input type="text" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])){ echo esc_attr($_POST['contactName']);}?>" class="required requiredField full" />
								<?php } ?>
								<?php if(isset($nameError)) { ?>
									<label class="error"><?php esc_html($nameError);?></label>
								<?php } ?>
							</p>
							<p>
								<label for="email"><b><?php _e('Email:', 'virtue'); ?></b><span class="contact-required">*</span></label>
								<input type="text" name="email" id="email" value="<?php if(isset($_POST['email'])){ echo esc_attr($_POST['email']); }?>" class="required requiredField email full" />
								<?php if(isset($emailError)) { ?>
									<label class="error"><?php echo esc_html($emailError);?></label>
								<?php } ?>
							</p>
							<p><label for="commentsText"><b><?php _e('Message: ', 'virtue'); ?></b><span class="contact-required">*</span></label>
								<textarea name="comments" id="commentsText" rows="10" class="required requiredField"><?php if(isset($_POST['comments'])) { if(function_exists('stripslashes')) { echo esc_textarea(stripslashes($_POST['comments'])); } else { echo esc_textarea($_POST['comments']); } } ?></textarea>
								<?php if(isset($commentError)) { ?><label class="error"><?php echo esc_html($commentError);?></label><?php } ?>
							</p>
							<?php if(isset($form_math) && $form_math == 'yes') {
							   		$one = rand(5, 50);
									$two = rand(1, 9);
									$result = md5($one + $two); ?>
								<p>
									<label for="kad_captcha"><b><?php echo $one.' + '.$two; ?> = </b><span class="contact-required">*</span></label>
									<input type="text" name="kad_captcha" id="kad_captcha" class="required requiredField kad_captcha kad-quarter" />
									<?php if(isset($kad_captchaError)) { ?>
										<label class="error"><?php echo esc_html($kad_captchaError);?></label>
										<?php } ?>
									<input type="hidden" name="hval" id="hval" value="<?php echo esc_attr($result);?>" />
								</p>
							<?php } ?>
							<?php if( isset( $consent ) && 'true' == $consent ) { ?>
								<p>
									<input type="checkbox" name="gdpr-consent" id="gdpr-consent" class="required requiredField kad_gdpr-consent" />
									<?php 
									if ( isset($virtue_premium['contact_consent'] ) && ! empty( $virtue_premium['contact_consent'] ) ) {
										$contact_consent_label = $virtue_premium['contact_consent'];
									} else {
										if ( function_exists( 'the_privacy_policy_link' ) ) {
											$privacy_link = get_the_privacy_policy_link();
										}
										if( ! empty( $privacy_link ) ) {
											$contact_consent_label = sprintf( __('Please check to consent to our %s.', 'virtue'), $privacy_link);
										} else {
											$contact_consent_label = __('Please check to consent to our privacy policy.', 'virtue');
										}
									} ?>
									<label for="gdpr-consent" class="gdpr-consent-label"><?php echo $contact_consent_label; ?><span class="contact-required">*</span></label>
									<?php if(isset($kad_consentError)) { ?><label class="error"><?php echo esc_html($kad_consentError);?></label><?php } ?>
								</p>
							<?php } ?>
							<?php
							$spam_field = apply_filters( 'kadence-contact-spam-field', null );

							if( ! empty( $spam_field ) && is_array( $spam_field ) ) { ?>
								<p>	
									<?php if( isset( $spam_field['label'] ) && !empty( $spam_field['label'] ) ){
										echo wp_kses_post( $spam_field['label'] );
									}
									if( isset( $spam_field['input'] ) && !empty( $spam_field['input'] ) ){
										echo wp_kses_post( $spam_field['input'] );
									}
							
									if( isset( $spamError) ) { ?><label class="error"><?php echo esc_html( $spamError );?></label><?php } ?>
								</p>
							<?php } ?>

							<p>
								<input type="submit" class="kad-btn kad-btn-primary" id="submit" value="<?php _e('Send Email', 'virtue'); ?>" ></input>
							</p>
						</div><!-- /.contactform-->
						<input type="hidden" name="submitted" id="submitted" value="true" />
					</form>
				<?php } ?>
      </div><!--contactform-->
    <?php } ?>