<?php
/**
 * Virtue Premium Theme Options
 *
 * @package     Virtue Theme
 * @since      	4.6.6
 */


/**
 * Theme Options
 */
if ( ! class_exists( 'Virtue_Theme_Options' ) ) {
	/**
	 * Theme Options
	 */
	class Virtue_Theme_Options {
		public static $default_options = null;
		/**
		 * Set default theme option values
		 *
		 * @return default values of the theme.
		 */
		public static function defaults() {
			if ( is_null( self::$default_options ) ) {
				self::$default_options = apply_filters( 'virtue_theme_options_defaults', array(
					'boxed_layout'                           => 'wide',
					'sidebar_side'                           => 'right',
					// Header
					'header_style'                           => 'standard',
					'header_height'                          => '120',
					'side_header_menu_width'                 => '33.333333',
					'sticky_header'                          => 0,
					'shrink_center_header'                   => 0,
					'shrink_center_header_height'            => '120',
					'm_center_sticky_header'                 => 0,
					'm_sticky_header'                        => 0,
					'logo_layout'                            => 'logoleft',
					'primary_sticky'                         => 0,
					'x1_virtue_logo_upload'                  => '',
					'x2_virtue_logo_upload'                  => '',
					'font_logo_style'                        => array(
						'font-family'        => 'Lato',
						'color'              => '',
						'font-style'         => '400',
						'font-size'          => '32px',
						'line-height'        => '40px',
					),
					'logo_below_text'                        => '',
					'font_tagline_style'                     => array(
						'font-family'        => 'Lato',
						'color'              => '#444444',
						'font-style'         => '400',
						'font-size'          => '14px',
						'line-height'        => '20px',
					),
					'logo_padding_top'                       => '25',
					'logo_padding_bottom'                    => '10',
					'logo_padding_left'                      => '0',
					'logo_padding_right'                     => '0',
					'logo_padding_right'                     => '0',
					'menu_margin_top'                        => '40',
					'menu_margin_bottom'                     => '10',
					'virtue_banner_upload'                   => '',
					'virtue_banner_link'                     => '',
					'sitewide_after_header_shortcode_input'  => '',
					// Mobile header
					'mobile_header'                          => 0,
					'mobile_header_tablet_show'              => 0,
					'mobile_header_logo'                     => '',
					'mobile_header_height'                   => '60',
					'mobile_header_sticky'                   => 0,
					'mobile_header_account'                  => 0,
					'mobile_header_cart'                     => 0,
					'mobile_header_search'                   => 0,
					'mobile_header_search_woo'               => 0,
					// Topbar settings
					'topbar'                                 => 1,
					'topbar_off_mobile'                      => 0,
					'topbar_mobile'                          => 0,
					'topbar_icons'                           => 0,
					'topbar_icon_menu'                       => '',
					'show_cartcount'                         => 1,
					'topbar_search'                          => 1,
					'topbar_widget'                          => 0,
					'topbar_layout'                          => 0,
					// Footer settings
					'footer_layout'                          => 'fourc',
					'sitewide_calltoaction'                  => 0,
					'sitewide_action_text'                   => '',
					'sitewide_action_color'                  => '',
					'sitewide_action_text_btn'               => '',
					'sitewide_action_link'                   => '',
					'sitewide_action_btn_color'              => '',
					'sitewide_action_bg_color'               => '',
					'sitewide_action_btn_color_hover'        => '',
					'sitewide_action_bg_color_hover'         => '',
					'sitewide_action_padding'                => '20',
					'sitewide_action_background'             => '',
					'sitewide_footer_shortcode_input'        => '',
					// Home slider
					'choose_slider'                          => 'none',
					'rev_slider'                             => '',
					'kt_slider'                              => '',
					'ksp_slider'                             => '',
					'above_header_slider'                    => 0,
					'above_header_slider_arrow'              => 0,
					'home_cyclone_slider'                    => '',
					'home_slider'                            => '',
					'slider_size'                            => '400',
					'slider_size_width'                      => '1140',
					'slider_autoplay'                        => 1,
					'slider_pausetime'                       => '7000',
					'trans_type'                             => 'fade',
					'slider_transtime'                       => '600',
					'slider_captions'                        => 0,
					'video_embed'                            => '',
					// Home Mobile slider
					'mobile_switch'                          => 0,
					'mobile_tablet_show'                     => 0,
					'choose_mobile_slider'                   => 'none',
					'mobile_rev_slider'                      => '',
					'mobile_ksp'                             => '',
					'mobile_cyclone_slider'                  => '',
					'home_mobile_slider'                     => '',
					'mobile_slider_size'                     => '300',
					'mobile_slider_size_width'               => '480',
					'mobile_slider_autoplay'                 => 1,
					'mobile_slider_pausetime'                => '7000',
					'mobile_trans_type'                      => 'fade',
					'mobile_slider_transtime'                => '600',
					'mobile_slider_captions'                 => 0,
					'mobile_video_embed'                     => '',
					// Home Page
					'home_sidebar_layout'                    => 'full',
					'home_sidebar'                           => 'sidebar-primary',
					'homepage_layout'                        => '',
					// Home Image menu
					'home_image_menu'                        => '',
					'home_image_menu_column'                 => '3',
					'img_menu_height'                        => '110',
					'img_menu_height_setting'                => 'normal',
					// Home Feature Product
					'product_title'                          => '',
					'home_product_feat_column'               => '4',
					'home_product_count'                     => '6',
					'home_product_feat_scroll'               => 'oneitem',
					'home_product_feat_speed'                => '9',
					// Home On sale Products
					'product_sale_title'                     => '',
					'home_product_sale_column'               => '4',
					'home_product_sale_count'                => '6',
					'home_product_sale_scroll'               => 'oneitem',
					'home_product_sale_speed'                => '9',
					// Home Best Selling Products
					'product_best_title'                     => '',
					'home_product_best_column'               => '4',
					'home_product_best_count'                => '6',
					'home_product_best_scroll'               => 'oneitem',
					'home_product_best_speed'                => '9',
					// Home Latest Posts
					'blog_title'                             => '',
					'home_post_count'                        => '2',
					'home_post_column'                       => '2',
					'home_post_type'                         => '',
					'home_post_word_count'                   => '34',
					// Home Portfolio carousel
					'portfolio_title'                        => '',
					'portfolio_type'                         => '',
					'home_portfolio_carousel_column'         => '3',
					'home_portfolio_carousel_height'         => '',
					'home_portfolio_carousel_count'          => '6',
					'home_portfolio_carousel_speed'          => 'oneitem',
					'home_portfolio_order'                   => 'menu_order',
					'portfolio_show_type'                    => 0,
					'portfolio_show_excerpt'                 => 0,
					// Home Custom Carousel
					'custom_carousel_title'                  => '',
					'home_custom_carousel_items'             => '',
					'home_custom_carousel_column'            => '3',
					'home_custom_carousel_scroll'            => 'oneitem',
					'home_custom_speed'                      => '9',
					'home_custom_carousel_imageratio'        => 0,
					// Home Icon Menu
					'icon_menu'                              => '',
					'home_icon_menu_column'                  => '3',
					'icon_bg_color'                          => '',
					'icon_font_color'                        => '',
					// Home portfolio
					'portfolio_full_title'                   => '',
					'portfolio_full_type'                    => '',
					'portfolio_full_show_filter'             => 0,
					'home_port_count'                        => '8',
					'home_portfolio_full_order'              => 'menu_order',
				);
			}
			return self::$default_options;
		}

           array(
            'id'=>'info_portfolio_full_settings',
            'type' => 'info',
            'desc' => __('Home Portfolio Full Settings', 'virtue'),
            ),
           array(
            'id'=>'portfolio_full_title',
            'type' => 'text',
            'title' => __('Home Portfolio Full Title', 'virtue'),
            'subtitle' => __('e.g. = Our Work', 'virtue'),
            ),
           array(
            'id'=>'portfolio_full_type',
            'type' => 'select',
            'data' => 'terms',
            'args' => array('taxonomies'=>'portfolio-type', 'args'=>array()),
            'title' => __('Portfolio Full Category Type', 'virtue'), 
            'subtitle' => __('Choose type for the Portfolio Full', 'virtue'),
            'width' => 'width:60%',
            ),
           array(
            'id'=>'portfolio_full_show_filter',
            'type' => 'switch', 
            'title' => __('Display Portfolio Filter', 'virtue'),
            "default"       => 0,
            ),
           array(
            'id'=>'home_port_count',
            'type' => 'slider', 
            'title' => __('Choose how many Portfolio Items on Homepage', 'virtue'),
            "default"       => "8",
            "min"       => "4",
            "step"      => "1",
            "max"       => "36",
            ),
           array(
            'id'=>'home_portfolio_full_order',
            'type' => 'select',
            'title' => __('Portfolio full Order by', 'virtue'), 
            'subtitle' => __("Choose how the portfolio items should be ordered.", 'virtue'),
            'options' => array('menu_order' => __('Menu Order', 'virtue'),'title' => __('Title', 'virtue'),'date' => __('Date', 'virtue'),'rand' => __('Random', 'virtue')),
            'default' => 'menu_order',
            'width' => 'width:60%',
            ),
           array(
            'id'=>'home_portfolio_full_layout',
            'type' => 'select',
            'title' => __('Portfolio Layout', 'virtue'), 
            'subtitle' => __("Choose the portfolio layout", 'virtue'),
            'options' => array('normal' => __('Normal', 'virtue'),'mosaic' => __('Mosaic (limited options)', 'virtue')),
            'default' => 'normal',
            'width' => 'width:60%',
            ),
           array(
            'id'=>'home_port_columns',
            'type' => 'slider', 
            'title' => __('Choose how many Portfolio columns', 'virtue'),
            "default"       => "4",
            "min"       => "2",
            "step"      => "1",
            "max"       => "5",
            ),
           array(
            'id'=>'home_portfolio_full_height',
            'type' => 'text',
            'title' => __('Set height for portfolio items - Optional', 'virtue'),
            'subtitle' => __('Example 400', 'virtue'),
            ),
           array(
            'id'=>'portfolio_full_masonry',
            'type' => 'switch', 
            'title' => __('Masonry Style', 'virtue'),
            "default"       => 0,
            ),
           array(
            'id'=>'portfolio_full_show_type',
            'type' => 'switch', 
            'title' => __('Display Portfolio Types under Title', 'virtue'),
            "default"       => 0,
            ),
           array(
            'id'=>'portfolio_full_show_excerpt',
            'type' => 'switch', 
            'title' => __('Display Portfolio Excerpt under Title', 'virtue'),
            "default" => 0,
            ),
           array(
            'id'=>'home_portfolio_lightbox',
            'type' => 'switch', 
            'title' => __('Display lightbox link in top right corner?', 'virtue'),
            "default"       => 0,
            ),
           array(
            'id'=>'info_page_content',
            'type' => 'info',
            'desc' => __('Page Content Options (if home page is latest post page)', 'virtue'),
            ),
           array(
            'id'=>'home_post_summery',
            'type' => 'select',
            'title' => __('Latest Post Display', 'virtue'), 
            'subtitle' => __("If Latest Post page is front page. Choose to show full post or post excerpt.", 'virtue'),
            'options' => array('summery' => __('Post Excerpt', 'virtue'),'full' => __('Full', 'virtue')),
            'default' => 'summery',
            'width' => 'width:60%',
            ),
           array(
            'id'=>'home_post_grid',
            'type' => 'switch', 
            'title' => __('Use Post Grid Format', 'virtue'),
            "default" => 0,
            ),
           array(
            'id'=>'home_post_grid_columns',
            'type' => 'select',
            'title' => __('Post Columns', 'virtue'), 
            'options' => array('fourcolumn' => __('Four Column', 'virtue'), 'threecolumn' => __('Three Column', 'virtue'),'twocolumn' => __('Two Column', 'virtue')),
            'default' => 'fourcolumn',
            'width' => 'width:60%',
            'required' => array('home_post_grid','=','1'),
            ),

    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'shop_settings',
    'icon' => 'icon-basket',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Shop Settings', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Shop Archive Page Settings', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'product_shop_layout',
            'type' => 'select',
            'title' => __('Shop Product Column Layout', 'virtue'), 
            'subtitle' => __('Choose how many product columns on the shop and category pages', 'virtue'),
            'options' => array('1' => __('One Column', 'virtue'), '2' => __('Two Column', 'virtue'), '3' => __('Three Column', 'virtue'), '4' => __('Four Column', 'virtue'), '5' => __('Five Column', 'virtue'), '6' => __('Six Column', 'virtue')),
            'width' => 'width:60%',
            'default' => '4',
            ),
      array(
            'id'=>'shop_layout',
            'type' => 'image_select',
            'compiler'=> false,
            'title' => __('Display the sidebar on Shop Page?', 'virtue'), 
            'subtitle' => __('This determines if there is a sidebar on the shop page.', 'virtue'),
            'options' => array(
                    'full' => array('alt' => 'Full Layout', 'img' => OPTIONS_PATH .'img/1col.png'),
                    'sidebar' => array('alt' => 'Sidebar Layout', 'img' => OPTIONS_PATH .'img/2cr.png'),
                ),
            'default' => 'full',
            ),
      array(
            'id'=>'shop_sidebar',
            'type' => 'select',
            'title' => __('Choose a Sidebar for your shop page', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ),  
      array(
            'id'=>'shop_cat_layout',
            'type' => 'image_select',
            'compiler'=> false,
            'title' => __('Display the sidebar on Product Category Pages?', 'virtue'), 
            'subtitle' => __('This determines if there is a sidebar on the product category pages.', 'virtue'),
            'options' => array(
                    'full' => array('alt' => 'Full Layout', 'img' => OPTIONS_PATH .'img/1col.png'),
                    'sidebar' => array('alt' => 'Sidebar Layout', 'img' => OPTIONS_PATH .'img/2cr.png'),
                ),
            'default' => 'full',
            ),
      array(
            'id'=>'shop_cat_sidebar',
            'type' => 'select',
            'title' => __('Choose a Sidebar for your Product Category Pages', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ),            
      array(
            'id'=>'products_per_page',
            'type' => 'slider', 
            'title' => __('How many products per page', 'virtue'),
            "default"       => "12",
            "min"       => "2",
            "step"      => "1",
            "max"       => "80",
            ),
      array(
            'id'=>'product_fitrows',
            'type' => 'switch', 
            'title' => __('Force products into rows', 'virtue'),
            'subtitle' => __('Products fit into rows regardless of size', 'virtue'),
            "default"=> 1,
            ),
      array(
            'id'=>'shop_filter',
            'type' => 'switch', 
            'title' => __('Show Category Filter on Shop Page', 'virtue'),
            'subtitle' => __('This adds an dynamic filter to the shop page. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'cat_filter',
            'type' => 'switch', 
            'title' => __('Show Category Filter on Category Pages', 'virtue'),
            'subtitle' => __('This adds an dynamic filter to Category pages. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'infinitescroll',
            'type' => 'switch', 
            'title' => __('Use Infinite Scroll on Shop pages', 'virtue'),
            'subtitle' => __('Not recomended that you use with filter.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'shop_toggle',
            'type' => 'switch', 
            'title' => __('Show toggle buttons for list/grid on shop page', 'virtue'),
            'subtitle' => __('Adds two icons for toggling between a grid and list layout on shop page.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'shop_excerpt',
            'type' => 'switch', 
            'title' => __('Stop Product Excerpt from loading in the shop grid pages.', 'virtue'),
            'subtitle' => __('Good to turn on if there are conflicts on your shop grid pages.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'shop_rating',
            'type' => 'switch', 
            'title' => __('Show Ratings in Shop and Category Pages', 'virtue'),
            'subtitle' => __('This determines if the rating is displayed in the product archive pages', 'virtue'),
            "default"=> 1,
            ),
      array(
            'id'=>'outofstocktag',
            'type' => 'switch', 
            'title' => __('Show Sold tag if product out of stock.', 'virtue'),
            'subtitle' => __('This determines if a sold tag is displayed on the top right of the product image', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'shop_hide_action',
            'type' => 'switch', 
            'title' => __('Hide Add to Cart Till Mouse Hover', 'virtue'),
            'subtitle' => __('This determines if add to cart button will be hidden till the mouse hovers over the product', 'virtue'),
            "default"=> 1,
            ),
      array(
            'id'=>'product_img_flip',
            'type' => 'switch', 
            'title' => __('Product Image Flip', 'virtue'),
            'subtitle' => __('This allows your product image to flip to the first gallery image when hovered over on shop page. *Note only works in newer browsers.', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'product_quantity_input',
            'type' => 'switch', 
            'title' => __('Quantity Box plus and minus', 'virtue'),
            'subtitle' => __('Turn this off if you would like to use browser added plus and minus for number boxes', 'virtue'),
            "default"=> 1,
            ),
        array(
            'id'=>'info_cat_product_size',
            'type' => 'info',
            'desc' => __('Shop Category Image Size', 'virtue'),
            ),
         array(
            'id'=>'product_cat_layout',
            'type' => 'select',
            'title' => __('Shop Category Column Layout', 'virtue'), 
            'subtitle' => __('Choose how many Category Image columns to show on the shop and category pages', 'virtue'),
            'options' => array('2' => __('Two Column', 'virtue'), '3' => __('Three Column', 'virtue'), '4' => __('Four Column', 'virtue'), '5' => __('Five Column', 'virtue'), '6' => __('Six Column', 'virtue')),
            'width' => 'width:60%',
            'default' => '4',
            ),
        array(
            'id'=>'product_cat_img_ratio',
            'type' => 'select',
            'title' => __('Category Image Aspect Ratio', 'virtue'), 
            'subtitle' => __('If enabled below this sets how you want your category images to be cropped.', 'virtue'),
            'options' => array('square' => __('Square 1:1', 'virtue'), 'portrait' => __('Portrait 3:4', 'virtue'), 'landscape' => __('Landscape 4:3', 'virtue'), 'widelandscape' => __('Wide Landscape 4:2', 'virtue'), 'off' => __('Turn Off', 'virtue')),
            'default' => 'widelandscape',
            'width' => 'width:60%',
            ),
        array(
            'id'=>'info_shop_product_title',
            'type' => 'info',
            'desc' => __('Shop Product Title Settings', 'virtue'),
            ),
        array(
            'id'=>'font_shop_title',
            'type' => 'typography', 
            'title' => __('Shop & archive Product title Font', 'virtue'),
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'text-align' => false,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('.product_item .product_details h5'),
            'subtitle'=> __("Choose Size and Style for product titles on category and archive pages.", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'700',
                'font-size'=>'16px', 
                'line-height'=>'20px', ),
            ),
        array(
            'id'=>'shop_title_uppercase',
            'type' => 'switch', 
            'title' => __('Set Product Title to Uppercase?', 'virtue'),
            'subtitle' => __('This makes your product titles uppercase on Category pages', 'virtue'),
            "default"=> 0,
            ),
        array(
            'id'=>'shop_title_min_height',
            'type' => 'slider', 
            'title' => __('Product title Min Height', 'virtue'),
            'subtitle' => __('If your titles are long increase this to help align your products height.', 'virtue'),
            "default"       => "40",
            "min"       => "20",
            "step"      => "5",
            "max"       => "120",
            ), 
         array(
            'id'=>'info_shop_img_size',
            'type' => 'info',
            'desc' => __('Product Image Sizes', 'virtue'),
            ),
         array(
            'id'=>'shop_img_ratio',
            'type' => 'select',
            'title' => __('Product Image Aspect Ratio', 'virtue'), 
            'subtitle' => __('If enabled below this sets how you want your product images to be cropped.', 'virtue'),
            'options' => array('square' => __('Square 1:1', 'virtue'), 'portrait' => __('Portrait 3:4', 'virtue'), 'landscape' => __('Landscape 4:3', 'virtue'), 'widelandscape' => __('Wide Landscape 4:2', 'virtue')),
            'default' => 'square',
            'width' => 'width:60%',
            ),
      array(
            'id'=>'product_img_resize',
            'type' => 'switch', 
            'title' => __('Enable Product Image Aspect Ratio on Catalog pages', 'virtue'),
            'subtitle' => __('If turned off image dimensions are set by woocommerce settings - recommended width: 270px for Catalog Images', 'virtue'),
            "default"=> 1,
            ),
      array(
            'id'=>'product_simg_resize',
            'type' => 'switch', 
            'title' => __('Enable Product Image Aspect Ratio on product Page', 'virtue'),
            'subtitle' => __('If turned off image dimensions are set by woocommerce settings - recommended width: 468px for Single Product Image', 'virtue'),
            "default"=> 1,
            ),
        array(
            'id'=>'info_shop_slider',
            'type' => 'info',
            'desc' => __('Shop Slider', 'virtue'),
            ),
      array(
            'id'=>'shop_slider',
            'type' => 'switch', 
            'title' => __('Would you like to use have a slider on your shop page?', 'virtue'),
            "default"       => 0,
            ),
        array(
            'id'=>'choose_shop_slider',
            'type' => 'select',
            'title' => __('Choose a Slider for your shop page', 'virtue'), 
            'options' => array('none' => __('None', 'virtue'),'flex' => __('Flex Slider', 'virtue'), 'fullwidth' => 'Fullwidth Slider', 'rev' => __('Revolution Slider', 'virtue'),'ksp' => __('Kadence Slider Pro', 'virtue'), 'cyclone' => __('Shortcode Entry', 'virtue')),
            'default' => 'none',
            'width' => 'width:60%',
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_rev_slider',
            'type' => 'select',
            'title' => __('If Revolution Slider', 'virtue'), 
            'subtitle' => __("Choose your Revolution Slider Here", 'virtue'),
            'options' => $of_revolution,
            'default' => 'select',
            'width' => 'width:60%',
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_ksp',
            'type' => 'select',
            'title' => __('If Kadence Slider Pro', 'virtue'), 
            'subtitle' => __("Choose your Kadence Slider Here", 'virtue'),
            'options' => $of_ksp,
            'default' => 'select',
            'width' => 'width:60%',
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_cyclone_slider',
            'type' => 'text',
            'title' => __('If Shortcode Slider', 'virtue'),
            'subtitle' => __('Paste Shortcode Slider shortcode here', 'virtue'),
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_slider_images',
            'type' => 'kad_slides',
            'title' => __('Slider Images', 'virtue'),
            'subtitle'=> __('Use large images for best results.', 'virtue'),
            'required' => array('shop_slider','=','1'),
        ),  
        array(
            'id'=>'shop_slider_size',
            'type' => 'slider', 
            'title' => __('Slider Max Height', 'virtue'),
            'subtitle' => __('Note: does not work if images are smaller than max.', 'virtue'),
            "default"       => "400",
            "min"       => "100",
            "step"      => "5",
            "max"       => "600",
            'required' => array('shop_slider','=','1'),
            ), 
        array(
            'id'=>'shop_slider_size_width',
            'type' => 'slider', 
            'title' => __('Slider Max Width', 'virtue'),
            'subtitle' => __('Note: does not work if images are smaller than max. If using sidebar set to 770', 'virtue'),
            "default"       => "1140",
            "min"       => "600",
            "step"      => "5",
            "max"       => "1140",
            'required' => array('shop_slider','=','1'),
            ), 
        array(
            'id'=>'shop_slider_autoplay',
            'type' => 'switch', 
            'title' => __('Auto Play?', 'virtue'),
            'subtitle'=> __('This determines if a slider automatically scrolls', 'virtue'),
            "default"       => 1,
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_slider_pausetime',
            'type' => 'slider', 
            'title' => __('Slider Pause Time', 'virtue'),
            'subtitle' => __('How long to pause on each slide, in milliseconds.', 'virtue'),
            "default"   => "7000",
            "min"       => "3000",
            "step"      => "1000",
            "max"       => "12000",
            'required' => array('shop_slider','=','1'),
            ), 
        array(
            'id'=>'shop_trans_type',
            'type' => 'select',
            'title' => __('Transition Type', 'virtue'), 
            'subtitle' => __("Choose a transition type", 'virtue'),
            'options' => array('fade' => __('Fade', 'virtue'),'slide' => __('Slide', 'virtue') ),
            'default' => 'fade',
            'required' => array('shop_slider','=','1'),
            ),
        array(
            'id'=>'shop_slider_transtime',
            'type' => 'slider', 
            'title' => __('Slider Transition Time', 'virtue'),
            'subtitle' => __('How long for slide transitions, in milliseconds.', 'virtue'),
            "default"       => "600",
            "min"       => "200",
            "step"      => "100",
            "max"       => "1200",
            'required' => array('shop_slider','=','1'),
            ), 
        array(
            'id'=>'shop_slider_captions',
            'type' => 'switch', 
            'title' => __('Show Captions?', 'virtue'),
            'subtitle'=> __('Choose to show or hide captions', 'virtue'),
            "default"       => 0,
            'required' => array('shop_slider','=','1'),
            ),
        ),
) );
Redux::setSection( $opt_name, array(
            'id' => 'product_settings',
            'icon' => 'icon-bag2',
            'customizer' => false,
            'icon_class' => 'icon-large',
            'title' => __('Product Settings', 'virtue'),
            'desc' => "<div class='redux-info-field'><h3>".__('Product Page Settings', 'virtue')."</h3></div>",
            'fields' => array(
        array(
            'id'=>'singleproduct_layout',
            'type' => 'image_select',
            'title' => __('Single Product Layout', 'virtue'), 
            'subtitle' => __('This determines if the image and product title layout on single product pages.', 'virtue'),
            'options' => array(
                    'normal' => array('alt' => 'Normal Layout', 'img' => OPTIONS_PATH .'img/pni.png'),
                    'largeimg' => array('alt' => 'Large Image Layout', 'img' => OPTIONS_PATH .'img/pwi.png'),
                ),
            'default' => 'normal',
            ),
         array(
            'id'=>'product_gallery_slider',
            'type' => 'switch', 
            'title' => __('Enable woocommerce slider for product gallery? (must be woocommerce 3.0+)', 'virtue'),
            "default" => 0,
        ),
        array(
            'id'=>'product_gallery_zoom',
            'type' => 'switch', 
            'title' => __('Enable woocommerce hover zoom for product gallery? (must be woocommerce 3.0+)', 'virtue'),
            "default" => 0,
        ), 
        array(
            'id'=>'product_sidebar_default',
            'type' => 'select',
            'title' => __('Product Sidebar Default', 'virtue'), 
            'options' => array('no' => __('No, Do not Show', 'virtue'), 'yes' => __('Yes, Show', 'virtue')),
            'width' => 'width:60%',
            'default' => 'no',
            ),
        array(
            'id'=>'product_sidebar_default_sidebar',
            'type' => 'select',
            'title' => __('Choose a Default Sidebar for your Single Product Pages', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ),  
        array(
            'id'=>'product_radio',
            'type' => 'switch', 
            'title' => __('Display variations as radio buttons instead of select box?', 'virtue'),
            'subtitle'=> __('This will display product varations in a box form.', 'virtue'),
            "default"=> 0,
            ),
        array(
            'id'=>'product_nav',
            'type' => 'switch', 
            'title' => __('Display Product Navigation arrows beside title?', 'virtue'),
            'subtitle'=> __('This will display navigation arrow beside product title to navigate to other products in the same category.', 'virtue'),
            "default"=> 0,
            ),
        array(
            'id'=>'product_tabs',
            'type' => 'switch', 
            'title' => __('Display product tabs?', 'virtue'),
            'subtitle'=> __('This determines if product tabs are displayed', 'virtue'),
            "default"       => 1,
            ),
        array(
            'id'=>'product_tabs_scroll',
            'type' => 'switch', 
            'title' => __('Scroll to Tab?', 'virtue'),
            'subtitle'=> __('This scrolls the page to the product tab when clicked', 'virtue'),
            "default"       => 0,
            ),
        array(
            'id'=>'ptab_description',
            'type' => 'slider', 
            'title' => __('Product Tab Order - Lowest First', 'virtue'),
            'desc'=> __('Description Tab', 'virtue'),
            "default"       => "10",
            "min"       => "5",
            "step"      => "5",
            "max"       => "60",
            ), 
        array(
            'id'=>'ptab_additional',
            'type' => 'slider', 
            'desc'=> __('Additional Information Tab', 'virtue'),
            "default"       => "20",
            "min"       => "5",
            "step"      => "5",
            "max"       => "60",
            ), 
         array(
            'id'=>'ptab_reviews',
            'type' => 'slider', 
            'desc'=> __('Reviews Tab', 'virtue'),
            "default"       => "30",
            "min"       => "5",
            "step"      => "5",
            "max"       => "60",
            ), 
         array(
            'id'=>'ptab_video',
            'type' => 'slider', 
            'desc'=> __('Product Video Tab', 'virtue'),
            "default"       => "40",
            "min"       => "5",
            "step"      => "5",
            "max"       => "60",
            ),
          array(
            'id'=>'custom_tab_01',
            'type' => 'switch', 
            'title' => __('Activate Custom Tab 01', 'virtue'),
            'subtitle'=> __('This adds a custom product tab to your products', 'virtue'),
            "default"       => 0,
            ),
          array(
            'id'=>'custom_tab_02',
            'type' => 'switch', 
            'title' => __('Activate Custom Tab 02', 'virtue'),
            'subtitle'=> __('This adds a custom product tab to your products', 'virtue'),
            "default"       => 0,
            ),
          array(
            'id'=>'custom_tab_03',
            'type' => 'switch', 
            'title' => __('Activate Custom Tab 03', 'virtue'),
            'subtitle'=> __('This adds a custom product tab to your products', 'virtue'),
            "default"       => 0,
            ),
        array(
            'id'=>'related_products',
            'type' => 'switch', 
            'title' => __('Display related products?', 'virtue'),
            'subtitle'=> __('This determines related products are displayed', 'virtue'),
            "default"       => 1,
            ),
        array(
            'id'=>'related_item_column',
            'type' => 'slider', 
            'title' => __('Choose how many columns are in related product carousel', 'virtue'),
            "default"   => "4",
            "min"       => "2",
            "step"      => "1",
            "max"       => "6",
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'portfolio_options',
    'icon' => 'icon-images2',
    'icon_class' => 'icon-large',
    'customizer' => false,
    'title' => __('Portfolio Options', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Portfolio Options', 'virtue')."</h3></div>",
    'fields' => array(
        array(
            'id'=>'portfolio_permalink',
            'type' => 'text',
            'title' => __('Portfolio Permalink Base', 'virtue'),
            'subtitle' => __('Standard: portfolio *NOTE If you change this resave your permalinks', 'virtue'),
            ),
        array(
            'id'=>'portfolio_comments',
            'type' => 'switch', 
            'title' => __('Allow Comments on Portfolio Posts', 'virtue'),
            'subtitle' => __('Turn on to allow Comments on Portfolio posts', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'portfolio_header_single_image_height',
            'type' => 'switch', 
            'title' => __('Turn off height crop for single portfolio image', 'virtue'),
            'subtitle' => __('This makes the default height of your single portfolio image the ratio of the uploaded image', 'virtue'),
            "default"=> 0,
            ),
        array(
            'id'=>'info_portfolio_nav_options',
            'type' => 'info',
            'desc' => __('Portfolio Navigation Options', 'virtue'),
            ),
        array(
            'id'=>'portfolio_link',
            'type' => 'select',
            'data' => 'pages',
            'width' => 'width:60%',
            'title' => __('All Projects Default Portfolio Page', 'virtue'), 
            'subtitle' => __('This sets the link in every portfolio post. You can override in post.', 'virtue'),
            ),
        array(
            'id'=>'portfolio_arrow_nav',
            'type' => 'select',
            'title' => __('Portfolio Arrow Navigation', 'virtue'), 
            'options' => array('all' => __('Navigate through All Posts', 'virtue'), 'cat' => __('Navigate through Category', 'virtue')),
            'width' => 'width:60%',
            'default' => 'all',
            ),
        array(
            'id'=>'info_portfolio_cat_defaults',
            'type' => 'info',
            'desc' => __('Portfolio Archive Pages', 'virtue'),
            ),
        array(
            'id'=>'portfolio_tax_column',
            'type' => 'slider', 
            'title' => __('Choose how many portfolio columns to show on portfolio archive pages.', 'virtue'),
            "default"       => "4",
            "min"       => "2",
            "step"      => "1",
            "max"       => "6",
            ),
         array(
            'id'=>'portfolio_tax_items',
            'type' => 'slider', 
            'title' => __('Choose how many portfolio items show on portfolio archive pages.', 'virtue'),
            "default"       => "12",
            "min"       => "2",
            "step"      => "1",
            "max"       => "48",
            ),
         array(
            'id'=>'portfolio_tax_order',
            'type' => 'select',
            'title' => __('Choose order for portfolio archive pages', 'virtue'), 
            'options' => array('menu_order' => __('Menu Order', 'virtue'), 'date' => __('Date', 'virtue'),'title' => __('Title', 'virtue')),
            'width' => 'width:60%',
            'default' => 'menu_order',
            ),
         array(
            'id'=>'portfolio_tax_height',
            'type' => 'text',
            'title' => __('Set height for portfolio items - Optional', 'virtue'),
            'subtitle' => __('Example 400', 'virtue'),
            ),
           array(
            'id'=>'portfolio_tax_masonry',
            'type' => 'switch', 
            'title' => __('Masonry Style', 'virtue'),
            "default"       => 0,
            ),
           array(
            'id'=>'portfolio_tax_lightbox',
            'type' => 'switch', 
            'title' => __('Display lightbox link in top right corner?', 'virtue'),
            "default"       => 1,
            ),
         array(
            'id'=>'portfolio_type_under_title',
            'type' => 'switch',
            'customizer' => false,
            'title' => __('Show Types under Title', 'virtue'),
            'subtitle' => __('Choose to show or hide portfolio type under title.', 'virtue'),
            "default" => 1,
            ),
         array(
            'id'=>'portfolio_tax_show_excerpt',
            'type' => 'switch', 
            'title' => __('Display Portfolio Excerpt under Title', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'info_portfolio_recent_carousel',
            'type' => 'info',
            'desc' => __('Portfolio Post Bottom Carousel', 'virtue'),
            ),
        array(
            'id'=>'portfolio_recent_car_column',
            'type' => 'slider', 
            'title' => __('Choose how many columns to show on recent portfolio carousel.', 'virtue'),
            "default"       => "4",
            "min"       => "2",
            "step"      => "1",
            "max"       => "6",
            ),
        array(
            'id'=>'portfolio_recent_carousel_speed',
            'type' => 'slider', 
            'title' => __('Choose the carousel speed (in seconds).', 'virtue'),
            "default"       => "9",
            "min"       => "2",
            "step"      => "1",
            "max"       => "12",
            ),
        array(
            'id'=>'portfolio_recent_car_items',
            'type' => 'slider', 
            'title' => __('Choose how many items to show on recent portfolio carousel.', 'virtue'),
            "default"       => "8",
            "min"       => "6",
            "step"      => "1",
            "max"       => "18",
            ),
         array(
            'id'=>'portfolio_recent_carousel_scroll',
            'type' => 'select',
            'title' => __('Portfolio Carousel Scroll', 'virtue'), 
            'subtitle' => __("Choose how the portfolio items scroll.", 'virtue'),
            'options' => array('oneitem' => __('One Item', 'virtue'), 'all' => __('All Visible', 'virtue')),
            'default' => 'oneitem',
            'width' => 'width:60%',
            ),
      ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'blog_options',
    'icon' => 'icon-pencil2',
    'icon_class' => 'icon-large',
    'customizer' => false,
    'title' => __('Blog Options', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Blog Options', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'post_word_count',
            'type' => 'slider', 
            'title' => __('Post Excerpt Length', 'virtue'),
            'subtitle' => __('Determines how many words are in an Excerpt.', 'virtue'),
            "default"   => "40",
            "min"       => "20",
            "step"      => "2",
            "max"       => "80",
            ),
       array(
            'id'=>'custom_excerpt_readmore',
            'type' => 'switch', 
            'title' => __('Add "read more" link to custom excerpts?', 'virtue'),
            'subtitle' => __('Choose to automatically add a "read more" link to custom excerpts', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'close_comments',
            'type' => 'switch', 
            'title' => __('Show Comments Closed Text?', 'virtue'),
            'subtitle' => __('Choose to show or hide comments closed alert below posts.', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'hide_author',
            'type' => 'switch', 
            'title' => __('Show Author Icon with posts?', 'virtue'),
            'subtitle' => __('Choose to show or hide author icon under post title.', 'virtue'),
            "default" => 1,
            ),
      array(
            'id'=>'hide_postedin',
            'type' => 'switch', 
            'title' => __('Show "posted in" categories with posts?', 'virtue'),
            'subtitle' => __('Choose to show or hide posted in categories under post title.', 'virtue'),
            "default" => 1,
            ),
      array(
            'id'=>'hide_commenticon',
            'type' => 'switch', 
            'title' => __('Show Comment Icon with posts?', 'virtue'),
            'subtitle' => __('Choose to show or hide comment icon under post title.', 'virtue'),
            "default" => 1,
            ),
      array(
            'id'=>'hide_postdate',
            'type' => 'switch', 
            'title' => __('Show Date with posts?', 'virtue'),
            'subtitle' => __('Choose to show or hide date with post title.', 'virtue'),
            "default" => 1,
            ),
      array(
            'id'=>'show_postlinks',
            'type' => 'switch', 
            'title' => __('Show Previous and Next posts links?', 'virtue'),
            'subtitle' => __('Choose to show or hide previous and next post links in the footer of a single post.', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'postlinks_in_cat',
            'type' => 'select',
            'title' => __('Blog post navigation setting', 'virtue'), 
            'options' => array('all' => __('Navigate through All Posts', 'virtue'), 'cat' => __('Navigate through Categories', 'virtue')),
            'width' => 'width:60%',
            'default' => 'all',
            ),
      array(
            'id'=>'blog_infinitescroll',
            'type' => 'switch', 
            'title' => __('Use Infinite Scroll on Blog pages', 'virtue'),
            'subtitle' => __('Remove Pagination and creates infinite scroll instead. Note does not work with slider post summaries', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'blog_cat_infinitescroll',
            'type' => 'switch', 
            'title' => __('Use Infinite Scroll on Blog archive pages', 'virtue'),
            'subtitle' => __('Remove Pagination and creates infinite scroll instead. Note does not work with slider post summaries', 'virtue'),
            "default"=> 0,
            ),
      array(
            'id'=>'blog_grid_display_height',
            'type' => 'switch', 
            'title' => __('Display Blog Grid posts at equal height', 'virtue'),
            'subtitle' => __('Turn on if you want the blog grid items to be equal height and display in equal rows regardless of post content.', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'info_blog_defaults',
            'type' => 'info',
            'desc' => __('Blog Post Defaults', 'virtue'),
            ),
       array(
            'id'=>'blogpost_sidebar_default',
            'type' => 'select',
            'title' => __('Blog Post Sidebar Default', 'virtue'), 
            'options' => array('yes' => __('Yes, Show', 'virtue'), 'no' => __('No, Do not Show', 'virtue')),
            'width' => 'width:60%',
            'default' => 'yes',
            ),
       array(
            'id'=>'blogpost_sidebar_id_default',
            'type' => 'select',
            'title' => __('Choose a default sidebar for your Blog Posts', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ), 
        array(
            'id'=>'post_summery_default',
            'type' => 'select',
            'title' => __('Blog Post Summary Default', 'virtue'), 
            'options' => array('text' => __('Text', 'virtue'), 'img_portrait' => __('Portrait Image', 'virtue'), 'img_landscape' => __('Landscape Image', 'virtue'), 'slider_portrait' => __('Portrait Image Slider', 'virtue'), 'slider_landscape' => __('Landscape Image Slider', 'virtue')),
            'width' => 'width:60%',
            'default' => 'text',
            ),
        array(
            'id'=>'post_summery_default_image',
            'type' => 'media', 
            'url'=> true,
            'title' => __('Default post summary feature Image', 'virtue'),
            'subtitle' => __('Replace theme default feature image for posts without a featured image', 'virtue'),
            ),
        array(
            'id'=>'post_head_default',
            'type' => 'select',
            'title' => __('Blog Post Head Content Default', 'virtue'), 
            'options' => array('none' => __('None', 'virtue'), 'flex' => __('Image Slider', 'virtue'), 'carousel' => __('Image Carousel', 'virtue'), 'image' => __('Image', 'virtue'), 'video' => __('Video', 'virtue')),
            'width' => 'width:60%',
            'default' => 'none',
            ),
        array(
            'id'=>'post_header_single_image_height',
            'type' => 'switch', 
            'title' => __('Turn off height crop for single post header image', 'virtue'),
            'subtitle' => __('This makes the default height of your single posts header image the ratio of the uploaded image', 'virtue'),
            "default"=> 0,
            ),
        array(
            'id'=>'post_author_default',
            'type' => 'select',
            'title' => __('Blog Post Author Box Default', 'virtue'), 
            'options' => array('no' => __('No, Do not Show', 'virtue'), 'yes' => __('Yes, Show', 'virtue')),
            'width' => 'width:60%',
            'default' => 'no',
            ),
        array(
            'id'=>'post_carousel_default',
            'type' => 'select',
            'title' => __('Blog Post Bottom Carousel Default', 'virtue'), 
            'options' => array('no' => __('No, Do not Show', 'virtue'), 'recent' => __('Yes - Display Recent Posts', 'virtue'), 'similar' => __('Yes - Display Similar Posts', 'virtue')),
            'width' => 'width:60%',
            'default' => 'no',
            ),
        array(
            'id'=>'blog_similar_random_order',
            'type' => 'switch', 
            'title' => __('Display Similar Posts in random order?', 'virtue'),
            "default"=> 0,
            'required' => array('post_carousel_default','=','similar'),
            ),
        array(
            'id'=>'post_carousel_columns',
            'type' => 'slider', 
            'title' => __('Choose how many items to show on recent/similar post carousel.', 'virtue'),
            "default"       => "3",
            "min"       => "3",
            "step"      => "1",
            "max"       => "6",
            ),
        array(
            'id'=>'info_blog_category',
            'type' => 'info',
            'desc' => __('Blog Category/Archive Defaults', 'virtue'),
            ),
        array(
            'id'=>'category_post_summary',
            'type' => 'select',
            'title' => __('Category Display Type', 'virtue'), 
            'options' => array('summary' => __('Post Excerpt', 'virtue'),'full' => __('Full Post', 'virtue'), 'grid' => __('Grid Post', 'virtue')),
            'width' => 'width:60%',
            'default' => 'summary',
            ),
        array(
            'id'=>'category_post_grid_column',
            'type' => 'select',
            'title' => __('Category Display Type', 'virtue'), 
            'options' => array('2' => __('Two Column', 'virtue'),'3' => __('Three Column', 'virtue'), '4' => __('Four Column', 'virtue')),
            'width' => 'width:60%',
            'default' => '3',
            'required' => array('category_post_summary','=','grid'),
            ),
        array(
            'id'=>'blog_cat_layout',
            'type' => 'image_select',
            'compiler'=> false,
            'title' => __('Display the sidebar on blog archives?', 'virtue'), 
            'subtitle' => __('This determines if there is a sidebar on the blog category pages.', 'virtue'),
            'options' => array(
                    'full' => array('alt' => 'Full Layout', 'img' => OPTIONS_PATH .'img/1col.png'),
                    'sidebar' => array('alt' => 'Sidebar Layout', 'img' => OPTIONS_PATH .'img/2cr.png'),
                ),
            'default' => 'sidebar',
            ),
      array(
            'id'=>'blog_cat_sidebar',
            'type' => 'select',
            'title' => __('Choose a Sidebar for your Category/Archive Pages', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ),    
      ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'basic_styling',
    'icon' => 'icon-brush',
    'icon_class' => 'icon-large',
    'title' => __('Basic Styling', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Basic Styling', 'virtue')."</h3></div>",
    'fields' => array(
        array(
            'id'=>'skin_stylesheet',
            'type' => 'select',
            'title' => __('Theme Skin Stylesheet', 'virtue'), 
            'subtitle' => __("Note* changes made in options panel will override this stylesheet. Example: Colors set in typography.", 'virtue'),
            'options' => $alt_stylesheets,
            'default' => 'default.css',
            'width' => 'width:60%',
            'customizer' => true,
            ),
        array(
            'id'=>'primary_color',
            'type' => 'color',
            'title' => __('Primary Color', 'virtue'), 
            'subtitle' => __('Choose the default Highlight color for your site.', 'virtue'),
            'transparent'=>false,
            'validate' => 'color',
            'customizer' => true,
            ),
        array(
            'id'=>'primary20_color',
            'type' => 'color',
            'title' => __('20% lighter than Primary Color', 'virtue'), 
            'subtitle' => __('This is used for hover effects', 'virtue'),
            'default' => '',
            'transparent'=>false,
            'validate' => 'color',
            'customizer' => true,
            ),
        array(
            'id'=>'gray_font_color',
            'type' => 'color',
            'title' => __('Sitewide Gray Fonts', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'validate' => 'color',
            'customizer' => true,
            ),
        array(
            'id'=>'footerfont_color',
            'type' => 'color',
            'title' => __('Footer Font Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'validate' => 'color',
            'customizer' => true,
            ),
      ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'advanced_styling',
    'icon' => 'icon-paint-format',
    'icon_class' => 'icon-large',
    'title' => __('Advanced Styling', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Main Content Background', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'content_bg_color',
            'type' => 'color',
            'title' => __('Content Background Color', 'virtue'),
            'customizer' => true,
            'default' => '',
            'validate' => 'color',
            ),
      array(
            'id'=>'bg_content_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'content_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'content_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'content_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_topbar_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Topbar Background', 'virtue'),
            ),
      array(
            'id'=>'topbar_bg_color',
            'type' => 'color',
            'title' => __('Topbar Background Color', 'virtue'), 
            'default' => '',
            'validate' => 'color',
            'customizer' => true,
            ),
      array(
            'id'=>'bg_topbar_bg_img',
            'type' => 'media', 
            'url'=> true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'topbar_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'topbar_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'topbar_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_header_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Header Background', 'virtue'),
            ),
      array(
            'id'=>'header_bg_color',
            'type' => 'color',
            'title' => __('Header Background Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'validate' => 'color',
            'customizer' => true,
            ),
      array(
            'id'=>'bg_header_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'header_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'header_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'header_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_menu_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Secondary Menu Background', 'virtue'),
            ),
      array(
            'id'=>'menu_bg_color',
            'type' => 'color',
            'title' => __('Secondary Menu Background Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'validate' => 'color',
            ),
      array(
            'id'=>'bg_menu_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'menu_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'menu_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'menu_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_mobile_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Mobile Menu Background', 'virtue'),
            ),
      array(
            'id'=>'mobile_bg_color',
            'type' => 'color',
            'title' => __('Mobile Menu Background Color', 'virtue'), 
            'default' => '',
            'validate' => 'color',
            'customizer' => true,
            ),
      array(
            'id'=>'bg_mobile_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'mobile_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'mobile_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'mobile_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
       array(
            'id'=>'info_feature_background',
            'type' => 'info',
            'desc' => __('Feature Background', 'virtue'),
            ),
      array(
            'id'=>'feature_bg_color',
            'type' => 'color',
            'title' => __('Background Color', 'virtue'), 
            'default' => '',
            'validate' => 'color',
            ),
      array(
            'id'=>'bg_feature_bg_img',
            'type' => 'media', 
            'url'=> true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'feature_bg_repeat',
            'type' => 'select',
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'feature_bg_placementx',
            'type' => 'select',
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'feature_bg_placementy',
            'type' => 'select',
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_footer_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Footer Background', 'virtue'),
            ),
      array(
            'id'=>'footer_bg_color',
            'type' => 'color',
            'title' => __('Footer Background Color', 'virtue'), 
            'default' => '',
            'validate' => 'color',
            'customizer' => true,
            ),
      array(
            'id'=>'bg_footer_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'footer_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'footer_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'footer_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'info_body_background',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Body Background', 'virtue'),
            ),
      array(
            'id'=>'boxed_bg_color',
            'type' => 'color',
            'title' => __('Body Background Color', 'virtue'), 
            'default' => '',
            'validate' => 'color',
            'customizer' => true,
            ),
      array(
            'id'=>'bg_boxed_bg_img',
            'type' => 'media', 
            'url'=> true,
            'customizer' => true,
            'title' => __('Upload background image or texture', 'virtue'),
            ), 
      array(
            'id'=>'boxed_bg_repeat',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Image repeat options', 'virtue'), 
            'options' => array('no-repeat' => __('no-repeat', 'virtue'), 'repeat' => __('repeat', 'virtue'), 'repeat-x' => __('repeat-x', 'virtue'), 'repeat-y' => __('repeat-y', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'boxed_bg_placementx',
            'type' => 'select',
            'customizer' => true,
            'title' => __('X image placement options', 'virtue'), 
            'options' => array('left' => __('left', 'virtue'), 'center' => __('center', 'virtue'), 'right' => __('right', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'boxed_bg_placementy',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Y image placement options', 'virtue'), 
            'options' => array('top' => __('top', 'virtue'), 'center' => __('center', 'virtue'), 'bottom' => __('bottom', 'virtue')),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'boxed_bg_fixed',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Fixed or Scroll', 'virtue'), 
            'options' => array('fixed' => 'Fixed', 'scroll'=>'Scroll'),
            'width' => 'width:60%',
            ),
      array(
            'id'=>'boxed_bg_size',
            'type' => 'select',
            'customizer' => true,
            'title' => __('Background Size', 'virtue'), 
            'options' => array('auto' => 'Auto', 'contain'=>'Contain', 'cover'=>'Cover'),
            'width' => 'width:60%',
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'typography',
    'icon' => 'icon-text-width',
    'icon_class' => 'icon-large',
    'title' => __('Typography', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Header Font Options', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'font_h1',
            'type' => 'typography', 
            'title' => __('H1 Headings', 'virtue'),
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'customizer' => true,
            'text-align' => false,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('h1'),
            'subtitle'=> __("Choose Size and Style for h1 (This Styles Your Page Titles)", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'38px', 
                'line-height'=>'40px', ),
            ),
    array(
            'id'=>'font_h2',
            'type' => 'typography', 
            'title' => __('H2 Headings', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
              'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'customizer' => true,
            'line-height'=>true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('h2'),
            'subtitle'=> __("Choose Size and Style for h2", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'32px', 
                'line-height'=>'40px', ),
            ),
    array(
            'id'=>'font_h3',
            'type' => 'typography', 
            'title' => __('H3 Headings', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'customizer' => true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('h3'),
            'subtitle'=> __("Choose Size and Style for h3", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'28px', 
                'line-height'=>'40px', ),
            ),
    array(
            'id'=>'font_h4',
            'type' => 'typography', 
            'title' => __('H4 Headings', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'customizer' => true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('h4'),
            'subtitle'=> __("Choose Size and Style for h4", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'24px', 
                'line-height'=>'40px', ),
            ),
    array(
            'id'=>'font_h5',
            'type' => 'typography', 
            'title' => __('H5 Headings', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'customizer' => true,
            'text-align' => false,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('h5'),
            'subtitle'=> __("Choose Size and Style for h5", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'',
                'font-size'=>'18px', 
                'line-height'=>'24px', ),
            ),
    array(
            'id'=>'info_body_font',
            'type' => 'info',
            'desc' => __('Body Font Options', 'virtue'),
            ),
    array(
            'id'=>'font_p',
            'type' => 'typography', 
            'title' => __('Body Font', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'customizer' => true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('body'),
            'subtitle'=> __("Choose Size and Style for paragraphs", 'virtue'),
            'default'=> array(
                'font-family'=>'',
                'color'=>'', 
                'font-style'=>'400',
                'font-size'=>'14px', 
                'line-height'=>'20px', ),
            ),
  ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'menu_settings',
    'icon' => 'icon-menu4',
    'icon_class' => 'icon-large',
    'title' => __('Menu Settings', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Primary Menu Options', 'virtue')."</h3></div>",
    'fields' => array(
        array(
            'id'=>'show_subindicator',
            'customizer' => true,
            'type' => 'switch', 
            'title' => __('Enable sub-indicator in menu?', 'virtue'),
            'subtitle'=> __('Choose to enable arrows showing there is a submenu', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'menu_search',
            'customizer' => true,
            'type' => 'switch', 
            'title' => __('Enable Search in Primary Menu?', 'virtue'),
            'subtitle'=> __('Choose to enable a search button in the header menu', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'menu_search_woo',
            'customizer' => true,
            'type' => 'switch', 
            'title' => __('Make menu search results only products?', 'virtue'),
            'subtitle'=> __('This will change the menu search to a woocommerce search.', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'menu_account',
            'customizer' => true,
            'type' => 'switch', 
            'title' => __('Enable My Account icon in Primary Menu?', 'virtue'),
            'subtitle'=> __('Woocommerce only - Choose to enable a my account icon link in the primary menu', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'menu_cart',
            'customizer' => true,
            'type' => 'switch', 
            'title' => __('Enable Mini Cart in Primary Menu?', 'virtue'),
            'subtitle'=> __('Choose to enable a Cart button in the header menu', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'font_primary_menu',
            'type' => 'typography', 
            'title' => __('Primary Menu Font', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'text-align' => false,
            'customizer' => true,
            'line-height'=>true,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('#nav-main ul.sf-menu a, .nav-main ul.sf-menu a'),
            'subtitle'=> __("Choose Size and Style for primary menu", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'12px', 
                'line-height'=>'18px', ),
            ),
    array(
            'id'=>'primarymenu_hover_color',
            'type' => 'color',
            'title' => __('Hover and Active Font Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'customizer' => true,
            'validate' => 'color',
            ),
    array(
            'id'=>'primarymenu_hover_bg_color',
            'type' => 'color',
            'title' => __('Hover and Active Background Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'customizer' => true,
            'validate' => 'color',
            ),
    array(
            'id'=>'info_menu_secondary_font',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Secondary Menu Options', 'virtue'),
            ),
    array(
            'id'=>'font_secondary_menu',
            'type' => 'typography', 
            'title' => __('Secondary Menu Font', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'text-align' => false,
            'customizer' => true,
            'line-height'=>true,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('#nav-second ul.sf-menu a'),
            'subtitle'=> __("Choose Size and Style for secondary menu", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'18px', 
                'line-height'=>'22px', ),
            ),
    array(
            'id'=>'secondarymenu_hover_color',
            'type' => 'color',
            'title' => __('Secondary Hover and Active Font Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'customizer' => true,
            'validate' => 'color',
            ),
    array(
            'id'=>'secondarymenu_hover_bg_color',
            'type' => 'color',
            'title' => __('Secondary Hover and Active Background Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'customizer' => true,
            'validate' => 'color',
            ),
    array(
            'id'=>'secondary_menu_size',
            'type' => 'select',
            'title' => __('Secondary Menu Item Size', 'virtue'), 
            'subtitle' => __("Choose how many menu items fit in the menu.", 'virtue'),
            'options' => array('25%' => __('Four Items', 'virtue'), '20%' => __('Five Items', 'virtue'), '16.5%' => __('Six Items', 'virtue'), '14.2%' => __('Seven Items', 'virtue'), '12.5%' => __('Eight Items', 'virtue')),
            'default' => '16.5%',
            'customizer' => true,
            'width' => 'width:60%',
            ),
    array(
            'id'=>'info_dropdown_menu_settings',
            'type' => 'info',
            'customizer' => true,
            'desc' => __('Dropdown Menu Style', 'virtue'),
            ),
    array(
            'id'=>'dropdown_font_color',
            'type' => 'color',
            'title' => __('Dropdown Font Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'transparent'=>false,
            'validate' => 'color',
            ),
    array(
            'id'=>'dropdown_background_color',
            'type' => 'color',
            'title' => __('Dropdown Background Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'transparent'=>false,
            'validate' => 'color',
            ),
    array(
            'id'=>'dropdown_border_color',
            'type' => 'color',
            'title' => __('Dropdown Border Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'transparent'=>true,
            'validate' => 'color',
            ),
    array(
            'id'=>'dropdown_menu_font_size',
            'type' => 'typography', 
            'title' => __('Dropdown Menu Font size', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>false, 
            'google'=>false, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>false, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'font-weight'=>false,
            'text-transform' => false,
            'line-height'=>true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            'all_styles' => false,
            'color'=>false,
            'customizer' => true,
            'preview'=>false, // Disable the previewer
            'output' => array('#nav-main ul.sf-menu ul li a, #nav-second ul.sf-menu ul li a, .nav-main ul.sf-menu ul li a'),
            'subtitle'=> __("Choose Size for the Dropdown menus", 'virtue'),
            'default'=> array(
                'font-size'=>'12px',
                'line-height'=>'inherit',
                 ),
            ),
    array(
            'id'=>'dropdown_font_hover_color',
            'type' => 'color',
            'title' => __('Dropdown Font Hover Color', 'virtue'), 
            'default' => '',
            'customizer' => true,
            'transparent'=>false,
            'output' => array('#nav-main ul.sf-menu ul li a:hover, #nav-second ul.sf-menu ul li a:hover, .nav-main ul.sf-menu ul li a:hover'),
            'validate' => 'color',
            ),
    array(
            'id'=>'info_menu_mobile_font',
            'type' => 'info',
            'desc' => __('Mobile Menu Options', 'virtue'),
            ),
    array(
            'id'=>'show_mobile_btn',
            'type' => 'switch', 
            'title' => __('Mobile Menu only show button', 'virtue'),
            "default"       => 0,
            ),
    array(
            'id'=>'mobile_submenu_collapse',
            'type' => 'switch', 
            'title' => __('Submenu items collapse until opened', 'virtue'),
            "default" => 0,
            ),
    array(
            'id'=>'font_mobile_menu',
            'type' => 'typography', 
            'title' => __('Mobile Menu Font', 'virtue'),
            //'compiler'=>true, // Use if you want to hook in your own CSS compiler
            'font-family'=>true, 
            'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
            'font-backup'=>false, // Select a backup non-google font in addition to a google font
            'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
            'subsets'=>true, // Only appears if google is true and subsets not set to false
            'font-size'=>true,
            'line-height'=>true,
            'text-align' => false,
            //'word-spacing'=>false, // Defaults to false
            //'all_styles' => true,
            'color'=>true,
            'preview'=>true, // Disable the previewer
            'output' => array('.kad-nav-inner .kad-mnav, .kad-mobile-nav .kad-nav-inner li a', '.nav-trigger-case'),
            'subtitle'=> __("Choose Size and Style for Mobile Menu", 'virtue'),
            'default'=> array(
                'font-family'=>'Lato',
                'color'=>"", 
                'font-style'=>'400',
                'font-size'=>'16px', 
                'line-height'=>'20px', ),
            ),
    array(
            'id'=>'mobilemenu_hover_color',
            'type' => 'color',
            'title' => __('Mobile Hover and Active Font Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'validate' => 'color',
            ),
    array(
            'id'=>'mobilemenu_hover_bg_color',
            'type' => 'color',
            'title' => __('Mobile Hover and Active Background Color', 'virtue'), 
            'default' => '',
            'transparent'=>false,
            'validate' => 'color',
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'language_settings',
    'icon' => 'icon-bubbles',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Language Settings', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Quick Language Settings', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'mobile_menu_text',
            'type' => 'text',
            'title' => __('Mobile Menu Title', 'virtue'),
            'subtitle' => __('Standard: Menu', 'virtue'),
            ),
      array(
            'id'=>'search_placeholder_text',
            'type' => 'text',
            'title' => __('Search Placeholder Text', 'virtue'),
            'subtitle' => __('Standard: Search"', 'virtue'),
            ),
      array(
            'id'=>'cart_placeholder_text',
            'type' => 'text',
            'title' => __('Topbar Cart Total Text', 'virtue'),
            'subtitle' => __('Standard: Your Cart', 'virtue'),
            ),
      array(
            'id'=>'sold_placeholder_text',
            'type' => 'text',
            'title' => __('Product Sold Text', 'virtue'),
            'subtitle' => __('Standard: Sold', 'virtue'),
            ),
      array(
            'id'=>'sale_placeholder_text',
            'type' => 'text',
            'title' => __('Product Sale Text', 'virtue'),
            'subtitle' => __('Standard: Sale', 'virtue'),
            ),
      array(
            'id'=>'wc_clear_placeholder_text',
            'type' => 'text',
            'title' => __('Clear Selection Text', 'virtue'),
            'subtitle' => __('Standard: Clear selection', 'virtue'),
            ),
      array(
            'id'=>'notavailable_placeholder_text',
            'type' => 'text',
            'title' => __('Not Available Text (radio button tooltip)', 'virtue'),
            'subtitle' => __('Standard: Not Available', 'virtue'),
            ),
      array(
            'id'=>'post_readmore_text',
            'type' => 'text',
            'title' => __('Post READ MORE text', 'virtue'),
            'subtitle' => __('Standard: Read More', 'virtue'),
            ),
      array(
            'id'=>'post_by_text',
            'type' => 'text',
            'title' => __('Post Author BY text', 'virtue'),
            'subtitle' => __('Standard: by', 'virtue'),
            ),
      array(
            'id'=>'post_incat_text',
            'type' => 'text',
            'title' => __('Post Category POSTED IN text', 'virtue'),
            'subtitle' => __('Standard: posted in:', 'virtue'),
            ),
      array(
            'id'=>'filter_all_text',
            'type' => 'text',
            'title' => __('Dynamic filter All text', 'virtue'),
            'subtitle' => __('Standard: All', 'virtue'),
            ),
        array(
            'id'=>'shop_filter_text',
            'type' => 'text',
            'title' => __('Mobile dynamic Filter Products text', 'virtue'),
            'subtitle' => __('Standard: Filter Products', 'virtue'),
            ),
        array(
            'id'=>'portfolio_filter_text',
            'type' => 'text',
            'title' => __('Mobile dynamic Filter Projects text', 'virtue'),
            'subtitle' => __('Standard: Filter Projects', 'virtue'),
            ),
         array(
            'id'=>'wc_clear_placeholder_text',
            'type' => 'text',
            'title' => __('Product Page: Clear Selection Text', 'virtue'),
            'subtitle' => __('Standard: Clear selection', 'virtue'),
            ),
      array(
            'id'=>'description_tab_text',
            'type' => 'text',
            'title' => __('Product Page: Description tab text', 'virtue'),
            'subtitle' => __('Standard: Description', 'virtue'),
            ),
      array(
            'id'=>'description_header_text',
            'type' => 'text',
            'title' => __('Product Page: Description header text', 'virtue'),
            'subtitle' => __('Standard: Product Description', 'virtue'),
            ),
      array(
            'id'=>'additional_information_tab_text',
            'type' => 'text',
            'title' => __('Product Page: Additional Information tab text', 'virtue'),
            'subtitle' => __('Standard: Additional Information', 'virtue'),
            ),
      array(
            'id'=>'additional_information_header_text',
            'type' => 'text',
            'title' => __('Product Page: Additional Information Header text', 'virtue'),
            'subtitle' => __('Standard: Additional Information', 'virtue'),
            ),
      array(
            'id'=>'video_tab_text',
            'type' => 'text',
            'title' => __('Product Page: Product Video tab text', 'virtue'),
            'subtitle' => __('Standard: Product Video', 'virtue'),
            ),
      array(
            'id'=>'video_title_text',
            'type' => 'text',
            'title' => __('Product Page: Product Video Header text', 'virtue'),
            'subtitle' => __('Standard: Product Video', 'virtue'),
            ),
      array(
            'id'=>'reviews_tab_text',
            'type' => 'text',
            'title' => __('Product Page: Reviews tab text', 'virtue'),
            'subtitle' => __('Standard: Reviews', 'virtue'),
            ),
      array(
            'id'=>'related_products_text',
            'type' => 'text',
            'title' => __('Product Page: Related Products text', 'virtue'),
            'subtitle' => __('Standard: Related Products', 'virtue'),
            ),
      array(
            'id'=>'wc_upsell_products_text',
            'type' => 'text',
            'title' => __('Product Page: You may also like... text', 'virtue'),
            'subtitle' => __('Standard: You may also like&hellip;', 'virtue'),
            ),
      array(
            'id'=>'lightbox_loading_text',
            'type' => 'text',
            'title' => __('LightBox: Loading text', 'virtue'),
            'subtitle' => __('Standard: Loading...', 'virtue'),
            ),
      array(
            'id'=>'lightbox_of_text',
            'type' => 'text',
            'title' => __('LightBox: of text', 'virtue'),
            'subtitle' => __('Standard: of', 'virtue'),
            ),
      array(
            'id'=>'lightbox_error_text',
            'type' => 'text',
            'title' => __('LightBox: Error text', 'virtue'),
            'subtitle' => __('Standard: The Image could not be loaded.', 'virtue'),
            ),
      array(
			'id'=>'contact_consent',
			'type' => 'text',
			'title' => __('Contact Form Consent Label', 'virtue'),
			'subtitle' => __('Standard: Please check to consent to our privacy policy.', 'virtue'),
		),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'breadcrumbs',
    'icon' => 'icon-link4',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Breadcrumbs', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Sitewide Breadcrumbs', 'virtue')."</h3></div>",
    'fields' => array(
      array(
            'id'=>'show_breadcrumbs_shop',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs in Woocommerce Pages and Categories?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your Woocommerce pages and Categories', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'show_breadcrumbs_product',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs on Products?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your Woocommerce products', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'show_breadcrumbs_post',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs on Blog Post?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your single blog post', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'show_breadcrumbs_portfolio',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs on Portfolio Post?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your single portfolio posts', 'virtue'),
            "default" => 0,
            ),
       array(
            'id'=>'show_breadcrumbs_staff',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs on Staff Post?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your single staff posts', 'virtue'),
            "default" => 0,
            ),
       array(
            'id'=>'staff_link',
            'type' => 'select',
            'data' => 'pages',
            'width' => 'width:60%',
            'title' => __('All Staff Post Page', 'virtue'), 
            'subtitle' => __('This sets the link for your main staff page, for breadcrumbs.', 'virtue'),
            'required' => array('show_breadcrumbs_staff','=','1'),
            ),
      array(
            'id'=>'show_breadcrumbs_page',
            'type' => 'switch', 
            'title' => __('Show Breadcrumbs on Pages & Categories?', 'virtue'),
            'subtitle' => __('Choose to show or hide breadcrumbs on your pages and categories', 'virtue'),
            "default" => 0,
            ),
      array(
            'id'=>'home_breadcrumb_text',
            'type' => 'text',
            'title' => __('Home title for breadcrumbs', 'virtue'),
            'subtitle' => __('Standard: Home', 'virtue'),
            ),
      array(
            'id'=>'blog_link',
            'type' => 'select',
            'data' => 'pages',
            'width' => 'width:60%',
            'title' => __('All Blog Post Page', 'virtue'), 
            'subtitle' => __('This sets the link for your main blog page, for breadcrumbs. Use only if your blog page is not your home page.', 'virtue'),
            ),
      array(
            'id'=>'shop_breadcrumbs',
            'type' => 'switch', 
            'title' => __('Show Shop page in breadcrumbs?', 'virtue'),
            'subtitle' => __('Choose to show or hide the shop page in breadcrumbs on your site', 'virtue'),
            "default" => 0,
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'misc_settings',
    'icon' => 'icon-wrench',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Misc Settings', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Misc Settings', 'virtue')."</h3></div>",
    'fields' => array(
        array(
            'id'=>'page_comments',
            'type' => 'switch', 
            'title' => __('Allow Comments on Pages', 'virtue'),
            'subtitle' => __('Turn on to allow comments on Pages', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'page_title_show',
            'type' => 'switch', 
            'title' => __('Show page title by default', 'virtue'),
            'subtitle' => __('Turn off to hide page titles by default', 'virtue'),
            "default" => 1,
            ),
        array(
            'id'=>'testimonial_single_nav',
            'type' => 'switch', 
            'title' => __('Arrow navigation for single testimonial post?', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'testimonial_page',
            'type' => 'select',
            'data' => 'pages',
            'width' => 'width:60%',
            'title' => __('Grid Link for testimonial navigation', 'virtue'),
            'required' => array('testimonial_single_nav','=','1'),
            ),
        array(
            'id'=>'hide_image_border',
            'type' => 'switch', 
            'title' => __('Hide Image Border', 'virtue'),
            'subtitle' => __('Choose to show or hide image border', 'virtue'),
            "default" => 1,
            ),
        array(
            'id'=>'remove_image_padding',
            'type' => 'switch', 
            'title' => __('Remove default image padding', 'virtue'),
            'subtitle' => __('Turn on to remove default image padding.', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'select2_select',
            'type' => 'switch', 
            'title' => __('Select2 Select', 'virtue'),
            'subtitle' => __('Turn on or off the select2 select', 'virtue'),
            "default" => 1,
            ),  
        array(
            'id'=>'minimal_icons',
            'type' => 'switch', 
            'title' => __('Enable Minimal Icons', 'virtue'),
            'subtitle' => __('Turning this on will make the theme only load a few icons on the front end.', 'virtue'),
            "default" => 0,
            ),   
        array(
            'id'=>'virtue_custom_favicon',
            'type' => 'media', 
            'preview'=> true,
            'title' => __('Custom Favicon', 'virtue'),
            'subtitle' => __('Upload a 16px x 16px png/gif/ico image that will represent your website favicon.', 'virtue'),
            ),
        array(
            'id'=>'contact_email',
            'type' => 'text',
            'title' => __('Contact Form Email', 'virtue'),
            'subtitle' => __('Sets the email for the contact page email form.', 'virtue'),
            'validate' => 'email',
            'msg' => __('Enter a valid email address.', 'virtue'),
            'default' => 'test@test.com'
            ),  
        array(
            'id'=>'footer_text',
            'type' => 'textarea',
            'title' => __('Footer Copyright Text', 'virtue'), 
            'subtitle' => __('Write your own copyright text here. You can use the following shortcodes in your footer text: [copyright] [site-name] [the-year]', 'virtue'),
            'default' => '[copyright] [the-year] [site-name] [theme-credit]',
            ),
        array(
            'id'=>'info_search_sidebars',
            'type' => 'info',
            'desc' => __('Search Results', 'virtue'),
            ),
        array(
            'id'=>'search_sidebar',
            'type' => 'select',
            'title' => __('Search Results - choose Sidebar', 'virtue'), 
            'data' => 'sidebars',
            'default' => 'sidebar-primary',
            'width' => 'width:60%',
            ),
        array(
            'id'=>'search_layout',
            'type' => 'select',
            'title' => __('Search Results Layout', 'virtue'), 
            'options' => array('grid' => __('Grid', 'virtue'),'singlecolumn' => __('Single Column', 'virtue'), 'simple_grid' => __('Simple Grid', 'virtue')),
            'width' => 'width:60%',
            'default' => 'grid',
            ),
        array(
            'id'=>'info_sidebars',
            'type' => 'info',
            'desc' => __('Create Sidebars', 'virtue'),
            ),
        array(
            'id'=>'cust_sidebars',
            'type' => 'multi_text',
            'title' => __('Create Custom Sidebars', 'virtue'),
            'subtitle' => __('Type new sidebar name into textbox', 'virtue'),
            'default' =>__('Extra Sidebar', 'virtue'),
            ),
        array(
            'id'=>'info_pagewidth',
            'type' => 'info',
            'desc' => __('Limit Max Page width', 'virtue'),
            ),
        array(
            'id'=>'page_max_width',
            'type' => 'switch', 
            'title' => __('Limit Max Page to 940px', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'info_smoothscrolling',
            'type' => 'info',
            'desc' => __('Smooth Scrolling', 'virtue'),
            ),
        array(
            'id'=>'smooth_scrolling',
            'type' => 'select',
            'title' => __('Smooth Scrolling', 'virtue'), 
            'options' => array('0' => __('Leave Off', 'virtue'), '1' => __('Use - with scroll bar replacement', 'virtue'), '2' => __('Use - no replacement of scroll bar (chrome browser only)', 'virtue')),
            'width' => 'width:60%',
            'default' => '0',
            ),
        array(
            'id'=>'smooth_scrolling_hide',
            'type' => 'switch', 
            'title' => __('Enable Auto Hide', 'virtue'),
            'subtitle' => __('This hides the scroll bar when not scrolling.', 'virtue'),
            "default" => 0,
            ), 
         array(
            'id'=>'smooth_scrolling_background',
            'type' => 'switch', 
            'title' => __('Hide Scroll background', 'virtue'),
            'subtitle' => __('This hides the scroll bar background.', 'virtue'),
            "default" => 0,
            ), 
        array(
            'id'=>'info_wpgallerys',
            'type' => 'info',
            'desc' => __('Wordpress Galleries', 'virtue'),
            ),
        array(
            'id'=>'virtue_gallery',
            'type' => 'switch', 
            'title' => __('Enable Virtue Galleries to override Wordpress', 'virtue'),
            'subtitle' => __('Disable this if using a plugin to customize galleries, for example jetpack tiled gallery.', 'virtue'),
            "default" => 1,
            ),
        array(
            'id'=>'virtue_gallery_masonry',
            'type' => 'switch', 
            'title' => __('Use Masonry Feature on Virtue Galleries', 'virtue'),
            'subtitle' => __('This allows for dynamic gallery grids with images of different height', 'virtue'),
            "default" => 1,
            ),
        array(
            'id'=>'gallery_captions',
            'type' => 'switch', 
            'title' => __('Show captions on Virtue Galleries', 'virtue'),
            'subtitle' => __('This sets the default caption setting to true.', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'info_animation_in',
            'type' => 'info',
            'desc' => __('Site Scroll Animation in', 'virtue'),
            ),
        array(
            'id'=>'virtue_animate_in',
            'type' => 'switch', 
            'title' => __('Enable Animation In', 'virtue'),
            'subtitle' => __('Disable this if you want to remove all the appear animation', 'virtue'),
            "default" => 1,
            ),
        array(
            'id'=>'info_lightbox',
            'type' => 'info',
            'desc' => __('Theme Lightbox', 'virtue'),
            ),
        array(
            'id'=>'kadence_lightbox',
            'type' => 'switch',
            'on' => __('Lightbox Off', 'virtue'),
            'off' => __('Lightbox On', 'virtue'),
            'title' => __('Turn Off Theme Lightbox?', 'virtue'),
            "default" => 0,
            ),
        array(
            'id'=>'info_gfonts',
            'type' => 'info',
            'desc' => __('Google Fonts', 'virtue'),
            ),
        array(
                'id'=>'load_google_fonts_locally',
                'type' => 'switch', 
                'title' => __('Load Google Fonts Locally', 'virtue'),
                'subtitle' => __('This will download font files to your server instead of using google servers.', 'virtue'),
                "default" => 0,
            ),
        array(
            'id'=>'info_gmaps',
            'type' => 'info',
            'desc' => __('Theme Google Maps', 'virtue'),
            ),
        array(
            'id'=>'google_map_api',
            'type' => 'text',
            'title' => __('Google Map API', 'virtue'),
            'subtitle' => __('For best performance add your own API for google maps.', 'virtue'),
            'description' =>'<a target="_blank" href="https://developers.google.com/maps/documentation/javascript/get-api-key">Get an API code Here</a>',
            'default' => ''
            ),  
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'advanced_settings',
    'icon' => 'icon-tools',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Advanced Settings', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('SEO General Options', 'virtue')."</h3></div>",
    'fields' => array(
        array(
            'id'=>'google_analytics',
            'type' => 'text',
            'title' => __('Google Analytics Tracking ID', 'virtue'),
            'subtitle' => __('Paste your Google Analytics Tracking ID Here. (example: UA-########-#)', 'virtue'),
            ),
        array(
			'id'=>'google_analytics_anony',
			'type' => 'switch', 
			'title' => __('Enable IP Anonymization in Google Analytics', 'virtue'),
			'subtitle' => __('Anonymizes the last part of visitors IP address.', 'virtue'),
			"default" => 0,
			), 
        array(
            'id'=>'seo_switch',
            'type' => 'switch', 
            'title' => __('Turn on Virtue SEO?', 'virtue'),
            'subtitle' => __('Choose whether or not you would like to use Virtue Theme SEO options. We only recommend this for very basic sites as it does not provide advanced SEO support. For full SEO options we suggest using a plugin.', 'virtue'),
            "default" => 0,
            ), 
        array(
            'id'=>'seo_sitetitle',
            'type' => 'text',
            'title' => __('Site Title', 'virtue'),
            'subtitle' => __('Optimal Format: Brand Name | Primary Keyword and Secondary Keyword', 'virtue'),
            'required' => array('seo_switch','=','1'),
            ),
            array(
            'id'=>'seo_sitedescription',
            'type' => 'textarea',
            'title' => __('Site Description', 'virtue'), 
            'subtitle' => __('Optimal Length: Roughly 155 Characters', 'virtue'),
            'default' => '',
            'required' => array('seo_switch','=','1'),
            ),
            array(
            'id'=>'info_CSS',
            'type' => 'info',
            'desc' => __('Custom CSS Box', 'virtue'),
            ),
             array(
            'id'=>'custom_css',
            'type' => 'textarea',
            'title' => __('Custom CSS', 'virtue'), 
            'subtitle' => __('Quickly add some CSS to your theme by adding it to this block.', 'virtue'),
            //'validate' => 'css',
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'id' => 'header_footer_scripts',
    'icon' => 'icon-file',
    'customizer' => false,
    'icon_class' => 'icon-large',
    'title' => __('Header and Footer Scripts', 'virtue'),
    'desc' => "<div class='redux-info-field'><h3>".__('Simple output for header and footer scripts', 'virtue')."</h3></div>",
    'fields' => array(
            array(
            'id'=>'info_header_script',
            'type' => 'info',
            'desc' => __('Header Output', 'virtue'),
            ),
             array(
            'id'=>'kt_header_script',
            'type' => 'textarea',
            'title' => __('Outputs between &lt;head&gt; and &lt;/head&gt;', 'virtue'), 
            'subtitle' => __('Quickly add a script to your header.', 'virtue'),
            ),
             array(
            'id'=>'info_kt_after_body_open_script',
            'type' => 'info',
            'desc' => __('After the opening &lt;body&gt; tag', 'virtue'),
            ),
             array(
            'id'=>'kt_after_body_open_script',
            'type' => 'textarea',
            'title' => __('Outputs immediately after the opening &lt;body&gt; tag', 'virtue'), 
            'subtitle' => __('Quickly add a script for google tag manager.', 'virtue'),
            ),
             array(
            'id'=>'info_footer_script',
            'type' => 'info',
            'desc' => __('Footer Output', 'virtue'),
            ),
              array(
            'id'=>'kt_footer_script',
            'type' => 'textarea',
            'title' => __('Outputs right before &lt;/body&gt;', 'virtue'), 
            'subtitle' => __('Quickly add a script to your footer.', 'virtue'),
            ),
    ),
) );
Redux::setSection( $opt_name, array(
    'icon' => 'icon-cog',
    'icon_class' => 'icon-large',
    'title' => __('Theme Extensions', 'virtue'),
    'id' => 'theme_extensions',
    'customizer' => false,
    'desc' => "<div class='redux-info-field'><h3>".__('Theme Extensions', 'virtue')."</h3></div>
    <p>".__('Disable Built in Theme Extensions. Please Note, this does not change how the front end loads. If these items where already not used then they were not loaded it the front end. These options only clean up the admin area.', 'virtue')."</p>",
    'fields' => array(
            array(
                'id'=>'kadence_woo_extension',
                'type' => 'switch', 
                'title' => __('Woocommerce Shop', 'virtue'),
                'subtitle' => __('Turn Off/On all Woocommerce references and code', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kadence_portfolio_extension',
                'type' => 'switch', 
                'title' => __('Portfolio Posts', 'virtue'),
                'subtitle' => __('Turn Off/On all Portfolio references and code', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kadence_staff_extension',
                'type' => 'switch', 
                'title' => __('Staff Posts', 'virtue'),
                'subtitle' => __('Turn Off/On all Staff references and code', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kadence_testimonial_extension',
                'type' => 'switch', 
                'title' => __('Testimonial Posts', 'virtue'),
                'subtitle' => __('Turn Off/On all Testimonial references and code', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kadence_header_footer_extension',
                'type' => 'switch', 
                'title' => __('Header and Footer Script output', 'virtue'),
                'subtitle' => __('Turn Off/On Header and Footer Script output boxes.', 'virtue'),
                "default" => 0,
            ),
            array(
                'id'=>'enable_custom_404',
                'type' => 'switch', 
                'title' => __('Custom 404 Page', 'virtue'),
                'subtitle' => __('Turn Off/On option for custom 404 page.', 'virtue'),
                "default" => 0,
            ),
            array(
                'id'=>'custom_404_page',
                'type' => 'select',
                'data' => 'pages',
                'width' => 'width:60%',
                'title' => __('Choose a 404 page', 'virtue'), 
                'subtitle' => __('Select the page to be used instead of the standard 404 page.', 'virtue'),
                'required' => array('enable_custom_404','=','1'),
            ),
            array(
                'id'=>'kt_revslider_notice',
                'type' => 'switch', 
                'title' => __('Enable Install and Updates for Slider Revolution', 'virtue'),
                'subtitle' => __('Turn Off/On Revolution slider install/update notices from theme.', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'hide_rev_activation_notice',
                'type' => 'switch', 
                'title' => __('Hide Slider Revolution Activation Notice', 'virtue'),
                'subtitle' => __('Turn Off the Revolution notice to activate slider from plugin authors', 'virtue'),
                'on' => __('hide', 'virtue'),
                'off' => __('show', 'virtue'),
                "default" => 1,
                'required' => array('kt_revslider_notice','=','1'),
            ),
            array(
                'id'=>'kt_cycloneslider_notice',
                'type' => 'switch', 
                'title' => __('Enable Install and Updates for Cyclone Slider', 'virtue'),
                'subtitle' => __('Turn Off/On Cyclone slider install/update notices from theme.', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kt_kadenceslider_notice',
                'type' => 'switch', 
                'title' => __('Enable Install and Updates for Kadence Slider', 'virtue'),
                'subtitle' => __('Turn Off/On Kadence slider install/update notices from theme.', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kt_pagebuilder_notice',
                'type' => 'switch', 
                'title' => __('Enable Notice for Pagebuilder', 'virtue'),
                'subtitle' => __('Turn Off/On notices to install pagebuilder.', 'virtue'),
                "default" => 1,
            ),
            array(
                'id'=>'kt_tinymce_notice',
                'type' => 'switch', 
                'title' => __('Enable Notice for Black Studio TinyMCE Widget', 'virtue'),
                'subtitle' => __('Turn Off/On notices to install TinyMCE Widget.', 'virtue'),
                "default" => 1,
            ),
    ),
) );
Redux::setSection( $opt_name, array(
                    'id' => 'import_export',
                    'title'  => __( 'Import / Export', 'virtue' ),
                    'desc'   => __( 'Import and Export your Theme Options from text or URL.', 'virtue' ),
                    'icon'   => 'icon-large icon-storage',
                    'fields' => array(
                        array(
                            'id'         => 'opt-import-export',
                            'type'       => 'import_export',
                            'title'      => '',
                            'subtitle'   => '',
                            'full_width' => true,
                        ),
                    ),
                ) );


function kadence_override_redux_icons_css() {
  wp_dequeue_style( 'redux-admin-css' );
  wp_register_style('kt-redux-custom-css', get_template_directory_uri() . '/themeoptions/options/css/style.css', false, 335);    
  wp_enqueue_style('kt-redux-custom-css');
  wp_dequeue_style( 'select2-css');
    wp_dequeue_style( 'redux-elusive-icon' );
    wp_dequeue_style( 'redux-elusive-icon-ie7' );
}
add_action('redux/page/virtue_premium/enqueue', 'kadence_override_redux_icons_css');

function kadence_remove_demo() {

        // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
        if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
            remove_filter( 'plugin_row_meta', array(
                ReduxFrameworkPlugin::instance(),
                'plugin_metalinks'
            ), null, 2 );

            // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
            remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
        }
    }

